<?php
/**
 * SantaPress Admin View: Layout
 *
 * @link       https://santapress.halloecho.de
 * @since      1.0.0
 *
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}
?>

<div class="wrap">
	
	<h1><?php esc_html_e('Layout Settings', 'santapress'); ?></h1>

	<?php
	$args = array(
			'posts_per_page'   => -1,
			'orderby'          => 'menu_order',
			'order'            => 'ASC',
			'post_type'        => 'door',
			'post_status'      => 'publish, future',
			'suppress_filters' => true
		);
	$doors = get_posts( $args );
	if($doors):
	?>

    <p><?php esc_html_e('Here you can change the template for your calender. Please note that choosing a new template will override all
    existing door images.', 'santapress'); ?><br />
	<?php esc_html_e('Changing the template will not delete any content or other settings (opening type, tracking etc.) you might have already made on each door.', 'santapress'); ?></p>

	<form method="post" action="options.php">
        <?php
            settings_fields( 'santapress_layout_settings' );
            do_settings_sections( 'santapress_layout_settings' );
            submit_button();
            settings_errors();
        ?>
    </form>

    <?php else: ?>

		<p><strong><?php esc_html_e('Ups, seems like you haven\'t run the installation yet. Please run it first', 'santapress') ?>.</strong></p>
	
    <?php endif; ?>

</div>