<?php
/**
 * SantaPress Admin View: Init Exists
 *
 * @link       https://santapress.halloecho.de
 * @since      1.0.0
 *
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}
?>

<div class="wrap">
    
	<h1>SantaPress <span class="santapress_version">Version <?php echo SANTAPRESS_VERSION; ?></span></h1>

    <h2><strong><span class="dashicons dashicons-smiley"></span> <?php esc_html_e('It seems like you have set up SantaPress successfully.', 'santapress'); ?></strong></h2>

    <h2>Shortcode</h2>
    <p><?php esc_html_e('You can integrate the SantaPress calender by inserting this shortcode to any post, page, custom post type etc.', 'santapress'); ?>: <span class="santapress_shortcode_wrapper"><input type="text" onfocus="this.select();" readonly="readonly" value="[santapress]" class="code santapress_shortcode" id="santapress_shortcode"><span class="santapress_shortcode_copied"><?php esc_html_e('Copied to clipboard', 'santapress'); ?></span></span><br />

    <?php esc_html_e('For more options to integrate, please go to the', 'santapress'); ?> <a href="https://santapress.halloecho.de/docs" target="_blank">docs</a>.</p>

    <h2><?php esc_html_e('Settings', 'santapress'); ?></h2>
    <p class="sp-lh">
    	<?php printf( wp_kses( __('To %sglobally%s change the layout, please go to %sLayout%s.', 'santapress'), array( 'strong' )), '<strong>', '</strong>', '<a href="admin.php?page=santapress_layout_settings">', '</a>' ); ?>
    	<br />
        <?php printf( wp_kses( __('%sIndividual%s settings (door image, opening type, custom javascripts) can be made on each door post.', 'santapress'), array( 'strong' )), '<strong>', '</strong>'); ?>
		<br />
	<?php esc_html_e('For global settings, please go to', 'santapress'); ?> <a href="admin.php?page=santapress_config"><?php esc_html_e('Settings', 'santapress'); ?></a>.
	</p>
 
	<h2><?php esc_html_e('Reset', 'santapress'); ?></h2>
    <p><?php printf( wp_kses( __('If you want to start from scratch, simply delete all %sDoors%s and come back to this page.', 'santapress'), array( 'a' => array( 'href' ))), '<a href="edit.php?post_type=door">', '</a>'); ?></p>
</div>