<?php
/**
 * SantaPress Admin View: Config
 *
 * @link       https://santapress.halloecho.de
 * @since      1.0.0
 *
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}
?>

<div class="wrap">
	
	<h1>Global Settings</h1>

	<?php
	$args = array(
			'posts_per_page'   => -1,
			'orderby'          => 'menu_order',
			'order'            => 'ASC',
			'post_type'        => 'door',
			'post_status'      => 'publish, future',
			'suppress_filters' => true
		);
	$doors = get_posts( $args );
	if($doors):
	?>

	<form method="post" action="options.php">
        <?php
            settings_fields( 'santapress_config' );
            do_settings_sections( 'santapress_config' );
            submit_button();
            settings_errors();
        ?>
    </form>

    <?php else: ?>

		<p><strong><?php esc_html_e('Ups, seems like you haven\'t run the installation yet. Please run it first', 'santapress') ?>.</strong></p>
	
    <?php endif; ?>

</div>