(function( $ ) {
	'use strict';
	
	/**
	 * SantaPress Admin JavaScript
	 *
	 * @link       https://santapress.halloecho.de
	 * @since      1.0.0
	 *
	 */

	$(function() {

		$('.santapress_datepicker').datepicker({
			dateFormat : 'yy-mm-dd'
		});

		$( document ).on( 'click', '.santapress_layout_col label', function() {
			$('.santapress_layout_col img').removeClass('selected');
			$(this).find('img').addClass('selected');
		});

		$( document ).on( 'click', '#santapress_shortcode', function() {
			var copyText = document.getElementById("santapress_shortcode");
			copyText.select();
			document.execCommand("copy");
			var $santapress_shortcode_copied = $(this).parent().find('.santapress_shortcode_copied');
			$santapress_shortcode_copied.show();
			setTimeout(function() {
		       $santapress_shortcode_copied.fadeOut();
		   	}, 800);
		});

		$('.color-field').wpColorPicker();

		var santapress_door_image_url = $('.santapress_door_image').find('input[type="text"]').val();
		if(santapress_door_image_url) {
			// svg fix
			if (santapress_door_image_url.indexOf('.svg') >= 0) {
				santapress_door_image_url = santapress_door_image_url.replace('.svg', '.png');
			}
			$('<div class="santapress_door_image_img"><img src="'+santapress_door_image_url+'"></div><br /><a href="javascript:void(0);" class="santapress_select_img">Select a different image</a><div id="santapress_door_images"></div>').appendTo('.santapress_door_image');
		}

		$(document).on('click', '.santapress_select_img', function(e) {
			e.preventDefault();
			$('#santapress_door_images').load( data.plugin_admin_dir_url + 'ajax/get_door_images.php' );
		});

		$(document).on('click', '.santapress_choose_door', function(e) {
			e.preventDefault();
			var imgUrl = $(this).find('img').attr('src');
			$('.santapress_door_image').find('input[type="text"]').val(imgUrl);
			$('.santapress_door_image_img').find('img').attr('src', imgUrl);
		});

		if( $('#setting-error-santapress_init_notice').length ) {
			$('form.santapress_installation').addClass('updated');
			$('form.santapress_installation').find('input[type="submit"]').attr('disabled', 'disabled');
			$('#menu-posts-door .wp-menu-image.dashicons-star-empty').addClass('settings-updated');
		}

		if( $('.santapress_manual_layout').length ) { // user is on global settings page
			if($('input[name="santapress_modal_autolayout"]').prop('checked')) { // autolayout active
				$('.santapress_manual_layout').hide();
			}
			else {
				$('.santapress_manual_layout').show();
			}
			$('input[name="santapress_modal_autolayout"]').change(function() {
				if(this.checked)
					$('.santapress_manual_layout').hide();
				else
					$('.santapress_manual_layout').show();
			});
			$('.santapress_manual_layout').first().addClass('first');
			$('.santapress_manual_layout').last().addClass('last');
		}

		if( $('input[name="santapress_quizcookie"]').length ) { // user is on quiz settings page
			if($('input[name="santapress_quizcookie"]').prop('checked')) { // autolayout active
				$('.santapress_quizcookie_msg').show();
			}
			else {
				$('.santapress_quizcookie_msg').hide();
			}
			$('input[name="santapress_quizcookie"]').change(function() {
				if(this.checked)
					$('.santapress_quizcookie_msg').show();
				else
					$('.santapress_quizcookie_msg').hide();
			});
		}

	});

})( jQuery );
