<?php

/**
 * Ajax File to retrieve door images in WordPress Backend
 *
 * @link       https://santapress.halloecho.de
 * @since      1.0.0
 *
 * @package    SantaPress
 * @subpackage SantaPress/admin
 */

$it = new RecursiveDirectoryIterator("../../public/img");
$files = [];

// Loop through files
foreach(new RecursiveIteratorIterator($it) as $file) {
    if ( $file->getExtension() == 'png' ) {
    	$filename = $file->getFilename();
    	$_filename = explode('.', $filename);
    	if(is_numeric($_filename[0]))
        	$files[$_filename[0]][] = $file->getPathname();
    }
}

ksort($files);

$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$_actual_link = explode('admin/ajax/', $actual_link);
$plugin_url = $_actual_link[0];

foreach($files as $subfiles) {
	foreach($subfiles as $file) {
		$_file = explode('public/img/', $file);
		echo '<span class="santapress_choose_door"><img src="'.$plugin_url.'public/img/'.$_file[1].'"></span>';
	}
}
?>