<?php
/**
 * Created by PhpStorm.
 * User: roninwp
 * Date: 2/21/2019
 * Time: 2:33 PM
 */
?>

<script type="text/html" id="tmpl-fat-sb-quote-template">
    <div class="ui modal tiny fat-semantic-container fat-sb-quote-form">
        <div class="header fat-sb-popup-title"><?php echo esc_attr('Quote detail', 'revy'); ?></div>
        <div class="scrolling content">
            <div class="ui form">
                <div class="two fields">
                    <div class="field ">
                        <label><?php echo esc_html__('First name', 'revy'); ?></label>
                        {{data.q_first_name}}
                    </div>

                    <div class="field ">
                        <label><?php echo esc_html__('Last name', 'revy'); ?> </label>
                        {{data.q_last_name}}
                    </div>

                </div>

                <div class="two fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Email', 'revy'); ?></label>
                        {{data.q_email}}
                    </div>

                    <div class="field ">
                        <label><?php echo esc_html__('Phone', 'revy'); ?> </label>
                        {{data.q_phone_code}}{{data.q_phone}}
                    </div>

                </div>

                <div class="two fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Device type', 'revy'); ?></label>
                        {{data.q_device_type}}
                    </div>

                    <div class="field ">
                        <label><?php echo esc_html__('Brand name', 'revy'); ?> </label>
                        {{data.q_brand_name}}
                    </div>

                </div>

                <div class="two fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Model', 'revy'); ?></label>
                        {{data.q_model}}
                    </div>

                    <div class="field ">
                        <label><?php echo esc_html__('Color', 'revy'); ?></label>
                        {{data.q_color}}
                    </div>

                </div>

                <div class="two fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Serial', 'revy'); ?></label>
                        {{data.q_serial_number}}
                    </div>

                </div>

                <div class="one fields">
                    <div class="field">
                        <label><?php echo esc_html__('Detail problem', 'revy'); ?></label>
                        <div class="problem">
                            {{data.q_detail_problem}}
                        </div>
                    </div>
                </div>
                <# if (data.q_image_url!=''){ #>
                <div class="one fields">
                    <div class="field">
                        <label><?php echo esc_html__('Attached image', 'revy'); ?></label>
                        <div class="problem">
                           <img src="{{data.q_image_url}}">
                        </div>
                    </div>
                </div>
                <# } #>
            </div>
        </div>
        <div class="actions">
            <button class="ui basic button fat-close-modal">
                <i class="times circle outline icon"></i>
                <?php echo esc_html__('Close', 'revy'); ?>
            </button>

        </div>
    </div>
</script>

<script type="text/html" id="tmpl-fat-sb-quote-item-template">
    <# _.each(data, function(item){ #>
    <tr data-id="{{item.q_id}}">
        <td data-label="<?php echo esc_attr__('Create Date', 'revy'); ?>">{{item.q_create_date}}</td>
        <td data-label="<?php echo esc_attr__('Customer', 'revy'); ?>">
            {{item.q_first_name}} {{item.q_last_name}}
            <span class="extra-info">{{item.q_email}}</span>
            <span class="extra-info">{{item.q_phone_code}} {{item.q_phone}}</span>
        </td>
        <td data-label="<?php echo esc_attr__('Device type', 'revy'); ?>">
            {{ item.q_device_type}}
        </td>
        <td data-label="<?php echo esc_attr__('Brand name', 'revy'); ?>">
            {{ item.q_brand_name}}
        </td>
        <td class="fat-sb-model" data-label="<?php echo esc_attr__('Model', 'revy'); ?>">
            {{item.q_model}}
        </td>
        <td class="fat-sb-color" data-label="<?php echo esc_attr__('Color', 'revy'); ?>">
            {{item.q_color}}
        </td>
        <td class="fat-sb-serial" data-label="<?php echo esc_attr__('Serial', 'revy'); ?>">
            {{item.q_color}}
        </td>
       <!-- <td class="fat-sb-status" data-label="<?php /*echo esc_attr__('Status', 'revy'); */?>">

            <# if (item.editable== 1) { #>
            <div class="ui floating dropdown labeled icon selection">
                <# }else{ #>
                <div class="ui floating dropdown labeled icon selection disabled">
                    <# } #>
                    <input type="hidden" name="b_process_status" value="{{item.b_process_status}}"
                           data-value="{{item.b_process_status}}"
                           data-onChange="RevyBooking.processUpdateProcessStatus" data-id="{{item.q_id}}">
                    <i class="dropdown icon"></i>
                    <span class="text"><div
                                class="ui yellow empty circular label"></div> <?php /*echo esc_html__('Pending', 'revy'); */?></span>
                    <div class="menu">
                        <div class="item" data-value="2">
                            <div class="ui red empty circular label"></div>
                            <?php /*echo esc_html__('Canceled', 'revy'); */?>
                        </div>
                        <div class="item" data-value="1">
                            <div class="ui green empty circular label"></div>
                            <?php /*echo esc_html__('Approved', 'revy'); */?>
                        </div>
                        <div class="item" data-value="0">
                            <div class="ui yellow empty circular label"></div>
                            <?php /*echo esc_html__('Pending', 'revy'); */?>
                        </div>
                        <div class="item" data-value="3">
                            <div class="ui empty empty circular label"></div>
                            <?php /*echo esc_html__('Rejected', 'revy'); */?>
                        </div>
                    </div>
                </div>
        </td>-->
        <td>
            <div class="ps-relative">
                <button class=" ui icon button fat-item-bt-inline fat-sb-edit-booking"
                        data-onClick="RevyQuote.showPopupQuote"
                        data-id="{{item.q_id}}" data-title="<?php echo esc_attr__('Detail', 'revy'); ?>">
                    <i class="info circle icon"></i>
                </button>

                <button class=" ui icon button fat-item-bt-inline fat-sb-delete"
                        data-onClick="RevyQuote.processDeleteQuote"
                        data-id="{{item.q_id}}" data-title="<?php echo esc_attr__('Delete', 'revy'); ?>">
                    <i class="trash alternate outline icon"></i>
                </button>
            </div>
        </td>
    </tr>
    <# }) #>
</script>



