<script type="text/html" id="tmpl-fat-sb-services-color-template">
    <div class="ui modal tiny fat-semantic-container fat-sb-color-form">
        <div class="header fat-sb-popup-title"><?php echo esc_html__('Add new model color','revy'); ?></div>
        <div class="scrolling content">
            <div class="ui form">
                <div class="one fields">
                    <div class="ui image-field" id="rc_image_id" data-image-id="{{data.rc_image_id}}"
                         data-image-url="{{data.rc_image_url}}">
                    </div>
                </div>

                <div class="one fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Color Name','revy'); ?><span
                                    class="required"> *</span></label>
                        <div class="ui left icon input ">
                            <input type="text" name="rc_name" id="rc_name" value="{{data.rc_name}}" autocomplete="off"
                                   placeholder="<?php echo esc_attr__('Color name','revy'); ?>" required>
                            <i class="edit outline icon"></i>
                        </div>
                        <div class="field-error-message">
                            <?php echo esc_html__('Please enter name','revy'); ?>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <div class="actions">
            <button class="ui basic button fat-close-modal">
                <i class="times circle outline icon"></i>
                <?php echo esc_html__('Cancel','revy'); ?>
            </button>

            <button class="ui blue button fat-submit-modal submit-color"
                    data-onClick="RevyColor.processSubmitColor" data-id="{{data.rc_id}}"
                    data-success-message="<?php echo esc_attr__('Color has been saved','revy'); ?>">
                <i class="save outline icon"></i>
                <?php echo esc_html__('Save','revy'); ?>
            </button>

        </div>
    </div>
</script>

<script type="text/html" id="tmpl-fat-sb-color-item-template">
    <# _.each(data, function(item){ #>
    <tr class="item" data-id="{{item.rc_id}}">
        <td class="fat-c-image" data-label="<?php echo esc_attr__('Image', 'revy'); ?>">
            <img src="{{item.rc_image_url }}">
        </td>

        <td class="fat-c-name" data-label="<?php echo esc_attr__('Color Name', 'revy'); ?>">
            {{item.rc_name }}
        </td>
        <td>
            <div class="ps-relative">
                <button class="ui icon button fat-item-bt-inline fat-sb-delete" data-onClick="RevyColor.processDeleteColor"
                        data-id="{{item.rc_id}}" data-title="<?php echo esc_attr__('Delete', 'revy'); ?>">
                    <i class="trash alternate outline icon"></i>
                </button>

                <button class="ui icon ui-tooltip button fat-item-bt-inline fat-sb-edit"
                        data-onClick="RevyColor.processEditColor"
                        data-id="{{item.rc_id}}" data-title="<?php echo esc_attr__('Edit', 'revy'); ?>">
                    <i class="edit outline icon"></i>
                </button>
            </div>

        </td>
    </tr>
    <# }) #>
</script>