<?php
$db = Revy_DB_Brands::instance();
$brands = $db->get_brands(1);

$db = Revy_DB_Devices::instance();
$devices = $db->get_devices(1);

?>
<script type="text/html" id="tmpl-fat-sb-services-category-template">
    <div class="ui modal tiny fat-semantic-container fat-sb-category-form">
        <div class="header fat-sb-popup-title"><?php echo esc_html__('Add new category','revy'); ?></div>
        <div class="scrolling content">
            <div class="ui form">
                <div class="one fields">
                    <div class="ui image-field" id="c_image_id" data-image-id="{{data.c_image_id}}"
                         data-image-url="{{data.c_image_url}}">
                    </div>
                </div>

                <div class="field">
                    <label for="c_brand_id"><?php echo esc_html__('Device', 'revy'); ?>
                        <span
                                class="required"> *</span>
                    </label>
                    <div class="ui selection search dropdown top left pointing has-icon rm-device">
                        <i class="folder outline icon"></i>
                        <input type="hidden" name="c_device_id" id="c_device_id"
                               value="{{data.c_device_id}}" tabindex="1"
                               required>
                        <div class="text"><?php echo esc_html__('Select device','revy'); ?></div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                            <?php foreach ($devices as $dv) { ?>
                                <div class="item"
                                     data-value="<?php echo esc_attr($dv->rd_id); ?>"><?php echo esc_html($dv->rd_name); ?></div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please select device', 'revy'); ?>
                    </div>
                </div>

                <div class="field">
                    <label for="c_brand_id"><?php echo esc_html__('Brand', 'revy'); ?>
                        <span
                                class="required"> *</span>
                    </label>
                    <div class="ui selection search dropdown top left pointing has-icon rm-brand">
                        <i class="folder outline icon"></i>
                        <input type="hidden" name="c_brand_id" id="c_brand_id"
                               value="{{data.c_brand_id}}" tabindex="1"
                               required>
                        <div class="text"><?php echo esc_html__('Select brand','revy'); ?></div>
                        <i class="dropdown icon"></i>
                        <div class="menu">
                            <?php foreach ($brands as $b) { ?>
                                <div class="item"
                                     data-value="<?php echo esc_attr($b->rb_id); ?>"><?php echo esc_html($b->rb_name); ?></div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please select brand', 'revy'); ?>
                    </div>
                </div>

                <div class="one fields">
                    <div class="field ">
                        <label><?php echo esc_html__('Name','revy'); ?><span
                                    class="required"> *</span></label>
                        <div class="ui left icon input ">
                            <input type="text" name="c_name" id="c_name" value="{{data.c_name}}" autocomplete="off"
                                   placeholder="<?php echo esc_attr__('Category name','revy'); ?>" required>
                            <i class="edit outline icon"></i>
                        </div>
                        <div class="field-error-message">
                            <?php echo esc_html__('Please enter name','revy'); ?>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <div class="actions">
            <button class="ui basic button fat-close-modal">
                <i class="times circle outline icon"></i>
                <?php echo esc_html__('Cancel','revy'); ?>
            </button>

            <button class="ui blue button fat-submit-modal submit-category"
                    data-onClick="RevyCategory.processSubmitCategory" data-id="{{data.c_id}}"
                    data-success-message="<?php echo esc_attr__('Category has been saved','revy'); ?>">
                <i class="save outline icon"></i>
                <?php echo esc_html__('Save','revy'); ?>
            </button>

        </div>
    </div>
</script>

<script type="text/html" id="tmpl-fat-sb-category-item-template">
    <# _.each(data, function(item){ #>
    <tr class="item" data-id="{{item.c_id}}">
        <td class="fat-c-id" data-label="<?php echo esc_attr__('ID', 'revy'); ?>">
            {{item.c_id }}
        </td>
        <td class="fat-c-image" data-label="<?php echo esc_attr__('Image', 'revy'); ?>">
            <img src="{{item.c_image_url }}">
        </td>

        <td class="fat-c-device" data-label="<?php echo esc_attr__('Device', 'revy'); ?>">
            {{item.rd_name }}
        </td>

        <td class="fat-c-brand" data-label="<?php echo esc_attr__('Brand', 'revy'); ?>">
            {{item.rb_name }}
        </td>

        <td class="fat-c-name" data-label="<?php echo esc_attr__('Name', 'revy'); ?>">
            {{item.c_name }}
        </td>
        <td>
            <div class="ps-relative">
                <button class="ui icon button fat-item-bt-inline fat-sb-delete" data-onClick="RevyCategory.processDeleteCategory"
                        data-id="{{item.c_id}}" data-title="<?php echo esc_attr__('Delete', 'revy'); ?>">
                    <i class="trash alternate outline icon"></i>
                </button>

                <button class="ui icon ui-tooltip button fat-item-bt-inline fat-sb-edit"
                        data-onClick="RevyCategory.processEditCategory"
                        data-id="{{item.c_id}}" data-title="<?php echo esc_attr__('Edit', 'revy'); ?>">
                    <i class="edit outline icon"></i>
                </button>
            </div>

        </td>
    </tr>
    <# }) #>
</script>