<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();
$serial_number_label = isset($setting['serial_number_label']) && $setting['serial_number_label'] ? $setting['serial_number_label'] : esc_html__('Serial number (or IMEI)', 'revy');
$phoneCode = Revy_Utils::getPhoneCountry();
$phone_code_default = isset($setting['default_phone_code']) && $setting['default_phone_code'] ? $setting['default_phone_code'] : '+44,uk';

$container_class = 'fat-semantic-container fat-booking-container fat-quote-form-container';
?>
<div class="<?php echo esc_attr($container_class);?>">
    <div class="quote-form-wrap fat-section-shadow">
        <h4 class="quote-form-title"><?php echo esc_html__('Quote Form', 'revy'); ?></h4>
        <div class="ui form">
            <div class="two fields">
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="c_first_name"><?php echo esc_html__('First name', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input ">
                        <input type="text" name="c_first_name" id="c_first_name"
                               data-onChange="RevyQuoteForm.resetValidateField"
                               value=""
                               placeholder="<?php echo esc_attr__('First name', 'revy'); ?>"
                               required>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter first name', 'revy'); ?>
                    </div>
                </div>
                <div class="field ">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="c_last_name"><?php echo esc_html__('Last name', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input ">
                        <input type="text" name="c_last_name" id="c_last_name"
                               data-onChange="RevyQuoteForm.resetValidateField"
                               value=""
                               placeholder="<?php echo esc_attr__('Last name', 'revy'); ?>"
                               required>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter last name', 'revy'); ?>
                    </div>
                </div>
            </div>
            <div class="two fields phone-email">
                <div class="field email-field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="c_email"><?php echo esc_html__('Email', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input">
                        <input type="email" name="c_email" id="c_email"
                               data-onChange="RevyQuoteForm.resetValidateField"
                               value=""
                               placeholder="<?php echo esc_attr__('Email', 'revy'); ?>"
                               required>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter email', 'revy'); ?>
                    </div>
                </div>
                <div class="field phone-field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="phone_code"><?php echo esc_html__('Phone', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="phone-code-wrap">
                        <div class="ui fluid search selection dropdown phone-code fat-small-dropdown">
                            <input type="hidden" name="phone_code" id="phone_code"
                                   autocomplete="nope"
                                   value="<?php echo esc_attr($phone_code_default); ?>">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">
                                <?php
                                foreach ($phoneCode as $pc) {
                                    $pc = explode(',', $pc); ?>
                                    <div class="item"
                                         data-value="<?php echo esc_attr($pc[1] . ',' . $pc[2]); ?>">
                                        <i
                                            class="<?php echo esc_attr($pc[2]); ?> flag"></i><?php echo esc_html($pc[0]); ?>
                                    </div>
                                <?php } ?>
                                <div class="item"
                                     data-value="other"><?php echo esc_html__('Other', 'revy'); ?></div>
                            </div>
                        </div>

                        <div class="ui left input phone-number">
                            <input type="text" name="c_phone" id="c_phone"
                                   data-onChange="RevyQuoteForm.resetValidateField" required
                                   value=""
                                   placeholder="<?php echo esc_attr__('Phone', 'revy'); ?>">
                        </div>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter phone', 'revy'); ?>
                    </div>
                </div>
            </div>
            <div class="one fields address">
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="c_address"><?php echo esc_html__('Address', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input ">
                        <input type="text" name="c_address" id="c_address" value="" placeholder="<?php echo esc_attr__('Address', 'revy'); ?>"
                               data-onChange="RevyQuoteForm.resetValidateField">
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter address', 'revy'); ?>
                    </div>
                </div>
            </div>

            <div class="two fields address-postal">
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_device_type"><?php echo esc_html__('Device type', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input ">
                        <input type="text" name="q_device_type" id="q_device_type" value="" placeholder="<?php echo esc_attr__('Device type', 'revy'); ?>"
                               data-onChange="RevyQuoteForm.resetValidateField" required>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter postal code', 'revy'); ?>
                    </div>
                </div>
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_brand_name"><?php echo esc_html__('Brand name', 'revy'); ?>
                        <span class="required"> *</span></label>
                    <div class="ui left input ">
                        <input type="text" name="q_brand_name" id="q_brand_name" value="" placeholder="<?php echo esc_attr__('Brand name', 'revy'); ?>"
                               data-onChange="RevyQuoteForm.resetValidateField" required>
                    </div>
                    <div class="field-error-message">
                        <?php echo esc_html__('Please enter brand name', 'revy'); ?>
                    </div>
                </div>
            </div>

            <div class="two fields model-color">
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_model"><?php echo esc_html__('Model', 'revy'); ?></label>
                    <div class="ui left input ">
                        <input type="text" name="q_model" id="q_model" value="" placeholder="<?php echo esc_attr__('Model', 'revy'); ?>">
                    </div>
                </div>
                <div class="field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_color"><?php echo esc_html__('Color', 'revy'); ?></label>
                    <div class="ui left input ">
                        <input type="text" name="q_color" id="q_color" value="" placeholder="<?php echo esc_attr__('Color', 'revy'); ?>">
                    </div>
                </div>
            </div>

            <div class="one fields serial-number">
                <div class="field serial-field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="b_serial_number"><?php echo esc_html($serial_number_label); ?>
                    </label>
                    <div class="ui left input ">
                        <input type="text" name="b_serial_number" id="b_serial_number" value="" placeholder="<?php echo esc_attr($serial_number_label); ?>">
                    </div>
                </div>
            </div>
            <div class="one fields detail-problem">
                <div class="field notes-field">
                    <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_detail_problem"><?php echo esc_html__('Detail problem', 'revy'); ?>
                    </label>
                    <div class="ui left input ">
                        <textarea id="q_detail_problem" name="q_detail_problem"></textarea>
                    </div>
                </div>
            </div>

            <?php if(isset($setting['enable_upload_image']) && $setting['enable_upload_image']=='1') : ?>
                <div class="one fields images">
                    <div class="field ">
                        <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10" for="q_image_id"><?php echo esc_html__('Image', 'revy'); ?>
                        </label>
                        <div class="media-field"  data-file-size="<?php echo esc_attr($setting['image_file_size']);?>">
                            <div class="ui image-field " id="q_image_id" data-image-icon="image outline icon" data-onClick="RevyQuoteForm.chooseImage">
                                <i class="image outline icon"></i>
                                <span><?php echo esc_html__('Please choose image','revy');?></span>
                            </div>
                        </div>

                    </div>
                </div>
            <?php endif; ?>

            <div class="button-group fat-mg-top-30">
                <button class="ui primary button fat-bt-submit" data-onclick="RevyQuoteForm.submitQuote">
                   <?php echo esc_html__('Submit','revy');?>
                </button>
            </div>
        </div>
    </div>

</div>
