<?php
if($pdf_data['delivery']==1){
    $pdf_data['delivery'] = esc_html__('Fix at home','revy');
}
if($pdf_data['delivery']==2){
    $pdf_data['delivery'] = esc_html__('Carry-In','revy');
}
if($pdf_data['delivery']==3){
    $pdf_data['delivery'] = esc_html__('Mail-In Delivery','revy');
}

?>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <style>
        .order-detail {
            width: 800px;
            max-width: 100%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border-top: solid 1px #ddd;
            border-left: solid 1px #ddd;
            border-right: solid 1px #ddd;
        }

        table td,
        table th {
            padding: 10px;
        }

        table tr {
            border-bottom: solid 1px #ddd;
        }

        table th {
            text-align: left;
        }

        table td.no-padding {
            padding: 0px;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .order-general > span {
            display: inline-block;

        }

        .order-general .order-label {
            min-width: 200px;

        }

        .order-detail,
        table th,
        table td,
        .order-general .order-label,
        .order-value{
            font-family: firefly, DejaVu Sans, sans-serif;
        }

        .order-general .order-value,
        .order-general .order-label {
            display: inline-block;
            margin-bottom: 10px;
        }

        .font-bold {
            font-weight: 600;
        }

    </style>
</head>
<body>

<?php
$setting = Revy_DB_Setting::instance();
$setting = $setting->get_setting();

?>

<div id="pdf_export">


    <div class="order-review">
        <h2 style="text-align: center;margin-bottom: 60px"><?php echo esc_html__('Order review', 'revy'); ?></h2>
        <div class="order-general">
            <div class="order-company-wrap">
                <span class="order-label"><?php echo esc_html__('Company name:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($setting['company_name']); ?></span>
            </div>
            <div class="order-company-wrap">
                <span class="order-label"><?php echo esc_html__('Company address:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($setting['company_address']); ?></span>
            </div>
            <div class="order-company-wrap">
                <span class="order-label"><?php echo esc_html__('Company email:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($setting['company_email']); ?></span>
            </div>
            <div class="order-company-wrap">
                <span class="order-label"><?php echo esc_html__('Company phone:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($setting['company_phone']); ?></span>
            </div>
            <div class="order-number-wrap">
                <span class="order-label"><?php echo esc_html__('Order number:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['order_code']); ?></span>
            </div>
            <div class="order-date-wrap">
                <span class="order-label"><?php echo esc_html__('Create date:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['create_date']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Booking date:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['booking_date'].' '. $pdf_data['booking_time']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('First name:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['first_name']); ?></span></div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Last name:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['last_name']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Email:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['email']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Phone:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['phone']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Serial number:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['serial_number']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Delivery method:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['delivery']); ?></span>
            </div>
            <div class="order-email-wrap">
                <span class="order-label"><?php echo esc_html__('Note:', 'revy'); ?></span>
                <span class="order-value"><?php echo esc_html($pdf_data['note']); ?></span>
            </div>

        </div>
        <div class="order-detail">
            <h4 class="order-detail-title"><?php echo esc_html__('Order detail', 'revy'); ?></h4>
            <table class="order-device-table">
                <thead>
                <tr>
                    <th><?php echo esc_html__('Device', 'revy'); ?></th>
                    <th><?php echo esc_html__('Service', 'revy'); ?></th>
                    <th style="text-align: right"><?php echo esc_html__('Total', 'revy'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php if (isset($pdf_data['services']) && is_array($pdf_data['services'])):
                    foreach ($pdf_data['services'] as $sev) { ?>
                        <tr>
                            <td><?php echo esc_html($sev['device']);?></td>
                            <td><?php echo esc_html($sev['service']);?>
                            </td>
                            <td style="text-align: right"><?php echo Revy_Utils::formatMoney($sev['total']);?></td>
                        </tr>
                    <?php }
                endif; ?>
                </tbody>
                <tfoot>
                <tr id="tr-delivery">
                    <td>&nbsp;</td>
                    <td class="text-right font-bold"><?php echo esc_html__('Delivery fee', 'revy'); ?></td>
                    <td id="order-delivery-cost" style="text-align: right"><?php echo Revy_Utils::formatMoney($pdf_data['delivery_cost']);?></td>
                </tr>
                <?php if(isset($pdf_data['tax']) && $pdf_data['tax']) : ?>
                    <tr id="tr-tax">
                        <td>&nbsp;</td>
                        <td class="text-right font-bold"><?php echo esc_html__('Tax', 'revy'); ?></td>
                        <td id="order-delivery-cost" style="text-align: right"><?php echo Revy_Utils::formatMoney($pdf_data['tax']);?></td>
                    </tr>
                <?php endif;?>
                <tr id="tr-total">
                    <td>&nbsp;</td>
                    <td class="text-right font-bold" ><?php echo esc_html__('Total', 'revy'); ?></td>
                    <td id="order-total" style="text-align: right"><?php echo Revy_Utils::formatMoney($pdf_data['total']);?></td>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

</body>
</html>