<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();

$group_label = isset($setting['group_label']) && $setting['group_label'] ? $setting['group_label'] : esc_html__('Group', 'revy');
$serial_number_label = isset($setting['serial_number_label']) && $setting['serial_number_label'] ? $setting['serial_number_label'] : esc_html__('Serial number (or IMEI)', 'revy');

$fields = get_option($setting_db->custom_field_key);

$phoneCode = Revy_Utils::getPhoneCountry();
$phone_code_default = isset($setting['default_phone_code']) && $setting['default_phone_code'] ? $setting['default_phone_code'] : '+44,uk';

$hide_last_name = isset($atts['hide_last_name']) && $atts['hide_last_name'] == '1';
$hide_postal_code = isset($atts['hide_postal_code']) && $atts['hide_postal_code'] == '1';
$hide_address = isset($atts['hide_address']) && $atts['hide_address'] == '1';
$hide_city = isset($atts['hide_city']) && $atts['hide_city'] == '1';
$hide_country = isset($atts['hide_country']) && $atts['hide_country'] == '1';
$hide_serial_number = isset($atts['hide_serial_number']) && $atts['hide_serial_number'] == '1';
$hide_notes = isset($atts['hide_notes']) && $atts['hide_notes'] == '1';

?>
<div class="customer-info-wrap fat-section-shadow">
    <h4><?php echo esc_html__('Customer Information', 'revy'); ?></h4>
    <div class="ui form">
        <div class="two fields full-name">
            <div class="field first-name">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_first_name"><?php echo esc_html__('First name', 'revy'); ?>
                    <span class="required"> *</span></label>
                <div class="ui left input ">
                    <input type="text" name="c_first_name" id="c_first_name"
                           data-onChange="RevyBookingFlow.resetValidateField"
                           value=""
                           placeholder="<?php echo esc_attr__('First name', 'revy'); ?>"
                           required>
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter first name', 'revy'); ?>
                </div>
            </div>
            <div class="field last-name">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_last_name"><?php echo esc_html__('Last name', 'revy'); ?>
                    <span class="required"> *</span></label>
                <div class="ui left input ">
                    <input type="text" name="c_last_name" id="c_last_name"
                           data-onChange="RevyBookingFlow.resetValidateField"
                           value="<?php echo($hide_last_name ? 'Empty' : ''); ?>"
                           placeholder="<?php echo esc_attr__('Last name', 'revy'); ?>"
                           required>
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter last name', 'revy'); ?>
                </div>
            </div>
        </div>
        <div class="two fields phone-email">
            <div class="field email-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_email"><?php echo esc_html__('Email', 'revy'); ?>
                    <span class="required"> *</span></label>
                <div class="ui left input">
                    <input type="email" name="c_email" id="c_email"
                           data-onChange="RevyBookingFlow.resetValidateField"
                           value=""
                           placeholder="<?php echo esc_attr__('Email', 'revy'); ?>"
                           required>
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter email', 'revy'); ?>
                </div>
            </div>
            <div class="field phone-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="phone_code"><?php echo esc_html__('Phone', 'revy'); ?>
                    <?php if (isset($setting['required_phone']) && $setting['required_phone'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="phone-code-wrap">
                    <div class="ui fluid search selection dropdown phone-code fat-small-dropdown">
                        <input type="hidden" name="phone_code" id="phone_code"
                               autocomplete="nope"
                               value="<?php echo esc_attr($phone_code_default); ?>">
                        <i class="dropdown icon"></i>
                        <div class="default text"></div>
                        <div class="menu">
                            <?php
                            foreach ($phoneCode as $pc) {
                                $pc = explode(',', $pc); ?>
                                <div class="item"
                                     data-value="<?php echo esc_attr($pc[1] . ',' . $pc[2]); ?>">
                                    <i
                                            class="<?php echo esc_attr($pc[2]); ?> flag"></i><?php echo esc_html($pc[0]); ?>
                                </div>
                            <?php } ?>
                            <div class="item"
                                 data-value="other"><?php echo esc_html__('Other', 'revy'); ?></div>
                        </div>
                    </div>

                    <div class="ui left input phone-number">
                        <input type="number" name="c_phone" id="c_phone"
                               data-onChange="RevyBookingFlow.resetValidateField" <?php echo isset($setting['required_phone']) && $setting['required_phone'] == '1' ?  'required' : ''?>
                               value=""
                               placeholder="<?php echo esc_attr__('Phone', 'revy'); ?>">
                    </div>
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter phone', 'revy'); ?>
                </div>
            </div>
        </div>
        <div class="two fields address-postal">
            <div class="field postal-code">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_postal_code"><?php echo esc_html__('Postal Code', 'revy'); ?>
                    <?php if (isset($setting['required_postal_code']) && $setting['required_postal_code'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="ui left input ">
                    <input type="text" name="c_postal_code" id="c_postal_code"
                           value="<?php echo($hide_postal_code ? 'Empty' : ''); ?>"
                           placeholder="<?php echo esc_attr__('Postal Code', 'revy'); ?>" <?php echo isset($setting['required_postal_code']) && $setting['required_postal_code'] == '1' ?  'required' : ''?>
                           data-onChange="RevyBookingFlow.resetValidateField">
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter postal code', 'revy'); ?>
                </div>
            </div>
            <div class="field address">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_address"><?php echo esc_html__('Address', 'revy'); ?>
                    <?php if (isset($setting['required_address']) && $setting['required_address'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="ui left input ">
                    <input type="text" name="c_address" id="c_address"
                           value="<?php echo($hide_address ? 'Empty' : ''); ?>"
                           placeholder="<?php echo esc_attr__('Address', 'revy'); ?>" <?php echo isset($setting['required_address']) && $setting['required_address'] == '1' ?  'required' : ''?>
                           data-onChange="RevyBookingFlow.resetValidateField">
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter address', 'revy'); ?>
                </div>
            </div>
        </div>
        <div class="two fields city-country">
            <div class="field city-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_city"><?php echo esc_html__('City', 'revy'); ?>
                    <?php if (isset($setting['required_city']) && $setting['required_city'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="ui left input ">
                    <input type="text" name="c_city" id="c_city" value="<?php echo($hide_city ? 'Empty' : ''); ?>"
                           placeholder="<?php echo esc_attr__('City', 'revy'); ?>" <?php echo isset($setting['required_city']) && $setting['required_city'] == '1' ?  'required' : ''?>
                           data-onChange="RevyBookingFlow.resetValidateField">
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter city', 'revy'); ?>
                </div>
            </div>
            <div class="field country-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="c_country"><?php echo esc_html__('Country', 'revy'); ?>
                    <?php if (isset($setting['required_country']) && $setting['required_country'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="ui left input ">
                    <input type="text" name="c_country" id="c_country"
                           value="<?php echo($hide_country ? 'Empty' : ''); ?>"
                           placeholder="<?php echo esc_attr__('Country', 'revy'); ?>" <?php echo isset($setting['required_country']) && $setting['required_country'] == '1' ?  'required' : ''?>
                           data-onChange="RevyBookingFlow.resetValidateField">
                </div>
                <div class="field-error-message">
                    <?php echo esc_html__('Please enter country', 'revy'); ?>
                </div>
            </div>
        </div>
        <div class="one fields serial-number">
            <div class="field serial-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="b_serial_number"><?php echo esc_html($serial_number_label); ?>
                    <?php if (isset($setting['required_serial_number']) && $setting['required_serial_number'] == '1'): ?>
                        <span class="required"> *</span>
                    <?php endif; ?>
                </label>
                <div class="ui left input ">
                    <input type="text" name="b_serial_number" id="b_serial_number"
                           value="<?php echo($hide_serial_number ? 'Empty' : ''); ?>" <?php echo isset($setting['required_serial_number']) && $setting['required_serial_number'] == '1' ?  'required' : ''?>
                           placeholder="<?php echo esc_attr($serial_number_label); ?>">
                </div>
            </div>
        </div>

        <div class="one fields custom-fields">
            <?php if (isset($fields) && is_array($fields)):
                foreach ($fields as $field) {
                    ?>
                    <div class="field <?php echo esc_attr($field['type']); ?>"
                         data-id="<?php echo esc_attr($field['id']); ?>"
                         data-label="<?php echo esc_attr($field['label']); ?>">
                        <label for="<?php echo esc_attr($field['id']); ?>"><?php echo esc_attr($field['label']); ?>
                            <?php if ($field['required'] == 'yes'): ?>
                                <span class="required"> *</span>
                            <?php endif; ?>
                        </label>
                        <?php if ($field['type'] == 'text'): ?>
                            <div class="ui left input ">
                                <input type="text" name="<?php echo esc_attr($field['id']); ?>"
                                       id="<?php echo esc_attr($field['id']); ?>"
                                       value=""
                                       placeholder="<?php echo esc_attr($field['placeholder']); ?>" <?php echo($field['required'] == 'yes' ? 'required' : ''); ?> >
                            </div>
                        <?php endif; ?>
                        <?php if ($field['type'] == 'number'): ?>
                            <div class="ui action input number has-button">
                                <button class="ui icon button number-decrease">
                                    <i class="minus-icon"></i>
                                </button>
                                <input type="text" name="<?php echo esc_attr($field['id']); ?>" data-type="int"
                                       data-step="1" data-min="0"
                                       data-max="5" tabindex="6" id="<?php echo esc_attr($field['id']); ?>"
                                       value="0" <?php echo($field['required'] == 'yes' ? 'required' : ''); ?> >
                                <button class="ui icon button number-increase">
                                    <i class="plus-icon"></i>
                                </button>
                            </div>
                        <?php endif; ?>

                        <?php if ($field['type'] == 'textarea'): ?>
                            <textarea name="<?php echo esc_attr($field['id']); ?>"
                                      id="<?php echo esc_attr($field['id']); ?>"
                                      placeholder="<?php echo esc_attr($field['placeholder']); ?>"
                                      rows="3" <?php echo($field['required'] == 'yes' ? 'required' : ''); ?> ></textarea>
                        <?php endif; ?>

                        <?php if ($field['required'] == 'yes'): ?>
                            <div class="field-error-message">
                                <?php echo esc_html__('Please enter value for this field', 'revy'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php
                }
            endif; ?>
        </div>

        <div class="one fields notes">
            <div class="field notes-field">
                <label class="fat-fw-400 fat-lh-1em fat-mg-bottom-10"
                       for="b_notes"><?php echo esc_html__('Notes', 'revy'); ?>
                </label>
                <div class="ui left input ">
                    <textarea id="b_notes" name="b_notes"></textarea>
                </div>
            </div>
        </div>
    </div>
</div>
