<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();
?>

<div class="fat-sb-head">
    <h4 class="fat-sb-title"><?php echo esc_html($setting['step_brand_title']);?></h4>
    <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_brand_subtitle']);?></div>
    <div class="fat-search-box">
        <div class="ui transparent left icon input ui-search fat-sb-search fat-no-margin">
            <input type="text" id="brand_key" data-type="brand" placeholder="<?php echo esc_attr('Search brand name ...','revy');?>" data-onkeyup="RevyBookingFlow.searchNameOnKeyUp" autocomplete="nope">
            <i class="search icon"></i>
            <a class="fat-close" data-onclick="RevyBookingFlow.closeSearchOnClick">
                <i class="times icon"></i>
            </a>
        </div>
    </div>
</div>

<div class="fat-sb-item-inner-wrap brand-step step-item flex-center">

</div>
<div class="fat-sb-go-back text-center">
    <a href="javascript:" data-onclick="RevyBookingFlow.goBackDeviceStep" data-prevent-event="1">
        <i class="arrow left icon"></i><?php echo esc_html__('Change Device Type','revy');?></a>
</div>

<?php if(isset($setting['enable_quote_form']) && $setting['enable_quote_form']=='1' && isset($setting['quote_form_page']) && $setting['quote_form_page']):
    $quote_page = get_permalink($setting['quote_form_page']);
    ?>
    <div class="fat-quote-link text-center fat-mg-top-30">
        <?php echo esc_html__('If you cannot see your brand type listed here please use our ','revy');?><a href="<?php echo esc_url($quote_page);?>"> <?php echo esc_html__('Quote Form','revy');?></a>
    </div>
<?php endif; ?>


<script type="text/html" id="tmpl-fat-brand-item-template">
    <# _.each(data, function(item){ #>
    <div class="fat-sb-item fat-align-center fat-on-click"
         data-brand-id="{{item.rb_id}}" data-name=" {{item.rb_name}}"
         data-onClick="RevyBookingFlow.brandOnClick">
        <div class="fat-it-inner">
            <img src="{{item.rb_image_url}}">
            <div class="item-title">{{item.rb_name}}</div>
        </div>
    </div>
    <# }) #>
</script>
