<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();
$atts = is_array($atts) ? $atts : array();
$atts['hide_model_category'] = 1;


$show_group_filter = isset($atts['group_filter']) && $atts['group_filter'] == '1';
$service_type_filter = isset($atts['service_type_filter']) && $atts['service_type_filter'] == '1';
$container_class = 'fat-semantic-container fat-booking-container fat-sb-flow-layout';

$container_class .= isset($setting['hide_payment']) && $setting['hide_payment'] == '1' ? ' hide-payment' : '';
$container_class .= isset($setting['mapbox_api_key']) && $setting['mapbox_api_key'] != '' ? '' : '  hide-map';
$container_class .= isset($setting['default_payment_method']) && $setting['default_payment_method'] ? (' payment-' . $setting['default_payment_method']) : '';
$container_class .= is_array($atts) && isset($atts['layout']) && $atts['layout'] == 'brand-model' ? ' brand-model-step' : '';


if($atts['hide_price']=='1'){
    $container_class .= ' hide-price';
}else{
    $container_class .= isset($setting['hide_price']) && $setting['hide_price'] == '1' ? ' hide-price' : '';
}

$container_class .= isset($atts['hide_last_name']) && $atts['hide_last_name'] == '1' ? ' hide-last-name' : '';
$container_class .= isset($atts['hide_postal_code']) && $atts['hide_postal_code'] == '1' ? ' hide-postal-code' : '';
$container_class .= isset($atts['hide_address']) && $atts['hide_address'] == '1' ? ' hide-address' : '';
$container_class .= isset($atts['hide_city']) && $atts['hide_city'] == '1' ? ' hide-city' : '';
$container_class .= isset($atts['hide_country']) && $atts['hide_country'] == '1' ? ' hide-country' : '';
$container_class .= isset($atts['hide_serial_number']) && $atts['hide_serial_number'] == '1' ? ' hide-serial-number' : '';
$container_class .= isset($atts['hide_notes']) && $atts['hide_notes'] == '1' ? ' hide-notes' : '';
$container_class .= isset($atts['hide_garage']) && $atts['hide_garage'] == '1' ? ' hide-garage' : '';
$container_class .= isset($atts['hide_delivery_method']) && $atts['hide_delivery_method'] == '1' ? ' hide-delivery-method' : '';
$container_class .= isset($atts['hide_head']) && $atts['hide_head'] == '1' ? ' hide-head' : '';
$container_class .= isset($atts['hide_progress_bar_mobile']) && $atts[' '] == '1' ? ' hide-progress-bar-mobile' : '';
$container_class .= isset($atts['show_search_box']) && $atts['show_search_box'] == '1' ? ' show-search-box' : ' hide-search-box';
$container_class .= isset($atts['hide_progress_bar']) && $atts['hide_progress_bar'] == '1' ? ' hide-progress-bar' : '';
$container_class .= isset($atts['hide_model_category']) && $atts['hide_model_category'] == '1' ? ' hide-model-category' : '';

$container_class .= $show_group_filter ? ' has-group-filter' : '';
$container_class .= $service_type_filter ? ' has-service-type-filter' : '';

$device_id = isset($atts['device']) && $atts['device'] ? $atts['device'] : 0;
$device_id = isset($_GET['device']) && $_GET['device'] ? $_GET['device'] : $device_id;

$brand_id = isset($atts['brand']) && $atts['brand'] ? $atts['brand'] : 0;
$brand_id = isset($_GET['brand']) && $_GET['brand'] ? $_GET['brand'] : $brand_id;

$cat_id = isset($atts['model_cat']) && $atts['model_cat'] ? $atts['model_cat'] : 0;
$model_id = isset($_GET['model_cat']) && $_GET['model_cat'] ? $_GET['model_cat'] : $cat_id;

$model_id = isset($atts['model']) && $atts['model'] ? $atts['model'] : 0;
$model_id = isset($_GET['model']) && $_GET['model'] ? $_GET['model'] : $model_id;

$container_class .= $device_id ? " has-default-value" : '';

$service_layout = isset($atts['service_layout']) && $atts['service_layout'] ? ' service-layout-' . $atts['service_layout'] : '';
$container_class .= $service_layout;


?>
<div class="<?php echo esc_attr($container_class); ?>" data-device="<?php echo esc_attr($device_id); ?>"
     data-brand="<?php echo esc_attr($brand_id); ?>"
     data-cat="<?php echo esc_attr($cat_id);?>"
     data-model="<?php echo esc_attr($model_id); ?>">

    <?php include REVY_SC_TEMPLATE_PATH . '/partials/progress-bar.php'; ?>

    <div class="fat-sb-list-devices fat-sb-item-wrap">
        <?php include REVY_SC_TEMPLATE_PATH . '/partials/devices.php'; ?>
    </div>

    <?php if (is_array($atts) && isset($atts['layout']) && $atts['layout'] == 'brand-model'): ?>
        <div class="fat-sb-list-brand fat-sb-item-wrap fat-hidden-step">
            <?php include REVY_SC_TEMPLATE_PATH . '/partials/brands.php'; ?>
        </div>
        <div class="fat-sb-list-category fat-sb-item-wrap fat-hidden-step">
            <?php include REVY_SC_TEMPLATE_PATH . '/partials/category.php'; ?>
        </div>
        <div class="fat-sb-list-model fat-sb-item-wrap fat-hidden-step">
            <?php include REVY_SC_TEMPLATE_PATH . '/partials/models.php'; ?>
        </div>
    <?php endif; ?>

    <div class="fat-sb-list-services fat-sb-item-wrap fat-hidden-step">
        <?php
        if (!isset($atts['service_layout']) || $atts['service_layout'] != 'single') {
            include REVY_SC_TEMPLATE_PATH . '/partials/services.php';
        } else {
            include REVY_SC_TEMPLATE_PATH . '/partials/services-single.php';
        } ?>
    </div>

    <div class="fat-sb-list-delivery-method fat-sb-item-wrap fat-hidden-step">
        <?php include REVY_SC_TEMPLATE_PATH . '/partials/delivery-method.php'; ?>
    </div>

    <div class="fat-sb-list-garages fat-sb-item-wrap fat-hidden-step">
        <?php include REVY_SC_TEMPLATE_PATH . '/partials/garages.php'; ?>
    </div>

    <div class="fat-sb-order-wrap fat-hidden-step">
        <div class="fat-sb-head">
            <h4 class="fat-sb-title"><?php echo esc_html($setting['step_schedule_title']); ?></h4>
            <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_schedule_subtitle']); ?></div>
        </div>
        <div class="order-wrap-inner">
            <div class="fat-sb-col-left">
                <?php include REVY_SC_TEMPLATE_PATH . '/partials/customer-info.php';
                include REVY_SC_TEMPLATE_PATH . '/partials/weekly-calendar.php'; ?>
            </div>
            <div class="fat-sb-col-right">
                <?php include REVY_SC_TEMPLATE_PATH . '/partials/repair-summary.php'; ?>
            </div>
        </div>
    </div>

    <div class="fat-sb-appointment-booked-wrap fat-hidden-step">
        <div class="fat-sb-head">
            <h4 class="fat-sb-title"><?php echo esc_html($setting['step_booked_title']); ?></h4>
            <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_booked_subtitle']); ?></div>
            <div class="fat-sb-pdf-download">
                <a href="#" class="ui primary button"><?php echo esc_html__('Download PDF Order','revy');?></a>
            </div>
        </div>
    </div>

    <?php include REVY_SC_TEMPLATE_PATH . '/partials/auto-translate.php'; ?>

</div>
