<?php
/**
 * Created by PhpStorm.
 * User: roninwp
 * Date: 3/4/2019
 * Time: 3:54 PM
 */
?>
<div class="fat-sb-header">
    <img src="<?php echo esc_url(REVY_ASSET_URL . '/images/plugin_logo.png'); ?>">
    <div class="fat-sb-header-title"><?php echo esc_html__('SMS Template','revy'); ?></div>
</div>
<div class="fat-sb-email-template-container fat-sb-sms-template-container fat-semantic-container fat-min-height-300 fat-pd-right-15">
    <div class="ui card full-width">
        <div class="content">
            <div class="ui grid">
                <div class="four wide column">
                    <div class="ui vertical pointing menu fat-sb-template-tab">
                        <a class="item active" data-onClick="RevySMSTemplate.menuOnClick"
                           data-template="pending"
                           data-customer-title="<?php esc_attr_e('Booking Pending Template for Customer','revy'); ?>">
                            <?php esc_html_e('Booking Pending Template','revy'); ?>
                        </a>
                        <a class="item" data-onClick="RevySMSTemplate.menuOnClick"
                           data-template="approved"
                           data-customer-title="<?php esc_attr_e('Booking Approved Template for Customer','revy'); ?>">
                            <?php esc_html_e('Booking Approved Template','revy'); ?>
                        </a>
                        <a class="item" data-onClick="RevySMSTemplate.menuOnClick"
                           data-template="rejected"
                           data-customer-title="<?php esc_attr_e('Booking Rejected Template for Customer','revy'); ?>">
                            <?php esc_html_e('Booking Rejected Template','revy'); ?>
                        </a>
                        <a class="item" data-onClick="RevySMSTemplate.menuOnClick"
                           data-template="canceled"
                           data-customer-title="<?php esc_attr_e('Booking Canceled Template for Customer','revy'); ?>">
                            <?php esc_html_e('Booking Canceled Template','revy'); ?>
                        </a>

                    </div>

                    <div class="fat-email-keys">
                        <h4><?php esc_html_e('Please use keys bellow for email template','revy');?></h4>
                        <ul class="list-email-key">
                            <li><span>{booking_time}</span> : <?php esc_html_e('time of booking','revy');?> </li>
                            <li><span>{booking_date}</span> : <?php esc_html_e('date of booking','revy');?> </li>
                            <li><span>{garage_name}</span> : <?php esc_html_e('name of garage','revy');?> </li>
                            <li><span>{garage_address}</span> : <?php esc_html_e('address of garage','revy');?> </li>
                            <li><span>{garage_email}</span> : <?php esc_html_e('email of garage','revy');?> </li>
                            <li><span>{garage_phone}</span> : <?php esc_html_e('phone of garage','revy');?> </li>
                            <li><span>{brand_name}</span> : <?php esc_html_e('name of brand','revy');?> </li>
                            <li><span>{device_name}</span> : <?php esc_html_e('name of device','revy');?> </li>
                            <li><span>{model_name}</span> : <?php esc_html_e('name of model','revy');?> </li>
                            <li><span>{delivery_method}</span> : <?php esc_html_e('delivery method','revy');?> </li>
                            <li><span>{service_info}</span> : <?php esc_html_e('This is service information (service name, service attribute, duration ...)','revy');?> </li>
                            <li><span>{booking_price}</span> : <?php esc_html_e('total price of booking','revy');?> </li>
                            <li><span>{customer_first_name}</span> : <?php esc_html_e('customer first name','revy');?> </li>
                            <li><span>{customer_last_name}</span> : <?php esc_html_e('customer last name','revy');?> </li>
                            <li><span>{customer_address}</span> : <?php esc_html_e('customer address','revy');?> </li>
                            <li><span>{customer_city}</span> : <?php esc_html_e('customer city','revy');?> </li>
                            <li><span>{customer_country}</span> : <?php esc_html_e('customer country','revy');?> </li>
                            <li><span>{customer_postal_code}</span> : <?php esc_html_e('customer postal code','revy');?> </li>
                            <li><span>{customer_phone}</span> : <?php esc_html_e('customer phone','revy');?> </li>
                            <li><span>{customer_email}</span> : <?php esc_html_e('customer email','revy');?> </li>
                            <li><span>{company_phone}</span> : <?php esc_html_e('company phone','revy');?> </li>
                            <li><span>{company_name}</span> : <?php esc_html_e('company name','revy');?> </li>
                            <li><span>{company_address}</span> : <?php esc_html_e('company address','revy');?> </li>
                            <li><span>{company_email}</span> : <?php esc_html_e('company email','revy');?> </li>
                            <li><span>{payment_method}</span> : <?php esc_html_e('payment method','revy');?> </li>
                            <li><span>{serial_number}</span> : <?php esc_html_e('Serial number of IMEI','revy');?> </li>
                            <li><span>{notes}</span> : <?php esc_html_e('Notes','revy');?> </li>
                        </ul>
                        <p><?php esc_html_e('If you want to use the field in the booking formbuilder, use the field\'s name as the keyword. For example if the name of field is txtExtra then the keyword is {txtExtra}','revy');?></p>
                    </div>

                </div>
                <div class="twelve wide column">
                    <div class="fat-sb-pending-template">
                        <div class="fat-sb-checkbox-wrap right">
                            <h4 class="fat-sb-customer-label"><?php esc_html_e('Booking Pending Template for Customer','revy'); ?></h4>
                            <div class="ui toggle checkbox" data-tooltip="<?php esc_attr_e('On/Off send SMS  for customer','revy');?>" data-position="top right">
                                <input type="checkbox" name="customer_template_enable" id="customer_template_enable" data-onChange="RevySMSTemplate.dependFieldOnChange"
                                       value="1" checked>
                                <label>&nbsp;</label>
                            </div>
                        </div>

                        <div class="fields customer-template" data-depend="customer_template_enable">
                            <div class="field fat-editor">
                                <label><?php esc_html_e('Message','revy'); ?></label>
                                <textarea name="customer_template" id="customer_template" rows="3"></textarea>
                            </div>
                        </div>

                        <div class="fields">
                            <div class="field fat-text-right">
                                <div class="ui primary button" data-onClick="RevySMSTemplate.submitTemplate"
                                     data-invalid-message="<?php echo esc_attr__('Please input data ','revy');?>"
                                     data-success-message="<?php esc_attr_e('Template have been saved','revy');?>" >
                                    <?php echo esc_html__('Save','revy');?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>