<?php
/**
 * Created by PhpStorm.
 * User: roninwp
 * Date: 11/20/2018
 * Time: 10:42 AM
 */
?>
<div class="fat-sb-header">
    <img src="<?php echo esc_url(REVY_ASSET_URL.'/images/plugin_logo.png');?>">
    <div class="fat-sb-header-title"><?php echo esc_html__('Quote','revy');?></div>
</div>

<div class="fat-sb-quote-container fat-semantic-container fat-min-height-300 fat-pd-right-15">
    <div class="ui card full-width">
        <div class="content has-button-group">
            <div class="toolbox-action-group">
                <div class="ui transparent left icon input ui-search fat-sb-search no-border-radius fat-mg-right-10 " >
                    <input type="text" id="q_customer_name" id="q_customer_name" data-onKeyUp="RevyQuote.searchNameKeyup" autocomplete="nope"
                           placeholder="<?php echo esc_attr__('Search name or email ...','revy');?>">
                    <i class="search icon"></i>
                    <a class="fat-close" data-onClick="RevyQuote.closeSearchOnClick">
                        <i class="times icon"></i>
                    </a>
                </div>

                <div class="ui transparent left date-input input no-border-radius">
                    <?php
                    $start_date = current_time('mysql', 0);
                    $start_date = DateTime::createFromFormat('Y-m-d H:i:s', $start_date);
                    $end_date = new DateTime();
                    $end_date->modify('+6 day');
                    $date_format = get_option('date_format');
                    $locale = get_locale();
                    $locale = explode('_',$locale)[0];
                    ?>
                    <input type="text"  class="date-range-picker"  name="date_of_book" id="date_of_book" data-auto-update="1" data-onChange="RevyQuote.searchDateOnChange"
                           data-start="<?php echo esc_attr($start_date->format('Y-m-d'));?>" data-end="<?php echo esc_attr($end_date->format('Y-m-d'));?>"
                           data-locale="<?php echo esc_attr($locale);?>"
                           date-time-picker="1"
                           data-start-init="<?php echo date_i18n($date_format,$start_date->format('U'));?>"
                           data-end-init="<?php echo date_i18n($date_format,$end_date->format('U'));?>" >
                </div>

            </div>
        </div>
        <div class="content">
            <table class="ui single line table fat-sb-list-quotes">
                <thead>
                <tr>
                    <th><?php echo esc_html__('Create Date','revy');?></th>
                    <th><?php echo esc_html__('Customer','revy');?></th>
                    <th><?php echo esc_html__('Device type','revy');?></th>
                    <th><?php echo esc_html__('Brand name','revy');?></th>
                    <th><?php echo esc_html__('Model','revy');?></th>
                    <th><?php echo esc_html__('Color','revy');?></th>
                    <th><?php echo esc_html__('Serial','revy');?></th>
                  <!--  <th class="fat-sb-status"><?php /*echo esc_html__('Status','revy');*/?></th>-->
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <tr class="fat-tr-not-found">
                    <td colspan="8">
                        <div class="ui fluid placeholder">
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                            <div class="line"></div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>

            <div class="fat-sb-pagination" data-obj="RevyQuote" data-func="loadQuote">
            </div>
        </div>
    </div>
</div>