<?php
/*
Plugin Name: Revy
Plugin URI:  https://plugins.roninwp.com/revy/
Description: Revy - Online bookings system for car, mobile, computer, washing machine, plumb
Version:     2.5
Author:      Roninwp
Author URI:  https://codecanyon.net/user/roninwp/portfolio?ref=roninwp
Domain Path: /languages
Text Domain: revy
*/

if (!defined('ABSPATH')) die('-1');
if (!class_exists('Revy')) {
    class Revy
    {
        private static $instance = NULL;
        private static $version = '2.5';

        function __construct()
        {
            $this->init();
        }

        function init()
        {
            do_action('revy_before_init');

            spl_autoload_extensions(".php");
            spl_autoload_register(array($this, 'autoload'));

            $this->define_constants();
            $this->hook();
            $this->register_shortcode();
            $this->includes();

            do_action('revy_after_init');
        }

        private function autoload($class_name)
        {
            $class_name = strtolower($class_name);
            $class_name = 'class-' . str_replace('_', '-', $class_name) . '.php';
            $class_path = '';
            if (strrpos($class_name, 'revy-db') !== FALSE) {
                $class_path = REVY_DIR_PATH . "inc/db/{$class_name}";
            }
            if (strrpos($class_name, 'revy-menu') !== FALSE) {
                $class_path = REVY_DIR_PATH . "inc/menu/{$class_name}";
            }
            if (strrpos($class_name, 'revy-ajax') !== FALSE) {
                $class_path = REVY_DIR_PATH . "inc/ajax/{$class_name}";
            }
            if (strrpos($class_name, 'revy-utils') !== FALSE || strrpos($class_name, 'revy-import-export') !== FALSE) {
                $class_path = REVY_DIR_PATH . "inc/utils/{$class_name}";
            }

            if (strrpos($class_name, 'revy-shortcodes') !== FALSE) {
                $class_path = REVY_DIR_PATH . "shortcodes/{$class_name}";
            }
            if (strrpos($class_name, 'revy-payment') !== FALSE) {
                $class_path = REVY_DIR_PATH . "inc/payment/{$class_name}";
            }

            if (strrpos($class_name, 'ics') !== FALSE) {
                $class_path = REVY_DIR_PATH . "libs/{$class_name}";
            }
            if (is_readable($class_path)) {
                return require_once($class_path);
            }
            return false;
        }

        function define_constants()
        {
            defined('REVY_DIR_PATH') or define('REVY_DIR_PATH', plugin_dir_path(__FILE__));
            defined('REVY_SC_TEMPLATE_PATH') or define('REVY_SC_TEMPLATE_PATH', plugin_dir_path(__FILE__) . '/templates/shortcodes/');
            defined('REVY_PLUGIN_URL') or define('REVY_PLUGIN_URL', plugins_url('', __FILE__));
            defined('REVY_ASSET_URL') or define('REVY_ASSET_URL', plugins_url() . '/revy/assets/');
            defined('REVY_PLUGIN_VERSION') or define('REVY_PLUGIN_VERSION', Revy::$version);
        }

        private function hook()
        {
            register_activation_hook(__FILE__, array($this, 'plugin_activate'));
            $ajax_handlers = new Revy_Ajax_Handlers();
            if (is_admin()) {
                $menu_admin = new Revy_Menu_Admin();
                add_action('admin_enqueue_scripts', array($menu_admin, 'admin_enqueue_script'), 100);
                add_action('admin_init', array($ajax_handlers, 'setup_ajax_handler'));
                add_action('admin_menu', array($menu_admin, 'init_menu'));
                add_action('admin_init', array($this, 'reset_data'));

            }
            add_action('send_headers', array($this, 'payment_update_status'));
            add_action('init', array($ajax_handlers, 'setup_fe_ajax_handler'));
            add_action('plugins_loaded', array($this, 'load_text_domain'));

        }

        private function register_shortcode()
        {
            $shortcode = Revy_Shortcodes::instance();
            add_shortcode('rp', array($shortcode, 'revy_shortcode'));
            add_shortcode('rp_history', array($shortcode, 'history_shortcode'));
            add_shortcode('rp_quote_form', array($shortcode, 'revy_quote_form_shortcode'));

        }

        public function plugin_activate()
        {
            $table = Revy_DB_Table::instance();
            $table->create_tables();
            $table->update_tables();
            $table->syn_model_group();
        }

        function load_text_domain()
        {
            $domain = dirname(plugin_basename(__FILE__));
            $locale = apply_filters('plugin_locale', get_locale(), $domain);
            load_textdomain('revy', trailingslashit(WP_LANG_DIR) . 'plugins' . '/' . $domain . '-' . $locale . '.mo');
            load_plugin_textdomain('revy', false, basename(dirname(__FILE__)) . '/languages/');
        }

        public function require_file($path)
        {
            if (is_readable($path)) {
                require_once($path);
                return true;
            } else {
                return false;
            }
        }

        public function includes()
        {
            $setting = Revy_DB_Setting::instance();
            $setting = $setting->get_setting();
            if (isset($setting['default_payment_method']) && $setting['default_payment_method'] == 'woocommerce') {
                $this->require_file(REVY_DIR_PATH . "inc/payment/class-revy-wc.php");
            }
        }

        public function payment_update_status()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'revy_booking' && isset($_GET['token'])) {
                $payment = new Revy_Payment();
                $payment->payment_update_status();
            }
        }

        public function reset_data(){
            if (isset($_GET['action']) && $_GET['action'] === 'revy_reset_data') {
                global $wpdb;
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_booking");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_booking AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_booking_detail");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_booking_detail AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_devices");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_devices AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_brands");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_brands AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_models");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_models AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_garages");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_garages AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services_garage");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services_garage AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services_price");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services_price AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services_schedule");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services_schedule AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services_day_off");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services_day_off AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_customers");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_customers AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_coupons");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_coupons AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_coupon_logs");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_coupon_logs AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_services_product");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_services_product AUTO_INCREMENT = 1 ");
                $wpdb->query("DELETE FROM {$wpdb->prefix}rp_wc_order_service");
                $wpdb->query("ALTER TABLE {$wpdb->prefix}rp_wc_order_service AUTO_INCREMENT = 1 ");

                add_action('admin_notices',array($this,'reset_data_notice'));

            }
        }

        public function reset_data_notice(){
            ?>
            <div class="notice notice-success repair-booking-notice">
                <p><?php echo esc_html__('Data has been deleted','revy'); ?></p>
            </div>
            <?php
        }

        public static function getInstance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

    }

    Revy::getInstance();
}

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}