<?php
/**
 * Created by PhpStorm.
 * User: roninwp
 * Date: 6/19/2020
 * Time: 10:38 AM
 */

if (!class_exists('Revy_DB_Bookings')) {
    class Revy_DB_Bookings
    {
        private static $instance = NULL;

        public static function instance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        public function get_insight()
        {
            global $wpdb;
            $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
            $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
            $b_garage = isset($_REQUEST['garage']) && $_REQUEST['garage'] ? $_REQUEST['garage'] : '';

            if ($start_date == '') {
                $now = new DateTime();
                $start_date = $now->format('Y-m-d');
            }
            if ($end_date == '') {
                $now = new DateTime();
                $end_date = $now->modify('+6 day')->format('Y-m-d');
            }

            $sql = "SELECT b_id, b_date, b_time, b_gateway_status, b_gateway_type, b_total_pay, b_process_status, b_pay_now, c_create_date
                                        FROM {$wpdb->prefix}rp_booking 
                                        LEFT JOIN {$wpdb->prefix}rp_customers 
                                        ON b_customer_id = c_id
                                        WHERE b_process_status !=-1 AND DATE(b_date) BETWEEN %s AND %s";

            if ($b_garage && is_array($b_garage)) {
                $b_garage = Revy_Utils::prepareIn($b_garage);
                $sql .= " AND b_garage_id IN ({$b_garage})";
            }

            $sql .= " ORDER BY b_date";
            $sql = $wpdb->prepare($sql, $start_date, $end_date);
            $bookings = $wpdb->get_results($sql);
            $result = array(
                'revenue' => array(),
                'service_emp_chart' => array(
                    'employees' => array(),
                    'services' => array(),
                    'categories' => array()
                ),
                'new_customer' => 0,
                'return_customer' => 0,
                'booking_approved' => 0,
                'booking_pending' => 0,
                'booking_rejected' => 0,
                'booking_canceled' => 0,
                'total_revenue' => 0
            );

            $start_date = DateTime::createFromFormat('Y-m-d H:i:s', $start_date . ' 00:00:00');
            $end_date = DateTime::createFromFormat('Y-m-d H:i:s', $end_date . ' 23:59:59');

            $revenue = array();
            $services = array();
            $b_ids = array();
            foreach ($bookings as $b) {
                $b_ids[] = $b->b_id;
                if ($b->b_gateway_status == 1 || $b->b_pay_now==1) {
                    $result['total_revenue'] += $b->b_total_pay;

                    if (array_key_exists($b->b_date, $revenue)) {
                        $revenue[$b->b_date] += (float)$b->b_total_pay;
                    } else {
                        $revenue[$b->b_date] = (float)$b->b_total_pay;
                    }
                }

                if ($start_date <= $b->c_create_date && $b->c_create_date <= $start_date) {
                    $result['new_customer'] += 1;
                } else {
                    $result['return_customer'] += 1;
                }

                if ($b->b_process_status == 0) {
                    $result['booking_pending'] += 1;
                }

                if ($b->b_process_status == 1) {
                    $result['booking_approved'] += 1;
                }

                if ($b->b_process_status == 2) {
                    $result['booking_canceled'] += 1;
                }

                if ($b->b_process_status == 3) {
                    $result['booking_rejected'] += 1;
                }

            }

            if(count($b_ids) > 0){
                $b_ids = implode(',', $b_ids);
                $sql = "SELECT RB.b_date, RDB.b_service_id 
                    FROM {$wpdb->prefix}rp_booking AS RB  
                    LEFT JOIN {$wpdb->prefix}rp_booking_detail AS RDB
                    ON RB.b_id = RDB.b_id
                    WHERE RB.b_id IN ({$b_ids})";
                $booking_detail = $wpdb->get_results($sql);
                foreach ($booking_detail as $bd) {
                    if (!isset($services[$bd->b_date]) || !in_array($bd->b_service_id, $services[$bd->b_date])) {
                        $services[$bd->b_date][] = $bd->b_service_id;
                    }
                }
            }

            $diff_day = $end_date->diff($start_date)->days;
            $date = '';
            for ($i = 0; $i <= $diff_day; $i++) {
                $start_date = $i == 0 ? $start_date : $start_date->modify('+1 days');
                $date = $start_date->format('Y-m-d');
                if (!isset($revenue[$date])) {
                    $result['revenue'][] = 0;
                } else {
                    $result['revenue'][] = $revenue[$date];
                }

                $result['service_emp_chart']['services'][] = is_array($services) && isset($services[$date]) ? count($services[$date]) : 0;
                $result['service_emp_chart']['categories'][] = $date;
            }
            return $result;
        }

        public function get_booking()
        {
            global $wpdb;
            $page = isset($_REQUEST['page']) && $_REQUEST['page'] ? $_REQUEST['page'] : 1;
            $b_customer_name = isset($_REQUEST['b_customer_name']) && $_REQUEST['b_customer_name'] ? $_REQUEST['b_customer_name'] : '';
            $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
            $start_time = isset($_REQUEST['start_time']) && $_REQUEST['start_time'] ? $_REQUEST['start_time'] : '00:00';
            $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
            $end_time = isset($_REQUEST['end_time']) && $_REQUEST['end_time'] ? $_REQUEST['end_time'] : '23:59';
            $b_customer = isset($_REQUEST['b_customer']) && $_REQUEST['b_customer'] ? $_REQUEST['b_customer'] : '';
            $b_service = isset($_REQUEST['b_service']) && $_REQUEST['b_service'] ? $_REQUEST['b_service'] : '';
            $b_process_status = isset($_REQUEST['b_process_status']) ? $_REQUEST['b_process_status'] : '';
            $order = isset($_REQUEST['order']) && $_REQUEST['order'] ? $_REQUEST['order'] : 'DESC';
            $order_by = isset($_REQUEST['order_by']) && $_REQUEST['order_by'] ? $_REQUEST['order_by'] : 'b_date';
            $b_garage = isset($_REQUEST['garage']) && $_REQUEST['garage'] ? $_REQUEST['garage'] : '';
            $b_delivery_method = isset($_REQUEST['b_delivery_method']) && $_REQUEST['b_delivery_method'] ? $_REQUEST['b_delivery_method'] : '';

            $sql = "SELECT b_date, b_time, b_id, b_customer_id, c_first_name, c_last_name, c_email, c_phone_code, c_phone, rm_name, b_gateway_type, 
                            b_gateway_status, b_total_pay, b_process_status, b_create_date, b_delivery_method, b_group_name, b_delivery_fee
                    FROM {$wpdb->prefix}rp_booking
                    LEFT JOIN {$wpdb->prefix}rp_customers ON b_customer_id = c_id
                    LEFT JOIN {$wpdb->prefix}rp_models ON b_model_id = rm_id
                    WHERE  b_process_status!=-1 ";
            if ($b_customer_name) {
                $search_key = '%'.$b_customer_name.'%';
                $sql .= " AND (c_first_name LIKE %s OR c_last_name LIKE %s OR c_email LIKE %s) ";
                $sql = $wpdb->prepare($sql, $search_key, $search_key, $search_key);
            }

            if ($b_customer && is_array($b_customer)) {
                $b_customer = Revy_Utils::prepareIn($b_customer);
                $sql .= " AND b_customer_id IN ({$b_customer})";
            }

            if ($b_service && is_array($b_service)) {
                $b_service = Revy_Utils::prepareIn($b_service);
                $sql .= " AND b_id IN (SELECT b_id FROM {$wpdb->prefix}rp_booking_detail WHERE b_service_id IN ({$b_service}) )";
            }

            if ($b_garage && is_array($b_garage)) {
                $b_garage = Revy_Utils::prepareIn($b_garage);
                $sql .= " AND b_garage_id IN ({$b_garage})";
            }

            if ($b_delivery_method != '') {
                $sql .= " AND b_delivery_method = %s";
                $sql = $wpdb->prepare($sql, $b_delivery_method);
            }

            if ($b_process_status != '') {
                $sql .= " AND b_process_status = %d";
                $sql = $wpdb->prepare($sql, $b_process_status);
            }

            if ($start_date && $end_date) {
                $sql .= " AND DATE(b_date) BETWEEN %s AND %s";
                $sql = $wpdb->prepare($sql, $start_date, $end_date);
            }

            $use_info = Revy_Utils::get_user_info();

            $order_sql = sanitize_sql_orderby("{$order_by} {$order}");
            $sql .= " ORDER BY {$order_sql}";
            $bookings = $wpdb->get_results($sql);
            $hours = Revy_Utils::getDurations(1, 'duration_step');

            $total_cancel = 0;
            $total_pending = 0;
            $total_reject = 0;
            $total_approved = 0;

            $b_date = '';
            $now = current_time('mysql', 0);
            $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);

            $start_date_time = DateTime::createFromFormat('Y-m-d H:i', $start_date . ' ' . $start_time);
            $end_date_time = DateTime::createFromFormat('Y-m-d H:i', $end_date . ' ' . $end_time);
            $bookings_filter = array();

            $delivery_method = array(
                1 => esc_html__('Fixit Home','revy'),
                2 => esc_html__('Carry In','revy'),
                3 => esc_html__('Mail In','revy')
            );
            foreach ($bookings as $booking) {
                $booking->c_phone_code = explode(',', $booking->c_phone_code)[0];
                $booking->b_delivery_method_label = $delivery_method[$booking->b_delivery_method];
                $booking->rm_name .= isset($booking->b_group_name) && $booking->b_group_name ? (' - '.$booking->b_group_name) : '';
                if ($booking->b_process_status == 0) {
                    $total_pending++;
                }
                if ($booking->b_process_status == 1) {
                    $total_approved++;
                }
                if ($booking->b_process_status == 2) {
                    $total_cancel++;
                }
                if ($booking->b_process_status == 3) {
                    $total_reject++;
                }

                $booking->editable = 1;
                /*if($booking->b_delivery_method == 2){ //Carry In
                    $booking->editable = 0;
                    $b_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking->b_date . ' 00:00:00');
                    $b_date->modify("+{$booking->b_time} minutes");
                    if ($b_date >= $start_date_time && $b_date <= $end_date_time) {
                        $booking->editable = $b_date > $now ? 1 : 0;
                    }
                }*/
                $bookings_filter[] = $booking;
            }

            $bookings = $bookings_filter;
            $total = count($bookings);

            $db_setting = Revy_DB_Setting::instance();
            $setting = $db_setting->get_setting();

            $item_per_page = isset($setting['item_per_page']) ? $setting['item_per_page'] : 10;
            $number_of_page = $total / $item_per_page + ($total % $item_per_page > 0 ? 1 : 0);
            $page = $page > $number_of_page ? $number_of_page : $page;
            $page = ($page - 1) * $item_per_page;
            $bookings = array_slice($bookings, $page, $item_per_page);

            $booking_detail = array();
            if (count($bookings) > 0) {
                $b_ids = array();
                foreach ($bookings as $bk) {
                    $b_ids[] = $bk->b_id;
                }
                $b_ids = implode(',', $b_ids);
                $sql = "SELECT RDB.b_id, RDB.b_model_name, RDB.b_model_color, RDB.b_service_id, S.s_name, RDB.b_service_duration, RDB.b_attr_title, RDB.b_attr_value, RDB.b_price, RDB.b_service_tax_amount  
                    FROM {$wpdb->prefix}rp_booking_detail AS RDB
                    LEFT JOIN {$wpdb->prefix}rp_services AS S
                    ON RDB.b_service_id = S.s_id
                    WHERE RDB.b_id IN ({$b_ids})";
                $booking_detail = $wpdb->get_results($sql);
            }

            return array(
                'total' => $total,
                'bookings' => $bookings,
                'booking_detail' => $booking_detail,
                'total_cancel' => $total_cancel,
                'total_approved' => $total_approved,
                'total_pending' => $total_pending,
                'total_reject' => $total_reject,

            );
        }

        public function get_booking_export()
        {
            global $wpdb;
            $b_customer_name = isset($_REQUEST['b_customer_name']) && $_REQUEST['b_customer_name'] ? $_REQUEST['b_customer_name'] : '';
            $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
            $start_time = isset($_REQUEST['start_time']) && $_REQUEST['start_time'] ? $_REQUEST['start_time'] : '00:00';
            $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
            $end_time = isset($_REQUEST['end_time']) && $_REQUEST['end_time'] ? $_REQUEST['end_time'] : '23:59';
            $b_customer = isset($_REQUEST['b_customer']) && $_REQUEST['b_customer'] ? $_REQUEST['b_customer'] : '';
            $b_service = isset($_REQUEST['b_service']) && $_REQUEST['b_service'] ? $_REQUEST['b_service'] : '';
            $b_process_status = isset($_REQUEST['b_process_status']) ? $_REQUEST['b_process_status'] : '';
            $b_garage = isset($_REQUEST['garage']) && $_REQUEST['garage'] ? $_REQUEST['garage'] : '';
            $b_delivery_method = isset($_REQUEST['b_delivery_method']) && $_REQUEST['b_delivery_method'] ? $_REQUEST['b_delivery_method'] : '';

            $sql = "SELECT b_date, b_time, b_id, rm_name, G.rg_name, G.rg_address, b_customer_address, b_customer_city, b_customer_country, b_customer_postal_code, 
                            b_customer_id, c_first_name, c_last_name, c_email, c_phone, b_gateway_type, b_gateway_status, b_total_pay, b_process_status
                    FROM {$wpdb->prefix}rp_booking AS B
                    LEFT JOIN {$wpdb->prefix}rp_garages AS G
                    ON B.b_garage_id = G.rg_id
                    LEFT JOIN {$wpdb->prefix}rp_models AS M
                    ON B.b_model_id = M.rm_id
                    LEFT JOIN {$wpdb->prefix}rp_customers AS C 
                    ON B.b_customer_id = C.c_id
                    WHERE  b_process_status!= -1 ";
            if ($b_customer_name) {
                $search_key = '%'.$b_customer_name.'%';
                $sql .= " AND (c_first_name LIKE %s OR c_last_name LIKE %s OR c_email LIKE %s) ";
                $sql = $wpdb->prepare($sql, $search_key, $search_key, $search_key);
            }
            if ($b_customer && is_array($b_customer)) {
                $b_customer = Revy_Utils::prepareIn($b_customer);
                $sql .= " AND b_customer_id IN ({$b_customer})";
            }
            if ($b_service && is_array($b_service)) {
                $b_service = Revy_Utils::prepareIn($b_service);
                $sql .= " AND b_service_id IN ({$b_service})";
            }
            if ($b_garage && is_array($b_garage)) {
                $b_garage = Revy_Utils::prepareIn($b_garage);
                $sql .= " AND b_garage_id IN ({$b_garage})";
            }
            if ($b_process_status != '') {
                $sql .= " AND b_process_status = %d";
                $sql = $wpdb->prepare($sql, $b_process_status);
            }

            if ($start_date && $end_date) {
                $sql .= " AND DATE(b_date) BETWEEN %s AND %s";
                $sql = $wpdb->prepare($sql, $start_date, $end_date);
            }

            $sql .= " ORDER BY b_id DESC";
            $bookings = $wpdb->get_results($sql);

            $b_ids = array();
            foreach ($bookings as $bk) {
                $b_ids[] = $bk->b_id;
            }

            $b_ids = implode(',', $b_ids);
            $sql = "SELECT b_id, b_model_name, b_model_color, b_service_id, S.s_name, b_attr_title, b_attr_value, b_price
                    FROM {$wpdb->prefix}rp_booking_detail AS RDB
                    LEFT JOIN {$wpdb->prefix}rp_services AS S
                    ON RDB.b_service_id = S.s_id
                    WHERE b_id IN ({$b_ids})";
            $booking_detail = $wpdb->get_results($sql);
            foreach($booking_detail as $bd){
                $services[$bd->b_id][] = $bd;
            }

            return array(
                'booking' => $bookings,
                'booking_detail' => $booking_detail
            );
        }

        public function get_booking_calendar()
        {
            global $wpdb;
            $from_date = isset($_REQUEST['from_date']) && $_REQUEST['from_date'] ? $_REQUEST['from_date'] : (new DateTime())->format('Y-m-d');
            $to_date = isset($_REQUEST['to_date']) && $_REQUEST['to_date'] ? $_REQUEST['to_date'] : (new DateTime())->format('Y-m-d');
            $b_customer = isset($_REQUEST['customer']) && $_REQUEST['customer'] ? $_REQUEST['customer'] : '';
            $b_service = isset($_REQUEST['service']) && $_REQUEST['service'] ? $_REQUEST['service'] : '';
            $b_process_status = isset($_REQUEST['b_process_status']) && $_REQUEST['b_process_status'] ? $_REQUEST['b_process_status'] : '';
            $b_garage = isset($_REQUEST['garage']) && $_REQUEST['garage'] ? $_REQUEST['garage'] : '';

            $sql = "SELECT b_date, b_id, b_customer_id, c_first_name, c_last_name, c_email, rm_name, b_date, b_time, b_process_status, rg_name, rg_address
                    FROM {$wpdb->prefix}rp_booking AS RB
                    LEFT JOIN {$wpdb->prefix}rp_models ON b_model_id = rm_id
                    LEFT JOIN {$wpdb->prefix}rp_customers ON b_customer_id = c_id
                    LEFT JOIN {$wpdb->prefix}rp_garages ON b_garage_id = rg_id
                    WHERE  b_process_status!=-1 AND DATE(b_date) BETWEEN %s AND %s ";

            $sql = $wpdb->prepare($sql, $from_date, $to_date);

            if ($b_customer && is_array($b_customer)) {
                $b_customer = Revy_Utils::prepareIn($b_customer);
                $sql .= " AND b_customer_id IN ({$b_customer}) ";
            }

            if ($b_service && is_array($b_service)) {
                $b_service = Revy_Utils::prepareIn($b_service);
                $sql .= " AND b_id IN (SELECT b_id FROM {$wpdb->prefix}rp_booking_detail WHERE b_service_id IN ({$b_service}) )";
            }

            if ($b_garage && is_array($b_garage)) {
                $b_garage = Revy_Utils::prepareIn($b_garage);
                $sql .= " AND b_garage_id IN ({$b_garage})";
            }

            if ($b_process_status) {
                $sql .= " AND b_process_status = %d";
                $sql = $wpdb->prepare($sql, $b_process_status);
            }

            $use_info = Revy_Utils::get_user_info();
            if ($use_info['is_admin'] == 0) {
                $sql .= " AND b_employee_id = %d";
                $sql = $wpdb->prepare($sql, $use_info['e_id']);
            }

            $bookings = $wpdb->get_results($sql);
            $result = array();
            $color = array(
                0 => '#fbbd08',
                1 => '#21ba45',
                2 => '#db2828',
                3 => '#b5b5b5'
            );
            $now = current_time('mysql', 0);
            $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
            $b_ids = array();
            foreach ($bookings as $booking) {
                $b_ids[] = $booking->b_id;
                $start = DateTime::createFromFormat('Y-m-d H:i:s', $booking->b_date . ' 00:00:00');
                $start->modify("+{$booking->b_time} minutes");
                $end = clone $start;
                $result[] = array(
                    'id' => $booking->b_id,
                    'title' => $booking->c_first_name . ' ' . $booking->c_last_name . ' - ' . $booking->rm_name,
                    'model_name' => $booking->rm_name,
                    'start' => $start->format('Y-m-d H:i:s'),
                    'end' => $end->format('Y-m-d H:i:s'),
                    'color' => isset($color[$booking->b_process_status]) ? $color[$booking->b_process_status] : $color[0],
                    //'service' => $booking->s_name,
                    'customer' => $booking->c_first_name . ' ' . $booking->c_last_name,
                    'time' =>  $start->format('H:i'),
                    'garage' => $booking->rg_name,
                    'garage_address' => $booking->rg_address,
                    'b_editable' => $start > $now ? 1 : 0
                );
            }

            $booking_detail = array();
            if (count($b_ids) > 0) {
                $b_ids = implode(',', $b_ids);
                $sql = "SELECT RDB.b_id, RDB.b_service_id, S.s_name, RDB.b_service_duration, RDB.b_attr_title, RDB.b_attr_value, RDB.b_price, RDB.b_service_tax_amount  
                    FROM {$wpdb->prefix}rp_booking_detail AS RDB
                    LEFT JOIN {$wpdb->prefix}rp_services AS S
                    ON RDB.b_service_id = S.s_id
                    WHERE RDB.b_id IN ({$b_ids})";
                $booking_detail = $wpdb->get_results($sql);
            }
            return array(
                'bookings' => $result,
                'booking_detail' => $booking_detail,
                'date' => $from_date
            );
        }

        public function get_booking_by_id()
        {
            $b_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : 0;
            global $wpdb;
            $result['booking'] = array(
                'b_id' => 0,
                'b_quantity' => 1,
                'b_gateway_type' => 'onsite'
            );
            if ($b_id) {
                $sql = "SELECT  b_id, rg_name, c_first_name, c_last_name, b_customer_address, b_customer_city, b_customer_country, b_customer_postal_code, b_garage_id, rd_name, 
                                rb_name, rm_name, b_date, b_time, b_total_tax, b_total_amount, b_coupon_code, b_discount, b_total_pay, b_gateway_type, b_gateway_status, 
                                b_process_status, b_description, b_create_date, b_pay_now, b_send_notify, b_status_note, b_canceled_by_client, b_delivery_method, b_serial_number, 
                                b_notes, b_custom_field
                        FROM {$wpdb->prefix}rp_booking AS RB
                        LEFT JOIN {$wpdb->prefix}rp_models AS RM
                        ON RB.b_model_id = RM.rm_id
                        LEFT JOIN {$wpdb->prefix}rp_devices AS RD
                        ON RM.rm_device_id = RD.rd_id
                        LEFT JOIN {$wpdb->prefix}rp_brands AS B
                        ON RM.rm_brand_id = B.rb_id
                        LEFT JOIN  {$wpdb->prefix}rp_customers AS C
                        ON RB.b_customer_id = C.c_id
                        LEFT JOIN  {$wpdb->prefix}rp_garages AS G
                        ON RB.b_garage_id = G.rg_id
                        WHERE b_id=%d";

                $sql = $wpdb->prepare($sql, $b_id);
                $booking = $wpdb->get_results($sql);

                $setting = Revy_DB_Setting::instance();
                if (count($booking) > 0) {
                    $sql = "SELECT  RBD.b_model_name, RBD.b_model_color, S.s_name, S.s_id,  RBD.b_service_id, RBD.b_service_duration, RBD.b_service_break_time, RBD.b_attr_title, RBD.b_attr_value, RBD.b_quantity, 
                                    RBD.b_price, RBD.b_service_tax, RBD.b_service_tax_amount
                           FROM {$wpdb->prefix}rp_booking_detail AS RBD
                           LEFT JOIN {$wpdb->prefix}rp_services AS S
                            ON RBD.b_service_id = S.s_id
                            WHERE RBD.b_id = %d";
                    $sql = $wpdb->prepare($sql, $b_id);
                    $result['booking_detail'] = $wpdb->get_results($sql);
                    foreach ($result['booking_detail'] as $bk) {
                        $bk->b_price_label = $setting->formatCurrency($bk->b_price);
                        $bk->b_tax_label = $setting->formatCurrency($bk->b_service_tax_amount);
                    }

                    $booking = $booking[0];
                    $booking->b_sub_total = $booking->b_total_amount - $booking->b_total_tax;
                    $booking->b_sub_total_label =  $setting->formatCurrency($booking->b_sub_total);
                    $booking->b_total_amount_label = $setting->formatCurrency($booking->b_total_amount);
                    $booking->b_total_pay_label = $setting->formatCurrency($booking->b_total_pay);
                    $booking->b_discount_label = $setting->formatCurrency($booking->b_discount);
                    $booking->b_total_tax_label = $setting->formatCurrency($booking->b_total_tax);
                    $booking->b_custom_field =  $booking->b_custom_field !='' ? unserialize($booking->b_custom_field) : '';
                    $result['booking'] = $booking;
                }
            }

            return $result;
        }

        public function get_time_slot_available()
        {
            $booking_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : 0;
            $s_id = isset($_REQUEST['s_id']) ? $_REQUEST['s_id'] : '';
            $loc_id = isset($_REQUEST['loc_id']) ? $_REQUEST['loc_id'] : '';
            $day_in_week = isset($_REQUEST['day_in_week']) ? $_REQUEST['day_in_week'] : '';
            $date = isset($_REQUEST['date']) ? $_REQUEST['date'] : '';
            $number_of_device = isset($_REQUEST['number_of_device']) ? $_REQUEST['number_of_device'] : '';
            if ($s_id && $loc_id && $day_in_week && $date && $number_of_device) {
                global $wpdb;

                //get service
                $sql = "SELECT  s_maximum_slot, s_duration, s_break_time 
                        FROM {$wpdb->prefix}rp_services 
                        WHERE s_id = %d";
                $sql = $wpdb->prepare($sql, $s_id);
                $services = $wpdb->get_results($sql);
                $s_maximum_slot = isset($services[0]) ? $services[0]->s_maximum_slot : 1;
                $s_break_time = isset($services[0]) && $services[0]->s_break_time ? $services[0]->s_break_time : 0;
                $s_duration = isset($services[0]) && $services[0]->s_duration ? $services[0]->s_duration : 0;

                //check the date is day off
                $sql = "SELECT 1 FROM {$wpdb->prefix}rp_services_day_off WHERE s_id=%d AND dof_start <= %s AND dof_end >= %s";
                $sql = $wpdb->prepare($sql, $s_id, $date, $date);
                $day_off = $wpdb->get_results($sql);
                if (is_countable($day_off) && count($day_off) > 0) {
                    return array();
                }

                //get booking in this day
                $sql = "SELECT b_garage_id, b_service_id, b_date, b_time, b_service_duration, b_service_break_time, SUM(b_quantity) AS total_book
                        FROM {$wpdb->prefix}rp_booking
                        WHERE b_date = %s AND  b_service_id=%d";
                if ($booking_id) {
                    $sql .= " AND b_id != %d" ;
                    $sql = $wpdb->prepare($sql, $booking_id);
                }
                $sql .= " GROUP BY b_garage_id, b_service_id, b_date, b_time, b_service_duration, b_service_break_time ";
                $sql = $wpdb->prepare($sql, $date, $s_id);
                $booking = $wpdb->get_results($sql);

                //get work hour
                $sql = "SELECT ss_work_hour_start, ss_work_hour_end FROM {$wpdb->prefix}rp_services_schedule WHERE s_id=%d AND ss_day=%s";
                $sql = $wpdb->prepare($sql, $s_id, $day_in_week);
                $work_hours = $wpdb->get_results($sql);

                $db_setting = Revy_DB_Setting::instance();
                $db_setting = $db_setting->get_setting();
                $time_step = isset($db_setting['time_step']) ? $db_setting['time_step'] : 15;
                $duration_label = Revy_Utils::getWorkHours(5);
                $steps = Revy_Utils::getWorkHours(5);

                $time_slot = [];
                $wh_start = 0;
                $wh_end = 0;
                $now = current_time('mysql', 0);
                $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                $date_is_now = $now->format('Y-m-d') == $date;
                $now_minute = (intval($now->format('G')) * 60) + intval($now->format('i'));
                $end_day_minute = 24 * 60;
                $is_free = 1;
                $seat_available = 0;
                foreach ($work_hours as $wh) {
                    $wh_start = $wh->ss_work_hour_start;
                    $wh_end = $wh->ss_work_hour_end;
                    $is_free = 1;
                    $slot_end = 0;
                    for ($slot = $wh_start; $slot < $wh_end; $slot = $slot + $time_step + $s_break_time) {
                        if (($date_is_now && $slot < $now_minute) || (($slot_end + $s_break_time) >= $end_day_minute)) {
                            break;
                        }
                        $slot_end = $slot + $s_duration;
                        $seat_available = $s_maximum_slot;
                        foreach ($booking as $bk) {
                            if ($bk->b_service_id == $s_id && $bk->b_garage_id == $loc_id && $bk->b_time == $slot && ($bk->b_time + $bk->b_service_duration) == $slot_end) {
                                $seat_available = $s_maximum_slot - $bk->total_book;
                                $is_free = $seat_available >= 1;
                            } else {
                                $is_free = $slot >= ($bk->b_time + $bk->b_service_duration + $bk->b_service_break_time) || ($slot + $s_break_time + $s_duration) <= $bk->b_time;
                            }
                            if (!$is_free) {
                                break;
                            }
                        }
                        if ($is_free) {
                            $time_slot[] = array(
                                'slot' => $slot,
                                'min_seat' => 1,
                                'max_seat' => $seat_available,
                                'label' => $steps[$slot] . (isset($steps[$slot_end]) && $s_duration ? ' - ' . $steps[$slot_end] : '')
                            );
                        }
                    }
                }

                return $time_slot;
            }
        }

        public function save_booking()
        {
            $b_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : '';
            $b_date = isset($_REQUEST['date']) ? $_REQUEST['date'] : '';
            $b_time = isset($_REQUEST['time']) ? $_REQUEST['time'] : '';
            $b_serial_number = isset($_REQUEST['b_serial_number']) ? $_REQUEST['b_serial_number'] : '';
            $b_notes = isset($_REQUEST['b_notes']) ? $_REQUEST['b_notes'] : '';
            $pay_now = isset($_REQUEST['pay_now']) ? $_REQUEST['pay_now'] : '';
            $b_custom_field = isset($_REQUEST['b_custom_field']) ? serialize($_REQUEST['b_custom_field']) : '';

            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            $hide_date_time = isset($setting['hide_date_time']) && $setting['hide_date_time']=='1' ;

            if ($b_id && $b_date!='' && ($b_time || $hide_date_time) && ($pay_now==1 || $pay_now==0)) {
                global $wpdb;
                $sql = "SELECT b_id, b_garage_id, b_pay_now, b_date, b_time, b_delivery_method FROM {$wpdb->prefix}rp_booking AS RB WHERE b_id = %d";
                $sql = $wpdb->prepare($sql, $b_id);
                $booking = $wpdb->get_results($sql);
                if (!isset($booking[0])) {
                    return;
                }
                $booking = $booking[0];

                //not change
                if ($booking->b_date == $b_date && $booking->b_time == $b_time && $booking->b_pay_now == $pay_now) {
                    $sql = "UPDATE {$wpdb->prefix}rp_booking SET b_serial_number=%s, b_notes=%s, b_custom_field=%s WHERE b_id = %d";
                    $sql = $wpdb->prepare($sql,  $b_serial_number, $b_notes, $b_custom_field, $b_id);
                    $wpdb->query($sql);
                    return array(
                        'result' => 1
                    );
                }

                // update pay now
                if ($booking->b_date == $b_date && $booking->b_time == $b_time && $booking->b_pay_now != $pay_now) {
                    $b_gateway_status = $pay_now==1 ? 1 : 0;
                    $sql = "UPDATE {$wpdb->prefix}rp_booking SET b_pay_now=%d, b_gateway_status=%d, b_serial_number=%s, b_notes=%s WHERE b_id = %d";
                    $sql = $wpdb->prepare($sql, $pay_now, $pay_now, $b_serial_number, $b_notes, $b_id);
                    $result = $wpdb->query($sql);
                    return array(
                        'result' => $result,
                    );
                }

                //process update b_date, b_time and may be pay now
                $sql = "SELECT b_service_id, b_service_duration, b_service_break_time, S.s_maximum_slot, b_quantity
                        FROM {$wpdb->prefix}rp_booking_detail AS RDB
                         LEFT JOIN {$wpdb->prefix}rp_services AS S
                         ON RDB.b_service_id = S.s_id
                         WHERE b_id = %d";
                $sql = $wpdb->prepare($sql, $b_id);
                $booking_detail = $wpdb->get_results($sql);
                $data = array(
                    'b_date' => $b_date,
                    'b_time' => $b_time,
                    'c_email' => '', //ignore check limit customer
                );

                $is_valid_limit = $this->validate_booking($data);
                if (is_array($is_valid_limit) && $is_valid_limit['result'] < 0) {
                    return array(
                        'result' => -1,
                        'message' => $is_valid_limit['message']
                    );
                }

                //validate
                $is_valid_time_slot = array('valid' => true);
                if(!$hide_date_time){
                    foreach ($booking_detail as $bd) {
                        $is_valid_time_slot = $this->validate_booking_slot($b_id, $bd->b_service_id, $bd->b_service_break_time, $bd->b_service_duration,
                            $bd->s_maximum_slot, $booking->b_garage_id, $b_date, $b_time, $bd->b_quantity);
                        if (!$is_valid_time_slot['valid']) {
                            return array(
                                'result' => -1,
                                'message' => $is_valid_time_slot['message']
                            );
                        }
                    }
                }

                $sql = "UPDATE {$wpdb->prefix}rp_booking SET b_date=%s, b_time=%d, b_pay_now=%d, b_gateway_status=%d, b_serial_number=%s, b_notes=%s, b_custom_field=%s WHERE b_id = %d";
                $sql = $wpdb->prepare($sql, $b_date, $b_time, $pay_now, $pay_now, $b_serial_number, $b_notes, $b_custom_field, $b_id);
                $result = $wpdb->query($sql);
                return array(
                    'result' => $result,
                );


            } else {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Invalid data', 'revy')
                );
            }

        }

        public function save_booking_fe()
        {
            $data = isset($_REQUEST['data']) ? $_REQUEST['data'] : '';
            $services_selected = isset($_REQUEST['services']) ? $_REQUEST['services'] : array();
            $booking_id = 0;
            if ($data && is_array($services_selected) && count($services_selected) > 0) {
                global $wpdb;
                $booking = array();
                $pdf_content = array();
                $booking['b_order_code'] = uniqid();
                $booking['b_gateway_type'] = isset($data['b_gateway_type']) ? $data['b_gateway_type'] : 'onsite';



                $setting_db = Revy_DB_Setting::instance();
                $setting = $setting_db->get_setting();
                $limit_booking_before = isset($setting['limit_booking_before']) && $setting['limit_booking_before'] ? $setting['limit_booking_before'] : 0;

                $hide_date_time = isset($setting['hide_date_time']) && $setting['hide_date_time']=='1' ;

                $delivery_fee = 0;
                if($data['b_delivery_method'] == 1){ // Fix at home
                    $setting_db = Revy_DB_Setting::instance();
                    $setting = $setting_db->get_setting();
                    $delivery_fee = isset($setting['fix_at_home_fee']) && $setting['fix_at_home_fee'] ? $setting['fix_at_home_fee'] : 0;
                }

                if($limit_booking_before > 0 && ($data['b_delivery_method'] == 1 || $data['b_delivery_method']==2 )){
                    $now = current_time('mysql', 0);
                    $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                    $now = $now->modify('+' .$limit_booking_before.' day');
                    $now = $now->format('Y-m-d');
                    $booking_date =  $data['b_date'];
                    if(strtotime($now) >= strtotime($booking_date)){
                        return array(
                            'result' => -1,
                            'message' => esc_html__('You can not booking before ','revy'). $limit_booking_before . esc_html__(' day(s)','revy')
                        );
                    }

                }

                if(isset($setting['default_payment_method']) && $setting['default_payment_method']=='woocommerce'){
                    $booking['b_gateway_type'] = 'woocommerce';
                }

                //customer
                $c_first_name = isset($data['c_first_name']) ? $data['c_first_name'] : '';
                $c_last_name = isset($data['c_last_name']) ? $data['c_last_name'] : '';
                $c_email = isset($data['c_email']) ? $data['c_email'] : '';
                $c_phone = isset($data['c_phone']) ? $data['c_phone'] : '';
                $c_phone_code = isset($data['c_phone_code']) ? $data['c_phone_code'] : '';
                $c_address = isset($data['b_customer_address']) ? $data['b_customer_address'] : '';
                $c_city = isset($data['b_customer_city']) ? $data['b_customer_city'] : '';
                $c_postal_code = isset($data['b_customer_postal_code']) ? $data['b_customer_postal_code'] : '';
                $c_country = isset($data['b_customer_country']) ? $data['b_customer_country'] : '';

                $pdf_content['order_code'] = $booking['b_order_code'];
                $pdf_content['create_date'] = current_time('mysql', 0);
                $pdf_content['first_name'] = $c_first_name;
                $pdf_content['last_name'] = $c_last_name;
                $pdf_content['phone'] = explode(',',$c_phone_code)[0].$c_phone;
                $pdf_content['address'] = $c_address;
                $pdf_content['city'] = $c_city;
                $pdf_content['email'] = $c_email;
                $pdf_content['country'] = $c_country;
                $pdf_content['postal_code'] = $c_postal_code;
                $pdf_content['delivery'] = $data['b_delivery_method'];

                if ($c_first_name == '' || $c_last_name == '' || $c_email == '') {
                    return array(
                        'result' => -1,
                        'message' => esc_html__('Please fill data for first name, last name and email', 'revy')
                    );
                }

                if(!$hide_date_time && $data['b_delivery_method'] != 3){ //delivery != Mail In
                    $is_valid_limit = $this->validate_booking($data);
                    if (is_array($is_valid_limit) && $is_valid_limit['result'] < 0) {
                        return $is_valid_limit;
                    }
                }


                $sql = "SELECT c_id, c_email FROM {$wpdb->prefix}rp_customers WHERE c_email=%s";
                $sql = $wpdb->prepare($sql, $c_email);
                $customer = $wpdb->get_results($sql);

                if (count($customer) > 0 && $customer[0]->c_id) {
                    $booking['b_customer_id'] = $customer[0]->c_id;
                } else {
                    $c_dob = new DateTime();
                    $c_code = uniqid();
                    $result_add_customer = $wpdb->insert($wpdb->prefix . 'rp_customers', array(
                        'c_first_name' => $c_first_name,
                        'c_last_name' => $c_last_name,
                        'c_email' => $c_email,
                        'c_gender' => 0,
                        'c_phone' => $c_phone,
                        'c_phone_code' => $c_phone_code,
                        'c_address' => $c_address,
                        'c_postal_code' => $c_postal_code,
                        'c_city' => $c_city,
                        'c_country' => $c_country,
                        'c_dob' => $c_dob->modify('-20 years')->format('Y-m-d'),
                        'c_code' => $c_code
                    ));
                    $booking['b_customer_id'] = $result_add_customer > 0 ? $wpdb->insert_id : $result_add_customer;
                }
                if (!isset($booking['b_customer_id']) || $booking['b_customer_id'] <= 0) {
                    return array(
                        'result' => -1,
                        'message' => esc_html__('Cannot add customer information, please contact site admin for this error', 'revy')
                    );
                }

                $quantity = isset($data['b_quantity']) && $data['b_quantity'] ? $data['b_quantity'] : 1;
                $b_total_amount = 0;

                //service
                $s_ids = array();
                $s_attr_code = array();
                $service_name = '';
                foreach ($services_selected as $s) {
                    $s_ids[] = $s['s_id'];
                    if(isset($s['s_attr_code']) && $s['s_attr_code']!=''){
                        $s_attr_code[] = $s['s_attr_code'];
                    }
                    $service_name .= $s['s_name'] . '; ';
                }
                if(count($s_attr_code) > 0){
                    $sql = "SELECT S.s_id, S.s_name, S.s_tax, S.s_duration, S.s_do_together, S.s_break_time, S.s_maximum_slot, SP.s_attr_title, SP.s_attr_value, SP.s_price
                                FROM {$wpdb->prefix}rp_services AS S
                                LEFT JOIN {$wpdb->prefix}rp_services_price AS SP
                                ON S.s_id = SP.s_id
                                WHERE S.s_id IN (" . implode(',', $s_ids) . ") AND SP.s_attr_code IN ('" . implode("','", $s_attr_code) . "')";

                }else{
                    $sql = "SELECT  s_id,  s_name,  s_tax,  s_duration, s_do_together,  s_break_time, s_maximum_slot, '' AS s_attr_title, '' AS s_attr_value, 0 As s_price
                                FROM {$wpdb->prefix}rp_services
                                WHERE s_id IN (" . implode(',', $s_ids) . ") ";

                }
                $ser_info = $wpdb->get_results($sql);
                if (count($ser_info) < count($services_selected)) {
                    return array(
                        'result' => -1,
                        'message' => esc_html__('Invalid data', 'revy')
                    );
                }

                $booking_detail = array();
                $b_total_tax = 0;
                $model_color = array();
                $pdf_content['services'] = array();
                foreach ($ser_info as $s) {
                    $b_service_tax_amount = ($s->s_price * $quantity) * ($s->s_tax / 100);
                    $b_total_tax += $b_service_tax_amount;
                    //$b_total_amount += $b_service_tax_amount + ($s->s_price * $quantity);
                    $b_total_amount += ($s->s_price * $quantity);
                    $model_color = $this->get_model_color($services_selected, $s->s_id);
                    $booking_detail[] = array(
                        'b_service_id' => $s->s_id,
                        'b_service_duration' => $s->s_duration,
                        'b_service_break_time' => $s->s_break_time,
                        'b_model_id' => $model_color['s_model_id'],
                        'b_model_name' => $model_color['s_model_name'],
                        'b_model_color' => $model_color['s_model_color'],
                        'b_attr_title' => $s->s_attr_title,
                        'b_attr_value' => $s->s_attr_value,
                        'b_quantity' => $quantity,
                        'b_price' => $s->s_price,
                        'b_service_tax' => $s->s_tax,
                        'b_service_tax_amount' => $b_service_tax_amount
                    );
                    $pdf_content['services'][] = array(
                        'device' => $model_color['s_model_name'].' '.$model_color['s_model_color'],
                        'service' => $s->s_name.' '.$s->s_attr_title.' '.$s->s_attr_value,
                        'total' => ($s->s_price * $quantity)
                    );
                }
                $pdf_content['tax'] = $b_total_tax;

                $b_id = 0;
                $booking['b_customer_address'] = isset($data['b_customer_address']) ? $data['b_customer_address'] : '';
                $booking['b_customer_city'] = isset($data['b_customer_city']) ? $data['b_customer_city'] : '';
                $booking['b_customer_country'] = isset($data['b_customer_country']) ? $data['b_customer_country'] : '';
                $booking['b_customer_postal_code'] = isset($data['b_customer_postal_code']) ? $data['b_customer_postal_code'] : '';
                $booking['b_garage_id'] = isset($data['b_garage_id']) ? $data['b_garage_id'] : 0;
                $booking['b_device_id'] = isset($data['b_device_id']) ? $data['b_device_id'] : 0;
                $booking['b_brand_id'] = isset($data['b_brand_id']) ? $data['b_brand_id'] : 0;
                $booking['b_model_id'] = isset($data['b_model_id']) ? $data['b_model_id'] : 0;
                $booking['b_group_name'] = isset($data['b_group_name']) ? $data['b_group_name'] : '';

                if($hide_date_time){
                    $now = current_time('mysql',0);
                    $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                    $booking['b_date'] = $now->format('Y-m-d');
                    $booking['b_time'] = 0;
                }else{
                    $booking['b_date'] = $data['b_date'] ;
                    $booking['b_time'] = $data['b_time'];
                }

                $pdf_content['booking_date'] =  $booking['b_date'];
                $pdf_content['booking_time'] = Revy_Utils::getTimeLabel($data['b_time']);

                $b_total_amount += $delivery_fee;
                $booking['b_delivery_fee'] = $delivery_fee;
                $booking['b_pay_now'] = 0;
                $booking['b_send_notify'] = 0;
                $booking['b_total_amount'] = $b_total_amount;
                $booking['b_delivery_method'] = $data['b_delivery_method'];
                $booking['b_serial_number'] = isset($data['b_serial_number']) ? $data['b_serial_number'] : '' ;
                $booking['b_notes'] = isset($data['b_notes']) ? $data['b_notes'] : '' ;
                $booking['b_custom_field'] = isset($data['b_custom_field']) ? serialize($data['b_custom_field']) : '';

                //get service do together
                $s_do_together = array();
                $s_check_together = array();
                foreach ($ser_info as $s) {
                    if($s->s_do_together != null && $s->s_do_together && !in_array($s->s_id, $s_check_together)){
                        $s_check_together[] = $s->s_id;
                        $s_do_together = array_merge($s_do_together, explode(',',$s->s_do_together));
                    }
                }

                //validate for Carry In
                if(!$hide_date_time && $booking['b_delivery_method'] == 2 && !in_array($s->s_id, $s_do_together)){
                    $is_valid_time_slot = array('valid' => true);
                    foreach ($ser_info as $s) {
                        $is_valid_time_slot = $this->validate_booking_slot($b_id, $s->s_id, $s->s_break_time, $s->s_duration,
                            $s->s_maximum_slot, $booking['b_garage_id'], $booking['b_date'], $booking['b_time'], $quantity);
                        if (!$is_valid_time_slot['valid']) {
                            return array(
                                'result' => -1,
                                'message' => $is_valid_time_slot['message']
                            );
                        }
                    }
                }

                //assign appointment date for mail in delivery
                if(!$hide_date_time && $booking['b_delivery_method'] == 3){
                    $now = current_time('mysql', 0);
                    $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                    $booking['b_date'] = $now->format('Y-m-d');
                    $booking['b_time'] = intval($now->format('G')) * 60 + intval($now->format('H'));
                }

                //coupon
                $booking['b_coupon_code'] = isset($data['b_coupon_code']) ? $data['b_coupon_code'] : '';
                $coupon = Revy_Utils::getCoupon($booking['b_coupon_code'], $s_ids);
                $discount = 0;
                $discount_type = '';
                if (isset($coupon['result']) && $coupon['result'] > 0 && isset($coupon['discount_type'])) {
                    $booking['b_discount'] = $coupon['amount'];
                    $discount_type = $coupon['discount_type'];
                    $booking['b_coupon_id'] = $coupon['coupon_id'];
                }

                $discount = 0;
                if ($discount_type == '1') { //percent
                    $discount = ($booking['b_total_amount'] * $booking['b_discount']) / 100;
                    $discount = number_format($discount, 2);
                } else {
                    $discount = isset($booking['b_discount']) ? $booking['b_discount'] : 0;
                }
                $discount = floatval($discount);

                $booking['b_total_pay'] = $booking['b_total_amount'] > $discount ? ($booking['b_total_amount'] - $discount) : 0;
                $booking['b_total_pay'] += $b_total_tax;

                $booking['b_gateway_status'] = 0;
                $booking['b_description'] = isset($data['b_description']) ? $data['b_description'] : '';

                $db_setting = Revy_DB_Setting::instance();
                $setting = $db_setting->get_setting();
                $booking['b_process_status'] = isset($setting['b_process_status']) ? $setting['b_process_status'] : 0;

                $booking['b_create_date'] = current_time('mysql', 0);

                do_action('revy_before_add_booking', $booking);

                if ($booking['b_total_pay'] > 0 && ($booking['b_gateway_type'] === 'stripe' || $booking['b_gateway_type'] === 'paypal')) {
                    //temporary for payment gateway
                    $booking['b_process_status'] = -1;
                }

                $booking['b_total_tax'] = 0;
                foreach ($booking_detail as $bd) {
                    $booking['b_total_tax'] += $bd['b_service_tax_amount'];
                }

                $result = $wpdb->insert($wpdb->prefix . 'rp_booking', $booking);
                $booking_id = $result > 0 ? $wpdb->insert_id : $result;

                // insert booking detail
                if ($booking_id > 0) {
                    foreach ($booking_detail as $bd) {
                        $bd['b_id'] = $booking_id;
                        $wpdb->insert($wpdb->prefix . 'rp_booking_detail', $bd);
                    }
                }

                if ($c_phone) {
                    $wpdb->update($wpdb->prefix . 'rp_customers', array('c_last_booking' => $booking['b_date'], 'c_phone' => $c_phone, 'c_phone_code' => $c_phone_code), array('c_id' => $booking['b_customer_id']));
                } else {
                    $wpdb->update($wpdb->prefix . 'rp_customers', array('c_last_booking' => $booking['b_date']), array('c_id' => $booking['b_customer_id']));
                }

                do_action('fat_after_add_booking', $booking_id, $booking);

                $approve_url = '';

                if ($booking_id > 0 && $booking['b_gateway_type'] === 'paypal') {
                    $payment_desc = esc_html__('Customer:', 'revy') . $c_first_name . ' ' . $c_last_name;
                    $payment_desc .= esc_html__('Service:', 'revy') . $service_name;
                    $time = '';
                    if( isset($data['b_date_i18n'])){
                        $time .= $data['b_date_i18n'];
                    }
                    if(isset($data['b_time_label'] )){
                        $time .= ' ' . $data['b_time_label'] . ',';
                    }

                    $payment_desc .= esc_html__('Time:', 'revy') . $time;
                    $url = esc_url(home_url());
                    $total_pay = $booking['b_total_pay'];
                    $customer = $c_first_name . ' ' . $c_last_name . '(' . $c_email . ')';
                    $service_name = is_array($service_name) ? implode(', ', $service_name) : $service_name;
                    if ($total_pay > 0) {
                        $payment = new Revy_Payment();
                        $payment_result = $payment->payment($booking_id, $customer, $service_name, $total_pay, 0, $setting['currency'], $payment_desc, $url);
                        if ($payment_result['result'] == -1) {
                            $sql = "DELETE FROM {$wpdb->prefix}rp_booking WHERE b_id = %d";
                            $sql = $wpdb->prepare($sql, $booking_id);
                            $wpdb->query($sql);
                            return array(
                                'result' => -1,
                                'message' => $payment_result['message']
                            );
                        } else {
                            $approve_url = $payment_result['approval_url'];
                        }
                    } else {
                        return array(
                            'result' => $booking_id,
                        );
                    }
                }

                if ($booking_id > 0 && $booking['b_gateway_type'] === 'stripe') {
                    return array(
                        'result' => $booking_id,
                        'payment_method' => $booking['b_gateway_type']
                    );
                }

                if ($booking_id && $booking['b_gateway_type'] === 'onsite') {
                    if(isset($booking['b_coupon_id']) && $booking['b_coupon_id']){
                        $db_coupon = Revy_DB_Coupons::instance();
                        $db_coupon->increase_used($booking_id);
                    }

                    do_action('revy_booking_completed', $booking_id);
                }


                $pdf_content['serial_number'] = $booking['b_serial_number'];
                $pdf_content['delivery_cost'] =  $delivery_fee;
                $pdf_content['total'] =  $booking['b_total_pay'];
                $pdf_content['note']  = $booking['b_notes'];
                $utils = new Revy_Utils();
                $pdf_file = $utils->export_to_pdf($pdf_content);

                $result = array(
                    'result' => $booking_id,
                    'redirect_url' => isset($approve_url) ? $approve_url : '',
                    'pdf' => $pdf_file
                );

                $result = apply_filters('revy_payment_booking', $result, $booking_id, $booking);

                return $result;

            } else {
                if ($booking_id) {
                    error_log('save booking fe error, now delete booking id:'.$booking_id);
                    global $wpdb;
                    $sql = "DELETE FROM {$wpdb->prefix}rp_booking WHERE b_id = %d";
                    $sql = $wpdb->prepare($sql, $booking_id);
                    $wpdb->query($sql);

                    $sql = "DELETE FROM {$wpdb->prefix}rp_booking_detail WHERE b_id = %d";
                    $sql = $wpdb->prepare($sql, $booking_id);
                    $wpdb->query($sql);
                }
                return array(
                    'result' => -1,
                    'message' => esc_html__('Invalid data', 'revy')
                );
            }
        }

        public function get_model_color($services_selected, $s_id){
            foreach($services_selected as $sev){
                if($sev['s_id'] == $s_id){
                    return array(
                        's_model_id' => $sev['s_model_id'],
                        's_model_name' => $sev['s_model_name'],
                        's_model_color' => $sev['s_model_color']
                    );
                }
            }
            return array(
                's_model_id' => '',
                's_model_name' => '',
                's_model_color' => ''
            );
        }

        public function update_booking_process_status()
        {
            $b_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : '';
            $b_process_status = isset($_REQUEST['b_process_status']) ? $_REQUEST['b_process_status'] : '';
            $status = array(0, 1, 2, 3);
            if ($b_id && $b_process_status != '' && in_array($b_process_status, $status)) {
                global $wpdb;

                $sql = "SELECT b_id, b_customer_id, b_garage_id, b_date, b_time, b_process_status FROM {$wpdb->prefix}rp_booking WHERE b_id=%d";
                $sql = $wpdb->prepare($sql, $b_id);

                $booking = $wpdb->get_results($sql);

                if (count($booking) == 0) {
                    return array(
                        'result' => -1,
                        'message' => esc_html__('Cannot find this booking.Maybe it have been deleted', 'revy'),
                    );
                }

                do_action('revy_before_update_booking_status', $b_id, $b_process_status);
                $result = $wpdb->update($wpdb->prefix . 'rp_booking', array('b_process_status' => $b_process_status, 'b_send_notify' => 0, 'b_canceled_by_client' => 0),
                    array('b_id' => $b_id));
                do_action('revy_update_booking_status', $b_id, $b_process_status);
                return array(
                    'result' => $result,
                    'message' => $result ? esc_html__('Booking status have been updated', 'revy') : esc_html__('Cannot find this booking.Maybe it have been deleted', 'revy')
                );

            } else {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Invalid data', 'revy')
                );
            }
        }

        public function send_booking_mail($b_id, $is_fe = 1)
        {
            global $wpdb;
            if ($b_id == '') {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Data invalid', 'revy')
                );
            }
            $sql = "SELECT  b_id, b_order_code, c_code, c_first_name, c_last_name, c_email, c_phone,  rg_name, rg_email, rg_phone, rg_address,  
                            b_date, b_time,  b_process_status, b_customer_address, b_customer_city, b_customer_country, b_customer_postal_code,
                            b_total_pay, b_send_notify, b_description, b_coupon_code, b_delivery_method, '' as s_name, '' as b_attr_title, '' as b_attr_value, 
                            '' as b_service_duration, 1 as b_quantity, '' as s_description, '' as s_info, rb_name, rm_name, rd_name, b_gateway_type, b_serial_number, b_notes
                    FROM {$wpdb->prefix}rp_booking 
                    LEFT JOIN {$wpdb->prefix}rp_customers ON b_customer_id = c_id
                    LEFT JOIN {$wpdb->prefix}rp_garages ON b_garage_id = rg_id
                    LEFT JOIN {$wpdb->prefix}rp_brands  ON b_brand_id = rb_id
                    LEFT JOIN {$wpdb->prefix}rp_models ON b_model_id = rm_id
                    LEFT JOIN {$wpdb->prefix}rp_devices ON b_device_id = rd_id
                    WHERE b_id=%d";
            $sql = $wpdb->prepare($sql, $b_id);
            $mail_info = $wpdb->get_results($sql);

            $sql = "SELECT S.s_name, S.s_description, b_service_duration, b_service_break_time, b_quantity, b_price, b_attr_title, b_attr_value
                    FROM {$wpdb->prefix}rp_booking_detail AS RBD
                    LEFT JOIN {$wpdb->prefix}rp_services AS S
                    ON RBD.b_service_id = S.s_id
                    WHERE b_id=%d";
            $sql = $wpdb->prepare($sql, $b_id);
            $booking_detail = $wpdb->get_results($sql);

            if (count($mail_info) <= 0 || (isset($mail_info[0]->b_send_notify) && $mail_info[0]->b_send_notify == '1')) {
                return;
            }

            $mail_info = $mail_info[0];

            $mail_info->s_info = array();
            foreach ($booking_detail as $bd) {
                $mail_info->s_info[] = array(
                    's_name' => $bd->s_name,
                    'b_attr_title' => $bd->b_attr_title,
                    'b_attr_value' => $bd->b_attr_value,
                    'b_service_duration' => $bd->b_service_duration,
                    'b_quantity' => $bd->b_quantity,
                    's_description' => $bd->s_description,
                    'b_price' =>  $bd->b_price

                ) ;
            }

            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            $email_templates = $setting_db->get_email_template();
            $template = '';

            $pending_key = $is_fe ? 'pending' : 'backend';
            $approved_key = $is_fe ? 'approved' : 'backend';
            foreach ($email_templates as $tmpl) {
                if ($mail_info->b_process_status == 0 && $tmpl['template'] === $pending_key) {
                    $template = $tmpl;
                    break;
                }

                if ($mail_info->b_process_status == 1 && $tmpl['template'] === $approved_key) {
                    $template = $tmpl;
                    break;
                }

                if ($mail_info->b_process_status == 2 && $tmpl['template'] === 'canceled') {
                    $template = $tmpl;
                    break;
                }

                if ($mail_info->b_process_status == 3 && $tmpl['template'] === 'rejected') {
                    $template = $tmpl;
                    break;
                }
            }

            $subject = $message = '';

            if(isset($setting['employee_email']) && $setting['employee_email']){
                $setting['cc_to'] = $setting['cc_to'] !='' ? ( $setting['cc_to'].','.$setting['employee_email']) : $setting['employee_email'];
            }

            if ($mail_info->b_delivery_method== 1 && isset($template['fixit_home_enable']) && $template['fixit_home_enable'] ) {
                $subject = $template['fixit_home_subject'];
                $message = $template['fixit_home_message'];

                Revy_Utils::makeMailContent($subject, $message, $mail_info, $setting);
                return Revy_Utils::sendMail(array(
                    'mailer' => $setting['mailer'],
                    'smtp_host' => $setting['smtp_host'],
                    'smtp_port' => $setting['smtp_port'],
                    'smtp_username' => $setting['smtp_username'],
                    'smtp_password' => $setting['smtp_password'],
                    'encryption' => $setting['smtp_encryption'],
                    'from_name' => $setting['send_from_name'],
                    'from_name_label' => isset($setting['send_from_name_label']) ? $setting['send_from_name_label'] : $setting['send_from_name'],
                    'send_to' => $mail_info->c_email,
                    'cc_email' => $setting['cc_to'],
                    'bcc_email' => $setting['bcc_to'],
                    'subject' => $subject,
                    'message' => $message
                ));
            }

            if ($mail_info->b_delivery_method== 2 && isset($template['carry_in_enable']) && $template['carry_in_enable'] ) {
                $subject = $template['carry_in_subject'];
                $message = $template['carry_in_message'];
                Revy_Utils::makeMailContent($subject, $message, $mail_info, $setting);
                return Revy_Utils::sendMail(array(
                    'mailer' => $setting['mailer'],
                    'smtp_host' => $setting['smtp_host'],
                    'smtp_port' => $setting['smtp_port'],
                    'smtp_username' => $setting['smtp_username'],
                    'smtp_password' => $setting['smtp_password'],
                    'encryption' => $setting['smtp_encryption'],
                    'from_name' => $setting['send_from_name'],
                    'from_name_label' => isset($setting['send_from_name_label']) ? $setting['send_from_name_label'] : $setting['send_from_name'],
                    'send_to' => $mail_info->c_email,
                    'cc_email' => $setting['cc_to'],
                    'bcc_email' => $setting['bcc_to'],
                    'subject' => $subject,
                    'message' => $message
                ));
            }

            if ($mail_info->b_delivery_method== 3 && isset($template['mail_in_enable']) && $template['mail_in_enable'] ) {
                $subject = $template['mail_in_subject'];
                $message = $template['mail_in_message'];
                Revy_Utils::makeMailContent($subject, $message, $mail_info, $setting);
                return Revy_Utils::sendMail(array(
                    'mailer' => $setting['mailer'],
                    'smtp_host' => $setting['smtp_host'],
                    'smtp_port' => $setting['smtp_port'],
                    'smtp_username' => $setting['smtp_username'],
                    'smtp_password' => $setting['smtp_password'],
                    'encryption' => $setting['smtp_encryption'],
                    'from_name' => $setting['send_from_name'],
                    'from_name_label' => isset($setting['send_from_name_label']) ? $setting['send_from_name_label'] : $setting['send_from_name'],
                    'send_to' => $mail_info->c_email,
                    'cc_email' => $setting['cc_to'],
                    'bcc_email' => $setting['bcc_to'],
                    'subject' => $subject,
                    'message' => $message
                ));
            }

        }

        public function send_booking_sms($b_id)
        {
            global $wpdb;
            if ($b_id == '') {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Data invalid', 'revy')
                );
            }
            $sql = "SELECT  b_id, b_order_code, c_code, c_first_name, c_last_name, c_email, c_phone_code, c_phone,  rg_name, rg_email, rg_phone, rg_address,  
                            b_date, b_time,  b_process_status, b_customer_address, b_customer_city, b_customer_country, b_customer_postal_code,
                            b_total_pay, b_send_notify, b_description, b_coupon_code, b_delivery_method, '' as s_name, '' as b_attr_title, '' as b_attr_value, 
                            '' as b_service_duration, 1 as b_quantity, '' as s_description, '' as s_info, rb_name, rm_name, rd_name, b_gateway_type, b_serial_number, b_notes
                    FROM {$wpdb->prefix}rp_booking 
                    LEFT JOIN {$wpdb->prefix}rp_customers ON b_customer_id = c_id
                    LEFT JOIN {$wpdb->prefix}rp_garages ON b_garage_id = rg_id
                    LEFT JOIN {$wpdb->prefix}rp_brands  ON b_brand_id = rb_id
                    LEFT JOIN {$wpdb->prefix}rp_models ON b_model_id = rm_id
                    LEFT JOIN {$wpdb->prefix}rp_devices ON b_device_id = rd_id
                    WHERE b_id=%d";
            $sql = $wpdb->prepare($sql, $b_id);
            $mail_info = $wpdb->get_results($sql);

            $sql = "SELECT S.s_name, S.s_description, b_service_duration, b_service_break_time, b_quantity, b_price, b_attr_title, b_attr_value
                    FROM {$wpdb->prefix}rp_booking_detail AS RBD
                    LEFT JOIN {$wpdb->prefix}rp_services AS S
                    ON RBD.b_service_id = S.s_id
                    WHERE b_id=%d";
            $sql = $wpdb->prepare($sql, $b_id);
            $booking_detail = $wpdb->get_results($sql);

            if (count($mail_info) <= 0 || (isset($mail_info[0]->b_send_notify) && $mail_info[0]->b_send_notify == '1')) {
                return;
            }

            $mail_info = $mail_info[0];
            $phone = explode(',',$mail_info->c_phone_code)[0].$mail_info->c_phone;
            $mail_info->s_info = array();
            foreach ($booking_detail as $bd) {
                $mail_info->s_info[] = array(
                    's_name' => $bd->s_name,
                    'b_attr_title' => $bd->b_attr_title,
                    'b_attr_value' => $bd->b_attr_value,
                    'b_service_duration' => $bd->b_service_duration,
                    'b_quantity' => $bd->b_quantity,
                    's_description' => $bd->s_description,
                    'b_price' =>  $bd->b_price

                ) ;
            }

            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            $sms_templates = $setting_db->get_sms_template();
            $template = '';

            $pending_key = 'pending';
            $approved_key = 'approved';
            $sms_enable = false;
            $sms_message = '';
            foreach ($sms_templates as $tmpl) {
                if ($mail_info->b_process_status == 0 && $tmpl['template'] === $pending_key) {
                    $sms_enable = $tmpl['customer_enable'];
                    $sms_message = $tmpl['customer_message'];
                    break;
                }

                if ($mail_info->b_process_status == 1 && $tmpl['template'] === $approved_key) {
                    $sms_enable = $tmpl['customer_enable'];
                    $sms_message = $tmpl['customer_message'];
                    break;
                }

                if ($mail_info->b_process_status == 2 && $tmpl['template'] === 'canceled') {
                    $sms_enable = $tmpl['customer_enable'];
                    $sms_message = $tmpl['customer_message'];
                    break;
                }

                if ($mail_info->b_process_status == 3 && $tmpl['template'] === 'rejected') {
                    $sms_enable = $tmpl['customer_enable'];
                    $sms_message = $tmpl['customer_message'];
                    break;
                }
            }

            if($sms_enable){
                Revy_Utils::makeSMSContent($sms_message, $mail_info, $setting);
                Revy_Utils::sendSMS($phone, $sms_message);
            }


        }

        public function delete_booking()
        {
            $b_ids = isset($_REQUEST['b_ids']) && $_REQUEST['b_ids'] != '' ? $_REQUEST['b_ids'] : '';
            if ($b_ids) {
                global $wpdb;
                $b_ids = Revy_Utils::prepareIn($b_ids);

                $sql = "DELETE FROM {$wpdb->prefix}rp_booking_detail WHERE  b_id IN ({$b_ids}) ";
                $wpdb->query($sql);

                $sql = "DELETE FROM {$wpdb->prefix}rp_booking WHERE  b_id IN ({$b_ids}) ";
                $wpdb->query($sql);

                $coupon_db  = Revy_DB_Coupons::instance();
                foreach($b_ids as $b_id){
                    $coupon_db->decrease_used($b_id);
                }
                return array(
                    'result' => 1,
                    'message' => esc_html__(' booking(s) have been deleted', 'revy')
                );

            } else {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Data is invalid', 'revy')
                );
            }
        }

        private function validate_booking_slot($b_id, $s_id, $s_duration, $s_break_time, $service_max_cap, $garage_id, $date, $time, $quantity)
        {
            global $wpdb;
            $invalid_message = esc_html__('The appointments are fully booked. Please check again later or browse other day !', 'revy');
            $time_end = $time + $s_duration + $s_break_time;

            //Check seats available for this service
            $sql = "SELECT SUM(RBD.b_quantity) as total_customer_number
                    FROM {$wpdb->prefix}rp_booking AS RB
                    LEFT JOIN {$wpdb->prefix}rp_booking_detail AS RBD
                    ON RB.b_id = RBD.b_id
                    WHERE   RB.b_id != %d
                            AND b_delivery_method = 2
                            AND b_process_status IN (0,1)
                            AND b_date = %s AND RBD.b_service_id = %d AND b_garage_id = %d
                            AND b_time <=%d AND %d <= (b_time + RBD.b_service_duration + RBD.b_service_break_time) ";
            $sql = $wpdb->prepare($sql, $b_id, $date, $s_id, $garage_id, $time, $time_end);
            $booking_in_time = $wpdb->get_results($sql);

            if (is_countable($booking_in_time) && count($booking_in_time) > 0 && !is_null($booking_in_time[0]->total_customer_number)) {
                $total_customer_number = $booking_in_time[0]->total_customer_number;
                if ($quantity > ($service_max_cap - $total_customer_number) || (1 > ($service_max_cap - $total_customer_number))) {
                    return array(
                        'valid' => false,
                        'message' => esc_html__('The number of device exceeds the number that can be serviced', 'fat-event')
                    );
                }
            }

            //Check conflict time slot with $s_id
            $sql = "SELECT RB.b_id
                    FROM {$wpdb->prefix}rp_booking AS RB
                    LEFT JOIN {$wpdb->prefix}rp_booking_detail AS RBD
                    ON RB.b_id = RBD.b_id
                    WHERE   RB.b_id != %d
                            AND RB.b_delivery_method = 2
                            AND b_process_status IN (0,1)
                            AND b_date = %s AND (
                               (  {$time} <= b_time AND b_time < {$time_end} AND {$time_end} < (b_time + RBD.b_service_break_time + RBD.b_service_duration) ) OR
                                    ( {$time} <= b_time AND (b_time + RBD.b_service_break_time + RBD.b_service_duration) < {$time_end} ) OR
                                    ( b_time <= {$time} AND {$time} < (b_time + RBD.b_service_break_time + RBD.b_service_duration) AND (b_time + RBD.b_service_break_time + RBD.b_service_duration) < {$time_end}) OR 
                                    ( b_time <= {$time} AND {$time_end} <= (b_time + RBD.b_service_duration + RBD.b_service_break_time) AND RBD.b_service_id = %d AND b_garage_id != %d)
                            )";
            $sql = $wpdb->prepare($sql, $b_id, $date, $s_id, $garage_id);
            $booking_conflict = $wpdb->get_results($sql);

            if (is_countable($booking_conflict) && count($booking_conflict)) {
                error_log('booking conflict');
                return array(
                    'valid' => false,
                    'message' => $invalid_message
                );
            }

            //check the date is day off
            $sql = "SELECT dof_id FROM {$wpdb->prefix}rp_services_day_off WHERE s_id=%d AND dof_start <= %s AND dof_end >= %s";
            $sql = $wpdb->prepare($sql, $s_id, $date, $date);
            $day_off = $wpdb->get_results($sql);
            if (is_countable($day_off) && count($day_off) > 0) {
                error_log('invalid day off');
                return array(
                    'valid' => false,
                    'message' => $invalid_message
                );
            }

            //check service schedule
            $date = DateTime::createFromFormat('Y-m-d', $date);
            $day_of_week = 2;

            switch ($date->format('D')) {
                case 'Mon':
                {
                    $day_of_week = 2;
                    break;
                }
                case 'Tue':
                {
                    $day_of_week = 3;
                    break;
                }
                case 'Wed':
                {
                    $day_of_week = 4;
                    break;
                }
                case 'Thu':
                {
                    $day_of_week = 5;
                    break;
                }
                case 'Fri':
                {
                    $day_of_week = 6;
                    break;
                }
                case 'Sat':
                {
                    $day_of_week = 7;
                    break;
                }
                case 'Sun':
                {
                    $day_of_week = 8;
                    break;
                }
            }
            $sql = "SELECT ss_work_hour_start, ss_work_hour_end, ss_enable
                    FROM {$wpdb->prefix}rp_services_schedule
                    WHERE s_id=%d AND ss_day=%d AND ss_enable=1";
            $sql = $wpdb->prepare($sql, $s_id, $day_of_week);
            $service_schedules = $wpdb->get_results($sql);
            if (is_countable($service_schedules) && count($service_schedules) > 0) {
                foreach ($service_schedules as $ss) {
                    if ($ss->ss_work_hour_start <= $time && ($time + $s_duration) <= $ss->ss_work_hour_end) {
                        return array(
                            'valid' => true,
                        );
                    }
                }
                error_log('invalid service schedule');
                return array(
                    'valid' => false,
                    'message' => $invalid_message
                );
            } else {
                return array(
                    'valid' => false,
                    'message' => $invalid_message
                );
            }

            return array(
                'valid' => true
            );
        }

        public function get_booking_history()
        {
            global $wpdb;
            $c_code = isset($_REQUEST['c_code']) ? $_REQUEST['c_code'] : '';
            $page = isset($_REQUEST['page']) && $_REQUEST['page'] ? $_REQUEST['page'] : 1;
            $status = isset($_REQUEST['status']) && $_REQUEST['status'] ? $_REQUEST['status'] : 0;
            $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
            $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
            $total = 0;
            if ($c_code) {
                $sql = "SELECT c_email FROM {$wpdb->prefix}rp_customers WHERE c_code=%s";
                $sql = $wpdb->prepare($sql, $c_code);
                $customer = $wpdb->get_results($sql);
                $user_email = count($customer) > 0 && isset($customer[0]->c_email) ? $customer[0]->c_email : '';

                if ($user_email) {
                    $sql = "SELECT  b_date, b_time, b_id, b_customer_id, c_first_name, c_last_name, c_email, b_gateway_type, b_gateway_status, b_total_pay, 
                                    b_process_status, b_create_date, b_delivery_method, b_group_name
                                        FROM {$wpdb->prefix}rp_booking LEFT JOIN {$wpdb->prefix}rp_customers ON b_customer_id = c_id
                                        WHERE c_email=%s AND b_canceled_by_client!=1 AND b_process_status = %s AND DATE(b_date) BETWEEN %s AND %s
                                        ORDER BY b_date DESC";
                    $sql = $wpdb->prepare($sql, $user_email, $status, $start_date, $end_date);
                    $bookings = $wpdb->get_results($sql);
                    $total = count($bookings);

                    $db_setting = Revy_DB_Setting::instance();
                    $setting = $db_setting->get_setting();

                    $item_per_page = isset($setting['item_per_page']) ? $setting['item_per_page'] : 10;
                    $number_of_page = $total / $item_per_page + ($total % $item_per_page > 0 ? 1 : 0);
                    $page = $page > $number_of_page ? $number_of_page : $page;
                    $page = ($page - 1) * $item_per_page;
                    $bookings = array_slice($bookings, $page, $item_per_page);

                    $b_date = '';
                    $now = current_time('mysql', 0);
                    $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                    $hours = Revy_Utils::getDurations(0, 'duration_step');
                    $steps = Revy_Utils::getWorkHours(5);
                    $status = array(
                        esc_html__('Pending', 'revy'),
                        esc_html__('Approved', 'revy'),
                        esc_html__('Cancel', 'revy'),
                        esc_html__('Rejected', 'revy')
                    );

                    $b_ids = array();
                    foreach ($bookings as $booking) {
                        $b_ids[] = $booking->b_id;
                        $b_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking->b_date . ' 00:00:00');
                        $b_date->modify("+{$booking->b_time} minutes");
                        $booking->editable = $b_date > $now ? 1 : 0;
                        if($booking->b_delivery_method == 1 || $booking->b_delivery_method == 3){
                            $booking->editable = 1;
                        }
                        $booking->is_cancel = $booking->editable && $booking->b_process_status == 0 ? 1 : 0;
                        $booking->b_time_label = $steps[$booking->b_time];
                        $booking->rm_name .= isset($booking->b_group_name) && $booking->b_group_name ? (' - '.$booking->b_group_name) : '';
                    }

                    //get service name for each booking
                    $booking_detail = array();
                    if($total > 0){
                        $sql = "SELECT b_id, b_model_name, b_model_color, s_name, b_service_id, b_attr_title, b_attr_value
                            FROM {$wpdb->prefix}rp_booking_detail AS RBD
                            LEFT JOIN {$wpdb->prefix}rp_services AS RS
                            ON RBD.b_service_id = RS.s_id
                            WHERE b_id IN(". implode(',', $b_ids).")";
                        $booking_detail = $wpdb->get_results($sql);
                    }

                    return array(
                        'result' => 1,
                        'total' => $total,
                        'bookings' => $bookings,
                        'bookings_detail' => $booking_detail
                    );
                } else {
                    return array(
                        'result' => -1,
                        'message' => esc_html__('Customer code invalid', 'revy')
                    );
                }
            }

            return array(
                'result' => -1,
                'message' => esc_html__('Data invalid', 'revy')
            );
        }

        public function cancel_booking()
        {
            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            if (isset($setting['allow_client_cancel']) && $setting['allow_client_cancel'] == 0) {
                return array(
                    'result' => -1,
                    'message' => esc_html__('The reservation cancellation function is locked', 'revy')
                );
            }
            global $wpdb;
            $c_code = isset($_REQUEST['c_code']) ? $_REQUEST['c_code'] : '';
            $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
            $cancel_before = isset($setting['cancel_before']) && $setting['cancel_before'] ? intval($setting['cancel_before']) : 0;

            $current_user = wp_get_current_user();
            $user_email = $current_user->exists() ? $current_user->user_email : '';
            if (($c_code || $user_email) && $id) {
                if ($c_code) {
                    $sql = "SELECT c_id FROM {$wpdb->prefix}rp_customers WHERE c_code!='' AND c_code=%s";
                    $sql = $wpdb->prepare($sql, $c_code);
                } else {
                    $sql = "SELECT c_id FROM {$wpdb->prefix}rp_customers WHERE c_email=%s";
                    $sql = $wpdb->prepare($sql, $user_email);
                }
                $customer = $wpdb->get_results($sql);
                if (count($customer) > 0 && isset($customer[0]->c_id)) {
                    $sql = "SELECT b_id, b_date, b_time, b_process_status FROM {$wpdb->prefix}rp_booking WHERE b_id = %d AND b_customer_id = %d";
                    $sql = $wpdb->prepare($sql, $id, $customer[0]->c_id);
                    $bookings = $wpdb->get_results($sql);
                    if (count($bookings) > 0) {
                        if ($bookings[0]->b_process_status != 0) {
                            return array(
                                'result' => -1,
                                'message' => esc_html__('You cannot cancel approved appointment', 'revy')
                            );
                        }

                        if ($cancel_before) {
                            $now = current_time('mysql', 0);
                            $now = strtotime($now);
                            $bookings[0]->b_time = intval($bookings[0]->b_time);
                            $hours = $bookings[0]->b_time / 60;
                            $hours = floor($hours);
                            $hours = $hours > 10 ? $hours : '0' . $hours;
                            $minute = $bookings[0]->b_time % 60;
                            $minute = $minute > 10 ? $minute : '0' . $minute;
                            $b_date_time = $bookings[0]->b_date . ' ' . $hours . ':' . $minute;
                            $b_date_time = strtotime($b_date_time);
                            $diff = $b_date_time - $now;
                            $hours_diff = $diff / (60 * 60);
                            if ($hours_diff < $cancel_before) {
                                return array(
                                    'result' => -1,
                                    'cancel_before' => $cancel_before,
                                    'b_date_time' => ($bookings[0]->b_date . ' ' . $hours . ':' . $minute),
                                    'hours_diff' => $hours_diff,
                                    'message' => esc_html__('Time limit for cancellation reservations has passed', 'revy')
                                );
                            }
                        }

                        $b_status_note = esc_html__('Canceled by client', 'revy');
                        $sql = "UPDATE {$wpdb->prefix}rp_booking SET b_canceled_by_client = 1, b_process_status=2, b_send_notify=0, b_status_note= %s WHERE b_process_status=0 AND b_id = %d AND b_customer_id = %d";
                        $sql = $wpdb->prepare($sql, $b_status_note, $id, $customer[0]->c_id);
                        $wpdb->query($sql);
                        return array(
                            'result' => 1,
                            'message' => esc_html__('Booking has been canceled', 'revy')
                        );
                    }
                }
            }

            return array(
                'result' => -1,
                'message' => esc_html__('Data invalid', 'revy')
            );
        }

        public function export_calendar()
        {
            if (isset($_REQUEST['b_id'])) {
                global $wpdb;
                $b_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : '';

                $sql = "SELECT b_id, s_name, b_service_duration, 
                                            loc_name, loc_address, b_date, b_time
                                        FROM {$wpdb->prefix}rp_booking 
                                        LEFT JOIN {$wpdb->prefix}rp_services ON b_service_id = s_id
                                        LEFT JOIN {$wpdb->prefix}rp_garages ON b_garage_id = rg_id
                                        WHERE b_id=%d";
                $sql = $wpdb->prepare($sql, $b_id);
                $booking_info = $wpdb->get_results($sql);

                if (count($booking_info) > 0) {
                    $booking_info = $booking_info[0];
                    $u_start_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking_info->b_date . ' 00:00:00');
                    $u_start_date = $u_start_date->modify('+' . $booking_info->b_time . ' minute');
                    $u_end_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking_info->b_date . ' 00:00:00');
                    $u_end_date = $u_end_date->modify('+' . ($booking_info->b_time + $booking_info->b_service_duration) . ' minute');
                    $description = esc_html__('Service name:', 'revy') . $booking_info->s_name . ' \\n ';

                    $location = $booking_info->loc_name . ' ' . $booking_info->loc_address;

                    $setting_db = Revy_DB_Setting::instance();
                    $setting = $setting_db->get_setting();

                    $properties = array(
                        'dtstart' => $u_start_date->format('Y-m-d H:i'),
                        'dtend' => $u_end_date->format('Y-m-d H:i'),
                        'description' => $description,
                        'location' => $location,
                        'summary' => $booking_info->s_name,
                        'organizer' => $setting['company_name']
                    );
                    $ics = new ICS($properties);
                    return $ics->to_string();
                } else {
                    return esc_html__('Data invalid', 'revy');
                }
            }
        }

        public function export_google_calendar()
        {
            if (isset($_REQUEST['b_id'])) {
                global $wpdb;
                $b_id = isset($_REQUEST['b_id']) ? $_REQUEST['b_id'] : '';

                $link = '';

                $sql = "SELECT b_id,  s_name, b_service_duration, 
                                            loc_name, loc_address, b_date, b_time
                                        FROM {$wpdb->prefix}rp_booking 
                                        LEFT JOIN {$wpdb->prefix}rp_services ON b_service_id = s_id
                                        LEFT JOIN {$wpdb->prefix}rp_garages ON b_garage_id = rg_id
                                        WHERE b_id=%d";
                $sql = $wpdb->prepare($sql, $b_id);
                $booking_info = $wpdb->get_results($sql);
                if (count($booking_info) > 0) {
                    $booking_info = $booking_info[0];
                    $link = 'http://www.google.com/calendar/render?action=TEMPLATE';
                    $time_zone = wp_timezone();
                    $u_start_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking_info->b_date . ' 00:00:00', $time_zone);// ($booking_info->b_date;
                    $u_start_date = $u_start_date->modify('+' . $booking_info->b_time . ' minute');
                    $u_end_date = DateTime::createFromFormat('Y-m-d H:i:s', $booking_info->b_date . ' 00:00:00', $time_zone);
                    $u_end_date = $u_end_date->modify('+' . ($booking_info->b_time + $booking_info->b_service_duration) . ' minute');

                    $link .= '&text=' . $booking_info->s_name;
                    $link .= '&dates=' . $u_start_date->format('Ymd') . 'T' . $u_start_date->format('His') . '/' . $u_end_date->format('Ymd') . 'T' . $u_end_date->format('His');
                    $link .= '&details=Service:' . $booking_info->s_name . ' Duration:' . $booking_info->b_service_duration;
                    $link .= '&location=' . $booking_info->loc_name . ' ' . $booking_info->loc_address;
                    $link .= '&trp=false&sprop=&sprop=name:';
                    return $link;
                } else {
                    return '';
                }
            }
        }

        public function validate_booking($data)
        {
            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();

            //validate day limit
            $day_limit = isset($setting['day_limit']) && $setting['day_limit'] ? $setting['day_limit'] : 365;
            $b_date = DateTime::createFromFormat('Y-m-d H:i', $data['b_date'] . ' 00:00');
            $now = current_time('mysql', 0);
            $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
            if ($b_date->diff($now)->days > $day_limit) {
                return array(
                    'result' => -1,
                    'message' => sprintf(esc_html__('You cannot book service before %s days', 'revy'), $day_limit)
                );
            }
            $b_date_time = DateTime::createFromFormat('Y-m-d H:i', $data['b_date'] . ' 00:00');
            $b_date_time = $b_date_time->modify('+' . $data['b_time'] . ' minutes');
            if ($now >= $b_date_time) {
                return array(
                    'result' => -1,
                    'message' => esc_html__('You cannot set time in the past for ', 'revy') . $data['b_date_i18n'] . ' ' . $data['b_time_label']
                );
            }

            //validate limit in time period
            if ($data['c_email']!='' && isset($setting['limit_booking']) && $setting['limit_booking'] == 1 && isset($setting['limited_time']) && $setting['limited_time'] > 0) {
                global $wpdb;
                $limited_time = $setting['limited_time'];
                $sql = "SELECT b_create_date 
                        FROM {$wpdb->prefix}rp_booking AS RB
                        INNER JOIN {$wpdb->prefix}rp_customers AS RC 
                        ON RB.b_customer_id = RC.c_id
                        WHERE RC.c_email = %s AND RB.b_process_status!=-1";
                $sql = $wpdb->prepare($sql, $data['c_email']);
                $bk = $wpdb->get_results($sql);

                if (isset($bk[0]) && $bk[0]->b_create_date) {
                    $bk[0]->b_create_date = DateTime::createFromFormat('Y-m-d H:i:s', $bk[0]->b_create_date);
                    if ($now->diff($bk[0]->b_create_date) <= $limited_time) {
                        return array(
                            'result' => -1,
                            'message' => esc_html__('You can not make more appointment in ', 'revy') . $limited_time . esc_html__(' minutes', 'revy')
                        );
                    }
                }

            }

            return array(
                'result' => 1
            );

        }

        public function save_quote_fe()
        {
            $data = isset($_REQUEST['data']) ? $_REQUEST['data'] : '';
            if(isset($data['media_type']) && $data['media_type']!='image'){
                return array(
                    'result' => -1,
                    'message' => esc_html__('Quote only allow upload image','revy')
                );
            }
            if (isset($data['q_first_name']) && isset($data['q_last_name']) && isset($data['q_email']) && isset($data['q_phone'])
            && isset($data['q_device_type']) && isset($data['q_brand_name']) ) {
                global $wpdb;

                $db_setting = Revy_DB_Setting::instance();
                $setting = $db_setting->get_setting();

                $quote_form = array();
                $quote_form['q_first_name'] = $data['q_first_name'];
                $quote_form['q_last_name'] = $data['q_last_name'];
                $quote_form['q_email'] = $data['q_email'];
                $quote_form['q_phone_code'] = $data['q_phone_code'];
                $quote_form['q_phone'] = $data['q_phone'];
                $quote_form['q_address'] = $data['q_address'];
                $quote_form['q_device_type'] = $data['q_device_type'];
                $quote_form['q_brand_name'] = $data['q_brand_name'];
                $quote_form['q_model'] = isset($data['q_model']) ? $data['q_model'] : '';
                $quote_form['q_color'] = isset($data['q_color']) ? $data['q_color'] : '';
                $quote_form['q_serial_number'] = isset($data['q_serial_number']) ? $data['q_serial_number'] : '';
                $quote_form['q_detail_problem'] = isset($data['q_detail_problem']) ? $data['q_detail_problem'] : '';
                $quote_form['q_create_date'] = current_time( 'mysql', 0);
                $quote_form['q_status'] = isset($setting['q_status']) ? $setting['q_status'] : 0;

                if(isset($setting['enable_upload_image']) && $setting['enable_upload_image']=='1' && isset($data['media_data']) && $data['media_data']!=''){
                    $media = $this->save_media_file($data['media_data'], $data['media_type'], $data['media_mime']);
                    $quote_form['q_image_id'] = $media['id'];
                    $quote_form['q_image_url'] = $media['url_full'];
                }

                $result = $wpdb->insert("{$wpdb->prefix}rp_quote_form", $quote_form);
                $quote_id = $result > 0 ? $wpdb->insert_id : $result;
                return array(
                    'result' => $quote_id,
                    'message' => $result > 0 ? esc_html__('Quote has been saved','revy') : esc_html__('An error occurred during execution','revy')
                );
            }
        }

        public function send_quote_mail($q_id)
        {
            global $wpdb;
            if ($q_id == '') {
                return array(
                    'result' => -1,
                    'message' => esc_html__('Data invalid', 'revy')
                );
            }
            $sql = "SELECT  q_id, q_first_name, q_last_name, q_email, q_phone,  q_address, q_device_type, q_brand_name, q_model,  
                            q_color, q_serial_number,  q_detail_problem, q_image_url
                    FROM {$wpdb->prefix}rp_quote_form 
                    WHERE q_id=%d";
            $sql = $wpdb->prepare($sql, $q_id);
            $mail_info = $wpdb->get_results($sql);


            if (count($mail_info) <= 0 ) {
                return;
            }

            $mail_info = $mail_info[0];

            $setting_db = Revy_DB_Setting::instance();
            $setting = $setting_db->get_setting();
            $email_templates = $setting_db->get_email_template();
            $template = '';

            foreach ($email_templates as $tmpl) {
                if ( $tmpl['template'] === 'quote_form') {
                    $template = $tmpl;
                    break;
                }
            }

            $subject = $message = '';

            $subject = $template['quote_form_subject'];
            $message = $template['quote_form_message'];

            if($subject1='' && $message!=''){
                Revy_Utils::makeMailContent($subject, $message, $mail_info, $setting);
                return Revy_Utils::sendMail(array(
                    'mailer' => $setting['mailer'],
                    'smtp_host' => $setting['smtp_host'],
                    'smtp_port' => $setting['smtp_port'],
                    'smtp_username' => $setting['smtp_username'],
                    'smtp_password' => $setting['smtp_password'],
                    'encryption' => $setting['smtp_encryption'],
                    'from_name' => $setting['send_from_name'],
                    'from_name_label' => isset($setting['send_from_name_label']) ? $setting['send_from_name_label'] : $setting['send_from_name'],
                    'send_to' => $mail_info->c_email,
                    'cc_email' => $setting['cc_to'],
                    'bcc_email' => $setting['bcc_to'],
                    'subject' => $subject,
                    'message' => $message
                ));
            }
        }

        private function save_media_file($media_data, $type, $mime)
        {
            $revy_setting = Revy_DB_Setting::instance();
            $setting =  $revy_setting->get_setting();
            $max_file_size = $setting['image_file_size'];

            $media_data = base64_decode($media_data);
            $upload_dir = wp_get_upload_dir();
            $upload_folder = $upload_dir['path'];
            $upload_url = $upload_dir['url'];

            $file_name = uniqid() . '.' . ($type == 'video' ? explode('/', $mime)[1] : 'jpg');
            $output_filename = $upload_folder . '/' . $file_name;
            $result_write_file = file_put_contents($output_filename, $media_data);
            $file_size = filesize($output_filename);
            $image_size = getimagesize($output_filename);

            if(!is_array($image_size) || $image_size===FALSE){
                unlink($output_filename);
                return array(
                    'result' => -1,
                    'message' => esc_html__('The file type is not allow', 'revy')
                );
            }

            if($file_size > ($max_file_size * 1024 * 1024)){
                unlink($output_filename);
                return array(
                    'result' => -1,
                    'message' => esc_html__('The file size is too large, please choose another file < ', 'revy'). $setting['image_file_size'].'Mb'
                );
            }

            global $wpdb;
            $sql = "SELECT ID FROM {$wpdb->prefix}users";
            $users = $wpdb->get_results($sql);
            $post_author = 1;
            foreach ($users as $u) {
                $user_meta = get_userdata($u->ID);
                $user_roles = $user_meta->roles;
                if (in_array('administrator', $user_roles)) {
                    $post_author = $u->ID;
                    break;
                }
            }

            $attach_id = wp_insert_attachment(array(
                'guid' => $upload_url . '/' . $file_name,
                'post_mime_type' => $mime,
                'post_title' => $file_name,
                'post_content' => '',
                'post_status' => 'inherit',
                'post_author' => $post_author,
                'post_parent' => 0
            ), $output_filename, 0);

            if (!is_wp_error($attach_id)) {
                $attach_data = wp_generate_attachment_metadata($attach_id, $output_filename);
                wp_update_attachment_metadata($attach_id, $attach_data);
            }
            $url_full = wp_get_attachment_image_url($attach_id, 'full');

            return array(
                'id' => $attach_id,
                'url_full' => $url_full,
            );
        }

        public function get_quotes()
        {
            global $wpdb;
            $page = isset($_REQUEST['page']) && $_REQUEST['page'] ? $_REQUEST['page'] : 1;
            $start_date = isset($_REQUEST['start_date']) && $_REQUEST['start_date'] ? $_REQUEST['start_date'] : '';
            $start_time = isset($_REQUEST['start_time']) && $_REQUEST['start_time'] ? $_REQUEST['start_time'] : '00:00';
            $end_date = isset($_REQUEST['end_date']) && $_REQUEST['end_date'] ? $_REQUEST['end_date'] : '';
            $end_time = isset($_REQUEST['end_time']) && $_REQUEST['end_time'] ? $_REQUEST['end_time'] : '23:59';
            $q_status = isset($_REQUEST['q_status']) ? $_REQUEST['q_status'] : '';
            $q_customer_name = isset($_REQUEST['q_customer_name']) ? $_REQUEST['q_customer_name'] : '';

            $start_date .= ' '. $start_time;
            $end_date .= ' '. $end_time;

            $sql = "SELECT q_id, q_first_name, q_last_name, q_email, q_phone_code, q_phone, q_address, q_device_type, q_brand_name, q_model, q_color, q_serial_number, q_image_url, q_status,
                            q_create_date
                    FROM {$wpdb->prefix}rp_quote_form
                    WHERE q_status!=%d ";

            $sql = $wpdb->prepare($sql, -1);
            if ($q_customer_name) {
                $search_key = '%'.$q_customer_name.'%';
                $sql .= " AND (q_first_name LIKE %s OR q_last_name LIKE %s OR q_email LIKE %s) ";
                $sql  =$wpdb->prepare($sql, $search_key, $search_key, $search_key);
            }

            if ($q_status != '') {
                $sql .= " AND q_status = %d";
                $sql = $wpdb->prepare($sql, $q_status);
            }

            if ($start_date && $end_date) {
                $sql .= " AND DATE(q_create_date) BETWEEN %s AND %s";
                $sql = $wpdb->prepare($sql, $start_date, $end_date);
            }
            $sql.=' order by q_id DESC';

            $quotes = $wpdb->get_results($sql);

            $total = count($quotes);

            $db_setting = Revy_DB_Setting::instance();
            $setting = $db_setting->get_setting();

            $item_per_page = isset($setting['item_per_page']) ? $setting['item_per_page'] : 10;
            $number_of_page = $total / $item_per_page + ($total % $item_per_page > 0 ? 1 : 0);
            $page = $page > $number_of_page ? $number_of_page : $page;
            $page = ($page - 1) * $item_per_page;
            $quotes = array_slice($quotes, $page, $item_per_page);

            $phone_code = '';
            for($i=0; $i< count($quotes); $i++){
                $phone_code = explode(',', $quotes[$i]->q_phone_code);
                $quotes[$i]->q_phone_code = count($phone_code)>=2 ? '('.$phone_code[0].')' : $quotes[$i]->q_phone_code;
            }

            return array(
                'total' => $total,
                'quotes' => $quotes
            );
        }

        public function get_quote_by_id()
        {
            global $wpdb;
            $q_id = isset($_REQUEST['q_id']) && $_REQUEST['q_id'] ? $_REQUEST['q_id'] : '';

            $sql = "SELECT q_id, q_first_name, q_last_name, q_email, q_phone_code, q_phone, q_address, q_device_type, q_brand_name, q_model, q_color, q_serial_number, q_image_url, q_status,
                            q_create_date, q_detail_problem
                    FROM {$wpdb->prefix}rp_quote_form
                    WHERE  q_id = %d ";
            $sql = $wpdb->prepare($sql, $q_id);
            $quote = $wpdb->get_results($sql);
            $phone_code = '';
            for($i=0; $i< count($quote); $i++){
                $phone_code = explode(',', $quote[$i]->q_phone_code);
                $quote[$i]->q_phone_code = count($phone_code)>=2 ? '('.$phone_code[0].')' : $quote[$i]->q_phone_code;
            }
            return is_array($quote) && count($quote)>0 ? $quote[0] : array();
        }

        public function delete_quote()
        {
            global $wpdb;
            $q_id = isset($_REQUEST['q_id']) && $_REQUEST['q_id'] ? $_REQUEST['q_id'] : '';
            $sql = "DELETE FROM {$wpdb->prefix}rp_quote_form WHERE  q_id = %d ";
            $sql = $wpdb->prepare($sql, $q_id);
            $result = $wpdb->query($sql);
            return array(
                'result' => $result,
                'message' => $result > 0 ? esc_html__(' quote have been deleted', 'revy') : esc_html__('Data is invalid', 'revy')
            );
        }
    }
}