"use strict";
var RevyBookingFlow = {
    is_attribute_change: 0,
    weekly_timeslot: [],
    b_date: '',
    b_time: 0,
    device_name: '',
    brand_name: '',
    multiple_brand_name: [],
    model_name: '',
    multiple_model_name: [],
    group_name: '',
    service_type: '',
    device_id: 0,
    brand_id: 0,
    model_id: 0,
    model_color: '',
    cat_id: 0,
    garage_id: 0,
    garage_title: '',
    garage_address: '',
    garage_desc: '',
    services_selected: [],
    garage_near_me: [],
    b_total_pay: 0,
    s_id: [],
    disable_animation: 0,
    delivery_fee: 0,
    delivery_method: 3 //default mail in ; 1: FixItHome, 2:Carry In, 3: Mail in
};

(function ($) {
    RevyBookingFlow.init = function () {
        RevyBookingFlow.initField();
        RevyBookingFlow.initStripeCardInput();
        RevyMain_FE.registerOnClick($('.fat-booking-container.fat-sb-flow-layout'));
        RevyMain_FE.registerOnChange($('.fat-booking-container.fat-sb-flow-layout'));
        RevyMain_FE.registerOnKeyUp($('.fat-search-box'));
        if (!$('.fat-sb-flow-layout').hasClass('hide-map')) {
            RevyMain_FE.getClientLocation();
        }

        //process for default value
        RevyBookingFlow.initDefaultValue();
        $(window).scroll(function () {
            RevyBookingFlow.anchorRepairList();
        })

        //process next step
        $('body').on('revy_next_step', function(){
            RevyBookingFlow.nextProgressBar();
        })
        $('body').on('revy_prev_step', function(){
            RevyBookingFlow.prevProgressBar();
        })

        //fix anchor
        $('a[href^="#"]').on('click', function(event){
            var anchor = $(this).attr('href');
            if($(anchor).length > 0){
                event.preventDefault();
                RevyMain_FE.scrollTo($(anchor),80);
                return false;
            }
        })

        //init for fix brand, device and model
        var fix_brand_id = $('.fat-booking-container.fat-sb-flow-layout').attr('data-brand'),
            fix_cat_id = $('.fat-booking-container.fat-sb-flow-layout').attr('data-cat'),
            fix_device_id = $('.fat-booking-container.fat-sb-flow-layout').attr('data-device'),
            fix_model_id = $('.fat-booking-container.fat-sb-flow-layout').attr('data-model');
        if(typeof fix_brand_id !='undefined' && fix_brand_id!='' && fix_brand_id!='0' && $('.fat-booking-container').hasClass('brand-model-step')){
            var container = $('.fat-booking-container');
            container.css('opacity', 0);

            RevyBookingFlow.disable_animation = 1;
            setTimeout(function(){
                if($('.brand-step .fat-sb-item[data-brand-id="' + fix_brand_id + '"]').length >0){
                    RevyMain_FE.registerOnClick($('.fat-booking-container.fat-sb-flow-layout'));

                    $('.brand-step .fat-sb-item[data-brand-id="' + fix_brand_id + '"]').trigger('click');
                    setTimeout(function(){
                        if($('.category-step .fat-sb-item[data-cat-id="' + fix_cat_id + '"]').length >0){
                            RevyMain_FE.registerOnClick($('.fat-booking-container.fat-sb-flow-layout'));
                            $('.category-step .fat-sb-item[data-cat-id="' + fix_cat_id + '"]').trigger('click');
                            /*setTimeout(function(){
                                RevyMain_FE.registerOnClick($('.fat-booking-container.fat-sb-flow-layout'));
                                if($('.model-step .fat-sb-item[data-model-id="' + fix_model_id + '"]').length >0){
                                    $('.model-step .fat-sb-item[data-model-id="' + fix_model_id + '"]').trigger('click');
                                }
                                container.css('opacity', 1);
                            },500)*/
                        }else{
                            RevyBookingFlow.disable_animation = 0;
                            container.css('opacity',1);
                        }
                    },500)
                }else{
                    RevyBookingFlow.disable_animation = 0;
                    container.css('opacity', 1);
                }
            },1000);

            setTimeout(function () {
                container.css('opacity', 1);
            },2500)
        }

    };

    RevyBookingFlow.initDefaultValue = function () {
        var container = $('.fat-booking-container'),
            device_id = container.attr('data-device'),
            brand_id = container.attr('data-brand'),
            model_id = container.attr('data-model');

        device_id = typeof device_id != 'undefined' ? device_id : 0;
        brand_id = typeof brand_id != 'undefined' ? brand_id : 0;
        model_id = typeof model_id != 'undefined' ? model_id : 0;
        if (device_id > 0) {
            $('.fat-sb-item[data-device-id="' + device_id + '"]', container).trigger('click');
            if (brand_id > 0) {
                setTimeout(function () {
                    if (container.hasClass('brand-model-step')) {
                        $('.fat-sb-item[data-brand-id="' + device_id + '"]', container).trigger('click');
                    } else {
                        $('.ui.dropdown.brands', container).suidropdown('set selected', brand_id);
                    }
                    if (model_id > 0) {
                        setTimeout(function () {

                            if (container.hasClass('brand-model-step')) {
                                $('.fat-sb-item[data-model-id="' + device_id + '"]', container).trigger('click');
                            } else {
                                $('.fat-semantic-container .ui.dropdown.models').suidropdown('set selected', model_id);
                            }
                            $('.fat-booking-container').removeClass('has-default-value');
                        }, 500)
                    } else {
                        $('.fat-booking-container').removeClass('has-default-value');
                    }
                }, 500);
            } else {
                $('.fat-booking-container').removeClass('has-default-value');
            }
        }
    }

    RevyBookingFlow.initField = function () {
        $('.fat-booking-container.fat-sb-flow-layout').each(function () {
            var container = $(this);

            //dropdown
            $('.ui.dropdown', container).each(function () {
                var self = $(this);
                self.suidropdown({
                    clearable: self.hasClass('clearable')
                });
            });
            container.addClass('has-init');

            //tooltip
            $('.apoint-tooltip').popup({
                position: 'bottom center'
            });

            RevyMain_FE.initNumberField(container);
        });
    };

    RevyBookingFlow.initCalendar = function () {
        var container = $('.fat-booking-container'),
            startOfWeek = moment().startOf('week'),
            endOfWeek = moment().endOf('week'),
            filter = startOfWeek.format('MMM DD') + ' - ' + endOfWeek.format('MMM DD, YYYY');

        $('.fat-sb-calendar-layout', container).css('opacity', 1);
        RevyBookingFlow.changeWeek(0, startOfWeek.format('YYYY-MM-DD'), container);

        $('.fat-sb-calendar-wrap span.next-week', container).off('click').on('click', function () {
            var week = $(this).closest('.calendar-filter').attr('data-week');
            RevyBookingFlow.changeWeek(1, week, container);
        });

        $('.fat-sb-calendar-wrap span.prev-week', container).off('click').on('click', function () {
            var week = $(this).closest('.calendar-filter').attr('data-week');
            RevyBookingFlow.changeWeek(-1, week, container);
        });

        $('.fat-sb-calendar-layout', container).addClass('has-init');

        if ($('.fat-sb-calendar-wrap .week-date:not(.disabled)', container).length == 0) {
            $('.fat-sb-calendar-wrap span.next-week', container).trigger('click');
        }

    };

    RevyBookingFlow.initStripeCardInput = function () {
        if ($('form#stripe-payment-form').length == 0) {
            return;
        }
        $('form#stripe-payment-form').each(function () {
            var stripe_form = $(this),
                booking_container = stripe_form.closest('.fat-booking-container'),
                pk = stripe_form.attr('data-pk'),
                card_element_id = $('.card-element', booking_container).attr('id'),
                card_errors_id = $('.card-errors', booking_container).attr('id');
            if (typeof pk == 'undefined' || pk == '') {
                return;
            }

            RevyBookingFlow.stripe = Stripe(pk);
            var elements = RevyBookingFlow.stripe.elements(),
                style = {
                    base: {
                        iconColor: '#666ee8',
                        color: '#31325f',
                        fontWeight: 400,
                        fontFamily:
                            '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
                        fontSmoothing: 'antialiased',
                        fontSize: '16px',
                        '::placeholder': {
                            color: '#aab7c4',
                        },
                        ':-webkit-autofill': {
                            color: '#666ee8',
                        },
                    },
                };

            // Create an instance of the card Element.
            RevyBookingFlow.card = elements.create('card', {style, hidePostalCode: true});

            // Add an instance of the card Element into the `card-element` <div>.
            RevyBookingFlow.card.mount('#' + card_element_id);

            // Handle real-time validation errors from the card Element.
            RevyBookingFlow.card.addEventListener('change', function (event) {
                var displayError = document.getElementById(card_errors_id);
                if (event.error) {
                    displayError.textContent = event.error.message;
                } else {
                    displayError.textContent = '';
                }
            });

        });
    };

    RevyBookingFlow.searchNameOnKeyUp = function (self) {
        var search_wrap = self.closest('.ui.input'),
            type = self.attr('data-type'),
            keyword = self.val().toLowerCase();

        if (self.val().length >= 2 || self.val() == '') {
            search_wrap.addClass('loading');
            var name = '',
                step_wrap = '';

            if(type =='brand'){
                step_wrap = $('.brand-step');
            }
            if(type =='model'){
                step_wrap = $('.model-step');
            }
            if(type =='service'){
                step_wrap = $('.service-step');
            }

            $('.fat-sb-item',step_wrap).each(function () {
                name = $(this).attr('data-name').toLowerCase();
                if (name.indexOf(keyword) == -1) {
                    $(this).fadeOut();
                }else{
                    $(this).fadeIn();
                }
            })

            if (self.val().length >= 2) {
                search_wrap.addClass('active-search');
            }
            if (self.val() == '') {
                search_wrap.removeClass('active-search');
                $('.fat-sb-item', step_wrap).fadeIn();
            }
            setTimeout(function(){
                search_wrap.removeClass('loading');
            },500)

        }
    }

    RevyBookingFlow.closeSearchOnClick = function(self){
        var search_wrap = self.closest('.ui.ui-search');
        $('input',search_wrap).val('');
        $('input',search_wrap).trigger('keyup');
    };

    RevyBookingFlow.changeWeek = function (direct, start_week, container) {
        //direct: 1 -> next, -1: previous
        var diff = 0,
            current_date = moment(),
            server_current_date = moment('YYYY-MM-DD H:m:s', RevyMain_FE.data.now),
            date_class = '',
            inWorkingHour = true;

        current_date = server_current_date.isAfter(current_date) ? server_current_date : current_date

        $('.week-day-header .week-date', container).removeClass('day-off');
        $('.week-date span.selected', container).removeClass('selected');
        $('.ui.dropdown.time-options item', container).remove();
        $('.ui.dropdown.time-options', container).suidropdown('clear');
        $('.ui.dropdown.time-options', container).suidropdown('restore defaults');

        if (typeof revy_data.limit_booking_before != 'undefined' && parseInt(revy_data.limit_booking_before) > 0) {
            current_date.add(parseInt(revy_data.limit_booking_before), 'd');
        }
        current_date = moment(current_date.format('YYYY-MM-DD'));


        if (direct == -1) {
            diff = -7;
        }
        if (direct == 1) {
            diff = 7;
        }
        var startOfWeek = moment(start_week).add(diff, 'd').startOf('week'),
            endOfWeek = moment(start_week).add(diff, 'd').endOf('week'),
            filter = startOfWeek.format('MMM DD') + ' - ' + endOfWeek.format('MMM DD, YYYY');

        $('.fat-sb-calendar-wrap .calendar-filter').attr('data-week', startOfWeek.format('YYYY-MM-DD'));
        $('.fat-sb-calendar-wrap span.current-week').html(filter);

        $('.week-day-header.sun .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.sun .week-header-mobile').html(revy_data.mon + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.sun .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.mon .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.mon .week-header-mobile').html(revy_data.tue + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.mon .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.tue .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.tue .week-header-mobile').html(revy_data.wed + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.tue .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.wed .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-content.wed  .week-header-mobile').html(revy_data.thu + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.wed .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.thu .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.thu  .week-header-mobile').html(revy_data.fri + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.thu .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.fri .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.fri  .week-header-mobile').html(revy_data.sat + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.fri .week-date').removeClass('disabled').addClass(date_class);


        startOfWeek = moment(startOfWeek).add(1, 'd');
        $('.week-day-header.sat .week-date span').html(startOfWeek.format('DD')).attr('data-date', startOfWeek.format('YYYY-MM-DD'));
        $('.week-day-header.sat  .week-header-mobile').html(revy_data.sun + ', ' + startOfWeek.format('DD') + '-' + startOfWeek.format('MMM'));
        inWorkingHour = RevyBookingFlow.inWorkingHour(startOfWeek);
        date_class = startOfWeek.isBefore(current_date) || !inWorkingHour ? 'disabled' : '';
        $('.week-day-header.sat .week-date').removeClass('disabled').addClass(date_class);

        if (RevyBookingFlow.delivery_method == 2) { // Carry In
            RevyBookingFlow.initWeeklyTimeSlot(container);
        }
    }

    RevyBookingFlow.inWorkingHour = function (date) {
        var day_of_week = date.days();
        day_of_week = day_of_week == 0 ? 8 : (day_of_week + 1);
        day_of_week = day_of_week.toString();

        if (typeof revy_flow_data != 'undefined' && typeof revy_flow_data.day_off != 'undefined') {
            for (let dof of revy_flow_data.day_off) {
                if (dof == date.format('YYYY-MM-DD')) {
                    $('.week-date span[data-date="' + dof + '"]').closest('.week-date').addClass('day-off');
                    return false;
                }
            }
        }

        if (typeof revy_flow_data != 'undefined' && typeof revy_flow_data.working_hour != 'undefined') {
            var wh = _.filter(revy_flow_data.working_hour, function (item) {
                return item.es_day == day_of_week && item.es_enable == '1';
            });
            if (wh.length > 0) {
                return true;
            } else {
                return false;
            }
        }

        return false;
    };

    RevyBookingFlow.deviceOnClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            parent_step = $(elm).closest('.device-step'),
            next_step = $('.brand-model-step', container),
            device_item = $('.fat-it-inner', elm).clone(false).addClass('no-hover');

        RevyBookingFlow.device_id = $(elm).attr('data-device-id');
        parent_step.fadeOut(function () {
            RevyBookingFlow.bindBrandToDropdown(RevyBookingFlow.device_id, container);
            $('.fat-sb-item', next_step).empty().append(device_item);

            //reset models dropdown
            $('.ui.dropdown.models', container).suidropdown('clear');

            $('.brand-model-step .fat-sb-item .fat-it-inner', container).off('click').on('click', function () {
                $('.field.brand-field .ui.selection.dropdown.brands', container).trigger('click');
            })

            next_step.fadeIn();
        })

    };

    RevyBookingFlow.deviceBrandModelStepOnClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            parent_step = $(elm).closest('.fat-sb-list-devices');

        RevyBookingFlow.device_id = $(elm).attr('data-device-id');
        parent_step.fadeOut(function () {
            RevyBookingFlow.bindBrandToStep(RevyBookingFlow.device_id, container);
            $('body').trigger('revy_next_step');
        })

    };

    RevyBookingFlow.nextProgressBar = function(){
        if($('li.fat-progress-item.active').length > 0 && $('li.fat-progress-item.active').last().next().length > 0 ){
            $('li.fat-progress-item.active').last().next().addClass('active');
        }
    }

    RevyBookingFlow.prevProgressBar = function(){
        if($('li.fat-progress-item.active').length > 0 && $('li.fat-progress-item.active').last().prev().length > 0 ){
            $('li.fat-progress-item.active').last().removeClass('active');
        }
    }

    RevyBookingFlow.brandOnClick = function (elm) {

        var container = $(elm).closest('.fat-booking-container'),
            parent_step = $(elm).closest('.fat-sb-list-brand'),
            brand_id = $(elm).attr('data-brand-id'),
            duration = RevyBookingFlow.disable_animation == 0 ? 0 : 400;

        RevyBookingFlow.brand_id = brand_id;
        RevyBookingFlow.brand_name = $(elm).attr('data-name');
        RevyBookingFlow.multiple_brand_name.push($(elm).attr('data-name'));
        RevyBookingFlow.bindCategoryToStep(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);
        $('body').trigger('revy_next_step');

    }

    RevyBookingFlow.categoryOnClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            parent_step = $(elm).closest('.fat-sb-list-category'),
            cat_id = $(elm).attr('data-cat-id');

        RevyBookingFlow.cat_id = cat_id;
        RevyBookingFlow.bindModelToStep(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);
        $('body').trigger('revy_next_step');
    }

    RevyBookingFlow.chooseCategoryByDefault = function (cat_id, container) {
        RevyBookingFlow.cat_id = cat_id;
        RevyBookingFlow.bindModelToStep(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);
        $('body').trigger('revy_next_step');
    }

    RevyBookingFlow.modelOnClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            parent_step = $(elm).closest('.fat-sb-list-model'),
            model_id = $(elm).attr('data-model-id');

        RevyBookingFlow.model_color = ''; // reset color for model
        RevyBookingFlow.model_id = model_id;
        RevyBookingFlow.model_name = $(elm).attr('data-name');

        RevyBookingFlow.multiple_model_name.push($(elm).attr('data-name'));
        RevyBookingFlow.resetServiceSelected(container);
        RevyBookingFlow.bindServices(RevyBookingFlow.model_id, container);

        RevyBookingFlow.showColorPopup(model_id, function () {
            parent_step.fadeOut(function () {
                RevyBookingFlow.goToTop(container);
                $('.fat-sb-list-services', container).fadeIn();
                $('body').trigger('revy_next_step');
            })
        })
    };

    RevyBookingFlow.showColorPopup = function (model_id, callback) {
        var model = _.filter(revy_flow_data.models, function (item) {
            return parseInt(item.rm_id) == parseInt(model_id);
        });
        if (model.length > 0 && typeof model[0].rm_colors != 'undefined' && model[0].rm_colors != '') {
            console.log(model[0].rm_colors);
            var colors = model[0].rm_colors.split(',');
            RevyMain_FE.showPopup('fat-sb-popup-color-template', '', [], function () {
                $('.fat-sb-color-list .color-item').hide();
                $('.fat-sb-color-list .fat-sb-popup-title .fat-model-name').html(RevyBookingFlow.model_name);

                for (let id of colors) {
                    $('.fat-sb-color-list .color-item.color-' + id).show();
                }
                $('.fat-sb-color-list .color-item').on('click', function () {
                    RevyBookingFlow.model_color = $(this).attr('data-name');
                    $('.ui.modal.fat-sb-color-list').suimodal('hide');
                    if (callback) {
                        callback();
                    }
                });

                $('.fat-close-modal').on('click', function(){
                    RevyBookingFlow.model_color = '';
                    $('.ui.modal.fat-sb-color-list').suimodal('hide');
                    if (callback) {
                        callback();
                    }
                })
            });
        } else {
            if (callback) {
                callback();
            }
        }
    };

    RevyBookingFlow.serviceOnClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            service_id = $(elm).attr('data-service-id'),
            service_name = $(elm).attr('data-service-name'),
            min_price = $(elm).attr('data-min-price'),
            min_price_format = $(elm).attr('data-min-price-format'),
            item = '';

        service_id = parseInt(service_id);
        if (RevyBookingFlow.is_attribute_change == 1) {
            return;
        }

        RevyBookingFlow.s_id = _.filter(RevyBookingFlow.s_id, function (id) {
            return id != service_id;
        });
        RevyBookingFlow.s_id.push(service_id);

        if ($('.price-attribute .item', elm).length > 1 && !$(elm).hasClass('one-attribute') && !$(elm).hasClass('no-attribute')) {
            $('.ui.dropdown.attribute', elm).suidropdown('show');
        } else {
            var attr_code = '',
                attr_title = '',
                attr_value = '';
            if ($('.price-attribute .item', elm).length == 1) {
                item = $('.ui.dropdown.attribute .menu .item:first-child', elm);
                attr_code = item.attr('data-code');
                attr_title = item.attr('data-title');
                attr_value = item.attr('data-value');
            }
            RevyBookingFlow.addToRepairList(service_id, service_name, min_price, min_price_format, container, attr_code, attr_title, attr_value);
            elm.addClass('selected');
        }

    };

    RevyBookingFlow.garageOnClick = function (elm) {
        var container = elm.closest('.fat-booking-container');
        RevyBookingFlow.garage_id = elm.attr('data-garage-id');
        RevyBookingFlow.garage_title = $('.item-title', elm).html();
        RevyBookingFlow.garage_address = $('.item-address', elm).html();
        RevyBookingFlow.garage_desc = $('.item-desc', elm).html();
        $('.fat-sb-list-garages', container).fadeOut(function () {
            RevyBookingFlow.bindRepairSummary(container);
            if (RevyBookingFlow.delivery_method == 2) {
                RevyBookingFlow.initWeeklyTimeSlot(container);
            }
            $('.repair-summary .time-meta', container).hide();

            $('.fat-sb-order-wrap', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                if ($('.payment-method-wrap .fat-list-gateway .gateway-item').length == 1) {
                    $('.payment-method-wrap .fat-list-gateway .gateway-item').trigger('click');
                }
            });
        })
    }

    RevyBookingFlow.addToRepairList = function (service_id, service_name, price, price_format, container, attr_code, attr_title, attr_value) {

        var price = parseFloat(price);
        price_format = price > 0 ? price_format : '';

        //remove service in Repair list
        if ($('.fat-sb-repair-list a.fat-sb-remove-service[data-id="' + service_id + '"]', container).length == 1) {
            $('.fat-sb-repair-list a.fat-sb-remove-service[data-id="' + service_id + '"]', container).addClass('no-animation no-reset-default').trigger('click');
        }

        var item = $('<li><span class="service-name">' + service_name + '</span><br/>' +
            '<span class="service-attribute">' + attr_title + ' ' + attr_value + '</span><br/>' +
            '<span class="model-name">' + RevyBookingFlow.model_name + (RevyBookingFlow.model_color != '' ? ' ' + RevyBookingFlow.model_color : '') + '</span>' +
            '<span class="service-price">' + price_format + '<a href="javascript:;?>" class="fat-sb-remove-service" data-id="' + service_id + '" data-onClick="RevyBookingFlow.removeService">' +
            '<i class="trash alternate outline icon"></i></a> </span>');

        $('.fat-sb-list-services .fat-sb-repair-list ul', container).append(item);
        RevyMain_FE.registerOnClick(item);
        $('.fat-sb-repair-list button.fat-bt-next', container).removeClass('disabled');

        //add service to list selected
        var service = _.findWhere(revy_flow_data.services, {s_id: service_id.toString()});
        if (typeof service != 'undefined') {
            RevyBookingFlow.services_selected.push({
                s_name: service.s_name,
                s_id: service_id,
                s_model_id: RevyBookingFlow.model_id,
                s_model_name: RevyBookingFlow.model_name,
                s_model_color: RevyBookingFlow.model_color,
                s_do_together: service.s_do_together,
                s_tax: service.s_tax,
                s_duration: service.s_duration,
                s_break_time: service.s_break_time,
                s_max_slot: service.s_maximum_slot,
                s_price: price,
                s_garage_ids: service.s_garage_ids,
                s_attr_code: attr_code,
                s_attr_title: attr_title,
                s_attr_value: attr_value
            });
        }

        //auto go to repair list for mobile and tablet device
        if (container.width() < 768) {
            RevyBookingFlow.goToRepairList(container);
        }

    };

    RevyBookingFlow.removeService = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            service_id = $(elm).attr('data-id'),
            parent = $(elm).closest('li'),
            timeout = 400;

        if (!elm.hasClass('no-reset-default')) {
            $('.fat-sb-item[data-service-id="' + service_id + '"] .ui.dropdown.attribute', container).suidropdown('restore defaults');
        }
        timeout = elm.hasClass('no-animation') ? 0 : timeout;
        parent.fadeOut(timeout, function () {
            parent.remove();
            if ($('.fat-sb-repair-list ul li', container).length == 0) {
                $('.fat-sb-repair-list button.fat-bt-next', container).addClass('disabled');
            } else {
                $('.fat-sb-repair-list button.fat-bt-next', container).removeClass('disabled');
            }
            $('.fat-sb-service-inner .fat-sb-item[data-service-id="' + service_id + '"]', container).removeClass('selected');
            RevyBookingFlow.services_selected = _.filter(RevyBookingFlow.services_selected, function (item) {
                return item.s_id != service_id;
            });

        });

    };

    RevyBookingFlow.brandOnChange = function (value, text, $choice, self) {
        if (value != '') {
            var container = $(self).closest('.fat-booking-container');
            /* $('.model-field', container).addClass('fadein');*/
            //$('.model-field .field-inner', container).fadeIn();
            RevyBookingFlow.brand_id = value;
            RevyBookingFlow.brand_name = text;
            RevyBookingFlow.multiple_brand_name.push(text);
            //RevyBookingFlow.bindModelToDropdown(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);

            $('.category-field .field-inner', container).fadeIn();
            RevyBookingFlow.bindCategoryToDropdown(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);
        }
    };

    RevyBookingFlow.categoryOnChange = function (value, text, $choice, self) {
        if (value != '') {
            var container = $(self).closest('.fat-booking-container');

            $('.model-field .field-inner', container).fadeIn();
            RevyBookingFlow.cat_id = value;
            RevyBookingFlow.bindModelToDropdown(RevyBookingFlow.device_id, RevyBookingFlow.brand_id, container);
        }
    };

    RevyBookingFlow.modelOnChange = function (value, text, $choice, self) {
        if (value != '') {
            var container = $(self).closest('.fat-booking-container');
            RevyBookingFlow.model_id = value;
            RevyBookingFlow.model_name = text;
            RevyBookingFlow.multiple_model_name.push(text);

            if (container.hasClass('has-group-filter')) {
                RevyBookingFlow.bindGroupToDropdown(RevyBookingFlow.model_id, container);
                $('.group-field .field-inner', container).fadeIn();

            } else {
                RevyBookingFlow.group_name = '';
                RevyBookingFlow.resetServiceSelected(container);
                RevyBookingFlow.bindServices(RevyBookingFlow.model_id, container);
                var $title_elm = $('.fat-sb-list-services .fat-sb-title');
                $title_elm.html($('#service_step_title').html() + ' ' + RevyBookingFlow.model_name);
                $('.fat-sb-list-devices', container).fadeOut(function () {
                    RevyBookingFlow.goToTop(container);
                    $('.fat-sb-list-services', container).fadeIn();
                })
            }
        }
    };

    RevyBookingFlow.groupOnChange = function (value, text, $choice, self) {
        if (value != '') {
            var container = $(self).closest('.fat-booking-container');
            RevyBookingFlow.group_name = value;

            if (container.hasClass('has-service-type-filter')) {
                $('.service-type-field .field-inner', container).fadeIn();
            } else {
                RevyBookingFlow.resetServiceSelected(container);
                RevyBookingFlow.bindServices(RevyBookingFlow.model_id, container);
                $('.fat-sb-list-devices', container).fadeOut(function () {
                    RevyBookingFlow.goToTop(container);
                    $('.fat-sb-list-services', container).fadeIn();
                })
            }
        }
    };

    RevyBookingFlow.serviceTypeOnChange = function (value, text, $choice, self) {
        if (value != '') {
            var container = $(self).closest('.fat-booking-container');
            RevyBookingFlow.service_type = value;

            RevyBookingFlow.resetServiceSelected(container);
            RevyBookingFlow.bindServices(RevyBookingFlow.model_id, container);
            $('.fat-sb-list-devices', container).fadeOut(function () {
                RevyBookingFlow.goToTop(container);
                $('.fat-sb-list-services', container).fadeIn();
            })
        }
    };

    RevyBookingFlow.attributeOnChange = function (value, text, $choice, self) {
        if (typeof $choice != 'undefined') {
            var container = self.closest('.fat-booking-container'),
                service_item = self.closest('.fat-sb-item'),
                service_id = service_item.attr('data-service-id'),
                service_name = service_item.attr('data-service-name'),
                price = $choice.attr('data-price'),
                price_format = $choice.attr('data-price-format'),
                attr_code = $choice.attr('data-code'),
                attr_title = $choice.attr('data-title'),
                attr_value = $choice.attr('data-value');

            RevyBookingFlow.addToRepairList(service_id, service_name, price, price_format, container, attr_code, attr_title, attr_value);

            service_item.addClass('selected');

            $('.fat-min-price', service_item).html(price_format);

            //prevent service on click
            RevyBookingFlow.is_attribute_change = 1;
            setTimeout(function () {
                RevyBookingFlow.is_attribute_change = 0;
            }, 500)
        }
    };

    RevyBookingFlow.bindBrandToDropdown = function (device_id, container) {
        var elm_brand = $('.ui.dropdown.brands', container),
            elm_brand_menu = $(' > .menu', elm_brand),
            brands = [];

        brands = _.filter(revy_flow_data.brands, function (item) {
            return _.indexOf(item.rb_device_ids.split(','), device_id) > -1;
        });

        elm_brand.addClass('fat-loading');
        elm_brand.append('<div class="ui button loading"></div>');
        elm_brand_menu.val('');
        $('.item', elm_brand_menu).remove();
        elm_brand.suidropdown('clear');
        for (let brand of brands) {
            elm_brand_menu.append('<div class="item" data-value="' + brand.rb_id + '">' + brand.rb_name + '</div>');
        }
        elm_brand.removeClass('fat-loading');
        $('.ui.button.loading', elm_brand).remove();
    };

    RevyBookingFlow.bindBrandToStep = function (device_id, container) {
        var brand_step = $('.fat-sb-list-brand', container),
            brand_list = $('.fat-sb-item-inner-wrap', brand_step),
            brands = [];

        brands = _.filter(revy_flow_data.brands, function (item) {
            return _.indexOf(item.rb_device_ids.split(','), device_id) > -1;
        });

        var template = wp.template('fat-brand-item-template'),
            items = $(template(brands));

        brand_list.empty();
        brand_list.append(items);

        $('.fat-sb-list-devices').fadeOut(function () {
            brand_step.removeClass('fat-hidden-step').fadeIn();
            RevyMain_FE.registerOnClick(brand_step);
            RevyMain_FE.registerOnClick($('.fat-sb-calendar-wrap'));
        })

    };

    RevyBookingFlow.bindCategoryToDropdown = function (device_id, brand_id, container) {

        var elm_category = $('.ui.dropdown.category', container),
            elm_category_menu = $(' > .menu', elm_category),
            categories = [];
        categories = _.filter(revy_flow_data.categories, function (item) {
            return item.c_brand_id == brand_id && item.c_device_id == device_id;
        });

        elm_category.addClass('fat-loading');
        elm_category.append('<div class="ui button loading"></div>');
        elm_category_menu.val('');
        $('.item', elm_category_menu).remove();
        elm_category.suidropdown('clear');
        elm_category_menu.append('<div class="item" data-value=""></div>');
        for (let cat of categories) {
            elm_category_menu.append('<div class="item" data-value="' + cat.c_id + '">' + cat.c_name + '</div>');
        }
        elm_category.removeClass('fat-loading');
        $('.ui.button.loading', elm_category).remove();

        if(container.hasClass('hide-model-category') &&  $('.category-field .ui.dropdown.category', container).length > 0){
            var default_cat_id = container.attr('data-cat');
            if(typeof default_cat_id=='undefined' || default_cat_id=='' || default_cat_id=='0'){
                default_cat_id = $('.category-field .ui.dropdown.category .menu .item:nth-child(2)', container).attr('data-value');
            }
            setTimeout(function(){
                $('.category-field .ui.dropdown.category', container).suidropdown('set selected', default_cat_id);
            },500)
        }
    };

    RevyBookingFlow.bindModelToDropdown = function (device_id, brand_id, container) {
        var elm_model = $('.ui.dropdown.models', container),
            elm_model_menu = $(' > .menu', elm_model),
            models = [];
        models = _.filter(revy_flow_data.models, function (item) {
            return item.rm_brand_id == brand_id && item.rm_device_id == device_id && (RevyBookingFlow.cat_id ==  0 || item.rm_cat_id == RevyBookingFlow.cat_id);
        });

        elm_model.addClass('fat-loading');
        elm_model.append('<div class="ui button loading"></div>');
        elm_model_menu.val('');
        $('.item', elm_model_menu).remove();
        elm_model.suidropdown('clear');
        elm_model_menu.append('<div class="item" data-value=""></div>');
        for (let model of models) {
            elm_model_menu.append('<div class="item" data-value="' + model.rm_id + '">' + model.rm_name + '</div>');
        }
        elm_model.removeClass('fat-loading');
        $('.ui.button.loading', elm_model).remove();
    };

    RevyBookingFlow.bindCategoryToStep = function (device_id, brand_id, container) {
        var category_step = $('.fat-sb-list-category', container),
            category_list = $('.fat-sb-item-inner-wrap', category_step),
            categories = [],
            duration = RevyBookingFlow.disable_animation == 0 ? 0 : 400;

        categories = _.filter(revy_flow_data.categories, function (item) {
            return item.c_brand_id == brand_id && item.c_device_id == device_id;
        });
        var template = wp.template('fat-category-item-template'),
            items = $(template(categories));

        category_list.empty();
        category_list.append(items);

        $('.fat-sb-list-brand', container).fadeOut(duration, function () {
            if(container.hasClass('hide-model-category') ){
                var default_cat_id = container.attr('data-cat');
                if(typeof default_cat_id=='undefined' || default_cat_id=='' || default_cat_id=='0'){
                    $('.fat-sb-list-category .fat-sb-item:first-child', container).attr('data-cat-id');
                }
                RevyBookingFlow.chooseCategoryByDefault(default_cat_id, container);

            }else{
                category_step.removeClass('fat-hidden-step').fadeIn(duration);
                RevyMain_FE.registerOnClick(category_step);
            }
        })
    };

    RevyBookingFlow.bindModelToStep = function (device_id, brand_id, container) {
        var model_step = $('.fat-sb-list-model', container),
            model_list = $('.fat-sb-item-inner-wrap', model_step),
            models = [],
            duration = RevyBookingFlow.disable_animation == 0 ? 0 : 400;

        models = _.filter(revy_flow_data.models, function (item) {
            return item.rm_brand_id == brand_id && item.rm_device_id == device_id && (RevyBookingFlow.cat_id == 0 || item.rm_cat_id == RevyBookingFlow.cat_id);
        });
        var template = wp.template('fat-model-item-template'),
            items = $(template(models));

        model_list.empty();
        model_list.append(items);

        $('.fat-sb-list-category', container).fadeOut(duration, function () {
            model_step.removeClass('fat-hidden-step').fadeIn(duration);
            RevyMain_FE.registerOnClick(model_step);
        })
    };

    RevyBookingFlow.bindGroupToDropdown = function (model_id, container) {
        var elm_group = $('.ui.dropdown.groups', container),
            elm_group_menu = $(' > .menu', elm_group),
            groups = [];

        groups = _.filter(revy_flow_data.groups, function (item) {
            return item.rm_model_id == model_id;
        });

        elm_group.addClass('fat-loading');
        elm_group.append('<div class="ui button loading"></div>');
        elm_group_menu.val('');
        $('.item', elm_group_menu).remove();
        elm_group.suidropdown('clear');
        elm_group_menu.append('<div class="item" data-value=""></div>');
        for (let gr of groups) {
            for (var $i = 0; $i < gr.rm_groups.length; $i++) {
                elm_group_menu.append('<div class="item" data-value="' + gr.rm_groups[$i] + '">' + gr.rm_groups[$i] + '</div>');
            }
        }
        elm_group.removeClass('fat-loading');
        $('.ui.button.loading', elm_group).remove();
    };

    RevyBookingFlow.bindServices = function (model_id, container) {
        var elm_list_services = $('.fat-sb-list-services', container),
            template = wp.template('fat-flow-service-item-template'),
            services = _.filter(revy_flow_data.services, {s_model_id: model_id}),
            iterm_inner = $('.fat-sb-list-services .fat-sb-item-inner-wrap', container),
            items = '';

        if (RevyBookingFlow.service_type != '') {
            var se_type = '';
            services = _.filter(services, function (se) {
                if (typeof se.s_types == 'undefined' || se.s_types == '' || se.s_types == null) {
                    return false;
                }
                se_type = se.s_types.split(',');
                for (let type of se_type) {
                    if ($.trim(type) == RevyBookingFlow.service_type) {
                        return true;
                    }
                }
                return false;
            });
        }

        iterm_inner.empty();
        if (services.length > 0) {

            //for auto translate
            if ($('.fat-sb-service-auto-translate').length > 0) {
                for (let se of services) {
                    se.s_name = $('#service_name_' + se.s_id).html();
                    se.s_description = $('#service_desc_' + se.s_id).html();
                    for (let att of se.attrs) {
                        att.s_attr_title = $('#ser_' + se.s_id + '_attr_code_' + att.s_attr_code + '_title').html();
                        att.s_attr_value = $('#ser_' + se.s_id + '_attr_code_' + att.s_attr_code + '_value').html();
                    }
                }
            }


            for (let se of services) {
                if (typeof se.s_min_price != 'undefined') {
                    se.s_min_price_format = RevyMain_FE.formatPrice(se.s_min_price);
                }
                se.s_min_price_class = 'pr-' + se.s_min_price.split('.')[0];
                if (typeof se['attrs'] != 'undefined') {
                    for (let at of se['attrs']) {
                        if (typeof at['s_price'] != 'undefined') {
                            at['s_price_format'] = RevyMain_FE.formatPrice(at['s_price']);
                        }
                    }
                }
            }
            items = $(template(services));
            iterm_inner.append(items);
            RevyMain_FE.registerOnClick(elm_list_services);
            RevyMain_FE.registerOnChange(elm_list_services);
            RevyBookingFlow.displayServiceDetailPopup(elm_list_services);

        } else {
            iterm_inner.append('<div class="rb-not-found">' + revy_data.empty_services + '</div>');
        }

    };

    RevyBookingFlow.bindGarage = function (container) {
        var elm_list_garage = $('.fat-sb-list-garages', container),
            template = wp.template('fat-flow-garage-item-template'),
            iterm_inner = $('.fat-sb-item-inner-wrap', elm_list_garage),
            items = '',
            garages = [];

        iterm_inner.empty();
        $('.fat-sb-list-garages .fat-sb-item-not-found', container).remove();
        if (RevyBookingFlow.delivery_method == 3) { //Mail In
            // get garage
            var service_garage = [];
            for (let sv of RevyBookingFlow.services_selected) {
                service_garage = _.union(service_garage, sv.s_garage_ids.split(','));
            }
            for (let gr of revy_flow_data.garages) {
                if (_.indexOf(service_garage, gr.rg_id) > -1) {
                    garages.push(gr);
                }
            }
        } else {
            garages = RevyBookingFlow.garage_near_me;
        }

        for (let gr of garages) {
            if ($('.fat-sb-garage-auto-translate .fat-sb-item[data-garage-id="' + gr.rg_id + '"]').length > 0) {
                var garage_item = $('.fat-sb-garage-auto-translate .fat-sb-item[data-garage-id="' + gr.rg_id + '"]');
                gr.rg_description = $('.item-desc', garage_item).html();
                gr.rg_address = $('.item-address', garage_item).html();
                gr.rg_name = $('.item-title', garage_item).html();
            }
        }

        if (garages.length > 0) {
            items = $(template(garages));
            iterm_inner.append(items);
            RevyMain_FE.registerOnClick(elm_list_garage);
            RevyBookingFlow.displayGarageDetailPopup(elm_list_garage);
        } else {
            $('.fat-sb-list-garages .fat-sb-item-inner-wrap', container).append('<div class="fat-sb-item-not-found">' + revy_data.garage_not_found + '</div>');
        }
    };

    RevyBookingFlow.goBackBrand = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.fat-sb-list-services', container).fadeOut(function () {
            $('.fat-sb-list-devices', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
            });
        });
    };

    RevyBookingFlow.goBackDevice = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.brand-model-step', container).fadeOut(function () {
            $('.device-step', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
            });
        })
    };

    RevyBookingFlow.goBackDeviceStep = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.fat-sb-list-brand', container).fadeOut(function () {
            $('.fat-sb-list-devices', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        })
    };

    RevyBookingFlow.goBackBrandStep = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            current_tab = container.hasClass('hide-model-category') ? $('.fat-sb-list-model', container) : $('.fat-sb-list-category', container);
        current_tab.fadeOut(function () {
            $('.fat-sb-list-brand', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        })
    };

    RevyBookingFlow.goBackCategoryStep = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.fat-sb-list-model', container).fadeOut(function () {
            $('.fat-sb-list-category', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        })
    };

    RevyBookingFlow.goBackModelStep = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.fat-sb-list-services', container).fadeOut(function () {
            $('.fat-sb-list-model', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        })
    }

    RevyBookingFlow.goBackServices = function (elm) {
        var container = elm.closest('.fat-booking-container');
        $('.fat-sb-list-delivery-method,.fat-sb-order-wrap,.fat-sb-list-garages', container).fadeOut(function () {
            $('.fat-sb-list-services', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        });
    };

    RevyBookingFlow.goBackDeliveryMethod = function (elm) {
        var container = elm.closest('.fat-booking-container');
        $('.fat-sb-list-garages', container).fadeOut(function () {
            $('.fat-sb-list-delivery-method', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
            });
        });
    };

    RevyBookingFlow.gotoDeliveryMethod = function (elm) {
        var container = elm.closest('.fat-booking-container'),
            elm_title = $('.fat-sb-list-delivery-method .fat-sb-title', container),
            elm_subtitle = $('.fat-sb-list-delivery-method .fat-sb-subtitle', container),
            is_hide_map = container.hasClass('hide-map');

        RevyBookingFlow.garage_near_me = is_hide_map ? RevyBookingFlow.getGarages(revy_flow_data.garages) : RevyBookingFlow.getGarageNearMe(revy_flow_data.garages);

        if (RevyBookingFlow.garage_near_me.length > 0 || is_hide_map) {
            elm_title.html($('#delivery_title').html());
            elm_subtitle.html($('#delivery_subtitle').html());
            $('.fat-sb-list-garages .fat-sb-go-back a span, .fat-sb-order-wrap a.fat-go-back-location span', container).html($('#change_delivery_method_title').html());
            $('.postal-code-wrap', container).hide();
            $('.list-delivery-method .fat-sb-item', container).removeClass('disabled');
        } else {
            elm_title.html(elm_title.attr('data-location-title'));
            elm_subtitle.html(elm_title.attr('data-location-subtitle'));
            $('.postal-code-wrap', container).show();
            $('.fat-sb-list-garages .fat-sb-go-back a span, .fat-sb-order-wrap a.fat-go-back-location span', container).html(revy_data.change_location_label);
            $('.list-delivery-method .fat-sb-item.fixit-home,.list-delivery-method .fat-sb-item.carry-in', container).addClass('disabled');
        }
        $('.fat-sb-list-services', container).fadeOut(function () {
            if (container.hasClass('hide-delivery-method')) {
                $('.fat-sb-list-delivery-method .fat-sb-item-inner-wrap .fat-sb-item:first-child .fat-it-inner').trigger('click');
            } else {
                RevyBookingFlow.goToTop(container);
                $('.fat-sb-list-delivery-method', container).fadeIn();
            }
            $('body').trigger('revy_next_step');

        });
    };

    RevyBookingFlow.goBackGarage = function (elm) {
        var container = elm.closest('.fat-booking-container');
        $('.fat-sb-order-wrap', container).fadeOut(function () {
            $('.fat-sb-list-garages', container).fadeIn();
            $('body').trigger('revy_prev_step');
        });
    };

    RevyBookingFlow.goBackLocationFixItHome = function (elm) {
        var container = $(elm).closest('.fat-booking-container');
        $('.fat-sb-order-wrap', container).fadeOut(function () {
            $('.fat-sb-list-delivery-method', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
                $('body').trigger('revy_prev_step');
            });
        });
    };

    RevyBookingFlow.resetServiceSelected = function (container) {
        if (revy_data.enable_multiple_device != '1') {
            RevyBookingFlow.services_selected = [];
            $('.fat-sb-list-services .fat-sb-repair-list ul', container).empty();
        }
        if (RevyBookingFlow.services_selected.length == 0) {
            $('.fat-sb-repair-list button.fat-bt-next', container).addClass('disabled');
        }
    }

    RevyBookingFlow.getLocationFromPostalCode = function (self) {
        var container = self.closest('.fat-booking-container'),
            post_code = $('input#postal_code', container).val();
        if (post_code != '') {
            var tab = self.closest('.fat-sb-tab-content'),
                api_url = 'https://api.mapbox.com/geocoding/v5/mapbox.places/' + post_code + '.json?&types=postcode&limit=1&access_token=' + RevyMain_FE.data.map_api_key;

            $('#c_postal_code', container).val(post_code);
            $('.fat-sb-postal-code-message', container).fadeOut();
            RevyMain_FE.addLoading(container, self);
            $.ajax({
                url: api_url,
                type: 'GET',
                success: function (response) {
                    RevyMain_FE.removeLoading(container, self);
                    if (typeof response.features != 'undefined' && typeof response.features[0] != 'undefined') {
                        RevyMain_FE.client_longitude = response.features[0].center[0];
                        RevyMain_FE.client_latitude = response.features[0].center[1];
                        RevyBookingFlow.garage_near_me = RevyBookingFlow.getGarageNearMe(revy_flow_data.garages);
                        if (RevyBookingFlow.garage_near_me.length == 0) {
                            $('.fat-sb-postal-code-message', container).html('No garage found near your area. Send your device to our mail-in repair facility');
                            $('.fat-sb-postal-code-message', container).fadeIn();
                            $('.list-delivery-method .fixit-home,.list-delivery-method .carry-in', container).addClass('disabled');
                        } else {
                            $('.list-delivery-method .fixit-home,.list-delivery-method .carry-in', container).removeClass('disabled');
                        }
                    } else {
                        $('.fat-sb-postal-code-message', container).html('Can not get your location via postal code. Send your device to our mail-in repair facility');
                        $('.list-delivery-method .fixit-home,.list-delivery-method .carry-in', container).addClass('disabled');
                        $('.fat-sb-postal-code-message', container).fadeIn();
                    }

                },
                error: function (response) {
                    RevyMain_FE.removeLoading(container, self);
                }
            });

        }
    }

    RevyBookingFlow.getGarageNearMe = function (garages) {
        var garage_near_me = [],
            from = turf.point([RevyMain_FE.client_longitude, RevyMain_FE.client_latitude]),
            to = '',
            options = {units: RevyMain_FE.data.distance_unit},
            distance = 0,
            service_garage = [];

        for (let sv of RevyBookingFlow.services_selected) {
            service_garage = _.union(service_garage, sv.s_garage_ids.split(','));
        }
        //console.log('distance_near_me :' + RevyMain_FE.data.distance_near_me);
        for (let gr of garages) {
            if (_.indexOf(service_garage, gr.rg_id) > -1) {
                if (gr.rg_longitude != null && gr.rg_latitude != null && gr.rg_longitude != '' && gr.rg_latitude != '' && !isNaN(gr.rg_longitude) && !isNaN(gr.rg_latitude)) {
                    to = turf.point([gr.rg_longitude, gr.rg_latitude]);
                    distance = turf.distance(from, to, options);
                    //console.log('distance :' + distance);
                    if (distance <= RevyMain_FE.data.distance_near_me) {
                        garage_near_me.push(gr);
                    }
                }
            }
        }
        return garage_near_me;
    }

    RevyBookingFlow.getGarages = function (garages) {
        var garage_near_me = [],
            service_garage = [];

        for (let sv of RevyBookingFlow.services_selected) {
            service_garage = _.union(service_garage, sv.s_garage_ids.split(','));
        }
        for (let gr of garages) {
            if (_.indexOf(service_garage, gr.rg_id) > -1) {
                garage_near_me.push(gr);
            }
        }
        return garage_near_me;
    }

    RevyBookingFlow.fixItHomeOnClick = function (elm) {
        var container = elm.closest('.fat-booking-container');
        $('.fat-sb-order-wrap', container).removeClass('no-appointment-section no-garage-section');
        RevyBookingFlow.delivery_method = 1; // FixIt at  Home
        $('.fat-sb-list-delivery-method', container).fadeOut(function () {
            $('.button-group button.ui.button:not(.next-delivery)', container).addClass('disabled');
            $('.fat-sb-order-wrap', container).addClass('no-garage-section');

            if ($('.fat-sb-order-wrap .appointment-wrap').attr('data-hide-time') == '1') {
                $('.button-group button.ui.button.fat-bt-payment', container).removeClass('disabled');
            }

            RevyBookingFlow.delivery_fee = typeof elm.attr('data-fee') && elm.attr('data-fee') != '' ? parseFloat(elm.attr('data-fee')) : 0;
            RevyBookingFlow.bindRepairSummary(container);
            RevyBookingFlow.showCustomerFormBaseOnDelivery(container);
            RevyBookingFlow.goToTop(container);
            RevyBookingFlow.initCalendar();
            $('.fat-sb-order-wrap', container).fadeIn();
            RevyBookingFlow.activePaymentDefault();
            $('body').trigger('revy_next_step');
        });
    };

    RevyBookingFlow.activePaymentDefault = function () {
        var default_payment = $('.fat-list-gateway .gateway-item:first-child');
        if (default_payment.attr('data-value') != 'paypal') {
            default_payment.trigger('click');
        }
    };

    RevyBookingFlow.carryInOnClick = function (elm) {
        var container = elm.closest('.fat-booking-container');
        RevyBookingFlow.delivery_method = 2; // Carry In
        $('.fat-sb-list-delivery-method', container).fadeOut(function () {
            $('.fat-sb-order-wrap', container).removeClass('no-appointment-section  no-garage-section');
            $('.button-group button.ui.button:not(.next-delivery)', container).addClass('disabled');

            if ($('.fat-sb-order-wrap .appointment-wrap').attr('data-hide-time') == '1') {
                $('.button-group button.ui.button.fat-bt-payment', container).removeClass('disabled');
            }
            RevyBookingFlow.delivery_fee = typeof elm.attr('data-fee') && elm.attr('data-fee') != '' ? parseFloat(elm.attr('data-fee')) : 0;
            RevyBookingFlow.bindGarage(container);
            RevyBookingFlow.showCustomerFormBaseOnDelivery(container);
            RevyBookingFlow.goToTop(container);
            RevyBookingFlow.initCalendar();
            if (container.hasClass('hide-garage')) {
                RevyBookingFlow.bindRepairSummary(container);
                if ($('.fat-sb-list-garages .fat-sb-item-inner-wrap .fat-sb-item:first-child').length > 0) {
                    $('.fat-sb-list-garages .fat-sb-item-inner-wrap .fat-sb-item:first-child').trigger('click');
                }
                //$('.fat-sb-order-wrap', container).fadeIn();
                RevyBookingFlow.activePaymentDefault();
                $('.fat-sb-order-wrap a.fat-go-back-garage', container).hide();
                $('.fat-sb-order-wrap a.fat-go-back-service', container).removeClass('fat-sb-hidden');
            } else {
                $('.fat-sb-list-garages', container).fadeIn();
                RevyBookingFlow.activePaymentDefault();
                $('body').trigger('revy_next_step');
            }

        });
    };

    RevyBookingFlow.mailInOnClick = function (elm) {
        var container = elm.closest('.fat-booking-container');
        RevyBookingFlow.delivery_method = 3; // Mail In Delivery
        $('.fat-sb-order-wrap', container).removeClass('no-appointment-section  no-garage-section');
        $('.fat-sb-list-delivery-method', container).fadeOut(function () {
            $('.button-group button.ui.button:not(.next-delivery)', container).addClass('disabled');
            $('.button-group button.ui.button.fat-bt-payment', container).removeClass('disabled');
            $('.fat-sb-order-wrap', container).addClass('no-appointment-section ');

            RevyBookingFlow.delivery_fee = typeof elm.attr('data-fee') && elm.attr('data-fee') != '' ? parseFloat(elm.attr('data-fee')) : 0;

            RevyBookingFlow.bindGarage(container);
            RevyBookingFlow.showCustomerFormBaseOnDelivery(container);
            RevyBookingFlow.goToTop(container);
            RevyBookingFlow.initCalendar();
            if (container.hasClass('hide-garage')) {
                RevyBookingFlow.bindRepairSummary(container);
                if ($('.fat-sb-list-garages .fat-sb-item-inner-wrap .fat-sb-item:first-child').length > 0) {
                    $('.fat-sb-list-garages .fat-sb-item-inner-wrap .fat-sb-item:first-child').trigger('click');
                }
                //$('.fat-sb-order-wrap', container).fadeIn();
                RevyBookingFlow.activePaymentDefault();
                $('.fat-sb-order-wrap a.fat-go-back-garage', container).hide();
                $('.fat-sb-order-wrap a.fat-go-back-service', container).removeClass('fat-sb-hidden');
            } else {
                $('.fat-sb-list-garages', container).fadeIn();
                RevyBookingFlow.activePaymentDefault();
            }
            $('body').trigger('revy_next_step');
        });
    };

    RevyBookingFlow.dateOnClick = function (elm) {
        var container = $(elm).closest('.appointment-wrap'),
            date = elm.attr('data-date');
        if (elm.closest('.week-date').hasClass('disabled')) {
            return;
        }
        if (!elm.hasClass('selected')) {
            $('.week-date span.selected', container).removeClass('selected');
            elm.addClass('selected');
            RevyBookingFlow.b_date = date;
            if (RevyBookingFlow.delivery_method == 2) { //Carry In
                RevyBookingFlow.initTimeSlotCarryIn(date, container);
            } else {
                RevyBookingFlow.initTimeSlotBaseOnWorkingHour(date, container);
            }
        }
    };

    RevyBookingFlow.initTimeSlotBaseOnWorkingHour = function (date, container) {
        var dd_time_options = $('.ui.dropdown.time-options', container),
            day_of_week = 0;

        date = moment(date, 'YYYY-MM-DD');
        day_of_week = date.days();
        day_of_week = day_of_week == 0 ? 8 : (day_of_week + 1);
        day_of_week = day_of_week.toString();

        dd_time_options.addClass('loading');
        dd_time_options.suidropdown('clear');
        $('.item', dd_time_options).remove();

        var working_hours = _.filter(revy_flow_data.working_hour, function (item) {
            return item.es_day == day_of_week && item.es_enable == '1';
        });

        var es_start = 0,
            es_end = 0,
            time_step = parseInt(revy_data.time_step),
            slots = revy_data.slots,
            time_items = '';

        for (let wh of working_hours[0].work_hours) {
            es_start = parseInt(wh.es_work_hour_start);
            es_end = parseInt(wh.es_work_hour_end);
            time_items = '';
            for (var $i = es_start; $i <= es_end; $i += time_step) {
                time_items += '<div class="item" data-value="' + $i + '">' + slots[$i] + '</div>';
            }
            $('.menu', dd_time_options).append(time_items);
        }
        dd_time_options.removeClass('loading');
    };

    RevyBookingFlow.showCustomerFormBaseOnDelivery = function (container) {
        if (RevyBookingFlow.delivery_method == 1) { // Fix It at Home
            $('a.fat-go-back-garage', container).addClass('fat-sb-hidden');
            $('a.fat-go-back-location', container).removeClass('fat-sb-hidden');

        } else {
            $('a.fat-go-back-garage', container).removeClass('fat-sb-hidden');
            $('a.fat-go-back-location', container).addClass('fat-sb-hidden');
        }

        if (RevyBookingFlow.delivery_method == 2) { // Carry In
            $('.customer-info-wrap .address-postal, .customer-info-wrap .city-country', container).hide();
        } else {
            $('.customer-info-wrap .address-postal, .customer-info-wrap .city-country', container).show();
        }
    };

    RevyBookingFlow.goToTop = function (container) {
        if (typeof RevyMain_FE.data.disable_scroll != 'undefined' && RevyMain_FE.data.disable_scroll == '1') {
            return;
        }
        var top = container.offset().top - 50;
        $("html, body").animate({scrollTop: top}, 500);
    };

    RevyBookingFlow.goToRepairList = function (container) {
        var top = $('.fat-sb-repair-list', container).offset().top - 100;
        $("html, body").animate({scrollTop: top}, "slow");
    };

    RevyBookingFlow.resetValidateField = function (self) {
        if (self.val() != '') {
            self.closest('.field').removeClass('field-error');
        }
    };

    RevyBookingFlow.confirmOrderClick = function (elm) {
        var container = $(elm).closest('.fat-booking-container'),
            form = $('.ui.form', container),
            payment_method = $('.fat-list-gateway .gateway-item.selected', container).attr('data-value'),
            custom_fields = [],
            hide_date_time = $('.fat-sb-order-wrap .appointment-wrap').attr('data-hide-time') == '1';

        $('.custom-fields .field', form).each(function () {
            if ($(this).hasClass('text') || $(this).hasClass('number')) {
                custom_fields.push({
                    id: $(this).attr('data-id'),
                    label: $(this).attr('data-label'),
                    value: $('input', this).val()
                });
            }
            if ($(this).hasClass('textarea')) {
                custom_fields.push({
                    id: $(this).attr('data-id'),
                    label: $(this).attr('data-label'),
                    value: $('textarea', this).val()
                });
            }
        });

        $('.fat-sb-error-message').html('');
        if ($('#term_condition').length > 0 && !$('#term_condition').is(':checked')) {
            $('.fat-sb-error-message').html(RevyMain_FE.data.term_condition_message);
            return;
        }

        RevyMain_FE.addLoading(container, elm);

        $('.repair-summary  .fat-sb-error-message', container).html('').addClass('fat-sb-hidden');

        $('#c_postal_code, #c_address, #c_city, #c_country', form).removeAttr('required');

        if (RevyBookingFlow.delivery_method == 2) { //Carry In
            $('#c_postal_code, #c_address, #c_city, #c_country', form).removeAttr('required');
        }

        if (RevyMain_FE.validateForm(form)) {
            var data = {
                c_first_name: $('#c_first_name', form).val(),
                c_last_name: $('#c_last_name', form).val(),
                c_email: $('#c_email', form).val(),
                c_phone_code: $('#phone_code', form).val(),
                c_phone: $('#c_phone', form).val(),
                b_customer_postal_code: $('#c_postal_code', form).val(),
                b_customer_address: $('#c_address', form).val(),
                b_customer_city: $('#c_city', form).val(),
                b_customer_country: $('#c_country', form).val(),
                b_garage_id: RevyBookingFlow.garage_id,
                b_device_id: RevyBookingFlow.device_id,
                b_brand_id: RevyBookingFlow.brand_id,
                b_model_id: RevyBookingFlow.model_id,
                b_group_name: RevyBookingFlow.group_name,
                b_date: RevyBookingFlow.b_date,
                b_time: RevyBookingFlow.b_time,
                b_serial_number: $('#b_serial_number', form).val(),
                b_notes: $('#b_notes', form).val(),
                b_delivery_method: RevyBookingFlow.delivery_method,
                b_gateway_type: payment_method,
                b_custom_field: custom_fields,
                b_coupon_code: $('.fat-sb-order-wrap #coupon').length > 0 ? $('#coupon').val() : ''
            };

            try {
                $.ajax({
                    url: revy_data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'save_booking_fe',
                        s_field: revy_data.ajax_s_field,
                        services: RevyBookingFlow.services_selected,
                        data: data
                    }),
                    success: function (response) {
                        response = $.parseJSON(response);
                        if (response.result > 0) {

                            if(typeof response.pdf!='undefined' && response.pdf!=''){
                                $('.fat-sb-pdf-download a').attr('href', response.pdf);
                            }

                            if (payment_method == 'stripe' && RevyBookingFlow.b_total_pay > 0) {
                                RevyBookingFlow.stripePaymentIntents(response.result, self, container);
                                return;
                            }

                            if (typeof response.redirect_url != 'undefined' && response.redirect_url != '') {
                                window.location.href = response.redirect_url;
                                return;
                            }

                            if (payment_method == 'onsite' || payment_method == 'paypal' || RevyBookingFlow.b_total_pay == 0) {
                                //display success message
                                $('.fat-sb-order-wrap', container).fadeOut(function () {
                                    $('.fat-bt-add-icalendar', container).attr('data-id', response.result);
                                    $('.fat-bt-add-google-calendar', container).attr('data-id', response.result);
                                    RevyBookingFlow.goToTop(container);
                                    $('.fat-sb-appointment-booked-wrap', container).fadeIn();
                                });

                                RevyMain_FE.removeLoading(container, elm);

                                $.ajax({
                                    url: revy_data.ajax_url,
                                    type: 'POST',
                                    data: ({
                                        action: 'send_booking_fe_mail',
                                        s_field: revy_data.ajax_s_field,
                                        b_id: response.result,
                                    })
                                });

                                $.ajax({
                                    url: revy_data.ajax_url,
                                    type: 'POST',
                                    data: ({
                                        action: 'send_booking_fe_sms',
                                        s_field: revy_data.ajax_s_field,
                                        b_id: response.result,
                                    })
                                });

                            }

                        } else {
                            RevyMain_FE.removeLoading(container, elm);
                            $('.repair-summary  .fat-sb-error-message', container).html(response.message).removeClass('fat-sb-hidden');
                        }
                    },
                    error: function (response) {
                        RevyMain_FE.removeLoading(container, elm);
                    }
                });
            } catch (err) {
            }

        } else {
            RevyMain_FE.removeLoading(container, elm);
            var top = $('.customer-info-wrap', container).offset().top - 100;
            $("html, body").animate({scrollTop: top}, "slow");
        }
    };

    RevyBookingFlow.gatewayOnClick = function (elm) {
        var container = elm.closest('.fat-booking-container'),
            gateway = $(elm).attr('data-value')
        if (!elm.hasClass('selected')) {
            $('.gateway-item.selected', container).removeClass('selected');
            $(elm).addClass('selected');
            if (gateway == 'stripe') {
                $('.fat-sb-order-stripe', container).removeClass('fat-sb-hidden');
                $('.fat-sb-order-stripe', container).fadeIn();
            } else {
                $('.fat-sb-order-stripe', container).addClass('fat-sb-hidden');
            }
        }

    }

    RevyBookingFlow.stripePaymentIntents = function ($booking_id, self, container) {
        var card = RevyBookingFlow.card;
        $.ajax({
            url: revy_data.ajax_url,
            type: 'POST',
            data: ({
                action: 'payment_intents',
                b_id: $booking_id
            }),
            success: function (paymentIntent) {
                paymentIntent = $.parseJSON(paymentIntent);
                if (typeof paymentIntent.error == 'undefined') {
                    (async () => {
                        const response = await RevyBookingFlow.stripe.confirmCardPayment(
                            paymentIntent.client_secret,
                            {
                                payment_method: {
                                    card
                                }
                            }
                        );
                        if (typeof response['paymentIntent'] != "undefined") {
                            RevyBookingFlow.stripeHandlePayment($booking_id, response, container, self);
                        } else {
                            var container = $('.fat-booking-container'),
                                self = $('button.fat-bt-payment', container);
                            RevyMain_FE.removeLoading(container, self);
                            if (typeof response.error != 'undefined' && typeof response.error.message != 'undefined') {
                                $('.repair-summary .fat-sb-error-message', container).html(response.error.message).removeClass('fat-sb-hidden');
                            }
                        }
                    })();

                } else {
                    RevyMain_FE.removeLoading(container, self);
                    $('.fat-sb-tab-content.appointment .fat-sb-error-message', container).html(paymentIntent.error).removeClass('fat-sb-hidden');
                }
            },
            error: function () {
                RevyMain_FE.removeLoading(container, self);
            }
        });
    };

    RevyBookingFlow.stripeHandlePayment = function ($booking_id, paymentResponse, container, self) {
        $.ajax({
            url: revy_data.ajax_url,
            type: 'POST',
            data: ({
                action: 'payment_confirm',
                b_id: $booking_id,
                paymentResponse: paymentResponse['paymentIntent']
            }),
            success: function (response) {
                response = $.parseJSON(response);
                RevyMain_FE.removeLoading(container, self);
                if (response.result > 0) {
                    $.ajax({
                        url: revy_data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'send_booking_fe_mail',
                            s_field: revy_data.ajax_s_field,
                            b_id: response.result,
                            paymentResponse: paymentResponse
                        })
                    });

                    $.ajax({
                        url: revy_data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'send_booking_fe_sms',
                            s_field: revy_data.ajax_s_field,
                            b_id: response.result,
                        })
                    });

                    //display success message
                    $('.fat-sb-order-wrap', container).fadeOut(function () {
                        $('.fat-bt-add-icalendar', container).attr('data-id', response.result);
                        $('.fat-bt-add-google-calendar', container).attr('data-id', response.result);
                        RevyBookingFlow.goToTop(container);
                        $('.fat-sb-appointment-booked-wrap', container).removeClass('fat-hidden-step').fadeIn();
                    });

                } else {
                    $('.repair-summary .fat-sb-error-message', container).html(response.message).removeClass('fat-sb-hidden');
                }
            },
            error: function () {
                RevyMain_FE.removeLoading(container, self);
            }
        });
    };

    RevyBookingFlow.bindRepairSummary = function (container) {
        $('.repair-summary  .time-meta .mt-value', container).html('');
        $('.repair-summary  .garage-title', container).html(RevyBookingFlow.garage_title);
        $('.repair-summary  .garage-address', container).html(RevyBookingFlow.garage_address);
        $('.repair-summary  .garage-desc', container).html(RevyBookingFlow.garage_desc);

          if(revy_data.enable_multiple_device!='1'){
              if(RevyBookingFlow.group_name!=''){
                  $('.repair-summary  .device-meta .mt-value', container).html(RevyBookingFlow.brand_name + '-' + RevyBookingFlow.model_name + '-' + RevyBookingFlow.group_name);
              }else{
                  $('.repair-summary  .device-meta .mt-value', container).html(RevyBookingFlow.brand_name + '-' + RevyBookingFlow.model_name);
              }
          }else{
              var device = '';
              for(let model of RevyBookingFlow.multiple_model_name){
                  device += (device=='') ? model : (', ' + model);
              }
              $('.repair-summary  .device-meta .mt-value', container).html(device);
          }

        //add repair list to device meta
        var repair_list = $('.fat-sb-repair-list-inner ul').clone();
        $('.service-price .fat-sb-remove-service', repair_list).remove();
        //$('.repair-summary  .device-meta .mt-value', container).html(repair_list);


        $('.repair-summary  .time-meta .mt-value', container).html('');

        var service = '',
            sub_total = 0,
            total = 0,
            tax = 0,
            discount = $('.discount-meta .mt-value', container).attr('data-value');

        if (typeof discount != 'undefined' && discount != '' && !isNaN(discount)) {
            discount = parseFloat(discount);
        } else {
            discount = 0;
        }

        for (let sv of RevyBookingFlow.services_selected) {
            service += service == '' ? sv.s_name : (', ' + sv.s_name);
            service += '<span class="service-attribute"> (' + sv.s_attr_title + ' ' + sv.s_attr_value + ')</span>';
            tax += parseFloat(sv.s_price) * parseFloat(sv.s_tax) / 100;
            sub_total += parseFloat(sv.s_price);
            total += parseFloat(sv.s_price); // + tax
        }
        if (RevyBookingFlow.delivery_fee > 0) {
            total += RevyBookingFlow.delivery_fee;
            sub_total += RevyBookingFlow.delivery_fee;

            $('.delivery-fee-meta .mt-value', container).show().html(RevyMain_FE.formatPrice(RevyBookingFlow.delivery_fee));
        } else {
            $('.delivery-fee-meta .mt-value', container).hide();
        }
        total = total - discount + tax;
        RevyBookingFlow.b_total_pay = total;

        $('.service-meta .mt-value', container).html(service);
        if (tax > 0) {
            $('.tax-meta .mt-value', container).html(RevyMain_FE.formatPrice(tax));
            $('.tax-meta').show();
        } else {
            $('.tax-meta').hide();
        }

        $('.subtotal-meta .mt-value', container).attr('data-value', sub_total);
        $('.subtotal-meta .mt-value', container).html(RevyMain_FE.formatPrice(sub_total));

        $('.cost-meta .mt-value', container).attr('data-value', sub_total);
        $('.cost-meta .mt-value', container).html(RevyMain_FE.formatPrice(total));

    };

    RevyBookingFlow.timeOnChange = function (value, text, $choice, self) {
        RevyBookingFlow.b_time = value;
        text = typeof text != 'undefined' ? text : '';
        $('.time-meta .mt-value').html(RevyBookingFlow.b_date + ' ' + text);
        $('.time-meta').show();
        $('.button-group button.ui.button').removeClass('disabled');
    }

    //for Carry-In
    RevyBookingFlow.initWeeklyTimeSlot = function (container) {
        if (RevyBookingFlow.garage_id <= 0) {
            return;
        }
        var elm = $('.ui.dropdown.time-options', container);
        RevyMain_FE.addLoading(container, elm);
        try {
            var $s_ids = [],
                start_date = $('.fat-sb-calendar-wrap .week-day-header.sun .week-date span', container).attr('data-date'),
                end_date = $('.fat-sb-calendar-wrap .week-day-header.sat .week-date span', container).attr('data-date');
            for (let sev of RevyBookingFlow.services_selected) {
                $s_ids.push(sev.s_id);
            }
            $.ajax({
                url: revy_data.ajax_url,
                type: 'POST',
                data: ({
                    action: 'get_time_slot_weekly',
                    s_field: revy_data.ajax_s_field,
                    s_ids: $s_ids,
                    garage_id: RevyBookingFlow.garage_id,
                    date_start: start_date,
                    date_end: end_date
                }),
                success: function (response) {
                    RevyMain_FE.removeLoading(container, elm);
                    RevyBookingFlow.weekly_timeslot = $.parseJSON(response);

                    var current_date = moment();
                    current_date = moment(current_date.format('YYYY-MM-DD'));

                    for (let s_id of $s_ids) {
                        $('.week-header .week-day-header .week-date').each(function () {
                            var self = $(this),
                                date = $('span', self).attr('data-date'),
                                days = RevyBookingFlow.weekly_timeslot[s_id].days,
                                mm_date = moment(date);

                            self.addClass('disabled');
                            for (let day of days) {
                                if (day.date == date && day.work_hour.length > 0 && !mm_date.isBefore(current_date)) {
                                    self.removeClass('disabled');
                                }
                            }
                        })
                    }

                },
                error: function (response) {
                    RevyMain_FE.removeLoading(container, elm);
                }
            });
        } catch (err) {
            RevyMain_FE.removeLoading(container, elm);
        }
    };

    RevyBookingFlow.initTimeSlotCarryIn = function (date_str, container) {
        var dd_time_options = $('.ui.dropdown.time-options', container),
            mm_date = moment(date_str, 'YYYY-MM-DD'),
            date = new Date(mm_date.year(), mm_date.month(), mm_date.date()),
            booking_in_day = [],
            booking_service_in_day = [],
            time_slot = [],
            group_slot = [],
            days = [],
            cap = 1,
            min_cap = 1,
            max_cap = 1,
            range = 0,
            time = 0,
            end_time = 0,
            is_conflict = 0,
            time_step = parseInt(revy_data.time_step),
            now = RevyMain_FE.parseDateTime(RevyMain_FE.data.now),
            now_minute = now.getHours() * 60 + now.getMinutes(),
            weekly_timeslot = RevyBookingFlow.weekly_timeslot,
            s_do_together = [],
            is_service_together = 0;

        RevyBookingFlow.garage_id = parseInt(RevyBookingFlow.garage_id);

        $('.fat-sb-time-notice', container).hide();

        for (let service of RevyBookingFlow.services_selected) {
            if (typeof service.s_do_together != 'undefined' && service.s_do_together != null) {
                s_do_together = $.merge(s_do_together, service.s_do_together.split(','));
            }
        }

        for (let service of RevyBookingFlow.services_selected) {
            is_service_together = 0;
            if (s_do_together.indexOf(service.s_id.toString()) !== -1) {
                is_service_together = 1;
            }

            if (typeof weekly_timeslot[service.s_id] == 'undefined') {
                return false;
            }
            booking_in_day = _.where(weekly_timeslot[service.s_id].booking, {b_date: date_str});
            days = _.findWhere(weekly_timeslot[service.s_id].days, {date: date_str});
            booking_service_in_day = _.where(weekly_timeslot[service.s_id].booking, {
                b_date: date_str,
                b_service_id: service.s_id.toString()
            });

            max_cap = parseInt(weekly_timeslot[service.s_id].max_cap);
            cap = max_cap;
            if (typeof days == 'undefined') {
                return false;
            }

            if (days.work_hour.length == 0 && is_service_together == 0) {
                return false;
            }

            for (let wh of days.work_hour) {
                wh.es_work_hour_end = parseInt(wh.es_work_hour_end);
                wh.es_work_hour_start = parseInt(wh.es_work_hour_start);
                range = (wh.es_work_hour_end - wh.es_work_hour_start) / time_step;
                service.s_duration = parseInt(service.s_duration);
                service.s_break_time = parseInt(service.s_break_time);

                for (var $i = 0; $i < range; $i++) {
                    time = wh.es_work_hour_start + $i * time_step;
                    end_time = time + service.s_duration + service.s_break_time;
                    is_conflict = 0;

                    if (end_time > wh.es_work_hour_end && is_service_together == 0) {
                        break;
                    }

                    if (typeof booking_service_in_day != 'undefined' && is_service_together == 0) {
                        for (let bk of booking_service_in_day) {
                            bk.b_time_end = parseInt(bk.b_time_end);
                            bk.b_time = parseInt(bk.b_time);
                            bk.b_garage_id = parseInt(bk.b_garage_id);
                            bk.total_device = parseInt(bk.total_device);
                            if (bk.b_time <= time && end_time <= bk.b_time_end) {
                                if (bk.b_garage_id == RevyBookingFlow.garage_id && (max_cap - bk.total_device) >= min_cap) {
                                    is_conflict = 0;
                                    cap = max_cap - bk.total_device;
                                } else {
                                    is_conflict = 1;
                                }
                                break;
                            }
                        }
                    }

                    if (!is_conflict && typeof booking_in_day != 'undefined' && is_service_together == 0) {
                        for (let bk of booking_in_day) {
                            if (bk.b_time <= time && end_time <= bk.b_time_end && bk.b_garage_id == RevyBookingFlow.garage_id && bk.b_service_id == service.s_id) {
                                break;
                            } else {
                                is_conflict = !(end_time <= bk.b_time || time >= bk.b_time_end);
                            }
                            if (is_conflict) {
                                break;
                            }
                        }
                    }
                    if (RevyMain_FE.equalDay(now, date) && time <= now_minute) {
                        is_conflict = 1;
                    }
                    if (!is_conflict) {
                        group_slot.push(time);
                        time_slot.push({
                            s_id: service.s_id,
                            slot: time,
                            available: cap
                        });
                    }
                }
            }

        }

        var total_service = RevyBookingFlow.services_selected.length;
        group_slot = _.groupBy(group_slot);
        time_slot = _.filter(time_slot, function (item) {
            return typeof group_slot[item.slot] != 'undefined' && group_slot[item.slot].length == total_service;
        });

        dd_time_options.addClass('loading');
        dd_time_options.suidropdown('clear');
        $('.item', dd_time_options).remove();


        if (time_slot.length > 0) {
            var time_items = '';
            for (let ts of time_slot) {
                time_items += '<div class="item" data-value="' + ts.slot + '">' + revy_data.slots[ts.slot] + '</div>';
            }
            $('.menu', dd_time_options).append(time_items);
        } else {
            $('.fat-sb-time-notice', container).fadeIn();
        }

        setTimeout(function () {
            dd_time_options.removeClass('loading');
        }, 300)

    };

    RevyBookingFlow.couponOnChange = function (self) {
        if (self.val() == '') {
            var container = self.closest('.fat-sb-flow-layout');
            $('.fat-coupon-error', container).html('');
        }
    };

    RevyBookingFlow.getCoupon = function (self) {
        var container = self.closest('.fat-sb-flow-layout'),
            coupon = $('#coupon', container).val(),
            s_id = RevyBookingFlow.s_id,
            total = RevyBookingFlow.b_total_pay;
        if (s_id == '' || coupon == '') {
            var discount = 0;
            $('.discount-meta .mt-value', container).attr('data-value', discount);
            $('.discount-meta .mt-value', container).text(RevyMain_FE.data.symbol_prefix + '0' + RevyMain_FE.data.symbol_suffix);
            $('.discount-meta').hide();
            RevyBookingFlow.bindRepairSummary(container);
            return;
        }
        if (self.hasClass('loading')) {
            return;
        }

        self.addClass('loading');
        $.ajax({
            url: revy_data.ajax_url,
            type: 'GET',
            data: ({
                action: 'get_coupon_fe_discount',
                s_field: revy_data.ajax_s_field,
                coupon: coupon,
                s_ids: RevyBookingFlow.s_id
            }),
            success: function (response) {
                response = $.parseJSON(response);
                var discount = 0;
                self.removeClass('loading');

                if (response.result > 0) {
                    $('.coupon-meta .fat-coupon-error', container).html('');
                    if (response.discount_type == '1') {
                        discount = (total * parseFloat(response.amount)) / 100;
                    } else {
                        discount = parseFloat(response.amount);
                    }
                } else {
                    $('.coupon-meta .fat-coupon-error', container).html(response.message);
                }

                $('.discount-meta').show();
                $('.discount-meta .mt-value', container).attr('data-value', discount);
                $('.discount-meta .mt-value', container).text(RevyMain_FE.data.symbol_prefix + discount.format(RevyMain_FE.data.number_of_decimals, 3, ',') + RevyMain_FE.data.symbol_suffix);

                RevyBookingFlow.bindRepairSummary(container);

            },
            error: function () {
                self.removeClass('loading');
            }
        })
    };

    RevyBookingFlow.displayServiceDetailPopup = function (elm_list_services) {

        $('a.bt-mobile-detail', elm_list_services).each(function () {
            $(this).off('click').on('click', function (event) {
                event.preventDefault();
                var service_item = $(this).closest('.fat-sb-item'),
                    desc = $('.fat-sb-col-right', service_item).html(),
                    service_name = $(this).attr('data-service-name'),
                    has_show_detail = $(this).hasClass('visible'),
                    popup = $('<div class="fat-sb-popup-container"><div class="fat-sb-popup-inner">' +
                        '<div class="fat-popup-title">' + service_name + '</div><div class="fat-popup-content">' + desc + '</div>' +
                        '<a href="#" class="fat-sb-close-popup"><i class="close icon"></i></a>' +
                        '</div>' +
                        '</div>');

                $('body fat-sb-popup-container').remove();
                $('body').append(popup);

                $('.fat-sb-popup-container a.fat-sb-close-popup').off('click').on('click', function (event) {
                    event.preventDefault();
                    $('.fat-sb-popup-container').fadeOut(function () {
                        $('.fat-sb-popup-container').remove();
                    })
                })

                /*  $('a.bt-mobile-detail',elm_list_services).popup('hide').popup('destroy');

                  if(!has_show_detail){
                      $(this).popup({
                          inline     : true,
                          position   : 'top center',
                          on    : 'click',
                          closable: true
                      }).popup('show');
                  }*/
                return false;

            })
        })
    }

    RevyBookingFlow.displayGarageDetailPopup = function (elm_list_garages) {

        $('a.bt-mobile-detail', elm_list_garages).each(function () {
            $(this).off('click').on('click', function (event) {
                event.preventDefault();
                var garage_item = $(this).closest('.fat-sb-item'),
                    desc = $('.item-desc', garage_item).html(),
                    garage_name = $('.item-title', garage_item).html(),
                    has_show_detail = $(this).hasClass('visible'),
                    popup = $('<div class="fat-sb-popup-container"><div class="fat-sb-popup-inner">' +
                        '<div class="fat-popup-title">' + garage_name + '</div><div class="fat-popup-content">' + desc + '</div>' +
                        '<a href="#" class="fat-sb-close-popup"><i class="close icon"></i></a>' +
                        '</div>' +
                        '</div>');

                $('body fat-sb-popup-container').remove();
                $('body').append(popup);

                $('.fat-sb-popup-container a.fat-sb-close-popup').off('click').on('click', function (event) {
                    event.preventDefault();
                    $('.fat-sb-popup-container').fadeOut(function () {
                        $('.fat-sb-popup-container').remove();
                    })
                })

                return false;

            })
        })
    }

    RevyBookingFlow.anchorRepairList = function () {
        var window_width = $(window).outerWidth(),
            scrollTop = $(window).scrollTop(),
            repair_elm = $('.fat-sb-repair-list'),
            repair_inner_elm = $('.fat-sb-repair-list-inner'),
            repair_height = repair_elm.outerHeight(),
            repair_inner_height = repair_inner_elm.outerHeight(),
            service_inner_top = $('.fat-sb-service-inner').offset().top,
            service_inner_height = $('.fat-sb-service-inner').outerHeight(),
            diff = 0,
            bottom_limit = 0;

        diff = parseFloat(scrollTop) - parseFloat(service_inner_top);

        if (window_width > 991 && $('.fat-sb-list-services').is(':visible') && diff > 0) {
            bottom_limit = service_inner_top + service_inner_height - scrollTop;
            if (bottom_limit > repair_inner_height) {
                repair_elm.addClass('anchor');
                repair_elm.css('top', diff + 'px');
            }
        } else {
            repair_elm.removeClass('anchor');
        }
    }

    RevyBookingFlow.chooseAnotherDevice = function (self) {
        var container = self.closest('.fat-booking-container');
        $('.fat-sb-list-services', container).fadeOut(function () {
            $('.fat-sb-list-devices .brand-model-step', container).hide();
            $('.fat-sb-list-devices .device-step', container).show();
            $('.fat-sb-list-devices', container).fadeIn(function () {
                RevyBookingFlow.goToTop(container);
            });
        })
    }

    RevyBookingFlow.initAutoTranslate = function () {
        if ($('.fat-sb-service-auto-translate').length > 0) {
            revy_data.loading = $('#revy_data_loading').html();
            revy_data.select_duration_message = $('#revy_data_select_duration_message').html();
            revy_data.select_date_message = $('#revy_data_select_date_message').html();
            revy_data.model_not_found = $('#revy_data_model_not_found').html();
            revy_data.service_not_found = $('#revy_data_service_not_found').html();
            revy_data.garage_not_found = $('#revy_data_garage_not_found').html();
            revy_data.pickup_success_message = $('#revy_data_pickup_success_message').html();
        }
    }

    $(document).ready(function () {
        RevyBookingFlow.init();
    });

    $(window).ready(function () {
        RevyBookingFlow.initAutoTranslate();
    });

})(jQuery)