"use strict";
var RevySMSTemplate = {};
(function ($) {
    RevySMSTemplate.init = function () {
        RevyMain.registerEventProcess($('.fat-sb-sms-template-container'));
        RevyMain.initPopupToolTip();
    };

    RevySMSTemplate.menuOnClick = function(self){
        if(self.hasClass('active')){
            return;
        }
        $('a.active','.fat-sb-sms-template-container .ui.menu').removeClass('active');
        self.addClass('active');
        $('.fat-sb-pending-template').show();

        $('.fat-sb-customer-label').html(self.attr('data-customer-title'));
        RevySMSTemplate.initTemplate(self.attr('data-template'));
    };

    RevySMSTemplate.dependFieldOnChange = function(self){
        var id = self.attr('id'),
            value = self.val();
        $('[data-depend="' + id + '"]', '.fat-sb-sms-template-container').each(function () {
            var elm = $(this);
            if (self.is(':checked')) {
                elm.slideDown();
            } else {
                elm.slideUp();
            }
        });
    };

    RevySMSTemplate.submitTemplate = function(self){
        RevyMain.showProcess(self);
        var template =  $('a.active','.fat-sb-sms-template-container .ui.menu').attr('data-template'),
            customer_template_enable = $('#customer_template_enable').is(':checked') ? 1 : 0,
            customer_message = $('#customer_template').val();

        $.ajax({
            url: revy_data.ajax_url,
            type: 'POST',
            data: ({
                action: 'save_sms_template',
                data: {
                    'template' : template,
                    'customer_enable': customer_template_enable,
                    'customer_message' : customer_message
                }
            }),
            success: function (response) {
                RevyMain.closeProcess(self);
                response = $.parseJSON(response);
                if (response.result > 0) {
                    RevyMain.showMessage(self.attr('data-success-message'));

                    for(var $i=0; $i< revy_sms_data.length; $i++){
                        if(revy_sms_data[$i]['template'] == template){
                            revy_sms_data[$i]['customer_enable'] = customer_template_enable;
                            revy_sms_data[$i]['customer_message'] = customer_message;

                            revy_sms_data[$i]['employee_enable'] = employee_template_enable;
                            revy_sms_data[$i]['employee_message'] = employee_message;
                        }
                    }

                } else {
                    if(typeof response.message!='undefined'){
                        RevyMain.showMessage(response.message, 3);
                    }else{
                        RevyMain.showMessage(RevyMain.data.error_message, 2);
                    }
                }
            },
            error: function () {
                RevyMain.closeProcess(self);
                RevyMain.showMessage(RevyMain.data.error_message, 2);
            }
        });
    };

    RevySMSTemplate.initTemplate = function(template){
        var customer_enable = 0,
            customer_message = '';

        for(var $i=0; $i< revy_sms_data.length; $i++){
            if(revy_sms_data[$i]['template'] == template){
                var data = revy_sms_data[$i];
                customer_enable = data['customer_enable'];
                customer_message = data['customer_message'];
            }
        }

        $('#customer_template_enable').prop("checked", customer_enable==1);
        $('#customer_template').html(customer_message);
        if ($('#customer_template_enable').is(':checked')) {
            $('.fields.customer-template').slideDown();
        } else {
            $('.fields.customer-template').hide();
        }
    };

    $(document).ready(function () {
        RevySMSTemplate.init();
    });
    $(window).load(function(){
        setTimeout(function(){
            var template = $('a.active','.fat-sb-sms-template-container .ui.menu').attr('data-template');
            RevySMSTemplate.initTemplate(template);
        },500);
    });
})(jQuery);