"use strict";
var RevyQuote = {
    bod_field: null,
    order: '',
    order_by: '',
    b_id: 0,
    b_time: 0,
    b_date: '',
    booking_detail: [],
    s_ids: [],
    garage_id: 0,
    delivery_method: 1,
    time_slot_monthly: [],
    time_slot: [],
    is_first_init: 0,
    b_date_type: ''
};
(function ($) {
        RevyQuote.init = function () {
            RevyMain.initField($('.fat-semantic-container'));
            RevyMain.initCheckAll();

            RevyQuote.loadQuote(1);

            RevyMain.registerEventProcess($('.fat-booking-status-list', '.fat-sb-booking-container'));
            RevyMain.registerEventProcess($('.toolbox-action-group', '.fat-sb-booking-container'));
            RevyMain.registerOnClick($('.fat-sb-order-wrap', '.fat-sb-booking-container'));

            $('.fat-sb-quote-container input.date-range-picker').on('apply.daterangepicker', function(ev, picker) {
                RevyQuote.searchDateOnChange($('.fat-sb-quote-container input.date-range-picker'));
            });
        };

        RevyQuote.loadQuote = function (page, callback) {
            var b_customer_name = $('#b_customer_name').val(),
                start_date = $('#date_of_book').attr('data-start'),
                start_time = $('#date_of_book').attr('data-start-time'),
                end_date = $('#date_of_book').attr('data-end'),
                end_time = $('#date_of_book').attr('data-end-time'),
                q_status = $('#b_process_status').val();
            $('.fat-sb-list-quote tbody tr').remove();
            page = typeof page != 'undefined' && page != '' ? page : 1;
            $.ajax({
                url: RevyMain.data.ajax_url,
                type: 'GET',
                data: ({
                    action: 'get_quotes',
                    q_name: b_customer_name,
                    start_date: start_date,
                    start_time: start_time,
                    end_date: end_date,
                    end_time: end_time,
                    q_status: q_status,
                    page: page
                }),
                success: function (response) {
                    response = $.parseJSON(response);
                    var total = response.total,
                        quotes = response.quotes,
                        template = wp.template('fat-sb-quote-item-template'),
                        items = '',
                        elm_quotes = $('.fat-sb-list-quotes');

                    items = $(template(quotes));
                    $('tbody tr', elm_quotes).remove();
                    if (quotes.length > 0) {
                        elm_quotes.append(items);
                        RevyMain.registerEventProcess($('.fat-sb-list-quotes'));
                        $('.fat-item-bt-inline[data-title]', '.fat-semantic-container').each(function () {
                            $(this).popup({
                                title: '',
                                content: $(this).attr('data-title'),
                                inline: true
                            });
                        });
                    } else {
                        RevyMain.showNotFoundMessage($('tbody', elm_quotes), '<tr><td colspan="10">', '</td></tr>');
                    }
                    RevyMain.initPaging(total, page, $('.fat-sb-pagination'));

                    $('table.fat-sb-list-quotes .ui.dropdown').suidropdown();

                    $('.fat-item-bt-inline[data-title]', '.fat-semantic-container').each(function () {
                        $(this).popup({
                            title: '',
                            content: $(this).attr('data-title'),
                            inline: true
                        });
                    });

                    if (callback) {
                        callback();
                    }
                },
                error: function () {
                    if (callback) {
                        callback();
                    }
                }
            })
        };

        RevyQuote.showPopupQuote = function (elm, callback) {
            var q_id = typeof elm.attr('data-id') != 'undefined' ? elm.attr('data-id') : 0;

            RevyMain.showProcess(elm);

            $.ajax({
                url: RevyMain.data.ajax_url,
                type: 'GET',
                data: ({
                    action: 'get_quote_by_id',
                    q_id: q_id
                }),
                success: function (response) {
                    RevyMain.closeProcess(elm);
                    response = $.parseJSON(response);
                    RevyMain.showPopup('fat-sb-quote-template', '', response, function () {

                        RevyMain.registerEventProcess($('.fat-sb-booking-form'));

                        if (typeof callback == 'function') {
                            callback();
                        }
                    });
                },
                error: function () {
                }
            });
        };

        /*
        Process on change
         */

        RevyQuote.dropdownClick = function (self) {
            var value = '',
                message = '';
            if (self.hasClass('fat-sb-services-dic')) {
                value = $('#b_service_cat_id').val();
                message = self.attr('data-warning-message');
            }

            if (self.hasClass('fat-sb-services-extra-dic')) {
                value = $('#b_service_id').val();
                message = self.attr('data-warning-message');
            }

            if (self.hasClass('fat-sb-employees-dic')) {
                value = $('#b_service_id').val();
                value = $('#b_garage_id').val() == '' ? '' : value;
                message = self.attr('data-warning-message');
            }
            if (self.hasClass('fat-customer-number-dic')) {
                value = $('#b_service_id').val();
                message = self.attr('data-warning-message');
            }

            if (value == '') {
                self.popup({
                    title: '',
                    on: 'click',
                    hoverable: true,
                    position: 'bottom left',
                    content: message,
                    inline: true
                }).popup('toggle');
            } else {
                self.popup('destroy');
            }
        };

        RevyQuote.searchNameKeyup = function (self) {
            var search_wrap = self.closest('.ui.input');
            if (self.val().length >= 3 || self.val() == '') {
                search_wrap.addClass('loading');
                RevyQuote.loadQuote(1, function () {
                    search_wrap.removeClass('loading');
                });
                if (self.val().length >= 3) {
                    search_wrap.addClass('active-search');
                }
                if (self.val() == '') {
                    search_wrap.removeClass('active-search');
                }
            }
        };

        RevyQuote.closeSearchOnClick = function (self) {
            var search_wrap = self.closest('.ui.ui-search');
            $('input', search_wrap).val('');
            $('input', search_wrap).trigger('keyup');
        };

        RevyQuote.searchDateOnChange = function (self) {
            var date_picker = self.closest('.ui.date-input');
            $('.ui.loader', date_picker).remove();
            date_picker.addClass('fat-loading');
            date_picker.append('<div class="ui active tiny inline loader"></div>');
            RevyQuote.loadQuote(1, function () {
                $('.ui.loader', date_picker).remove();
                date_picker.removeClass('fat-loading');
            });
        };

        RevyQuote.processDeleteQuote = function (self) {
            var btDelete = self;
            RevyMain.showConfirmPopup(RevyMain.data.confirm_delete_title, RevyMain.data.confirm_delete_message, function (result, popup) {
                if (result == 1) {
                    var self = $('.fat-sb-bt-confirm.yes', popup),
                        q_id = btDelete.attr('data-id');
                    $.ajax({
                        url: RevyMain.data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'delete_quote',
                            q_id: q_id
                        }),
                        success: function (response) {
                            try {
                                self.closest('.ui.modal').suimodal('hide');
                                response = $.parseJSON(response);
                                RevyMain.closeProcess(self);
                                if (response.result > 0) {
                                    RevyMain.showMessage(response.message);
                                    $('tr[data-id="' + q_id + '"]', '.fat-sb-list-quotes').remove();
                                } else {
                                    if (typeof response.message != 'undefined') {
                                        RevyMain.showMessage(response.message, 3);
                                    } else {
                                        RevyMain.showMessage(RevyMain.data.error_message, 2);
                                    }
                                }
                            } catch (err) {
                            }
                        },
                        error: function () {
                            RevyMain.closeProcess(self);
                        }
                    });
                }
            });

        };

        $(document).ready(function () {
            if ($('.fat-sb-quote-container').length > 0) {
                RevyQuote.init();
            }
        });
    }
)(jQuery);