"use strict";
var RevyCategory = {};

(function ($) {
    RevyCategory.init = function () {
        RevyMain.initField($('.fat-semantic-container'));
        RevyCategory.loadCategory();
        RevyMain.registerEventProcess($('.fat-sb-category-container .toolbox-action-group'));
        RevyMain.initPopupToolTip();
    };

    RevyCategory.initButtonToolTip = function () {
        $('.fat-item-bt-inline[data-title]', '.fat-semantic-container').each(function () {
            var position = $(this).attr('data-position'),
                option = {
                    title: '',
                    content: $(this).attr('data-title'),
                    inline: true
                };
            if (typeof position != 'undefined') {
                option['position'] = position;
            }
            $(this).popup(option);
        });
    };

    RevyCategory.loadCategory = function (page, callback) {
        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'GET',
            data: ({
                action: 'get_category',
                page: typeof page!='undefined' && page!='' ? page: 1
            }),
            success: function (data) {
                data = $.parseJSON(data);
                var total = data.total,
                    categories = data.categories;

                var template = wp.template('fat-sb-category-item-template'),
                    items = $(template(categories)),
                    elm_category = $('.fat-sb-list-category');

                $('tbody tr', elm_category).remove();
                $('.fat-tr-not-found', elm_category).remove();
                if (categories.length > 0) {
                    elm_category.append(items);
                    RevyMain.registerEventProcess($('.fat-sb-list-category'));
                    RevyCategory.initButtonToolTip();
                } else {
                    RevyMain.showNotFoundMessage(elm_category,'<tr class="fat-tr-not-found"><td colspan="5">','</td></tr>');
                }

                RevyMain.initPaging(total, page, $('.fat-sb-pagination'));
                RevyMain.initCheckAll();
                if (typeof callback == 'function') {
                    callback();
                }
            },
            error: function () {
                if (typeof callback == 'function') {
                    callback();
                }
            }
        })
    };

    RevyCategory.processEditCategory = function(elm){
        var c_id = typeof elm.attr('data-id') != 'undefined' ? elm.attr('data-id') : 0,
            popup_title = typeof c_id != 'undefined' ? RevyMain.data.modal_title.edit_category : '';
        RevyCategory.showPopupCategory(elm, c_id, popup_title);
    };

    RevyCategory.processAddCategory = function (elm){
        RevyCategory.showPopupCategory(elm, 0, '');
    };

    RevyCategory.showPopupCategory = function (elm, c_id, popup_title, callback) {
        RevyMain.showProcess(elm);
        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'POST',
            data: ({
                action: 'get_category_by_id',
                c_id: c_id
            }),
            success: function (response) {
                RevyMain.closeProcess(elm);
                response = $.parseJSON(response);

                RevyMain.showPopup('fat-sb-services-category-template', popup_title, response, function () {
                    RevyMain.registerEventProcess($('.fat-sb-category-form'));
                    if(callback){
                        callback();
                    }

                });
            },
            error: function () {
            }
        });
    };

    RevyCategory.processSubmitCategory = function (self) {
        if (RevyMain.isFormValid) {
            var form = $('.fat-sb-category-form'),
                image_url = $('#c_image_id img').attr('src'),
                data = {};

            if (typeof self.attr('data-id') != 'undefined' && self.attr('data-id') != '') {
                data.c_id = self.attr('data-id');
            } else {
                data.c_id = '';
            }

            data.c_image_url = image_url;
            data.c_image_id = $('#c_image_id',form).attr('data-image-id');
            data.c_name = $('#c_name', form).val();
            data.c_device_id = $('#c_device_id',form).val();
            data.c_brand_id = $('#c_brand_id',form).val();
            data.rd_name = $('.rm-device', form).suidropdown('get text');
            data.rb_name = $('.rm-brand', form).suidropdown('get text');


            if (typeof self.attr('data-id') != 'undefined' && self.attr('data-id') != '') {
                data.c_id = self.attr('data-id');
                RevyMain.showProcess(self);
                RevyCategory.submitCategory(self, data);
            } else {
                RevyMain.showProcess(self);
                RevyCategory.submitCategory(self, data);
            }
        }
    };

    RevyCategory.submitCategory = function (self, data) {

        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'POST',
            data: ({
                action: 'save_category',
                data: data
            }),
            success: function (response) {
                RevyMain.closeProcess(self);
                self.closest('.ui.modal').suimodal('hide');
                response = $.parseJSON(response);

                if (response.result >= 0) {
                    RevyMain.showMessage(self.attr('data-success-message'));
                    $('.fat-sb-list-category .fat-sb-not-found').remove();

                    //update back to list
                    var item = $('.fat-sb-list-category .item[data-id="' + data.c_id + '"]');

                    if (item.length == 0) {
                        data.c_id = response.result;
                        var template = wp.template('fat-sb-category-item-template'),
                            item = $(template([data]));
                        $('.fat-sb-list-category').append(item);
                        RevyMain.registerEventProcess(item);

                    } else {
                        $('.fat-c-name', item).html(data.c_name);
                        $('.fat-c-device', item).html(data.rd_name);
                        $('.fat-c-brand', item).html(data.rb_name);
                        $('.fat-c-image', item).attr('src', data.c_image_url);
                    }

                } else {
                    if (typeof response.message != 'undefined') {
                        RevyMain.showMessage(response.message, 3);
                    } else {
                        RevyMain.showMessage(RevyMain.data.error_message, 2);
                    }
                }
            },
            error: function () {
                RevyMain.closeProcess(self);
                RevyMain.showMessage(RevyMain.data.error_message, 2);
            }
        });
    };

    RevyCategory.processDeleteCategory = function(self){
        var btDelete = self;
        RevyMain.showConfirmPopup(RevyMain.data.confirm_delete_title, RevyMain.data.confirm_delete_message, function (result, popup) {
            if (result == 1) {
                var self = $('.fat-sb-bt-confirm.yes', popup),
                    c_id = btDelete.attr('data-id');


                RevyMain.showProcess(self);
                $.ajax({
                    url: RevyMain.data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'delete_category',
                        c_id: c_id
                    }),
                    success: function (response) {
                        try {
                            RevyMain.closeProcess(self);
                            self.closest('.ui.modal').suimodal('hide');
                            response = $.parseJSON(response);
                            if (response.result > 0) {
                                $('tr[data-id="'+ c_id +'"]','.fat-sb-list-category').remove();
                                if ($('.fat-sb-list-category .item').length == 0) {
                                    RevyMain.showNotFoundMessage($('.fat-sb-list-category'),'<tr class="fat-tr-not-found"><td colspan="7">','</td></tr>');
                                }
                            } else {
                                if(typeof response.message!='undefined'){
                                    RevyMain.showMessage(response.message, 3);
                                }else{
                                    RevyMain.showMessage(RevyMain.data.error_message, 2);
                                }
                            }
                        } catch (err) {
                            RevyMain.closeProcess(self);
                            RevyMain.showMessage(RevyMain.data.error_message);
                        }
                    },
                    error: function () {
                        FatSbMain.closeProcess(self);
                        FatSbMain.showMessage(FatSbMain.data.error_message);
                    }
                });
            }
        });
    };

    RevyCategory.openImport = function (self){
        $('.fat-semantic-container .content.category').fadeOut(function(){
            $('.fat-semantic-container .content.fat-sb-import-section').fadeIn();
        })
    };

    RevyCategory.closeImport = function (self){
        $('.fat-semantic-container .content.fat-sb-import-section').fadeOut(function(){
            $('.fat-semantic-container .content.category').fadeIn();
        })
    };


    RevyCategory.processExportModelCategory = function(self){
        self.addClass('loading');
        $.ajax({
            url: RevyMain.data.ajax_url,
            type: 'GET',
            data: ({
                action: 'export_model_category',
            }),
            success: function(model_category){
                model_category = $.parseJSON(model_category);

                var csv = [],
                    row = [],
                    csvFile,
                    downloadLink;

                if (model_category.length > 0) {

                    row = [];
                    row.push('ID');
                    row.push('Thumb_ID');
                    row.push('Thumb_URL');
                    row.push('Device_Name');
                    row.push('Brand_Name');
                    row.push('Name');
                    csv.push(row.join(","));

                    for (let md of model_category) {
                        row = [];
                        row.push(md.c_id);
                        row.push('');
                        row.push(md.c_thumb);
                        row.push('"' + md.rd_name + '"');
                        row.push('"' + md.rb_name + '"');
                        row.push('"' + md.c_name + '"');
                        csv.push(row.join(","));
                    }

                    csv = csv.join("\n");
                    csvFile = new Blob([csv], {type: "text/csv"});

                    // Download link
                    downloadLink = document.createElement("a");

                    // File name
                    downloadLink.download = '03_revy_model_category.csv';

                    // Create a link to the file
                    downloadLink.href = window.URL.createObjectURL(csvFile);

                    // Hide download link
                    downloadLink.style.display = "none";

                    // Add the link to DOM
                    document.body.appendChild(downloadLink);
                    downloadLink.click();
                    self.removeClass('loading');
                }else{
                    self.removeClass('loading');
                    RevyMain.showMessage(RevyMain.data.not_found_message, 2);
                }

            },
            error: function(){
                self.removeClass('loading');
                RevyMain.showMessage(RevyMain.data.error_message, 2);
            }
        })
    };


    $(document).ready(function () {
        if ($('.fat-sb-category-container').length > 0) {
            RevyCategory.init();
        }
    });

})(jQuery)