<?php

if (!defined('ABSPATH')) {
	exit();
}

if (!class_exists('FP_RAC_Main_Function_Importing_Part')) {

	/**
	 * FP_RAC_Main_Function_Importing_Part Class.
	 */
	class FP_RAC_Main_Function_Importing_Part {

		public static $process_previous_order;
		public static $process_cartlist_auto_delete;
		public static $process_email_log_auto_delete;

		public static function init() {

			if (self::fp_rac_upgrade_file_exists()) {
				$background_files = array(
					'WP_Async_Request' => untrailingslashit(WP_PLUGIN_DIR) . '/woocommerce/includes/libraries/wp-async-request.php',
					'WP_Background_Process' => untrailingslashit(WP_PLUGIN_DIR) . '/woocommerce/includes/libraries/wp-background-process.php',
					'FP_RAC_Previous_Order_Background_Process' => RAC_PLUGIN_PATH . '/inc/background-updater/fp-rac-previous-order-background-process.php',
					'FP_RAC_Cartlist_Auto_Delete_Background_Process' => RAC_PLUGIN_PATH . '/inc/background-updater/fp-rac-carlist-auto-delete-background-process.php',
					'FP_RAC_Email_Log_Auto_Delete_Background_Process' => RAC_PLUGIN_PATH . '/inc/background-updater/fp-rac-email-log-auto-delete-background-process.php',
				);

				if (rac_check_is_array($background_files)) {
					foreach ($background_files as $classname => $file_path) {
						if (!class_exists($classname)) {
							include_once $file_path;
						}
					}
				}

				self::$process_previous_order = new FP_RAC_Previous_Order_Background_Process();
				self::$process_cartlist_auto_delete = new FP_RAC_Cartlist_Auto_Delete_Background_Process();
				self::$process_email_log_auto_delete = new FP_RAC_Email_Log_Auto_Delete_Background_Process();
			}
		}

		/*
		 * Check if Background Related Files exists
		 */

		public static function fp_rac_upgrade_file_exists() {
			$async_file = file_exists(untrailingslashit(WP_PLUGIN_DIR) . '/woocommerce/includes/libraries/wp-async-request.php');
			$background_file = file_exists(untrailingslashit(WP_PLUGIN_DIR) . '/woocommerce/includes/libraries/wp-background-process.php');

			if ($async_file && $background_file) {
				return true;
			}

			return false;
		}

		/**
		 * Handle Previous Order
		 */
		public static function handle_previous_order( $offset = 0, $limit = 1000 ) {
			$ids = get_option('rac_previous_order_background_updater_data');
			$ids = array_slice($ids, $offset, $limit);
			if (rac_check_is_array($ids)) {
				foreach ($ids as $id) {
					self::$process_previous_order->push_to_queue($id);
				}
			} else {
				self::$process_previous_order->push_to_queue('rac_no_data');
			}
			//update offset 
			update_option('rac_previous_order_background_updater_offset', $limit + $offset);
			if (0 == $offset) {
				FP_RAC_WooCommerce_Log::log('Previous Order Upgrade Started');
			}

			self::$process_previous_order->save()->dispatch();
		}

		/**
		 * Handle Cart List Auto Remove
		 */
		public static function handle_cartlist_auto_delete( $offset = 0, $limit = 1000 ) {
			$ids = get_option('rac_cartlist_auto_delete_background_updater_data');
			$ids = array_slice($ids, $offset, $limit);

			if (rac_check_is_array($ids)) {
				foreach ($ids as $id) {
					self::$process_cartlist_auto_delete->push_to_queue($id);
				}
			} else {
				self::$process_cartlist_auto_delete->push_to_queue('rac_no_data');
			}

			//update offset 
			update_option('rac_cartlist_auto_delete_background_updater_offset', $limit + $offset);

			if (0 == $offset) {
				FP_RAC_WooCommerce_Log::log('Cartlist automatic delete started');
			}

			self::$process_cartlist_auto_delete->save()->dispatch();
		}

		/**
		 * Handle E-mail Log Auto Remove
		 */
		public static function handle_email_log_auto_delete( $offset = 0, $limit = 1000 ) {
			$ids = get_option('rac_email_log_auto_delete_background_updater_data');
			$ids = array_slice($ids, $offset, $limit);

			if (rac_check_is_array($ids)) {
				foreach ($ids as $id) {
					self::$process_email_log_auto_delete->push_to_queue($id);
				}
			} else {
				self::$process_email_log_auto_delete->push_to_queue('rac_no_data');
			}

			//update offset 
			update_option('rac_email_log_auto_delete_background_updater_offset', $limit + $offset);

			if (0 == $offset) {
				FP_RAC_WooCommerce_Log::log('E-mail log automatic delete started');
			}

			self::$process_email_log_auto_delete->save()->dispatch();
		}
	}

	FP_RAC_Main_Function_Importing_Part::init();
}
