/* global fp_unsubscribe_obj */

jQuery(function ($) {
	'use strict' ;

	var Unsubscribe = {
		init: function () {
			$(document).on('change', '#fp_rac_unsubscribe_option', this.toggle_customer_email_subscription);
		},
		toggle_customer_email_subscription: function (event) {
			event.preventDefault();
			var $this = $(event.currentTarget);
			var data = {
				action: 'rac_toggle_customer_email_subscription',
				user_id: fp_unsubscribe_obj.rac_current_userid,
				unsubscribe: $($this).is(':checked') ? 'yes' : 'no',
				rac_security: fp_unsubscribe_obj.rac_unsubcribe_nonce
			};

			$.post(fp_unsubscribe_obj.rac_admin_url, data,function (res) {
				$("p.un_sub_email_css").hide();
				if (true === res.success) {
					alert(res.data.message);
				} else {
					alert(res.data.error);
				}
			});
		}

	};
	Unsubscribe.init();
});
