<?php
/**
 * Globalize the AWS Polly client.
 *
 * @package real-voice-pro
 */

// Prevent direct access to this file.
if ( ! defined( 'WPINC' ) ) {
	die();
}

if ( ! ( PHP_VERSION_ID >= 80100 ) ) {
	return;
}

// Load the AWS SDK for PHP.
$plugin_dir = substr( plugin_dir_path( __FILE__ ), 0, - 11 );
require $plugin_dir . 'vendor/autoload.php';

use Aws\Polly\PollyClient;
use Aws\Credentials\Credentials;

// AWS credentials.
$access_key_id     = get_option( 'daextrevop_aws_access_key_id' );
$secret_access_key = get_option( 'daextrevop_aws_secret_access_key' );
$region            = get_option( 'daextrevop_aws_region' );

global $daextrevop_aws_client;

// Create an AWS Polly client.
$daextrevop_aws_credentials = new Credentials( $access_key_id, $secret_access_key );
$daextrevop_aws_client      = new PollyClient(
	array(
		'version'     => 'latest',
		'region'      => $region,
		'credentials' => $daextrevop_aws_credentials,
	)
);
