<?php

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Tab;

class TabAccessibilityStatement extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'accessibility_statement';

	/**
	 * Get Accessibility Statement tab controls.
	 *
	 * @return array
	 */
	public static function controls(): array {

		$fields = [];

		# Website Owner's Contact Info header
		$fields['owner_contact_info_header'] = [
			'type'        => 'header',
			'label'       => esc_html__( 'Website Owner\'s Contact Info', 'readabler' ),
			'description' => esc_html__( 'This contact info will be used in the Accessibility Statement, to comply with the WCAG 2.1, and therefore with the ADA and Section 508. We do not use personal information and abides by data privacy laws.', 'readabler' ),
			'default'     => ''
		];

		# Accessibility statement type
		$fields['statement_type'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Statement source', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Accessibility Statement', 'readabler' ),
			'description' => esc_html__( 'Select the accessibility statement source', 'readabler' ),
			'default'     => 'inline',
			'options'     => [
				'inline' => esc_html__( 'Generated by plugin', 'readabler' ),
				'link'   => esc_html__( 'Custom link', 'readabler' ),
				'hide'   => esc_html__( 'None', 'readabler' )
			]
		];

		# Statement URL
		$fields['statement_link'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Statement URL', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'URL', 'readabler' ),
			'description' => esc_html__( 'Insert the accessibility statement link', 'readabler' ),
			'default'     => '',
			'attr'        => [
				'maxlength' => '4500'
			]
		];

		# Header generated
		$fields['owner_contact_info_header_generated'] = [
			'type'        => 'header',
			'description' => '<strong>' . esc_html__( 'Note', 'readabler' ) . ': ' . '</strong>' . esc_html__( 'If you are an agency purchasing for a client, you should enter your client\'s contact information.', 'readabler' ),
			'default'     => ''
		];

		# Website's Owner Name
		$fields['owner_name'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Website\'s Owner Name', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'Full Name', 'readabler' ),
			'default'     => '',
			'attr'        => [
				'maxlength' => '4500'
			]
		];

		# Website's Owner Email
		$fields['owner_email'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Website\'s Owner Email', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'E-mail', 'readabler' ),
			'default'     => '',
			'attr'        => [
				'maxlength' => '4500'
			]
		];

		# Website's Owner Phone
		$fields['owner_phone'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Website\'s Owner Phone', 'readabler' ) . ':',
			'placeholder' => esc_html__( 'phone', 'readabler' ),
			'default'     => '',
			'attr'        => [
				'maxlength' => '4500'
			]
		];

		# Accessibility Statement
		$fields['statement_text'] = [
			'type'        => 'editor',
			'label'       => esc_html__( 'Accessibility Statement', 'readabler' ) . ':',
			'description' => esc_html__( 'You can use special placeholders: {siteDomain}, {currentDate}, {contactEmail}, {contactName}, {contactPhone}. They will be replaced with their values accordingly.', 'readabler' ),
			'default'     => self::get_default_statement(),
			'attr'        => [
				'textarea_rows' => '20',
			]
		];

		return $fields;

	}

	/**
	 * Add Accessibility Statement tab.
	 * @return void
	 */
	public static function add_tab() {
		self::add_settings_tab(
			self::$key,
			4,
			'tune',
			esc_html__( 'Accessibility Statement', 'readabler' ),
			esc_html__( 'Accessibility Statement Settings', 'readabler' ),
			esc_html__( "Configure the Accessibility Statement page settings. This page provides information about your website's accessibility features and compliance with accessibility standards.", 'readabler' )
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

	/**
	 * Get default accessibility statement.
	 *
	 * @return string
	 */
	public static function get_default_statement(): string {

		// language=HTML
		return "<section>
	<h2>Accessibility Statement</h2>
	<ul>
	    <li>{siteDomain}</li>
	    <li>{currentDate}</li>
	</ul>
</section>

<h3>Compliance status</h3>
<p>We firmly believe that the internet should be available and accessible to anyone, and are committed to providing a website that is accessible to the widest possible audience,
regardless of circumstance and ability.</p>

<p>To fulfill this, we aim to adhere as strictly as possible to the World Wide Web Consortium’s (W3C) Web Content Accessibility Guidelines 2.1 (WCAG 2.1) at the AA level.
These guidelines explain how to make web content accessible to people with a wide array of disabilities. Complying with those guidelines helps us ensure that the website is accessible
to all people: blind people, people with motor impairments, visual impairment, cognitive disabilities, and more.</p>

<p>This website utilizes various technologies that are meant to make it as accessible as possible at all times. We utilize an accessibility interface that allows persons with specific
disabilities to adjust the website’s UI (user interface) and design it to their personal needs.</p>

<p>Additionally, the website utilizes an AI-based application that runs in the background and optimizes its accessibility level constantly. This application remediates the website’s HTML,
adapts Its functionality and behavior for screen-readers used by the blind users, and for keyboard functions used by individuals with motor impairments.</p>

<p>If you’ve found a malfunction or have ideas for improvement, we’ll be happy to hear from you. You can reach out to the website’s operators by using the following email {contactEmail}</p>

<h3>Screen-reader and keyboard navigation</h3>

<p>Our website implements the ARIA attributes (Accessible Rich Internet Applications) technique, alongside various different behavioral changes, to ensure blind users visiting with
screen-readers are able to read, comprehend, and enjoy the website’s functions. As soon as a user with a screen-reader enters your site, they immediately receive
a prompt to enter the Screen-Reader Profile so they can browse and operate your site effectively. Here’s how our website covers some of the most important screen-reader requirements,
alongside console screenshots of code examples:</p>

<ol>
 	<li>
 	
	    <p><strong>Screen-reader optimization: </strong>we run a background process that learns the website’s components from top to bottom, to ensure ongoing compliance even when updating the website.
	In this process, we provide screen-readers with meaningful data using the ARIA set of attributes. For example, we provide accurate form labels;
	descriptions for actionable icons (social media icons, search icons, cart icons, etc.); validation guidance for form inputs; element roles such as buttons, menus, modal dialogues (popups),
	and others. Additionally, the background process scans all the website’s images and provides an accurate and meaningful image-object-recognition-based description as an ALT (alternate text) tag
	for images that are not described. It will also extract texts that are embedded within the image, using an OCR (optical character recognition) technology.
	To turn on screen-reader adjustments at any time, users need only to press the Alt+1 keyboard combination. Screen-reader users also get automatic announcements to turn the Screen-reader mode on
	as soon as they enter the website.</p>
	
		<p>These adjustments are compatible with all popular screen readers, including JAWS and NVDA.</p>
	</li>
 	<li>
 		<p><strong>Keyboard navigation optimization: </strong>The background process also adjusts the website’s HTML, and adds various behaviors using JavaScript code to make the website operable by the keyboard. This includes the ability to navigate the website using the Tab and Shift+Tab keys, operate dropdowns with the arrow keys, close them with Esc, trigger buttons and links using the Enter key, navigate between radio and checkbox elements using the arrow keys, and fill them in with the Spacebar or Enter key.Additionally, keyboard users will find quick-navigation and content-skip menus, available at any time by clicking Alt+1, or as the first elements of the site while navigating with the keyboard. The background process also handles triggered popups by moving the keyboard focus towards them as soon as they appear, and not allow the focus drift outside it.</p> 
		<p>Users can also use shortcuts such as “M” (menus), “H” (headings), “F” (forms), “B” (buttons), and “G” (graphics) to jump to specific elements.</p>
	</li>
</ol>

<h3>Disability profiles supported in our website</h3>
<ul>
 	<li><strong>Epilepsy Safe Mode:</strong> this profile enables people with epilepsy to use the website safely by eliminating the risk of seizures that result from flashing or blinking animations and risky color combinations.</li>
 	<li><strong>Visually Impaired Mode:</strong> this mode adjusts the website for the convenience of users with visual impairments such as Degrading Eyesight, Tunnel Vision, Cataract, Glaucoma, and others.</li>
 	<li><strong>Cognitive Disability Mode:</strong> this mode provides different assistive options to help users with cognitive impairments such as Dyslexia, Autism, CVA, and others, to focus on the essential elements of the website more easily.</li>
 	<li><strong>ADHD Friendly Mode:</strong> this mode helps users with ADHD and Neurodevelopmental disorders to read, browse, and focus on the main website elements more easily while significantly reducing distractions.</li>
 	<li><strong>Blindness Mode:</strong> this mode configures the website to be compatible with screen-readers such as JAWS, NVDA, VoiceOver, and TalkBack. A screen-reader is software for blind users that is installed on a  computer and smartphone, and websites must be compatible with it.</li>
 	<li><strong>Keyboard Navigation Profile (Motor-Impaired):</strong> this profile enables motor-impaired persons to operate the website using the keyboard Tab, Shift+Tab, and the Enter keys. Users can also use shortcuts such as “M” (menus), “H” (headings), “F” (forms), “B” (buttons), and “G” (graphics) to jump to specific elements.</li>
</ul>

<h3>Additional UI, design, and readability adjustments</h3>
<ol>
 	<li><strong>Font adjustments –</strong> users, can increase and decrease its size, change its family (type), adjust the spacing, alignment, line height, and more.</li>
 	<li><strong>Color adjustments –</strong> users can select various color contrast profiles such as light, dark, inverted, and monochrome. Additionally, users can swap color schemes of titles, texts, and backgrounds, with over seven different coloring options.</li>
 	<li><strong>Animations –</strong> person with epilepsy can stop all running animations with the click of a button. Animations controlled by the interface include videos, GIFs, and CSS flashing transitions.</li>
 	<li><strong>Content highlighting –</strong> users can choose to emphasize important elements such as links and titles. They can also choose to highlight focused or hovered elements only.</li>
 	<li><strong>Audio muting –</strong> users with hearing devices may experience headaches or other issues due to automatic audio playing. This option lets users mute the entire website instantly.</li>
 	<li><strong>Cognitive disorders –</strong> we utilize a search engine that is linked to Wikipedia and Wiktionary, allowing people with cognitive disorders to decipher meanings of phrases, initials, slang, and others.</li>
 	<li><strong>Additional functions –</strong> we provide users the option to change cursor color and size, use a printing mode, enable a virtual keyboard, and many other functions.</li>
</ol>

<h3>Browser and assistive technology compatibility</h3>

<p>We aim to support the widest array of browsers and assistive technologies as possible, so our users can choose the best fitting tools for them, with as few limitations as possible. Therefore, we have worked very hard to be able to support all major systems that comprise over 95% of the user market share including Google Chrome, Mozilla Firefox, Apple Safari, Opera and Microsoft Edge, JAWS and NVDA (screen readers).</p>

<h3>Notes, comments, and feedback</h3>
<p>Despite our very best efforts to allow anybody to adjust the website to their needs. There may still be pages or sections that are not fully accessible, are in the process of becoming accessible, or are lacking an adequate technological solution to make them accessible. Still, we are continually improving our accessibility, adding, updating and improving its options and features, and developing and adopting new technologies. All this is meant to reach the optimal level of accessibility, following technological advancements. For any assistance, please reach out to {contactEmail}</p>";

	}

}
