<?php

namespace Merkulove\Readabler;

use Merkulove\Readabler\Unity\Activator;
use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\TabActivation;
use Merkulove\Readabler\Unity\Task;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class Actions {
	private static ?Actions $instance = null;

	private function __construct() {
		add_action( Plugin::const( 'cron_hook' ) . '_after', [ $this, 'after_cron' ] );
	}

	/**
	 * Actions to perform after cron job finishes.
	 * @return void
	 */
	public function after_cron(): void {

		// If the plugin is activated via TabActivation, do nothing
		if ( TabActivation::get_instance()->is_activated() ) {
			return;
		}

		// Set transient to indicate trial period has ended
		if ( time() - Activator::get_timestamp() > Task::interval() * 3 ) {
			update_option( Plugin::const( 'slug' ) . '_trial_ended', 1 );
		}

	}

	public static function get_instance(): Actions {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	private function __clone() {
	}

	public function __wakeup() {
	}
}
