/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@popperjs/core/lib/createPopper.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/createPopper.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   popperGenerator: () => (/* binding */ popperGenerator)
/* harmony export */ });
/* harmony import */ var _dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dom-utils/getCompositeRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dom-utils/listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/orderModifiers.js */ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/debounce.js */ "./node_modules/@popperjs/core/lib/utils/debounce.js");
/* harmony import */ var _utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/mergeByName.js */ "./node_modules/@popperjs/core/lib/utils/mergeByName.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");









var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: (0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(reference) ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference) : reference.contextElement ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference.contextElement) : [],
          popper: (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = (0,_utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__["default"])([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        });
        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: (0,_dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_4__["default"])(reference, (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_5__["default"])(popper), state.options.strategy === 'fixed'),
          popper: (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: (0,_utils_debounce_js__WEBPACK_IMPORTED_MODULE_7__["default"])(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {
      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref) {
        var name = _ref.name,
            _ref$options = _ref.options,
            options = _ref$options === void 0 ? {} : _ref$options,
            effect = _ref.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}
var createPopper = /*#__PURE__*/popperGenerator(); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/contains.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/contains.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ contains)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBoundingClientRect)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isLayoutViewport.js */ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getBoundingClientRect(element, includeScale, isFixedStrategy) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }

  var clientRect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if (includeScale && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    scaleX = element.offsetWidth > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.width) / element.offsetWidth || 1 : 1;
    scaleY = element.offsetHeight > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.height) / element.offsetHeight || 1 : 1;
  }

  var _ref = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) : window,
      visualViewport = _ref.visualViewport;

  var addVisualOffsets = !(0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__["default"])() && isFixedStrategy;
  var x = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
  var y = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
  var width = clientRect.width / scaleX;
  var height = clientRect.height / scaleY;
  return {
    width: width,
    height: height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getClippingRect)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getViewportRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js");
/* harmony import */ var _getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getDocumentRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js");
/* harmony import */ var _listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _contains_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");















function getInnerBoundingClientRect(element, strategy) {
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element, false, strategy === 'fixed');
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent, strategy) {
  return clippingParent === _enums_js__WEBPACK_IMPORTED_MODULE_1__.viewport ? (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element, strategy)) : (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = (0,_listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_8__["default"])(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__["default"])(element).position) >= 0;
  var clipperElement = canEscapeClipping && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isHTMLElement)(element) ? (0,_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__["default"])(element) : element;

  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) && (0,_contains_js__WEBPACK_IMPORTED_MODULE_11__["default"])(clippingParent, clipperElement) && (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_12__["default"])(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary, strategy) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent, strategy);
    accRect.top = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.top, accRect.top);
    accRect.right = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent, strategy));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getCompositeRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getNodeScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");









function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) / element.offsetWidth || 1;
  var scaleY = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent);
  var offsetParentIsScaled = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent) && isElementScaled(offsetParent);
  var documentElement = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent);
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(elementOrVirtualElement, offsetParentIsScaled, isFixed);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__["default"])(documentElement)) {
      scroll = (0,_getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__["default"])(offsetParent);
    }

    if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent)) {
      offsets = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__["default"])(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getComputedStyle)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getComputedStyle(element) {
  return (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element).getComputedStyle(element);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentElement)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return (((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentRect)
/* harmony export */ });
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");




 // Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var winScroll = (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);
  var y = -winScroll.scrollTop;

  if ((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__["default"])(body || html).direction === 'rtl') {
    x += (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getHTMLElementScroll)
/* harmony export */ });
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getLayoutRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
 // Returns the layout rect of an element relative to its offsetParent. Layout
// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeName)
/* harmony export */ });
function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeScroll)
/* harmony export */ });
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getHTMLElementScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js");




function getNodeScroll(node) {
  if (node === (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node) || !(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node)) {
    return (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node);
  } else {
    return (0,_getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node);
  }
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOffsetParent)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _isTableElement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./isTableElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/userAgent.js */ "./node_modules/@popperjs/core/lib/utils/userAgent.js");








function getTrueOffsetParent(element) {
  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || // https://github.com/popperjs/popper-core/issues/837
  (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = /firefox/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__["default"])());
  var isIE = /Trident/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__["default"])());

  if (isIE && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = (0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(currentNode)) {
    currentNode = currentNode.host;
  }

  while ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(currentNode) && ['html', 'body'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(currentNode)) < 0) {
    var css = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_5__["default"])(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && (0,_isTableElement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(offsetParent) && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) === 'html' || (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) === 'body' && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getParentNode)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");



function getParentNode(element) {
  if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isShadowRoot)(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) // fallback

  );
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getScrollParent)
/* harmony export */ });
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");




function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node) && (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node)) {
    return node;
  }

  return getScrollParent((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getViewportRect)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isLayoutViewport.js */ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getViewportRect(element, strategy) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0;

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    var layoutViewport = (0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_2__["default"])();

    if (layoutViewport || !layoutViewport && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element),
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js":
/*!****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindow.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindow)
/* harmony export */ });
function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScroll)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getWindowScroll(node) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScrollBarX)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");



function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)).left + (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element).scrollLeft;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");


function isElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isLayoutViewport)
/* harmony export */ });
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/userAgent.js */ "./node_modules/@popperjs/core/lib/utils/userAgent.js");

function isLayoutViewport() {
  return !/^((?!chrome|android).)*safari/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__["default"])());
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isScrollParent)
/* harmony export */ });
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isTableElement)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");

function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) >= 0;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js":
/*!************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ listScrollParents)
/* harmony export */ });
/* harmony import */ var _getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");




/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = (0,_getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(target)));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/enums.js":
/*!**************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/enums.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterMain: () => (/* binding */ afterMain),
/* harmony export */   afterRead: () => (/* binding */ afterRead),
/* harmony export */   afterWrite: () => (/* binding */ afterWrite),
/* harmony export */   auto: () => (/* binding */ auto),
/* harmony export */   basePlacements: () => (/* binding */ basePlacements),
/* harmony export */   beforeMain: () => (/* binding */ beforeMain),
/* harmony export */   beforeRead: () => (/* binding */ beforeRead),
/* harmony export */   beforeWrite: () => (/* binding */ beforeWrite),
/* harmony export */   bottom: () => (/* binding */ bottom),
/* harmony export */   clippingParents: () => (/* binding */ clippingParents),
/* harmony export */   end: () => (/* binding */ end),
/* harmony export */   left: () => (/* binding */ left),
/* harmony export */   main: () => (/* binding */ main),
/* harmony export */   modifierPhases: () => (/* binding */ modifierPhases),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   popper: () => (/* binding */ popper),
/* harmony export */   read: () => (/* binding */ read),
/* harmony export */   reference: () => (/* binding */ reference),
/* harmony export */   right: () => (/* binding */ right),
/* harmony export */   start: () => (/* binding */ start),
/* harmony export */   top: () => (/* binding */ top),
/* harmony export */   variationPlacements: () => (/* binding */ variationPlacements),
/* harmony export */   viewport: () => (/* binding */ viewport),
/* harmony export */   write: () => (/* binding */ write)
/* harmony export */ });
var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/applyStyles.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

 // This modifier takes the styles prepared by the `computeStyles` modifier
// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect,
  requires: ['computeStyles']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/arrow.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/arrow.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../dom-utils/contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");








 // eslint-disable-next-line import/no-unused-modules

var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return (0,_utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(typeof padding !== 'number' ? padding : (0,_utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_2__.basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(state.placement);
  var axis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(basePlacement);
  var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_2__.left, _enums_js__WEBPACK_IMPORTED_MODULE_2__.right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])(arrowElement);
  var minProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.top : _enums_js__WEBPACK_IMPORTED_MODULE_2__.left;
  var maxProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_2__.right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_7__.within)(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (!(0,_dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_8__["default"])(state.elements.popper, arrowElement)) {
    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/computeStyles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mapToStyles: () => (/* binding */ mapToStyles)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");







 // eslint-disable-next-line import/no-unused-modules

var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref, win) {
  var x = _ref.x,
      y = _ref.y;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(x * dpr) / dpr || 0,
    y: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(y * dpr) / dpr || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets,
      isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
      x = _offsets$x === void 0 ? 0 : _offsets$x,
      _offsets$y = offsets.y,
      y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.left;
  var sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;
  var win = window;

  if (adaptive) {
    var offsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper)) {
      offsetParent = (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(popper);

      if ((0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__["default"])(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.right) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom;
      var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
      offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.right;
      var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
      offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
    x: x,
    y: y
  }, (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper)) : {
    x: x,
    y: y
  };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref5) {
  var state = _ref5.state,
      options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
  var commonStyles = {
    placement: (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.placement),
    variation: (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__["default"])(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === 'fixed'
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/eventListeners.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
 // eslint-disable-next-line import/no-unused-modules

var passive = {
  passive: true
};

function effect(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/flip.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/flip.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getOppositePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getOppositeVariationPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/computeAutoPlacement.js */ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");






 // eslint-disable-next-line import/no-unused-modules

function getExpandedFallbackPlacements(placement) {
  if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto) {
    return [];
  }

  var oppositePlacement = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(placement);
  return [(0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement), oppositePlacement, (0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [(0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto ? (0,_utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);

    var isStartVariation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.start;
    var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.top, _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.right : _enums_js__WEBPACK_IMPORTED_MODULE_1__.left : isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    }

    var altVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/hide.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/hide.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");



function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}

function isAnySideFullyClipped(overflow) {
  return [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom, _enums_js__WEBPACK_IMPORTED_MODULE_0__.left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
      name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    elementContext: 'reference'
  });
  var popperAltOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-reference-hidden': isReferenceHidden,
    'data-popper-escaped': hasPopperEscaped
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'hide',
  enabled: true,
  phase: 'main',
  requiresIfExists: ['preventOverflow'],
  fn: hide
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   arrow: () => (/* reexport safe */ _arrow_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   computeStyles: () => (/* reexport safe */ _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   flip: () => (/* reexport safe */ _flip_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   hide: () => (/* reexport safe */ _hide_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   offset: () => (/* reexport safe */ _offset_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"])
/* harmony export */ });
/* harmony import */ var _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _arrow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _hide_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _offset_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");










/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/offset.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/offset.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   distanceAndSkiddingToXY: () => (/* binding */ distanceAndSkiddingToXY)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");

 // eslint-disable-next-line import/no-unused-modules

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  var invertDistance = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = _enums_js__WEBPACK_IMPORTED_MODULE_1__.placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");


function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = (0,_utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getAltAxis.js */ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");












function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state.placement);
  var variation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement);
  var altAxis = (0,_utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__["default"])(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
    mainAxis: tetherOffsetValue,
    altAxis: tetherOffsetValue
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, tetherOffsetValue);
  var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;
    var altSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min = offset + overflow[mainSide];
    var max = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : (0,_utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__["default"])();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent = state.elements.arrow && (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__["default"])(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.min)(min, tetherMin) : min, offset, tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.max)(max, tetherMax) : max);
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;

    var _altSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === 'y' ? 'height' : 'width';

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.top, _enums_js__WEBPACK_IMPORTED_MODULE_5__.left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

    var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

    var _preventedOffset = tether && isOriginSide ? (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.withinMaxClamp)(_tetherMin, _offset, _tetherMax) : (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper-lite.js":
/*!********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper-lite.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");





var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper.js":
/*!***************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.applyStyles),
/* harmony export */   arrow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.arrow),
/* harmony export */   computeStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.computeStyles),
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   createPopperLite: () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__.createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.eventListeners),
/* harmony export */   flip: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.flip),
/* harmony export */   hide: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.hide),
/* harmony export */   offset: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.offset),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.popperOffsets),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.preventOverflow)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modifiers/offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./modifiers/flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modifiers/preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");
/* harmony import */ var _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./modifiers/arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./modifiers/hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./popper-lite.js */ "./node_modules/@popperjs/core/lib/popper-lite.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modifiers/index.js */ "./node_modules/@popperjs/core/lib/modifiers/index.js");










var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"], _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__["default"], _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__["default"], _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"], _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__["default"], _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeAutoPlacement)
/* harmony export */ });
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");




function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.placements : _options$allowedAutoP;
  var variation = (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement);
  var placements = variation ? flipVariations ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements : _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements.filter(function (placement) {
    return (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) === variation;
  }) : _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements;
  var allowedPlacements = placements.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements;
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = (0,_detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[(0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeOffsets.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeOffsets)
/* harmony export */ });
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");




function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? (0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) : null;
  var variation = placement ? (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? (0,_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;

      default:
    }
  }

  return offsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/debounce.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/debounce.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ debounce)
/* harmony export */ });
function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/detectOverflow.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ detectOverflow)
/* harmony export */ });
/* harmony import */ var _dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getClippingRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");
/* harmony import */ var _rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");








 // eslint-disable-next-line import/no-unused-modules

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$strategy = _options.strategy,
      strategy = _options$strategy === void 0 ? state.strategy : _options$strategy,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = (0,_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__["default"])(typeof padding !== 'number' ? padding : (0,_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements));
  var altContext = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.reference : _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = (0,_dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])((0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(element) ? element : element.contextElement || (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.elements.popper), boundary, rootBoundary, strategy);
  var referenceClientRect = (0,_dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.elements.reference);
  var popperOffsets = (0,_computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"])({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = (0,_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__["default"])(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/expandToHashMap.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ expandToHashMap)
/* harmony export */ });
function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getAltAxis.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getAltAxis)
/* harmony export */ });
function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getBasePlacement.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBasePlacement)
/* harmony export */ });

function getBasePlacement(placement) {
  return placement.split('-')[0];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFreshSideObject)
/* harmony export */ });
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMainAxisFromPlacement)
/* harmony export */ });
function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositePlacement)
/* harmony export */ });
var hash = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositeVariationPlacement)
/* harmony export */ });
var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getVariation.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getVariation.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getVariation)
/* harmony export */ });
function getVariation(placement) {
  return placement.split('-')[1];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/math.js":
/*!*******************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/math.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   round: () => (/* binding */ round)
/* harmony export */ });
var max = Math.max;
var min = Math.min;
var round = Math.round;

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergeByName.js":
/*!**************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergeByName.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeByName)
/* harmony export */ });
function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergePaddingObject)
/* harmony export */ });
/* harmony import */ var _getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");

function mergePaddingObject(paddingObject) {
  return Object.assign({}, (0,_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(), paddingObject);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/orderModifiers.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderModifiers)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
 // source: https://stackoverflow.com/questions/49875255

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/rectToClientRect.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rectToClientRect)
/* harmony export */ });
function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/userAgent.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/userAgent.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getUAString)
/* harmony export */ });
function getUAString() {
  var uaData = navigator.userAgentData;

  if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
    return uaData.brands.map(function (item) {
      return item.brand + "/" + item.version;
    }).join(' ');
  }

  return navigator.userAgent;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/within.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/within.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   within: () => (/* binding */ within),
/* harmony export */   withinMaxClamp: () => (/* binding */ withinMaxClamp)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");

function within(min, value, max) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.max)(min, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.min)(value, max));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

/***/ }),

/***/ "./node_modules/axe-core/axe.js":
/*!**************************************!*\
  !*** ./node_modules/axe-core/axe.js ***!
  \**************************************/
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;var __WEBPACK_AMD_DEFINE_RESULT__;var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! axe v4.8.2
 * Copyright (c) 2015 - 2023 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
(function axeFunction(window) {
  var global = window;
  var document = window.document;
  'use strict';
  function _typeof(obj) {
    '@babel/helpers - typeof';
    return _typeof = 'function' == typeof Symbol && 'symbol' == typeof Symbol.iterator ? function(obj) {
      return typeof obj;
    } : function(obj) {
      return obj && 'function' == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : typeof obj;
    }, _typeof(obj);
  }
  var axe = axe || {};
  axe.version = '4.8.2';
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return axe;
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  }
  if (( false ? 0 : _typeof(module)) === 'object' && module.exports && typeof axeFunction.toString === 'function') {
    axe.source = '(' + axeFunction.toString() + ')(typeof window === "object" ? window : this);';
    module.exports = axe;
  }
  if (typeof window.getComputedStyle === 'function') {
    window.axe = axe;
  }
  var commons;
  function SupportError(error) {
    this.name = 'SupportError';
    this.cause = error.cause;
    this.message = '`'.concat(error.cause, '` - feature unsupported in your environment.');
    if (error.ruleId) {
      this.ruleId = error.ruleId;
      this.message += ' Skipping '.concat(this.ruleId, ' rule.');
    }
    this.stack = new Error().stack;
  }
  SupportError.prototype = Object.create(Error.prototype);
  SupportError.prototype.constructor = SupportError;
  'use strict';
  var _excluded = [ 'node' ], _excluded2 = [ 'relatedNodes' ], _excluded3 = [ 'node' ], _excluded4 = [ 'variant' ], _excluded5 = [ 'matches' ], _excluded6 = [ 'chromium' ], _excluded7 = [ 'noImplicit' ], _excluded8 = [ 'noPresentational' ], _excluded9 = [ 'precision', 'format', 'inGamut' ], _excluded10 = [ 'space' ], _excluded11 = [ 'algorithm' ], _excluded12 = [ 'method' ], _excluded13 = [ 'maxDeltaE', 'deltaEMethod', 'steps', 'maxSteps' ], _excluded14 = [ 'node' ], _excluded15 = [ 'environmentData' ], _excluded16 = [ 'environmentData' ], _excluded17 = [ 'environmentData' ], _excluded18 = [ 'environmentData' ], _excluded19 = [ 'environmentData' ];
  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
  }
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct.bind();
    } else {
      _construct = function _construct(Parent, args, Class) {
        var a = [ null ];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) {
          _setPrototypeOf(instance, Class.prototype);
        }
        return instance;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
      throw new TypeError('Super expression must either be null or a function');
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    Object.defineProperty(subClass, 'prototype', {
      writable: false
    });
    if (superClass) {
      _setPrototypeOf(subClass, superClass);
    }
  }
  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }
  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError('Derived constructors may only return object or undefined');
    }
    return _assertThisInitialized(self);
  }
  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError('this hasn\'t been initialised - super() hasn\'t been called');
    }
    return self;
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === 'undefined' || !Reflect.construct) {
      return false;
    }
    if (Reflect.construct.sham) {
      return false;
    }
    if (typeof Proxy === 'function') {
      return true;
    }
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }
  function _classPrivateFieldInitSpec(obj, privateMap, value) {
    _checkPrivateRedeclaration(obj, privateMap);
    privateMap.set(obj, value);
  }
  function _classPrivateMethodInitSpec(obj, privateSet) {
    _checkPrivateRedeclaration(obj, privateSet);
    privateSet.add(obj);
  }
  function _checkPrivateRedeclaration(obj, privateCollection) {
    if (privateCollection.has(obj)) {
      throw new TypeError('Cannot initialize the same private elements twice on an object');
    }
  }
  function _classPrivateFieldGet(receiver, privateMap) {
    var descriptor = _classExtractFieldDescriptor(receiver, privateMap, 'get');
    return _classApplyDescriptorGet(receiver, descriptor);
  }
  function _classApplyDescriptorGet(receiver, descriptor) {
    if (descriptor.get) {
      return descriptor.get.call(receiver);
    }
    return descriptor.value;
  }
  function _classPrivateMethodGet(receiver, privateSet, fn) {
    if (!privateSet.has(receiver)) {
      throw new TypeError('attempted to get private field on non-instance');
    }
    return fn;
  }
  function _classPrivateFieldSet(receiver, privateMap, value) {
    var descriptor = _classExtractFieldDescriptor(receiver, privateMap, 'set');
    _classApplyDescriptorSet(receiver, descriptor, value);
    return value;
  }
  function _classExtractFieldDescriptor(receiver, privateMap, action) {
    if (!privateMap.has(receiver)) {
      throw new TypeError('attempted to ' + action + ' private field on non-instance');
    }
    return privateMap.get(receiver);
  }
  function _classApplyDescriptorSet(receiver, descriptor, value) {
    if (descriptor.set) {
      descriptor.set.call(receiver, value);
    } else {
      if (!descriptor.writable) {
        throw new TypeError('attempted to set read only private field');
      }
      descriptor.value = value;
    }
  }
  function _objectWithoutProperties(source, excluded) {
    if (source == null) {
      return {};
    }
    var target = _objectWithoutPropertiesLoose(source, excluded);
    var key, i;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) {
          continue;
        }
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) {
          continue;
        }
        target[key] = source[key];
      }
    }
    return target;
  }
  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) {
      return {};
    }
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) {
        continue;
      }
      target[key] = source[key];
    }
    return target;
  }
  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }
  function _nonIterableSpread() {
    throw new TypeError('Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.');
  }
  function _iterableToArray(iter) {
    if (typeof Symbol !== 'undefined' && iter[Symbol.iterator] != null || iter['@@iterator'] != null) {
      return Array.from(iter);
    }
  }
  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      return _arrayLikeToArray(arr);
    }
  }
  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }
  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }
  function _nonIterableRest() {
    throw new TypeError('Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.');
  }
  function _iterableToArrayLimit(arr, i) {
    var _i = null == arr ? null : 'undefined' != typeof Symbol && arr[Symbol.iterator] || arr['@@iterator'];
    if (null != _i) {
      var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1;
      try {
        if (_x = (_i = _i.call(arr)).next, 0 === i) {
          if (Object(_i) !== _i) {
            return;
          }
          _n = !1;
        } else {
          for (;!(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0) {
          }
        }
      } catch (err) {
        _d = !0, _e = err;
      } finally {
        try {
          if (!_n && null != _i['return'] && (_r = _i['return'](), Object(_r) !== _r)) {
            return;
          }
        } finally {
          if (_d) {
            throw _e;
          }
        }
      }
      return _arr;
    }
  }
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) {
      return arr;
    }
  }
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError('Cannot call a class as a function');
    }
  }
  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ('value' in descriptor) {
        descriptor.writable = true;
      }
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) {
      _defineProperties(Constructor.prototype, protoProps);
    }
    if (staticProps) {
      _defineProperties(Constructor, staticProps);
    }
    Object.defineProperty(Constructor, 'prototype', {
      writable: false
    });
    return Constructor;
  }
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, 'string');
    return _typeof(key) === 'symbol' ? key : String(key);
  }
  function _toPrimitive(input, hint) {
    if (_typeof(input) !== 'object' || input === null) {
      return input;
    }
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || 'default');
      if (_typeof(res) !== 'object') {
        return res;
      }
      throw new TypeError('@@toPrimitive must return a primitive value.');
    }
    return (hint === 'string' ? String : Number)(input);
  }
  function _createForOfIteratorHelper(o, allowArrayLike) {
    var it = typeof Symbol !== 'undefined' && o[Symbol.iterator] || o['@@iterator'];
    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === 'number') {
        if (it) {
          o = it;
        }
        var i = 0;
        var F = function F() {};
        return {
          s: F,
          n: function n() {
            if (i >= o.length) {
              return {
                done: true
              };
            }
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function e(_e2) {
            throw _e2;
          },
          f: F
        };
      }
      throw new TypeError('Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.');
    }
    var normalCompletion = true, didErr = false, err;
    return {
      s: function s() {
        it = it.call(o);
      },
      n: function n() {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function e(_e3) {
        didErr = true;
        err = _e3;
      },
      f: function f() {
        try {
          if (!normalCompletion && it['return'] != null) {
            it['return']();
          }
        } finally {
          if (didErr) {
            throw err;
          }
        }
      }
    };
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) {
      return;
    }
    if (typeof o === 'string') {
      return _arrayLikeToArray(o, minLen);
    }
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === 'Object' && o.constructor) {
      n = o.constructor.name;
    }
    if (n === 'Map' || n === 'Set') {
      return Array.from(o);
    }
    if (n === 'Arguments' || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
      return _arrayLikeToArray(o, minLen);
    }
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) {
      len = arr.length;
    }
    for (var i = 0, arr2 = new Array(len); i < len; i++) {
      arr2[i] = arr[i];
    }
    return arr2;
  }
  function _typeof(obj) {
    '@babel/helpers - typeof';
    return _typeof = 'function' == typeof Symbol && 'symbol' == typeof Symbol.iterator ? function(obj) {
      return typeof obj;
    } : function(obj) {
      return obj && 'function' == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : typeof obj;
    }, _typeof(obj);
  }
  (function() {
    var _processFormat, _path, _getPath, _space;
    var __create = Object.create;
    var __defProp = Object.defineProperty;
    var __getProtoOf = Object.getPrototypeOf;
    var __hasOwnProp = Object.prototype.hasOwnProperty;
    var __getOwnPropNames = Object.getOwnPropertyNames;
    var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
    var __defNormalProp = function __defNormalProp(obj, key, value) {
      return key in obj ? __defProp(obj, key, {
        enumerable: true,
        configurable: true,
        writable: true,
        value: value
      }) : obj[key] = value;
    };
    var __markAsModule = function __markAsModule(target) {
      return __defProp(target, '__esModule', {
        value: true
      });
    };
    var __commonJS = function __commonJS(cb, mod) {
      return function() {
        return mod || cb((mod = {
          exports: {}
        }).exports, mod), mod.exports;
      };
    };
    var __export = function __export(target, all) {
      for (var name in all) {
        __defProp(target, name, {
          get: all[name],
          enumerable: true
        });
      }
    };
    var __exportStar = function __exportStar(target, module, desc) {
      if (module && _typeof(module) === 'object' || typeof module === 'function') {
        var _iterator = _createForOfIteratorHelper(__getOwnPropNames(module)), _step;
        try {
          var _loop = function _loop() {
            var key = _step.value;
            if (!__hasOwnProp.call(target, key) && key !== 'default') {
              __defProp(target, key, {
                get: function get() {
                  return module[key];
                },
                enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable
              });
            }
          };
          for (_iterator.s(); !(_step = _iterator.n()).done; ) {
            _loop();
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      return target;
    };
    var __toModule = function __toModule(module) {
      return __exportStar(__markAsModule(__defProp(module != null ? __create(__getProtoOf(module)) : {}, 'default', module && module.__esModule && 'default' in module ? {
        get: function get() {
          return module['default'];
        },
        enumerable: true
      } : {
        value: module,
        enumerable: true
      })), module);
    };
    var __publicField = function __publicField(obj, key, value) {
      __defNormalProp(obj, _typeof(key) !== 'symbol' ? key + '' : key, value);
      return value;
    };
    var require_noop = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {};
    });
    var require_is_value = __commonJS(function(exports, module) {
      'use strict';
      var _undefined = require_noop()();
      module.exports = function(val) {
        return val !== _undefined && val !== null;
      };
    });
    var require_normalize_options = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is_value();
      var forEach = Array.prototype.forEach;
      var create = Object.create;
      var process2 = function process2(src, obj) {
        var key;
        for (key in src) {
          obj[key] = src[key];
        }
      };
      module.exports = function(opts1) {
        var result = create(null);
        forEach.call(arguments, function(options) {
          if (!isValue(options)) {
            return;
          }
          process2(Object(options), result);
        });
        return result;
      };
    });
    var require_is_implemented = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        var sign = Math.sign;
        if (typeof sign !== 'function') {
          return false;
        }
        return sign(10) === 1 && sign(-20) === -1;
      };
    });
    var require_shim = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(value) {
        value = Number(value);
        if (isNaN(value) || value === 0) {
          return value;
        }
        return value > 0 ? 1 : -1;
      };
    });
    var require_sign = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented()() ? Math.sign : require_shim();
    });
    var require_to_integer = __commonJS(function(exports, module) {
      'use strict';
      var sign = require_sign();
      var abs = Math.abs;
      var floor = Math.floor;
      module.exports = function(value) {
        if (isNaN(value)) {
          return 0;
        }
        value = Number(value);
        if (value === 0 || !isFinite(value)) {
          return value;
        }
        return sign(value) * floor(abs(value));
      };
    });
    var require_to_pos_integer = __commonJS(function(exports, module) {
      'use strict';
      var toInteger = require_to_integer();
      var max2 = Math.max;
      module.exports = function(value) {
        return max2(0, toInteger(value));
      };
    });
    var require_resolve_length = __commonJS(function(exports, module) {
      'use strict';
      var toPosInt = require_to_pos_integer();
      module.exports = function(optsLength, fnLength, isAsync) {
        var length;
        if (isNaN(optsLength)) {
          length = fnLength;
          if (!(length >= 0)) {
            return 1;
          }
          if (isAsync && length) {
            return length - 1;
          }
          return length;
        }
        if (optsLength === false) {
          return false;
        }
        return toPosInt(optsLength);
      };
    });
    var require_valid_callable = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(fn) {
        if (typeof fn !== 'function') {
          throw new TypeError(fn + ' is not a function');
        }
        return fn;
      };
    });
    var require_valid_value = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is_value();
      module.exports = function(value) {
        if (!isValue(value)) {
          throw new TypeError('Cannot use null or undefined');
        }
        return value;
      };
    });
    var require_iterate = __commonJS(function(exports, module) {
      'use strict';
      var callable = require_valid_callable();
      var value = require_valid_value();
      var bind = Function.prototype.bind;
      var call = Function.prototype.call;
      var keys = Object.keys;
      var objPropertyIsEnumerable = Object.prototype.propertyIsEnumerable;
      module.exports = function(method, defVal) {
        return function(obj, cb) {
          var list, thisArg = arguments[2], compareFn = arguments[3];
          obj = Object(value(obj));
          callable(cb);
          list = keys(obj);
          if (compareFn) {
            list.sort(typeof compareFn === 'function' ? bind.call(compareFn, obj) : void 0);
          }
          if (typeof method !== 'function') {
            method = list[method];
          }
          return call.call(method, list, function(key, index) {
            if (!objPropertyIsEnumerable.call(obj, key)) {
              return defVal;
            }
            return call.call(cb, thisArg, obj[key], key, obj, index);
          });
        };
      };
    });
    var require_for_each = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_iterate()('forEach');
    });
    var require_registered_extensions = __commonJS(function() {
      'use strict';
    });
    var require_is_implemented2 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        var assign = Object.assign, obj;
        if (typeof assign !== 'function') {
          return false;
        }
        obj = {
          foo: 'raz'
        };
        assign(obj, {
          bar: 'dwa'
        }, {
          trzy: 'trzy'
        });
        return obj.foo + obj.bar + obj.trzy === 'razdwatrzy';
      };
    });
    var require_is_implemented3 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        try {
          Object.keys('primitive');
          return true;
        } catch (e) {
          return false;
        }
      };
    });
    var require_shim2 = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is_value();
      var keys = Object.keys;
      module.exports = function(object) {
        return keys(isValue(object) ? Object(object) : object);
      };
    });
    var require_keys = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented3()() ? Object.keys : require_shim2();
    });
    var require_shim3 = __commonJS(function(exports, module) {
      'use strict';
      var keys = require_keys();
      var value = require_valid_value();
      var max2 = Math.max;
      module.exports = function(dest, src) {
        var error, i, length = max2(arguments.length, 2), assign;
        dest = Object(value(dest));
        assign = function assign(key) {
          try {
            dest[key] = src[key];
          } catch (e) {
            if (!error) {
              error = e;
            }
          }
        };
        for (i = 1; i < length; ++i) {
          src = arguments[i];
          keys(src).forEach(assign);
        }
        if (error !== void 0) {
          throw error;
        }
        return dest;
      };
    });
    var require_assign = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented2()() ? Object.assign : require_shim3();
    });
    var require_is_object = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is_value();
      var map = {
        function: true,
        object: true
      };
      module.exports = function(value) {
        return isValue(value) && map[_typeof(value)] || false;
      };
    });
    var require_custom = __commonJS(function(exports, module) {
      'use strict';
      var assign = require_assign();
      var isObject = require_is_object();
      var isValue = require_is_value();
      var captureStackTrace = Error.captureStackTrace;
      module.exports = function(message) {
        var err2 = new Error(message), code = arguments[1], ext = arguments[2];
        if (!isValue(ext)) {
          if (isObject(code)) {
            ext = code;
            code = null;
          }
        }
        if (isValue(ext)) {
          assign(err2, ext);
        }
        if (isValue(code)) {
          err2.code = code;
        }
        if (captureStackTrace) {
          captureStackTrace(err2, module.exports);
        }
        return err2;
      };
    });
    var require_mixin = __commonJS(function(exports, module) {
      'use strict';
      var value = require_valid_value();
      var defineProperty = Object.defineProperty;
      var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
      var getOwnPropertyNames = Object.getOwnPropertyNames;
      var getOwnPropertySymbols = Object.getOwnPropertySymbols;
      module.exports = function(target, source) {
        var error, sourceObject = Object(value(source));
        target = Object(value(target));
        getOwnPropertyNames(sourceObject).forEach(function(name) {
          try {
            defineProperty(target, name, getOwnPropertyDescriptor(source, name));
          } catch (e) {
            error = e;
          }
        });
        if (typeof getOwnPropertySymbols === 'function') {
          getOwnPropertySymbols(sourceObject).forEach(function(symbol) {
            try {
              defineProperty(target, symbol, getOwnPropertyDescriptor(source, symbol));
            } catch (e) {
              error = e;
            }
          });
        }
        if (error !== void 0) {
          throw error;
        }
        return target;
      };
    });
    var require_define_length = __commonJS(function(exports, module) {
      'use strict';
      var toPosInt = require_to_pos_integer();
      var test = function test(arg1, arg2) {
        return arg2;
      };
      var desc;
      var defineProperty;
      var generate;
      var mixin;
      try {
        Object.defineProperty(test, 'length', {
          configurable: true,
          writable: false,
          enumerable: false,
          value: 1
        });
      } catch (ignore) {}
      if (test.length === 1) {
        desc = {
          configurable: true,
          writable: false,
          enumerable: false
        };
        defineProperty = Object.defineProperty;
        module.exports = function(fn, length) {
          length = toPosInt(length);
          if (fn.length === length) {
            return fn;
          }
          desc.value = length;
          return defineProperty(fn, 'length', desc);
        };
      } else {
        mixin = require_mixin();
        generate = function() {
          var cache2 = [];
          return function(length) {
            var args, i = 0;
            if (cache2[length]) {
              return cache2[length];
            }
            args = [];
            while (length--) {
              args.push('a' + (++i).toString(36));
            }
            return new Function('fn', 'return function (' + args.join(', ') + ') { return fn.apply(this, arguments); };');
          };
        }();
        module.exports = function(src, length) {
          var target;
          length = toPosInt(length);
          if (src.length === length) {
            return src;
          }
          target = generate(length)(src);
          try {
            mixin(target, src);
          } catch (ignore) {}
          return target;
        };
      }
    });
    var require_is = __commonJS(function(exports, module) {
      'use strict';
      var _undefined = void 0;
      module.exports = function(value) {
        return value !== _undefined && value !== null;
      };
    });
    var require_is2 = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is();
      var possibleTypes = {
        object: true,
        function: true,
        undefined: true
      };
      module.exports = function(value) {
        if (!isValue(value)) {
          return false;
        }
        return hasOwnProperty.call(possibleTypes, _typeof(value));
      };
    });
    var require_is3 = __commonJS(function(exports, module) {
      'use strict';
      var isObject = require_is2();
      module.exports = function(value) {
        if (!isObject(value)) {
          return false;
        }
        try {
          if (!value.constructor) {
            return false;
          }
          return value.constructor.prototype === value;
        } catch (error) {
          return false;
        }
      };
    });
    var require_is4 = __commonJS(function(exports, module) {
      'use strict';
      var isPrototype = require_is3();
      module.exports = function(value) {
        if (typeof value !== 'function') {
          return false;
        }
        if (!hasOwnProperty.call(value, 'length')) {
          return false;
        }
        try {
          if (typeof value.length !== 'number') {
            return false;
          }
          if (typeof value.call !== 'function') {
            return false;
          }
          if (typeof value.apply !== 'function') {
            return false;
          }
        } catch (error) {
          return false;
        }
        return !isPrototype(value);
      };
    });
    var require_is5 = __commonJS(function(exports, module) {
      'use strict';
      var isFunction = require_is4();
      var classRe = /^\s*class[\s{/}]/;
      var functionToString = Function.prototype.toString;
      module.exports = function(value) {
        if (!isFunction(value)) {
          return false;
        }
        if (classRe.test(functionToString.call(value))) {
          return false;
        }
        return true;
      };
    });
    var require_is_implemented4 = __commonJS(function(exports, module) {
      'use strict';
      var str = 'razdwatrzy';
      module.exports = function() {
        if (typeof str.contains !== 'function') {
          return false;
        }
        return str.contains('dwa') === true && str.contains('foo') === false;
      };
    });
    var require_shim4 = __commonJS(function(exports, module) {
      'use strict';
      var indexOf = String.prototype.indexOf;
      module.exports = function(searchString) {
        return indexOf.call(this, searchString, arguments[1]) > -1;
      };
    });
    var require_contains = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented4()() ? String.prototype.contains : require_shim4();
    });
    var require_d = __commonJS(function(exports, module) {
      'use strict';
      var isValue = require_is();
      var isPlainFunction = require_is5();
      var assign = require_assign();
      var normalizeOpts = require_normalize_options();
      var contains3 = require_contains();
      var d2 = module.exports = function(dscr, value) {
        var c4, e, w, options, desc;
        if (arguments.length < 2 || typeof dscr !== 'string') {
          options = value;
          value = dscr;
          dscr = null;
        } else {
          options = arguments[2];
        }
        if (isValue(dscr)) {
          c4 = contains3.call(dscr, 'c');
          e = contains3.call(dscr, 'e');
          w = contains3.call(dscr, 'w');
        } else {
          c4 = w = true;
          e = false;
        }
        desc = {
          value: value,
          configurable: c4,
          enumerable: e,
          writable: w
        };
        return !options ? desc : assign(normalizeOpts(options), desc);
      };
      d2.gs = function(dscr, get2, set2) {
        var c4, e, options, desc;
        if (typeof dscr !== 'string') {
          options = set2;
          set2 = get2;
          get2 = dscr;
          dscr = null;
        } else {
          options = arguments[3];
        }
        if (!isValue(get2)) {
          get2 = void 0;
        } else if (!isPlainFunction(get2)) {
          options = get2;
          get2 = set2 = void 0;
        } else if (!isValue(set2)) {
          set2 = void 0;
        } else if (!isPlainFunction(set2)) {
          options = set2;
          set2 = void 0;
        }
        if (isValue(dscr)) {
          c4 = contains3.call(dscr, 'c');
          e = contains3.call(dscr, 'e');
        } else {
          c4 = true;
          e = false;
        }
        desc = {
          get: get2,
          set: set2,
          configurable: c4,
          enumerable: e
        };
        return !options ? desc : assign(normalizeOpts(options), desc);
      };
    });
    var require_event_emitter = __commonJS(function(exports, module) {
      'use strict';
      var d2 = require_d();
      var callable = require_valid_callable();
      var apply = Function.prototype.apply;
      var call = Function.prototype.call;
      var create = Object.create;
      var defineProperty = Object.defineProperty;
      var defineProperties = Object.defineProperties;
      var hasOwnProperty2 = Object.prototype.hasOwnProperty;
      var descriptor = {
        configurable: true,
        enumerable: false,
        writable: true
      };
      var on;
      var once;
      var off;
      var emit;
      var methods;
      var descriptors;
      var base;
      on = function on(type2, listener) {
        var data;
        callable(listener);
        if (!hasOwnProperty2.call(this, '__ee__')) {
          data = descriptor.value = create(null);
          defineProperty(this, '__ee__', descriptor);
          descriptor.value = null;
        } else {
          data = this.__ee__;
        }
        if (!data[type2]) {
          data[type2] = listener;
        } else if (_typeof(data[type2]) === 'object') {
          data[type2].push(listener);
        } else {
          data[type2] = [ data[type2], listener ];
        }
        return this;
      };
      once = function once(type2, listener) {
        var _once, self2;
        callable(listener);
        self2 = this;
        on.call(this, type2, _once = function once2() {
          off.call(self2, type2, _once);
          apply.call(listener, this, arguments);
        });
        _once.__eeOnceListener__ = listener;
        return this;
      };
      off = function off(type2, listener) {
        var data, listeners, candidate, i;
        callable(listener);
        if (!hasOwnProperty2.call(this, '__ee__')) {
          return this;
        }
        data = this.__ee__;
        if (!data[type2]) {
          return this;
        }
        listeners = data[type2];
        if (_typeof(listeners) === 'object') {
          for (i = 0; candidate = listeners[i]; ++i) {
            if (candidate === listener || candidate.__eeOnceListener__ === listener) {
              if (listeners.length === 2) {
                data[type2] = listeners[i ? 0 : 1];
              } else {
                listeners.splice(i, 1);
              }
            }
          }
        } else {
          if (listeners === listener || listeners.__eeOnceListener__ === listener) {
            delete data[type2];
          }
        }
        return this;
      };
      emit = function emit(type2) {
        var i, l, listener, listeners, args;
        if (!hasOwnProperty2.call(this, '__ee__')) {
          return;
        }
        listeners = this.__ee__[type2];
        if (!listeners) {
          return;
        }
        if (_typeof(listeners) === 'object') {
          l = arguments.length;
          args = new Array(l - 1);
          for (i = 1; i < l; ++i) {
            args[i - 1] = arguments[i];
          }
          listeners = listeners.slice();
          for (i = 0; listener = listeners[i]; ++i) {
            apply.call(listener, this, args);
          }
        } else {
          switch (arguments.length) {
           case 1:
            call.call(listeners, this);
            break;

           case 2:
            call.call(listeners, this, arguments[1]);
            break;

           case 3:
            call.call(listeners, this, arguments[1], arguments[2]);
            break;

           default:
            l = arguments.length;
            args = new Array(l - 1);
            for (i = 1; i < l; ++i) {
              args[i - 1] = arguments[i];
            }
            apply.call(listeners, this, args);
          }
        }
      };
      methods = {
        on: on,
        once: once,
        off: off,
        emit: emit
      };
      descriptors = {
        on: d2(on),
        once: d2(once),
        off: d2(off),
        emit: d2(emit)
      };
      base = defineProperties({}, descriptors);
      module.exports = exports = function exports(o) {
        return o == null ? create(base) : defineProperties(Object(o), descriptors);
      };
      exports.methods = methods;
    });
    var require_is_implemented5 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        var from = Array.from, arr, result;
        if (typeof from !== 'function') {
          return false;
        }
        arr = [ 'raz', 'dwa' ];
        result = from(arr);
        return Boolean(result && result !== arr && result[1] === 'dwa');
      };
    });
    var require_is_implemented6 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        if ((typeof globalThis === 'undefined' ? 'undefined' : _typeof(globalThis)) !== 'object') {
          return false;
        }
        if (!globalThis) {
          return false;
        }
        return globalThis.Array === Array;
      };
    });
    var require_implementation = __commonJS(function(exports, module) {
      var naiveFallback = function naiveFallback() {
        if ((typeof self === 'undefined' ? 'undefined' : _typeof(self)) === 'object' && self) {
          return self;
        }
        if ((typeof window === 'undefined' ? 'undefined' : _typeof(window)) === 'object' && window) {
          return window;
        }
        throw new Error('Unable to resolve global `this`');
      };
      module.exports = function() {
        if (this) {
          return this;
        }
        try {
          Object.defineProperty(Object.prototype, '__global__', {
            get: function get() {
              return this;
            },
            configurable: true
          });
        } catch (error) {
          return naiveFallback();
        }
        try {
          if (!__global__) {
            return naiveFallback();
          }
          return __global__;
        } finally {
          delete Object.prototype.__global__;
        }
      }();
    });
    var require_global_this = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented6()() ? globalThis : require_implementation();
    });
    var require_is_implemented7 = __commonJS(function(exports, module) {
      'use strict';
      var global2 = require_global_this();
      var validTypes = {
        object: true,
        symbol: true
      };
      module.exports = function() {
        var Symbol2 = global2.Symbol;
        var symbol;
        if (typeof Symbol2 !== 'function') {
          return false;
        }
        symbol = Symbol2('test symbol');
        try {
          String(symbol);
        } catch (e) {
          return false;
        }
        if (!validTypes[_typeof(Symbol2.iterator)]) {
          return false;
        }
        if (!validTypes[_typeof(Symbol2.toPrimitive)]) {
          return false;
        }
        if (!validTypes[_typeof(Symbol2.toStringTag)]) {
          return false;
        }
        return true;
      };
    });
    var require_is_symbol = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(value) {
        if (!value) {
          return false;
        }
        if (_typeof(value) === 'symbol') {
          return true;
        }
        if (!value.constructor) {
          return false;
        }
        if (value.constructor.name !== 'Symbol') {
          return false;
        }
        return value[value.constructor.toStringTag] === 'Symbol';
      };
    });
    var require_validate_symbol = __commonJS(function(exports, module) {
      'use strict';
      var isSymbol = require_is_symbol();
      module.exports = function(value) {
        if (!isSymbol(value)) {
          throw new TypeError(value + ' is not a symbol');
        }
        return value;
      };
    });
    var require_generate_name = __commonJS(function(exports, module) {
      'use strict';
      var d2 = require_d();
      var create = Object.create;
      var defineProperty = Object.defineProperty;
      var objPrototype = Object.prototype;
      var created = create(null);
      module.exports = function(desc) {
        var postfix = 0, name, ie11BugWorkaround;
        while (created[desc + (postfix || '')]) {
          ++postfix;
        }
        desc += postfix || '';
        created[desc] = true;
        name = '@@' + desc;
        defineProperty(objPrototype, name, d2.gs(null, function(value) {
          if (ie11BugWorkaround) {
            return;
          }
          ie11BugWorkaround = true;
          defineProperty(this, name, d2(value));
          ie11BugWorkaround = false;
        }));
        return name;
      };
    });
    var require_standard_symbols = __commonJS(function(exports, module) {
      'use strict';
      var d2 = require_d();
      var NativeSymbol = require_global_this().Symbol;
      module.exports = function(SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
          hasInstance: d2('', NativeSymbol && NativeSymbol.hasInstance || SymbolPolyfill('hasInstance')),
          isConcatSpreadable: d2('', NativeSymbol && NativeSymbol.isConcatSpreadable || SymbolPolyfill('isConcatSpreadable')),
          iterator: d2('', NativeSymbol && NativeSymbol.iterator || SymbolPolyfill('iterator')),
          match: d2('', NativeSymbol && NativeSymbol.match || SymbolPolyfill('match')),
          replace: d2('', NativeSymbol && NativeSymbol.replace || SymbolPolyfill('replace')),
          search: d2('', NativeSymbol && NativeSymbol.search || SymbolPolyfill('search')),
          species: d2('', NativeSymbol && NativeSymbol.species || SymbolPolyfill('species')),
          split: d2('', NativeSymbol && NativeSymbol.split || SymbolPolyfill('split')),
          toPrimitive: d2('', NativeSymbol && NativeSymbol.toPrimitive || SymbolPolyfill('toPrimitive')),
          toStringTag: d2('', NativeSymbol && NativeSymbol.toStringTag || SymbolPolyfill('toStringTag')),
          unscopables: d2('', NativeSymbol && NativeSymbol.unscopables || SymbolPolyfill('unscopables'))
        });
      };
    });
    var require_symbol_registry = __commonJS(function(exports, module) {
      'use strict';
      var d2 = require_d();
      var validateSymbol = require_validate_symbol();
      var registry = Object.create(null);
      module.exports = function(SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
          for: d2(function(key) {
            if (registry[key]) {
              return registry[key];
            }
            return registry[key] = SymbolPolyfill(String(key));
          }),
          keyFor: d2(function(symbol) {
            var key;
            validateSymbol(symbol);
            for (key in registry) {
              if (registry[key] === symbol) {
                return key;
              }
            }
            return void 0;
          })
        });
      };
    });
    var require_polyfill = __commonJS(function(exports, module) {
      'use strict';
      var d2 = require_d();
      var validateSymbol = require_validate_symbol();
      var NativeSymbol = require_global_this().Symbol;
      var generateName = require_generate_name();
      var setupStandardSymbols = require_standard_symbols();
      var setupSymbolRegistry = require_symbol_registry();
      var create = Object.create;
      var defineProperties = Object.defineProperties;
      var defineProperty = Object.defineProperty;
      var SymbolPolyfill;
      var HiddenSymbol;
      var isNativeSafe;
      if (typeof NativeSymbol === 'function') {
        try {
          String(NativeSymbol());
          isNativeSafe = true;
        } catch (ignore) {}
      } else {
        NativeSymbol = null;
      }
      HiddenSymbol = function Symbol2(description) {
        if (this instanceof HiddenSymbol) {
          throw new TypeError('Symbol is not a constructor');
        }
        return SymbolPolyfill(description);
      };
      module.exports = SymbolPolyfill = function Symbol2(description) {
        var symbol;
        if (this instanceof Symbol2) {
          throw new TypeError('Symbol is not a constructor');
        }
        if (isNativeSafe) {
          return NativeSymbol(description);
        }
        symbol = create(HiddenSymbol.prototype);
        description = description === void 0 ? '' : String(description);
        return defineProperties(symbol, {
          __description__: d2('', description),
          __name__: d2('', generateName(description))
        });
      };
      setupStandardSymbols(SymbolPolyfill);
      setupSymbolRegistry(SymbolPolyfill);
      defineProperties(HiddenSymbol.prototype, {
        constructor: d2(SymbolPolyfill),
        toString: d2('', function() {
          return this.__name__;
        })
      });
      defineProperties(SymbolPolyfill.prototype, {
        toString: d2(function() {
          return 'Symbol (' + validateSymbol(this).__description__ + ')';
        }),
        valueOf: d2(function() {
          return validateSymbol(this);
        })
      });
      defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toPrimitive, d2('', function() {
        var symbol = validateSymbol(this);
        if (_typeof(symbol) === 'symbol') {
          return symbol;
        }
        return symbol.toString();
      }));
      defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toStringTag, d2('c', 'Symbol'));
      defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toStringTag, d2('c', SymbolPolyfill.prototype[SymbolPolyfill.toStringTag]));
      defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toPrimitive, d2('c', SymbolPolyfill.prototype[SymbolPolyfill.toPrimitive]));
    });
    var require_es6_symbol = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented7()() ? require_global_this().Symbol : require_polyfill();
    });
    var require_is_arguments = __commonJS(function(exports, module) {
      'use strict';
      var objToString = Object.prototype.toString;
      var id = objToString.call(function() {
        return arguments;
      }());
      module.exports = function(value) {
        return objToString.call(value) === id;
      };
    });
    var require_is_function = __commonJS(function(exports, module) {
      'use strict';
      var objToString = Object.prototype.toString;
      var isFunctionStringTag = RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);
      module.exports = function(value) {
        return typeof value === 'function' && isFunctionStringTag(objToString.call(value));
      };
    });
    var require_is_string = __commonJS(function(exports, module) {
      'use strict';
      var objToString = Object.prototype.toString;
      var id = objToString.call('');
      module.exports = function(value) {
        return typeof value === 'string' || value && _typeof(value) === 'object' && (value instanceof String || objToString.call(value) === id) || false;
      };
    });
    var require_shim5 = __commonJS(function(exports, module) {
      'use strict';
      var iteratorSymbol = require_es6_symbol().iterator;
      var isArguments = require_is_arguments();
      var isFunction = require_is_function();
      var toPosInt = require_to_pos_integer();
      var callable = require_valid_callable();
      var validValue = require_valid_value();
      var isValue = require_is_value();
      var isString2 = require_is_string();
      var isArray = Array.isArray;
      var call = Function.prototype.call;
      var desc = {
        configurable: true,
        enumerable: true,
        writable: true,
        value: null
      };
      var defineProperty = Object.defineProperty;
      module.exports = function(arrayLike) {
        var mapFn = arguments[1], thisArg = arguments[2], Context2, i, j, arr, length, code, iterator, result, getIterator, value;
        arrayLike = Object(validValue(arrayLike));
        if (isValue(mapFn)) {
          callable(mapFn);
        }
        if (!this || this === Array || !isFunction(this)) {
          if (!mapFn) {
            if (isArguments(arrayLike)) {
              length = arrayLike.length;
              if (length !== 1) {
                return Array.apply(null, arrayLike);
              }
              arr = new Array(1);
              arr[0] = arrayLike[0];
              return arr;
            }
            if (isArray(arrayLike)) {
              arr = new Array(length = arrayLike.length);
              for (i = 0; i < length; ++i) {
                arr[i] = arrayLike[i];
              }
              return arr;
            }
          }
          arr = [];
        } else {
          Context2 = this;
        }
        if (!isArray(arrayLike)) {
          if ((getIterator = arrayLike[iteratorSymbol]) !== void 0) {
            iterator = callable(getIterator).call(arrayLike);
            if (Context2) {
              arr = new Context2();
            }
            result = iterator.next();
            i = 0;
            while (!result.done) {
              value = mapFn ? call.call(mapFn, thisArg, result.value, i) : result.value;
              if (Context2) {
                desc.value = value;
                defineProperty(arr, i, desc);
              } else {
                arr[i] = value;
              }
              result = iterator.next();
              ++i;
            }
            length = i;
          } else if (isString2(arrayLike)) {
            length = arrayLike.length;
            if (Context2) {
              arr = new Context2();
            }
            for (i = 0, j = 0; i < length; ++i) {
              value = arrayLike[i];
              if (i + 1 < length) {
                code = value.charCodeAt(0);
                if (code >= 55296 && code <= 56319) {
                  value += arrayLike[++i];
                }
              }
              value = mapFn ? call.call(mapFn, thisArg, value, j) : value;
              if (Context2) {
                desc.value = value;
                defineProperty(arr, j, desc);
              } else {
                arr[j] = value;
              }
              ++j;
            }
            length = j;
          }
        }
        if (length === void 0) {
          length = toPosInt(arrayLike.length);
          if (Context2) {
            arr = new Context2(length);
          }
          for (i = 0; i < length; ++i) {
            value = mapFn ? call.call(mapFn, thisArg, arrayLike[i], i) : arrayLike[i];
            if (Context2) {
              desc.value = value;
              defineProperty(arr, i, desc);
            } else {
              arr[i] = value;
            }
          }
        }
        if (Context2) {
          desc.value = null;
          arr.length = length;
        }
        return arr;
      };
    });
    var require_from = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented5()() ? Array.from : require_shim5();
    });
    var require_to_array = __commonJS(function(exports, module) {
      'use strict';
      var from = require_from();
      var isArray = Array.isArray;
      module.exports = function(arrayLike) {
        return isArray(arrayLike) ? arrayLike : from(arrayLike);
      };
    });
    var require_resolve_resolve = __commonJS(function(exports, module) {
      'use strict';
      var toArray2 = require_to_array();
      var isValue = require_is_value();
      var callable = require_valid_callable();
      var slice = Array.prototype.slice;
      var resolveArgs;
      resolveArgs = function resolveArgs(args) {
        return this.map(function(resolve, i) {
          return resolve ? resolve(args[i]) : args[i];
        }).concat(slice.call(args, this.length));
      };
      module.exports = function(resolvers) {
        resolvers = toArray2(resolvers);
        resolvers.forEach(function(resolve) {
          if (isValue(resolve)) {
            callable(resolve);
          }
        });
        return resolveArgs.bind(resolvers);
      };
    });
    var require_resolve_normalize = __commonJS(function(exports, module) {
      'use strict';
      var callable = require_valid_callable();
      module.exports = function(userNormalizer) {
        var normalizer;
        if (typeof userNormalizer === 'function') {
          return {
            set: userNormalizer,
            get: userNormalizer
          };
        }
        normalizer = {
          get: callable(userNormalizer.get)
        };
        if (userNormalizer.set !== void 0) {
          normalizer.set = callable(userNormalizer.set);
          if (userNormalizer['delete']) {
            normalizer['delete'] = callable(userNormalizer['delete']);
          }
          if (userNormalizer.clear) {
            normalizer.clear = callable(userNormalizer.clear);
          }
          return normalizer;
        }
        normalizer.set = normalizer.get;
        return normalizer;
      };
    });
    var require_configure_map = __commonJS(function(exports, module) {
      'use strict';
      var customError = require_custom();
      var defineLength = require_define_length();
      var d2 = require_d();
      var ee = require_event_emitter().methods;
      var resolveResolve = require_resolve_resolve();
      var resolveNormalize = require_resolve_normalize();
      var apply = Function.prototype.apply;
      var call = Function.prototype.call;
      var create = Object.create;
      var defineProperties = Object.defineProperties;
      var _on = ee.on;
      var emit = ee.emit;
      module.exports = function(original, length, options) {
        var cache2 = create(null), conf, memLength, get2, set2, del, _clear, extDel, extGet, extHas, normalizer, getListeners, setListeners, deleteListeners, memoized, resolve;
        if (length !== false) {
          memLength = length;
        } else if (isNaN(original.length)) {
          memLength = 1;
        } else {
          memLength = original.length;
        }
        if (options.normalizer) {
          normalizer = resolveNormalize(options.normalizer);
          get2 = normalizer.get;
          set2 = normalizer.set;
          del = normalizer['delete'];
          _clear = normalizer.clear;
        }
        if (options.resolvers != null) {
          resolve = resolveResolve(options.resolvers);
        }
        if (get2) {
          memoized = defineLength(function(arg) {
            var id, result, args = arguments;
            if (resolve) {
              args = resolve(args);
            }
            id = get2(args);
            if (id !== null) {
              if (hasOwnProperty.call(cache2, id)) {
                if (getListeners) {
                  conf.emit('get', id, args, this);
                }
                return cache2[id];
              }
            }
            if (args.length === 1) {
              result = call.call(original, this, args[0]);
            } else {
              result = apply.call(original, this, args);
            }
            if (id === null) {
              id = get2(args);
              if (id !== null) {
                throw customError('Circular invocation', 'CIRCULAR_INVOCATION');
              }
              id = set2(args);
            } else if (hasOwnProperty.call(cache2, id)) {
              throw customError('Circular invocation', 'CIRCULAR_INVOCATION');
            }
            cache2[id] = result;
            if (setListeners) {
              conf.emit('set', id, null, result);
            }
            return result;
          }, memLength);
        } else if (length === 0) {
          memoized = function memoized() {
            var result;
            if (hasOwnProperty.call(cache2, 'data')) {
              if (getListeners) {
                conf.emit('get', 'data', arguments, this);
              }
              return cache2.data;
            }
            if (arguments.length) {
              result = apply.call(original, this, arguments);
            } else {
              result = call.call(original, this);
            }
            if (hasOwnProperty.call(cache2, 'data')) {
              throw customError('Circular invocation', 'CIRCULAR_INVOCATION');
            }
            cache2.data = result;
            if (setListeners) {
              conf.emit('set', 'data', null, result);
            }
            return result;
          };
        } else {
          memoized = function memoized(arg) {
            var result, args = arguments, id;
            if (resolve) {
              args = resolve(arguments);
            }
            id = String(args[0]);
            if (hasOwnProperty.call(cache2, id)) {
              if (getListeners) {
                conf.emit('get', id, args, this);
              }
              return cache2[id];
            }
            if (args.length === 1) {
              result = call.call(original, this, args[0]);
            } else {
              result = apply.call(original, this, args);
            }
            if (hasOwnProperty.call(cache2, id)) {
              throw customError('Circular invocation', 'CIRCULAR_INVOCATION');
            }
            cache2[id] = result;
            if (setListeners) {
              conf.emit('set', id, null, result);
            }
            return result;
          };
        }
        conf = {
          original: original,
          memoized: memoized,
          profileName: options.profileName,
          get: function get(args) {
            if (resolve) {
              args = resolve(args);
            }
            if (get2) {
              return get2(args);
            }
            return String(args[0]);
          },
          has: function has(id) {
            return hasOwnProperty.call(cache2, id);
          },
          delete: function _delete(id) {
            var result;
            if (!hasOwnProperty.call(cache2, id)) {
              return;
            }
            if (del) {
              del(id);
            }
            result = cache2[id];
            delete cache2[id];
            if (deleteListeners) {
              conf.emit('delete', id, result);
            }
          },
          clear: function clear() {
            var oldCache = cache2;
            if (_clear) {
              _clear();
            }
            cache2 = create(null);
            conf.emit('clear', oldCache);
          },
          on: function on(type2, listener) {
            if (type2 === 'get') {
              getListeners = true;
            } else if (type2 === 'set') {
              setListeners = true;
            } else if (type2 === 'delete') {
              deleteListeners = true;
            }
            return _on.call(this, type2, listener);
          },
          emit: emit,
          updateEnv: function updateEnv() {
            original = conf.original;
          }
        };
        if (get2) {
          extDel = defineLength(function(arg) {
            var id, args = arguments;
            if (resolve) {
              args = resolve(args);
            }
            id = get2(args);
            if (id === null) {
              return;
            }
            conf['delete'](id);
          }, memLength);
        } else if (length === 0) {
          extDel = function extDel() {
            return conf['delete']('data');
          };
        } else {
          extDel = function extDel(arg) {
            if (resolve) {
              arg = resolve(arguments)[0];
            }
            return conf['delete'](arg);
          };
        }
        extGet = defineLength(function() {
          var id, args = arguments;
          if (length === 0) {
            return cache2.data;
          }
          if (resolve) {
            args = resolve(args);
          }
          if (get2) {
            id = get2(args);
          } else {
            id = String(args[0]);
          }
          return cache2[id];
        });
        extHas = defineLength(function() {
          var id, args = arguments;
          if (length === 0) {
            return conf.has('data');
          }
          if (resolve) {
            args = resolve(args);
          }
          if (get2) {
            id = get2(args);
          } else {
            id = String(args[0]);
          }
          if (id === null) {
            return false;
          }
          return conf.has(id);
        });
        defineProperties(memoized, {
          __memoized__: d2(true),
          delete: d2(extDel),
          clear: d2(conf.clear),
          _get: d2(extGet),
          _has: d2(extHas)
        });
        return conf;
      };
    });
    var require_plain = __commonJS(function(exports, module) {
      'use strict';
      var callable = require_valid_callable();
      var forEach = require_for_each();
      var extensions = require_registered_extensions();
      var configure4 = require_configure_map();
      var resolveLength = require_resolve_length();
      module.exports = function self2(fn) {
        var options, length, conf;
        callable(fn);
        options = Object(arguments[1]);
        if (options.async && options.promise) {
          throw new Error('Options \'async\' and \'promise\' cannot be used together');
        }
        if (hasOwnProperty.call(fn, '__memoized__') && !options.force) {
          return fn;
        }
        length = resolveLength(options.length, fn.length, options.async && extensions.async);
        conf = configure4(fn, length, options);
        forEach(extensions, function(extFn, name) {
          if (options[name]) {
            extFn(options[name], conf, options);
          }
        });
        if (self2.__profiler__) {
          self2.__profiler__(conf);
        }
        conf.updateEnv();
        return conf.memoized;
      };
    });
    var require_primitive = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(args) {
        var id, i, length = args.length;
        if (!length) {
          return '\x02';
        }
        id = String(args[i = 0]);
        while (--length) {
          id += '\x01' + args[++i];
        }
        return id;
      };
    });
    var require_get_primitive_fixed = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(length) {
        if (!length) {
          return function() {
            return '';
          };
        }
        return function(args) {
          var id = String(args[0]), i = 0, currentLength = length;
          while (--currentLength) {
            id += '\x01' + args[++i];
          }
          return id;
        };
      };
    });
    var require_is_implemented8 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function() {
        var numberIsNaN = Number.isNaN;
        if (typeof numberIsNaN !== 'function') {
          return false;
        }
        return !numberIsNaN({}) && numberIsNaN(NaN) && !numberIsNaN(34);
      };
    });
    var require_shim6 = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(value) {
        return value !== value;
      };
    });
    var require_is_nan = __commonJS(function(exports, module) {
      'use strict';
      module.exports = require_is_implemented8()() ? Number.isNaN : require_shim6();
    });
    var require_e_index_of = __commonJS(function(exports, module) {
      'use strict';
      var numberIsNaN = require_is_nan();
      var toPosInt = require_to_pos_integer();
      var value = require_valid_value();
      var indexOf = Array.prototype.indexOf;
      var objHasOwnProperty = Object.prototype.hasOwnProperty;
      var abs = Math.abs;
      var floor = Math.floor;
      module.exports = function(searchElement) {
        var i, length, fromIndex, val;
        if (!numberIsNaN(searchElement)) {
          return indexOf.apply(this, arguments);
        }
        length = toPosInt(value(this).length);
        fromIndex = arguments[1];
        if (isNaN(fromIndex)) {
          fromIndex = 0;
        } else if (fromIndex >= 0) {
          fromIndex = floor(fromIndex);
        } else {
          fromIndex = toPosInt(this.length) - floor(abs(fromIndex));
        }
        for (i = fromIndex; i < length; ++i) {
          if (objHasOwnProperty.call(this, i)) {
            val = this[i];
            if (numberIsNaN(val)) {
              return i;
            }
          }
        }
        return -1;
      };
    });
    var require_get = __commonJS(function(exports, module) {
      'use strict';
      var indexOf = require_e_index_of();
      var create = Object.create;
      module.exports = function() {
        var lastId = 0, map = [], cache2 = create(null);
        return {
          get: function get(args) {
            var index = 0, set2 = map, i, length = args.length;
            if (length === 0) {
              return set2[length] || null;
            }
            if (set2 = set2[length]) {
              while (index < length - 1) {
                i = indexOf.call(set2[0], args[index]);
                if (i === -1) {
                  return null;
                }
                set2 = set2[1][i];
                ++index;
              }
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                return null;
              }
              return set2[1][i] || null;
            }
            return null;
          },
          set: function set(args) {
            var index = 0, set2 = map, i, length = args.length;
            if (length === 0) {
              set2[length] = ++lastId;
            } else {
              if (!set2[length]) {
                set2[length] = [ [], [] ];
              }
              set2 = set2[length];
              while (index < length - 1) {
                i = indexOf.call(set2[0], args[index]);
                if (i === -1) {
                  i = set2[0].push(args[index]) - 1;
                  set2[1].push([ [], [] ]);
                }
                set2 = set2[1][i];
                ++index;
              }
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                i = set2[0].push(args[index]) - 1;
              }
              set2[1][i] = ++lastId;
            }
            cache2[lastId] = args;
            return lastId;
          },
          delete: function _delete(id) {
            var index = 0, set2 = map, i, args = cache2[id], length = args.length, path = [];
            if (length === 0) {
              delete set2[length];
            } else if (set2 = set2[length]) {
              while (index < length - 1) {
                i = indexOf.call(set2[0], args[index]);
                if (i === -1) {
                  return;
                }
                path.push(set2, i);
                set2 = set2[1][i];
                ++index;
              }
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                return;
              }
              id = set2[1][i];
              set2[0].splice(i, 1);
              set2[1].splice(i, 1);
              while (!set2[0].length && path.length) {
                i = path.pop();
                set2 = path.pop();
                set2[0].splice(i, 1);
                set2[1].splice(i, 1);
              }
            }
            delete cache2[id];
          },
          clear: function clear() {
            map = [];
            cache2 = create(null);
          }
        };
      };
    });
    var require_get_1 = __commonJS(function(exports, module) {
      'use strict';
      var indexOf = require_e_index_of();
      module.exports = function() {
        var lastId = 0, argsMap = [], cache2 = [];
        return {
          get: function get(args) {
            var index = indexOf.call(argsMap, args[0]);
            return index === -1 ? null : cache2[index];
          },
          set: function set(args) {
            argsMap.push(args[0]);
            cache2.push(++lastId);
            return lastId;
          },
          delete: function _delete(id) {
            var index = indexOf.call(cache2, id);
            if (index !== -1) {
              argsMap.splice(index, 1);
              cache2.splice(index, 1);
            }
          },
          clear: function clear() {
            argsMap = [];
            cache2 = [];
          }
        };
      };
    });
    var require_get_fixed = __commonJS(function(exports, module) {
      'use strict';
      var indexOf = require_e_index_of();
      var create = Object.create;
      module.exports = function(length) {
        var lastId = 0, map = [ [], [] ], cache2 = create(null);
        return {
          get: function get(args) {
            var index = 0, set2 = map, i;
            while (index < length - 1) {
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                return null;
              }
              set2 = set2[1][i];
              ++index;
            }
            i = indexOf.call(set2[0], args[index]);
            if (i === -1) {
              return null;
            }
            return set2[1][i] || null;
          },
          set: function set(args) {
            var index = 0, set2 = map, i;
            while (index < length - 1) {
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                i = set2[0].push(args[index]) - 1;
                set2[1].push([ [], [] ]);
              }
              set2 = set2[1][i];
              ++index;
            }
            i = indexOf.call(set2[0], args[index]);
            if (i === -1) {
              i = set2[0].push(args[index]) - 1;
            }
            set2[1][i] = ++lastId;
            cache2[lastId] = args;
            return lastId;
          },
          delete: function _delete(id) {
            var index = 0, set2 = map, i, path = [], args = cache2[id];
            while (index < length - 1) {
              i = indexOf.call(set2[0], args[index]);
              if (i === -1) {
                return;
              }
              path.push(set2, i);
              set2 = set2[1][i];
              ++index;
            }
            i = indexOf.call(set2[0], args[index]);
            if (i === -1) {
              return;
            }
            id = set2[1][i];
            set2[0].splice(i, 1);
            set2[1].splice(i, 1);
            while (!set2[0].length && path.length) {
              i = path.pop();
              set2 = path.pop();
              set2[0].splice(i, 1);
              set2[1].splice(i, 1);
            }
            delete cache2[id];
          },
          clear: function clear() {
            map = [ [], [] ];
            cache2 = create(null);
          }
        };
      };
    });
    var require_map = __commonJS(function(exports, module) {
      'use strict';
      var callable = require_valid_callable();
      var forEach = require_for_each();
      var call = Function.prototype.call;
      module.exports = function(obj, cb) {
        var result = {}, thisArg = arguments[2];
        callable(cb);
        forEach(obj, function(value, key, targetObj, index) {
          result[key] = call.call(cb, thisArg, value, key, targetObj, index);
        });
        return result;
      };
    });
    var require_next_tick = __commonJS(function(exports, module) {
      'use strict';
      var ensureCallable = function ensureCallable(fn) {
        if (typeof fn !== 'function') {
          throw new TypeError(fn + ' is not a function');
        }
        return fn;
      };
      var byObserver = function byObserver(Observer) {
        var node = document.createTextNode(''), queue2, currentQueue, i = 0;
        new Observer(function() {
          var callback;
          if (!queue2) {
            if (!currentQueue) {
              return;
            }
            queue2 = currentQueue;
          } else if (currentQueue) {
            queue2 = currentQueue.concat(queue2);
          }
          currentQueue = queue2;
          queue2 = null;
          if (typeof currentQueue === 'function') {
            callback = currentQueue;
            currentQueue = null;
            callback();
            return;
          }
          node.data = i = ++i % 2;
          while (currentQueue) {
            callback = currentQueue.shift();
            if (!currentQueue.length) {
              currentQueue = null;
            }
            callback();
          }
        }).observe(node, {
          characterData: true
        });
        return function(fn) {
          ensureCallable(fn);
          if (queue2) {
            if (typeof queue2 === 'function') {
              queue2 = [ queue2, fn ];
            } else {
              queue2.push(fn);
            }
            return;
          }
          queue2 = fn;
          node.data = i = ++i % 2;
        };
      };
      module.exports = function() {
        if ((typeof process === 'undefined' ? 'undefined' : _typeof(process)) === 'object' && process && typeof process.nextTick === 'function') {
          return process.nextTick;
        }
        if (typeof queueMicrotask === 'function') {
          return function(cb) {
            queueMicrotask(ensureCallable(cb));
          };
        }
        if ((typeof document === 'undefined' ? 'undefined' : _typeof(document)) === 'object' && document) {
          if (typeof MutationObserver === 'function') {
            return byObserver(MutationObserver);
          }
          if (typeof WebKitMutationObserver === 'function') {
            return byObserver(WebKitMutationObserver);
          }
        }
        if (typeof setImmediate === 'function') {
          return function(cb) {
            setImmediate(ensureCallable(cb));
          };
        }
        if (typeof setTimeout === 'function' || (typeof setTimeout === 'undefined' ? 'undefined' : _typeof(setTimeout)) === 'object') {
          return function(cb) {
            setTimeout(ensureCallable(cb), 0);
          };
        }
        return null;
      }();
    });
    var require_async = __commonJS(function() {
      'use strict';
      var aFrom = require_from();
      var objectMap = require_map();
      var mixin = require_mixin();
      var defineLength = require_define_length();
      var nextTick = require_next_tick();
      var slice = Array.prototype.slice;
      var apply = Function.prototype.apply;
      var create = Object.create;
      require_registered_extensions().async = function(tbi, conf) {
        var waiting = create(null), cache2 = create(null), base = conf.memoized, original = conf.original, currentCallback, currentContext, currentArgs;
        conf.memoized = defineLength(function(arg) {
          var args = arguments, last2 = args[args.length - 1];
          if (typeof last2 === 'function') {
            currentCallback = last2;
            args = slice.call(args, 0, -1);
          }
          return base.apply(currentContext = this, currentArgs = args);
        }, base);
        try {
          mixin(conf.memoized, base);
        } catch (ignore) {}
        conf.on('get', function(id) {
          var cb, context, args;
          if (!currentCallback) {
            return;
          }
          if (waiting[id]) {
            if (typeof waiting[id] === 'function') {
              waiting[id] = [ waiting[id], currentCallback ];
            } else {
              waiting[id].push(currentCallback);
            }
            currentCallback = null;
            return;
          }
          cb = currentCallback;
          context = currentContext;
          args = currentArgs;
          currentCallback = currentContext = currentArgs = null;
          nextTick(function() {
            var data;
            if (hasOwnProperty.call(cache2, id)) {
              data = cache2[id];
              conf.emit('getasync', id, args, context);
              apply.call(cb, data.context, data.args);
            } else {
              currentCallback = cb;
              currentContext = context;
              currentArgs = args;
              base.apply(context, args);
            }
          });
        });
        conf.original = function() {
          var args, cb, origCb, result;
          if (!currentCallback) {
            return apply.call(original, this, arguments);
          }
          args = aFrom(arguments);
          cb = function self2(err2) {
            var cb2, args2, id = self2.id;
            if (id == null) {
              nextTick(apply.bind(self2, this, arguments));
              return void 0;
            }
            delete self2.id;
            cb2 = waiting[id];
            delete waiting[id];
            if (!cb2) {
              return void 0;
            }
            args2 = aFrom(arguments);
            if (conf.has(id)) {
              if (err2) {
                conf['delete'](id);
              } else {
                cache2[id] = {
                  context: this,
                  args: args2
                };
                conf.emit('setasync', id, typeof cb2 === 'function' ? 1 : cb2.length);
              }
            }
            if (typeof cb2 === 'function') {
              result = apply.call(cb2, this, args2);
            } else {
              cb2.forEach(function(cb3) {
                result = apply.call(cb3, this, args2);
              }, this);
            }
            return result;
          };
          origCb = currentCallback;
          currentCallback = currentContext = currentArgs = null;
          args.push(cb);
          result = apply.call(original, this, args);
          cb.cb = origCb;
          currentCallback = cb;
          return result;
        };
        conf.on('set', function(id) {
          if (!currentCallback) {
            conf['delete'](id);
            return;
          }
          if (waiting[id]) {
            if (typeof waiting[id] === 'function') {
              waiting[id] = [ waiting[id], currentCallback.cb ];
            } else {
              waiting[id].push(currentCallback.cb);
            }
          } else {
            waiting[id] = currentCallback.cb;
          }
          delete currentCallback.cb;
          currentCallback.id = id;
          currentCallback = null;
        });
        conf.on('delete', function(id) {
          var result;
          if (hasOwnProperty.call(waiting, id)) {
            return;
          }
          if (!cache2[id]) {
            return;
          }
          result = cache2[id];
          delete cache2[id];
          conf.emit('deleteasync', id, slice.call(result.args, 1));
        });
        conf.on('clear', function() {
          var oldCache = cache2;
          cache2 = create(null);
          conf.emit('clearasync', objectMap(oldCache, function(data) {
            return slice.call(data.args, 1);
          }));
        });
      };
    });
    var require_primitive_set = __commonJS(function(exports, module) {
      'use strict';
      var forEach = Array.prototype.forEach;
      var create = Object.create;
      module.exports = function(arg) {
        var set2 = create(null);
        forEach.call(arguments, function(name) {
          set2[name] = true;
        });
        return set2;
      };
    });
    var require_is_callable = __commonJS(function(exports, module) {
      'use strict';
      module.exports = function(obj) {
        return typeof obj === 'function';
      };
    });
    var require_validate_stringifiable = __commonJS(function(exports, module) {
      'use strict';
      var isCallable = require_is_callable();
      module.exports = function(stringifiable) {
        try {
          if (stringifiable && isCallable(stringifiable.toString)) {
            return stringifiable.toString();
          }
          return String(stringifiable);
        } catch (e) {
          throw new TypeError('Passed argument cannot be stringifed');
        }
      };
    });
    var require_validate_stringifiable_value = __commonJS(function(exports, module) {
      'use strict';
      var ensureValue = require_valid_value();
      var stringifiable = require_validate_stringifiable();
      module.exports = function(value) {
        return stringifiable(ensureValue(value));
      };
    });
    var require_safe_to_string = __commonJS(function(exports, module) {
      'use strict';
      var isCallable = require_is_callable();
      module.exports = function(value) {
        try {
          if (value && isCallable(value.toString)) {
            return value.toString();
          }
          return String(value);
        } catch (e) {
          return '<Non-coercible to string value>';
        }
      };
    });
    var require_to_short_string_representation = __commonJS(function(exports, module) {
      'use strict';
      var safeToString = require_safe_to_string();
      var reNewLine = /[\n\r\u2028\u2029]/g;
      module.exports = function(value) {
        var string = safeToString(value);
        if (string.length > 100) {
          string = string.slice(0, 99) + '\u2026';
        }
        string = string.replace(reNewLine, function(_char) {
          return JSON.stringify(_char).slice(1, -1);
        });
        return string;
      };
    });
    var require_is_promise = __commonJS(function(exports, module) {
      module.exports = isPromise;
      module.exports['default'] = isPromise;
      function isPromise(obj) {
        return !!obj && (_typeof(obj) === 'object' || typeof obj === 'function') && typeof obj.then === 'function';
      }
    });
    var require_promise = __commonJS(function() {
      'use strict';
      var objectMap = require_map();
      var primitiveSet = require_primitive_set();
      var ensureString = require_validate_stringifiable_value();
      var toShortString = require_to_short_string_representation();
      var isPromise = require_is_promise();
      var nextTick = require_next_tick();
      var create = Object.create;
      var supportedModes = primitiveSet('then', 'then:finally', 'done', 'done:finally');
      require_registered_extensions().promise = function(mode, conf) {
        var waiting = create(null), cache2 = create(null), promises = create(null);
        if (mode === true) {
          mode = null;
        } else {
          mode = ensureString(mode);
          if (!supportedModes[mode]) {
            throw new TypeError('\'' + toShortString(mode) + '\' is not valid promise mode');
          }
        }
        conf.on('set', function(id, ignore, promise) {
          var isFailed = false;
          if (!isPromise(promise)) {
            cache2[id] = promise;
            conf.emit('setasync', id, 1);
            return;
          }
          waiting[id] = 1;
          promises[id] = promise;
          var onSuccess = function onSuccess(result) {
            var count = waiting[id];
            if (isFailed) {
              throw new Error('Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in \'done:finally\' mode)\nConsider to rely on \'then\' or \'done\' mode instead.');
            }
            if (!count) {
              return;
            }
            delete waiting[id];
            cache2[id] = result;
            conf.emit('setasync', id, count);
          };
          var onFailure = function onFailure() {
            isFailed = true;
            if (!waiting[id]) {
              return;
            }
            delete waiting[id];
            delete promises[id];
            conf['delete'](id);
          };
          var resolvedMode = mode;
          if (!resolvedMode) {
            resolvedMode = 'then';
          }
          if (resolvedMode === 'then') {
            var nextTickFailure = function nextTickFailure() {
              nextTick(onFailure);
            };
            promise = promise.then(function(result) {
              nextTick(onSuccess.bind(this, result));
            }, nextTickFailure);
            if (typeof promise['finally'] === 'function') {
              promise['finally'](nextTickFailure);
            }
          } else if (resolvedMode === 'done') {
            if (typeof promise.done !== 'function') {
              throw new Error('Memoizee error: Retrieved promise does not implement \'done\' in \'done\' mode');
            }
            promise.done(onSuccess, onFailure);
          } else if (resolvedMode === 'done:finally') {
            if (typeof promise.done !== 'function') {
              throw new Error('Memoizee error: Retrieved promise does not implement \'done\' in \'done:finally\' mode');
            }
            if (typeof promise['finally'] !== 'function') {
              throw new Error('Memoizee error: Retrieved promise does not implement \'finally\' in \'done:finally\' mode');
            }
            promise.done(onSuccess);
            promise['finally'](onFailure);
          }
        });
        conf.on('get', function(id, args, context) {
          var promise;
          if (waiting[id]) {
            ++waiting[id];
            return;
          }
          promise = promises[id];
          var emit = function emit() {
            conf.emit('getasync', id, args, context);
          };
          if (isPromise(promise)) {
            if (typeof promise.done === 'function') {
              promise.done(emit);
            } else {
              promise.then(function() {
                nextTick(emit);
              });
            }
          } else {
            emit();
          }
        });
        conf.on('delete', function(id) {
          delete promises[id];
          if (waiting[id]) {
            delete waiting[id];
            return;
          }
          if (!hasOwnProperty.call(cache2, id)) {
            return;
          }
          var result = cache2[id];
          delete cache2[id];
          conf.emit('deleteasync', id, [ result ]);
        });
        conf.on('clear', function() {
          var oldCache = cache2;
          cache2 = create(null);
          waiting = create(null);
          promises = create(null);
          conf.emit('clearasync', objectMap(oldCache, function(data) {
            return [ data ];
          }));
        });
      };
    });
    var require_dispose = __commonJS(function() {
      'use strict';
      var callable = require_valid_callable();
      var forEach = require_for_each();
      var extensions = require_registered_extensions();
      var apply = Function.prototype.apply;
      extensions.dispose = function(dispose, conf, options) {
        var del;
        callable(dispose);
        if (options.async && extensions.async || options.promise && extensions.promise) {
          conf.on('deleteasync', del = function del(id, resultArray) {
            apply.call(dispose, null, resultArray);
          });
          conf.on('clearasync', function(cache2) {
            forEach(cache2, function(result, id) {
              del(id, result);
            });
          });
          return;
        }
        conf.on('delete', del = function del(id, result) {
          dispose(result);
        });
        conf.on('clear', function(cache2) {
          forEach(cache2, function(result, id) {
            del(id, result);
          });
        });
      };
    });
    var require_max_timeout = __commonJS(function(exports, module) {
      'use strict';
      module.exports = 2147483647;
    });
    var require_valid_timeout = __commonJS(function(exports, module) {
      'use strict';
      var toPosInt = require_to_pos_integer();
      var maxTimeout = require_max_timeout();
      module.exports = function(value) {
        value = toPosInt(value);
        if (value > maxTimeout) {
          throw new TypeError(value + ' exceeds maximum possible timeout');
        }
        return value;
      };
    });
    var require_max_age = __commonJS(function() {
      'use strict';
      var aFrom = require_from();
      var forEach = require_for_each();
      var nextTick = require_next_tick();
      var isPromise = require_is_promise();
      var timeout = require_valid_timeout();
      var extensions = require_registered_extensions();
      var noop3 = Function.prototype;
      var max2 = Math.max;
      var min = Math.min;
      var create = Object.create;
      extensions.maxAge = function(maxAge, conf, options) {
        var timeouts, postfix, preFetchAge, preFetchTimeouts;
        maxAge = timeout(maxAge);
        if (!maxAge) {
          return;
        }
        timeouts = create(null);
        postfix = options.async && extensions.async || options.promise && extensions.promise ? 'async' : '';
        conf.on('set' + postfix, function(id) {
          timeouts[id] = setTimeout(function() {
            conf['delete'](id);
          }, maxAge);
          if (typeof timeouts[id].unref === 'function') {
            timeouts[id].unref();
          }
          if (!preFetchTimeouts) {
            return;
          }
          if (preFetchTimeouts[id]) {
            if (preFetchTimeouts[id] !== 'nextTick') {
              clearTimeout(preFetchTimeouts[id]);
            }
          }
          preFetchTimeouts[id] = setTimeout(function() {
            delete preFetchTimeouts[id];
          }, preFetchAge);
          if (typeof preFetchTimeouts[id].unref === 'function') {
            preFetchTimeouts[id].unref();
          }
        });
        conf.on('delete' + postfix, function(id) {
          clearTimeout(timeouts[id]);
          delete timeouts[id];
          if (!preFetchTimeouts) {
            return;
          }
          if (preFetchTimeouts[id] !== 'nextTick') {
            clearTimeout(preFetchTimeouts[id]);
          }
          delete preFetchTimeouts[id];
        });
        if (options.preFetch) {
          if (options.preFetch === true || isNaN(options.preFetch)) {
            preFetchAge = .333;
          } else {
            preFetchAge = max2(min(Number(options.preFetch), 1), 0);
          }
          if (preFetchAge) {
            preFetchTimeouts = {};
            preFetchAge = (1 - preFetchAge) * maxAge;
            conf.on('get' + postfix, function(id, args, context) {
              if (!preFetchTimeouts[id]) {
                preFetchTimeouts[id] = 'nextTick';
                nextTick(function() {
                  var result;
                  if (preFetchTimeouts[id] !== 'nextTick') {
                    return;
                  }
                  delete preFetchTimeouts[id];
                  conf['delete'](id);
                  if (options.async) {
                    args = aFrom(args);
                    args.push(noop3);
                  }
                  result = conf.memoized.apply(context, args);
                  if (options.promise) {
                    if (isPromise(result)) {
                      if (typeof result.done === 'function') {
                        result.done(noop3, noop3);
                      } else {
                        result.then(noop3, noop3);
                      }
                    }
                  }
                });
              }
            });
          }
        }
        conf.on('clear' + postfix, function() {
          forEach(timeouts, function(id) {
            clearTimeout(id);
          });
          timeouts = {};
          if (preFetchTimeouts) {
            forEach(preFetchTimeouts, function(id) {
              if (id !== 'nextTick') {
                clearTimeout(id);
              }
            });
            preFetchTimeouts = {};
          }
        });
      };
    });
    var require_lru_queue = __commonJS(function(exports, module) {
      'use strict';
      var toPosInt = require_to_pos_integer();
      var create = Object.create;
      var hasOwnProperty2 = Object.prototype.hasOwnProperty;
      module.exports = function(limit) {
        var size = 0, base = 1, queue2 = create(null), map = create(null), index = 0, del;
        limit = toPosInt(limit);
        return {
          hit: function hit(id) {
            var oldIndex = map[id], nuIndex = ++index;
            queue2[nuIndex] = id;
            map[id] = nuIndex;
            if (!oldIndex) {
              ++size;
              if (size <= limit) {
                return;
              }
              id = queue2[base];
              del(id);
              return id;
            }
            delete queue2[oldIndex];
            if (base !== oldIndex) {
              return;
            }
            while (!hasOwnProperty2.call(queue2, ++base)) {
              continue;
            }
          },
          delete: del = function del(id) {
            var oldIndex = map[id];
            if (!oldIndex) {
              return;
            }
            delete queue2[oldIndex];
            delete map[id];
            --size;
            if (base !== oldIndex) {
              return;
            }
            if (!size) {
              index = 0;
              base = 1;
              return;
            }
            while (!hasOwnProperty2.call(queue2, ++base)) {
              continue;
            }
          },
          clear: function clear() {
            size = 0;
            base = 1;
            queue2 = create(null);
            map = create(null);
            index = 0;
          }
        };
      };
    });
    var require_max = __commonJS(function() {
      'use strict';
      var toPosInteger = require_to_pos_integer();
      var lruQueue = require_lru_queue();
      var extensions = require_registered_extensions();
      extensions.max = function(max2, conf, options) {
        var postfix, queue2, hit;
        max2 = toPosInteger(max2);
        if (!max2) {
          return;
        }
        queue2 = lruQueue(max2);
        postfix = options.async && extensions.async || options.promise && extensions.promise ? 'async' : '';
        conf.on('set' + postfix, hit = function hit(id) {
          id = queue2.hit(id);
          if (id === void 0) {
            return;
          }
          conf['delete'](id);
        });
        conf.on('get' + postfix, hit);
        conf.on('delete' + postfix, queue2['delete']);
        conf.on('clear' + postfix, queue2.clear);
      };
    });
    var require_ref_counter = __commonJS(function() {
      'use strict';
      var d2 = require_d();
      var extensions = require_registered_extensions();
      var create = Object.create;
      var defineProperties = Object.defineProperties;
      extensions.refCounter = function(ignore, conf, options) {
        var cache2, postfix;
        cache2 = create(null);
        postfix = options.async && extensions.async || options.promise && extensions.promise ? 'async' : '';
        conf.on('set' + postfix, function(id, length) {
          cache2[id] = length || 1;
        });
        conf.on('get' + postfix, function(id) {
          ++cache2[id];
        });
        conf.on('delete' + postfix, function(id) {
          delete cache2[id];
        });
        conf.on('clear' + postfix, function() {
          cache2 = {};
        });
        defineProperties(conf.memoized, {
          deleteRef: d2(function() {
            var id = conf.get(arguments);
            if (id === null) {
              return null;
            }
            if (!cache2[id]) {
              return null;
            }
            if (!--cache2[id]) {
              conf['delete'](id);
              return true;
            }
            return false;
          }),
          getRefCount: d2(function() {
            var id = conf.get(arguments);
            if (id === null) {
              return 0;
            }
            if (!cache2[id]) {
              return 0;
            }
            return cache2[id];
          })
        });
      };
    });
    var require_memoizee = __commonJS(function(exports, module) {
      'use strict';
      var normalizeOpts = require_normalize_options();
      var resolveLength = require_resolve_length();
      var plain = require_plain();
      module.exports = function(fn) {
        var options = normalizeOpts(arguments[1]), length;
        if (!options.normalizer) {
          length = options.length = resolveLength(options.length, fn.length, options.async);
          if (length !== 0) {
            if (options.primitive) {
              if (length === false) {
                options.normalizer = require_primitive();
              } else if (length > 1) {
                options.normalizer = require_get_primitive_fixed()(length);
              }
            } else if (length === false) {
              options.normalizer = require_get()();
            } else if (length === 1) {
              options.normalizer = require_get_1()();
            } else {
              options.normalizer = require_get_fixed()(length);
            }
          }
        }
        if (options.async) {
          require_async();
        }
        if (options.promise) {
          require_promise();
        }
        if (options.dispose) {
          require_dispose();
        }
        if (options.maxAge) {
          require_max_age();
        }
        if (options.max) {
          require_max();
        }
        if (options.refCounter) {
          require_ref_counter();
        }
        return plain(fn, options);
      };
    });
    var require_utils = __commonJS(function(exports) {
      'use strict';
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
      function isIdentStart(c4) {
        return c4 >= 'a' && c4 <= 'z' || c4 >= 'A' && c4 <= 'Z' || c4 === '-' || c4 === '_';
      }
      exports.isIdentStart = isIdentStart;
      function isIdent(c4) {
        return c4 >= 'a' && c4 <= 'z' || c4 >= 'A' && c4 <= 'Z' || c4 >= '0' && c4 <= '9' || c4 === '-' || c4 === '_';
      }
      exports.isIdent = isIdent;
      function isHex(c4) {
        return c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F' || c4 >= '0' && c4 <= '9';
      }
      exports.isHex = isHex;
      function escapeIdentifier(s) {
        var len = s.length;
        var result = '';
        var i = 0;
        while (i < len) {
          var chr = s.charAt(i);
          if (exports.identSpecialChars[chr]) {
            result += '\\' + chr;
          } else {
            if (!(chr === '_' || chr === '-' || chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || i !== 0 && chr >= '0' && chr <= '9')) {
              var charCode = chr.charCodeAt(0);
              if ((charCode & 63488) === 55296) {
                var extraCharCode = s.charCodeAt(i++);
                if ((charCode & 64512) !== 55296 || (extraCharCode & 64512) !== 56320) {
                  throw Error('UCS-2(decode): illegal sequence');
                }
                charCode = ((charCode & 1023) << 10) + (extraCharCode & 1023) + 65536;
              }
              result += '\\' + charCode.toString(16) + ' ';
            } else {
              result += chr;
            }
          }
          i++;
        }
        return result;
      }
      exports.escapeIdentifier = escapeIdentifier;
      function escapeStr(s) {
        var len = s.length;
        var result = '';
        var i = 0;
        var replacement;
        while (i < len) {
          var chr = s.charAt(i);
          if (chr === '"') {
            chr = '\\"';
          } else if (chr === '\\') {
            chr = '\\\\';
          } else if ((replacement = exports.strReplacementsRev[chr]) !== void 0) {
            chr = replacement;
          }
          result += chr;
          i++;
        }
        return '"' + result + '"';
      }
      exports.escapeStr = escapeStr;
      exports.identSpecialChars = {
        '!': true,
        '"': true,
        '#': true,
        $: true,
        '%': true,
        '&': true,
        '\'': true,
        '(': true,
        ')': true,
        '*': true,
        '+': true,
        ',': true,
        '.': true,
        '/': true,
        ';': true,
        '<': true,
        '=': true,
        '>': true,
        '?': true,
        '@': true,
        '[': true,
        '\\': true,
        ']': true,
        '^': true,
        '`': true,
        '{': true,
        '|': true,
        '}': true,
        '~': true
      };
      exports.strReplacementsRev = {
        '\n': '\\n',
        '\r': '\\r',
        '\t': '\\t',
        '\f': '\\f',
        '\v': '\\v'
      };
      exports.singleQuoteEscapeChars = {
        n: '\n',
        r: '\r',
        t: '\t',
        f: '\f',
        '\\': '\\',
        '\'': '\''
      };
      exports.doubleQuotesEscapeChars = {
        n: '\n',
        r: '\r',
        t: '\t',
        f: '\f',
        '\\': '\\',
        '"': '"'
      };
    });
    var require_parser_context = __commonJS(function(exports) {
      'use strict';
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
      var utils_1 = require_utils();
      function parseCssSelector(str, pos, pseudos, attrEqualityMods, ruleNestingOperators, substitutesEnabled) {
        var l = str.length;
        var chr = '';
        function getStr(quote, escapeTable) {
          var result = '';
          pos++;
          chr = str.charAt(pos);
          while (pos < l) {
            if (chr === quote) {
              pos++;
              return result;
            } else if (chr === '\\') {
              pos++;
              chr = str.charAt(pos);
              var esc = void 0;
              if (chr === quote) {
                result += quote;
              } else if ((esc = escapeTable[chr]) !== void 0) {
                result += esc;
              } else if (utils_1.isHex(chr)) {
                var hex = chr;
                pos++;
                chr = str.charAt(pos);
                while (utils_1.isHex(chr)) {
                  hex += chr;
                  pos++;
                  chr = str.charAt(pos);
                }
                if (chr === ' ') {
                  pos++;
                  chr = str.charAt(pos);
                }
                result += String.fromCharCode(parseInt(hex, 16));
                continue;
              } else {
                result += chr;
              }
            } else {
              result += chr;
            }
            pos++;
            chr = str.charAt(pos);
          }
          return result;
        }
        function getIdent() {
          var result = '';
          chr = str.charAt(pos);
          while (pos < l) {
            if (utils_1.isIdent(chr)) {
              result += chr;
            } else if (chr === '\\') {
              pos++;
              if (pos >= l) {
                throw Error('Expected symbol but end of file reached.');
              }
              chr = str.charAt(pos);
              if (utils_1.identSpecialChars[chr]) {
                result += chr;
              } else if (utils_1.isHex(chr)) {
                var hex = chr;
                pos++;
                chr = str.charAt(pos);
                while (utils_1.isHex(chr)) {
                  hex += chr;
                  pos++;
                  chr = str.charAt(pos);
                }
                if (chr === ' ') {
                  pos++;
                  chr = str.charAt(pos);
                }
                result += String.fromCharCode(parseInt(hex, 16));
                continue;
              } else {
                result += chr;
              }
            } else {
              return result;
            }
            pos++;
            chr = str.charAt(pos);
          }
          return result;
        }
        function skipWhitespace() {
          chr = str.charAt(pos);
          var result = false;
          while (chr === ' ' || chr === '\t' || chr === '\n' || chr === '\r' || chr === '\f') {
            result = true;
            pos++;
            chr = str.charAt(pos);
          }
          return result;
        }
        function parse3() {
          var res = parseSelector();
          if (pos < l) {
            throw Error('Rule expected but "' + str.charAt(pos) + '" found.');
          }
          return res;
        }
        function parseSelector() {
          var selector = parseSingleSelector();
          if (!selector) {
            return null;
          }
          var res = selector;
          chr = str.charAt(pos);
          while (chr === ',') {
            pos++;
            skipWhitespace();
            if (res.type !== 'selectors') {
              res = {
                type: 'selectors',
                selectors: [ selector ]
              };
            }
            selector = parseSingleSelector();
            if (!selector) {
              throw Error('Rule expected after ",".');
            }
            res.selectors.push(selector);
          }
          return res;
        }
        function parseSingleSelector() {
          skipWhitespace();
          var selector = {
            type: 'ruleSet'
          };
          var rule = parseRule();
          if (!rule) {
            return null;
          }
          var currentRule = selector;
          while (rule) {
            rule.type = 'rule';
            currentRule.rule = rule;
            currentRule = rule;
            skipWhitespace();
            chr = str.charAt(pos);
            if (pos >= l || chr === ',' || chr === ')') {
              break;
            }
            if (ruleNestingOperators[chr]) {
              var op = chr;
              pos++;
              skipWhitespace();
              rule = parseRule();
              if (!rule) {
                throw Error('Rule expected after "' + op + '".');
              }
              rule.nestingOperator = op;
            } else {
              rule = parseRule();
              if (rule) {
                rule.nestingOperator = null;
              }
            }
          }
          return selector;
        }
        function parseRule() {
          var rule = null;
          while (pos < l) {
            chr = str.charAt(pos);
            if (chr === '*') {
              pos++;
              (rule = rule || {}).tagName = '*';
            } else if (utils_1.isIdentStart(chr) || chr === '\\') {
              (rule = rule || {}).tagName = getIdent();
            } else if (chr === '.') {
              pos++;
              rule = rule || {};
              (rule.classNames = rule.classNames || []).push(getIdent());
            } else if (chr === '#') {
              pos++;
              (rule = rule || {}).id = getIdent();
            } else if (chr === '[') {
              pos++;
              skipWhitespace();
              var attr = {
                name: getIdent()
              };
              skipWhitespace();
              if (chr === ']') {
                pos++;
              } else {
                var operator = '';
                if (attrEqualityMods[chr]) {
                  operator = chr;
                  pos++;
                  chr = str.charAt(pos);
                }
                if (pos >= l) {
                  throw Error('Expected "=" but end of file reached.');
                }
                if (chr !== '=') {
                  throw Error('Expected "=" but "' + chr + '" found.');
                }
                attr.operator = operator + '=';
                pos++;
                skipWhitespace();
                var attrValue = '';
                attr.valueType = 'string';
                if (chr === '"') {
                  attrValue = getStr('"', utils_1.doubleQuotesEscapeChars);
                } else if (chr === '\'') {
                  attrValue = getStr('\'', utils_1.singleQuoteEscapeChars);
                } else if (substitutesEnabled && chr === '$') {
                  pos++;
                  attrValue = getIdent();
                  attr.valueType = 'substitute';
                } else {
                  while (pos < l) {
                    if (chr === ']') {
                      break;
                    }
                    attrValue += chr;
                    pos++;
                    chr = str.charAt(pos);
                  }
                  attrValue = attrValue.trim();
                }
                skipWhitespace();
                if (pos >= l) {
                  throw Error('Expected "]" but end of file reached.');
                }
                if (chr !== ']') {
                  throw Error('Expected "]" but "' + chr + '" found.');
                }
                pos++;
                attr.value = attrValue;
              }
              rule = rule || {};
              (rule.attrs = rule.attrs || []).push(attr);
            } else if (chr === ':') {
              pos++;
              var pseudoName = getIdent();
              var pseudo = {
                name: pseudoName
              };
              if (chr === '(') {
                pos++;
                var value = '';
                skipWhitespace();
                if (pseudos[pseudoName] === 'selector') {
                  pseudo.valueType = 'selector';
                  value = parseSelector();
                } else {
                  pseudo.valueType = pseudos[pseudoName] || 'string';
                  if (chr === '"') {
                    value = getStr('"', utils_1.doubleQuotesEscapeChars);
                  } else if (chr === '\'') {
                    value = getStr('\'', utils_1.singleQuoteEscapeChars);
                  } else if (substitutesEnabled && chr === '$') {
                    pos++;
                    value = getIdent();
                    pseudo.valueType = 'substitute';
                  } else {
                    while (pos < l) {
                      if (chr === ')') {
                        break;
                      }
                      value += chr;
                      pos++;
                      chr = str.charAt(pos);
                    }
                    value = value.trim();
                  }
                  skipWhitespace();
                }
                if (pos >= l) {
                  throw Error('Expected ")" but end of file reached.');
                }
                if (chr !== ')') {
                  throw Error('Expected ")" but "' + chr + '" found.');
                }
                pos++;
                pseudo.value = value;
              }
              rule = rule || {};
              (rule.pseudos = rule.pseudos || []).push(pseudo);
            } else {
              break;
            }
          }
          return rule;
        }
        return parse3();
      }
      exports.parseCssSelector = parseCssSelector;
    });
    var require_render = __commonJS(function(exports) {
      'use strict';
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
      var utils_1 = require_utils();
      function renderEntity(entity) {
        var res = '';
        switch (entity.type) {
         case 'ruleSet':
          var currentEntity = entity.rule;
          var parts = [];
          while (currentEntity) {
            if (currentEntity.nestingOperator) {
              parts.push(currentEntity.nestingOperator);
            }
            parts.push(renderEntity(currentEntity));
            currentEntity = currentEntity.rule;
          }
          res = parts.join(' ');
          break;

         case 'selectors':
          res = entity.selectors.map(renderEntity).join(', ');
          break;

         case 'rule':
          if (entity.tagName) {
            if (entity.tagName === '*') {
              res = '*';
            } else {
              res = utils_1.escapeIdentifier(entity.tagName);
            }
          }
          if (entity.id) {
            res += '#' + utils_1.escapeIdentifier(entity.id);
          }
          if (entity.classNames) {
            res += entity.classNames.map(function(cn) {
              return '.' + utils_1.escapeIdentifier(cn);
            }).join('');
          }
          if (entity.attrs) {
            res += entity.attrs.map(function(attr) {
              if ('operator' in attr) {
                if (attr.valueType === 'substitute') {
                  return '[' + utils_1.escapeIdentifier(attr.name) + attr.operator + '$' + attr.value + ']';
                } else {
                  return '[' + utils_1.escapeIdentifier(attr.name) + attr.operator + utils_1.escapeStr(attr.value) + ']';
                }
              } else {
                return '[' + utils_1.escapeIdentifier(attr.name) + ']';
              }
            }).join('');
          }
          if (entity.pseudos) {
            res += entity.pseudos.map(function(pseudo) {
              if (pseudo.valueType) {
                if (pseudo.valueType === 'selector') {
                  return ':' + utils_1.escapeIdentifier(pseudo.name) + '(' + renderEntity(pseudo.value) + ')';
                } else if (pseudo.valueType === 'substitute') {
                  return ':' + utils_1.escapeIdentifier(pseudo.name) + '($' + pseudo.value + ')';
                } else if (pseudo.valueType === 'numeric') {
                  return ':' + utils_1.escapeIdentifier(pseudo.name) + '(' + pseudo.value + ')';
                } else {
                  return ':' + utils_1.escapeIdentifier(pseudo.name) + '(' + utils_1.escapeIdentifier(pseudo.value) + ')';
                }
              } else {
                return ':' + utils_1.escapeIdentifier(pseudo.name);
              }
            }).join('');
          }
          break;

         default:
          throw Error('Unknown entity type: "' + entity.type + '".');
        }
        return res;
      }
      exports.renderEntity = renderEntity;
    });
    var require_lib = __commonJS(function(exports) {
      'use strict';
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
      var parser_context_1 = require_parser_context();
      var render_1 = require_render();
      var CssSelectorParser3 = function() {
        function CssSelectorParser4() {
          this.pseudos = {};
          this.attrEqualityMods = {};
          this.ruleNestingOperators = {};
          this.substitutesEnabled = false;
        }
        CssSelectorParser4.prototype.registerSelectorPseudos = function() {
          var pseudos = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            pseudos[_i] = arguments[_i];
          }
          for (var _a = 0, pseudos_1 = pseudos; _a < pseudos_1.length; _a++) {
            var pseudo = pseudos_1[_a];
            this.pseudos[pseudo] = 'selector';
          }
          return this;
        };
        CssSelectorParser4.prototype.unregisterSelectorPseudos = function() {
          var pseudos = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            pseudos[_i] = arguments[_i];
          }
          for (var _a = 0, pseudos_2 = pseudos; _a < pseudos_2.length; _a++) {
            var pseudo = pseudos_2[_a];
            delete this.pseudos[pseudo];
          }
          return this;
        };
        CssSelectorParser4.prototype.registerNumericPseudos = function() {
          var pseudos = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            pseudos[_i] = arguments[_i];
          }
          for (var _a = 0, pseudos_3 = pseudos; _a < pseudos_3.length; _a++) {
            var pseudo = pseudos_3[_a];
            this.pseudos[pseudo] = 'numeric';
          }
          return this;
        };
        CssSelectorParser4.prototype.unregisterNumericPseudos = function() {
          var pseudos = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            pseudos[_i] = arguments[_i];
          }
          for (var _a = 0, pseudos_4 = pseudos; _a < pseudos_4.length; _a++) {
            var pseudo = pseudos_4[_a];
            delete this.pseudos[pseudo];
          }
          return this;
        };
        CssSelectorParser4.prototype.registerNestingOperators = function() {
          var operators = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            operators[_i] = arguments[_i];
          }
          for (var _a = 0, operators_1 = operators; _a < operators_1.length; _a++) {
            var operator = operators_1[_a];
            this.ruleNestingOperators[operator] = true;
          }
          return this;
        };
        CssSelectorParser4.prototype.unregisterNestingOperators = function() {
          var operators = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            operators[_i] = arguments[_i];
          }
          for (var _a = 0, operators_2 = operators; _a < operators_2.length; _a++) {
            var operator = operators_2[_a];
            delete this.ruleNestingOperators[operator];
          }
          return this;
        };
        CssSelectorParser4.prototype.registerAttrEqualityMods = function() {
          var mods = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            mods[_i] = arguments[_i];
          }
          for (var _a = 0, mods_1 = mods; _a < mods_1.length; _a++) {
            var mod = mods_1[_a];
            this.attrEqualityMods[mod] = true;
          }
          return this;
        };
        CssSelectorParser4.prototype.unregisterAttrEqualityMods = function() {
          var mods = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            mods[_i] = arguments[_i];
          }
          for (var _a = 0, mods_2 = mods; _a < mods_2.length; _a++) {
            var mod = mods_2[_a];
            delete this.attrEqualityMods[mod];
          }
          return this;
        };
        CssSelectorParser4.prototype.enableSubstitutes = function() {
          this.substitutesEnabled = true;
          return this;
        };
        CssSelectorParser4.prototype.disableSubstitutes = function() {
          this.substitutesEnabled = false;
          return this;
        };
        CssSelectorParser4.prototype.parse = function(str) {
          return parser_context_1.parseCssSelector(str, 0, this.pseudos, this.attrEqualityMods, this.ruleNestingOperators, this.substitutesEnabled);
        };
        CssSelectorParser4.prototype.render = function(path) {
          return render_1.renderEntity(path).trim();
        };
        return CssSelectorParser4;
      }();
      exports.CssSelectorParser = CssSelectorParser3;
    });
    var require_doT = __commonJS(function(exports, module) {
      (function() {
        'use strict';
        var doT3 = {
          name: 'doT',
          version: '1.1.1',
          templateSettings: {
            evaluate: /\{\{([\s\S]+?(\}?)+)\}\}/g,
            interpolate: /\{\{=([\s\S]+?)\}\}/g,
            encode: /\{\{!([\s\S]+?)\}\}/g,
            use: /\{\{#([\s\S]+?)\}\}/g,
            useParams: /(^|[^\w$])def(?:\.|\[[\'\"])([\w$\.]+)(?:[\'\"]\])?\s*\:\s*([\w$\.]+|\"[^\"]+\"|\'[^\']+\'|\{[^\}]+\})/g,
            define: /\{\{##\s*([\w\.$]+)\s*(\:|=)([\s\S]+?)#\}\}/g,
            defineParams: /^\s*([\w$]+):([\s\S]+)/,
            conditional: /\{\{\?(\?)?\s*([\s\S]*?)\s*\}\}/g,
            iterate: /\{\{~\s*(?:\}\}|([\s\S]+?)\s*\:\s*([\w$]+)\s*(?:\:\s*([\w$]+))?\s*\}\})/g,
            varname: 'it',
            strip: true,
            append: true,
            selfcontained: false,
            doNotSkipEncoded: false
          },
          template: void 0,
          compile: void 0,
          log: true
        };
        (function() {
          if ((typeof globalThis === 'undefined' ? 'undefined' : _typeof(globalThis)) === 'object') {
            return;
          }
          try {
            Object.defineProperty(Object.prototype, '__magic__', {
              get: function get() {
                return this;
              },
              configurable: true
            });
            __magic__.globalThis = __magic__;
            delete Object.prototype.__magic__;
          } catch (e) {
            window.globalThis = function() {
              if (typeof self !== 'undefined') {
                return self;
              }
              if (typeof window !== 'undefined') {
                return window;
              }
              if (typeof global !== 'undefined') {
                return global;
              }
              if (typeof this !== 'undefined') {
                return this;
              }
              throw new Error('Unable to locate global `this`');
            }();
          }
        })();
        doT3.encodeHTMLSource = function(doNotSkipEncoded) {
          var encodeHTMLRules = {
            '&': '&#38;',
            '<': '&#60;',
            '>': '&#62;',
            '"': '&#34;',
            '\'': '&#39;',
            '/': '&#47;'
          }, matchHTML = doNotSkipEncoded ? /[&<>"'\/]/g : /&(?!#?\w+;)|<|>|"|'|\//g;
          return function(code) {
            return code ? code.toString().replace(matchHTML, function(m3) {
              return encodeHTMLRules[m3] || m3;
            }) : '';
          };
        };
        if (typeof module !== 'undefined' && module.exports) {
          module.exports = doT3;
        } else if (true) {
          !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
            return doT3;
          }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
        } else {}
        var startend = {
          append: {
            start: '\'+(',
            end: ')+\'',
            startencode: '\'+encodeHTML('
          },
          split: {
            start: '\';out+=(',
            end: ');out+=\'',
            startencode: '\';out+=encodeHTML('
          }
        }, skip = /$^/;
        function resolveDefs(c4, block, def) {
          return (typeof block === 'string' ? block : block.toString()).replace(c4.define || skip, function(m3, code, assign, value) {
            if (code.indexOf('def.') === 0) {
              code = code.substring(4);
            }
            if (!(code in def)) {
              if (assign === ':') {
                if (c4.defineParams) {
                  value.replace(c4.defineParams, function(m4, param, v) {
                    def[code] = {
                      arg: param,
                      text: v
                    };
                  });
                }
                if (!(code in def)) {
                  def[code] = value;
                }
              } else {
                new Function('def', 'def[\'' + code + '\']=' + value)(def);
              }
            }
            return '';
          }).replace(c4.use || skip, function(m3, code) {
            if (c4.useParams) {
              code = code.replace(c4.useParams, function(m4, s, d2, param) {
                if (def[d2] && def[d2].arg && param) {
                  var rw = (d2 + ':' + param).replace(/'|\\/g, '_');
                  def.__exp = def.__exp || {};
                  def.__exp[rw] = def[d2].text.replace(new RegExp('(^|[^\\w$])' + def[d2].arg + '([^\\w$])', 'g'), '$1' + param + '$2');
                  return s + 'def.__exp[\'' + rw + '\']';
                }
              });
            }
            var v = new Function('def', 'return ' + code)(def);
            return v ? resolveDefs(c4, v, def) : v;
          });
        }
        function unescape(code) {
          return code.replace(/\\('|\\)/g, '$1').replace(/[\r\t\n]/g, ' ');
        }
        doT3.template = function(tmpl, c4, def) {
          c4 = c4 || doT3.templateSettings;
          var cse = c4.append ? startend.append : startend.split, needhtmlencode, sid = 0, indv, str = c4.use || c4.define ? resolveDefs(c4, tmpl, def || {}) : tmpl;
          str = ('var out=\'' + (c4.strip ? str.replace(/(^|\r|\n)\t* +| +\t*(\r|\n|$)/g, ' ').replace(/\r|\n|\t|\/\*[\s\S]*?\*\//g, '') : str).replace(/'|\\/g, '\\$&').replace(c4.interpolate || skip, function(m3, code) {
            return cse.start + unescape(code) + cse.end;
          }).replace(c4.encode || skip, function(m3, code) {
            needhtmlencode = true;
            return cse.startencode + unescape(code) + cse.end;
          }).replace(c4.conditional || skip, function(m3, elsecase, code) {
            return elsecase ? code ? '\';}else if(' + unescape(code) + '){out+=\'' : '\';}else{out+=\'' : code ? '\';if(' + unescape(code) + '){out+=\'' : '\';}out+=\'';
          }).replace(c4.iterate || skip, function(m3, iterate, vname, iname) {
            if (!iterate) {
              return '\';} } out+=\'';
            }
            sid += 1;
            indv = iname || 'i' + sid;
            iterate = unescape(iterate);
            return '\';var arr' + sid + '=' + iterate + ';if(arr' + sid + '){var ' + vname + ',' + indv + '=-1,l' + sid + '=arr' + sid + '.length-1;while(' + indv + '<l' + sid + '){' + vname + '=arr' + sid + '[' + indv + '+=1];out+=\'';
          }).replace(c4.evaluate || skip, function(m3, code) {
            return '\';' + unescape(code) + 'out+=\'';
          }) + '\';return out;').replace(/\n/g, '\\n').replace(/\t/g, '\\t').replace(/\r/g, '\\r').replace(/(\s|;|\}|^|\{)out\+='';/g, '$1').replace(/\+''/g, '');
          if (needhtmlencode) {
            if (!c4.selfcontained && globalThis && !globalThis._encodeHTML) {
              globalThis._encodeHTML = doT3.encodeHTMLSource(c4.doNotSkipEncoded);
            }
            str = 'var encodeHTML = typeof _encodeHTML !== \'undefined\' ? _encodeHTML : (' + doT3.encodeHTMLSource.toString() + '(' + (c4.doNotSkipEncoded || '') + '));' + str;
          }
          try {
            return new Function(c4.varname, str);
          } catch (e) {
            if (typeof console !== 'undefined') {
              console.log('Could not create a template function: ' + str);
            }
            throw e;
          }
        };
        doT3.compile = function(tmpl, def) {
          return doT3.template(tmpl, null, def);
        };
      })();
    });
    var require_es6_promise = __commonJS(function(exports, module) {
      (function(global2, factory) {
        _typeof(exports) === 'object' && typeof module !== 'undefined' ? module.exports = factory() :  true ? !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
      })(exports, function() {
        'use strict';
        function objectOrFunction(x) {
          var type2 = _typeof(x);
          return x !== null && (type2 === 'object' || type2 === 'function');
        }
        function isFunction(x) {
          return typeof x === 'function';
        }
        var _isArray = void 0;
        if (Array.isArray) {
          _isArray = Array.isArray;
        } else {
          _isArray = function _isArray(x) {
            return Object.prototype.toString.call(x) === '[object Array]';
          };
        }
        var isArray = _isArray;
        var len = 0;
        var vertxNext = void 0;
        var customSchedulerFn = void 0;
        var asap = function asap2(callback, arg) {
          queue2[len] = callback;
          queue2[len + 1] = arg;
          len += 2;
          if (len === 2) {
            if (customSchedulerFn) {
              customSchedulerFn(flush);
            } else {
              scheduleFlush();
            }
          }
        };
        function setScheduler(scheduleFn) {
          customSchedulerFn = scheduleFn;
        }
        function setAsap(asapFn) {
          asap = asapFn;
        }
        var browserWindow = typeof window !== 'undefined' ? window : void 0;
        var browserGlobal = browserWindow || {};
        var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
        var isNode2 = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
        var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
        function useNextTick() {
          return function() {
            return process.nextTick(flush);
          };
        }
        function useVertxTimer() {
          if (typeof vertxNext !== 'undefined') {
            return function() {
              vertxNext(flush);
            };
          }
          return useSetTimeout();
        }
        function useMutationObserver() {
          var iterations = 0;
          var observer = new BrowserMutationObserver(flush);
          var node = document.createTextNode('');
          observer.observe(node, {
            characterData: true
          });
          return function() {
            node.data = iterations = ++iterations % 2;
          };
        }
        function useMessageChannel() {
          var channel = new MessageChannel();
          channel.port1.onmessage = flush;
          return function() {
            return channel.port2.postMessage(0);
          };
        }
        function useSetTimeout() {
          var globalSetTimeout = setTimeout;
          return function() {
            return globalSetTimeout(flush, 1);
          };
        }
        var queue2 = new Array(1e3);
        function flush() {
          for (var i = 0; i < len; i += 2) {
            var callback = queue2[i];
            var arg = queue2[i + 1];
            callback(arg);
            queue2[i] = void 0;
            queue2[i + 1] = void 0;
          }
          len = 0;
        }
        function attemptVertx() {
          try {
            var vertx = Function('return this')().require('vertx');
            vertxNext = vertx.runOnLoop || vertx.runOnContext;
            return useVertxTimer();
          } catch (e) {
            return useSetTimeout();
          }
        }
        var scheduleFlush = void 0;
        if (isNode2) {
          scheduleFlush = useNextTick();
        } else if (BrowserMutationObserver) {
          scheduleFlush = useMutationObserver();
        } else if (isWorker) {
          scheduleFlush = useMessageChannel();
        } else if (browserWindow === void 0 && true) {
          scheduleFlush = attemptVertx();
        } else {
          scheduleFlush = useSetTimeout();
        }
        function then(onFulfillment, onRejection) {
          var parent = this;
          var child = new this.constructor(noop3);
          if (child[PROMISE_ID] === void 0) {
            makePromise(child);
          }
          var _state = parent._state;
          if (_state) {
            var callback = arguments[_state - 1];
            asap(function() {
              return invokeCallback(_state, child, callback, parent._result);
            });
          } else {
            subscribe2(parent, child, onFulfillment, onRejection);
          }
          return child;
        }
        function resolve$1(object) {
          var Constructor = this;
          if (object && _typeof(object) === 'object' && object.constructor === Constructor) {
            return object;
          }
          var promise = new Constructor(noop3);
          resolve(promise, object);
          return promise;
        }
        var PROMISE_ID = Math.random().toString(36).substring(2);
        function noop3() {}
        var PENDING = void 0;
        var FULFILLED = 1;
        var REJECTED = 2;
        function selfFulfillment() {
          return new TypeError('You cannot resolve a promise with itself');
        }
        function cannotReturnOwn() {
          return new TypeError('A promises callback cannot return that same promise.');
        }
        function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
          try {
            then$$1.call(value, fulfillmentHandler, rejectionHandler);
          } catch (e) {
            return e;
          }
        }
        function handleForeignThenable(promise, thenable, then$$1) {
          asap(function(promise2) {
            var sealed = false;
            var error = tryThen(then$$1, thenable, function(value) {
              if (sealed) {
                return;
              }
              sealed = true;
              if (thenable !== value) {
                resolve(promise2, value);
              } else {
                fulfill(promise2, value);
              }
            }, function(reason) {
              if (sealed) {
                return;
              }
              sealed = true;
              reject(promise2, reason);
            }, 'Settle: ' + (promise2._label || ' unknown promise'));
            if (!sealed && error) {
              sealed = true;
              reject(promise2, error);
            }
          }, promise);
        }
        function handleOwnThenable(promise, thenable) {
          if (thenable._state === FULFILLED) {
            fulfill(promise, thenable._result);
          } else if (thenable._state === REJECTED) {
            reject(promise, thenable._result);
          } else {
            subscribe2(thenable, void 0, function(value) {
              return resolve(promise, value);
            }, function(reason) {
              return reject(promise, reason);
            });
          }
        }
        function handleMaybeThenable(promise, maybeThenable, then$$1) {
          if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
            handleOwnThenable(promise, maybeThenable);
          } else {
            if (then$$1 === void 0) {
              fulfill(promise, maybeThenable);
            } else if (isFunction(then$$1)) {
              handleForeignThenable(promise, maybeThenable, then$$1);
            } else {
              fulfill(promise, maybeThenable);
            }
          }
        }
        function resolve(promise, value) {
          if (promise === value) {
            reject(promise, selfFulfillment());
          } else if (objectOrFunction(value)) {
            var then$$1 = void 0;
            try {
              then$$1 = value.then;
            } catch (error) {
              reject(promise, error);
              return;
            }
            handleMaybeThenable(promise, value, then$$1);
          } else {
            fulfill(promise, value);
          }
        }
        function publishRejection(promise) {
          if (promise._onerror) {
            promise._onerror(promise._result);
          }
          publish(promise);
        }
        function fulfill(promise, value) {
          if (promise._state !== PENDING) {
            return;
          }
          promise._result = value;
          promise._state = FULFILLED;
          if (promise._subscribers.length !== 0) {
            asap(publish, promise);
          }
        }
        function reject(promise, reason) {
          if (promise._state !== PENDING) {
            return;
          }
          promise._state = REJECTED;
          promise._result = reason;
          asap(publishRejection, promise);
        }
        function subscribe2(parent, child, onFulfillment, onRejection) {
          var _subscribers = parent._subscribers;
          var length = _subscribers.length;
          parent._onerror = null;
          _subscribers[length] = child;
          _subscribers[length + FULFILLED] = onFulfillment;
          _subscribers[length + REJECTED] = onRejection;
          if (length === 0 && parent._state) {
            asap(publish, parent);
          }
        }
        function publish(promise) {
          var subscribers = promise._subscribers;
          var settled = promise._state;
          if (subscribers.length === 0) {
            return;
          }
          var child = void 0, callback = void 0, detail = promise._result;
          for (var i = 0; i < subscribers.length; i += 3) {
            child = subscribers[i];
            callback = subscribers[i + settled];
            if (child) {
              invokeCallback(settled, child, callback, detail);
            } else {
              callback(detail);
            }
          }
          promise._subscribers.length = 0;
        }
        function invokeCallback(settled, promise, callback, detail) {
          var hasCallback = isFunction(callback), value = void 0, error = void 0, succeeded = true;
          if (hasCallback) {
            try {
              value = callback(detail);
            } catch (e) {
              succeeded = false;
              error = e;
            }
            if (promise === value) {
              reject(promise, cannotReturnOwn());
              return;
            }
          } else {
            value = detail;
          }
          if (promise._state !== PENDING) {} else if (hasCallback && succeeded) {
            resolve(promise, value);
          } else if (succeeded === false) {
            reject(promise, error);
          } else if (settled === FULFILLED) {
            fulfill(promise, value);
          } else if (settled === REJECTED) {
            reject(promise, value);
          }
        }
        function initializePromise(promise, resolver) {
          try {
            resolver(function resolvePromise(value) {
              resolve(promise, value);
            }, function rejectPromise(reason) {
              reject(promise, reason);
            });
          } catch (e) {
            reject(promise, e);
          }
        }
        var id = 0;
        function nextId() {
          return id++;
        }
        function makePromise(promise) {
          promise[PROMISE_ID] = id++;
          promise._state = void 0;
          promise._result = void 0;
          promise._subscribers = [];
        }
        function validationError() {
          return new Error('Array Methods must be provided an Array');
        }
        var Enumerator = function() {
          function Enumerator2(Constructor, input) {
            this._instanceConstructor = Constructor;
            this.promise = new Constructor(noop3);
            if (!this.promise[PROMISE_ID]) {
              makePromise(this.promise);
            }
            if (isArray(input)) {
              this.length = input.length;
              this._remaining = input.length;
              this._result = new Array(this.length);
              if (this.length === 0) {
                fulfill(this.promise, this._result);
              } else {
                this.length = this.length || 0;
                this._enumerate(input);
                if (this._remaining === 0) {
                  fulfill(this.promise, this._result);
                }
              }
            } else {
              reject(this.promise, validationError());
            }
          }
          Enumerator2.prototype._enumerate = function _enumerate(input) {
            for (var i = 0; this._state === PENDING && i < input.length; i++) {
              this._eachEntry(input[i], i);
            }
          };
          Enumerator2.prototype._eachEntry = function _eachEntry(entry, i) {
            var c4 = this._instanceConstructor;
            var resolve$$1 = c4.resolve;
            if (resolve$$1 === resolve$1) {
              var _then = void 0;
              var error = void 0;
              var didError = false;
              try {
                _then = entry.then;
              } catch (e) {
                didError = true;
                error = e;
              }
              if (_then === then && entry._state !== PENDING) {
                this._settledAt(entry._state, i, entry._result);
              } else if (typeof _then !== 'function') {
                this._remaining--;
                this._result[i] = entry;
              } else if (c4 === Promise$1) {
                var promise = new c4(noop3);
                if (didError) {
                  reject(promise, error);
                } else {
                  handleMaybeThenable(promise, entry, _then);
                }
                this._willSettleAt(promise, i);
              } else {
                this._willSettleAt(new c4(function(resolve$$12) {
                  return resolve$$12(entry);
                }), i);
              }
            } else {
              this._willSettleAt(resolve$$1(entry), i);
            }
          };
          Enumerator2.prototype._settledAt = function _settledAt(state, i, value) {
            var promise = this.promise;
            if (promise._state === PENDING) {
              this._remaining--;
              if (state === REJECTED) {
                reject(promise, value);
              } else {
                this._result[i] = value;
              }
            }
            if (this._remaining === 0) {
              fulfill(promise, this._result);
            }
          };
          Enumerator2.prototype._willSettleAt = function _willSettleAt(promise, i) {
            var enumerator = this;
            subscribe2(promise, void 0, function(value) {
              return enumerator._settledAt(FULFILLED, i, value);
            }, function(reason) {
              return enumerator._settledAt(REJECTED, i, reason);
            });
          };
          return Enumerator2;
        }();
        function all(entries) {
          return new Enumerator(this, entries).promise;
        }
        function race(entries) {
          var Constructor = this;
          if (!isArray(entries)) {
            return new Constructor(function(_, reject2) {
              return reject2(new TypeError('You must pass an array to race.'));
            });
          } else {
            return new Constructor(function(resolve2, reject2) {
              var length = entries.length;
              for (var i = 0; i < length; i++) {
                Constructor.resolve(entries[i]).then(resolve2, reject2);
              }
            });
          }
        }
        function reject$1(reason) {
          var Constructor = this;
          var promise = new Constructor(noop3);
          reject(promise, reason);
          return promise;
        }
        function needsResolver() {
          throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
        }
        function needsNew() {
          throw new TypeError('Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.');
        }
        var Promise$1 = function() {
          function Promise2(resolver) {
            this[PROMISE_ID] = nextId();
            this._result = this._state = void 0;
            this._subscribers = [];
            if (noop3 !== resolver) {
              typeof resolver !== 'function' && needsResolver();
              this instanceof Promise2 ? initializePromise(this, resolver) : needsNew();
            }
          }
          Promise2.prototype['catch'] = function _catch(onRejection) {
            return this.then(null, onRejection);
          };
          Promise2.prototype['finally'] = function _finally(callback) {
            var promise = this;
            var constructor = promise.constructor;
            if (isFunction(callback)) {
              return promise.then(function(value) {
                return constructor.resolve(callback()).then(function() {
                  return value;
                });
              }, function(reason) {
                return constructor.resolve(callback()).then(function() {
                  throw reason;
                });
              });
            }
            return promise.then(callback, callback);
          };
          return Promise2;
        }();
        Promise$1.prototype.then = then;
        Promise$1.all = all;
        Promise$1.race = race;
        Promise$1.resolve = resolve$1;
        Promise$1.reject = reject$1;
        Promise$1._setScheduler = setScheduler;
        Promise$1._setAsap = setAsap;
        Promise$1._asap = asap;
        function polyfill() {
          var local = void 0;
          if (typeof global !== 'undefined') {
            local = global;
          } else if (typeof self !== 'undefined') {
            local = self;
          } else {
            try {
              local = Function('return this')();
            } catch (e) {
              throw new Error('polyfill failed because global object is unavailable in this environment');
            }
          }
          var P = local.Promise;
          if (P) {
            var promiseToString = null;
            try {
              promiseToString = Object.prototype.toString.call(P.resolve());
            } catch (e) {}
            if (promiseToString === '[object Promise]' && !P.cast) {
              return;
            }
          }
          local.Promise = Promise$1;
        }
        Promise$1.polyfill = polyfill;
        Promise$1.Promise = Promise$1;
        return Promise$1;
      });
    });
    var require_typedarray = __commonJS(function(exports) {
      var MAX_ARRAY_LENGTH = 1e5;
      var ECMAScript = function() {
        var opts = Object.prototype.toString;
        var ophop = Object.prototype.hasOwnProperty;
        return {
          Class: function Class(v) {
            return opts.call(v).replace(/^\[object *|\]$/g, '');
          },
          HasProperty: function HasProperty(o, p2) {
            return p2 in o;
          },
          HasOwnProperty: function HasOwnProperty(o, p2) {
            return ophop.call(o, p2);
          },
          IsCallable: function IsCallable(o) {
            return typeof o === 'function';
          },
          ToInt32: function ToInt32(v) {
            return v >> 0;
          },
          ToUint32: function ToUint32(v) {
            return v >>> 0;
          }
        };
      }();
      var LN2 = Math.LN2;
      var abs = Math.abs;
      var floor = Math.floor;
      var log2 = Math.log;
      var min = Math.min;
      var pow = Math.pow;
      var round = Math.round;
      function clamp3(v, minimum, max2) {
        return v < minimum ? minimum : v > max2 ? max2 : v;
      }
      var getOwnPropNames = Object.getOwnPropertyNames || function(o) {
        if (o !== Object(o)) {
          throw new TypeError('Object.getOwnPropertyNames called on non-object');
        }
        var props = [], p2;
        for (p2 in o) {
          if (ECMAScript.HasOwnProperty(o, p2)) {
            props.push(p2);
          }
        }
        return props;
      };
      var defineProp;
      if (Object.defineProperty && function() {
        try {
          Object.defineProperty({}, 'x', {});
          return true;
        } catch (e) {
          return false;
        }
      }()) {
        defineProp = Object.defineProperty;
      } else {
        defineProp = function defineProp(o, p2, desc) {
          if (!o === Object(o)) {
            throw new TypeError('Object.defineProperty called on non-object');
          }
          if (ECMAScript.HasProperty(desc, 'get') && Object.prototype.__defineGetter__) {
            Object.prototype.__defineGetter__.call(o, p2, desc.get);
          }
          if (ECMAScript.HasProperty(desc, 'set') && Object.prototype.__defineSetter__) {
            Object.prototype.__defineSetter__.call(o, p2, desc.set);
          }
          if (ECMAScript.HasProperty(desc, 'value')) {
            o[p2] = desc.value;
          }
          return o;
        };
      }
      function configureProperties(obj) {
        if (getOwnPropNames && defineProp) {
          var props = getOwnPropNames(obj), i;
          for (i = 0; i < props.length; i += 1) {
            defineProp(obj, props[i], {
              value: obj[props[i]],
              writable: false,
              enumerable: false,
              configurable: false
            });
          }
        }
      }
      function makeArrayAccessors(obj) {
        if (!defineProp) {
          return;
        }
        if (obj.length > MAX_ARRAY_LENGTH) {
          throw new RangeError('Array too large for polyfill');
        }
        function makeArrayAccessor(index) {
          defineProp(obj, index, {
            get: function get() {
              return obj._getter(index);
            },
            set: function set(v) {
              obj._setter(index, v);
            },
            enumerable: true,
            configurable: false
          });
        }
        var i;
        for (i = 0; i < obj.length; i += 1) {
          makeArrayAccessor(i);
        }
      }
      function as_signed(value, bits) {
        var s = 32 - bits;
        return value << s >> s;
      }
      function as_unsigned(value, bits) {
        var s = 32 - bits;
        return value << s >>> s;
      }
      function packI8(n2) {
        return [ n2 & 255 ];
      }
      function unpackI8(bytes) {
        return as_signed(bytes[0], 8);
      }
      function packU8(n2) {
        return [ n2 & 255 ];
      }
      function unpackU8(bytes) {
        return as_unsigned(bytes[0], 8);
      }
      function packU8Clamped(n2) {
        n2 = round(Number(n2));
        return [ n2 < 0 ? 0 : n2 > 255 ? 255 : n2 & 255 ];
      }
      function packI16(n2) {
        return [ n2 >> 8 & 255, n2 & 255 ];
      }
      function unpackI16(bytes) {
        return as_signed(bytes[0] << 8 | bytes[1], 16);
      }
      function packU16(n2) {
        return [ n2 >> 8 & 255, n2 & 255 ];
      }
      function unpackU16(bytes) {
        return as_unsigned(bytes[0] << 8 | bytes[1], 16);
      }
      function packI32(n2) {
        return [ n2 >> 24 & 255, n2 >> 16 & 255, n2 >> 8 & 255, n2 & 255 ];
      }
      function unpackI32(bytes) {
        return as_signed(bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], 32);
      }
      function packU32(n2) {
        return [ n2 >> 24 & 255, n2 >> 16 & 255, n2 >> 8 & 255, n2 & 255 ];
      }
      function unpackU32(bytes) {
        return as_unsigned(bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], 32);
      }
      function packIEEE754(v, ebits, fbits) {
        var bias = (1 << ebits - 1) - 1;
        var s, e, f, i, bits, str, bytes;
        function roundToEven(n2) {
          var w = floor(n2);
          var fl = n2 - w;
          if (fl < .5) {
            return w;
          }
          if (fl > .5) {
            return w + 1;
          }
          return w % 2 ? w + 1 : w;
        }
        if (v !== v) {
          e = (1 << ebits) - 1;
          f = pow(2, fbits - 1);
          s = 0;
        } else if (v === Infinity || v === -Infinity) {
          e = (1 << ebits) - 1;
          f = 0;
          s = v < 0 ? 1 : 0;
        } else if (v === 0) {
          e = 0;
          f = 0;
          s = 1 / v === -Infinity ? 1 : 0;
        } else {
          s = v < 0;
          v = abs(v);
          if (v >= pow(2, 1 - bias)) {
            e = min(floor(log2(v) / LN2), 1023);
            f = roundToEven(v / pow(2, e) * pow(2, fbits));
            if (f / pow(2, fbits) >= 2) {
              e = e + 1;
              f = 1;
            }
            if (e > bias) {
              e = (1 << ebits) - 1;
              f = 0;
            } else {
              e = e + bias;
              f = f - pow(2, fbits);
            }
          } else {
            e = 0;
            f = roundToEven(v / pow(2, 1 - bias - fbits));
          }
        }
        bits = [];
        for (i = fbits; i; i -= 1) {
          bits.push(f % 2 ? 1 : 0);
          f = floor(f / 2);
        }
        for (i = ebits; i; i -= 1) {
          bits.push(e % 2 ? 1 : 0);
          e = floor(e / 2);
        }
        bits.push(s ? 1 : 0);
        bits.reverse();
        str = bits.join('');
        bytes = [];
        while (str.length) {
          bytes.push(parseInt(str.substring(0, 8), 2));
          str = str.substring(8);
        }
        return bytes;
      }
      function unpackIEEE754(bytes, ebits, fbits) {
        var bits = [], i, j, b2, str, bias, s, e, f;
        for (i = bytes.length; i; i -= 1) {
          b2 = bytes[i - 1];
          for (j = 8; j; j -= 1) {
            bits.push(b2 % 2 ? 1 : 0);
            b2 = b2 >> 1;
          }
        }
        bits.reverse();
        str = bits.join('');
        bias = (1 << ebits - 1) - 1;
        s = parseInt(str.substring(0, 1), 2) ? -1 : 1;
        e = parseInt(str.substring(1, 1 + ebits), 2);
        f = parseInt(str.substring(1 + ebits), 2);
        if (e === (1 << ebits) - 1) {
          return f === 0 ? s * Infinity : NaN;
        } else if (e > 0) {
          return s * pow(2, e - bias) * (1 + f / pow(2, fbits));
        } else if (f !== 0) {
          return s * pow(2, -(bias - 1)) * (f / pow(2, fbits));
        }
        return s < 0 ? -0 : 0;
      }
      function unpackF64(b2) {
        return unpackIEEE754(b2, 11, 52);
      }
      function packF64(v) {
        return packIEEE754(v, 11, 52);
      }
      function unpackF32(b2) {
        return unpackIEEE754(b2, 8, 23);
      }
      function packF32(v) {
        return packIEEE754(v, 8, 23);
      }
      (function() {
        function ArrayBuffer(length) {
          length = ECMAScript.ToInt32(length);
          if (length < 0) {
            throw new RangeError('ArrayBuffer size is not a small enough positive integer');
          }
          this.byteLength = length;
          this._bytes = [];
          this._bytes.length = length;
          var i;
          for (i = 0; i < this.byteLength; i += 1) {
            this._bytes[i] = 0;
          }
          configureProperties(this);
        }
        exports.ArrayBuffer = exports.ArrayBuffer || ArrayBuffer;
        function ArrayBufferView() {}
        function makeConstructor(bytesPerElement, pack, unpack) {
          var _ctor;
          _ctor = function ctor(buffer, byteOffset, length) {
            var array, sequence, i, s;
            if (!arguments.length || typeof arguments[0] === 'number') {
              this.length = ECMAScript.ToInt32(arguments[0]);
              if (length < 0) {
                throw new RangeError('ArrayBufferView size is not a small enough positive integer');
              }
              this.byteLength = this.length * this.BYTES_PER_ELEMENT;
              this.buffer = new ArrayBuffer(this.byteLength);
              this.byteOffset = 0;
            } else if (_typeof(arguments[0]) === 'object' && arguments[0].constructor === _ctor) {
              array = arguments[0];
              this.length = array.length;
              this.byteLength = this.length * this.BYTES_PER_ELEMENT;
              this.buffer = new ArrayBuffer(this.byteLength);
              this.byteOffset = 0;
              for (i = 0; i < this.length; i += 1) {
                this._setter(i, array._getter(i));
              }
            } else if (_typeof(arguments[0]) === 'object' && !(arguments[0] instanceof ArrayBuffer || ECMAScript.Class(arguments[0]) === 'ArrayBuffer')) {
              sequence = arguments[0];
              this.length = ECMAScript.ToUint32(sequence.length);
              this.byteLength = this.length * this.BYTES_PER_ELEMENT;
              this.buffer = new ArrayBuffer(this.byteLength);
              this.byteOffset = 0;
              for (i = 0; i < this.length; i += 1) {
                s = sequence[i];
                this._setter(i, Number(s));
              }
            } else if (_typeof(arguments[0]) === 'object' && (arguments[0] instanceof ArrayBuffer || ECMAScript.Class(arguments[0]) === 'ArrayBuffer')) {
              this.buffer = buffer;
              this.byteOffset = ECMAScript.ToUint32(byteOffset);
              if (this.byteOffset > this.buffer.byteLength) {
                throw new RangeError('byteOffset out of range');
              }
              if (this.byteOffset % this.BYTES_PER_ELEMENT) {
                throw new RangeError('ArrayBuffer length minus the byteOffset is not a multiple of the element size.');
              }
              if (arguments.length < 3) {
                this.byteLength = this.buffer.byteLength - this.byteOffset;
                if (this.byteLength % this.BYTES_PER_ELEMENT) {
                  throw new RangeError('length of buffer minus byteOffset not a multiple of the element size');
                }
                this.length = this.byteLength / this.BYTES_PER_ELEMENT;
              } else {
                this.length = ECMAScript.ToUint32(length);
                this.byteLength = this.length * this.BYTES_PER_ELEMENT;
              }
              if (this.byteOffset + this.byteLength > this.buffer.byteLength) {
                throw new RangeError('byteOffset and length reference an area beyond the end of the buffer');
              }
            } else {
              throw new TypeError('Unexpected argument type(s)');
            }
            this.constructor = _ctor;
            configureProperties(this);
            makeArrayAccessors(this);
          };
          _ctor.prototype = new ArrayBufferView();
          _ctor.prototype.BYTES_PER_ELEMENT = bytesPerElement;
          _ctor.prototype._pack = pack;
          _ctor.prototype._unpack = unpack;
          _ctor.BYTES_PER_ELEMENT = bytesPerElement;
          _ctor.prototype._getter = function(index) {
            if (arguments.length < 1) {
              throw new SyntaxError('Not enough arguments');
            }
            index = ECMAScript.ToUint32(index);
            if (index >= this.length) {
              return void 0;
            }
            var bytes = [];
            for (var i = 0, o = this.byteOffset + index * this.BYTES_PER_ELEMENT; i < this.BYTES_PER_ELEMENT; i += 1, 
            o += 1) {
              bytes.push(this.buffer._bytes[o]);
            }
            return this._unpack(bytes);
          };
          _ctor.prototype.get = _ctor.prototype._getter;
          _ctor.prototype._setter = function(index, value) {
            if (arguments.length < 2) {
              throw new SyntaxError('Not enough arguments');
            }
            index = ECMAScript.ToUint32(index);
            if (index < this.length) {
              var bytes = this._pack(value);
              var i;
              var o;
              for (i = 0, o = this.byteOffset + index * this.BYTES_PER_ELEMENT; i < this.BYTES_PER_ELEMENT; i += 1, 
              o += 1) {
                this.buffer._bytes[o] = bytes[i];
              }
            }
          };
          _ctor.prototype.set = function(index, value) {
            if (arguments.length < 1) {
              throw new SyntaxError('Not enough arguments');
            }
            var array, sequence, offset, len, i, s, d2, byteOffset, byteLength, tmp;
            if (_typeof(arguments[0]) === 'object' && arguments[0].constructor === this.constructor) {
              array = arguments[0];
              offset = ECMAScript.ToUint32(arguments[1]);
              if (offset + array.length > this.length) {
                throw new RangeError('Offset plus length of array is out of range');
              }
              byteOffset = this.byteOffset + offset * this.BYTES_PER_ELEMENT;
              byteLength = array.length * this.BYTES_PER_ELEMENT;
              if (array.buffer === this.buffer) {
                tmp = [];
                for (i = 0, s = array.byteOffset; i < byteLength; i += 1, s += 1) {
                  tmp[i] = array.buffer._bytes[s];
                }
                for (i = 0, d2 = byteOffset; i < byteLength; i += 1, d2 += 1) {
                  this.buffer._bytes[d2] = tmp[i];
                }
              } else {
                for (i = 0, s = array.byteOffset, d2 = byteOffset; i < byteLength; i += 1, 
                s += 1, d2 += 1) {
                  this.buffer._bytes[d2] = array.buffer._bytes[s];
                }
              }
            } else if (_typeof(arguments[0]) === 'object' && typeof arguments[0].length !== 'undefined') {
              sequence = arguments[0];
              len = ECMAScript.ToUint32(sequence.length);
              offset = ECMAScript.ToUint32(arguments[1]);
              if (offset + len > this.length) {
                throw new RangeError('Offset plus length of array is out of range');
              }
              for (i = 0; i < len; i += 1) {
                s = sequence[i];
                this._setter(offset + i, Number(s));
              }
            } else {
              throw new TypeError('Unexpected argument type(s)');
            }
          };
          _ctor.prototype.subarray = function(start, end) {
            start = ECMAScript.ToInt32(start);
            end = ECMAScript.ToInt32(end);
            if (arguments.length < 1) {
              start = 0;
            }
            if (arguments.length < 2) {
              end = this.length;
            }
            if (start < 0) {
              start = this.length + start;
            }
            if (end < 0) {
              end = this.length + end;
            }
            start = clamp3(start, 0, this.length);
            end = clamp3(end, 0, this.length);
            var len = end - start;
            if (len < 0) {
              len = 0;
            }
            return new this.constructor(this.buffer, this.byteOffset + start * this.BYTES_PER_ELEMENT, len);
          };
          return _ctor;
        }
        var Int8Array = makeConstructor(1, packI8, unpackI8);
        var Uint8Array2 = makeConstructor(1, packU8, unpackU8);
        var Uint8ClampedArray2 = makeConstructor(1, packU8Clamped, unpackU8);
        var Int16Array = makeConstructor(2, packI16, unpackI16);
        var Uint16Array = makeConstructor(2, packU16, unpackU16);
        var Int32Array = makeConstructor(4, packI32, unpackI32);
        var Uint32Array3 = makeConstructor(4, packU32, unpackU32);
        var Float32Array = makeConstructor(4, packF32, unpackF32);
        var Float64Array = makeConstructor(8, packF64, unpackF64);
        exports.Int8Array = exports.Int8Array || Int8Array;
        exports.Uint8Array = exports.Uint8Array || Uint8Array2;
        exports.Uint8ClampedArray = exports.Uint8ClampedArray || Uint8ClampedArray2;
        exports.Int16Array = exports.Int16Array || Int16Array;
        exports.Uint16Array = exports.Uint16Array || Uint16Array;
        exports.Int32Array = exports.Int32Array || Int32Array;
        exports.Uint32Array = exports.Uint32Array || Uint32Array3;
        exports.Float32Array = exports.Float32Array || Float32Array;
        exports.Float64Array = exports.Float64Array || Float64Array;
      })();
      (function() {
        function r(array, index) {
          return ECMAScript.IsCallable(array.get) ? array.get(index) : array[index];
        }
        var IS_BIG_ENDIAN = function() {
          var u16array = new exports.Uint16Array([ 4660 ]), u8array = new exports.Uint8Array(u16array.buffer);
          return r(u8array, 0) === 18;
        }();
        function DataView(buffer, byteOffset, byteLength) {
          if (arguments.length === 0) {
            buffer = new exports.ArrayBuffer(0);
          } else if (!(buffer instanceof exports.ArrayBuffer || ECMAScript.Class(buffer) === 'ArrayBuffer')) {
            throw new TypeError('TypeError');
          }
          this.buffer = buffer || new exports.ArrayBuffer(0);
          this.byteOffset = ECMAScript.ToUint32(byteOffset);
          if (this.byteOffset > this.buffer.byteLength) {
            throw new RangeError('byteOffset out of range');
          }
          if (arguments.length < 3) {
            this.byteLength = this.buffer.byteLength - this.byteOffset;
          } else {
            this.byteLength = ECMAScript.ToUint32(byteLength);
          }
          if (this.byteOffset + this.byteLength > this.buffer.byteLength) {
            throw new RangeError('byteOffset and length reference an area beyond the end of the buffer');
          }
          configureProperties(this);
        }
        function makeGetter(arrayType) {
          return function(byteOffset, littleEndian) {
            byteOffset = ECMAScript.ToUint32(byteOffset);
            if (byteOffset + arrayType.BYTES_PER_ELEMENT > this.byteLength) {
              throw new RangeError('Array index out of range');
            }
            byteOffset += this.byteOffset;
            var uint8Array = new exports.Uint8Array(this.buffer, byteOffset, arrayType.BYTES_PER_ELEMENT), bytes = [], i;
            for (i = 0; i < arrayType.BYTES_PER_ELEMENT; i += 1) {
              bytes.push(r(uint8Array, i));
            }
            if (Boolean(littleEndian) === Boolean(IS_BIG_ENDIAN)) {
              bytes.reverse();
            }
            return r(new arrayType(new exports.Uint8Array(bytes).buffer), 0);
          };
        }
        DataView.prototype.getUint8 = makeGetter(exports.Uint8Array);
        DataView.prototype.getInt8 = makeGetter(exports.Int8Array);
        DataView.prototype.getUint16 = makeGetter(exports.Uint16Array);
        DataView.prototype.getInt16 = makeGetter(exports.Int16Array);
        DataView.prototype.getUint32 = makeGetter(exports.Uint32Array);
        DataView.prototype.getInt32 = makeGetter(exports.Int32Array);
        DataView.prototype.getFloat32 = makeGetter(exports.Float32Array);
        DataView.prototype.getFloat64 = makeGetter(exports.Float64Array);
        function makeSetter(arrayType) {
          return function(byteOffset, value, littleEndian) {
            byteOffset = ECMAScript.ToUint32(byteOffset);
            if (byteOffset + arrayType.BYTES_PER_ELEMENT > this.byteLength) {
              throw new RangeError('Array index out of range');
            }
            var typeArray = new arrayType([ value ]), byteArray = new exports.Uint8Array(typeArray.buffer), bytes = [], i, byteView;
            for (i = 0; i < arrayType.BYTES_PER_ELEMENT; i += 1) {
              bytes.push(r(byteArray, i));
            }
            if (Boolean(littleEndian) === Boolean(IS_BIG_ENDIAN)) {
              bytes.reverse();
            }
            byteView = new exports.Uint8Array(this.buffer, byteOffset, arrayType.BYTES_PER_ELEMENT);
            byteView.set(bytes);
          };
        }
        DataView.prototype.setUint8 = makeSetter(exports.Uint8Array);
        DataView.prototype.setInt8 = makeSetter(exports.Int8Array);
        DataView.prototype.setUint16 = makeSetter(exports.Uint16Array);
        DataView.prototype.setInt16 = makeSetter(exports.Int16Array);
        DataView.prototype.setUint32 = makeSetter(exports.Uint32Array);
        DataView.prototype.setInt32 = makeSetter(exports.Int32Array);
        DataView.prototype.setFloat32 = makeSetter(exports.Float32Array);
        DataView.prototype.setFloat64 = makeSetter(exports.Float64Array);
        exports.DataView = exports.DataView || DataView;
      })();
    });
    var require_weakmap_polyfill = __commonJS(function(exports) {
      (function(self2) {
        'use strict';
        if (self2.WeakMap) {
          return;
        }
        var hasOwnProperty2 = Object.prototype.hasOwnProperty;
        var hasDefine = Object.defineProperty && function() {
          try {
            return Object.defineProperty({}, 'x', {
              value: 1
            }).x === 1;
          } catch (e) {}
        }();
        var defineProperty = function defineProperty(object, name, value) {
          if (hasDefine) {
            Object.defineProperty(object, name, {
              configurable: true,
              writable: true,
              value: value
            });
          } else {
            object[name] = value;
          }
        };
        self2.WeakMap = function() {
          function WeakMap2() {
            if (this === void 0) {
              throw new TypeError('Constructor WeakMap requires \'new\'');
            }
            defineProperty(this, '_id', genId('_WeakMap'));
            if (arguments.length > 0) {
              throw new TypeError('WeakMap iterable is not supported');
            }
          }
          defineProperty(WeakMap2.prototype, 'delete', function(key) {
            checkInstance(this, 'delete');
            if (!isObject(key)) {
              return false;
            }
            var entry = key[this._id];
            if (entry && entry[0] === key) {
              delete key[this._id];
              return true;
            }
            return false;
          });
          defineProperty(WeakMap2.prototype, 'get', function(key) {
            checkInstance(this, 'get');
            if (!isObject(key)) {
              return void 0;
            }
            var entry = key[this._id];
            if (entry && entry[0] === key) {
              return entry[1];
            }
            return void 0;
          });
          defineProperty(WeakMap2.prototype, 'has', function(key) {
            checkInstance(this, 'has');
            if (!isObject(key)) {
              return false;
            }
            var entry = key[this._id];
            if (entry && entry[0] === key) {
              return true;
            }
            return false;
          });
          defineProperty(WeakMap2.prototype, 'set', function(key, value) {
            checkInstance(this, 'set');
            if (!isObject(key)) {
              throw new TypeError('Invalid value used as weak map key');
            }
            var entry = key[this._id];
            if (entry && entry[0] === key) {
              entry[1] = value;
              return this;
            }
            defineProperty(key, this._id, [ key, value ]);
            return this;
          });
          function checkInstance(x, methodName) {
            if (!isObject(x) || !hasOwnProperty2.call(x, '_id')) {
              throw new TypeError(methodName + ' method called on incompatible receiver ' + _typeof(x));
            }
          }
          function genId(prefix) {
            return prefix + '_' + rand() + '.' + rand();
          }
          function rand() {
            return Math.random().toString().substring(2);
          }
          defineProperty(WeakMap2, '_polyfill', true);
          return WeakMap2;
        }();
        function isObject(x) {
          return Object(x) === x;
        }
      })(typeof globalThis !== 'undefined' ? globalThis : typeof self !== 'undefined' ? self : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : exports);
    });
    var require_global = __commonJS(function(exports, module) {
      var check = function check(it) {
        return it && it.Math == Math && it;
      };
      module.exports = check((typeof globalThis === 'undefined' ? 'undefined' : _typeof(globalThis)) == 'object' && globalThis) || check((typeof window === 'undefined' ? 'undefined' : _typeof(window)) == 'object' && window) || check((typeof self === 'undefined' ? 'undefined' : _typeof(self)) == 'object' && self) || check((typeof global === 'undefined' ? 'undefined' : _typeof(global)) == 'object' && global) || function() {
        return this;
      }() || Function('return this')();
    });
    var require_fails = __commonJS(function(exports, module) {
      module.exports = function(exec) {
        try {
          return !!exec();
        } catch (error) {
          return true;
        }
      };
    });
    var require_function_bind_native = __commonJS(function(exports, module) {
      var fails = require_fails();
      module.exports = !fails(function() {
        var test = function() {}.bind();
        return typeof test != 'function' || test.hasOwnProperty('prototype');
      });
    });
    var require_function_apply = __commonJS(function(exports, module) {
      var NATIVE_BIND = require_function_bind_native();
      var FunctionPrototype = Function.prototype;
      var apply = FunctionPrototype.apply;
      var call = FunctionPrototype.call;
      module.exports = (typeof Reflect === 'undefined' ? 'undefined' : _typeof(Reflect)) == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function() {
        return call.apply(apply, arguments);
      });
    });
    var require_function_uncurry_this = __commonJS(function(exports, module) {
      var NATIVE_BIND = require_function_bind_native();
      var FunctionPrototype = Function.prototype;
      var call = FunctionPrototype.call;
      var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);
      module.exports = NATIVE_BIND ? uncurryThisWithBind : function(fn) {
        return function() {
          return call.apply(fn, arguments);
        };
      };
    });
    var require_classof_raw = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this();
      var toString = uncurryThis({}.toString);
      var stringSlice = uncurryThis(''.slice);
      module.exports = function(it) {
        return stringSlice(toString(it), 8, -1);
      };
    });
    var require_function_uncurry_this_clause = __commonJS(function(exports, module) {
      var classofRaw = require_classof_raw();
      var uncurryThis = require_function_uncurry_this();
      module.exports = function(fn) {
        if (classofRaw(fn) === 'Function') {
          return uncurryThis(fn);
        }
      };
    });
    var require_document_all = __commonJS(function(exports, module) {
      var documentAll = (typeof document === 'undefined' ? 'undefined' : _typeof(document)) == 'object' && document.all;
      var IS_HTMLDDA = typeof documentAll == 'undefined' && documentAll !== void 0;
      module.exports = {
        all: documentAll,
        IS_HTMLDDA: IS_HTMLDDA
      };
    });
    var require_is_callable2 = __commonJS(function(exports, module) {
      var $documentAll = require_document_all();
      var documentAll = $documentAll.all;
      module.exports = $documentAll.IS_HTMLDDA ? function(argument) {
        return typeof argument == 'function' || argument === documentAll;
      } : function(argument) {
        return typeof argument == 'function';
      };
    });
    var require_descriptors = __commonJS(function(exports, module) {
      var fails = require_fails();
      module.exports = !fails(function() {
        return Object.defineProperty({}, 1, {
          get: function get() {
            return 7;
          }
        })[1] != 7;
      });
    });
    var require_function_call = __commonJS(function(exports, module) {
      var NATIVE_BIND = require_function_bind_native();
      var call = Function.prototype.call;
      module.exports = NATIVE_BIND ? call.bind(call) : function() {
        return call.apply(call, arguments);
      };
    });
    var require_object_property_is_enumerable = __commonJS(function(exports) {
      'use strict';
      var $propertyIsEnumerable = {}.propertyIsEnumerable;
      var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
      var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({
        1: 2
      }, 1);
      exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
        var descriptor = getOwnPropertyDescriptor(this, V);
        return !!descriptor && descriptor.enumerable;
      } : $propertyIsEnumerable;
    });
    var require_create_property_descriptor = __commonJS(function(exports, module) {
      module.exports = function(bitmap, value) {
        return {
          enumerable: !(bitmap & 1),
          configurable: !(bitmap & 2),
          writable: !(bitmap & 4),
          value: value
        };
      };
    });
    var require_indexed_object = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this();
      var fails = require_fails();
      var classof = require_classof_raw();
      var $Object = Object;
      var split = uncurryThis(''.split);
      module.exports = fails(function() {
        return !$Object('z').propertyIsEnumerable(0);
      }) ? function(it) {
        return classof(it) == 'String' ? split(it, '') : $Object(it);
      } : $Object;
    });
    var require_is_null_or_undefined = __commonJS(function(exports, module) {
      module.exports = function(it) {
        return it === null || it === void 0;
      };
    });
    var require_require_object_coercible = __commonJS(function(exports, module) {
      var isNullOrUndefined = require_is_null_or_undefined();
      var $TypeError = TypeError;
      module.exports = function(it) {
        if (isNullOrUndefined(it)) {
          throw $TypeError('Can\'t call method on ' + it);
        }
        return it;
      };
    });
    var require_to_indexed_object = __commonJS(function(exports, module) {
      var IndexedObject = require_indexed_object();
      var requireObjectCoercible = require_require_object_coercible();
      module.exports = function(it) {
        return IndexedObject(requireObjectCoercible(it));
      };
    });
    var require_is_object2 = __commonJS(function(exports, module) {
      var isCallable = require_is_callable2();
      var $documentAll = require_document_all();
      var documentAll = $documentAll.all;
      module.exports = $documentAll.IS_HTMLDDA ? function(it) {
        return _typeof(it) == 'object' ? it !== null : isCallable(it) || it === documentAll;
      } : function(it) {
        return _typeof(it) == 'object' ? it !== null : isCallable(it);
      };
    });
    var require_path = __commonJS(function(exports, module) {
      module.exports = {};
    });
    var require_get_built_in = __commonJS(function(exports, module) {
      var path = require_path();
      var global2 = require_global();
      var isCallable = require_is_callable2();
      var aFunction = function aFunction(variable) {
        return isCallable(variable) ? variable : void 0;
      };
      module.exports = function(namespace, method) {
        return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global2[namespace]) : path[namespace] && path[namespace][method] || global2[namespace] && global2[namespace][method];
      };
    });
    var require_object_is_prototype_of = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this();
      module.exports = uncurryThis({}.isPrototypeOf);
    });
    var require_engine_user_agent = __commonJS(function(exports, module) {
      var getBuiltIn = require_get_built_in();
      module.exports = getBuiltIn('navigator', 'userAgent') || '';
    });
    var require_engine_v8_version = __commonJS(function(exports, module) {
      var global2 = require_global();
      var userAgent = require_engine_user_agent();
      var process2 = global2.process;
      var Deno = global2.Deno;
      var versions = process2 && process2.versions || Deno && Deno.version;
      var v8 = versions && versions.v8;
      var match;
      var version;
      if (v8) {
        match = v8.split('.');
        version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
      }
      if (!version && userAgent) {
        match = userAgent.match(/Edge\/(\d+)/);
        if (!match || match[1] >= 74) {
          match = userAgent.match(/Chrome\/(\d+)/);
          if (match) {
            version = +match[1];
          }
        }
      }
      module.exports = version;
    });
    var require_symbol_constructor_detection = __commonJS(function(exports, module) {
      var V8_VERSION = require_engine_v8_version();
      var fails = require_fails();
      module.exports = !!Object.getOwnPropertySymbols && !fails(function() {
        var symbol = Symbol();
        return !String(symbol) || !(Object(symbol) instanceof Symbol) || !Symbol.sham && V8_VERSION && V8_VERSION < 41;
      });
    });
    var require_use_symbol_as_uid = __commonJS(function(exports, module) {
      var NATIVE_SYMBOL = require_symbol_constructor_detection();
      module.exports = NATIVE_SYMBOL && !Symbol.sham && _typeof(Symbol.iterator) == 'symbol';
    });
    var require_is_symbol2 = __commonJS(function(exports, module) {
      var getBuiltIn = require_get_built_in();
      var isCallable = require_is_callable2();
      var isPrototypeOf = require_object_is_prototype_of();
      var USE_SYMBOL_AS_UID = require_use_symbol_as_uid();
      var $Object = Object;
      module.exports = USE_SYMBOL_AS_UID ? function(it) {
        return _typeof(it) == 'symbol';
      } : function(it) {
        var $Symbol = getBuiltIn('Symbol');
        return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
      };
    });
    var require_try_to_string = __commonJS(function(exports, module) {
      var $String = String;
      module.exports = function(argument) {
        try {
          return $String(argument);
        } catch (error) {
          return 'Object';
        }
      };
    });
    var require_a_callable = __commonJS(function(exports, module) {
      var isCallable = require_is_callable2();
      var tryToString = require_try_to_string();
      var $TypeError = TypeError;
      module.exports = function(argument) {
        if (isCallable(argument)) {
          return argument;
        }
        throw $TypeError(tryToString(argument) + ' is not a function');
      };
    });
    var require_get_method = __commonJS(function(exports, module) {
      var aCallable = require_a_callable();
      var isNullOrUndefined = require_is_null_or_undefined();
      module.exports = function(V, P) {
        var func = V[P];
        return isNullOrUndefined(func) ? void 0 : aCallable(func);
      };
    });
    var require_ordinary_to_primitive = __commonJS(function(exports, module) {
      var call = require_function_call();
      var isCallable = require_is_callable2();
      var isObject = require_is_object2();
      var $TypeError = TypeError;
      module.exports = function(input, pref) {
        var fn, val;
        if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) {
          return val;
        }
        if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) {
          return val;
        }
        if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) {
          return val;
        }
        throw $TypeError('Can\'t convert object to primitive value');
      };
    });
    var require_is_pure = __commonJS(function(exports, module) {
      module.exports = true;
    });
    var require_define_global_property = __commonJS(function(exports, module) {
      var global2 = require_global();
      var defineProperty = Object.defineProperty;
      module.exports = function(key, value) {
        try {
          defineProperty(global2, key, {
            value: value,
            configurable: true,
            writable: true
          });
        } catch (error) {
          global2[key] = value;
        }
        return value;
      };
    });
    var require_shared_store = __commonJS(function(exports, module) {
      var global2 = require_global();
      var defineGlobalProperty = require_define_global_property();
      var SHARED = '__core-js_shared__';
      var store = global2[SHARED] || defineGlobalProperty(SHARED, {});
      module.exports = store;
    });
    var require_shared = __commonJS(function(exports, module) {
      var IS_PURE = require_is_pure();
      var store = require_shared_store();
      (module.exports = function(key, value) {
        return store[key] || (store[key] = value !== void 0 ? value : {});
      })('versions', []).push({
        version: '3.26.1',
        mode: IS_PURE ? 'pure' : 'global',
        copyright: '\xa9 2014-2022 Denis Pushkarev (zloirock.ru)',
        license: 'https://github.com/zloirock/core-js/blob/v3.26.1/LICENSE',
        source: 'https://github.com/zloirock/core-js'
      });
    });
    var require_to_object = __commonJS(function(exports, module) {
      var requireObjectCoercible = require_require_object_coercible();
      var $Object = Object;
      module.exports = function(argument) {
        return $Object(requireObjectCoercible(argument));
      };
    });
    var require_has_own_property = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this();
      var toObject = require_to_object();
      var hasOwnProperty2 = uncurryThis({}.hasOwnProperty);
      module.exports = Object.hasOwn || function hasOwn2(it, key) {
        return hasOwnProperty2(toObject(it), key);
      };
    });
    var require_uid = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this();
      var id = 0;
      var postfix = Math.random();
      var toString = uncurryThis(1..toString);
      module.exports = function(key) {
        return 'Symbol(' + (key === void 0 ? '' : key) + ')_' + toString(++id + postfix, 36);
      };
    });
    var require_well_known_symbol = __commonJS(function(exports, module) {
      var global2 = require_global();
      var shared = require_shared();
      var hasOwn2 = require_has_own_property();
      var uid = require_uid();
      var NATIVE_SYMBOL = require_symbol_constructor_detection();
      var USE_SYMBOL_AS_UID = require_use_symbol_as_uid();
      var WellKnownSymbolsStore = shared('wks');
      var Symbol2 = global2.Symbol;
      var symbolFor = Symbol2 && Symbol2['for'];
      var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol2 : Symbol2 && Symbol2.withoutSetter || uid;
      module.exports = function(name) {
        if (!hasOwn2(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
          var description = 'Symbol.' + name;
          if (NATIVE_SYMBOL && hasOwn2(Symbol2, name)) {
            WellKnownSymbolsStore[name] = Symbol2[name];
          } else if (USE_SYMBOL_AS_UID && symbolFor) {
            WellKnownSymbolsStore[name] = symbolFor(description);
          } else {
            WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
          }
        }
        return WellKnownSymbolsStore[name];
      };
    });
    var require_to_primitive = __commonJS(function(exports, module) {
      var call = require_function_call();
      var isObject = require_is_object2();
      var isSymbol = require_is_symbol2();
      var getMethod = require_get_method();
      var ordinaryToPrimitive = require_ordinary_to_primitive();
      var wellKnownSymbol = require_well_known_symbol();
      var $TypeError = TypeError;
      var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
      module.exports = function(input, pref) {
        if (!isObject(input) || isSymbol(input)) {
          return input;
        }
        var exoticToPrim = getMethod(input, TO_PRIMITIVE);
        var result;
        if (exoticToPrim) {
          if (pref === void 0) {
            pref = 'default';
          }
          result = call(exoticToPrim, input, pref);
          if (!isObject(result) || isSymbol(result)) {
            return result;
          }
          throw $TypeError('Can\'t convert object to primitive value');
        }
        if (pref === void 0) {
          pref = 'number';
        }
        return ordinaryToPrimitive(input, pref);
      };
    });
    var require_to_property_key = __commonJS(function(exports, module) {
      var toPrimitive = require_to_primitive();
      var isSymbol = require_is_symbol2();
      module.exports = function(argument) {
        var key = toPrimitive(argument, 'string');
        return isSymbol(key) ? key : key + '';
      };
    });
    var require_document_create_element = __commonJS(function(exports, module) {
      var global2 = require_global();
      var isObject = require_is_object2();
      var document2 = global2.document;
      var EXISTS = isObject(document2) && isObject(document2.createElement);
      module.exports = function(it) {
        return EXISTS ? document2.createElement(it) : {};
      };
    });
    var require_ie8_dom_define = __commonJS(function(exports, module) {
      var DESCRIPTORS = require_descriptors();
      var fails = require_fails();
      var createElement = require_document_create_element();
      module.exports = !DESCRIPTORS && !fails(function() {
        return Object.defineProperty(createElement('div'), 'a', {
          get: function get() {
            return 7;
          }
        }).a != 7;
      });
    });
    var require_object_get_own_property_descriptor = __commonJS(function(exports) {
      var DESCRIPTORS = require_descriptors();
      var call = require_function_call();
      var propertyIsEnumerableModule = require_object_property_is_enumerable();
      var createPropertyDescriptor = require_create_property_descriptor();
      var toIndexedObject = require_to_indexed_object();
      var toPropertyKey = require_to_property_key();
      var hasOwn2 = require_has_own_property();
      var IE8_DOM_DEFINE = require_ie8_dom_define();
      var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
      exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
        O = toIndexedObject(O);
        P = toPropertyKey(P);
        if (IE8_DOM_DEFINE) {
          try {
            return $getOwnPropertyDescriptor(O, P);
          } catch (error) {}
        }
        if (hasOwn2(O, P)) {
          return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
        }
      };
    });
    var require_is_forced = __commonJS(function(exports, module) {
      var fails = require_fails();
      var isCallable = require_is_callable2();
      var replacement = /#|\.prototype\./;
      var isForced = function isForced(feature, detection) {
        var value = data[normalize(feature)];
        return value == POLYFILL ? true : value == NATIVE ? false : isCallable(detection) ? fails(detection) : !!detection;
      };
      var normalize = isForced.normalize = function(string) {
        return String(string).replace(replacement, '.').toLowerCase();
      };
      var data = isForced.data = {};
      var NATIVE = isForced.NATIVE = 'N';
      var POLYFILL = isForced.POLYFILL = 'P';
      module.exports = isForced;
    });
    var require_function_bind_context = __commonJS(function(exports, module) {
      var uncurryThis = require_function_uncurry_this_clause();
      var aCallable = require_a_callable();
      var NATIVE_BIND = require_function_bind_native();
      var bind = uncurryThis(uncurryThis.bind);
      module.exports = function(fn, that) {
        aCallable(fn);
        return that === void 0 ? fn : NATIVE_BIND ? bind(fn, that) : function() {
          return fn.apply(that, arguments);
        };
      };
    });
    var require_v8_prototype_define_bug = __commonJS(function(exports, module) {
      var DESCRIPTORS = require_descriptors();
      var fails = require_fails();
      module.exports = DESCRIPTORS && fails(function() {
        return Object.defineProperty(function() {}, 'prototype', {
          value: 42,
          writable: false
        }).prototype != 42;
      });
    });
    var require_an_object = __commonJS(function(exports, module) {
      var isObject = require_is_object2();
      var $String = String;
      var $TypeError = TypeError;
      module.exports = function(argument) {
        if (isObject(argument)) {
          return argument;
        }
        throw $TypeError($String(argument) + ' is not an object');
      };
    });
    var require_object_define_property = __commonJS(function(exports) {
      var DESCRIPTORS = require_descriptors();
      var IE8_DOM_DEFINE = require_ie8_dom_define();
      var V8_PROTOTYPE_DEFINE_BUG = require_v8_prototype_define_bug();
      var anObject = require_an_object();
      var toPropertyKey = require_to_property_key();
      var $TypeError = TypeError;
      var $defineProperty = Object.defineProperty;
      var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
      var ENUMERABLE = 'enumerable';
      var CONFIGURABLE = 'configurable';
      var WRITABLE = 'writable';
      exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
        anObject(O);
        P = toPropertyKey(P);
        anObject(Attributes);
        if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
          var current = $getOwnPropertyDescriptor(O, P);
          if (current && current[WRITABLE]) {
            O[P] = Attributes.value;
            Attributes = {
              configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
              enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
              writable: false
            };
          }
        }
        return $defineProperty(O, P, Attributes);
      } : $defineProperty : function defineProperty(O, P, Attributes) {
        anObject(O);
        P = toPropertyKey(P);
        anObject(Attributes);
        if (IE8_DOM_DEFINE) {
          try {
            return $defineProperty(O, P, Attributes);
          } catch (error) {}
        }
        if ('get' in Attributes || 'set' in Attributes) {
          throw $TypeError('Accessors not supported');
        }
        if ('value' in Attributes) {
          O[P] = Attributes.value;
        }
        return O;
      };
    });
    var require_create_non_enumerable_property = __commonJS(function(exports, module) {
      var DESCRIPTORS = require_descriptors();
      var definePropertyModule = require_object_define_property();
      var createPropertyDescriptor = require_create_property_descriptor();
      module.exports = DESCRIPTORS ? function(object, key, value) {
        return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
      } : function(object, key, value) {
        object[key] = value;
        return object;
      };
    });
    var require_export = __commonJS(function(exports, module) {
      'use strict';
      var global2 = require_global();
      var apply = require_function_apply();
      var uncurryThis = require_function_uncurry_this_clause();
      var isCallable = require_is_callable2();
      var getOwnPropertyDescriptor = require_object_get_own_property_descriptor().f;
      var isForced = require_is_forced();
      var path = require_path();
      var bind = require_function_bind_context();
      var createNonEnumerableProperty = require_create_non_enumerable_property();
      var hasOwn2 = require_has_own_property();
      var wrapConstructor = function wrapConstructor(NativeConstructor) {
        var Wrapper = function Wrapper(a2, b2, c4) {
          if (this instanceof Wrapper) {
            switch (arguments.length) {
             case 0:
              return new NativeConstructor();

             case 1:
              return new NativeConstructor(a2);

             case 2:
              return new NativeConstructor(a2, b2);
            }
            return new NativeConstructor(a2, b2, c4);
          }
          return apply(NativeConstructor, this, arguments);
        };
        Wrapper.prototype = NativeConstructor.prototype;
        return Wrapper;
      };
      module.exports = function(options, source) {
        var TARGET = options.target;
        var GLOBAL = options.global;
        var STATIC = options.stat;
        var PROTO = options.proto;
        var nativeSource = GLOBAL ? global2 : STATIC ? global2[TARGET] : (global2[TARGET] || {}).prototype;
        var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
        var targetPrototype = target.prototype;
        var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
        var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;
        for (key in source) {
          FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
          USE_NATIVE = !FORCED && nativeSource && hasOwn2(nativeSource, key);
          targetProperty = target[key];
          if (USE_NATIVE) {
            if (options.dontCallGetSet) {
              descriptor = getOwnPropertyDescriptor(nativeSource, key);
              nativeProperty = descriptor && descriptor.value;
            } else {
              nativeProperty = nativeSource[key];
            }
          }
          sourceProperty = USE_NATIVE && nativeProperty ? nativeProperty : source[key];
          if (USE_NATIVE && _typeof(targetProperty) == _typeof(sourceProperty)) {
            continue;
          }
          if (options.bind && USE_NATIVE) {
            resultProperty = bind(sourceProperty, global2);
          } else if (options.wrap && USE_NATIVE) {
            resultProperty = wrapConstructor(sourceProperty);
          } else if (PROTO && isCallable(sourceProperty)) {
            resultProperty = uncurryThis(sourceProperty);
          } else {
            resultProperty = sourceProperty;
          }
          if (options.sham || sourceProperty && sourceProperty.sham || targetProperty && targetProperty.sham) {
            createNonEnumerableProperty(resultProperty, 'sham', true);
          }
          createNonEnumerableProperty(target, key, resultProperty);
          if (PROTO) {
            VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
            if (!hasOwn2(path, VIRTUAL_PROTOTYPE)) {
              createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
            }
            createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
            if (options.real && targetPrototype && !targetPrototype[key]) {
              createNonEnumerableProperty(targetPrototype, key, sourceProperty);
            }
          }
        }
      };
    });
    var require_es_object_has_own = __commonJS(function() {
      var $ = require_export();
      var hasOwn2 = require_has_own_property();
      $({
        target: 'Object',
        stat: true
      }, {
        hasOwn: hasOwn2
      });
    });
    var require_has_own = __commonJS(function(exports, module) {
      require_es_object_has_own();
      var path = require_path();
      module.exports = path.Object.hasOwn;
    });
    var require_has_own2 = __commonJS(function(exports, module) {
      var parent = require_has_own();
      module.exports = parent;
    });
    var require_has_own3 = __commonJS(function(exports, module) {
      var parent = require_has_own2();
      module.exports = parent;
    });
    var definitions = [ {
      name: 'NA',
      value: 'inapplicable',
      priority: 0,
      group: 'inapplicable'
    }, {
      name: 'PASS',
      value: 'passed',
      priority: 1,
      group: 'passes'
    }, {
      name: 'CANTTELL',
      value: 'cantTell',
      priority: 2,
      group: 'incomplete'
    }, {
      name: 'FAIL',
      value: 'failed',
      priority: 3,
      group: 'violations'
    } ];
    var constants = {
      helpUrlBase: 'https://dequeuniversity.com/rules/',
      gridSize: 200,
      results: [],
      resultGroups: [],
      resultGroupMap: {},
      impact: Object.freeze([ 'minor', 'moderate', 'serious', 'critical' ]),
      preload: Object.freeze({
        assets: [ 'cssom', 'media' ],
        timeout: 1e4
      }),
      allOrigins: '<unsafe_all_origins>',
      sameOrigin: '<same_origin>'
    };
    definitions.forEach(function(definition) {
      var name = definition.name;
      var value = definition.value;
      var priority = definition.priority;
      var group = definition.group;
      constants[name] = value;
      constants[name + '_PRIO'] = priority;
      constants[name + '_GROUP'] = group;
      constants.results[priority] = value;
      constants.resultGroups[priority] = group;
      constants.resultGroupMap[value] = group;
    });
    Object.freeze(constants.results);
    Object.freeze(constants.resultGroups);
    Object.freeze(constants.resultGroupMap);
    Object.freeze(constants);
    var constants_default = constants;
    function log() {
      if ((typeof console === 'undefined' ? 'undefined' : _typeof(console)) === 'object' && console.log) {
        Function.prototype.apply.call(console.log, console, arguments);
      }
    }
    var log_default = log;
    var whitespaceRegex = /[\t\r\n\f]/g;
    var AbstractVirtualNode = function() {
      function AbstractVirtualNode() {
        _classCallCheck(this, AbstractVirtualNode);
        this.parent = void 0;
      }
      _createClass(AbstractVirtualNode, [ {
        key: 'props',
        get: function get() {
          throw new Error('VirtualNode class must have a "props" object consisting of "nodeType" and "nodeName" properties');
        }
      }, {
        key: 'attrNames',
        get: function get() {
          throw new Error('VirtualNode class must have an "attrNames" property');
        }
      }, {
        key: 'attr',
        value: function attr() {
          throw new Error('VirtualNode class must have an "attr" function');
        }
      }, {
        key: 'hasAttr',
        value: function hasAttr() {
          throw new Error('VirtualNode class must have a "hasAttr" function');
        }
      }, {
        key: 'hasClass',
        value: function hasClass(className) {
          var classAttr = this.attr('class');
          if (!classAttr) {
            return false;
          }
          var selector = ' ' + className + ' ';
          return (' ' + classAttr + ' ').replace(whitespaceRegex, ' ').indexOf(selector) >= 0;
        }
      } ]);
      return AbstractVirtualNode;
    }();
    var abstract_virtual_node_default = AbstractVirtualNode;
    var utils_exports = {};
    __export(utils_exports, {
      DqElement: function DqElement() {
        return dq_element_default;
      },
      aggregate: function aggregate() {
        return aggregate_default;
      },
      aggregateChecks: function aggregateChecks() {
        return aggregate_checks_default;
      },
      aggregateNodeResults: function aggregateNodeResults() {
        return aggregate_node_results_default;
      },
      aggregateResult: function aggregateResult() {
        return aggregate_result_default;
      },
      areStylesSet: function areStylesSet() {
        return are_styles_set_default;
      },
      assert: function assert() {
        return assert_default;
      },
      checkHelper: function checkHelper() {
        return check_helper_default;
      },
      clone: function clone() {
        return _clone;
      },
      closest: function closest() {
        return closest_default;
      },
      collectResultsFromFrames: function collectResultsFromFrames() {
        return _collectResultsFromFrames;
      },
      contains: function contains() {
        return _contains;
      },
      convertSelector: function convertSelector() {
        return _convertSelector;
      },
      cssParser: function cssParser() {
        return css_parser_default;
      },
      deepMerge: function deepMerge() {
        return deep_merge_default;
      },
      escapeSelector: function escapeSelector() {
        return escape_selector_default;
      },
      extendMetaData: function extendMetaData() {
        return extend_meta_data_default;
      },
      filterHtmlAttrs: function filterHtmlAttrs() {
        return _filterHtmlAttrs;
      },
      finalizeRuleResult: function finalizeRuleResult() {
        return _finalizeRuleResult;
      },
      findBy: function findBy() {
        return find_by_default;
      },
      getAllChecks: function getAllChecks() {
        return get_all_checks_default;
      },
      getAncestry: function getAncestry() {
        return _getAncestry;
      },
      getBaseLang: function getBaseLang() {
        return get_base_lang_default;
      },
      getCheckMessage: function getCheckMessage() {
        return get_check_message_default;
      },
      getCheckOption: function getCheckOption() {
        return get_check_option_default;
      },
      getEnvironmentData: function getEnvironmentData() {
        return _getEnvironmentData;
      },
      getFlattenedTree: function getFlattenedTree() {
        return _getFlattenedTree;
      },
      getFrameContexts: function getFrameContexts() {
        return _getFrameContexts;
      },
      getFriendlyUriEnd: function getFriendlyUriEnd() {
        return get_friendly_uri_end_default;
      },
      getNodeAttributes: function getNodeAttributes() {
        return get_node_attributes_default;
      },
      getNodeFromTree: function getNodeFromTree() {
        return get_node_from_tree_default;
      },
      getPreloadConfig: function getPreloadConfig() {
        return _getPreloadConfig;
      },
      getRootNode: function getRootNode() {
        return get_root_node_default;
      },
      getRule: function getRule() {
        return _getRule;
      },
      getScroll: function getScroll() {
        return get_scroll_default;
      },
      getScrollState: function getScrollState() {
        return get_scroll_state_default;
      },
      getSelector: function getSelector() {
        return _getSelector;
      },
      getSelectorData: function getSelectorData() {
        return _getSelectorData;
      },
      getShadowSelector: function getShadowSelector() {
        return _getShadowSelector;
      },
      getStandards: function getStandards() {
        return _getStandards;
      },
      getStyleSheetFactory: function getStyleSheetFactory() {
        return get_stylesheet_factory_default;
      },
      getXpath: function getXpath() {
        return get_xpath_default;
      },
      injectStyle: function injectStyle() {
        return inject_style_default;
      },
      isHidden: function isHidden() {
        return is_hidden_default;
      },
      isHtmlElement: function isHtmlElement() {
        return is_html_element_default;
      },
      isNodeInContext: function isNodeInContext() {
        return _isNodeInContext;
      },
      isShadowRoot: function isShadowRoot() {
        return is_shadow_root_default;
      },
      isValidLang: function isValidLang() {
        return valid_langs_default;
      },
      isXHTML: function isXHTML() {
        return is_xhtml_default;
      },
      matchAncestry: function matchAncestry() {
        return _matchAncestry;
      },
      matches: function matches() {
        return _matches;
      },
      matchesExpression: function matchesExpression() {
        return _matchesExpression;
      },
      matchesSelector: function matchesSelector() {
        return element_matches_default;
      },
      memoize: function memoize() {
        return memoize_default;
      },
      mergeResults: function mergeResults() {
        return merge_results_default;
      },
      nodeLookup: function nodeLookup() {
        return _nodeLookup;
      },
      nodeSerializer: function nodeSerializer() {
        return node_serializer_default;
      },
      nodeSorter: function nodeSorter() {
        return node_sorter_default;
      },
      parseCrossOriginStylesheet: function parseCrossOriginStylesheet() {
        return parse_crossorigin_stylesheet_default;
      },
      parseSameOriginStylesheet: function parseSameOriginStylesheet() {
        return parse_sameorigin_stylesheet_default;
      },
      parseStylesheet: function parseStylesheet() {
        return parse_stylesheet_default;
      },
      performanceTimer: function performanceTimer() {
        return performance_timer_default;
      },
      pollyfillElementsFromPoint: function pollyfillElementsFromPoint() {
        return _pollyfillElementsFromPoint;
      },
      preload: function preload() {
        return _preload;
      },
      preloadCssom: function preloadCssom() {
        return preload_cssom_default;
      },
      preloadMedia: function preloadMedia() {
        return preload_media_default;
      },
      processMessage: function processMessage() {
        return process_message_default;
      },
      publishMetaData: function publishMetaData() {
        return _publishMetaData;
      },
      querySelectorAll: function querySelectorAll() {
        return query_selector_all_default;
      },
      querySelectorAllFilter: function querySelectorAllFilter() {
        return query_selector_all_filter_default;
      },
      queue: function queue() {
        return queue_default;
      },
      respondable: function respondable() {
        return _respondable;
      },
      ruleShouldRun: function ruleShouldRun() {
        return rule_should_run_default;
      },
      select: function select() {
        return _select;
      },
      sendCommandToFrame: function sendCommandToFrame() {
        return _sendCommandToFrame;
      },
      setScrollState: function setScrollState() {
        return set_scroll_state_default;
      },
      shadowSelect: function shadowSelect() {
        return _shadowSelect;
      },
      shadowSelectAll: function shadowSelectAll() {
        return _shadowSelectAll;
      },
      shouldPreload: function shouldPreload() {
        return _shouldPreload;
      },
      toArray: function toArray() {
        return to_array_default;
      },
      tokenList: function tokenList() {
        return token_list_default;
      },
      uniqueArray: function uniqueArray() {
        return unique_array_default;
      },
      uuid: function uuid() {
        return uuid_default;
      },
      validInputTypes: function validInputTypes() {
        return valid_input_type_default;
      },
      validLangs: function validLangs() {
        return _validLangs;
      }
    });
    function aggregate(map, values, initial) {
      values = values.slice();
      if (initial) {
        values.push(initial);
      }
      var sorting = values.map(function(val) {
        return map.indexOf(val);
      }).sort();
      return map[sorting.pop()];
    }
    var aggregate_default = aggregate;
    var CANTTELL_PRIO = constants_default.CANTTELL_PRIO, FAIL_PRIO = constants_default.FAIL_PRIO;
    var checkMap = [];
    checkMap[constants_default.PASS_PRIO] = true;
    checkMap[constants_default.CANTTELL_PRIO] = null;
    checkMap[constants_default.FAIL_PRIO] = false;
    var checkTypes = [ 'any', 'all', 'none' ];
    function anyAllNone(obj, functor) {
      return checkTypes.reduce(function(out, type2) {
        out[type2] = (obj[type2] || []).map(function(val) {
          return functor(val, type2);
        });
        return out;
      }, {});
    }
    function aggregateChecks(nodeResOriginal) {
      var nodeResult = Object.assign({}, nodeResOriginal);
      anyAllNone(nodeResult, function(check, type2) {
        var i = typeof check.result === 'undefined' ? -1 : checkMap.indexOf(check.result);
        check.priority = i !== -1 ? i : constants_default.CANTTELL_PRIO;
        if (type2 === 'none') {
          if (check.priority === constants_default.PASS_PRIO) {
            check.priority = constants_default.FAIL_PRIO;
          } else if (check.priority === constants_default.FAIL_PRIO) {
            check.priority = constants_default.PASS_PRIO;
          }
        }
      });
      var priorities = {
        all: nodeResult.all.reduce(function(a2, b2) {
          return Math.max(a2, b2.priority);
        }, 0),
        none: nodeResult.none.reduce(function(a2, b2) {
          return Math.max(a2, b2.priority);
        }, 0),
        any: nodeResult.any.reduce(function(a2, b2) {
          return Math.min(a2, b2.priority);
        }, 4) % 4
      };
      nodeResult.priority = Math.max(priorities.all, priorities.none, priorities.any);
      var impacts = [];
      checkTypes.forEach(function(type2) {
        nodeResult[type2] = nodeResult[type2].filter(function(check) {
          return check.priority === nodeResult.priority && check.priority === priorities[type2];
        });
        nodeResult[type2].forEach(function(check) {
          return impacts.push(check.impact);
        });
      });
      if ([ CANTTELL_PRIO, FAIL_PRIO ].includes(nodeResult.priority)) {
        nodeResult.impact = aggregate_default(constants_default.impact, impacts);
      } else {
        nodeResult.impact = null;
      }
      anyAllNone(nodeResult, function(c4) {
        delete c4.result;
        delete c4.priority;
      });
      nodeResult.result = constants_default.results[nodeResult.priority];
      delete nodeResult.priority;
      return nodeResult;
    }
    var aggregate_checks_default = aggregateChecks;
    function _finalizeRuleResult(ruleResult) {
      var rule = axe._audit.rules.find(function(_ref) {
        var id = _ref.id;
        return id === ruleResult.id;
      });
      if (rule && rule.impact) {
        ruleResult.nodes.forEach(function(node) {
          [ 'any', 'all', 'none' ].forEach(function(checkType) {
            (node[checkType] || []).forEach(function(checkResult) {
              checkResult.impact = rule.impact;
            });
          });
        });
      }
      Object.assign(ruleResult, aggregate_node_results_default(ruleResult.nodes));
      delete ruleResult.nodes;
      return ruleResult;
    }
    function aggregateNodeResults(nodeResults) {
      var ruleResult = {};
      nodeResults = nodeResults.map(function(nodeResult) {
        if (nodeResult.any && nodeResult.all && nodeResult.none) {
          return aggregate_checks_default(nodeResult);
        } else if (Array.isArray(nodeResult.node)) {
          return _finalizeRuleResult(nodeResult);
        } else {
          throw new TypeError('Invalid Result type');
        }
      });
      if (nodeResults && nodeResults.length) {
        var resultList = nodeResults.map(function(node) {
          return node.result;
        });
        ruleResult.result = aggregate_default(constants_default.results, resultList, ruleResult.result);
      } else {
        ruleResult.result = 'inapplicable';
      }
      constants_default.resultGroups.forEach(function(group) {
        return ruleResult[group] = [];
      });
      nodeResults.forEach(function(nodeResult) {
        var groupName = constants_default.resultGroupMap[nodeResult.result];
        ruleResult[groupName].push(nodeResult);
      });
      var impactGroup = constants_default.FAIL_GROUP;
      if (ruleResult[impactGroup].length === 0) {
        impactGroup = constants_default.CANTTELL_GROUP;
      }
      if (ruleResult[impactGroup].length > 0) {
        var impactList = ruleResult[impactGroup].map(function(failure) {
          return failure.impact;
        });
        ruleResult.impact = aggregate_default(constants_default.impact, impactList) || null;
      } else {
        ruleResult.impact = null;
      }
      return ruleResult;
    }
    var aggregate_node_results_default = aggregateNodeResults;
    function copyToGroup(resultObject, subResult, group) {
      var resultCopy = Object.assign({}, subResult);
      resultCopy.nodes = (resultCopy[group] || []).concat();
      constants_default.resultGroups.forEach(function(resultGroup) {
        delete resultCopy[resultGroup];
      });
      resultObject[group].push(resultCopy);
    }
    function aggregateResult(results) {
      var resultObject = {};
      constants_default.resultGroups.forEach(function(groupName) {
        return resultObject[groupName] = [];
      });
      results.forEach(function(subResult) {
        if (subResult.error) {
          copyToGroup(resultObject, subResult, constants_default.CANTTELL_GROUP);
        } else if (subResult.result === constants_default.NA) {
          copyToGroup(resultObject, subResult, constants_default.NA_GROUP);
        } else {
          constants_default.resultGroups.forEach(function(group) {
            if (Array.isArray(subResult[group]) && subResult[group].length > 0) {
              copyToGroup(resultObject, subResult, group);
            }
          });
        }
      });
      return resultObject;
    }
    var aggregate_result_default = aggregateResult;
    function areStylesSet(el, styles, stopAt) {
      var styl = window.getComputedStyle(el, null);
      if (!styl) {
        return false;
      }
      for (var i = 0; i < styles.length; ++i) {
        var att = styles[i];
        if (styl.getPropertyValue(att.property) === att.value) {
          return true;
        }
      }
      if (!el.parentNode || el.nodeName.toUpperCase() === stopAt.toUpperCase()) {
        return false;
      }
      return areStylesSet(el.parentNode, styles, stopAt);
    }
    var are_styles_set_default = areStylesSet;
    function assert(bool, message) {
      if (!bool) {
        throw new Error(message);
      }
    }
    var assert_default = assert;
    function toArray(thing) {
      return Array.prototype.slice.call(thing);
    }
    var to_array_default = toArray;
    function escapeSelector(value) {
      var string = String(value);
      var length = string.length;
      var index = -1;
      var codeUnit;
      var result = '';
      var firstCodeUnit = string.charCodeAt(0);
      while (++index < length) {
        codeUnit = string.charCodeAt(index);
        if (codeUnit == 0) {
          result += '\ufffd';
          continue;
        }
        if (codeUnit >= 1 && codeUnit <= 31 || codeUnit == 127 || index == 0 && codeUnit >= 48 && codeUnit <= 57 || index == 1 && codeUnit >= 48 && codeUnit <= 57 && firstCodeUnit == 45) {
          result += '\\' + codeUnit.toString(16) + ' ';
          continue;
        }
        if (index == 0 && length == 1 && codeUnit == 45) {
          result += '\\' + string.charAt(index);
          continue;
        }
        if (codeUnit >= 128 || codeUnit == 45 || codeUnit == 95 || codeUnit >= 48 && codeUnit <= 57 || codeUnit >= 65 && codeUnit <= 90 || codeUnit >= 97 && codeUnit <= 122) {
          result += string.charAt(index);
          continue;
        }
        result += '\\' + string.charAt(index);
      }
      return result;
    }
    var escape_selector_default = escapeSelector;
    function isMostlyNumbers() {
      var str = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      return str.length !== 0 && (str.match(/[0-9]/g) || '').length >= str.length / 2;
    }
    function splitString(str, splitIndex) {
      return [ str.substring(0, splitIndex), str.substring(splitIndex) ];
    }
    function trimRight(str) {
      return str.replace(/\s+$/, '');
    }
    function uriParser(url) {
      var original = url;
      var protocol = '', domain = '', port = '', path = '', query = '', hash = '';
      if (url.includes('#')) {
        var _splitString = splitString(url, url.indexOf('#'));
        var _splitString2 = _slicedToArray(_splitString, 2);
        url = _splitString2[0];
        hash = _splitString2[1];
      }
      if (url.includes('?')) {
        var _splitString3 = splitString(url, url.indexOf('?'));
        var _splitString4 = _slicedToArray(_splitString3, 2);
        url = _splitString4[0];
        query = _splitString4[1];
      }
      if (url.includes('://')) {
        var _url$split = url.split('://');
        var _url$split2 = _slicedToArray(_url$split, 2);
        protocol = _url$split2[0];
        url = _url$split2[1];
        var _splitString5 = splitString(url, url.indexOf('/'));
        var _splitString6 = _slicedToArray(_splitString5, 2);
        domain = _splitString6[0];
        url = _splitString6[1];
      } else if (url.substr(0, 2) === '//') {
        url = url.substr(2);
        var _splitString7 = splitString(url, url.indexOf('/'));
        var _splitString8 = _slicedToArray(_splitString7, 2);
        domain = _splitString8[0];
        url = _splitString8[1];
      }
      if (domain.substr(0, 4) === 'www.') {
        domain = domain.substr(4);
      }
      if (domain && domain.includes(':')) {
        var _splitString9 = splitString(domain, domain.indexOf(':'));
        var _splitString10 = _slicedToArray(_splitString9, 2);
        domain = _splitString10[0];
        port = _splitString10[1];
      }
      path = url;
      return {
        original: original,
        protocol: protocol,
        domain: domain,
        port: port,
        path: path,
        query: query,
        hash: hash
      };
    }
    function getFriendlyUriEnd() {
      var uri = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (uri.length <= 1 || uri.substr(0, 5) === 'data:' || uri.substr(0, 11) === 'javascript:' || uri.includes('?')) {
        return;
      }
      var currentDomain = options.currentDomain, _options$maxLength = options.maxLength, maxLength = _options$maxLength === void 0 ? 25 : _options$maxLength;
      var _uriParser = uriParser(uri), path = _uriParser.path, domain = _uriParser.domain, hash = _uriParser.hash;
      var pathEnd = path.substr(path.substr(0, path.length - 2).lastIndexOf('/') + 1);
      if (hash) {
        if (pathEnd && (pathEnd + hash).length <= maxLength) {
          return trimRight(pathEnd + hash);
        } else if (pathEnd.length < 2 && hash.length > 2 && hash.length <= maxLength) {
          return trimRight(hash);
        } else {
          return;
        }
      } else if (domain && domain.length < maxLength && path.length <= 1) {
        return trimRight(domain + path);
      }
      if (path === '/' + pathEnd && domain && currentDomain && domain !== currentDomain && (domain + path).length <= maxLength) {
        return trimRight(domain + path);
      }
      var lastDotIndex = pathEnd.lastIndexOf('.');
      if ((lastDotIndex === -1 || lastDotIndex > 1) && (lastDotIndex !== -1 || pathEnd.length > 2) && pathEnd.length <= maxLength && !pathEnd.match(/index(\.[a-zA-Z]{2-4})?/) && !isMostlyNumbers(pathEnd)) {
        return trimRight(pathEnd);
      }
    }
    var get_friendly_uri_end_default = getFriendlyUriEnd;
    function getNodeAttributes(node) {
      if (node.attributes instanceof window.NamedNodeMap) {
        return node.attributes;
      }
      return node.cloneNode(false).attributes;
    }
    var get_node_attributes_default = getNodeAttributes;
    var matchesSelector = function() {
      var method;
      function getMethod(node) {
        var index, candidate, candidates = [ 'matches', 'matchesSelector', 'mozMatchesSelector', 'webkitMatchesSelector', 'msMatchesSelector' ], length = candidates.length;
        for (index = 0; index < length; index++) {
          candidate = candidates[index];
          if (node[candidate]) {
            return candidate;
          }
        }
      }
      return function(node, selector) {
        if (!method || !node[method]) {
          method = getMethod(node);
        }
        if (node[method]) {
          return node[method](selector);
        }
        return false;
      };
    }();
    var element_matches_default = matchesSelector;
    var import_memoizee = __toModule(require_memoizee());
    axe._memoizedFns = [];
    function memoizeImplementation(fn) {
      var memoized = (0, import_memoizee['default'])(fn);
      axe._memoizedFns.push(memoized);
      return memoized;
    }
    var memoize_default = memoizeImplementation;
    var isXHTML = memoize_default(function(doc) {
      if (!(doc !== null && doc !== void 0 && doc.createElement)) {
        return false;
      }
      return doc.createElement('A').localName === 'A';
    });
    var is_xhtml_default = isXHTML;
    function _getShadowSelector(generateSelector2, elm) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (!elm) {
        return '';
      }
      var doc = elm.getRootNode && elm.getRootNode() || document;
      if (doc.nodeType !== 11) {
        return generateSelector2(elm, options, doc);
      }
      var stack = [];
      while (doc.nodeType === 11) {
        if (!doc.host) {
          return '';
        }
        stack.unshift({
          elm: elm,
          doc: doc
        });
        elm = doc.host;
        doc = elm.getRootNode();
      }
      stack.unshift({
        elm: elm,
        doc: doc
      });
      return stack.map(function(item) {
        return generateSelector2(item.elm, options, item.doc);
      });
    }
    var ignoredAttributes = [ 'class', 'style', 'id', 'selected', 'checked', 'disabled', 'tabindex', 'aria-checked', 'aria-selected', 'aria-invalid', 'aria-activedescendant', 'aria-busy', 'aria-disabled', 'aria-expanded', 'aria-grabbed', 'aria-pressed', 'aria-valuenow' ];
    var MAXATTRIBUTELENGTH = 31;
    var attrCharsRegex = /([\\"])/g;
    var newlineChars = /(\r\n|\r|\n)/g;
    function escapeAttribute(str) {
      return str.replace(attrCharsRegex, '\\$1').replace(newlineChars, '\\a ');
    }
    function getAttributeNameValue(node, at) {
      var name = at.name;
      var atnv;
      if (name.indexOf('href') !== -1 || name.indexOf('src') !== -1) {
        var friendly = get_friendly_uri_end_default(node.getAttribute(name));
        if (friendly) {
          atnv = escape_selector_default(at.name) + '$="' + escapeAttribute(friendly) + '"';
        } else {
          atnv = escape_selector_default(at.name) + '="' + escapeAttribute(node.getAttribute(name)) + '"';
        }
      } else {
        atnv = escape_selector_default(name) + '="' + escapeAttribute(at.value) + '"';
      }
      return atnv;
    }
    function countSort(a2, b2) {
      return a2.count < b2.count ? -1 : a2.count === b2.count ? 0 : 1;
    }
    function filterAttributes(at) {
      return !ignoredAttributes.includes(at.name) && at.name.indexOf(':') === -1 && (!at.value || at.value.length < MAXATTRIBUTELENGTH);
    }
    function _getSelectorData(domTree) {
      var data = {
        classes: {},
        tags: {},
        attributes: {}
      };
      domTree = Array.isArray(domTree) ? domTree : [ domTree ];
      var currentLevel = domTree.slice();
      var stack = [];
      var _loop2 = function _loop2() {
        var current = currentLevel.pop();
        var node = current.actualNode;
        if (!!node.querySelectorAll) {
          var tag = node.nodeName;
          if (data.tags[tag]) {
            data.tags[tag]++;
          } else {
            data.tags[tag] = 1;
          }
          if (node.classList) {
            Array.from(node.classList).forEach(function(cl) {
              var ind = escape_selector_default(cl);
              if (data.classes[ind]) {
                data.classes[ind]++;
              } else {
                data.classes[ind] = 1;
              }
            });
          }
          if (node.hasAttributes()) {
            Array.from(get_node_attributes_default(node)).filter(filterAttributes).forEach(function(at) {
              var atnv = getAttributeNameValue(node, at);
              if (atnv) {
                if (data.attributes[atnv]) {
                  data.attributes[atnv]++;
                } else {
                  data.attributes[atnv] = 1;
                }
              }
            });
          }
        }
        if (current.children.length) {
          stack.push(currentLevel);
          currentLevel = current.children.slice();
        }
        while (!currentLevel.length && stack.length) {
          currentLevel = stack.pop();
        }
      };
      while (currentLevel.length) {
        _loop2();
      }
      return data;
    }
    function uncommonClasses(node, selectorData) {
      var retVal = [];
      var classData = selectorData.classes;
      var tagData = selectorData.tags;
      if (node.classList) {
        Array.from(node.classList).forEach(function(cl) {
          var ind = escape_selector_default(cl);
          if (classData[ind] < tagData[node.nodeName]) {
            retVal.push({
              name: ind,
              count: classData[ind],
              species: 'class'
            });
          }
        });
      }
      return retVal.sort(countSort);
    }
    function getNthChildString(elm, selector) {
      var siblings = elm.parentNode && Array.from(elm.parentNode.children || '') || [];
      var hasMatchingSiblings = siblings.find(function(sibling) {
        return sibling !== elm && element_matches_default(sibling, selector);
      });
      if (hasMatchingSiblings) {
        var nthChild = 1 + siblings.indexOf(elm);
        return ':nth-child(' + nthChild + ')';
      } else {
        return '';
      }
    }
    function getElmId(elm) {
      if (!elm.getAttribute('id')) {
        return;
      }
      var doc = elm.getRootNode && elm.getRootNode() || document;
      var id = '#' + escape_selector_default(elm.getAttribute('id') || '');
      if (!id.match(/player_uid_/) && doc.querySelectorAll(id).length === 1) {
        return id;
      }
    }
    function getBaseSelector(elm) {
      var xhtml = is_xhtml_default(document);
      return escape_selector_default(xhtml ? elm.localName : elm.nodeName.toLowerCase());
    }
    function uncommonAttributes(node, selectorData) {
      var retVal = [];
      var attData = selectorData.attributes;
      var tagData = selectorData.tags;
      if (node.hasAttributes()) {
        Array.from(get_node_attributes_default(node)).filter(filterAttributes).forEach(function(at) {
          var atnv = getAttributeNameValue(node, at);
          if (atnv && attData[atnv] < tagData[node.nodeName]) {
            retVal.push({
              name: atnv,
              count: attData[atnv],
              species: 'attribute'
            });
          }
        });
      }
      return retVal.sort(countSort);
    }
    function getThreeLeastCommonFeatures(elm, selectorData) {
      var selector = '';
      var features;
      var clss = uncommonClasses(elm, selectorData);
      var atts = uncommonAttributes(elm, selectorData);
      if (clss.length && clss[0].count === 1) {
        features = [ clss[0] ];
      } else if (atts.length && atts[0].count === 1) {
        features = [ atts[0] ];
        selector = getBaseSelector(elm);
      } else {
        features = clss.concat(atts);
        features.sort(countSort);
        features = features.slice(0, 3);
        if (!features.some(function(feat) {
          return feat.species === 'class';
        })) {
          selector = getBaseSelector(elm);
        } else {
          features.sort(function(a2, b2) {
            return a2.species !== b2.species && a2.species === 'class' ? -1 : a2.species === b2.species ? 0 : 1;
          });
        }
      }
      return selector += features.reduce(function(val, feat) {
        switch (feat.species) {
         case 'class':
          return val + '.' + feat.name;

         case 'attribute':
          return val + '[' + feat.name + ']';
        }
        return val;
      }, '');
    }
    function generateSelector(elm, options, doc) {
      if (!axe._selectorData) {
        throw new Error('Expect axe._selectorData to be set up');
      }
      var _options$toRoot = options.toRoot, toRoot = _options$toRoot === void 0 ? false : _options$toRoot;
      var selector;
      var similar;
      do {
        var features = getElmId(elm);
        if (!features) {
          features = getThreeLeastCommonFeatures(elm, axe._selectorData);
          features += getNthChildString(elm, features);
        }
        if (selector) {
          selector = features + ' > ' + selector;
        } else {
          selector = features;
        }
        if (!similar) {
          similar = Array.from(doc.querySelectorAll(selector));
        } else {
          similar = similar.filter(function(item) {
            return element_matches_default(item, selector);
          });
        }
        elm = elm.parentElement;
      } while ((similar.length > 1 || toRoot) && elm && elm.nodeType !== 11);
      if (similar.length === 1) {
        return selector;
      } else if (selector.indexOf(' > ') !== -1) {
        return ':root' + selector.substring(selector.indexOf(' > '));
      }
      return ':root';
    }
    function _getSelector(elm, options) {
      return _getShadowSelector(generateSelector, elm, options);
    }
    function generateAncestry(node) {
      var nodeName2 = node.nodeName.toLowerCase();
      var parent = node.parentElement;
      if (!parent) {
        return nodeName2;
      }
      var nthChild = '';
      if (nodeName2 !== 'head' && nodeName2 !== 'body' && parent.children.length > 1) {
        var index = Array.prototype.indexOf.call(parent.children, node) + 1;
        nthChild = ':nth-child('.concat(index, ')');
      }
      return generateAncestry(parent) + ' > ' + nodeName2 + nthChild;
    }
    function _getAncestry(elm, options) {
      return _getShadowSelector(generateAncestry, elm, options);
    }
    function getXPathArray(node, path) {
      var sibling, count;
      if (!node) {
        return [];
      }
      if (!path && node.nodeType === 9) {
        path = [ {
          str: 'html'
        } ];
        return path;
      }
      path = path || [];
      if (node.parentNode && node.parentNode !== node) {
        path = getXPathArray(node.parentNode, path);
      }
      if (node.previousSibling) {
        count = 1;
        sibling = node.previousSibling;
        do {
          if (sibling.nodeType === 1 && sibling.nodeName === node.nodeName) {
            count++;
          }
          sibling = sibling.previousSibling;
        } while (sibling);
        if (count === 1) {
          count = null;
        }
      } else if (node.nextSibling) {
        sibling = node.nextSibling;
        do {
          if (sibling.nodeType === 1 && sibling.nodeName === node.nodeName) {
            count = 1;
            sibling = null;
          } else {
            count = null;
            sibling = sibling.previousSibling;
          }
        } while (sibling);
      }
      if (node.nodeType === 1) {
        var element = {};
        element.str = node.nodeName.toLowerCase();
        var id = node.getAttribute && escape_selector_default(node.getAttribute('id'));
        if (id && node.ownerDocument.querySelectorAll('#' + id).length === 1) {
          element.id = node.getAttribute('id');
        }
        if (count > 1) {
          element.count = count;
        }
        path.push(element);
      }
      return path;
    }
    function xpathToString(xpathArray) {
      return xpathArray.reduce(function(str, elm) {
        if (elm.id) {
          return '/'.concat(elm.str, '[@id=\'').concat(elm.id, '\']');
        } else {
          return str + '/'.concat(elm.str) + (elm.count > 0 ? '['.concat(elm.count, ']') : '');
        }
      }, '');
    }
    function getXpath(node) {
      var xpathArray = getXPathArray(node);
      return xpathToString(xpathArray);
    }
    var get_xpath_default = getXpath;
    var _cache = {};
    var cache = {
      set: function set(key, value) {
        validateKey(key);
        _cache[key] = value;
      },
      get: function get(key, creator) {
        validateCreator(creator);
        if (key in _cache) {
          return _cache[key];
        }
        if (typeof creator === 'function') {
          var value = creator();
          assert_default(value !== void 0, 'Cache creator function should not return undefined');
          this.set(key, value);
          return _cache[key];
        }
      },
      clear: function clear() {
        _cache = {};
      }
    };
    function validateKey(key) {
      assert_default(typeof key === 'string', 'key must be a string, ' + _typeof(key) + ' given');
      assert_default(key !== '', 'key must not be empty');
    }
    function validateCreator(creator) {
      assert_default(typeof creator === 'function' || typeof creator === 'undefined', 'creator must be a function or undefined, ' + _typeof(creator) + ' given');
    }
    var cache_default = cache;
    function getNodeFromTree(vNode, node) {
      var el = node || vNode;
      return cache_default.get('nodeMap') ? cache_default.get('nodeMap').get(el) : null;
    }
    var get_node_from_tree_default = getNodeFromTree;
    var CACHE_KEY = 'DqElm.RunOptions';
    function truncate(str, maxLength) {
      maxLength = maxLength || 300;
      if (str.length > maxLength) {
        var index = str.indexOf('>');
        str = str.substring(0, index + 1);
      }
      return str;
    }
    function getSource(element) {
      if (!(element !== null && element !== void 0 && element.outerHTML)) {
        return '';
      }
      var source = element.outerHTML;
      if (!source && typeof window.XMLSerializer === 'function') {
        source = new window.XMLSerializer().serializeToString(element);
      }
      return truncate(source || '');
    }
    function DqElement(elm) {
      var _this$spec$selector, _this$_virtualNode;
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var spec = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (!options) {
        var _cache_default$get;
        options = (_cache_default$get = cache_default.get(CACHE_KEY)) !== null && _cache_default$get !== void 0 ? _cache_default$get : {};
      }
      this.spec = spec;
      if (elm instanceof abstract_virtual_node_default) {
        this._virtualNode = elm;
        this._element = elm.actualNode;
      } else {
        this._element = elm;
        this._virtualNode = get_node_from_tree_default(elm);
      }
      this.fromFrame = ((_this$spec$selector = this.spec.selector) === null || _this$spec$selector === void 0 ? void 0 : _this$spec$selector.length) > 1;
      this._includeElementInJson = options.elementRef;
      if (options.absolutePaths) {
        this._options = {
          toRoot: true
        };
      }
      this.nodeIndexes = [];
      if (Array.isArray(this.spec.nodeIndexes)) {
        this.nodeIndexes = this.spec.nodeIndexes;
      } else if (typeof ((_this$_virtualNode = this._virtualNode) === null || _this$_virtualNode === void 0 ? void 0 : _this$_virtualNode.nodeIndex) === 'number') {
        this.nodeIndexes = [ this._virtualNode.nodeIndex ];
      }
      this.source = null;
      if (!axe._audit.noHtml) {
        var _this$spec$source;
        this.source = (_this$spec$source = this.spec.source) !== null && _this$spec$source !== void 0 ? _this$spec$source : getSource(this._element);
      }
    }
    DqElement.prototype = {
      get selector() {
        return this.spec.selector || [ _getSelector(this.element, this._options) ];
      },
      get ancestry() {
        return this.spec.ancestry || [ _getAncestry(this.element) ];
      },
      get xpath() {
        return this.spec.xpath || [ get_xpath_default(this.element) ];
      },
      get element() {
        return this._element;
      },
      toJSON: function toJSON() {
        var spec = {
          selector: this.selector,
          source: this.source,
          xpath: this.xpath,
          ancestry: this.ancestry,
          nodeIndexes: this.nodeIndexes,
          fromFrame: this.fromFrame
        };
        if (this._includeElementInJson) {
          spec.element = this._element;
        }
        return spec;
      }
    };
    DqElement.fromFrame = function fromFrame(node, options, frame) {
      var spec = DqElement.mergeSpecs(node, frame);
      return new DqElement(frame.element, options, spec);
    };
    DqElement.mergeSpecs = function mergeSpecs(child, parentFrame) {
      return _extends({}, child, {
        selector: [].concat(_toConsumableArray(parentFrame.selector), _toConsumableArray(child.selector)),
        ancestry: [].concat(_toConsumableArray(parentFrame.ancestry), _toConsumableArray(child.ancestry)),
        xpath: [].concat(_toConsumableArray(parentFrame.xpath), _toConsumableArray(child.xpath)),
        nodeIndexes: [].concat(_toConsumableArray(parentFrame.nodeIndexes), _toConsumableArray(child.nodeIndexes)),
        fromFrame: true
      });
    };
    DqElement.setRunOptions = function setRunOptions(_ref2) {
      var elementRef = _ref2.elementRef, absolutePaths = _ref2.absolutePaths;
      cache_default.set(CACHE_KEY, {
        elementRef: elementRef,
        absolutePaths: absolutePaths
      });
    };
    var dq_element_default = DqElement;
    function checkHelper(checkResult, options, resolve, reject) {
      return {
        isAsync: false,
        async: function async() {
          this.isAsync = true;
          return function(result) {
            if (result instanceof Error === false) {
              checkResult.result = result;
              resolve(checkResult);
            } else {
              reject(result);
            }
          };
        },
        data: function data(_data) {
          checkResult.data = _data;
        },
        relatedNodes: function relatedNodes(nodes) {
          if (!window.Node) {
            return;
          }
          if (nodes instanceof window.Node || nodes instanceof abstract_virtual_node_default) {
            nodes = [ nodes ];
          } else {
            nodes = to_array_default(nodes);
          }
          checkResult.relatedNodes = [];
          nodes.forEach(function(node) {
            if (node instanceof abstract_virtual_node_default) {
              node = node.actualNode;
            }
            if (node instanceof window.Node) {
              var dqElm = new dq_element_default(node);
              checkResult.relatedNodes.push(dqElm);
            }
          });
        }
      };
    }
    var check_helper_default = checkHelper;
    function _clone(obj) {
      return cloneRecused(obj, new Map());
    }
    function cloneRecused(obj, seen) {
      var _window, _window2;
      if (obj === null || _typeof(obj) !== 'object') {
        return obj;
      }
      if ((_window = window) !== null && _window !== void 0 && _window.Node && obj instanceof window.Node || (_window2 = window) !== null && _window2 !== void 0 && _window2.HTMLCollection && obj instanceof window.HTMLCollection || 'nodeName' in obj && 'nodeType' in obj && 'ownerDocument' in obj) {
        return obj;
      }
      if (seen.has(obj)) {
        return seen.get(obj);
      }
      if (Array.isArray(obj)) {
        var out2 = [];
        seen.set(obj, out2);
        obj.forEach(function(value) {
          out2.push(cloneRecused(value, seen));
        });
        return out2;
      }
      var out = {};
      seen.set(obj, out);
      for (var key in obj) {
        out[key] = cloneRecused(obj[key], seen);
      }
      return out;
    }
    var import_css_selector_parser = __toModule(require_lib());
    var parser = new import_css_selector_parser.CssSelectorParser();
    parser.registerSelectorPseudos('not');
    parser.registerSelectorPseudos('is');
    parser.registerNestingOperators('>');
    parser.registerAttrEqualityMods('^', '$', '*', '~');
    var css_parser_default = parser;
    function _matches(vNode, selector) {
      var expressions = _convertSelector(selector);
      return expressions.some(function(expression) {
        return _matchesExpression(vNode, expression);
      });
    }
    function matchesTag(vNode, exp) {
      return vNode.props.nodeType === 1 && (exp.tag === '*' || vNode.props.nodeName === exp.tag);
    }
    function matchesClasses(vNode, exp) {
      return !exp.classes || exp.classes.every(function(cl) {
        return vNode.hasClass(cl.value);
      });
    }
    function matchesAttributes(vNode, exp) {
      return !exp.attributes || exp.attributes.every(function(att) {
        var nodeAtt = vNode.attr(att.key);
        return nodeAtt !== null && att.test(nodeAtt);
      });
    }
    function matchesId(vNode, exp) {
      return !exp.id || vNode.props.id === exp.id;
    }
    function matchesPseudos(target, exp) {
      if (!exp.pseudos || exp.pseudos.every(function(pseudo) {
        if (pseudo.name === 'not') {
          return !pseudo.expressions.some(function(expression) {
            return _matchesExpression(target, expression);
          });
        } else if (pseudo.name === 'is') {
          return pseudo.expressions.some(function(expression) {
            return _matchesExpression(target, expression);
          });
        }
        throw new Error('the pseudo selector ' + pseudo.name + ' has not yet been implemented');
      })) {
        return true;
      }
      return false;
    }
    function matchExpression(vNode, expression) {
      return matchesTag(vNode, expression) && matchesClasses(vNode, expression) && matchesAttributes(vNode, expression) && matchesId(vNode, expression) && matchesPseudos(vNode, expression);
    }
    var escapeRegExp = function() {
      var from = /(?=[\-\[\]{}()*+?.\\\^$|,#\s])/g;
      var to2 = '\\';
      return function(string) {
        return string.replace(from, to2);
      };
    }();
    var reUnescape = /\\/g;
    function convertAttributes(atts) {
      if (!atts) {
        return;
      }
      return atts.map(function(att) {
        var attributeKey = att.name.replace(reUnescape, '');
        var attributeValue = (att.value || '').replace(reUnescape, '');
        var test, regexp;
        switch (att.operator) {
         case '^=':
          regexp = new RegExp('^' + escapeRegExp(attributeValue));
          break;

         case '$=':
          regexp = new RegExp(escapeRegExp(attributeValue) + '$');
          break;

         case '~=':
          regexp = new RegExp('(^|\\s)' + escapeRegExp(attributeValue) + '(\\s|$)');
          break;

         case '|=':
          regexp = new RegExp('^' + escapeRegExp(attributeValue) + '(-|$)');
          break;

         case '=':
          test = function test(value) {
            return attributeValue === value;
          };
          break;

         case '*=':
          test = function test(value) {
            return value && value.includes(attributeValue);
          };
          break;

         case '!=':
          test = function test(value) {
            return attributeValue !== value;
          };
          break;

         default:
          test = function test(value) {
            return value !== null;
          };
        }
        if (attributeValue === '' && /^[*$^]=$/.test(att.operator)) {
          test = function test() {
            return false;
          };
        }
        if (!test) {
          test = function test(value) {
            return value && regexp.test(value);
          };
        }
        return {
          key: attributeKey,
          value: attributeValue,
          type: typeof att.value === 'undefined' ? 'attrExist' : 'attrValue',
          test: test
        };
      });
    }
    function convertClasses(classes) {
      if (!classes) {
        return;
      }
      return classes.map(function(className) {
        className = className.replace(reUnescape, '');
        return {
          value: className,
          regexp: new RegExp('(^|\\s)' + escapeRegExp(className) + '(\\s|$)')
        };
      });
    }
    function convertPseudos(pseudos) {
      if (!pseudos) {
        return;
      }
      return pseudos.map(function(p2) {
        var expressions;
        if ([ 'is', 'not' ].includes(p2.name)) {
          expressions = p2.value;
          expressions = expressions.selectors ? expressions.selectors : [ expressions ];
          expressions = convertExpressions(expressions);
        }
        return {
          name: p2.name,
          expressions: expressions,
          value: p2.value
        };
      });
    }
    function convertExpressions(expressions) {
      return expressions.map(function(exp) {
        var newExp = [];
        var rule = exp.rule;
        while (rule) {
          newExp.push({
            tag: rule.tagName ? rule.tagName.toLowerCase() : '*',
            combinator: rule.nestingOperator ? rule.nestingOperator : ' ',
            id: rule.id,
            attributes: convertAttributes(rule.attrs),
            classes: convertClasses(rule.classNames),
            pseudos: convertPseudos(rule.pseudos)
          });
          rule = rule.rule;
        }
        return newExp;
      });
    }
    function _convertSelector(selector) {
      var expressions = css_parser_default.parse(selector);
      expressions = expressions.selectors ? expressions.selectors : [ expressions ];
      return convertExpressions(expressions);
    }
    function optimizedMatchesExpression(vNode, expressions, index, matchAnyParent) {
      if (!vNode) {
        return false;
      }
      var isArray = Array.isArray(expressions);
      var expression = isArray ? expressions[index] : expressions;
      var machedExpression = matchExpression(vNode, expression);
      while (!machedExpression && matchAnyParent && vNode.parent) {
        vNode = vNode.parent;
        machedExpression = matchExpression(vNode, expression);
      }
      if (index > 0) {
        if ([ ' ', '>' ].includes(expression.combinator) === false) {
          throw new Error('axe.utils.matchesExpression does not support the combinator: ' + expression.combinator);
        }
        machedExpression = machedExpression && optimizedMatchesExpression(vNode.parent, expressions, index - 1, expression.combinator === ' ');
      }
      return machedExpression;
    }
    function _matchesExpression(vNode, expressions, matchAnyParent) {
      return optimizedMatchesExpression(vNode, expressions, expressions.length - 1, matchAnyParent);
    }
    function closest(vNode, selector) {
      while (vNode) {
        if (_matches(vNode, selector)) {
          return vNode;
        }
        if (typeof vNode.parent === 'undefined') {
          throw new TypeError('Cannot resolve parent for non-DOM nodes');
        }
        vNode = vNode.parent;
      }
      return null;
    }
    var closest_default = closest;
    function noop() {}
    function funcGuard(f) {
      if (typeof f !== 'function') {
        throw new TypeError('Queue methods require functions as arguments');
      }
    }
    function queue() {
      var tasks = [];
      var started = 0;
      var remaining = 0;
      var completeQueue = noop;
      var complete = false;
      var err2;
      var defaultFail = function defaultFail(e) {
        err2 = e;
        setTimeout(function() {
          if (err2 !== void 0 && err2 !== null) {
            log_default('Uncaught error (of queue)', err2);
          }
        }, 1);
      };
      var failed = defaultFail;
      function createResolve(i) {
        return function(r) {
          tasks[i] = r;
          remaining -= 1;
          if (!remaining && completeQueue !== noop) {
            complete = true;
            completeQueue(tasks);
          }
        };
      }
      function abort(msg) {
        completeQueue = noop;
        failed(msg);
        return tasks;
      }
      function pop() {
        var length = tasks.length;
        for (;started < length; started++) {
          var task = tasks[started];
          try {
            task.call(null, createResolve(started), abort);
          } catch (e) {
            abort(e);
          }
        }
      }
      var q = {
        defer: function defer(fn) {
          if (_typeof(fn) === 'object' && fn.then && fn['catch']) {
            var defer = fn;
            fn = function fn(resolve, reject) {
              defer.then(resolve)['catch'](reject);
            };
          }
          funcGuard(fn);
          if (err2 !== void 0) {
            return;
          } else if (complete) {
            throw new Error('Queue already completed');
          }
          tasks.push(fn);
          ++remaining;
          pop();
          return q;
        },
        then: function then(fn) {
          funcGuard(fn);
          if (completeQueue !== noop) {
            throw new Error('queue `then` already set');
          }
          if (!err2) {
            completeQueue = fn;
            if (!remaining) {
              complete = true;
              completeQueue(tasks);
            }
          }
          return q;
        },
        catch: function _catch(fn) {
          funcGuard(fn);
          if (failed !== defaultFail) {
            throw new Error('queue `catch` already set');
          }
          if (!err2) {
            failed = fn;
          } else {
            fn(err2);
            err2 = null;
          }
          return q;
        },
        abort: abort
      };
      return q;
    }
    var queue_default = queue;
    var uuid;
    var _rng;
    var _crypto = window.crypto || window.msCrypto;
    if (!_rng && _crypto && _crypto.getRandomValues) {
      _rnds8 = new Uint8Array(16);
      _rng = function whatwgRNG() {
        _crypto.getRandomValues(_rnds8);
        return _rnds8;
      };
    }
    var _rnds8;
    if (!_rng) {
      _rnds = new Array(16);
      _rng = function _rng() {
        for (var i = 0, r; i < 16; i++) {
          if ((i & 3) === 0) {
            r = Math.random() * 4294967296;
          }
          _rnds[i] = r >>> ((i & 3) << 3) & 255;
        }
        return _rnds;
      };
    }
    var _rnds;
    var BufferClass = typeof window.Buffer == 'function' ? window.Buffer : Array;
    var _byteToHex = [];
    var _hexToByte = {};
    for (var i = 0; i < 256; i++) {
      _byteToHex[i] = (i + 256).toString(16).substr(1);
      _hexToByte[_byteToHex[i]] = i;
    }
    function parse(s, buf, offset) {
      var i = buf && offset || 0, ii = 0;
      buf = buf || [];
      s.toLowerCase().replace(/[0-9a-f]{2}/g, function(oct) {
        if (ii < 16) {
          buf[i + ii++] = _hexToByte[oct];
        }
      });
      while (ii < 16) {
        buf[i + ii++] = 0;
      }
      return buf;
    }
    function unparse(buf, offset) {
      var i = offset || 0, bth = _byteToHex;
      return bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + '-' + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]] + bth[buf[i++]];
    }
    var _seedBytes = _rng();
    var _nodeId = [ _seedBytes[0] | 1, _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5] ];
    var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 16383;
    var _lastMSecs = 0;
    var _lastNSecs = 0;
    function v1(options, buf, offset) {
      var i = buf && offset || 0;
      var b2 = buf || [];
      options = options || {};
      var clockseq = options.clockseq != null ? options.clockseq : _clockseq;
      var msecs = options.msecs != null ? options.msecs : new Date().getTime();
      var nsecs = options.nsecs != null ? options.nsecs : _lastNSecs + 1;
      var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 1e4;
      if (dt < 0 && options.clockseq == null) {
        clockseq = clockseq + 1 & 16383;
      }
      if ((dt < 0 || msecs > _lastMSecs) && options.nsecs == null) {
        nsecs = 0;
      }
      if (nsecs >= 1e4) {
        throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
      }
      _lastMSecs = msecs;
      _lastNSecs = nsecs;
      _clockseq = clockseq;
      msecs += 122192928e5;
      var tl = ((msecs & 268435455) * 1e4 + nsecs) % 4294967296;
      b2[i++] = tl >>> 24 & 255;
      b2[i++] = tl >>> 16 & 255;
      b2[i++] = tl >>> 8 & 255;
      b2[i++] = tl & 255;
      var tmh = msecs / 4294967296 * 1e4 & 268435455;
      b2[i++] = tmh >>> 8 & 255;
      b2[i++] = tmh & 255;
      b2[i++] = tmh >>> 24 & 15 | 16;
      b2[i++] = tmh >>> 16 & 255;
      b2[i++] = clockseq >>> 8 | 128;
      b2[i++] = clockseq & 255;
      var node = options.node || _nodeId;
      for (var n2 = 0; n2 < 6; n2++) {
        b2[i + n2] = node[n2];
      }
      return buf ? buf : unparse(b2);
    }
    function v4(options, buf, offset) {
      var i = buf && offset || 0;
      if (typeof options == 'string') {
        buf = options == 'binary' ? new BufferClass(16) : null;
        options = null;
      }
      options = options || {};
      var rnds = options.random || (options.rng || _rng)();
      rnds[6] = rnds[6] & 15 | 64;
      rnds[8] = rnds[8] & 63 | 128;
      if (buf) {
        for (var ii = 0; ii < 16; ii++) {
          buf[i + ii] = rnds[ii];
        }
      }
      return buf || unparse(rnds);
    }
    uuid = v4;
    uuid.v1 = v1;
    uuid.v4 = v4;
    uuid.parse = parse;
    uuid.unparse = unparse;
    uuid.BufferClass = BufferClass;
    axe._uuid = v1();
    var uuid_default = v4;
    var errorTypes = Object.freeze([ 'EvalError', 'RangeError', 'ReferenceError', 'SyntaxError', 'TypeError', 'URIError' ]);
    function stringifyMessage(_ref3) {
      var topic = _ref3.topic, channelId = _ref3.channelId, message = _ref3.message, messageId = _ref3.messageId, keepalive = _ref3.keepalive;
      var data = {
        channelId: channelId,
        topic: topic,
        messageId: messageId,
        keepalive: !!keepalive,
        source: getSource2()
      };
      if (message instanceof Error) {
        data.error = {
          name: message.name,
          message: message.message,
          stack: message.stack
        };
      } else {
        data.payload = message;
      }
      return JSON.stringify(data);
    }
    function parseMessage(dataString) {
      var data;
      try {
        data = JSON.parse(dataString);
      } catch (e) {
        return;
      }
      if (!isRespondableMessage(data)) {
        return;
      }
      var _data2 = data, topic = _data2.topic, channelId = _data2.channelId, messageId = _data2.messageId, keepalive = _data2.keepalive;
      var message = _typeof(data.error) === 'object' ? buildErrorObject(data.error) : data.payload;
      return {
        topic: topic,
        message: message,
        messageId: messageId,
        channelId: channelId,
        keepalive: !!keepalive
      };
    }
    function isRespondableMessage(postedMessage) {
      return postedMessage !== null && _typeof(postedMessage) === 'object' && typeof postedMessage.channelId === 'string' && postedMessage.source === getSource2();
    }
    function buildErrorObject(error) {
      var msg = error.message || 'Unknown error occurred';
      var errorName = errorTypes.includes(error.name) ? error.name : 'Error';
      var ErrConstructor = window[errorName] || Error;
      if (error.stack) {
        msg += '\n' + error.stack.replace(error.message, '');
      }
      return new ErrConstructor(msg);
    }
    function getSource2() {
      var application = 'axeAPI';
      var version = '';
      if (typeof axe !== 'undefined' && axe._audit && axe._audit.application) {
        application = axe._audit.application;
      }
      if (typeof axe !== 'undefined') {
        version = axe.version;
      }
      return application + '.' + version;
    }
    function assertIsParentWindow(win) {
      assetNotGlobalWindow(win);
      assert_default(window.parent === win, 'Source of the response must be the parent window.');
    }
    function assertIsFrameWindow(win) {
      assetNotGlobalWindow(win);
      assert_default(win.parent === window, 'Respondable target must be a frame in the current window');
    }
    function assetNotGlobalWindow(win) {
      assert_default(window !== win, 'Messages can not be sent to the same window.');
    }
    var channels = {};
    function storeReplyHandler(channelId, replyHandler) {
      var sendToParent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      assert_default(!channels[channelId], 'A replyHandler already exists for this message channel.');
      channels[channelId] = {
        replyHandler: replyHandler,
        sendToParent: sendToParent
      };
    }
    function getReplyHandler(channelId) {
      return channels[channelId];
    }
    function deleteReplyHandler(channelId) {
      delete channels[channelId];
    }
    var messageIds = [];
    function createMessageId() {
      var uuid2 = ''.concat(v4(), ':').concat(v4());
      if (messageIds.includes(uuid2)) {
        return createMessageId();
      }
      messageIds.push(uuid2);
      return uuid2;
    }
    function isNewMessage(uuid2) {
      if (messageIds.includes(uuid2)) {
        return false;
      }
      messageIds.push(uuid2);
      return true;
    }
    function postMessage(win, data, sendToParent, replyHandler) {
      sendToParent ? assertIsParentWindow(win) : assertIsFrameWindow(win);
      if (data.message instanceof Error && !sendToParent) {
        axe.log(data.message);
        return false;
      }
      var dataString = stringifyMessage(_extends({
        messageId: createMessageId()
      }, data));
      var allowedOrigins = axe._audit.allowedOrigins;
      if (!allowedOrigins || !allowedOrigins.length) {
        return false;
      }
      if (typeof replyHandler === 'function') {
        storeReplyHandler(data.channelId, replyHandler, sendToParent);
      }
      allowedOrigins.forEach(function(origin) {
        try {
          win.postMessage(dataString, origin);
        } catch (err2) {
          if (err2 instanceof win.DOMException) {
            throw new Error('allowedOrigins value "'.concat(origin, '" is not a valid origin'));
          }
          throw err2;
        }
      });
      return true;
    }
    function processError(win, error, channelId) {
      if (!win.parent !== window) {
        return axe.log(error);
      }
      try {
        postMessage(win, {
          topic: null,
          channelId: channelId,
          message: error,
          messageId: createMessageId(),
          keepalive: true
        }, true);
      } catch (err2) {
        return axe.log(err2);
      }
    }
    function createResponder(win, channelId) {
      var sendToParent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      return function respond(message, keepalive, replyHandler) {
        var data = {
          channelId: channelId,
          message: message,
          keepalive: keepalive
        };
        postMessage(win, data, sendToParent, replyHandler);
      };
    }
    function originIsAllowed(origin) {
      var allowedOrigins = axe._audit.allowedOrigins;
      return allowedOrigins && allowedOrigins.includes('*') || allowedOrigins.includes(origin);
    }
    function messageHandler(_ref4, topicHandler) {
      var origin = _ref4.origin, dataString = _ref4.data, win = _ref4.source;
      try {
        var data = parseMessage(dataString) || {};
        var channelId = data.channelId, message = data.message, messageId = data.messageId;
        if (!originIsAllowed(origin) || !isNewMessage(messageId)) {
          return;
        }
        if (message instanceof Error && win.parent !== window) {
          axe.log(message);
          return false;
        }
        try {
          if (data.topic) {
            var responder = createResponder(win, channelId);
            assertIsParentWindow(win);
            topicHandler(data, responder);
          } else {
            callReplyHandler(win, data);
          }
        } catch (error) {
          processError(win, error, channelId);
        }
      } catch (error) {
        axe.log(error);
        return false;
      }
    }
    function callReplyHandler(win, data) {
      var channelId = data.channelId, message = data.message, keepalive = data.keepalive;
      var _ref5 = getReplyHandler(channelId) || {}, replyHandler = _ref5.replyHandler, sendToParent = _ref5.sendToParent;
      if (!replyHandler) {
        return;
      }
      sendToParent ? assertIsParentWindow(win) : assertIsFrameWindow(win);
      var responder = createResponder(win, channelId, sendToParent);
      if (!keepalive && channelId) {
        deleteReplyHandler(channelId);
      }
      try {
        replyHandler(message, keepalive, responder);
      } catch (error) {
        axe.log(error);
        responder(error, keepalive);
      }
    }
    var frameMessenger = {
      open: function open(topicHandler) {
        if (typeof window.addEventListener !== 'function') {
          return;
        }
        var handler = function handler(messageEvent) {
          messageHandler(messageEvent, topicHandler);
        };
        window.addEventListener('message', handler, false);
        return function() {
          window.removeEventListener('message', handler, false);
        };
      },
      post: function post(win, data, replyHandler) {
        if (typeof window.addEventListener !== 'function') {
          return false;
        }
        return postMessage(win, data, false, replyHandler);
      }
    };
    function setDefaultFrameMessenger(respondable2) {
      respondable2.updateMessenger(frameMessenger);
    }
    var closeHandler;
    var postMessage2;
    var topicHandlers = {};
    function _respondable(win, topic, message, keepalive, replyHandler) {
      var data = {
        topic: topic,
        message: message,
        channelId: ''.concat(v4(), ':').concat(v4()),
        keepalive: keepalive
      };
      return postMessage2(win, data, replyHandler);
    }
    function messageListener(data, responder) {
      var topic = data.topic, message = data.message, keepalive = data.keepalive;
      var topicHandler = topicHandlers[topic];
      if (!topicHandler) {
        return;
      }
      try {
        topicHandler(message, keepalive, responder);
      } catch (error) {
        axe.log(error);
        responder(error, keepalive);
      }
    }
    _respondable.updateMessenger = function updateMessenger(_ref6) {
      var open = _ref6.open, post = _ref6.post;
      assert_default(typeof open === 'function', 'open callback must be a function');
      assert_default(typeof post === 'function', 'post callback must be a function');
      if (closeHandler) {
        closeHandler();
      }
      var close = open(messageListener);
      if (close) {
        assert_default(typeof close === 'function', 'open callback must return a cleanup function');
        closeHandler = close;
      } else {
        closeHandler = null;
      }
      postMessage2 = post;
    };
    _respondable.subscribe = function subscribe(topic, topicHandler) {
      assert_default(typeof topicHandler === 'function', 'Subscriber callback must be a function');
      assert_default(!topicHandlers[topic], 'Topic '.concat(topic, ' is already registered to.'));
      topicHandlers[topic] = topicHandler;
    };
    _respondable.isInFrame = function isInFrame() {
      var win = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;
      return !!win.frameElement;
    };
    setDefaultFrameMessenger(_respondable);
    function _sendCommandToFrame(node, parameters, resolve, reject) {
      var _parameters$options$p, _parameters$options;
      var win = node.contentWindow;
      var pingWaitTime = (_parameters$options$p = (_parameters$options = parameters.options) === null || _parameters$options === void 0 ? void 0 : _parameters$options.pingWaitTime) !== null && _parameters$options$p !== void 0 ? _parameters$options$p : 500;
      if (!win) {
        log_default('Frame does not have a content window', node);
        resolve(null);
        return;
      }
      if (pingWaitTime === 0) {
        callAxeStart(node, parameters, resolve, reject);
        return;
      }
      var timeout = setTimeout(function() {
        timeout = setTimeout(function() {
          if (!parameters.debug) {
            resolve(null);
          } else {
            reject(err('No response from frame', node));
          }
        }, 0);
      }, pingWaitTime);
      _respondable(win, 'axe.ping', null, void 0, function() {
        clearTimeout(timeout);
        callAxeStart(node, parameters, resolve, reject);
      });
    }
    function callAxeStart(node, parameters, resolve, reject) {
      var _parameters$options$f, _parameters$options2;
      var frameWaitTime = (_parameters$options$f = (_parameters$options2 = parameters.options) === null || _parameters$options2 === void 0 ? void 0 : _parameters$options2.frameWaitTime) !== null && _parameters$options$f !== void 0 ? _parameters$options$f : 6e4;
      var win = node.contentWindow;
      var timeout = setTimeout(function collectResultFramesTimeout() {
        reject(err('Axe in frame timed out', node));
      }, frameWaitTime);
      _respondable(win, 'axe.start', parameters, void 0, function(data) {
        clearTimeout(timeout);
        if (data instanceof Error === false) {
          resolve(data);
        } else {
          reject(data);
        }
      });
    }
    function err(message, node) {
      var selector;
      if (axe._tree) {
        selector = _getSelector(node);
      }
      return new Error(message + ': ' + (selector || node));
    }
    var customSerializer = null;
    var nodeSerializer = {
      update: function update(serializer) {
        assert_default(_typeof(serializer) === 'object', 'serializer must be an object');
        customSerializer = serializer;
      },
      toSpec: function toSpec(node) {
        return nodeSerializer.dqElmToSpec(new dq_element_default(node));
      },
      dqElmToSpec: function dqElmToSpec(dqElm, runOptions) {
        var _customSerializer;
        if (dqElm instanceof dq_element_default === false) {
          return dqElm;
        }
        if (runOptions) {
          dqElm = cloneLimitedDqElement(dqElm, runOptions);
        }
        if (typeof ((_customSerializer = customSerializer) === null || _customSerializer === void 0 ? void 0 : _customSerializer.toSpec) === 'function') {
          return customSerializer.toSpec(dqElm);
        }
        return dqElm.toJSON();
      },
      mergeSpecs: function mergeSpecs(nodeSpec, parentFrameSpec) {
        var _customSerializer2;
        if (typeof ((_customSerializer2 = customSerializer) === null || _customSerializer2 === void 0 ? void 0 : _customSerializer2.mergeSpecs) === 'function') {
          return customSerializer.mergeSpecs(nodeSpec, parentFrameSpec);
        }
        return dq_element_default.mergeSpecs(nodeSpec, parentFrameSpec);
      },
      mapRawResults: function mapRawResults(rawResults) {
        return rawResults.map(function(rawResult) {
          return _extends({}, rawResult, {
            nodes: nodeSerializer.mapRawNodeResults(rawResult.nodes)
          });
        });
      },
      mapRawNodeResults: function mapRawNodeResults(nodeResults) {
        return nodeResults === null || nodeResults === void 0 ? void 0 : nodeResults.map(function(_ref7) {
          var node = _ref7.node, nodeResult = _objectWithoutProperties(_ref7, _excluded);
          nodeResult.node = nodeSerializer.dqElmToSpec(node);
          for (var _i2 = 0, _arr2 = [ 'any', 'all', 'none' ]; _i2 < _arr2.length; _i2++) {
            var type2 = _arr2[_i2];
            nodeResult[type2] = nodeResult[type2].map(function(_ref8) {
              var relatedNodes = _ref8.relatedNodes, checkResult = _objectWithoutProperties(_ref8, _excluded2);
              checkResult.relatedNodes = relatedNodes.map(nodeSerializer.dqElmToSpec);
              return checkResult;
            });
          }
          return nodeResult;
        });
      }
    };
    var node_serializer_default = nodeSerializer;
    function cloneLimitedDqElement(dqElm, runOptions) {
      var fromFrame2 = dqElm.fromFrame;
      var hasAncestry = runOptions.ancestry, hasXpath = runOptions.xpath;
      var hasSelectors = runOptions.selectors !== false || fromFrame2;
      dqElm = new dq_element_default(dqElm.element, runOptions, {
        source: dqElm.source,
        nodeIndexes: dqElm.nodeIndexes,
        selector: hasSelectors ? dqElm.selector : [ ':root' ],
        ancestry: hasAncestry ? dqElm.ancestry : [ ':root' ],
        xpath: hasXpath ? dqElm.xpath : '/'
      });
      dqElm.fromFrame = fromFrame2;
      return dqElm;
    }
    function getAllChecks(object) {
      var result = [];
      return result.concat(object.any || []).concat(object.all || []).concat(object.none || []);
    }
    var get_all_checks_default = getAllChecks;
    function findBy(array, key, value) {
      if (Array.isArray(array)) {
        return array.find(function(obj) {
          return obj !== null && _typeof(obj) === 'object' && Object.hasOwn(obj, key) && obj[key] === value;
        });
      }
    }
    var find_by_default = findBy;
    function pushFrame(resultSet, options, frameSpec) {
      resultSet.forEach(function(res) {
        res.node = node_serializer_default.mergeSpecs(res.node, frameSpec);
        var checks = get_all_checks_default(res);
        checks.forEach(function(check) {
          check.relatedNodes = check.relatedNodes.map(function(node) {
            return node_serializer_default.mergeSpecs(node, frameSpec);
          });
        });
      });
    }
    function spliceNodes(target, to2) {
      var firstFromFrame = to2[0].node;
      for (var _i3 = 0; _i3 < target.length; _i3++) {
        var node = target[_i3].node;
        var resultSort = nodeIndexSort(node.nodeIndexes, firstFromFrame.nodeIndexes);
        if (resultSort > 0 || resultSort === 0 && firstFromFrame.selector.length < node.selector.length) {
          target.splice.apply(target, [ _i3, 0 ].concat(_toConsumableArray(to2)));
          return;
        }
      }
      target.push.apply(target, _toConsumableArray(to2));
    }
    function normalizeResult(result) {
      if (!result || !result.results) {
        return null;
      }
      if (!Array.isArray(result.results)) {
        return [ result.results ];
      }
      if (!result.results.length) {
        return null;
      }
      return result.results;
    }
    function mergeResults(frameResults, options) {
      var mergedResult = [];
      frameResults.forEach(function(frameResult) {
        var results = normalizeResult(frameResult);
        if (!results || !results.length) {
          return;
        }
        var frameSpec = getFrameSpec(frameResult);
        results.forEach(function(ruleResult) {
          if (ruleResult.nodes && frameSpec) {
            pushFrame(ruleResult.nodes, options, frameSpec);
          }
          var res = find_by_default(mergedResult, 'id', ruleResult.id);
          if (!res) {
            mergedResult.push(ruleResult);
          } else {
            if (ruleResult.nodes.length) {
              spliceNodes(res.nodes, ruleResult.nodes);
            }
          }
        });
      });
      mergedResult.forEach(function(result) {
        if (result.nodes) {
          result.nodes.sort(function(nodeA, nodeB) {
            return nodeIndexSort(nodeA.node.nodeIndexes, nodeB.node.nodeIndexes);
          });
        }
      });
      return mergedResult;
    }
    function nodeIndexSort() {
      var nodeIndexesA = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var nodeIndexesB = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var length = Math.max(nodeIndexesA === null || nodeIndexesA === void 0 ? void 0 : nodeIndexesA.length, nodeIndexesB === null || nodeIndexesB === void 0 ? void 0 : nodeIndexesB.length);
      for (var _i4 = 0; _i4 < length; _i4++) {
        var indexA = nodeIndexesA === null || nodeIndexesA === void 0 ? void 0 : nodeIndexesA[_i4];
        var indexB = nodeIndexesB === null || nodeIndexesB === void 0 ? void 0 : nodeIndexesB[_i4];
        if (typeof indexA !== 'number' || isNaN(indexA)) {
          return _i4 === 0 ? 1 : -1;
        }
        if (typeof indexB !== 'number' || isNaN(indexB)) {
          return _i4 === 0 ? -1 : 1;
        }
        if (indexA !== indexB) {
          return indexA - indexB;
        }
      }
      return 0;
    }
    var merge_results_default = mergeResults;
    function getFrameSpec(frameResult) {
      if (frameResult.frameElement) {
        return node_serializer_default.toSpec(frameResult.frameElement);
      } else if (frameResult.frameSpec) {
        return frameResult.frameSpec;
      }
      return null;
    }
    function _collectResultsFromFrames(parentContent, options, command, parameter, resolve, reject) {
      options = _extends({}, options, {
        elementRef: false
      });
      var q = queue_default();
      var frames = parentContent.frames;
      frames.forEach(function(_ref9) {
        var frameElement = _ref9.node, context = _objectWithoutProperties(_ref9, _excluded3);
        q.defer(function(res, rej) {
          var params = {
            options: options,
            command: command,
            parameter: parameter,
            context: context
          };
          function callback(results) {
            if (!results) {
              return res(null);
            }
            return res({
              results: results,
              frameElement: frameElement
            });
          }
          _sendCommandToFrame(frameElement, params, callback, rej);
        });
      });
      q.then(function(data) {
        resolve(merge_results_default(data, options));
      })['catch'](reject);
    }
    function _contains(vNode, otherVNode) {
      if (!vNode.shadowId && !otherVNode.shadowId && vNode.actualNode && typeof vNode.actualNode.contains === 'function') {
        return vNode.actualNode.contains(otherVNode.actualNode);
      }
      do {
        if (vNode === otherVNode) {
          return true;
        } else if (otherVNode.nodeIndex < vNode.nodeIndex) {
          return false;
        }
        otherVNode = otherVNode.parent;
      } while (otherVNode);
      return false;
    }
    function deepMerge() {
      var target = {};
      for (var _len = arguments.length, sources = new Array(_len), _key = 0; _key < _len; _key++) {
        sources[_key] = arguments[_key];
      }
      sources.forEach(function(source) {
        if (!source || _typeof(source) !== 'object' || Array.isArray(source)) {
          return;
        }
        for (var _i5 = 0, _Object$keys = Object.keys(source); _i5 < _Object$keys.length; _i5++) {
          var key = _Object$keys[_i5];
          if (!target.hasOwnProperty(key) || _typeof(source[key]) !== 'object' || Array.isArray(target[key])) {
            target[key] = source[key];
          } else {
            target[key] = deepMerge(target[key], source[key]);
          }
        }
      });
      return target;
    }
    var deep_merge_default = deepMerge;
    function extendMetaData(to2, from) {
      Object.assign(to2, from);
      Object.keys(from).filter(function(prop) {
        return typeof from[prop] === 'function';
      }).forEach(function(prop) {
        to2[prop] = null;
        try {
          to2[prop] = from[prop](to2);
        } catch (e) {}
      });
    }
    var extend_meta_data_default = extendMetaData;
    var possibleShadowRoots = [ 'article', 'aside', 'blockquote', 'body', 'div', 'footer', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'main', 'nav', 'p', 'section', 'span' ];
    function isShadowRoot(node) {
      if (node.shadowRoot) {
        var nodeName2 = node.nodeName.toLowerCase();
        if (possibleShadowRoots.includes(nodeName2) || /^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(nodeName2)) {
          return true;
        }
      }
      return false;
    }
    var is_shadow_root_default = isShadowRoot;
    var dom_exports = {};
    __export(dom_exports, {
      createGrid: function createGrid() {
        return _createGrid;
      },
      findElmsInContext: function findElmsInContext() {
        return find_elms_in_context_default;
      },
      findNearbyElms: function findNearbyElms() {
        return _findNearbyElms;
      },
      findUp: function findUp() {
        return find_up_default;
      },
      findUpVirtual: function findUpVirtual() {
        return find_up_virtual_default;
      },
      focusDisabled: function focusDisabled() {
        return focus_disabled_default;
      },
      getComposedParent: function getComposedParent() {
        return get_composed_parent_default;
      },
      getElementByReference: function getElementByReference() {
        return get_element_by_reference_default;
      },
      getElementCoordinates: function getElementCoordinates() {
        return get_element_coordinates_default;
      },
      getElementStack: function getElementStack() {
        return get_element_stack_default;
      },
      getModalDialog: function getModalDialog() {
        return get_modal_dialog_default;
      },
      getOverflowHiddenAncestors: function getOverflowHiddenAncestors() {
        return get_overflow_hidden_ancestors_default;
      },
      getRootNode: function getRootNode() {
        return get_root_node_default2;
      },
      getScrollOffset: function getScrollOffset() {
        return get_scroll_offset_default;
      },
      getTabbableElements: function getTabbableElements() {
        return get_tabbable_elements_default;
      },
      getTargetRects: function getTargetRects() {
        return get_target_rects_default;
      },
      getTargetSize: function getTargetSize() {
        return get_target_size_default;
      },
      getTextElementStack: function getTextElementStack() {
        return get_text_element_stack_default;
      },
      getViewportSize: function getViewportSize() {
        return get_viewport_size_default;
      },
      getVisibleChildTextRects: function getVisibleChildTextRects() {
        return get_visible_child_text_rects_default;
      },
      hasContent: function hasContent() {
        return has_content_default;
      },
      hasContentVirtual: function hasContentVirtual() {
        return has_content_virtual_default;
      },
      hasLangText: function hasLangText() {
        return _hasLangText;
      },
      idrefs: function idrefs() {
        return idrefs_default;
      },
      insertedIntoFocusOrder: function insertedIntoFocusOrder() {
        return inserted_into_focus_order_default;
      },
      isCurrentPageLink: function isCurrentPageLink() {
        return _isCurrentPageLink;
      },
      isFocusable: function isFocusable() {
        return _isFocusable;
      },
      isHTML5: function isHTML5() {
        return is_html5_default;
      },
      isHiddenForEveryone: function isHiddenForEveryone() {
        return _isHiddenForEveryone;
      },
      isHiddenWithCSS: function isHiddenWithCSS() {
        return is_hidden_with_css_default;
      },
      isInTabOrder: function isInTabOrder() {
        return _isInTabOrder;
      },
      isInTextBlock: function isInTextBlock() {
        return is_in_text_block_default;
      },
      isInert: function isInert() {
        return _isInert;
      },
      isModalOpen: function isModalOpen() {
        return is_modal_open_default;
      },
      isMultiline: function isMultiline() {
        return _isMultiline;
      },
      isNativelyFocusable: function isNativelyFocusable() {
        return is_natively_focusable_default;
      },
      isNode: function isNode() {
        return is_node_default;
      },
      isOffscreen: function isOffscreen() {
        return is_offscreen_default;
      },
      isOpaque: function isOpaque() {
        return is_opaque_default;
      },
      isSkipLink: function isSkipLink() {
        return _isSkipLink;
      },
      isVisible: function isVisible() {
        return is_visible_default;
      },
      isVisibleOnScreen: function isVisibleOnScreen() {
        return _isVisibleOnScreen;
      },
      isVisibleToScreenReaders: function isVisibleToScreenReaders() {
        return _isVisibleToScreenReaders;
      },
      isVisualContent: function isVisualContent() {
        return is_visual_content_default;
      },
      reduceToElementsBelowFloating: function reduceToElementsBelowFloating() {
        return reduce_to_elements_below_floating_default;
      },
      shadowElementsFromPoint: function shadowElementsFromPoint() {
        return shadow_elements_from_point_default;
      },
      urlPropsFromAttribute: function urlPropsFromAttribute() {
        return url_props_from_attribute_default;
      },
      visuallyContains: function visuallyContains() {
        return _visuallyContains;
      },
      visuallyOverlaps: function visuallyOverlaps() {
        return visually_overlaps_default;
      },
      visuallySort: function visuallySort() {
        return _visuallySort;
      }
    });
    function getRootNode(node) {
      var doc = node.getRootNode && node.getRootNode() || document;
      if (doc === node) {
        doc = document;
      }
      return doc;
    }
    var get_root_node_default = getRootNode;
    var get_root_node_default2 = get_root_node_default;
    function findElmsInContext(_ref10) {
      var context = _ref10.context, value = _ref10.value, attr = _ref10.attr, _ref10$elm = _ref10.elm, elm = _ref10$elm === void 0 ? '' : _ref10$elm;
      var root;
      var escapedValue = escape_selector_default(value);
      if (context.nodeType === 9 || context.nodeType === 11) {
        root = context;
      } else {
        root = get_root_node_default2(context);
      }
      return Array.from(root.querySelectorAll(elm + '[' + attr + '=' + escapedValue + ']'));
    }
    var find_elms_in_context_default = findElmsInContext;
    function findUpVirtual(element, target) {
      var parent;
      parent = element.actualNode;
      if (!element.shadowId && typeof element.actualNode.closest === 'function') {
        var match = element.actualNode.closest(target);
        if (match) {
          return match;
        }
        return null;
      }
      do {
        parent = parent.assignedSlot ? parent.assignedSlot : parent.parentNode;
        if (parent && parent.nodeType === 11) {
          parent = parent.host;
        }
      } while (parent && !element_matches_default(parent, target) && parent !== document.documentElement);
      if (!parent) {
        return null;
      }
      if (!element_matches_default(parent, target)) {
        return null;
      }
      return parent;
    }
    var find_up_virtual_default = findUpVirtual;
    function findUp(element, target) {
      return find_up_virtual_default(get_node_from_tree_default(element), target);
    }
    var find_up_default = findUp;
    function _rectsOverlap(rect1, rect2) {
      return (rect1.left | 0) < (rect2.right | 0) && (rect1.right | 0) > (rect2.left | 0) && (rect1.top | 0) < (rect2.bottom | 0) && (rect1.bottom | 0) > (rect2.top | 0);
    }
    var getOverflowHiddenAncestors = memoize_default(function getOverflowHiddenAncestorsMemoized(vNode) {
      var ancestors = [];
      if (!vNode) {
        return ancestors;
      }
      var overflow = vNode.getComputedStylePropertyValue('overflow');
      if (overflow === 'hidden') {
        ancestors.push(vNode);
      }
      return ancestors.concat(getOverflowHiddenAncestors(vNode.parent));
    });
    var get_overflow_hidden_ancestors_default = getOverflowHiddenAncestors;
    var clipRegex = /rect\s*\(([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px\s*\)/;
    var clipPathRegex = /(\w+)\((\d+)/;
    function nativelyHidden(vNode) {
      return [ 'style', 'script', 'noscript', 'template' ].includes(vNode.props.nodeName);
    }
    function displayHidden(vNode) {
      if (vNode.props.nodeName === 'area') {
        return false;
      }
      return vNode.getComputedStylePropertyValue('display') === 'none';
    }
    function visibilityHidden(vNode) {
      var _ref11 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, isAncestor = _ref11.isAncestor;
      return !isAncestor && [ 'hidden', 'collapse' ].includes(vNode.getComputedStylePropertyValue('visibility'));
    }
    function contentVisibiltyHidden(vNode) {
      var _ref12 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, isAncestor = _ref12.isAncestor;
      return !!isAncestor && vNode.getComputedStylePropertyValue('content-visibility') === 'hidden';
    }
    function ariaHidden(vNode) {
      return vNode.attr('aria-hidden') === 'true';
    }
    function opacityHidden(vNode) {
      return vNode.getComputedStylePropertyValue('opacity') === '0';
    }
    function scrollHidden(vNode) {
      var scroll = get_scroll_default(vNode.actualNode);
      var elHeight = parseInt(vNode.getComputedStylePropertyValue('height'));
      var elWidth = parseInt(vNode.getComputedStylePropertyValue('width'));
      return !!scroll && (elHeight === 0 || elWidth === 0);
    }
    function overflowHidden(vNode) {
      var _ref13 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, isAncestor = _ref13.isAncestor;
      if (isAncestor) {
        return false;
      }
      var rect = vNode.boundingClientRect;
      var nodes = get_overflow_hidden_ancestors_default(vNode);
      if (!nodes.length) {
        return false;
      }
      return nodes.some(function(node) {
        var nodeRect = node.boundingClientRect;
        if (nodeRect.width < 2 || nodeRect.height < 2) {
          return true;
        }
        return !_rectsOverlap(rect, nodeRect);
      });
    }
    function clipHidden(vNode) {
      var matchesClip = vNode.getComputedStylePropertyValue('clip').match(clipRegex);
      var matchesClipPath = vNode.getComputedStylePropertyValue('clip-path').match(clipPathRegex);
      if (matchesClip && matchesClip.length === 5) {
        var position = vNode.getComputedStylePropertyValue('position');
        if ([ 'fixed', 'absolute' ].includes(position)) {
          return matchesClip[3] - matchesClip[1] <= 0 && matchesClip[2] - matchesClip[4] <= 0;
        }
      }
      if (matchesClipPath) {
        var type2 = matchesClipPath[1];
        var value = parseInt(matchesClipPath[2], 10);
        switch (type2) {
         case 'inset':
          return value >= 50;

         case 'circle':
          return value === 0;

         default:
        }
      }
      return false;
    }
    function areaHidden(vNode, visibleFunction) {
      var mapEl = closest_default(vNode, 'map');
      if (!mapEl) {
        return true;
      }
      var mapElName = mapEl.attr('name');
      if (!mapElName) {
        return true;
      }
      var mapElRootNode = get_root_node_default(vNode.actualNode);
      if (!mapElRootNode || mapElRootNode.nodeType !== 9) {
        return true;
      }
      var refs = query_selector_all_default(axe._tree, 'img[usemap="#'.concat(escape_selector_default(mapElName), '"]'));
      if (!refs || !refs.length) {
        return true;
      }
      return refs.some(function(ref) {
        return !visibleFunction(ref);
      });
    }
    function detailsHidden(vNode) {
      var _vNode$parent;
      if (((_vNode$parent = vNode.parent) === null || _vNode$parent === void 0 ? void 0 : _vNode$parent.props.nodeName) !== 'details') {
        return false;
      }
      if (vNode.props.nodeName === 'summary') {
        var firstSummary = vNode.parent.children.find(function(node) {
          return node.props.nodeName === 'summary';
        });
        if (firstSummary === vNode) {
          return false;
        }
      }
      return !vNode.parent.hasAttr('open');
    }
    var hiddenMethods = [ displayHidden, visibilityHidden, contentVisibiltyHidden, detailsHidden ];
    function _isHiddenForEveryone(vNode) {
      var _ref14 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, skipAncestors = _ref14.skipAncestors, _ref14$isAncestor = _ref14.isAncestor, isAncestor = _ref14$isAncestor === void 0 ? false : _ref14$isAncestor;
      vNode = _nodeLookup(vNode).vNode;
      if (skipAncestors) {
        return isHiddenSelf(vNode, isAncestor);
      }
      return isHiddenAncestors(vNode, isAncestor);
    }
    var isHiddenSelf = memoize_default(function isHiddenSelfMemoized(vNode, isAncestor) {
      if (nativelyHidden(vNode)) {
        return true;
      }
      if (!vNode.actualNode) {
        return false;
      }
      if (hiddenMethods.some(function(method) {
        return method(vNode, {
          isAncestor: isAncestor
        });
      })) {
        return true;
      }
      if (!vNode.actualNode.isConnected) {
        return true;
      }
      return false;
    });
    var isHiddenAncestors = memoize_default(function isHiddenAncestorsMemoized(vNode, isAncestor) {
      if (isHiddenSelf(vNode, isAncestor)) {
        return true;
      }
      if (!vNode.parent) {
        return false;
      }
      return isHiddenAncestors(vNode.parent, true);
    });
    function getComposedParent(element) {
      if (element.assignedSlot) {
        return getComposedParent(element.assignedSlot);
      } else if (element.parentNode) {
        var parentNode = element.parentNode;
        if (parentNode.nodeType === 1) {
          return parentNode;
        } else if (parentNode.host) {
          return parentNode.host;
        }
      }
      return null;
    }
    var get_composed_parent_default = getComposedParent;
    function getScrollOffset(element) {
      if (!element.nodeType && element.document) {
        element = element.document;
      }
      if (element.nodeType === 9) {
        var docElement = element.documentElement, body = element.body;
        return {
          left: docElement && docElement.scrollLeft || body && body.scrollLeft || 0,
          top: docElement && docElement.scrollTop || body && body.scrollTop || 0
        };
      }
      return {
        left: element.scrollLeft,
        top: element.scrollTop
      };
    }
    var get_scroll_offset_default = getScrollOffset;
    function getElementCoordinates(element) {
      var scrollOffset = get_scroll_offset_default(document), xOffset = scrollOffset.left, yOffset = scrollOffset.top, coords = element.getBoundingClientRect();
      return {
        top: coords.top + yOffset,
        right: coords.right + xOffset,
        bottom: coords.bottom + yOffset,
        left: coords.left + xOffset,
        width: coords.right - coords.left,
        height: coords.bottom - coords.top
      };
    }
    var get_element_coordinates_default = getElementCoordinates;
    function getViewportSize(win) {
      var doc = win.document;
      var docElement = doc.documentElement;
      if (win.innerWidth) {
        return {
          width: win.innerWidth,
          height: win.innerHeight
        };
      }
      if (docElement) {
        return {
          width: docElement.clientWidth,
          height: docElement.clientHeight
        };
      }
      var body = doc.body;
      return {
        width: body.clientWidth,
        height: body.clientHeight
      };
    }
    var get_viewport_size_default = getViewportSize;
    function noParentScrolled(element, offset) {
      element = get_composed_parent_default(element);
      while (element && element.nodeName.toLowerCase() !== 'html') {
        if (element.scrollTop) {
          offset += element.scrollTop;
          if (offset >= 0) {
            return false;
          }
        }
        element = get_composed_parent_default(element);
      }
      return true;
    }
    function isOffscreen(element) {
      var _ref15 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, isAncestor = _ref15.isAncestor;
      if (isAncestor) {
        return false;
      }
      var _nodeLookup2 = _nodeLookup(element), domNode = _nodeLookup2.domNode;
      if (!domNode) {
        return void 0;
      }
      var leftBoundary;
      var docElement = document.documentElement;
      var styl = window.getComputedStyle(domNode);
      var dir = window.getComputedStyle(document.body || docElement).getPropertyValue('direction');
      var coords = get_element_coordinates_default(domNode);
      if (coords.bottom < 0 && (noParentScrolled(domNode, coords.bottom) || styl.position === 'absolute')) {
        return true;
      }
      if (coords.left === 0 && coords.right === 0) {
        return false;
      }
      if (dir === 'ltr') {
        if (coords.right <= 0) {
          return true;
        }
      } else {
        leftBoundary = Math.max(docElement.scrollWidth, get_viewport_size_default(window).width);
        if (coords.left >= leftBoundary) {
          return true;
        }
      }
      return false;
    }
    var is_offscreen_default = isOffscreen;
    var hiddenMethods2 = [ opacityHidden, scrollHidden, overflowHidden, clipHidden, is_offscreen_default ];
    function _isVisibleOnScreen(vNode) {
      vNode = _nodeLookup(vNode).vNode;
      return isVisibleOnScreenVirtual(vNode);
    }
    var isVisibleOnScreenVirtual = memoize_default(function isVisibleOnScreenMemoized(vNode, isAncestor) {
      if (vNode.actualNode && vNode.props.nodeName === 'area') {
        return !areaHidden(vNode, isVisibleOnScreenVirtual);
      }
      if (_isHiddenForEveryone(vNode, {
        skipAncestors: true,
        isAncestor: isAncestor
      })) {
        return false;
      }
      if (vNode.actualNode && hiddenMethods2.some(function(method) {
        return method(vNode, {
          isAncestor: isAncestor
        });
      })) {
        return false;
      }
      if (!vNode.parent) {
        return true;
      }
      return isVisibleOnScreenVirtual(vNode.parent, true);
    });
    function _getBoundingRect(rectA, rectB) {
      var top = Math.min(rectA.top, rectB.top);
      var right = Math.max(rectA.right, rectB.right);
      var bottom = Math.max(rectA.bottom, rectB.bottom);
      var left = Math.min(rectA.left, rectB.left);
      return new window.DOMRect(left, top, right - left, bottom - top);
    }
    function _isPointInRect(_ref16, _ref17) {
      var x = _ref16.x, y = _ref16.y;
      var top = _ref17.top, right = _ref17.right, bottom = _ref17.bottom, left = _ref17.left;
      return y >= top && x <= right && y <= bottom && x >= left;
    }
    var math_exports = {};
    __export(math_exports, {
      getBoundingRect: function getBoundingRect() {
        return _getBoundingRect;
      },
      getIntersectionRect: function getIntersectionRect() {
        return _getIntersectionRect;
      },
      getOffset: function getOffset() {
        return _getOffset;
      },
      getRectCenter: function getRectCenter() {
        return _getRectCenter;
      },
      hasVisualOverlap: function hasVisualOverlap() {
        return _hasVisualOverlap;
      },
      isPointInRect: function isPointInRect() {
        return _isPointInRect;
      },
      rectHasMinimumSize: function rectHasMinimumSize() {
        return _rectHasMinimumSize;
      },
      rectsOverlap: function rectsOverlap() {
        return _rectsOverlap;
      },
      splitRects: function splitRects() {
        return _splitRects;
      }
    });
    function _getIntersectionRect(rect1, rect2) {
      var leftX = Math.max(rect1.left, rect2.left);
      var rightX = Math.min(rect1.right, rect2.right);
      var topY = Math.max(rect1.top, rect2.top);
      var bottomY = Math.min(rect1.bottom, rect2.bottom);
      if (leftX >= rightX || topY >= bottomY) {
        return null;
      }
      return new window.DOMRect(leftX, topY, rightX - leftX, bottomY - topY);
    }
    function _getRectCenter(_ref18) {
      var left = _ref18.left, top = _ref18.top, width = _ref18.width, height = _ref18.height;
      return new window.DOMPoint(left + width / 2, top + height / 2);
    }
    var roundingMargin = .05;
    function _rectHasMinimumSize(minSize, _ref19) {
      var width = _ref19.width, height = _ref19.height;
      return width + roundingMargin >= minSize && height + roundingMargin >= minSize;
    }
    function _getOffset(vTarget, vNeighbor) {
      var minRadiusNeighbour = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 12;
      var targetRects = get_target_rects_default(vTarget);
      var neighborRects = get_target_rects_default(vNeighbor);
      if (!targetRects.length || !neighborRects.length) {
        return 0;
      }
      var targetBoundingBox = targetRects.reduce(_getBoundingRect);
      var targetCenter = _getRectCenter(targetBoundingBox);
      var minDistance = Infinity;
      var _iterator2 = _createForOfIteratorHelper(neighborRects), _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
          var rect = _step2.value;
          if (_isPointInRect(targetCenter, rect)) {
            return 0;
          }
          var closestPoint = getClosestPoint(targetCenter, rect);
          var distance2 = pointDistance(targetCenter, closestPoint);
          minDistance = Math.min(minDistance, distance2);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      var neighborTargetSize = get_target_size_default(vNeighbor);
      if (_rectHasMinimumSize(minRadiusNeighbour * 2, neighborTargetSize)) {
        return minDistance;
      }
      var neighborBoundingBox = neighborRects.reduce(_getBoundingRect);
      var neighborCenter = _getRectCenter(neighborBoundingBox);
      var centerDistance = pointDistance(targetCenter, neighborCenter) - minRadiusNeighbour;
      return Math.max(0, Math.min(minDistance, centerDistance));
    }
    function getClosestPoint(point, rect) {
      var x;
      var y;
      if (point.x < rect.left) {
        x = rect.left;
      } else if (point.x > rect.right) {
        x = rect.right;
      } else {
        x = point.x;
      }
      if (point.y < rect.top) {
        y = rect.top;
      } else if (point.y > rect.bottom) {
        y = rect.bottom;
      } else {
        y = point.y;
      }
      return {
        x: x,
        y: y
      };
    }
    function pointDistance(pointA, pointB) {
      return Math.hypot(pointA.x - pointB.x, pointA.y - pointB.y);
    }
    function _hasVisualOverlap(vNodeA, vNodeB) {
      var rectA = vNodeA.boundingClientRect;
      var rectB = vNodeB.boundingClientRect;
      if (rectA.left >= rectB.right || rectA.right <= rectB.left || rectA.top >= rectB.bottom || rectA.bottom <= rectB.top) {
        return false;
      }
      return _visuallySort(vNodeA, vNodeB) > 0;
    }
    function _splitRects(outerRect, overlapRects) {
      var uniqueRects = [ outerRect ];
      var _iterator3 = _createForOfIteratorHelper(overlapRects), _step3;
      try {
        var _loop3 = function _loop3() {
          var overlapRect = _step3.value;
          uniqueRects = uniqueRects.reduce(function(rects, inputRect) {
            return rects.concat(splitRect(inputRect, overlapRect));
          }, []);
        };
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done; ) {
          _loop3();
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return uniqueRects;
    }
    function splitRect(inputRect, clipRect) {
      var top = inputRect.top, left = inputRect.left, bottom = inputRect.bottom, right = inputRect.right;
      var yAligned = top < clipRect.bottom && bottom > clipRect.top;
      var xAligned = left < clipRect.right && right > clipRect.left;
      var rects = [];
      if (between(clipRect.top, top, bottom) && xAligned) {
        rects.push({
          top: top,
          left: left,
          bottom: clipRect.top,
          right: right
        });
      }
      if (between(clipRect.right, left, right) && yAligned) {
        rects.push({
          top: top,
          left: clipRect.right,
          bottom: bottom,
          right: right
        });
      }
      if (between(clipRect.bottom, top, bottom) && xAligned) {
        rects.push({
          top: clipRect.bottom,
          right: right,
          bottom: bottom,
          left: left
        });
      }
      if (between(clipRect.left, left, right) && yAligned) {
        rects.push({
          top: top,
          left: left,
          bottom: bottom,
          right: clipRect.left
        });
      }
      if (rects.length === 0) {
        if (isEnclosedRect(inputRect, clipRect)) {
          return [];
        }
        rects.push(inputRect);
      }
      return rects.map(computeRect);
    }
    var between = function between(num, min, max2) {
      return num > min && num < max2;
    };
    function computeRect(baseRect) {
      return new window.DOMRect(baseRect.left, baseRect.top, baseRect.right - baseRect.left, baseRect.bottom - baseRect.top);
    }
    function isEnclosedRect(rectA, rectB) {
      return rectA.top >= rectB.top && rectA.left >= rectB.left && rectA.bottom <= rectB.bottom && rectA.right <= rectB.right;
    }
    var ROOT_LEVEL = 0;
    var DEFAULT_LEVEL = .1;
    var FLOAT_LEVEL = .2;
    var POSITION_LEVEL = .3;
    var nodeIndex = 0;
    function _createGrid() {
      var root = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.body;
      var rootGrid = arguments.length > 1 ? arguments[1] : undefined;
      var parentVNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (cache_default.get('gridCreated') && !parentVNode) {
        return constants_default.gridSize;
      }
      cache_default.set('gridCreated', true);
      if (!parentVNode) {
        var _rootGrid;
        var vNode = get_node_from_tree_default(document.documentElement);
        if (!vNode) {
          vNode = new virtual_node_default(document.documentElement);
        }
        nodeIndex = 0;
        vNode._stackingOrder = [ createStackingContext(ROOT_LEVEL, nodeIndex++, null) ];
        (_rootGrid = rootGrid) !== null && _rootGrid !== void 0 ? _rootGrid : rootGrid = new Grid();
        addNodeToGrid(rootGrid, vNode);
        if (get_scroll_default(vNode.actualNode)) {
          var subGrid = new Grid(vNode);
          vNode._subGrid = subGrid;
        }
      }
      var treeWalker = document.createTreeWalker(root, window.NodeFilter.SHOW_ELEMENT, null, false);
      var node = parentVNode ? treeWalker.nextNode() : treeWalker.currentNode;
      while (node) {
        var _vNode = get_node_from_tree_default(node);
        if (_vNode && _vNode.parent) {
          parentVNode = _vNode.parent;
        } else if (node.assignedSlot) {
          parentVNode = get_node_from_tree_default(node.assignedSlot);
        } else if (node.parentElement) {
          parentVNode = get_node_from_tree_default(node.parentElement);
        } else if (node.parentNode && get_node_from_tree_default(node.parentNode)) {
          parentVNode = get_node_from_tree_default(node.parentNode);
        }
        if (!_vNode) {
          _vNode = new axe.VirtualNode(node, parentVNode);
        }
        _vNode._stackingOrder = createStackingOrder(_vNode, parentVNode, nodeIndex++);
        var scrollRegionParent = findScrollRegionParent(_vNode, parentVNode);
        var grid = scrollRegionParent ? scrollRegionParent._subGrid : rootGrid;
        if (get_scroll_default(_vNode.actualNode)) {
          var _subGrid = new Grid(_vNode);
          _vNode._subGrid = _subGrid;
        }
        var rect = _vNode.boundingClientRect;
        if (rect.width !== 0 && rect.height !== 0 && _isVisibleOnScreen(node)) {
          addNodeToGrid(grid, _vNode);
        }
        if (is_shadow_root_default(node)) {
          _createGrid(node.shadowRoot, grid, _vNode);
        }
        node = treeWalker.nextNode();
      }
      return constants_default.gridSize;
    }
    function isStackingContext(vNode, parentVNode) {
      var position = vNode.getComputedStylePropertyValue('position');
      var zIndex = vNode.getComputedStylePropertyValue('z-index');
      if (position === 'fixed' || position === 'sticky') {
        return true;
      }
      if (zIndex !== 'auto' && position !== 'static') {
        return true;
      }
      if (vNode.getComputedStylePropertyValue('opacity') !== '1') {
        return true;
      }
      var transform = vNode.getComputedStylePropertyValue('-webkit-transform') || vNode.getComputedStylePropertyValue('-ms-transform') || vNode.getComputedStylePropertyValue('transform') || 'none';
      if (transform !== 'none') {
        return true;
      }
      var mixBlendMode = vNode.getComputedStylePropertyValue('mix-blend-mode');
      if (mixBlendMode && mixBlendMode !== 'normal') {
        return true;
      }
      var filter = vNode.getComputedStylePropertyValue('filter');
      if (filter && filter !== 'none') {
        return true;
      }
      var perspective = vNode.getComputedStylePropertyValue('perspective');
      if (perspective && perspective !== 'none') {
        return true;
      }
      var clipPath = vNode.getComputedStylePropertyValue('clip-path');
      if (clipPath && clipPath !== 'none') {
        return true;
      }
      var mask = vNode.getComputedStylePropertyValue('-webkit-mask') || vNode.getComputedStylePropertyValue('mask') || 'none';
      if (mask !== 'none') {
        return true;
      }
      var maskImage = vNode.getComputedStylePropertyValue('-webkit-mask-image') || vNode.getComputedStylePropertyValue('mask-image') || 'none';
      if (maskImage !== 'none') {
        return true;
      }
      var maskBorder = vNode.getComputedStylePropertyValue('-webkit-mask-border') || vNode.getComputedStylePropertyValue('mask-border') || 'none';
      if (maskBorder !== 'none') {
        return true;
      }
      if (vNode.getComputedStylePropertyValue('isolation') === 'isolate') {
        return true;
      }
      var willChange = vNode.getComputedStylePropertyValue('will-change');
      if (willChange === 'transform' || willChange === 'opacity') {
        return true;
      }
      if (vNode.getComputedStylePropertyValue('-webkit-overflow-scrolling') === 'touch') {
        return true;
      }
      var contain = vNode.getComputedStylePropertyValue('contain');
      if ([ 'layout', 'paint', 'strict', 'content' ].includes(contain)) {
        return true;
      }
      if (zIndex !== 'auto' && isFlexOrGridContainer(parentVNode)) {
        return true;
      }
      return false;
    }
    function isFlexOrGridContainer(vNode) {
      if (!vNode) {
        return false;
      }
      var display2 = vNode.getComputedStylePropertyValue('display');
      return [ 'flex', 'inline-flex', 'grid', 'inline-grid' ].includes(display2);
    }
    function createStackingOrder(vNode, parentVNode, treeOrder) {
      var stackingOrder = parentVNode._stackingOrder.slice();
      if (isStackingContext(vNode, parentVNode)) {
        var index = stackingOrder.findIndex(function(_ref20) {
          var stackLevel2 = _ref20.stackLevel;
          return [ ROOT_LEVEL, FLOAT_LEVEL, POSITION_LEVEL ].includes(stackLevel2);
        });
        if (index !== -1) {
          stackingOrder.splice(index, stackingOrder.length - index);
        }
      }
      var stackLevel = getStackLevel(vNode, parentVNode);
      if (stackLevel !== null) {
        stackingOrder.push(createStackingContext(stackLevel, treeOrder, vNode));
      }
      return stackingOrder;
    }
    function createStackingContext(stackLevel, treeOrder, vNode) {
      return {
        stackLevel: stackLevel,
        treeOrder: treeOrder,
        vNode: vNode
      };
    }
    function getStackLevel(vNode, parentVNode) {
      var zIndex = getRealZIndex(vNode, parentVNode);
      if (![ 'auto', '0' ].includes(zIndex)) {
        return parseInt(zIndex);
      }
      if (vNode.getComputedStylePropertyValue('position') !== 'static') {
        return POSITION_LEVEL;
      }
      if (vNode.getComputedStylePropertyValue('float') !== 'none') {
        return FLOAT_LEVEL;
      }
      if (isStackingContext(vNode, parentVNode)) {
        return DEFAULT_LEVEL;
      }
      return null;
    }
    function getRealZIndex(vNode, parentVNode) {
      var position = vNode.getComputedStylePropertyValue('position');
      if (position === 'static' && !isFlexOrGridContainer(parentVNode)) {
        return 'auto';
      }
      return vNode.getComputedStylePropertyValue('z-index');
    }
    function findScrollRegionParent(vNode, parentVNode) {
      var scrollRegionParent = null;
      var checkedNodes = [ vNode ];
      while (parentVNode) {
        if (get_scroll_default(parentVNode.actualNode)) {
          scrollRegionParent = parentVNode;
          break;
        }
        if (parentVNode._scrollRegionParent) {
          scrollRegionParent = parentVNode._scrollRegionParent;
          break;
        }
        checkedNodes.push(parentVNode);
        parentVNode = get_node_from_tree_default(parentVNode.actualNode.parentElement || parentVNode.actualNode.parentNode);
      }
      checkedNodes.forEach(function(virtualNode) {
        return virtualNode._scrollRegionParent = scrollRegionParent;
      });
      return scrollRegionParent;
    }
    function addNodeToGrid(grid, vNode) {
      var overflowHiddenNodes = get_overflow_hidden_ancestors_default(vNode);
      vNode.clientRects.forEach(function(clientRect) {
        var _vNode$_grid;
        var visibleRect = overflowHiddenNodes.reduce(function(rect, overflowNode) {
          return rect && _getIntersectionRect(rect, overflowNode.boundingClientRect);
        }, clientRect);
        if (!visibleRect) {
          return;
        }
        (_vNode$_grid = vNode._grid) !== null && _vNode$_grid !== void 0 ? _vNode$_grid : vNode._grid = grid;
        var gridRect = grid.getGridPositionOfRect(visibleRect);
        grid.loopGridPosition(gridRect, function(gridCell) {
          if (!gridCell.includes(vNode)) {
            gridCell.push(vNode);
          }
        });
      });
    }
    var Grid = function() {
      function Grid() {
        var container = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        _classCallCheck(this, Grid);
        this.container = container;
        this.cells = [];
      }
      _createClass(Grid, [ {
        key: 'toGridIndex',
        value: function toGridIndex(num) {
          return Math.floor(num / constants_default.gridSize);
        }
      }, {
        key: 'getCellFromPoint',
        value: function getCellFromPoint(_ref21) {
          var _this$cells, _row;
          var x = _ref21.x, y = _ref21.y;
          assert_default(this.boundaries, 'Grid does not have cells added');
          var rowIndex = this.toGridIndex(y);
          var colIndex = this.toGridIndex(x);
          assert_default(_isPointInRect({
            y: rowIndex,
            x: colIndex
          }, this.boundaries), 'Element midpoint exceeds the grid bounds');
          var row = (_this$cells = this.cells[rowIndex - this.cells._negativeIndex]) !== null && _this$cells !== void 0 ? _this$cells : [];
          return (_row = row[colIndex - row._negativeIndex]) !== null && _row !== void 0 ? _row : [];
        }
      }, {
        key: 'loopGridPosition',
        value: function loopGridPosition(gridPosition, callback) {
          var _gridPosition = gridPosition, left = _gridPosition.left, right = _gridPosition.right, top = _gridPosition.top, bottom = _gridPosition.bottom;
          if (this.boundaries) {
            gridPosition = _getBoundingRect(this.boundaries, gridPosition);
          }
          this.boundaries = gridPosition;
          loopNegativeIndexMatrix(this.cells, top, bottom, function(gridRow, row) {
            loopNegativeIndexMatrix(gridRow, left, right, function(gridCell, col) {
              callback(gridCell, {
                row: row,
                col: col
              });
            });
          });
        }
      }, {
        key: 'getGridPositionOfRect',
        value: function getGridPositionOfRect(_ref22) {
          var top = _ref22.top, right = _ref22.right, bottom = _ref22.bottom, left = _ref22.left;
          var margin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          top = this.toGridIndex(top - margin);
          right = this.toGridIndex(right + margin - 1);
          bottom = this.toGridIndex(bottom + margin - 1);
          left = this.toGridIndex(left - margin);
          return new window.DOMRect(left, top, right - left, bottom - top);
        }
      } ]);
      return Grid;
    }();
    function loopNegativeIndexMatrix(matrix, start, end, callback) {
      var _matrix$_negativeInde;
      (_matrix$_negativeInde = matrix._negativeIndex) !== null && _matrix$_negativeInde !== void 0 ? _matrix$_negativeInde : matrix._negativeIndex = 0;
      if (start < matrix._negativeIndex) {
        for (var _i6 = 0; _i6 < matrix._negativeIndex - start; _i6++) {
          matrix.splice(0, 0, []);
        }
        matrix._negativeIndex = start;
      }
      var startOffset = start - matrix._negativeIndex;
      var endOffset = end - matrix._negativeIndex;
      for (var index = startOffset; index <= endOffset; index++) {
        var _index, _matrix$_index;
        (_matrix$_index = matrix[_index = index]) !== null && _matrix$_index !== void 0 ? _matrix$_index : matrix[_index] = [];
        callback(matrix[index], index + matrix._negativeIndex);
      }
    }
    function _findNearbyElms(vNode) {
      var _vNode$_grid2, _vNode$_grid2$cells;
      var margin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      _createGrid();
      if (!((_vNode$_grid2 = vNode._grid) !== null && _vNode$_grid2 !== void 0 && (_vNode$_grid2$cells = _vNode$_grid2.cells) !== null && _vNode$_grid2$cells !== void 0 && _vNode$_grid2$cells.length)) {
        return [];
      }
      var rect = vNode.boundingClientRect;
      var grid = vNode._grid;
      var selfIsFixed = hasFixedPosition(vNode);
      var gridPosition = grid.getGridPositionOfRect(rect, margin);
      var neighbors = [];
      grid.loopGridPosition(gridPosition, function(vNeighbors) {
        var _iterator4 = _createForOfIteratorHelper(vNeighbors), _step4;
        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done; ) {
            var vNeighbor = _step4.value;
            if (vNeighbor && vNeighbor !== vNode && !neighbors.includes(vNeighbor) && selfIsFixed === hasFixedPosition(vNeighbor)) {
              neighbors.push(vNeighbor);
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      });
      return neighbors;
    }
    var hasFixedPosition = memoize_default(function(vNode) {
      if (!vNode) {
        return false;
      }
      if (vNode.getComputedStylePropertyValue('position') === 'fixed') {
        return true;
      }
      return hasFixedPosition(vNode.parent);
    });
    var getModalDialog = memoize_default(function getModalDialogMemoized() {
      var _dialogs$find;
      if (!axe._tree) {
        return null;
      }
      var dialogs = query_selector_all_filter_default(axe._tree[0], 'dialog[open]', function(vNode) {
        var rect = vNode.boundingClientRect;
        var stack = document.elementsFromPoint(rect.left + 1, rect.top + 1);
        return stack.includes(vNode.actualNode) && _isVisibleOnScreen(vNode);
      });
      if (!dialogs.length) {
        return null;
      }
      var modalDialog = dialogs.find(function(dialog) {
        var rect = dialog.boundingClientRect;
        var stack = document.elementsFromPoint(rect.left - 10, rect.top - 10);
        return stack.includes(dialog.actualNode);
      });
      if (modalDialog) {
        return modalDialog;
      }
      return (_dialogs$find = dialogs.find(function(dialog) {
        var _getNodeFromGrid;
        var _ref23 = (_getNodeFromGrid = getNodeFromGrid(dialog)) !== null && _getNodeFromGrid !== void 0 ? _getNodeFromGrid : {}, vNode = _ref23.vNode, rect = _ref23.rect;
        if (!vNode) {
          return false;
        }
        var stack = document.elementsFromPoint(rect.left + 1, rect.top + 1);
        return !stack.includes(vNode.actualNode);
      })) !== null && _dialogs$find !== void 0 ? _dialogs$find : null;
    });
    var get_modal_dialog_default = getModalDialog;
    function getNodeFromGrid(dialog) {
      _createGrid();
      var grid = axe._tree[0]._grid;
      var viewRect = new window.DOMRect(0, 0, window.innerWidth, window.innerHeight);
      if (!grid) {
        return;
      }
      for (var row = 0; row < grid.cells.length; row++) {
        var cols = grid.cells[row];
        if (!cols) {
          continue;
        }
        for (var col = 0; col < cols.length; col++) {
          var cells = cols[col];
          if (!cells) {
            continue;
          }
          for (var _i7 = 0; _i7 < cells.length; _i7++) {
            var vNode = cells[_i7];
            var rect = vNode.boundingClientRect;
            var intersection = _getIntersectionRect(rect, viewRect);
            if (vNode.props.nodeName !== 'html' && vNode !== dialog && vNode.getComputedStylePropertyValue('pointer-events') !== 'none' && intersection) {
              return {
                vNode: vNode,
                rect: intersection
              };
            }
          }
        }
      }
    }
    function _isInert(vNode) {
      var _ref24 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, skipAncestors = _ref24.skipAncestors, isAncestor = _ref24.isAncestor;
      if (skipAncestors) {
        return isInertSelf(vNode, isAncestor);
      }
      return isInertAncestors(vNode, isAncestor);
    }
    var isInertSelf = memoize_default(function isInertSelfMemoized(vNode, isAncestor) {
      if (vNode.hasAttr('inert')) {
        return true;
      }
      if (!isAncestor && vNode.actualNode) {
        var modalDialog = get_modal_dialog_default();
        if (modalDialog && !_contains(modalDialog, vNode)) {
          return true;
        }
      }
      return false;
    });
    var isInertAncestors = memoize_default(function isInertAncestorsMemoized(vNode, isAncestor) {
      if (isInertSelf(vNode, isAncestor)) {
        return true;
      }
      if (!vNode.parent) {
        return false;
      }
      return isInertAncestors(vNode.parent, true);
    });
    var allowedDisabledNodeNames = [ 'button', 'command', 'fieldset', 'keygen', 'optgroup', 'option', 'select', 'textarea', 'input' ];
    function isDisabledAttrAllowed(nodeName2) {
      return allowedDisabledNodeNames.includes(nodeName2);
    }
    function focusDisabled(el) {
      var _nodeLookup3 = _nodeLookup(el), vNode = _nodeLookup3.vNode;
      if (isDisabledAttrAllowed(vNode.props.nodeName) && vNode.hasAttr('disabled') || _isInert(vNode)) {
        return true;
      }
      var parentNode = vNode.parent;
      var ancestors = [];
      var fieldsetDisabled = false;
      while (parentNode && parentNode.shadowId === vNode.shadowId && !fieldsetDisabled) {
        ancestors.push(parentNode);
        if (parentNode.props.nodeName === 'legend') {
          break;
        }
        if (parentNode._inDisabledFieldset !== void 0) {
          fieldsetDisabled = parentNode._inDisabledFieldset;
          break;
        }
        if (parentNode.props.nodeName === 'fieldset' && parentNode.hasAttr('disabled')) {
          fieldsetDisabled = true;
        }
        parentNode = parentNode.parent;
      }
      ancestors.forEach(function(ancestor) {
        return ancestor._inDisabledFieldset = fieldsetDisabled;
      });
      if (fieldsetDisabled) {
        return true;
      }
      if (vNode.props.nodeName !== 'area') {
        if (!vNode.actualNode) {
          return false;
        }
        return _isHiddenForEveryone(vNode);
      }
      return false;
    }
    var focus_disabled_default = focusDisabled;
    var angularSkipLinkRegex = /^\/\#/;
    var angularRouterLinkRegex = /^#[!/]/;
    function _isCurrentPageLink(anchor) {
      var _window$location;
      var href = anchor.getAttribute('href');
      if (!href || href === '#') {
        return false;
      }
      if (angularSkipLinkRegex.test(href)) {
        return true;
      }
      var hash = anchor.hash, protocol = anchor.protocol, hostname = anchor.hostname, port = anchor.port, pathname = anchor.pathname;
      if (angularRouterLinkRegex.test(hash)) {
        return false;
      }
      if (href.charAt(0) === '#') {
        return true;
      }
      if (typeof ((_window$location = window.location) === null || _window$location === void 0 ? void 0 : _window$location.origin) !== 'string' || window.location.origin.indexOf('://') === -1) {
        return null;
      }
      var currentPageUrl = window.location.origin + window.location.pathname;
      var url;
      if (!hostname) {
        url = window.location.origin;
      } else {
        url = ''.concat(protocol, '//').concat(hostname).concat(port ? ':'.concat(port) : '');
      }
      if (!pathname) {
        url += window.location.pathname;
      } else {
        url += (pathname[0] !== '/' ? '/' : '') + pathname;
      }
      return url === currentPageUrl;
    }
    function getElementByReference(node, attr) {
      var fragment = node.getAttribute(attr);
      if (!fragment) {
        return null;
      }
      if (attr === 'href' && !_isCurrentPageLink(node)) {
        return null;
      }
      if (fragment.indexOf('#') !== -1) {
        fragment = decodeURIComponent(fragment.substr(fragment.indexOf('#') + 1));
      }
      var candidate = document.getElementById(fragment);
      if (candidate) {
        return candidate;
      }
      candidate = document.getElementsByName(fragment);
      if (candidate.length) {
        return candidate[0];
      }
      return null;
    }
    var get_element_by_reference_default = getElementByReference;
    function _visuallySort(a2, b2) {
      _createGrid();
      var length = Math.max(a2._stackingOrder.length, b2._stackingOrder.length);
      for (var _i8 = 0; _i8 < length; _i8++) {
        if (typeof b2._stackingOrder[_i8] === 'undefined') {
          return -1;
        } else if (typeof a2._stackingOrder[_i8] === 'undefined') {
          return 1;
        }
        if (b2._stackingOrder[_i8].stackLevel > a2._stackingOrder[_i8].stackLevel) {
          return 1;
        }
        if (b2._stackingOrder[_i8].stackLevel < a2._stackingOrder[_i8].stackLevel) {
          return -1;
        }
        if (b2._stackingOrder[_i8].treeOrder !== a2._stackingOrder[_i8].treeOrder) {
          return b2._stackingOrder[_i8].treeOrder - a2._stackingOrder[_i8].treeOrder;
        }
      }
      var aNode = a2.actualNode;
      var bNode = b2.actualNode;
      if (aNode.getRootNode && aNode.getRootNode() !== bNode.getRootNode()) {
        var boundaries = [];
        while (aNode) {
          boundaries.push({
            root: aNode.getRootNode(),
            node: aNode
          });
          aNode = aNode.getRootNode().host;
        }
        while (bNode && !boundaries.find(function(boundary) {
          return boundary.root === bNode.getRootNode();
        })) {
          bNode = bNode.getRootNode().host;
        }
        aNode = boundaries.find(function(boundary) {
          return boundary.root === bNode.getRootNode();
        }).node;
        if (aNode === bNode) {
          return a2.actualNode.getRootNode() !== aNode.getRootNode() ? -1 : 1;
        }
      }
      var _window$Node = window.Node, DOCUMENT_POSITION_FOLLOWING = _window$Node.DOCUMENT_POSITION_FOLLOWING, DOCUMENT_POSITION_CONTAINS = _window$Node.DOCUMENT_POSITION_CONTAINS, DOCUMENT_POSITION_CONTAINED_BY = _window$Node.DOCUMENT_POSITION_CONTAINED_BY;
      var docPosition = aNode.compareDocumentPosition(bNode);
      var DOMOrder = docPosition & DOCUMENT_POSITION_FOLLOWING ? 1 : -1;
      var isDescendant = docPosition & DOCUMENT_POSITION_CONTAINS || docPosition & DOCUMENT_POSITION_CONTAINED_BY;
      var aPosition = getPositionOrder(a2);
      var bPosition = getPositionOrder(b2);
      if (aPosition === bPosition || isDescendant) {
        return DOMOrder;
      }
      return bPosition - aPosition;
    }
    function getPositionOrder(vNode) {
      if (vNode.getComputedStylePropertyValue('display').indexOf('inline') !== -1) {
        return 2;
      }
      if (isFloated(vNode)) {
        return 1;
      }
      return 0;
    }
    function isFloated(vNode) {
      if (!vNode) {
        return false;
      }
      if (vNode._isFloated !== void 0) {
        return vNode._isFloated;
      }
      var floatStyle = vNode.getComputedStylePropertyValue('float');
      if (floatStyle !== 'none') {
        vNode._isFloated = true;
        return true;
      }
      var floated = isFloated(vNode.parent);
      vNode._isFloated = floated;
      return floated;
    }
    function getRectStack(grid, rect) {
      var recursed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var center = _getRectCenter(rect);
      var gridCell = grid.getCellFromPoint(center) || [];
      var floorX = Math.floor(center.x);
      var floorY = Math.floor(center.y);
      var stack = gridCell.filter(function(gridCellNode) {
        return gridCellNode.clientRects.some(function(clientRect) {
          var rectX = clientRect.left;
          var rectY = clientRect.top;
          return floorX < Math.floor(rectX + clientRect.width) && floorX >= Math.floor(rectX) && floorY < Math.floor(rectY + clientRect.height) && floorY >= Math.floor(rectY);
        });
      });
      var gridContainer = grid.container;
      if (gridContainer) {
        stack = getRectStack(gridContainer._grid, gridContainer.boundingClientRect, true).concat(stack);
      }
      if (!recursed) {
        stack = stack.sort(_visuallySort).map(function(vNode) {
          return vNode.actualNode;
        }).concat(document.documentElement).filter(function(node, index, array) {
          return array.indexOf(node) === index;
        });
      }
      return stack;
    }
    function getElementStack(node) {
      _createGrid();
      var vNode = get_node_from_tree_default(node);
      var grid = vNode._grid;
      if (!grid) {
        return [];
      }
      return getRectStack(grid, vNode.boundingClientRect);
    }
    var get_element_stack_default = getElementStack;
    function getTabbableElements(virtualNode) {
      var nodeAndDescendents = query_selector_all_default(virtualNode, '*');
      var tabbableElements = nodeAndDescendents.filter(function(vNode) {
        var isFocusable2 = vNode.isFocusable;
        var tabIndex = vNode.actualNode.getAttribute('tabindex');
        tabIndex = tabIndex && !isNaN(parseInt(tabIndex, 10)) ? parseInt(tabIndex) : null;
        return tabIndex ? isFocusable2 && tabIndex >= 0 : isFocusable2;
      });
      return tabbableElements;
    }
    var get_tabbable_elements_default = getTabbableElements;
    function isNativelyFocusable(el) {
      var _nodeLookup4 = _nodeLookup(el), vNode = _nodeLookup4.vNode;
      if (!vNode || focus_disabled_default(vNode)) {
        return false;
      }
      switch (vNode.props.nodeName) {
       case 'a':
       case 'area':
        if (vNode.hasAttr('href')) {
          return true;
        }
        break;

       case 'input':
        return vNode.props.type !== 'hidden';

       case 'textarea':
       case 'select':
       case 'summary':
       case 'button':
        return true;

       case 'details':
        return !query_selector_all_default(vNode, 'summary').length;
      }
      return false;
    }
    var is_natively_focusable_default = isNativelyFocusable;
    function _isFocusable(el) {
      var _nodeLookup5 = _nodeLookup(el), vNode = _nodeLookup5.vNode;
      if (vNode.props.nodeType !== 1) {
        return false;
      }
      if (focus_disabled_default(vNode)) {
        return false;
      } else if (is_natively_focusable_default(vNode)) {
        return true;
      }
      var tabindex = vNode.attr('tabindex');
      if (tabindex && !isNaN(parseInt(tabindex, 10))) {
        return true;
      }
      return false;
    }
    function _isInTabOrder(el) {
      var _nodeLookup6 = _nodeLookup(el), vNode = _nodeLookup6.vNode;
      if (vNode.props.nodeType !== 1) {
        return false;
      }
      var tabindex = parseInt(vNode.attr('tabindex', 10));
      if (tabindex <= -1) {
        return false;
      }
      return _isFocusable(vNode);
    }
    var get_target_rects_default = memoize_default(getTargetRects);
    function getTargetRects(vNode) {
      var nodeRect = vNode.boundingClientRect;
      var overlappingVNodes = _findNearbyElms(vNode).filter(function(vNeighbor) {
        return _hasVisualOverlap(vNode, vNeighbor) && vNeighbor.getComputedStylePropertyValue('pointer-events') !== 'none' && !isDescendantNotInTabOrder(vNode, vNeighbor);
      });
      if (!overlappingVNodes.length) {
        return [ nodeRect ];
      }
      var obscuringRects = overlappingVNodes.map(function(_ref25) {
        var rect = _ref25.boundingClientRect;
        return rect;
      });
      return _splitRects(nodeRect, obscuringRects);
    }
    function isDescendantNotInTabOrder(vAncestor, vNode) {
      return vAncestor.actualNode.contains(vNode.actualNode) && !_isInTabOrder(vNode);
    }
    var get_target_size_default = memoize_default(getTargetSize);
    function getTargetSize(vNode, minSize) {
      var rects = get_target_rects_default(vNode);
      return getLargestRect(rects, minSize);
    }
    function getLargestRect(rects, minSize) {
      return rects.reduce(function(rectA, rectB) {
        var rectAisMinimum = _rectHasMinimumSize(minSize, rectA);
        var rectBisMinimum = _rectHasMinimumSize(minSize, rectB);
        if (rectAisMinimum !== rectBisMinimum) {
          return rectAisMinimum ? rectA : rectB;
        }
        var areaA = rectA.width * rectA.height;
        var areaB = rectB.width * rectB.height;
        return areaA > areaB ? rectA : rectB;
      });
    }
    var text_exports = {};
    __export(text_exports, {
      accessibleText: function accessibleText() {
        return accessible_text_default;
      },
      accessibleTextVirtual: function accessibleTextVirtual() {
        return _accessibleTextVirtual;
      },
      autocomplete: function autocomplete() {
        return _autocomplete;
      },
      formControlValue: function formControlValue() {
        return form_control_value_default;
      },
      formControlValueMethods: function formControlValueMethods() {
        return _formControlValueMethods;
      },
      hasUnicode: function hasUnicode() {
        return has_unicode_default;
      },
      isHumanInterpretable: function isHumanInterpretable() {
        return is_human_interpretable_default;
      },
      isIconLigature: function isIconLigature() {
        return _isIconLigature;
      },
      isValidAutocomplete: function isValidAutocomplete() {
        return is_valid_autocomplete_default;
      },
      label: function label() {
        return label_default;
      },
      labelText: function labelText() {
        return label_text_default;
      },
      labelVirtual: function labelVirtual() {
        return label_virtual_default2;
      },
      nativeElementType: function nativeElementType() {
        return native_element_type_default;
      },
      nativeTextAlternative: function nativeTextAlternative() {
        return _nativeTextAlternative;
      },
      nativeTextMethods: function nativeTextMethods() {
        return native_text_methods_default;
      },
      removeUnicode: function removeUnicode() {
        return remove_unicode_default;
      },
      sanitize: function sanitize() {
        return sanitize_default;
      },
      subtreeText: function subtreeText() {
        return subtree_text_default;
      },
      titleText: function titleText() {
        return title_text_default;
      },
      unsupported: function unsupported() {
        return unsupported_default;
      },
      visible: function visible() {
        return visible_default;
      },
      visibleTextNodes: function visibleTextNodes() {
        return visible_text_nodes_default;
      },
      visibleVirtual: function visibleVirtual() {
        return visible_virtual_default;
      }
    });
    function idrefs(node, attr) {
      node = node.actualNode || node;
      try {
        var doc = get_root_node_default2(node);
        var result = [];
        var attrValue = node.getAttribute(attr);
        if (attrValue) {
          attrValue = token_list_default(attrValue);
          for (var index = 0; index < attrValue.length; index++) {
            result.push(doc.getElementById(attrValue[index]));
          }
        }
        return result;
      } catch (e) {
        throw new TypeError('Cannot resolve id references for non-DOM nodes');
      }
    }
    var idrefs_default = idrefs;
    function accessibleText(element, context) {
      var virtualNode = get_node_from_tree_default(element);
      return _accessibleTextVirtual(virtualNode, context);
    }
    var accessible_text_default = accessibleText;
    function arialabelledbyText(element) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _nodeLookup7 = _nodeLookup(element), vNode = _nodeLookup7.vNode;
      if ((vNode === null || vNode === void 0 ? void 0 : vNode.props.nodeType) !== 1) {
        return '';
      }
      if (vNode.props.nodeType !== 1 || context.inLabelledByContext || context.inControlContext || !vNode.attr('aria-labelledby')) {
        return '';
      }
      var refs = idrefs_default(vNode, 'aria-labelledby').filter(function(elm) {
        return elm;
      });
      return refs.reduce(function(accessibleName, elm) {
        var accessibleNameAdd = accessible_text_default(elm, _extends({
          inLabelledByContext: true,
          startNode: context.startNode || vNode
        }, context));
        if (!accessibleName) {
          return accessibleNameAdd;
        } else {
          return ''.concat(accessibleName, ' ').concat(accessibleNameAdd);
        }
      }, '');
    }
    var arialabelledby_text_default = arialabelledbyText;
    function _arialabelText(element) {
      var _nodeLookup8 = _nodeLookup(element), vNode = _nodeLookup8.vNode;
      if ((vNode === null || vNode === void 0 ? void 0 : vNode.props.nodeType) !== 1) {
        return '';
      }
      return vNode.attr('aria-label') || '';
    }
    var ariaAttrs = {
      'aria-activedescendant': {
        type: 'idref',
        allowEmpty: true
      },
      'aria-atomic': {
        type: 'boolean',
        global: true
      },
      'aria-autocomplete': {
        type: 'nmtoken',
        values: [ 'inline', 'list', 'both', 'none' ]
      },
      'aria-braillelabel': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-brailleroledescription': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-busy': {
        type: 'boolean',
        global: true
      },
      'aria-checked': {
        type: 'nmtoken',
        values: [ 'false', 'mixed', 'true', 'undefined' ]
      },
      'aria-colcount': {
        type: 'int',
        minValue: -1
      },
      'aria-colindex': {
        type: 'int',
        minValue: 1
      },
      'aria-colspan': {
        type: 'int',
        minValue: 1
      },
      'aria-controls': {
        type: 'idrefs',
        allowEmpty: true,
        global: true
      },
      'aria-current': {
        type: 'nmtoken',
        allowEmpty: true,
        values: [ 'page', 'step', 'location', 'date', 'time', 'true', 'false' ],
        global: true
      },
      'aria-describedby': {
        type: 'idrefs',
        allowEmpty: true,
        global: true
      },
      'aria-description': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-details': {
        type: 'idref',
        allowEmpty: true,
        global: true
      },
      'aria-disabled': {
        type: 'boolean',
        global: true
      },
      'aria-dropeffect': {
        type: 'nmtokens',
        values: [ 'copy', 'execute', 'link', 'move', 'none', 'popup' ],
        global: true
      },
      'aria-errormessage': {
        type: 'idref',
        allowEmpty: true,
        global: true
      },
      'aria-expanded': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ]
      },
      'aria-flowto': {
        type: 'idrefs',
        allowEmpty: true,
        global: true
      },
      'aria-grabbed': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ],
        global: true
      },
      'aria-haspopup': {
        type: 'nmtoken',
        allowEmpty: true,
        values: [ 'true', 'false', 'menu', 'listbox', 'tree', 'grid', 'dialog' ],
        global: true
      },
      'aria-hidden': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ],
        global: true
      },
      'aria-invalid': {
        type: 'nmtoken',
        values: [ 'grammar', 'false', 'spelling', 'true' ],
        global: true
      },
      'aria-keyshortcuts': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-label': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-labelledby': {
        type: 'idrefs',
        allowEmpty: true,
        global: true
      },
      'aria-level': {
        type: 'int',
        minValue: 1
      },
      'aria-live': {
        type: 'nmtoken',
        values: [ 'assertive', 'off', 'polite' ],
        global: true
      },
      'aria-modal': {
        type: 'boolean'
      },
      'aria-multiline': {
        type: 'boolean'
      },
      'aria-multiselectable': {
        type: 'boolean'
      },
      'aria-orientation': {
        type: 'nmtoken',
        values: [ 'horizontal', 'undefined', 'vertical' ]
      },
      'aria-owns': {
        type: 'idrefs',
        allowEmpty: true,
        global: true
      },
      'aria-placeholder': {
        type: 'string',
        allowEmpty: true
      },
      'aria-posinset': {
        type: 'int',
        minValue: 1
      },
      'aria-pressed': {
        type: 'nmtoken',
        values: [ 'false', 'mixed', 'true', 'undefined' ]
      },
      'aria-readonly': {
        type: 'boolean'
      },
      'aria-relevant': {
        type: 'nmtokens',
        values: [ 'additions', 'all', 'removals', 'text' ],
        global: true
      },
      'aria-required': {
        type: 'boolean'
      },
      'aria-roledescription': {
        type: 'string',
        allowEmpty: true,
        global: true
      },
      'aria-rowcount': {
        type: 'int',
        minValue: -1
      },
      'aria-rowindex': {
        type: 'int',
        minValue: 1
      },
      'aria-rowspan': {
        type: 'int',
        minValue: 0
      },
      'aria-selected': {
        type: 'nmtoken',
        values: [ 'false', 'true', 'undefined' ]
      },
      'aria-setsize': {
        type: 'int',
        minValue: -1
      },
      'aria-sort': {
        type: 'nmtoken',
        values: [ 'ascending', 'descending', 'none', 'other' ]
      },
      'aria-valuemax': {
        type: 'decimal'
      },
      'aria-valuemin': {
        type: 'decimal'
      },
      'aria-valuenow': {
        type: 'decimal'
      },
      'aria-valuetext': {
        type: 'string',
        allowEmpty: true
      }
    };
    var aria_attrs_default = ariaAttrs;
    var ariaRoles = {
      alert: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      alertdialog: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded', 'aria-modal' ],
        superclassRole: [ 'alert', 'dialog' ],
        accessibleNameRequired: true
      },
      application: {
        type: 'landmark',
        allowedAttrs: [ 'aria-activedescendant', 'aria-expanded' ],
        superclassRole: [ 'structure' ],
        accessibleNameRequired: true
      },
      article: {
        type: 'structure',
        allowedAttrs: [ 'aria-posinset', 'aria-setsize', 'aria-expanded' ],
        superclassRole: [ 'document' ]
      },
      banner: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      blockquote: {
        type: 'structure',
        superclassRole: [ 'section' ]
      },
      button: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded', 'aria-pressed' ],
        superclassRole: [ 'command' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      caption: {
        type: 'structure',
        requiredContext: [ 'figure', 'table', 'grid', 'treegrid' ],
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      cell: {
        type: 'structure',
        requiredContext: [ 'row' ],
        allowedAttrs: [ 'aria-colindex', 'aria-colspan', 'aria-rowindex', 'aria-rowspan', 'aria-expanded' ],
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      checkbox: {
        type: 'widget',
        requiredAttrs: [ 'aria-checked' ],
        allowedAttrs: [ 'aria-readonly', 'aria-expanded', 'aria-required' ],
        superclassRole: [ 'input' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      code: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      columnheader: {
        type: 'structure',
        requiredContext: [ 'row' ],
        allowedAttrs: [ 'aria-sort', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-readonly', 'aria-required', 'aria-rowindex', 'aria-rowspan', 'aria-selected' ],
        superclassRole: [ 'cell', 'gridcell', 'sectionhead' ],
        accessibleNameRequired: false,
        nameFromContent: true
      },
      combobox: {
        type: 'widget',
        requiredAttrs: [ 'aria-expanded', 'aria-controls' ],
        allowedAttrs: [ 'aria-owns', 'aria-autocomplete', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-orientation' ],
        superclassRole: [ 'select' ],
        accessibleNameRequired: true
      },
      command: {
        type: 'abstract',
        superclassRole: [ 'widget' ]
      },
      complementary: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      composite: {
        type: 'abstract',
        superclassRole: [ 'widget' ]
      },
      contentinfo: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      comment: {
        type: 'structure',
        allowedAttrs: [ 'aria-level', 'aria-posinset', 'aria-setsize' ],
        superclassRole: [ 'article' ]
      },
      definition: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      deletion: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      dialog: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded', 'aria-modal' ],
        superclassRole: [ 'window' ],
        accessibleNameRequired: true
      },
      directory: {
        type: 'structure',
        deprecated: true,
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'list' ],
        nameFromContent: true
      },
      document: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'structure' ]
      },
      emphasis: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      feed: {
        type: 'structure',
        requiredOwned: [ 'article' ],
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'list' ]
      },
      figure: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      form: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      grid: {
        type: 'composite',
        requiredOwned: [ 'rowgroup', 'row' ],
        allowedAttrs: [ 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-rowcount' ],
        superclassRole: [ 'composite', 'table' ],
        accessibleNameRequired: false
      },
      gridcell: {
        type: 'widget',
        requiredContext: [ 'row' ],
        allowedAttrs: [ 'aria-readonly', 'aria-required', 'aria-selected', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan' ],
        superclassRole: [ 'cell', 'widget' ],
        nameFromContent: true
      },
      group: {
        type: 'structure',
        allowedAttrs: [ 'aria-activedescendant', 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      heading: {
        type: 'structure',
        requiredAttrs: [ 'aria-level' ],
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'sectionhead' ],
        accessibleNameRequired: false,
        nameFromContent: true
      },
      img: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        accessibleNameRequired: true,
        childrenPresentational: true
      },
      input: {
        type: 'abstract',
        superclassRole: [ 'widget' ]
      },
      insertion: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      landmark: {
        type: 'abstract',
        superclassRole: [ 'section' ]
      },
      link: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'command' ],
        accessibleNameRequired: true,
        nameFromContent: true
      },
      list: {
        type: 'structure',
        requiredOwned: [ 'listitem' ],
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      listbox: {
        type: 'widget',
        requiredOwned: [ 'group', 'option' ],
        allowedAttrs: [ 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'select' ],
        accessibleNameRequired: true
      },
      listitem: {
        type: 'structure',
        requiredContext: [ 'list' ],
        allowedAttrs: [ 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-expanded' ],
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      log: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      main: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      marquee: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      math: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        childrenPresentational: true
      },
      menu: {
        type: 'composite',
        requiredOwned: [ 'group', 'menuitemradio', 'menuitem', 'menuitemcheckbox', 'menu', 'separator' ],
        allowedAttrs: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'select' ]
      },
      menubar: {
        type: 'composite',
        requiredOwned: [ 'group', 'menuitemradio', 'menuitem', 'menuitemcheckbox', 'menu', 'separator' ],
        allowedAttrs: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'menu' ]
      },
      menuitem: {
        type: 'widget',
        requiredContext: [ 'menu', 'menubar', 'group' ],
        allowedAttrs: [ 'aria-posinset', 'aria-setsize', 'aria-expanded' ],
        superclassRole: [ 'command' ],
        accessibleNameRequired: true,
        nameFromContent: true
      },
      menuitemcheckbox: {
        type: 'widget',
        requiredContext: [ 'menu', 'menubar', 'group' ],
        requiredAttrs: [ 'aria-checked' ],
        allowedAttrs: [ 'aria-expanded', 'aria-posinset', 'aria-readonly', 'aria-setsize' ],
        superclassRole: [ 'checkbox', 'menuitem' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      menuitemradio: {
        type: 'widget',
        requiredContext: [ 'menu', 'menubar', 'group' ],
        requiredAttrs: [ 'aria-checked' ],
        allowedAttrs: [ 'aria-expanded', 'aria-posinset', 'aria-readonly', 'aria-setsize' ],
        superclassRole: [ 'menuitemcheckbox', 'radio' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      meter: {
        type: 'structure',
        requiredAttrs: [ 'aria-valuenow' ],
        allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-valuetext' ],
        superclassRole: [ 'range' ],
        accessibleNameRequired: true,
        childrenPresentational: true
      },
      mark: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      navigation: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      none: {
        type: 'structure',
        superclassRole: [ 'structure' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      note: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      option: {
        type: 'widget',
        requiredContext: [ 'group', 'listbox' ],
        allowedAttrs: [ 'aria-selected', 'aria-checked', 'aria-posinset', 'aria-setsize' ],
        superclassRole: [ 'input' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      paragraph: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      presentation: {
        type: 'structure',
        superclassRole: [ 'structure' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      progressbar: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded', 'aria-valuemax', 'aria-valuemin', 'aria-valuenow', 'aria-valuetext' ],
        superclassRole: [ 'range' ],
        accessibleNameRequired: true,
        childrenPresentational: true
      },
      radio: {
        type: 'widget',
        requiredAttrs: [ 'aria-checked' ],
        allowedAttrs: [ 'aria-posinset', 'aria-setsize', 'aria-required' ],
        superclassRole: [ 'input' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      radiogroup: {
        type: 'composite',
        allowedAttrs: [ 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'select' ],
        accessibleNameRequired: false
      },
      range: {
        type: 'abstract',
        superclassRole: [ 'widget' ]
      },
      region: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ],
        accessibleNameRequired: false
      },
      roletype: {
        type: 'abstract',
        superclassRole: []
      },
      row: {
        type: 'structure',
        requiredContext: [ 'grid', 'rowgroup', 'table', 'treegrid' ],
        requiredOwned: [ 'cell', 'columnheader', 'gridcell', 'rowheader' ],
        allowedAttrs: [ 'aria-colindex', 'aria-level', 'aria-rowindex', 'aria-selected', 'aria-activedescendant', 'aria-expanded', 'aria-posinset', 'aria-setsize' ],
        superclassRole: [ 'group', 'widget' ],
        nameFromContent: true
      },
      rowgroup: {
        type: 'structure',
        requiredContext: [ 'grid', 'table', 'treegrid' ],
        requiredOwned: [ 'row' ],
        superclassRole: [ 'structure' ],
        nameFromContent: true
      },
      rowheader: {
        type: 'structure',
        requiredContext: [ 'row' ],
        allowedAttrs: [ 'aria-sort', 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-readonly', 'aria-required', 'aria-rowindex', 'aria-rowspan', 'aria-selected' ],
        superclassRole: [ 'cell', 'gridcell', 'sectionhead' ],
        accessibleNameRequired: false,
        nameFromContent: true
      },
      scrollbar: {
        type: 'widget',
        requiredAttrs: [ 'aria-valuenow' ],
        allowedAttrs: [ 'aria-controls', 'aria-orientation', 'aria-valuemax', 'aria-valuemin', 'aria-valuetext' ],
        superclassRole: [ 'range' ],
        childrenPresentational: true
      },
      search: {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      searchbox: {
        type: 'widget',
        allowedAttrs: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-placeholder', 'aria-readonly', 'aria-required' ],
        superclassRole: [ 'textbox' ],
        accessibleNameRequired: true
      },
      section: {
        type: 'abstract',
        superclassRole: [ 'structure' ],
        nameFromContent: true
      },
      sectionhead: {
        type: 'abstract',
        superclassRole: [ 'structure' ],
        nameFromContent: true
      },
      select: {
        type: 'abstract',
        superclassRole: [ 'composite', 'group' ]
      },
      separator: {
        type: 'structure',
        requiredAttrs: [ 'aria-valuenow' ],
        allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-orientation', 'aria-valuetext' ],
        superclassRole: [ 'structure', 'widget' ],
        childrenPresentational: true
      },
      slider: {
        type: 'widget',
        requiredAttrs: [ 'aria-valuenow' ],
        allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-orientation', 'aria-readonly', 'aria-required', 'aria-valuetext' ],
        superclassRole: [ 'input', 'range' ],
        accessibleNameRequired: true,
        childrenPresentational: true
      },
      spinbutton: {
        type: 'widget',
        allowedAttrs: [ 'aria-valuemax', 'aria-valuemin', 'aria-readonly', 'aria-required', 'aria-activedescendant', 'aria-valuetext', 'aria-valuenow' ],
        superclassRole: [ 'composite', 'input', 'range' ],
        accessibleNameRequired: true
      },
      status: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      strong: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      structure: {
        type: 'abstract',
        superclassRole: [ 'roletype' ]
      },
      subscript: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      superscript: {
        type: 'structure',
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      switch: {
        type: 'widget',
        requiredAttrs: [ 'aria-checked' ],
        allowedAttrs: [ 'aria-expanded', 'aria-readonly', 'aria-required' ],
        superclassRole: [ 'checkbox' ],
        accessibleNameRequired: true,
        nameFromContent: true,
        childrenPresentational: true
      },
      suggestion: {
        type: 'structure',
        requiredOwned: [ 'insertion', 'deletion' ],
        superclassRole: [ 'section' ],
        prohibitedAttrs: [ 'aria-label', 'aria-labelledby' ]
      },
      tab: {
        type: 'widget',
        requiredContext: [ 'tablist' ],
        allowedAttrs: [ 'aria-posinset', 'aria-selected', 'aria-setsize', 'aria-expanded' ],
        superclassRole: [ 'sectionhead', 'widget' ],
        nameFromContent: true,
        childrenPresentational: true
      },
      table: {
        type: 'structure',
        requiredOwned: [ 'rowgroup', 'row' ],
        allowedAttrs: [ 'aria-colcount', 'aria-rowcount', 'aria-expanded' ],
        superclassRole: [ 'section' ],
        accessibleNameRequired: false,
        nameFromContent: true
      },
      tablist: {
        type: 'composite',
        requiredOwned: [ 'tab' ],
        allowedAttrs: [ 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-activedescendant', 'aria-expanded' ],
        superclassRole: [ 'composite' ]
      },
      tabpanel: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        accessibleNameRequired: false
      },
      term: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      text: {
        type: 'structure',
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      textbox: {
        type: 'widget',
        allowedAttrs: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-placeholder', 'aria-readonly', 'aria-required' ],
        superclassRole: [ 'input' ],
        accessibleNameRequired: true
      },
      time: {
        type: 'structure',
        superclassRole: [ 'section' ]
      },
      timer: {
        type: 'widget',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'status' ]
      },
      toolbar: {
        type: 'structure',
        allowedAttrs: [ 'aria-orientation', 'aria-activedescendant', 'aria-expanded' ],
        superclassRole: [ 'group' ],
        accessibleNameRequired: true
      },
      tooltip: {
        type: 'structure',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ],
        nameFromContent: true
      },
      tree: {
        type: 'composite',
        requiredOwned: [ 'group', 'treeitem' ],
        allowedAttrs: [ 'aria-multiselectable', 'aria-required', 'aria-activedescendant', 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'select' ],
        accessibleNameRequired: false
      },
      treegrid: {
        type: 'composite',
        requiredOwned: [ 'rowgroup', 'row' ],
        allowedAttrs: [ 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-readonly', 'aria-required', 'aria-rowcount' ],
        superclassRole: [ 'grid', 'tree' ],
        accessibleNameRequired: false
      },
      treeitem: {
        type: 'widget',
        requiredContext: [ 'group', 'tree' ],
        allowedAttrs: [ 'aria-checked', 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-selected', 'aria-setsize' ],
        superclassRole: [ 'listitem', 'option' ],
        accessibleNameRequired: true,
        nameFromContent: true
      },
      widget: {
        type: 'abstract',
        superclassRole: [ 'roletype' ]
      },
      window: {
        type: 'abstract',
        superclassRole: [ 'roletype' ]
      }
    };
    var aria_roles_default = ariaRoles;
    var dpubRoles = {
      'doc-abstract': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-acknowledgments': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-afterword': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-appendix': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-backlink': {
        type: 'link',
        allowedAttrs: [ 'aria-expanded' ],
        nameFromContent: true,
        superclassRole: [ 'link' ]
      },
      'doc-biblioentry': {
        type: 'listitem',
        allowedAttrs: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize' ],
        superclassRole: [ 'listitem' ],
        deprecated: true
      },
      'doc-bibliography': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-biblioref': {
        type: 'link',
        allowedAttrs: [ 'aria-expanded' ],
        nameFromContent: true,
        superclassRole: [ 'link' ]
      },
      'doc-chapter': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-colophon': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-conclusion': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-cover': {
        type: 'img',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'img' ]
      },
      'doc-credit': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-credits': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-dedication': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-endnote': {
        type: 'listitem',
        allowedAttrs: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize' ],
        superclassRole: [ 'listitem' ],
        deprecated: true
      },
      'doc-endnotes': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-epigraph': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-epilogue': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-errata': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-example': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-footnote': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-foreword': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-glossary': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-glossref': {
        type: 'link',
        allowedAttrs: [ 'aria-expanded' ],
        nameFromContent: true,
        superclassRole: [ 'link' ]
      },
      'doc-index': {
        type: 'navigation',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'navigation' ]
      },
      'doc-introduction': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-noteref': {
        type: 'link',
        allowedAttrs: [ 'aria-expanded' ],
        nameFromContent: true,
        superclassRole: [ 'link' ]
      },
      'doc-notice': {
        type: 'note',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'note' ]
      },
      'doc-pagebreak': {
        type: 'separator',
        allowedAttrs: [ 'aria-expanded', 'aria-orientation' ],
        superclassRole: [ 'separator' ],
        childrenPresentational: true
      },
      'doc-pagelist': {
        type: 'navigation',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'navigation' ]
      },
      'doc-part': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-preface': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-prologue': {
        type: 'landmark',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'landmark' ]
      },
      'doc-pullquote': {
        type: 'none',
        superclassRole: [ 'none' ]
      },
      'doc-qna': {
        type: 'section',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'section' ]
      },
      'doc-subtitle': {
        type: 'sectionhead',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'sectionhead' ]
      },
      'doc-tip': {
        type: 'note',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'note' ]
      },
      'doc-toc': {
        type: 'navigation',
        allowedAttrs: [ 'aria-expanded' ],
        superclassRole: [ 'navigation' ]
      }
    };
    var dpub_roles_default = dpubRoles;
    var graphicsRoles = {
      'graphics-document': {
        type: 'structure',
        superclassRole: [ 'document' ],
        accessibleNameRequired: true
      },
      'graphics-object': {
        type: 'structure',
        superclassRole: [ 'group' ],
        nameFromContent: true
      },
      'graphics-symbol': {
        type: 'structure',
        superclassRole: [ 'img' ],
        accessibleNameRequired: true,
        childrenPresentational: true
      }
    };
    var graphics_roles_default = graphicsRoles;
    var htmlElms = {
      a: {
        variant: {
          href: {
            matches: '[href]',
            contentTypes: [ 'interactive', 'phrasing', 'flow' ],
            allowedRoles: [ 'button', 'checkbox', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab', 'treeitem', 'doc-backlink', 'doc-biblioref', 'doc-glossref', 'doc-noteref' ],
            namingMethods: [ 'subtreeText' ]
          },
          default: {
            contentTypes: [ 'phrasing', 'flow' ],
            allowedRoles: true
          }
        }
      },
      abbr: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      address: {
        contentTypes: [ 'flow' ],
        allowedRoles: true
      },
      area: {
        variant: {
          href: {
            matches: '[href]',
            allowedRoles: false
          },
          default: {
            allowedRoles: [ 'button', 'link' ]
          }
        },
        contentTypes: [ 'phrasing', 'flow' ],
        namingMethods: [ 'altText' ]
      },
      article: {
        contentTypes: [ 'sectioning', 'flow' ],
        allowedRoles: [ 'feed', 'presentation', 'none', 'document', 'application', 'main', 'region' ],
        shadowRoot: true
      },
      aside: {
        contentTypes: [ 'sectioning', 'flow' ],
        allowedRoles: [ 'feed', 'note', 'presentation', 'none', 'region', 'search', 'doc-dedication', 'doc-example', 'doc-footnote', 'doc-glossary', 'doc-pullquote', 'doc-tip' ]
      },
      audio: {
        variant: {
          controls: {
            matches: '[controls]',
            contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
          },
          default: {
            contentTypes: [ 'embedded', 'phrasing', 'flow' ]
          }
        },
        allowedRoles: [ 'application' ],
        chromiumRole: 'Audio'
      },
      b: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      base: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      bdi: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      bdo: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      blockquote: {
        contentTypes: [ 'flow' ],
        allowedRoles: true,
        shadowRoot: true
      },
      body: {
        allowedRoles: false,
        shadowRoot: true
      },
      br: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: [ 'presentation', 'none' ],
        namingMethods: [ 'titleText', 'singleSpace' ]
      },
      button: {
        contentTypes: [ 'interactive', 'phrasing', 'flow' ],
        allowedRoles: [ 'checkbox', 'combobox', 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab' ],
        namingMethods: [ 'subtreeText' ]
      },
      canvas: {
        allowedRoles: true,
        contentTypes: [ 'embedded', 'phrasing', 'flow' ],
        chromiumRole: 'Canvas'
      },
      caption: {
        allowedRoles: false
      },
      cite: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      code: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      col: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      colgroup: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      data: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      datalist: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true,
        implicitAttrs: {
          'aria-multiselectable': 'false'
        }
      },
      dd: {
        allowedRoles: false
      },
      del: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      dfn: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      details: {
        contentTypes: [ 'interactive', 'flow' ],
        allowedRoles: false
      },
      dialog: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'alertdialog' ]
      },
      div: {
        contentTypes: [ 'flow' ],
        allowedRoles: true,
        shadowRoot: true
      },
      dl: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'group', 'list', 'presentation', 'none' ],
        chromiumRole: 'DescriptionList'
      },
      dt: {
        allowedRoles: [ 'listitem' ]
      },
      em: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      embed: {
        contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ],
        allowedRoles: [ 'application', 'document', 'img', 'presentation', 'none' ],
        chromiumRole: 'EmbeddedObject'
      },
      fieldset: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'radiogroup' ],
        namingMethods: [ 'fieldsetLegendText' ]
      },
      figcaption: {
        allowedRoles: [ 'group', 'none', 'presentation' ]
      },
      figure: {
        contentTypes: [ 'flow' ],
        allowedRoles: true,
        namingMethods: [ 'figureText', 'titleText' ]
      },
      footer: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'group', 'none', 'presentation', 'doc-footnote' ],
        shadowRoot: true
      },
      form: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'search', 'none', 'presentation' ]
      },
      h1: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '1'
        }
      },
      h2: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '2'
        }
      },
      h3: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '3'
        }
      },
      h4: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '4'
        }
      },
      h5: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '5'
        }
      },
      h6: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'tab', 'doc-subtitle' ],
        shadowRoot: true,
        implicitAttrs: {
          'aria-level': '6'
        }
      },
      head: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      header: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'group', 'none', 'presentation', 'doc-footnote' ],
        shadowRoot: true
      },
      hgroup: {
        contentTypes: [ 'heading', 'flow' ],
        allowedRoles: true
      },
      hr: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'none', 'presentation', 'doc-pagebreak' ],
        namingMethods: [ 'titleText', 'singleSpace' ]
      },
      html: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      i: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      iframe: {
        contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ],
        allowedRoles: [ 'application', 'document', 'img', 'none', 'presentation' ],
        chromiumRole: 'Iframe'
      },
      img: {
        variant: {
          nonEmptyAlt: {
            matches: [ {
              attributes: {
                alt: '/.+/'
              }
            }, {
              hasAccessibleName: true
            } ],
            allowedRoles: [ 'button', 'checkbox', 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'meter', 'option', 'progressbar', 'radio', 'scrollbar', 'separator', 'slider', 'switch', 'tab', 'treeitem', 'doc-cover' ]
          },
          usemap: {
            matches: '[usemap]',
            contentTypes: [ 'interactive', 'embedded', 'flow' ]
          },
          default: {
            allowedRoles: [ 'presentation', 'none' ],
            contentTypes: [ 'embedded', 'flow' ]
          }
        },
        namingMethods: [ 'altText' ]
      },
      input: {
        variant: {
          button: {
            matches: {
              properties: {
                type: 'button'
              }
            },
            allowedRoles: [ 'checkbox', 'combobox', 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'radio', 'switch', 'tab' ]
          },
          buttonType: {
            matches: {
              properties: {
                type: [ 'button', 'submit', 'reset' ]
              }
            },
            namingMethods: [ 'valueText', 'titleText', 'buttonDefaultText' ]
          },
          checkboxPressed: {
            matches: {
              properties: {
                type: 'checkbox'
              },
              attributes: {
                'aria-pressed': '/.*/'
              }
            },
            allowedRoles: [ 'button', 'menuitemcheckbox', 'option', 'switch' ],
            implicitAttrs: {
              'aria-checked': 'false'
            }
          },
          checkbox: {
            matches: {
              properties: {
                type: 'checkbox'
              },
              attributes: {
                'aria-pressed': null
              }
            },
            allowedRoles: [ 'menuitemcheckbox', 'option', 'switch' ],
            implicitAttrs: {
              'aria-checked': 'false'
            }
          },
          noRoles: {
            matches: {
              properties: {
                type: [ 'color', 'date', 'datetime-local', 'file', 'month', 'number', 'password', 'range', 'reset', 'submit', 'time', 'week' ]
              }
            },
            allowedRoles: false
          },
          hidden: {
            matches: {
              properties: {
                type: 'hidden'
              }
            },
            contentTypes: [ 'flow' ],
            allowedRoles: false,
            noAriaAttrs: true
          },
          image: {
            matches: {
              properties: {
                type: 'image'
              }
            },
            allowedRoles: [ 'link', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'radio', 'switch' ],
            namingMethods: [ 'altText', 'valueText', 'labelText', 'titleText', 'buttonDefaultText' ]
          },
          radio: {
            matches: {
              properties: {
                type: 'radio'
              }
            },
            allowedRoles: [ 'menuitemradio' ],
            implicitAttrs: {
              'aria-checked': 'false'
            }
          },
          textWithList: {
            matches: {
              properties: {
                type: 'text'
              },
              attributes: {
                list: '/.*/'
              }
            },
            allowedRoles: false
          },
          default: {
            contentTypes: [ 'interactive', 'flow' ],
            allowedRoles: [ 'combobox', 'searchbox', 'spinbutton' ],
            implicitAttrs: {
              'aria-valuenow': ''
            },
            namingMethods: [ 'labelText', 'placeholderText' ]
          }
        }
      },
      ins: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      kbd: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      label: {
        contentTypes: [ 'interactive', 'phrasing', 'flow' ],
        allowedRoles: false,
        chromiumRole: 'Label'
      },
      legend: {
        allowedRoles: false
      },
      li: {
        allowedRoles: [ 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'none', 'presentation', 'radio', 'separator', 'tab', 'treeitem', 'doc-biblioentry', 'doc-endnote' ],
        implicitAttrs: {
          'aria-setsize': '1',
          'aria-posinset': '1'
        }
      },
      link: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      main: {
        contentTypes: [ 'flow' ],
        allowedRoles: false,
        shadowRoot: true
      },
      map: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      math: {
        contentTypes: [ 'embedded', 'phrasing', 'flow' ],
        allowedRoles: false
      },
      mark: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      menu: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
      },
      meta: {
        variant: {
          itemprop: {
            matches: '[itemprop]',
            contentTypes: [ 'phrasing', 'flow' ]
          }
        },
        allowedRoles: false,
        noAriaAttrs: true
      },
      meter: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        chromiumRole: 'progressbar'
      },
      nav: {
        contentTypes: [ 'sectioning', 'flow' ],
        allowedRoles: [ 'doc-index', 'doc-pagelist', 'doc-toc', 'menu', 'menubar', 'none', 'presentation', 'tablist' ],
        shadowRoot: true
      },
      noscript: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      object: {
        variant: {
          usemap: {
            matches: '[usemap]',
            contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
          },
          default: {
            contentTypes: [ 'embedded', 'phrasing', 'flow' ]
          }
        },
        allowedRoles: [ 'application', 'document', 'img' ],
        chromiumRole: 'PluginObject'
      },
      ol: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
      },
      optgroup: {
        allowedRoles: false
      },
      option: {
        allowedRoles: false,
        implicitAttrs: {
          'aria-selected': 'false'
        }
      },
      output: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true,
        namingMethods: [ 'subtreeText' ]
      },
      p: {
        contentTypes: [ 'flow' ],
        allowedRoles: true,
        shadowRoot: true
      },
      param: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      picture: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      pre: {
        contentTypes: [ 'flow' ],
        allowedRoles: true
      },
      progress: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        implicitAttrs: {
          'aria-valuemax': '100',
          'aria-valuemin': '0',
          'aria-valuenow': '0'
        }
      },
      q: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      rp: {
        allowedRoles: true
      },
      rt: {
        allowedRoles: true
      },
      ruby: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      s: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      samp: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      script: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      search: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'form', 'group', 'none', 'presentation', 'region', 'search' ]
      },
      section: {
        contentTypes: [ 'sectioning', 'flow' ],
        allowedRoles: [ 'alert', 'alertdialog', 'application', 'banner', 'complementary', 'contentinfo', 'dialog', 'document', 'feed', 'group', 'log', 'main', 'marquee', 'navigation', 'none', 'note', 'presentation', 'search', 'status', 'tabpanel', 'doc-abstract', 'doc-acknowledgments', 'doc-afterword', 'doc-appendix', 'doc-bibliography', 'doc-chapter', 'doc-colophon', 'doc-conclusion', 'doc-credit', 'doc-credits', 'doc-dedication', 'doc-endnotes', 'doc-epigraph', 'doc-epilogue', 'doc-errata', 'doc-example', 'doc-foreword', 'doc-glossary', 'doc-index', 'doc-introduction', 'doc-notice', 'doc-pagelist', 'doc-part', 'doc-preface', 'doc-prologue', 'doc-pullquote', 'doc-qna', 'doc-toc' ],
        shadowRoot: true
      },
      select: {
        variant: {
          combobox: {
            matches: {
              attributes: {
                multiple: null,
                size: [ null, '1' ]
              }
            },
            allowedRoles: [ 'menu' ]
          },
          default: {
            allowedRoles: false
          }
        },
        contentTypes: [ 'interactive', 'phrasing', 'flow' ],
        implicitAttrs: {
          'aria-valuenow': ''
        },
        namingMethods: [ 'labelText' ]
      },
      slot: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      small: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      source: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      span: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true,
        shadowRoot: true
      },
      strong: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      style: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      svg: {
        contentTypes: [ 'embedded', 'phrasing', 'flow' ],
        allowedRoles: true,
        chromiumRole: 'SVGRoot',
        namingMethods: [ 'svgTitleText' ]
      },
      sub: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      summary: {
        allowedRoles: false,
        namingMethods: [ 'subtreeText' ]
      },
      sup: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      table: {
        contentTypes: [ 'flow' ],
        allowedRoles: true,
        namingMethods: [ 'tableCaptionText', 'tableSummaryText' ]
      },
      tbody: {
        allowedRoles: true
      },
      template: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: false,
        noAriaAttrs: true
      },
      textarea: {
        contentTypes: [ 'interactive', 'phrasing', 'flow' ],
        allowedRoles: false,
        implicitAttrs: {
          'aria-valuenow': '',
          'aria-multiline': 'true'
        },
        namingMethods: [ 'labelText', 'placeholderText' ]
      },
      tfoot: {
        allowedRoles: true
      },
      thead: {
        allowedRoles: true
      },
      time: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      title: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      td: {
        allowedRoles: true
      },
      th: {
        allowedRoles: true
      },
      tr: {
        allowedRoles: true
      },
      track: {
        allowedRoles: false,
        noAriaAttrs: true
      },
      u: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      ul: {
        contentTypes: [ 'flow' ],
        allowedRoles: [ 'directory', 'group', 'listbox', 'menu', 'menubar', 'none', 'presentation', 'radiogroup', 'tablist', 'toolbar', 'tree' ]
      },
      var: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: true
      },
      video: {
        variant: {
          controls: {
            matches: '[controls]',
            contentTypes: [ 'interactive', 'embedded', 'phrasing', 'flow' ]
          },
          default: {
            contentTypes: [ 'embedded', 'phrasing', 'flow' ]
          }
        },
        allowedRoles: [ 'application' ],
        chromiumRole: 'video'
      },
      wbr: {
        contentTypes: [ 'phrasing', 'flow' ],
        allowedRoles: [ 'presentation', 'none' ]
      }
    };
    var html_elms_default = htmlElms;
    var cssColors = {
      aliceblue: [ 240, 248, 255 ],
      antiquewhite: [ 250, 235, 215 ],
      aqua: [ 0, 255, 255 ],
      aquamarine: [ 127, 255, 212 ],
      azure: [ 240, 255, 255 ],
      beige: [ 245, 245, 220 ],
      bisque: [ 255, 228, 196 ],
      black: [ 0, 0, 0 ],
      blanchedalmond: [ 255, 235, 205 ],
      blue: [ 0, 0, 255 ],
      blueviolet: [ 138, 43, 226 ],
      brown: [ 165, 42, 42 ],
      burlywood: [ 222, 184, 135 ],
      cadetblue: [ 95, 158, 160 ],
      chartreuse: [ 127, 255, 0 ],
      chocolate: [ 210, 105, 30 ],
      coral: [ 255, 127, 80 ],
      cornflowerblue: [ 100, 149, 237 ],
      cornsilk: [ 255, 248, 220 ],
      crimson: [ 220, 20, 60 ],
      cyan: [ 0, 255, 255 ],
      darkblue: [ 0, 0, 139 ],
      darkcyan: [ 0, 139, 139 ],
      darkgoldenrod: [ 184, 134, 11 ],
      darkgray: [ 169, 169, 169 ],
      darkgreen: [ 0, 100, 0 ],
      darkgrey: [ 169, 169, 169 ],
      darkkhaki: [ 189, 183, 107 ],
      darkmagenta: [ 139, 0, 139 ],
      darkolivegreen: [ 85, 107, 47 ],
      darkorange: [ 255, 140, 0 ],
      darkorchid: [ 153, 50, 204 ],
      darkred: [ 139, 0, 0 ],
      darksalmon: [ 233, 150, 122 ],
      darkseagreen: [ 143, 188, 143 ],
      darkslateblue: [ 72, 61, 139 ],
      darkslategray: [ 47, 79, 79 ],
      darkslategrey: [ 47, 79, 79 ],
      darkturquoise: [ 0, 206, 209 ],
      darkviolet: [ 148, 0, 211 ],
      deeppink: [ 255, 20, 147 ],
      deepskyblue: [ 0, 191, 255 ],
      dimgray: [ 105, 105, 105 ],
      dimgrey: [ 105, 105, 105 ],
      dodgerblue: [ 30, 144, 255 ],
      firebrick: [ 178, 34, 34 ],
      floralwhite: [ 255, 250, 240 ],
      forestgreen: [ 34, 139, 34 ],
      fuchsia: [ 255, 0, 255 ],
      gainsboro: [ 220, 220, 220 ],
      ghostwhite: [ 248, 248, 255 ],
      gold: [ 255, 215, 0 ],
      goldenrod: [ 218, 165, 32 ],
      gray: [ 128, 128, 128 ],
      green: [ 0, 128, 0 ],
      greenyellow: [ 173, 255, 47 ],
      grey: [ 128, 128, 128 ],
      honeydew: [ 240, 255, 240 ],
      hotpink: [ 255, 105, 180 ],
      indianred: [ 205, 92, 92 ],
      indigo: [ 75, 0, 130 ],
      ivory: [ 255, 255, 240 ],
      khaki: [ 240, 230, 140 ],
      lavender: [ 230, 230, 250 ],
      lavenderblush: [ 255, 240, 245 ],
      lawngreen: [ 124, 252, 0 ],
      lemonchiffon: [ 255, 250, 205 ],
      lightblue: [ 173, 216, 230 ],
      lightcoral: [ 240, 128, 128 ],
      lightcyan: [ 224, 255, 255 ],
      lightgoldenrodyellow: [ 250, 250, 210 ],
      lightgray: [ 211, 211, 211 ],
      lightgreen: [ 144, 238, 144 ],
      lightgrey: [ 211, 211, 211 ],
      lightpink: [ 255, 182, 193 ],
      lightsalmon: [ 255, 160, 122 ],
      lightseagreen: [ 32, 178, 170 ],
      lightskyblue: [ 135, 206, 250 ],
      lightslategray: [ 119, 136, 153 ],
      lightslategrey: [ 119, 136, 153 ],
      lightsteelblue: [ 176, 196, 222 ],
      lightyellow: [ 255, 255, 224 ],
      lime: [ 0, 255, 0 ],
      limegreen: [ 50, 205, 50 ],
      linen: [ 250, 240, 230 ],
      magenta: [ 255, 0, 255 ],
      maroon: [ 128, 0, 0 ],
      mediumaquamarine: [ 102, 205, 170 ],
      mediumblue: [ 0, 0, 205 ],
      mediumorchid: [ 186, 85, 211 ],
      mediumpurple: [ 147, 112, 219 ],
      mediumseagreen: [ 60, 179, 113 ],
      mediumslateblue: [ 123, 104, 238 ],
      mediumspringgreen: [ 0, 250, 154 ],
      mediumturquoise: [ 72, 209, 204 ],
      mediumvioletred: [ 199, 21, 133 ],
      midnightblue: [ 25, 25, 112 ],
      mintcream: [ 245, 255, 250 ],
      mistyrose: [ 255, 228, 225 ],
      moccasin: [ 255, 228, 181 ],
      navajowhite: [ 255, 222, 173 ],
      navy: [ 0, 0, 128 ],
      oldlace: [ 253, 245, 230 ],
      olive: [ 128, 128, 0 ],
      olivedrab: [ 107, 142, 35 ],
      orange: [ 255, 165, 0 ],
      orangered: [ 255, 69, 0 ],
      orchid: [ 218, 112, 214 ],
      palegoldenrod: [ 238, 232, 170 ],
      palegreen: [ 152, 251, 152 ],
      paleturquoise: [ 175, 238, 238 ],
      palevioletred: [ 219, 112, 147 ],
      papayawhip: [ 255, 239, 213 ],
      peachpuff: [ 255, 218, 185 ],
      peru: [ 205, 133, 63 ],
      pink: [ 255, 192, 203 ],
      plum: [ 221, 160, 221 ],
      powderblue: [ 176, 224, 230 ],
      purple: [ 128, 0, 128 ],
      rebeccapurple: [ 102, 51, 153 ],
      red: [ 255, 0, 0 ],
      rosybrown: [ 188, 143, 143 ],
      royalblue: [ 65, 105, 225 ],
      saddlebrown: [ 139, 69, 19 ],
      salmon: [ 250, 128, 114 ],
      sandybrown: [ 244, 164, 96 ],
      seagreen: [ 46, 139, 87 ],
      seashell: [ 255, 245, 238 ],
      sienna: [ 160, 82, 45 ],
      silver: [ 192, 192, 192 ],
      skyblue: [ 135, 206, 235 ],
      slateblue: [ 106, 90, 205 ],
      slategray: [ 112, 128, 144 ],
      slategrey: [ 112, 128, 144 ],
      snow: [ 255, 250, 250 ],
      springgreen: [ 0, 255, 127 ],
      steelblue: [ 70, 130, 180 ],
      tan: [ 210, 180, 140 ],
      teal: [ 0, 128, 128 ],
      thistle: [ 216, 191, 216 ],
      tomato: [ 255, 99, 71 ],
      turquoise: [ 64, 224, 208 ],
      violet: [ 238, 130, 238 ],
      wheat: [ 245, 222, 179 ],
      white: [ 255, 255, 255 ],
      whitesmoke: [ 245, 245, 245 ],
      yellow: [ 255, 255, 0 ],
      yellowgreen: [ 154, 205, 50 ]
    };
    var css_colors_default = cssColors;
    var originals = {
      ariaAttrs: aria_attrs_default,
      ariaRoles: _extends({}, aria_roles_default, dpub_roles_default, graphics_roles_default),
      htmlElms: html_elms_default,
      cssColors: css_colors_default
    };
    var standards = _extends({}, originals);
    function configureStandards(config) {
      Object.keys(standards).forEach(function(propName) {
        if (config[propName]) {
          standards[propName] = deep_merge_default(standards[propName], config[propName]);
        }
      });
    }
    function resetStandards() {
      Object.keys(standards).forEach(function(propName) {
        standards[propName] = originals[propName];
      });
    }
    var standards_default = standards;
    function isUnsupportedRole(role) {
      var roleDefinition = standards_default.ariaRoles[role];
      return roleDefinition ? !!roleDefinition.unsupported : false;
    }
    var is_unsupported_role_default = isUnsupportedRole;
    function isValidRole(role) {
      var _ref26 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, allowAbstract = _ref26.allowAbstract, _ref26$flagUnsupporte = _ref26.flagUnsupported, flagUnsupported = _ref26$flagUnsupporte === void 0 ? false : _ref26$flagUnsupporte;
      var roleDefinition = standards_default.ariaRoles[role];
      var isRoleUnsupported = is_unsupported_role_default(role);
      if (!roleDefinition || flagUnsupported && isRoleUnsupported) {
        return false;
      }
      return allowAbstract ? true : roleDefinition.type !== 'abstract';
    }
    var is_valid_role_default = isValidRole;
    function getExplicitRole(vNode) {
      var _ref27 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, fallback = _ref27.fallback, abstracts = _ref27.abstracts, dpub = _ref27.dpub;
      vNode = vNode instanceof abstract_virtual_node_default ? vNode : get_node_from_tree_default(vNode);
      if (vNode.props.nodeType !== 1) {
        return null;
      }
      var roleAttr = (vNode.attr('role') || '').trim().toLowerCase();
      var roleList = fallback ? token_list_default(roleAttr) : [ roleAttr ];
      var firstValidRole = roleList.find(function(role) {
        if (!dpub && role.substr(0, 4) === 'doc-') {
          return false;
        }
        return is_valid_role_default(role, {
          allowAbstract: abstracts
        });
      });
      return firstValidRole || null;
    }
    var get_explicit_role_default = getExplicitRole;
    function getElementsByContentType(type2) {
      return Object.keys(standards_default.htmlElms).filter(function(nodeName2) {
        var elm = standards_default.htmlElms[nodeName2];
        if (elm.contentTypes) {
          return elm.contentTypes.includes(type2);
        }
        if (!elm.variant) {
          return false;
        }
        if (elm.variant['default'] && elm.variant['default'].contentTypes) {
          return elm.variant['default'].contentTypes.includes(type2);
        }
        return false;
      });
    }
    var get_elements_by_content_type_default = getElementsByContentType;
    function getGlobalAriaAttrs() {
      return cache_default.get('globalAriaAttrs', function() {
        return Object.keys(standards_default.ariaAttrs).filter(function(attrName) {
          return standards_default.ariaAttrs[attrName].global;
        });
      });
    }
    var get_global_aria_attrs_default = getGlobalAriaAttrs;
    function toGrid(node) {
      var table = [];
      var rows = node.rows;
      for (var i = 0, rowLength = rows.length; i < rowLength; i++) {
        var cells = rows[i].cells;
        table[i] = table[i] || [];
        var columnIndex = 0;
        for (var j = 0, cellLength = cells.length; j < cellLength; j++) {
          for (var colSpan = 0; colSpan < cells[j].colSpan; colSpan++) {
            var rowspanAttr = cells[j].getAttribute('rowspan');
            var rowspanValue = parseInt(rowspanAttr) === 0 || cells[j].rowspan === 0 ? rows.length : cells[j].rowSpan;
            for (var rowSpan = 0; rowSpan < rowspanValue; rowSpan++) {
              table[i + rowSpan] = table[i + rowSpan] || [];
              while (table[i + rowSpan][columnIndex]) {
                columnIndex++;
              }
              table[i + rowSpan][columnIndex] = cells[j];
            }
            columnIndex++;
          }
        }
      }
      return table;
    }
    var to_grid_default = memoize_default(toGrid);
    function getCellPosition(cell, tableGrid) {
      var rowIndex, index;
      if (!tableGrid) {
        tableGrid = to_grid_default(find_up_default(cell, 'table'));
      }
      for (rowIndex = 0; rowIndex < tableGrid.length; rowIndex++) {
        if (tableGrid[rowIndex]) {
          index = tableGrid[rowIndex].indexOf(cell);
          if (index !== -1) {
            return {
              x: index,
              y: rowIndex
            };
          }
        }
      }
    }
    var get_cell_position_default = memoize_default(getCellPosition);
    function _getScope(el) {
      var _nodeLookup9 = _nodeLookup(el), vNode = _nodeLookup9.vNode, cell = _nodeLookup9.domNode;
      var scope = vNode.attr('scope');
      var role = vNode.attr('role');
      if (![ 'td', 'th' ].includes(vNode.props.nodeName)) {
        throw new TypeError('Expected TD or TH element');
      }
      if (role === 'columnheader') {
        return 'col';
      } else if (role === 'rowheader') {
        return 'row';
      } else if (scope === 'col' || scope === 'row') {
        return scope;
      } else if (vNode.props.nodeName !== 'th') {
        return false;
      } else if (!vNode.actualNode) {
        return 'auto';
      }
      var tableGrid = to_grid_default(find_up_default(cell, 'table'));
      var pos = get_cell_position_default(cell, tableGrid);
      var headerRow = tableGrid[pos.y].every(function(node) {
        return node.nodeName.toUpperCase() === 'TH';
      });
      if (headerRow) {
        return 'col';
      }
      var headerCol = tableGrid.map(function(col) {
        return col[pos.x];
      }).every(function(node) {
        return node && node.nodeName.toUpperCase() === 'TH';
      });
      if (headerCol) {
        return 'row';
      }
      return 'auto';
    }
    function isColumnHeader(element) {
      return [ 'col', 'auto' ].indexOf(_getScope(element)) !== -1;
    }
    var is_column_header_default = isColumnHeader;
    function isRowHeader(cell) {
      return [ 'row', 'auto' ].includes(_getScope(cell));
    }
    var is_row_header_default = isRowHeader;
    function sanitize(str) {
      if (!str) {
        return '';
      }
      return str.replace(/\r\n/g, '\n').replace(/\u00A0/g, ' ').replace(/[\s]{2,}/g, ' ').trim();
    }
    var sanitize_default = sanitize;
    var getSectioningElementSelector = function getSectioningElementSelector() {
      return cache_default.get('sectioningElementSelector', function() {
        return get_elements_by_content_type_default('sectioning').map(function(nodeName2) {
          return ''.concat(nodeName2, ':not([role])');
        }).join(', ') + ' , main:not([role]), [role=article], [role=complementary], [role=main], [role=navigation], [role=region]';
      });
    };
    function hasAccessibleName(vNode) {
      var ariaLabelledby = sanitize_default(arialabelledby_text_default(vNode));
      var ariaLabel = sanitize_default(_arialabelText(vNode));
      return !!(ariaLabelledby || ariaLabel);
    }
    var implicitHtmlRoles = {
      a: function a(vNode) {
        return vNode.hasAttr('href') ? 'link' : null;
      },
      area: function area(vNode) {
        return vNode.hasAttr('href') ? 'link' : null;
      },
      article: 'article',
      aside: 'complementary',
      body: 'document',
      button: 'button',
      datalist: 'listbox',
      dd: 'definition',
      dfn: 'term',
      details: 'group',
      dialog: 'dialog',
      dt: 'term',
      fieldset: 'group',
      figure: 'figure',
      footer: function footer(vNode) {
        var sectioningElement = closest_default(vNode, getSectioningElementSelector());
        return !sectioningElement ? 'contentinfo' : null;
      },
      form: function form(vNode) {
        return hasAccessibleName(vNode) ? 'form' : null;
      },
      h1: 'heading',
      h2: 'heading',
      h3: 'heading',
      h4: 'heading',
      h5: 'heading',
      h6: 'heading',
      header: function header(vNode) {
        var sectioningElement = closest_default(vNode, getSectioningElementSelector());
        return !sectioningElement ? 'banner' : null;
      },
      hr: 'separator',
      img: function img(vNode) {
        var emptyAlt = vNode.hasAttr('alt') && !vNode.attr('alt');
        var hasGlobalAria = get_global_aria_attrs_default().find(function(attr) {
          return vNode.hasAttr(attr);
        });
        return emptyAlt && !hasGlobalAria && !_isFocusable(vNode) ? 'presentation' : 'img';
      },
      input: function input(vNode) {
        var suggestionsSourceElement;
        if (vNode.hasAttr('list')) {
          var listElement = idrefs_default(vNode.actualNode, 'list').filter(function(node) {
            return !!node;
          })[0];
          suggestionsSourceElement = listElement && listElement.nodeName.toLowerCase() === 'datalist';
        }
        switch (vNode.props.type) {
         case 'checkbox':
          return 'checkbox';

         case 'number':
          return 'spinbutton';

         case 'radio':
          return 'radio';

         case 'range':
          return 'slider';

         case 'search':
          return !suggestionsSourceElement ? 'searchbox' : 'combobox';

         case 'button':
         case 'image':
         case 'reset':
         case 'submit':
          return 'button';

         case 'text':
         case 'tel':
         case 'url':
         case 'email':
         case '':
          return !suggestionsSourceElement ? 'textbox' : 'combobox';

         default:
          return 'textbox';
        }
      },
      li: 'listitem',
      main: 'main',
      math: 'math',
      menu: 'list',
      nav: 'navigation',
      ol: 'list',
      optgroup: 'group',
      option: 'option',
      output: 'status',
      progress: 'progressbar',
      search: 'search',
      section: function section(vNode) {
        return hasAccessibleName(vNode) ? 'region' : null;
      },
      select: function select(vNode) {
        return vNode.hasAttr('multiple') || parseInt(vNode.attr('size')) > 1 ? 'listbox' : 'combobox';
      },
      summary: 'button',
      table: 'table',
      tbody: 'rowgroup',
      td: function td(vNode) {
        var table = closest_default(vNode, 'table');
        var role = get_explicit_role_default(table);
        return [ 'grid', 'treegrid' ].includes(role) ? 'gridcell' : 'cell';
      },
      textarea: 'textbox',
      tfoot: 'rowgroup',
      th: function th(vNode) {
        if (is_column_header_default(vNode)) {
          return 'columnheader';
        }
        if (is_row_header_default(vNode)) {
          return 'rowheader';
        }
      },
      thead: 'rowgroup',
      tr: 'row',
      ul: 'list'
    };
    var implicit_html_roles_default = implicitHtmlRoles;
    function fromPrimative(someString, matcher) {
      var matcherType = _typeof(matcher);
      if (Array.isArray(matcher) && typeof someString !== 'undefined') {
        return matcher.includes(someString);
      }
      if (matcherType === 'function') {
        return !!matcher(someString);
      }
      if (someString !== null && someString !== void 0) {
        if (matcher instanceof RegExp) {
          return matcher.test(someString);
        }
        if (/^\/.*\/$/.test(matcher)) {
          var pattern = matcher.substring(1, matcher.length - 1);
          return new RegExp(pattern).test(someString);
        }
      }
      return matcher === someString;
    }
    var from_primative_default = fromPrimative;
    function hasAccessibleName2(vNode, matcher) {
      return from_primative_default(!!_accessibleTextVirtual(vNode), matcher);
    }
    var has_accessible_name_default = hasAccessibleName2;
    function fromFunction(getValue, matcher) {
      var matcherType = _typeof(matcher);
      if (matcherType !== 'object' || Array.isArray(matcher) || matcher instanceof RegExp) {
        throw new Error('Expect matcher to be an object');
      }
      return Object.keys(matcher).every(function(propName) {
        return from_primative_default(getValue(propName), matcher[propName]);
      });
    }
    var from_function_default = fromFunction;
    function attributes(vNode, matcher) {
      vNode = _nodeLookup(vNode).vNode;
      return from_function_default(function(attrName) {
        return vNode.attr(attrName);
      }, matcher);
    }
    var attributes_default = attributes;
    function condition(arg, matcher) {
      return !!matcher(arg);
    }
    function explicitRole(vNode, matcher) {
      return from_primative_default(get_explicit_role_default(vNode), matcher);
    }
    var explicit_role_default = explicitRole;
    function implicitRole(vNode, matcher) {
      return from_primative_default(implicit_role_default(vNode), matcher);
    }
    var implicit_role_default2 = implicitRole;
    function nodeName(vNode, matcher) {
      vNode = _nodeLookup(vNode).vNode;
      return from_primative_default(vNode.props.nodeName, matcher);
    }
    var node_name_default = nodeName;
    function properties(vNode, matcher) {
      vNode = _nodeLookup(vNode).vNode;
      return from_function_default(function(propName) {
        return vNode.props[propName];
      }, matcher);
    }
    var properties_default = properties;
    function semanticRole(vNode, matcher) {
      return from_primative_default(get_role_default(vNode), matcher);
    }
    var semantic_role_default = semanticRole;
    var matchers = {
      hasAccessibleName: has_accessible_name_default,
      attributes: attributes_default,
      condition: condition,
      explicitRole: explicit_role_default,
      implicitRole: implicit_role_default2,
      nodeName: node_name_default,
      properties: properties_default,
      semanticRole: semantic_role_default
    };
    function fromDefinition(vNode, definition) {
      vNode = _nodeLookup(vNode).vNode;
      if (Array.isArray(definition)) {
        return definition.some(function(definitionItem) {
          return fromDefinition(vNode, definitionItem);
        });
      }
      if (typeof definition === 'string') {
        return _matches(vNode, definition);
      }
      return Object.keys(definition).every(function(matcherName) {
        if (!matchers[matcherName]) {
          throw new Error('Unknown matcher type "'.concat(matcherName, '"'));
        }
        var matchMethod = matchers[matcherName];
        var matcher = definition[matcherName];
        return matchMethod(vNode, matcher);
      });
    }
    var from_definition_default = fromDefinition;
    function matches2(vNode, definition) {
      return from_definition_default(vNode, definition);
    }
    var matches_default = matches2;
    matches_default.hasAccessibleName = has_accessible_name_default;
    matches_default.attributes = attributes_default;
    matches_default.condition = condition;
    matches_default.explicitRole = explicit_role_default;
    matches_default.fromDefinition = from_definition_default;
    matches_default.fromFunction = from_function_default;
    matches_default.fromPrimative = from_primative_default;
    matches_default.implicitRole = implicit_role_default2;
    matches_default.nodeName = node_name_default;
    matches_default.properties = properties_default;
    matches_default.semanticRole = semantic_role_default;
    var matches_default2 = matches_default;
    function getElementSpec(vNode) {
      var _ref28 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref28$noMatchAccessi = _ref28.noMatchAccessibleName, noMatchAccessibleName = _ref28$noMatchAccessi === void 0 ? false : _ref28$noMatchAccessi;
      var standard = standards_default.htmlElms[vNode.props.nodeName];
      if (!standard) {
        return {};
      }
      if (!standard.variant) {
        return standard;
      }
      var variant = standard.variant, spec = _objectWithoutProperties(standard, _excluded4);
      for (var variantName in variant) {
        if (!variant.hasOwnProperty(variantName) || variantName === 'default') {
          continue;
        }
        var _variant$variantName = variant[variantName], matches4 = _variant$variantName.matches, props = _objectWithoutProperties(_variant$variantName, _excluded5);
        var matchProperties = Array.isArray(matches4) ? matches4 : [ matches4 ];
        for (var _i9 = 0; _i9 < matchProperties.length && noMatchAccessibleName; _i9++) {
          if (matchProperties[_i9].hasOwnProperty('hasAccessibleName')) {
            return standard;
          }
        }
        if (matches_default2(vNode, matches4)) {
          for (var propName in props) {
            if (props.hasOwnProperty(propName)) {
              spec[propName] = props[propName];
            }
          }
        }
      }
      for (var _propName in variant['default']) {
        if (variant['default'].hasOwnProperty(_propName) && typeof spec[_propName] === 'undefined') {
          spec[_propName] = variant['default'][_propName];
        }
      }
      return spec;
    }
    var get_element_spec_default = getElementSpec;
    function implicitRole2(node) {
      var _ref29 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, chromium = _ref29.chromium;
      var vNode = node instanceof abstract_virtual_node_default ? node : get_node_from_tree_default(node);
      node = vNode.actualNode;
      if (!vNode) {
        throw new ReferenceError('Cannot get implicit role of a node outside the current scope.');
      }
      var nodeName2 = vNode.props.nodeName;
      var role = implicit_html_roles_default[nodeName2];
      if (!role && chromium) {
        var _get_element_spec_def = get_element_spec_default(vNode), chromiumRole = _get_element_spec_def.chromiumRole;
        return chromiumRole || null;
      }
      if (typeof role === 'function') {
        return role(vNode);
      }
      return role || null;
    }
    var implicit_role_default = implicitRole2;
    var inheritsPresentationChain = {
      td: [ 'tr' ],
      th: [ 'tr' ],
      tr: [ 'thead', 'tbody', 'tfoot', 'table' ],
      thead: [ 'table' ],
      tbody: [ 'table' ],
      tfoot: [ 'table' ],
      li: [ 'ol', 'ul' ],
      dt: [ 'dl', 'div' ],
      dd: [ 'dl', 'div' ],
      div: [ 'dl' ]
    };
    function getInheritedRole(vNode, explicitRoleOptions) {
      var parentNodeNames = inheritsPresentationChain[vNode.props.nodeName];
      if (!parentNodeNames) {
        return null;
      }
      if (!vNode.parent) {
        if (!vNode.actualNode) {
          return null;
        }
        throw new ReferenceError('Cannot determine role presentational inheritance of a required parent outside the current scope.');
      }
      if (!parentNodeNames.includes(vNode.parent.props.nodeName)) {
        return null;
      }
      var parentRole = get_explicit_role_default(vNode.parent, explicitRoleOptions);
      if ([ 'none', 'presentation' ].includes(parentRole) && !hasConflictResolution(vNode.parent)) {
        return parentRole;
      }
      if (parentRole) {
        return null;
      }
      return getInheritedRole(vNode.parent, explicitRoleOptions);
    }
    function resolveImplicitRole(vNode, _ref30) {
      var chromium = _ref30.chromium, explicitRoleOptions = _objectWithoutProperties(_ref30, _excluded6);
      var implicitRole3 = implicit_role_default(vNode, {
        chromium: chromium
      });
      if (!implicitRole3) {
        return null;
      }
      var presentationalRole = getInheritedRole(vNode, explicitRoleOptions);
      if (presentationalRole) {
        return presentationalRole;
      }
      return implicitRole3;
    }
    function hasConflictResolution(vNode) {
      var hasGlobalAria = get_global_aria_attrs_default().some(function(attr) {
        return vNode.hasAttr(attr);
      });
      return hasGlobalAria || _isFocusable(vNode);
    }
    function resolveRole(node) {
      var _ref31 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var noImplicit = _ref31.noImplicit, roleOptions = _objectWithoutProperties(_ref31, _excluded7);
      var _nodeLookup10 = _nodeLookup(node), vNode = _nodeLookup10.vNode;
      if (vNode.props.nodeType !== 1) {
        return null;
      }
      var explicitRole2 = get_explicit_role_default(vNode, roleOptions);
      if (!explicitRole2) {
        return noImplicit ? null : resolveImplicitRole(vNode, roleOptions);
      }
      if (![ 'presentation', 'none' ].includes(explicitRole2)) {
        return explicitRole2;
      }
      if (hasConflictResolution(vNode)) {
        return noImplicit ? null : resolveImplicitRole(vNode, roleOptions);
      }
      return explicitRole2;
    }
    function getRole(node) {
      var _ref32 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var noPresentational = _ref32.noPresentational, options = _objectWithoutProperties(_ref32, _excluded8);
      var role = resolveRole(node, options);
      if (noPresentational && [ 'presentation', 'none' ].includes(role)) {
        return null;
      }
      return role;
    }
    var get_role_default = getRole;
    var alwaysTitleElements = [ 'iframe' ];
    function titleText(node) {
      var _nodeLookup11 = _nodeLookup(node), vNode = _nodeLookup11.vNode;
      if (vNode.props.nodeType !== 1 || !node.hasAttr('title')) {
        return '';
      }
      if (!matches_default(vNode, alwaysTitleElements) && [ 'none', 'presentation' ].includes(get_role_default(vNode))) {
        return '';
      }
      return vNode.attr('title');
    }
    var title_text_default = titleText;
    function namedFromContents(vNode) {
      var _ref33 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, strict = _ref33.strict;
      vNode = vNode instanceof abstract_virtual_node_default ? vNode : get_node_from_tree_default(vNode);
      if (vNode.props.nodeType !== 1) {
        return false;
      }
      var role = get_role_default(vNode);
      var roleDef = standards_default.ariaRoles[role];
      if (roleDef && roleDef.nameFromContent) {
        return true;
      }
      if (strict) {
        return false;
      }
      return !roleDef || [ 'presentation', 'none' ].includes(role);
    }
    var named_from_contents_default = namedFromContents;
    function getOwnedVirtual(virtualNode) {
      var actualNode = virtualNode.actualNode, children = virtualNode.children;
      if (!children) {
        throw new Error('getOwnedVirtual requires a virtual node');
      }
      if (virtualNode.hasAttr('aria-owns')) {
        var owns = idrefs_default(actualNode, 'aria-owns').filter(function(element) {
          return !!element;
        }).map(function(element) {
          return axe.utils.getNodeFromTree(element);
        });
        return [].concat(_toConsumableArray(children), _toConsumableArray(owns));
      }
      return _toConsumableArray(children);
    }
    var get_owned_virtual_default = getOwnedVirtual;
    var unsupported_default = {
      accessibleNameFromFieldValue: [ 'progressbar' ]
    };
    function _isVisibleToScreenReaders(vNode) {
      vNode = _nodeLookup(vNode).vNode;
      return isVisibleToScreenReadersVirtual(vNode);
    }
    var isVisibleToScreenReadersVirtual = memoize_default(function isVisibleToScreenReadersMemoized(vNode, isAncestor) {
      if (ariaHidden(vNode) || _isInert(vNode, {
        skipAncestors: true,
        isAncestor: isAncestor
      })) {
        return false;
      }
      if (vNode.actualNode && vNode.props.nodeName === 'area') {
        return !areaHidden(vNode, isVisibleToScreenReadersVirtual);
      }
      if (_isHiddenForEveryone(vNode, {
        skipAncestors: true,
        isAncestor: isAncestor
      })) {
        return false;
      }
      if (!vNode.parent) {
        return true;
      }
      return isVisibleToScreenReadersVirtual(vNode.parent, true);
    });
    function visibleVirtual(element, screenReader, noRecursing) {
      var _nodeLookup12 = _nodeLookup(element), vNode = _nodeLookup12.vNode;
      var visibleMethod = screenReader ? _isVisibleToScreenReaders : _isVisibleOnScreen;
      var visible2 = !element.actualNode || element.actualNode && visibleMethod(element);
      var result = vNode.children.map(function(child) {
        var _child$props = child.props, nodeType = _child$props.nodeType, nodeValue = _child$props.nodeValue;
        if (nodeType === 3) {
          if (nodeValue && visible2) {
            return nodeValue;
          }
        } else if (!noRecursing) {
          return visibleVirtual(child, screenReader);
        }
      }).join('');
      return sanitize_default(result);
    }
    var visible_virtual_default = visibleVirtual;
    var nonTextInputTypes = [ 'button', 'checkbox', 'color', 'file', 'hidden', 'image', 'password', 'radio', 'reset', 'submit' ];
    function isNativeTextbox(node) {
      node = node instanceof abstract_virtual_node_default ? node : get_node_from_tree_default(node);
      var nodeName2 = node.props.nodeName;
      return nodeName2 === 'textarea' || nodeName2 === 'input' && !nonTextInputTypes.includes((node.attr('type') || '').toLowerCase());
    }
    var is_native_textbox_default = isNativeTextbox;
    function isNativeSelect(node) {
      node = node instanceof abstract_virtual_node_default ? node : get_node_from_tree_default(node);
      var nodeName2 = node.props.nodeName;
      return nodeName2 === 'select';
    }
    var is_native_select_default = isNativeSelect;
    function isAriaTextbox(node) {
      var role = get_explicit_role_default(node);
      return role === 'textbox';
    }
    var is_aria_textbox_default = isAriaTextbox;
    function isAriaListbox(node) {
      var role = get_explicit_role_default(node);
      return role === 'listbox';
    }
    var is_aria_listbox_default = isAriaListbox;
    function isAriaCombobox(node) {
      var role = get_explicit_role_default(node);
      return role === 'combobox';
    }
    var is_aria_combobox_default = isAriaCombobox;
    var rangeRoles = [ 'progressbar', 'scrollbar', 'slider', 'spinbutton' ];
    function isAriaRange(node) {
      var role = get_explicit_role_default(node);
      return rangeRoles.includes(role);
    }
    var is_aria_range_default = isAriaRange;
    var controlValueRoles = [ 'textbox', 'progressbar', 'scrollbar', 'slider', 'spinbutton', 'combobox', 'listbox' ];
    var _formControlValueMethods = {
      nativeTextboxValue: nativeTextboxValue,
      nativeSelectValue: nativeSelectValue,
      ariaTextboxValue: ariaTextboxValue,
      ariaListboxValue: ariaListboxValue,
      ariaComboboxValue: ariaComboboxValue,
      ariaRangeValue: ariaRangeValue
    };
    function formControlValue(virtualNode) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var actualNode = virtualNode.actualNode;
      var unsupportedRoles = unsupported_default.accessibleNameFromFieldValue || [];
      var role = get_role_default(virtualNode);
      if (context.startNode === virtualNode || !controlValueRoles.includes(role) || unsupportedRoles.includes(role)) {
        return '';
      }
      var valueMethods = Object.keys(_formControlValueMethods).map(function(name) {
        return _formControlValueMethods[name];
      });
      var valueString = valueMethods.reduce(function(accName, step) {
        return accName || step(virtualNode, context);
      }, '');
      if (context.debug) {
        log_default(valueString || '{empty-value}', actualNode, context);
      }
      return valueString;
    }
    function nativeTextboxValue(node) {
      var _nodeLookup13 = _nodeLookup(node), vNode = _nodeLookup13.vNode;
      if (is_native_textbox_default(vNode)) {
        return vNode.props.value || '';
      }
      return '';
    }
    function nativeSelectValue(node) {
      var _nodeLookup14 = _nodeLookup(node), vNode = _nodeLookup14.vNode;
      if (!is_native_select_default(vNode)) {
        return '';
      }
      var options = query_selector_all_default(vNode, 'option');
      var selectedOptions = options.filter(function(option) {
        return option.props.selected;
      });
      if (!selectedOptions.length) {
        selectedOptions.push(options[0]);
      }
      return selectedOptions.map(function(option) {
        return visible_virtual_default(option);
      }).join(' ') || '';
    }
    function ariaTextboxValue(node) {
      var _nodeLookup15 = _nodeLookup(node), vNode = _nodeLookup15.vNode, domNode = _nodeLookup15.domNode;
      if (!is_aria_textbox_default(vNode)) {
        return '';
      }
      if (!domNode || domNode && !_isHiddenForEveryone(domNode)) {
        return visible_virtual_default(vNode, true);
      } else {
        return domNode.textContent;
      }
    }
    function ariaListboxValue(node, context) {
      var _nodeLookup16 = _nodeLookup(node), vNode = _nodeLookup16.vNode;
      if (!is_aria_listbox_default(vNode)) {
        return '';
      }
      var selected = get_owned_virtual_default(vNode).filter(function(owned) {
        return get_role_default(owned) === 'option' && owned.attr('aria-selected') === 'true';
      });
      if (selected.length === 0) {
        return '';
      }
      return _accessibleTextVirtual(selected[0], context);
    }
    function ariaComboboxValue(node, context) {
      var _nodeLookup17 = _nodeLookup(node), vNode = _nodeLookup17.vNode;
      if (!is_aria_combobox_default(vNode)) {
        return '';
      }
      var listbox = get_owned_virtual_default(vNode).filter(function(elm) {
        return get_role_default(elm) === 'listbox';
      })[0];
      return listbox ? ariaListboxValue(listbox, context) : '';
    }
    function ariaRangeValue(node) {
      var _nodeLookup18 = _nodeLookup(node), vNode = _nodeLookup18.vNode;
      if (!is_aria_range_default(vNode) || !vNode.hasAttr('aria-valuenow')) {
        return '';
      }
      var valueNow = +vNode.attr('aria-valuenow');
      return !isNaN(valueNow) ? String(valueNow) : '0';
    }
    var form_control_value_default = formControlValue;
    function subtreeText(virtualNode) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var alreadyProcessed2 = _accessibleTextVirtual.alreadyProcessed;
      context.startNode = context.startNode || virtualNode;
      var _context = context, strict = _context.strict, inControlContext = _context.inControlContext, inLabelledByContext = _context.inLabelledByContext;
      var role = get_role_default(virtualNode);
      var _get_element_spec_def2 = get_element_spec_default(virtualNode, {
        noMatchAccessibleName: true
      }), contentTypes = _get_element_spec_def2.contentTypes;
      if (alreadyProcessed2(virtualNode, context) || virtualNode.props.nodeType !== 1 || contentTypes !== null && contentTypes !== void 0 && contentTypes.includes('embedded') || controlValueRoles.includes(role)) {
        return '';
      }
      if (!context.subtreeDescendant && !context.inLabelledByContext && !named_from_contents_default(virtualNode, {
        strict: strict
      })) {
        return '';
      }
      if (!strict) {
        var subtreeDescendant = !inControlContext && !inLabelledByContext;
        context = _extends({
          subtreeDescendant: subtreeDescendant
        }, context);
      }
      return get_owned_virtual_default(virtualNode).reduce(function(contentText, child) {
        return appendAccessibleText(contentText, child, context);
      }, '');
    }
    var phrasingElements = get_elements_by_content_type_default('phrasing').concat([ '#text' ]);
    function appendAccessibleText(contentText, virtualNode, context) {
      var nodeName2 = virtualNode.props.nodeName;
      var contentTextAdd = _accessibleTextVirtual(virtualNode, context);
      if (!contentTextAdd) {
        return contentText;
      }
      if (!phrasingElements.includes(nodeName2)) {
        if (contentTextAdd[0] !== ' ') {
          contentTextAdd += ' ';
        }
        if (contentText && contentText[contentText.length - 1] !== ' ') {
          contentTextAdd = ' ' + contentTextAdd;
        }
      }
      return contentText + contentTextAdd;
    }
    var subtree_text_default = subtreeText;
    function labelText(virtualNode) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var alreadyProcessed2 = _accessibleTextVirtual.alreadyProcessed;
      if (context.inControlContext || context.inLabelledByContext || alreadyProcessed2(virtualNode, context)) {
        return '';
      }
      if (!context.startNode) {
        context.startNode = virtualNode;
      }
      var labelContext = _extends({
        inControlContext: true
      }, context);
      var explicitLabels = getExplicitLabels(virtualNode);
      var implicitLabel = closest_default(virtualNode, 'label');
      var labels;
      if (implicitLabel) {
        labels = [].concat(_toConsumableArray(explicitLabels), [ implicitLabel.actualNode ]);
        labels.sort(node_sorter_default);
      } else {
        labels = explicitLabels;
      }
      return labels.map(function(label3) {
        return accessible_text_default(label3, labelContext);
      }).filter(function(text) {
        return text !== '';
      }).join(' ');
    }
    function getExplicitLabels(virtualNode) {
      if (!virtualNode.attr('id')) {
        return [];
      }
      if (!virtualNode.actualNode) {
        throw new TypeError('Cannot resolve explicit label reference for non-DOM nodes');
      }
      return find_elms_in_context_default({
        elm: 'label',
        attr: 'for',
        value: virtualNode.attr('id'),
        context: virtualNode.actualNode
      });
    }
    var label_text_default = labelText;
    var defaultButtonValues = {
      submit: 'Submit',
      image: 'Submit',
      reset: 'Reset',
      button: ''
    };
    var nativeTextMethods = {
      valueText: function valueText(_ref34) {
        var actualNode = _ref34.actualNode;
        return actualNode.value || '';
      },
      buttonDefaultText: function buttonDefaultText(_ref35) {
        var actualNode = _ref35.actualNode;
        return defaultButtonValues[actualNode.type] || '';
      },
      tableCaptionText: descendantText.bind(null, 'caption'),
      figureText: descendantText.bind(null, 'figcaption'),
      svgTitleText: descendantText.bind(null, 'title'),
      fieldsetLegendText: descendantText.bind(null, 'legend'),
      altText: attrText.bind(null, 'alt'),
      tableSummaryText: attrText.bind(null, 'summary'),
      titleText: title_text_default,
      subtreeText: subtree_text_default,
      labelText: label_text_default,
      singleSpace: function singleSpace() {
        return ' ';
      },
      placeholderText: attrText.bind(null, 'placeholder')
    };
    function attrText(attr, vNode) {
      return vNode.attr(attr) || '';
    }
    function descendantText(nodeName2, _ref36, context) {
      var actualNode = _ref36.actualNode;
      nodeName2 = nodeName2.toLowerCase();
      var nodeNames2 = [ nodeName2, actualNode.nodeName.toLowerCase() ].join(',');
      var candidate = actualNode.querySelector(nodeNames2);
      if (!candidate || candidate.nodeName.toLowerCase() !== nodeName2) {
        return '';
      }
      return accessible_text_default(candidate, context);
    }
    var native_text_methods_default = nativeTextMethods;
    function _nativeTextAlternative(virtualNode) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var actualNode = virtualNode.actualNode;
      if (virtualNode.props.nodeType !== 1 || [ 'presentation', 'none' ].includes(get_role_default(virtualNode))) {
        return '';
      }
      var textMethods = findTextMethods(virtualNode);
      var accessibleName = textMethods.reduce(function(accName, step) {
        return accName || step(virtualNode, context);
      }, '');
      if (context.debug) {
        axe.log(accessibleName || '{empty-value}', actualNode, context);
      }
      return accessibleName;
    }
    function findTextMethods(virtualNode) {
      var elmSpec = get_element_spec_default(virtualNode, {
        noMatchAccessibleName: true
      });
      var methods = elmSpec.namingMethods || [];
      return methods.map(function(methodName) {
        return native_text_methods_default[methodName];
      });
    }
    function getUnicodeNonBmpRegExp() {
      return /[\u1D00-\u1D7F\u1D80-\u1DBF\u1DC0-\u1DFF\u20A0-\u20CF\u20D0-\u20FF\u2100-\u214F\u2150-\u218F\u2190-\u21FF\u2200-\u22FF\u2300-\u23FF\u2400-\u243F\u2440-\u245F\u2460-\u24FF\u2500-\u257F\u2580-\u259F\u25A0-\u25FF\u2600-\u26FF\u2700-\u27BF\uE000-\uF8FF]/g;
    }
    function getPunctuationRegExp() {
      return /[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&\xa3\xa2\xa5\xa7\u20ac()*+,\-.\/:;<=>?@\[\]^_`{|}~\xb1]/g;
    }
    function getSupplementaryPrivateUseRegExp() {
      return /[\uDB80-\uDBBF][\uDC00-\uDFFF]/g;
    }
    function getCategoryFormatRegExp() {
      return /[\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804[\uDCBD\uDCCD]|\uD80D[\uDC30-\uDC38]|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/g;
    }
    var emoji_regex_default = function emoji_regex_default() {
      return /[#*0-9]\uFE0F?\u20E3|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26AA\u26B0\u26B1\u26BD\u26BE\u26C4\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0-\u26F5\u26F7\u26F8\u26FA\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B55\u3030\u303D\u3297\u3299]\uFE0F?|[\u261D\u270C\u270D](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\u270A\u270B](?:\uD83C[\uDFFB-\uDFFF])?|[\u23E9-\u23EC\u23F0\u23F3\u25FD\u2693\u26A1\u26AB\u26C5\u26CE\u26D4\u26EA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2795-\u2797\u27B0\u27BF\u2B50]|\u26F9(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\u2764\uFE0F?(?:\u200D(?:\uD83D\uDD25|\uD83E\uDE79))?|\uD83C(?:[\uDC04\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]\uFE0F?|[\uDF85\uDFC2\uDFC7](?:\uD83C[\uDFFB-\uDFFF])?|[\uDFC3\uDFC4\uDFCA](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDFCB\uDFCC](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uDDE6\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF]|\uDDE7\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF]|\uDDE8\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF]|\uDDE9\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF]|\uDDEA\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA]|\uDDEB\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7]|\uDDEC\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE]|\uDDED\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA]|\uDDEE\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9]|\uDDEF\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5]|\uDDF0\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF]|\uDDF1\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE]|\uDDF2\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF]|\uDDF3\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF]|\uDDF4\uD83C\uDDF2|\uDDF5\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE]|\uDDF6\uD83C\uDDE6|\uDDF7\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC]|\uDDF8\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF]|\uDDF9\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF]|\uDDFA\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF]|\uDDFB\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA]|\uDDFC\uD83C[\uDDEB\uDDF8]|\uDDFD\uD83C\uDDF0|\uDDFE\uD83C[\uDDEA\uDDF9]|\uDDFF\uD83C[\uDDE6\uDDF2\uDDFC]|\uDFF3\uFE0F?(?:\u200D(?:\u26A7\uFE0F?|\uD83C\uDF08))?|\uDFF4(?:\u200D\u2620\uFE0F?|\uDB40\uDC67\uDB40\uDC62\uDB40(?:\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDC73\uDB40\uDC63\uDB40\uDC74|\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F)?)|\uD83D(?:[\uDC08\uDC26](?:\u200D\u2B1B)?|[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3]\uFE0F?|[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC](?:\uD83C[\uDFFB-\uDFFF])?|[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD74\uDD90](?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?|[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC25\uDC27-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEDC-\uDEDF\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB\uDFF0]|\uDC15(?:\u200D\uD83E\uDDBA)?|\uDC3B(?:\u200D\u2744\uFE0F?)?|\uDC41\uFE0F?(?:\u200D\uD83D\uDDE8\uFE0F?)?|\uDC68(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDC68\uDC69]\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFE])))?))?|\uDC69(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?[\uDC68\uDC69]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?|\uDC69\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?))|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFE])))?))?|\uDC6F(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDD75(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDE2E(?:\u200D\uD83D\uDCA8)?|\uDE35(?:\u200D\uD83D\uDCAB)?|\uDE36(?:\u200D\uD83C\uDF2B\uFE0F?)?)|\uD83E(?:[\uDD0C\uDD0F\uDD18-\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5\uDEC3-\uDEC5\uDEF0\uDEF2-\uDEF8](?:\uD83C[\uDFFB-\uDFFF])?|[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDDDE\uDDDF](?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD0D\uDD0E\uDD10-\uDD17\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCC\uDDD0\uDDE0-\uDDFF\uDE70-\uDE7C\uDE80-\uDE88\uDE90-\uDEBD\uDEBF-\uDEC2\uDECE-\uDEDB\uDEE0-\uDEE8]|\uDD3C(?:\u200D[\u2640\u2642]\uFE0F?|\uD83C[\uDFFB-\uDFFF])?|\uDDD1(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFC-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFD-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFD\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFE]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF-\uDDB3\uDDBC\uDDBD]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?))?|\uDEF1(?:\uD83C(?:\uDFFB(?:\u200D\uD83E\uDEF2\uD83C[\uDFFC-\uDFFF])?|\uDFFC(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFD-\uDFFF])?|\uDFFD(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])?|\uDFFE(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFD\uDFFF])?|\uDFFF(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFE])?))?)/g;
    };
    function hasUnicode(str, options) {
      var emoji = options.emoji, nonBmp = options.nonBmp, punctuations = options.punctuations;
      var value = false;
      if (emoji) {
        value || (value = emoji_regex_default().test(str));
      }
      if (nonBmp) {
        value || (value = getUnicodeNonBmpRegExp().test(str) || getSupplementaryPrivateUseRegExp().test(str) || getCategoryFormatRegExp().test(str));
      }
      if (punctuations) {
        value || (value = getPunctuationRegExp().test(str));
      }
      return value;
    }
    var has_unicode_default = hasUnicode;
    function _isIconLigature(textVNode) {
      var differenceThreshold = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : .15;
      var occurrenceThreshold = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 3;
      var nodeValue = textVNode.actualNode.nodeValue.trim();
      if (!sanitize_default(nodeValue) || has_unicode_default(nodeValue, {
        emoji: true,
        nonBmp: true
      })) {
        return false;
      }
      var canvasContext = cache_default.get('canvasContext', function() {
        return document.createElement('canvas').getContext('2d', {
          willReadFrequently: true
        });
      });
      var canvas = canvasContext.canvas;
      var fonts = cache_default.get('fonts', function() {
        return {};
      });
      var style = window.getComputedStyle(textVNode.parent.actualNode);
      var fontFamily = style.getPropertyValue('font-family');
      if (!fonts[fontFamily]) {
        fonts[fontFamily] = {
          occurrences: 0,
          numLigatures: 0
        };
      }
      var font = fonts[fontFamily];
      if (font.occurrences >= occurrenceThreshold) {
        if (font.numLigatures / font.occurrences === 1) {
          return true;
        } else if (font.numLigatures === 0) {
          return false;
        }
      }
      font.occurrences++;
      var fontSize = 30;
      var fontStyle = ''.concat(fontSize, 'px ').concat(fontFamily);
      canvasContext.font = fontStyle;
      var firstChar = nodeValue.charAt(0);
      var width = canvasContext.measureText(firstChar).width;
      if (width === 0) {
        font.numLigatures++;
        return true;
      }
      if (width < 30) {
        var diff = 30 / width;
        width *= diff;
        fontSize *= diff;
        fontStyle = ''.concat(fontSize, 'px ').concat(fontFamily);
      }
      canvas.width = width;
      canvas.height = fontSize;
      canvasContext.font = fontStyle;
      canvasContext.textAlign = 'left';
      canvasContext.textBaseline = 'top';
      canvasContext.fillText(firstChar, 0, 0);
      var compareData = new Uint32Array(canvasContext.getImageData(0, 0, width, fontSize).data.buffer);
      if (!compareData.some(function(pixel) {
        return pixel;
      })) {
        font.numLigatures++;
        return true;
      }
      canvasContext.clearRect(0, 0, width, fontSize);
      canvasContext.fillText(nodeValue, 0, 0);
      var compareWith = new Uint32Array(canvasContext.getImageData(0, 0, width, fontSize).data.buffer);
      var differences = compareData.reduce(function(diff, pixel, i) {
        if (pixel === 0 && compareWith[i] === 0) {
          return diff;
        }
        if (pixel !== 0 && compareWith[i] !== 0) {
          return diff;
        }
        return ++diff;
      }, 0);
      var expectedWidth = nodeValue.split('').reduce(function(totalWidth, _char2) {
        return totalWidth + canvasContext.measureText(_char2).width;
      }, 0);
      var actualWidth = canvasContext.measureText(nodeValue).width;
      var pixelDifference = differences / compareData.length;
      var sizeDifference = 1 - actualWidth / expectedWidth;
      if (pixelDifference >= differenceThreshold && sizeDifference >= differenceThreshold) {
        font.numLigatures++;
        return true;
      }
      return false;
    }
    function _accessibleTextVirtual(virtualNode) {
      var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      context = prepareContext(virtualNode, context);
      if (shouldIgnoreHidden(virtualNode, context)) {
        return '';
      }
      if (shouldIgnoreIconLigature(virtualNode, context)) {
        return '';
      }
      var computationSteps = [ arialabelledby_text_default, _arialabelText, _nativeTextAlternative, form_control_value_default, subtree_text_default, textNodeValue, title_text_default ];
      var accessibleName = computationSteps.reduce(function(accName, step) {
        if (context.startNode === virtualNode) {
          accName = sanitize_default(accName);
        }
        if (accName !== '') {
          return accName;
        }
        return step(virtualNode, context);
      }, '');
      if (context.debug) {
        axe.log(accessibleName || '{empty-value}', virtualNode.actualNode, context);
      }
      return accessibleName;
    }
    function textNodeValue(virtualNode) {
      if (virtualNode.props.nodeType !== 3) {
        return '';
      }
      return virtualNode.props.nodeValue;
    }
    function shouldIgnoreHidden(virtualNode, context) {
      if (!virtualNode) {
        return false;
      }
      if (virtualNode.props.nodeType !== 1 || context.includeHidden) {
        return false;
      }
      return !_isVisibleToScreenReaders(virtualNode);
    }
    function shouldIgnoreIconLigature(virtualNode, context) {
      var _context$occurrenceTh;
      var ignoreIconLigature = context.ignoreIconLigature, pixelThreshold = context.pixelThreshold;
      var occurrenceThreshold = (_context$occurrenceTh = context.occurrenceThreshold) !== null && _context$occurrenceTh !== void 0 ? _context$occurrenceTh : context.occuranceThreshold;
      if (virtualNode.props.nodeType !== 3 || !ignoreIconLigature) {
        return false;
      }
      return _isIconLigature(virtualNode, pixelThreshold, occurrenceThreshold);
    }
    function prepareContext(virtualNode, context) {
      if (!context.startNode) {
        context = _extends({
          startNode: virtualNode
        }, context);
      }
      if (virtualNode.props.nodeType === 1 && context.inLabelledByContext && context.includeHidden === void 0) {
        context = _extends({
          includeHidden: !_isVisibleToScreenReaders(virtualNode)
        }, context);
      }
      return context;
    }
    _accessibleTextVirtual.alreadyProcessed = function alreadyProcessed(virtualnode, context) {
      context.processed = context.processed || [];
      if (context.processed.includes(virtualnode)) {
        return true;
      }
      context.processed.push(virtualnode);
      return false;
    };
    function removeUnicode(str, options) {
      var emoji = options.emoji, nonBmp = options.nonBmp, punctuations = options.punctuations;
      if (emoji) {
        str = str.replace(emoji_regex_default(), '');
      }
      if (nonBmp) {
        str = str.replace(getUnicodeNonBmpRegExp(), '').replace(getSupplementaryPrivateUseRegExp(), '').replace(getCategoryFormatRegExp(), '');
      }
      if (punctuations) {
        str = str.replace(getPunctuationRegExp(), '');
      }
      return str;
    }
    var remove_unicode_default = removeUnicode;
    function isHumanInterpretable(str) {
      if (!str.length) {
        return 0;
      }
      var alphaNumericIconMap = [ 'x', 'i' ];
      if (alphaNumericIconMap.includes(str)) {
        return 0;
      }
      var noUnicodeStr = remove_unicode_default(str, {
        emoji: true,
        nonBmp: true,
        punctuations: true
      });
      if (!sanitize_default(noUnicodeStr)) {
        return 0;
      }
      return 1;
    }
    var is_human_interpretable_default = isHumanInterpretable;
    var _autocomplete = {
      stateTerms: [ 'on', 'off' ],
      standaloneTerms: [ 'name', 'honorific-prefix', 'given-name', 'additional-name', 'family-name', 'honorific-suffix', 'nickname', 'username', 'new-password', 'current-password', 'organization-title', 'organization', 'street-address', 'address-line1', 'address-line2', 'address-line3', 'address-level4', 'address-level3', 'address-level2', 'address-level1', 'country', 'country-name', 'postal-code', 'cc-name', 'cc-given-name', 'cc-additional-name', 'cc-family-name', 'cc-number', 'cc-exp', 'cc-exp-month', 'cc-exp-year', 'cc-csc', 'cc-type', 'transaction-currency', 'transaction-amount', 'language', 'bday', 'bday-day', 'bday-month', 'bday-year', 'sex', 'url', 'photo', 'one-time-code' ],
      qualifiers: [ 'home', 'work', 'mobile', 'fax', 'pager' ],
      qualifiedTerms: [ 'tel', 'tel-country-code', 'tel-national', 'tel-area-code', 'tel-local', 'tel-local-prefix', 'tel-local-suffix', 'tel-extension', 'email', 'impp' ],
      locations: [ 'billing', 'shipping' ]
    };
    function isValidAutocomplete(autocompleteValue) {
      var _ref37 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref37$looseTyped = _ref37.looseTyped, looseTyped = _ref37$looseTyped === void 0 ? false : _ref37$looseTyped, _ref37$stateTerms = _ref37.stateTerms, stateTerms = _ref37$stateTerms === void 0 ? [] : _ref37$stateTerms, _ref37$locations = _ref37.locations, locations = _ref37$locations === void 0 ? [] : _ref37$locations, _ref37$qualifiers = _ref37.qualifiers, qualifiers = _ref37$qualifiers === void 0 ? [] : _ref37$qualifiers, _ref37$standaloneTerm = _ref37.standaloneTerms, standaloneTerms = _ref37$standaloneTerm === void 0 ? [] : _ref37$standaloneTerm, _ref37$qualifiedTerms = _ref37.qualifiedTerms, qualifiedTerms = _ref37$qualifiedTerms === void 0 ? [] : _ref37$qualifiedTerms;
      autocompleteValue = autocompleteValue.toLowerCase().trim();
      stateTerms = stateTerms.concat(_autocomplete.stateTerms);
      if (stateTerms.includes(autocompleteValue) || autocompleteValue === '') {
        return true;
      }
      qualifiers = qualifiers.concat(_autocomplete.qualifiers);
      locations = locations.concat(_autocomplete.locations);
      standaloneTerms = standaloneTerms.concat(_autocomplete.standaloneTerms);
      qualifiedTerms = qualifiedTerms.concat(_autocomplete.qualifiedTerms);
      var autocompleteTerms = autocompleteValue.split(/\s+/g);
      if (autocompleteTerms[autocompleteTerms.length - 1] === 'webauthn') {
        autocompleteTerms.pop();
        if (autocompleteTerms.length === 0) {
          return false;
        }
      }
      if (!looseTyped) {
        if (autocompleteTerms[0].length > 8 && autocompleteTerms[0].substr(0, 8) === 'section-') {
          autocompleteTerms.shift();
        }
        if (locations.includes(autocompleteTerms[0])) {
          autocompleteTerms.shift();
        }
        if (qualifiers.includes(autocompleteTerms[0])) {
          autocompleteTerms.shift();
          standaloneTerms = [];
        }
        if (autocompleteTerms.length !== 1) {
          return false;
        }
      }
      var purposeTerm = autocompleteTerms[autocompleteTerms.length - 1];
      return standaloneTerms.includes(purposeTerm) || qualifiedTerms.includes(purposeTerm);
    }
    var is_valid_autocomplete_default = isValidAutocomplete;
    function labelVirtual(virtualNode) {
      var ref, candidate;
      if (virtualNode.attr('aria-labelledby')) {
        ref = idrefs_default(virtualNode.actualNode, 'aria-labelledby');
        candidate = ref.map(function(thing) {
          var vNode = get_node_from_tree_default(thing);
          return vNode ? visible_virtual_default(vNode) : '';
        }).join(' ').trim();
        if (candidate) {
          return candidate;
        }
      }
      candidate = virtualNode.attr('aria-label');
      if (candidate) {
        candidate = sanitize_default(candidate);
        if (candidate) {
          return candidate;
        }
      }
      return null;
    }
    var label_virtual_default = labelVirtual;
    function visible(element, screenReader, noRecursing) {
      element = get_node_from_tree_default(element);
      return visible_virtual_default(element, screenReader, noRecursing);
    }
    var visible_default = visible;
    function labelVirtual2(virtualNode) {
      var ref, candidate, doc;
      candidate = label_virtual_default(virtualNode);
      if (candidate) {
        return candidate;
      }
      if (virtualNode.attr('id')) {
        if (!virtualNode.actualNode) {
          throw new TypeError('Cannot resolve explicit label reference for non-DOM nodes');
        }
        var id = escape_selector_default(virtualNode.attr('id'));
        doc = get_root_node_default2(virtualNode.actualNode);
        ref = doc.querySelector('label[for="' + id + '"]');
        candidate = ref && visible_default(ref, true);
        if (candidate) {
          return candidate;
        }
      }
      ref = closest_default(virtualNode, 'label');
      candidate = ref && visible_virtual_default(ref, true);
      if (candidate) {
        return candidate;
      }
      return null;
    }
    var label_virtual_default2 = labelVirtual2;
    function label(node) {
      node = get_node_from_tree_default(node);
      return label_virtual_default2(node);
    }
    var label_default = label;
    var nativeElementType = [ {
      matches: [ {
        nodeName: 'textarea'
      }, {
        nodeName: 'input',
        properties: {
          type: [ 'text', 'password', 'search', 'tel', 'email', 'url' ]
        }
      } ],
      namingMethods: 'labelText'
    }, {
      matches: {
        nodeName: 'input',
        properties: {
          type: [ 'button', 'submit', 'reset' ]
        }
      },
      namingMethods: [ 'valueText', 'titleText', 'buttonDefaultText' ]
    }, {
      matches: {
        nodeName: 'input',
        properties: {
          type: 'image'
        }
      },
      namingMethods: [ 'altText', 'valueText', 'labelText', 'titleText', 'buttonDefaultText' ]
    }, {
      matches: 'button',
      namingMethods: 'subtreeText'
    }, {
      matches: 'fieldset',
      namingMethods: 'fieldsetLegendText'
    }, {
      matches: 'OUTPUT',
      namingMethods: 'subtreeText'
    }, {
      matches: [ {
        nodeName: 'select'
      }, {
        nodeName: 'input',
        properties: {
          type: /^(?!text|password|search|tel|email|url|button|submit|reset)/
        }
      } ],
      namingMethods: 'labelText'
    }, {
      matches: 'summary',
      namingMethods: 'subtreeText'
    }, {
      matches: 'figure',
      namingMethods: [ 'figureText', 'titleText' ]
    }, {
      matches: 'img',
      namingMethods: 'altText'
    }, {
      matches: 'table',
      namingMethods: [ 'tableCaptionText', 'tableSummaryText' ]
    }, {
      matches: [ 'hr', 'br' ],
      namingMethods: [ 'titleText', 'singleSpace' ]
    } ];
    var native_element_type_default = nativeElementType;
    function visibleTextNodes(vNode) {
      var parentVisible = _isVisibleOnScreen(vNode);
      var nodes = [];
      vNode.children.forEach(function(child) {
        if (child.actualNode.nodeType === 3) {
          if (parentVisible) {
            nodes.push(child);
          }
        } else {
          nodes = nodes.concat(visibleTextNodes(child));
        }
      });
      return nodes;
    }
    var visible_text_nodes_default = visibleTextNodes;
    var getVisibleChildTextRects = memoize_default(function getVisibleChildTextRectsMemoized(node) {
      var vNode = get_node_from_tree_default(node);
      var nodeRect = vNode.boundingClientRect;
      var clientRects = [];
      var overflowHiddenNodes = get_overflow_hidden_ancestors_default(vNode);
      node.childNodes.forEach(function(textNode) {
        if (textNode.nodeType !== 3 || sanitize_default(textNode.nodeValue) === '') {
          return;
        }
        var contentRects = getContentRects(textNode);
        if (isOutsideNodeBounds(contentRects, nodeRect)) {
          return;
        }
        clientRects.push.apply(clientRects, _toConsumableArray(filterHiddenRects(contentRects, overflowHiddenNodes)));
      });
      return clientRects.length ? clientRects : [ nodeRect ];
    });
    var get_visible_child_text_rects_default = getVisibleChildTextRects;
    function getContentRects(node) {
      var range2 = document.createRange();
      range2.selectNodeContents(node);
      return Array.from(range2.getClientRects());
    }
    function isOutsideNodeBounds(rects, nodeRect) {
      return rects.some(function(rect) {
        var centerPoint = _getRectCenter(rect);
        return !_isPointInRect(centerPoint, nodeRect);
      });
    }
    function filterHiddenRects(contentRects, overflowHiddenNodes) {
      var visibleRects = [];
      contentRects.forEach(function(contentRect) {
        if (contentRect.width < 1 || contentRect.height < 1) {
          return;
        }
        var visibleRect = overflowHiddenNodes.reduce(function(rect, overflowNode) {
          return rect && _getIntersectionRect(rect, overflowNode.boundingClientRect);
        }, contentRect);
        if (visibleRect) {
          visibleRects.push(visibleRect);
        }
      });
      return visibleRects;
    }
    function getTextElementStack(node) {
      _createGrid();
      var vNode = get_node_from_tree_default(node);
      var grid = vNode._grid;
      if (!grid) {
        return [];
      }
      var clientRects = get_visible_child_text_rects_default(node);
      return clientRects.map(function(rect) {
        return getRectStack(grid, rect);
      });
    }
    var get_text_element_stack_default = getTextElementStack;
    var visualRoles = [ 'checkbox', 'img', 'meter', 'progressbar', 'scrollbar', 'radio', 'slider', 'spinbutton', 'textbox' ];
    function isVisualContent(el) {
      var _nodeLookup19 = _nodeLookup(el), vNode = _nodeLookup19.vNode;
      var role = axe.commons.aria.getExplicitRole(vNode);
      if (role) {
        return visualRoles.indexOf(role) !== -1;
      }
      switch (vNode.props.nodeName) {
       case 'img':
       case 'iframe':
       case 'object':
       case 'video':
       case 'audio':
       case 'canvas':
       case 'svg':
       case 'math':
       case 'button':
       case 'select':
       case 'textarea':
       case 'keygen':
       case 'progress':
       case 'meter':
        return true;

       case 'input':
        return vNode.props.type !== 'hidden';

       default:
        return false;
      }
    }
    var is_visual_content_default = isVisualContent;
    var hiddenTextElms = [ 'head', 'title', 'template', 'script', 'style', 'iframe', 'object', 'video', 'audio', 'noscript' ];
    function hasChildTextNodes(elm) {
      if (hiddenTextElms.includes(elm.props.nodeName)) {
        return false;
      }
      return elm.children.some(function(_ref38) {
        var props = _ref38.props;
        return props.nodeType === 3 && props.nodeValue.trim();
      });
    }
    function hasContentVirtual(elm, noRecursion, ignoreAria) {
      return hasChildTextNodes(elm) || is_visual_content_default(elm.actualNode) || !ignoreAria && !!label_virtual_default(elm) || !noRecursion && elm.children.some(function(child) {
        return child.actualNode.nodeType === 1 && hasContentVirtual(child);
      });
    }
    var has_content_virtual_default = hasContentVirtual;
    function hasContent(elm, noRecursion, ignoreAria) {
      elm = get_node_from_tree_default(elm);
      return has_content_virtual_default(elm, noRecursion, ignoreAria);
    }
    var has_content_default = hasContent;
    function _hasLangText(virtualNode) {
      if (typeof virtualNode.children === 'undefined' || hasChildTextNodes(virtualNode)) {
        return true;
      }
      if (virtualNode.props.nodeType === 1 && is_visual_content_default(virtualNode)) {
        return !!axe.commons.text.accessibleTextVirtual(virtualNode);
      }
      return virtualNode.children.some(function(child) {
        return !child.attr('lang') && _hasLangText(child) && !_isHiddenForEveryone(child);
      });
    }
    function insertedIntoFocusOrder(el) {
      var tabIndex = parseInt(el.getAttribute('tabindex'), 10);
      return tabIndex > -1 && _isFocusable(el) && !is_natively_focusable_default(el);
    }
    var inserted_into_focus_order_default = insertedIntoFocusOrder;
    function isHiddenWithCSS(el, descendentVisibilityValue) {
      var _nodeLookup20 = _nodeLookup(el), vNode = _nodeLookup20.vNode, domNode = _nodeLookup20.domNode;
      if (!vNode) {
        return _isHiddenWithCSS(domNode, descendentVisibilityValue);
      }
      if (vNode._isHiddenWithCSS === void 0) {
        vNode._isHiddenWithCSS = _isHiddenWithCSS(domNode, descendentVisibilityValue);
      }
      return vNode._isHiddenWithCSS;
    }
    function _isHiddenWithCSS(el, descendentVisibilityValue) {
      if (el.nodeType === 9) {
        return false;
      }
      if (el.nodeType === 11) {
        el = el.host;
      }
      if ([ 'STYLE', 'SCRIPT' ].includes(el.nodeName.toUpperCase())) {
        return false;
      }
      var style = window.getComputedStyle(el, null);
      if (!style) {
        throw new Error('Style does not exist for the given element.');
      }
      var displayValue = style.getPropertyValue('display');
      if (displayValue === 'none') {
        return true;
      }
      var HIDDEN_VISIBILITY_VALUES = [ 'hidden', 'collapse' ];
      var visibilityValue = style.getPropertyValue('visibility');
      if (HIDDEN_VISIBILITY_VALUES.includes(visibilityValue) && !descendentVisibilityValue) {
        return true;
      }
      if (HIDDEN_VISIBILITY_VALUES.includes(visibilityValue) && descendentVisibilityValue && HIDDEN_VISIBILITY_VALUES.includes(descendentVisibilityValue)) {
        return true;
      }
      var parent = get_composed_parent_default(el);
      if (parent && !HIDDEN_VISIBILITY_VALUES.includes(visibilityValue)) {
        return isHiddenWithCSS(parent, visibilityValue);
      }
      return false;
    }
    var is_hidden_with_css_default = isHiddenWithCSS;
    function isHTML5(doc) {
      var node = doc.doctype;
      if (node === null) {
        return false;
      }
      return node.name === 'html' && !node.publicId && !node.systemId;
    }
    var is_html5_default = isHTML5;
    function getRoleType(role) {
      var _window3;
      if (role instanceof abstract_virtual_node_default || (_window3 = window) !== null && _window3 !== void 0 && _window3.Node && role instanceof window.Node) {
        role = axe.commons.aria.getRole(role);
      }
      var roleDef = standards_default.ariaRoles[role];
      return (roleDef === null || roleDef === void 0 ? void 0 : roleDef.type) || null;
    }
    var get_role_type_default = getRoleType;
    function walkDomNode(node, functor) {
      if (functor(node.actualNode) !== false) {
        node.children.forEach(function(child) {
          return walkDomNode(child, functor);
        });
      }
    }
    var blockLike = [ 'block', 'list-item', 'table', 'flex', 'grid', 'inline-block' ];
    function isBlock(elm) {
      var display2 = window.getComputedStyle(elm).getPropertyValue('display');
      return blockLike.includes(display2) || display2.substr(0, 6) === 'table-';
    }
    function getBlockParent(node) {
      var parentBlock = get_composed_parent_default(node);
      while (parentBlock && !isBlock(parentBlock)) {
        parentBlock = get_composed_parent_default(parentBlock);
      }
      return get_node_from_tree_default(parentBlock);
    }
    function isInTextBlock(node, options) {
      if (isBlock(node)) {
        return false;
      }
      var virtualParent = getBlockParent(node);
      var parentText = '';
      var widgetText = '';
      var inBrBlock = 0;
      walkDomNode(virtualParent, function(currNode) {
        if (inBrBlock === 2) {
          return false;
        }
        if (currNode.nodeType === 3) {
          parentText += currNode.nodeValue;
        }
        if (currNode.nodeType !== 1) {
          return;
        }
        var nodeName2 = (currNode.nodeName || '').toUpperCase();
        if (currNode === node) {
          inBrBlock = 1;
        }
        if ([ 'BR', 'HR' ].includes(nodeName2)) {
          if (inBrBlock === 0) {
            parentText = '';
            widgetText = '';
          } else {
            inBrBlock = 2;
          }
        } else if (currNode.style.display === 'none' || currNode.style.overflow === 'hidden' || ![ '', null, 'none' ].includes(currNode.style['float']) || ![ '', null, 'relative' ].includes(currNode.style.position)) {
          return false;
        } else if (get_role_type_default(currNode) === 'widget') {
          widgetText += currNode.textContent;
          return false;
        }
      });
      parentText = sanitize_default(parentText);
      if (options !== null && options !== void 0 && options.noLengthCompare) {
        return parentText.length !== 0;
      }
      widgetText = sanitize_default(widgetText);
      return parentText.length > widgetText.length;
    }
    var is_in_text_block_default = isInTextBlock;
    function isModalOpen(options) {
      options = options || {};
      var modalPercent = options.modalPercent || .75;
      if (cache_default.get('isModalOpen')) {
        return cache_default.get('isModalOpen');
      }
      var definiteModals = query_selector_all_filter_default(axe._tree[0], 'dialog, [role=dialog], [aria-modal=true]', _isVisibleOnScreen);
      if (definiteModals.length) {
        cache_default.set('isModalOpen', true);
        return true;
      }
      var viewport = get_viewport_size_default(window);
      var percentWidth = viewport.width * modalPercent;
      var percentHeight = viewport.height * modalPercent;
      var x = (viewport.width - percentWidth) / 2;
      var y = (viewport.height - percentHeight) / 2;
      var points = [ {
        x: x,
        y: y
      }, {
        x: viewport.width - x,
        y: y
      }, {
        x: viewport.width / 2,
        y: viewport.height / 2
      }, {
        x: x,
        y: viewport.height - y
      }, {
        x: viewport.width - x,
        y: viewport.height - y
      } ];
      var stacks = points.map(function(point) {
        return Array.from(document.elementsFromPoint(point.x, point.y));
      });
      var _loop4 = function _loop4(_i10) {
        var modalElement = stacks[_i10].find(function(elm) {
          var style = window.getComputedStyle(elm);
          return parseInt(style.width, 10) >= percentWidth && parseInt(style.height, 10) >= percentHeight && style.getPropertyValue('pointer-events') !== 'none' && (style.position === 'absolute' || style.position === 'fixed');
        });
        if (modalElement && stacks.every(function(stack) {
          return stack.includes(modalElement);
        })) {
          cache_default.set('isModalOpen', true);
          return {
            v: true
          };
        }
      };
      for (var _i10 = 0; _i10 < stacks.length; _i10++) {
        var _ret = _loop4(_i10);
        if (_typeof(_ret) === 'object') {
          return _ret.v;
        }
      }
      cache_default.set('isModalOpen', void 0);
      return void 0;
    }
    var is_modal_open_default = isModalOpen;
    function _isMultiline(domNode) {
      var margin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
      var range2 = domNode.ownerDocument.createRange();
      range2.setStart(domNode, 0);
      range2.setEnd(domNode, domNode.childNodes.length);
      var lastLineEnd = 0;
      var lineCount = 0;
      var _iterator5 = _createForOfIteratorHelper(range2.getClientRects()), _step5;
      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done; ) {
          var rect = _step5.value;
          if (rect.height <= margin) {
            continue;
          }
          if (lastLineEnd > rect.top + margin) {
            lastLineEnd = Math.max(lastLineEnd, rect.bottom);
          } else if (lineCount === 0) {
            lastLineEnd = rect.bottom;
            lineCount++;
          } else {
            return true;
          }
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
      return false;
    }
    function isNode(element) {
      return element instanceof window.Node;
    }
    var is_node_default = isNode;
    var cacheKey = 'color.incompleteData';
    var incompleteData = {
      set: function set(key, reason) {
        if (typeof key !== 'string') {
          throw new Error('Incomplete data: key must be a string');
        }
        var data = cache_default.get(cacheKey, function() {
          return {};
        });
        if (reason) {
          data[key] = reason;
        }
        return data[key];
      },
      get: function get(key) {
        var data = cache_default.get(cacheKey);
        return data === null || data === void 0 ? void 0 : data[key];
      },
      clear: function clear() {
        cache_default.set(cacheKey, {});
      }
    };
    var incomplete_data_default = incompleteData;
    function elementHasImage(elm, style) {
      var graphicNodes = [ 'IMG', 'CANVAS', 'OBJECT', 'IFRAME', 'VIDEO', 'SVG' ];
      var nodeName2 = elm.nodeName.toUpperCase();
      if (graphicNodes.includes(nodeName2)) {
        incomplete_data_default.set('bgColor', 'imgNode');
        return true;
      }
      style = style || window.getComputedStyle(elm);
      var bgImageStyle = style.getPropertyValue('background-image');
      var hasBgImage = bgImageStyle !== 'none';
      if (hasBgImage) {
        var hasGradient = /gradient/.test(bgImageStyle);
        incomplete_data_default.set('bgColor', hasGradient ? 'bgGradient' : 'bgImage');
      }
      return hasBgImage;
    }
    var element_has_image_default = elementHasImage;
    var imports_exports = {};
    __export(imports_exports, {
      Colorjs: function Colorjs() {
        return Color;
      },
      CssSelectorParser: function CssSelectorParser() {
        return import_css_selector_parser2.CssSelectorParser;
      },
      doT: function doT() {
        return import_dot['default'];
      },
      emojiRegexText: function emojiRegexText() {
        return emoji_regex_default;
      },
      memoize: function memoize() {
        return import_memoizee2['default'];
      }
    });
    var import_css_selector_parser2 = __toModule(require_lib());
    var import_dot = __toModule(require_doT());
    var import_memoizee2 = __toModule(require_memoizee());
    function multiplyMatrices(A, B) {
      var m3 = A.length;
      if (!Array.isArray(A[0])) {
        A = [ A ];
      }
      if (!Array.isArray(B[0])) {
        B = B.map(function(x) {
          return [ x ];
        });
      }
      var p2 = B[0].length;
      var B_cols = B[0].map(function(_, i) {
        return B.map(function(x) {
          return x[i];
        });
      });
      var product = A.map(function(row) {
        return B_cols.map(function(col) {
          var ret = 0;
          if (!Array.isArray(row)) {
            var _iterator6 = _createForOfIteratorHelper(col), _step6;
            try {
              for (_iterator6.s(); !(_step6 = _iterator6.n()).done; ) {
                var c4 = _step6.value;
                ret += row * c4;
              }
            } catch (err) {
              _iterator6.e(err);
            } finally {
              _iterator6.f();
            }
            return ret;
          }
          for (var _i11 = 0; _i11 < row.length; _i11++) {
            ret += row[_i11] * (col[_i11] || 0);
          }
          return ret;
        });
      });
      if (m3 === 1) {
        product = product[0];
      }
      if (p2 === 1) {
        return product.map(function(x) {
          return x[0];
        });
      }
      return product;
    }
    function isString(str) {
      return type(str) === 'string';
    }
    function type(o) {
      var str = Object.prototype.toString.call(o);
      return (str.match(/^\[object\s+(.*?)\]$/)[1] || '').toLowerCase();
    }
    function toPrecision(n2, precision) {
      n2 = +n2;
      precision = +precision;
      var integerLength = (Math.floor(n2) + '').length;
      if (precision > integerLength) {
        return +n2.toFixed(precision - integerLength);
      } else {
        var p10 = Math.pow(10, integerLength - precision);
        return Math.round(n2 / p10) * p10;
      }
    }
    function parseFunction(str) {
      if (!str) {
        return;
      }
      str = str.trim();
      var isFunctionRegex = /^([a-z]+)\((.+?)\)$/i;
      var isNumberRegex = /^-?[\d.]+$/;
      var parts = str.match(isFunctionRegex);
      if (parts) {
        var args = [];
        parts[2].replace(/\/?\s*([-\w.]+(?:%|deg)?)/g, function($0, arg) {
          if (/%$/.test(arg)) {
            arg = new Number(arg.slice(0, -1) / 100);
            arg.type = '<percentage>';
          } else if (/deg$/.test(arg)) {
            arg = new Number(+arg.slice(0, -3));
            arg.type = '<angle>';
            arg.unit = 'deg';
          } else if (isNumberRegex.test(arg)) {
            arg = new Number(arg);
            arg.type = '<number>';
          }
          if ($0.startsWith('/')) {
            arg = arg instanceof Number ? arg : new Number(arg);
            arg.alpha = true;
          }
          args.push(arg);
        });
        return {
          name: parts[1].toLowerCase(),
          rawName: parts[1],
          rawArgs: parts[2],
          args: args
        };
      }
    }
    function last(arr) {
      return arr[arr.length - 1];
    }
    function interpolate(start, end, p2) {
      if (isNaN(start)) {
        return end;
      }
      if (isNaN(end)) {
        return start;
      }
      return start + (end - start) * p2;
    }
    function interpolateInv(start, end, value) {
      return (value - start) / (end - start);
    }
    function mapRange(from, to2, value) {
      return interpolate(to2[0], to2[1], interpolateInv(from[0], from[1], value));
    }
    function parseCoordGrammar(coordGrammars) {
      return coordGrammars.map(function(coordGrammar2) {
        return coordGrammar2.split('|').map(function(type2) {
          type2 = type2.trim();
          var range2 = type2.match(/^(<[a-z]+>)\[(-?[.\d]+),\s*(-?[.\d]+)\]?$/);
          if (range2) {
            var ret = new String(range2[1]);
            ret.range = [ +range2[2], +range2[3] ];
            return ret;
          }
          return type2;
        });
      });
    }
    var util = Object.freeze({
      __proto__: null,
      isString: isString,
      type: type,
      toPrecision: toPrecision,
      parseFunction: parseFunction,
      last: last,
      interpolate: interpolate,
      interpolateInv: interpolateInv,
      mapRange: mapRange,
      parseCoordGrammar: parseCoordGrammar,
      multiplyMatrices: multiplyMatrices
    });
    var Hooks = function() {
      function Hooks() {
        _classCallCheck(this, Hooks);
      }
      _createClass(Hooks, [ {
        key: 'add',
        value: function add(name, callback, first) {
          if (typeof arguments[0] != 'string') {
            for (var name in arguments[0]) {
              this.add(name, arguments[0][name], arguments[1]);
            }
            return;
          }
          (Array.isArray(name) ? name : [ name ]).forEach(function(name2) {
            this[name2] = this[name2] || [];
            if (callback) {
              this[name2][first ? 'unshift' : 'push'](callback);
            }
          }, this);
        }
      }, {
        key: 'run',
        value: function run(name, env) {
          this[name] = this[name] || [];
          this[name].forEach(function(callback) {
            callback.call(env && env.context ? env.context : env, env);
          });
        }
      } ]);
      return Hooks;
    }();
    var hooks = new Hooks();
    var defaults = {
      gamut_mapping: 'lch.c',
      precision: 5,
      deltaE: '76'
    };
    var WHITES = {
      D50: [ .3457 / .3585, 1, (1 - .3457 - .3585) / .3585 ],
      D65: [ .3127 / .329, 1, (1 - .3127 - .329) / .329 ]
    };
    function getWhite(name) {
      if (Array.isArray(name)) {
        return name;
      }
      return WHITES[name];
    }
    function adapt$1(W1, W2, XYZ) {
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      W1 = getWhite(W1);
      W2 = getWhite(W2);
      if (!W1 || !W2) {
        throw new TypeError('Missing white point to convert '.concat(!W1 ? 'from' : '').concat(!W1 && !W2 ? '/' : '').concat(!W2 ? 'to' : ''));
      }
      if (W1 === W2) {
        return XYZ;
      }
      var env = {
        W1: W1,
        W2: W2,
        XYZ: XYZ,
        options: options
      };
      hooks.run('chromatic-adaptation-start', env);
      if (!env.M) {
        if (env.W1 === WHITES.D65 && env.W2 === WHITES.D50) {
          env.M = [ [ 1.0479298208405488, .022946793341019088, -.05019222954313557 ], [ .029627815688159344, .990434484573249, -.01707382502938514 ], [ -.009243058152591178, .015055144896577895, .7518742899580008 ] ];
        } else if (env.W1 === WHITES.D50 && env.W2 === WHITES.D65) {
          env.M = [ [ .9554734527042182, -.023098536874261423, .0632593086610217 ], [ -.028369706963208136, 1.0099954580058226, .021041398966943008 ], [ .012314001688319899, -.020507696433477912, 1.3303659366080753 ] ];
        }
      }
      hooks.run('chromatic-adaptation-end', env);
      if (env.M) {
        return multiplyMatrices(env.M, env.XYZ);
      } else {
        throw new TypeError('Only Bradford CAT with white points D50 and D65 supported for now.');
      }
    }
    var \u03b5$4 = 75e-6;
    var _ColorSpace = (_processFormat = new WeakSet(), _path = new WeakMap(), _getPath = new WeakSet(), 
    function() {
      function _ColorSpace(options) {
        var _options$coords, _ref39, _options$white, _options$formats, _this$formats$functio, _this$formats, _this$formats2;
        _classCallCheck(this, _ColorSpace);
        _classPrivateMethodInitSpec(this, _getPath);
        _classPrivateMethodInitSpec(this, _processFormat);
        _classPrivateFieldInitSpec(this, _path, {
          writable: true,
          value: void 0
        });
        this.id = options.id;
        this.name = options.name;
        this.base = options.base ? _ColorSpace.get(options.base) : null;
        this.aliases = options.aliases;
        if (this.base) {
          this.fromBase = options.fromBase;
          this.toBase = options.toBase;
        }
        var _coords = (_options$coords = options.coords) !== null && _options$coords !== void 0 ? _options$coords : this.base.coords;
        this.coords = _coords;
        var white2 = (_ref39 = (_options$white = options.white) !== null && _options$white !== void 0 ? _options$white : this.base.white) !== null && _ref39 !== void 0 ? _ref39 : 'D65';
        this.white = getWhite(white2);
        this.formats = (_options$formats = options.formats) !== null && _options$formats !== void 0 ? _options$formats : {};
        for (var name in this.formats) {
          var format = this.formats[name];
          format.type || (format.type = 'function');
          format.name || (format.name = name);
        }
        if (options.cssId && !((_this$formats$functio = this.formats.functions) !== null && _this$formats$functio !== void 0 && _this$formats$functio.color)) {
          this.formats.color = {
            id: options.cssId
          };
          Object.defineProperty(this, 'cssId', {
            value: options.cssId
          });
        } else if ((_this$formats = this.formats) !== null && _this$formats !== void 0 && _this$formats.color && !((_this$formats2 = this.formats) !== null && _this$formats2 !== void 0 && _this$formats2.color.id)) {
          this.formats.color.id = this.id;
        }
        this.referred = options.referred;
        _classPrivateFieldSet(this, _path, _classPrivateMethodGet(this, _getPath, _getPath2).call(this).reverse());
        hooks.run('colorspace-init-end', this);
      }
      _createClass(_ColorSpace, [ {
        key: 'inGamut',
        value: function inGamut(coords) {
          var _ref40 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref40$epsilon = _ref40.epsilon, epsilon = _ref40$epsilon === void 0 ? \u03b5$4 : _ref40$epsilon;
          if (this.isPolar) {
            coords = this.toBase(coords);
            return this.base.inGamut(coords, {
              epsilon: epsilon
            });
          }
          var coordMeta = Object.values(this.coords);
          return coords.every(function(c4, i) {
            var meta = coordMeta[i];
            if (meta.type !== 'angle' && meta.range) {
              if (Number.isNaN(c4)) {
                return true;
              }
              var _meta$range = _slicedToArray(meta.range, 2), min = _meta$range[0], max2 = _meta$range[1];
              return (min === void 0 || c4 >= min - epsilon) && (max2 === void 0 || c4 <= max2 + epsilon);
            }
            return true;
          });
        }
      }, {
        key: 'cssId',
        get: function get() {
          var _this$formats$functio2, _this$formats$functio3;
          return ((_this$formats$functio2 = this.formats.functions) === null || _this$formats$functio2 === void 0 ? void 0 : (_this$formats$functio3 = _this$formats$functio2.color) === null || _this$formats$functio3 === void 0 ? void 0 : _this$formats$functio3.id) || this.id;
        }
      }, {
        key: 'isPolar',
        get: function get() {
          for (var id in this.coords) {
            if (this.coords[id].type === 'angle') {
              return true;
            }
          }
          return false;
        }
      }, {
        key: 'getFormat',
        value: function getFormat(format) {
          if (_typeof(format) === 'object') {
            format = _classPrivateMethodGet(this, _processFormat, _processFormat2).call(this, format);
            return format;
          }
          var ret;
          if (format === 'default') {
            ret = Object.values(this.formats)[0];
          } else {
            ret = this.formats[format];
          }
          if (ret) {
            ret = _classPrivateMethodGet(this, _processFormat, _processFormat2).call(this, ret);
            return ret;
          }
          return null;
        }
      }, {
        key: 'to',
        value: function to(space, coords) {
          if (arguments.length === 1) {
            var _ref41 = [ space.space, space.coords ];
            space = _ref41[0];
            coords = _ref41[1];
          }
          space = _ColorSpace.get(space);
          if (this === space) {
            return coords;
          }
          coords = coords.map(function(c4) {
            return Number.isNaN(c4) ? 0 : c4;
          });
          var myPath = _classPrivateFieldGet(this, _path);
          var otherPath = _classPrivateFieldGet(space, _path);
          var connectionSpace, connectionSpaceIndex;
          for (var _i12 = 0; _i12 < myPath.length; _i12++) {
            if (myPath[_i12] === otherPath[_i12]) {
              connectionSpace = myPath[_i12];
              connectionSpaceIndex = _i12;
            } else {
              break;
            }
          }
          if (!connectionSpace) {
            throw new Error('Cannot convert between color spaces '.concat(this, ' and ').concat(space, ': no connection space was found'));
          }
          for (var _i13 = myPath.length - 1; _i13 > connectionSpaceIndex; _i13--) {
            coords = myPath[_i13].toBase(coords);
          }
          for (var _i14 = connectionSpaceIndex + 1; _i14 < otherPath.length; _i14++) {
            coords = otherPath[_i14].fromBase(coords);
          }
          return coords;
        }
      }, {
        key: 'from',
        value: function from(space, coords) {
          if (arguments.length === 1) {
            var _ref42 = [ space.space, space.coords ];
            space = _ref42[0];
            coords = _ref42[1];
          }
          space = _ColorSpace.get(space);
          return space.to(this, coords);
        }
      }, {
        key: 'toString',
        value: function toString() {
          return ''.concat(this.name, ' (').concat(this.id, ')');
        }
      }, {
        key: 'getMinCoords',
        value: function getMinCoords() {
          var ret = [];
          for (var id in this.coords) {
            var _range2$min;
            var meta = this.coords[id];
            var range2 = meta.range || meta.refRange;
            ret.push((_range2$min = range2 === null || range2 === void 0 ? void 0 : range2.min) !== null && _range2$min !== void 0 ? _range2$min : 0);
          }
          return ret;
        }
      } ], [ {
        key: 'all',
        get: function get() {
          return _toConsumableArray(new Set(Object.values(_ColorSpace.registry)));
        }
      }, {
        key: 'register',
        value: function register(id, space) {
          if (arguments.length === 1) {
            space = arguments[0];
            id = space.id;
          }
          space = this.get(space);
          if (this.registry[id] && this.registry[id] !== space) {
            throw new Error('Duplicate color space registration: \''.concat(id, '\''));
          }
          this.registry[id] = space;
          if (arguments.length === 1 && space.aliases) {
            var _iterator7 = _createForOfIteratorHelper(space.aliases), _step7;
            try {
              for (_iterator7.s(); !(_step7 = _iterator7.n()).done; ) {
                var alias = _step7.value;
                this.register(alias, space);
              }
            } catch (err) {
              _iterator7.e(err);
            } finally {
              _iterator7.f();
            }
          }
          return space;
        }
      }, {
        key: 'get',
        value: function get(space) {
          if (!space || space instanceof _ColorSpace) {
            return space;
          }
          var argType = type(space);
          if (argType === 'string') {
            var ret = _ColorSpace.registry[space.toLowerCase()];
            if (!ret) {
              throw new TypeError('No color space found with id = "'.concat(space, '"'));
            }
            return ret;
          }
          for (var _len2 = arguments.length, alternatives = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
            alternatives[_key2 - 1] = arguments[_key2];
          }
          if (alternatives.length) {
            return _ColorSpace.get.apply(_ColorSpace, alternatives);
          }
          throw new TypeError(''.concat(space, ' is not a valid color space'));
        }
      }, {
        key: 'resolveCoord',
        value: function resolveCoord(ref, workingSpace) {
          var coordType = type(ref);
          var space, coord;
          if (coordType === 'string') {
            if (ref.includes('.')) {
              var _ref$split = ref.split('.');
              var _ref$split2 = _slicedToArray(_ref$split, 2);
              space = _ref$split2[0];
              coord = _ref$split2[1];
            } else {
              space = void 0;
              coord = ref;
            }
          } else if (Array.isArray(ref)) {
            var _ref43 = _slicedToArray(ref, 2);
            space = _ref43[0];
            coord = _ref43[1];
          } else {
            space = ref.space;
            coord = ref.coordId;
          }
          space = _ColorSpace.get(space);
          if (!space) {
            space = workingSpace;
          }
          if (!space) {
            throw new TypeError('Cannot resolve coordinate reference '.concat(ref, ': No color space specified and relative references are not allowed here'));
          }
          coordType = type(coord);
          if (coordType === 'number' || coordType === 'string' && coord >= 0) {
            var meta = Object.entries(space.coords)[coord];
            if (meta) {
              return _extends({
                space: space,
                id: meta[0],
                index: coord
              }, meta[1]);
            }
          }
          space = _ColorSpace.get(space);
          var normalizedCoord = coord.toLowerCase();
          var i = 0;
          for (var id in space.coords) {
            var _meta$name;
            var _meta = space.coords[id];
            if (id.toLowerCase() === normalizedCoord || ((_meta$name = _meta.name) === null || _meta$name === void 0 ? void 0 : _meta$name.toLowerCase()) === normalizedCoord) {
              return _extends({
                space: space,
                id: id,
                index: i
              }, _meta);
            }
            i++;
          }
          throw new TypeError('No "'.concat(coord, '" coordinate found in ').concat(space.name, '. Its coordinates are: ').concat(Object.keys(space.coords).join(', ')));
        }
      } ]);
      return _ColorSpace;
    }());
    function _processFormat2(format) {
      if (format.coords && !format.coordGrammar) {
        format.type || (format.type = 'function');
        format.name || (format.name = 'color');
        format.coordGrammar = parseCoordGrammar(format.coords);
        var coordFormats = Object.entries(this.coords).map(function(_ref151, i) {
          var _ref152 = _slicedToArray(_ref151, 2), id = _ref152[0], coordMeta = _ref152[1];
          var outputType = format.coordGrammar[i][0];
          var fromRange = coordMeta.range || coordMeta.refRange;
          var toRange = outputType.range, suffix = '';
          if (outputType == '<percentage>') {
            toRange = [ 0, 100 ];
            suffix = '%';
          } else if (outputType == '<angle>') {
            suffix = 'deg';
          }
          return {
            fromRange: fromRange,
            toRange: toRange,
            suffix: suffix
          };
        });
        format.serializeCoords = function(coords, precision) {
          return coords.map(function(c4, i) {
            var _coordFormats$i = coordFormats[i], fromRange = _coordFormats$i.fromRange, toRange = _coordFormats$i.toRange, suffix = _coordFormats$i.suffix;
            if (fromRange && toRange) {
              c4 = mapRange(fromRange, toRange, c4);
            }
            c4 = toPrecision(c4, precision);
            if (suffix) {
              c4 += suffix;
            }
            return c4;
          });
        };
      }
      return format;
    }
    function _getPath2() {
      var ret = [ this ];
      for (var _space2 = this; _space2 = _space2.base; ) {
        ret.push(_space2);
      }
      return ret;
    }
    var ColorSpace = _ColorSpace;
    __publicField(ColorSpace, 'registry', {});
    __publicField(ColorSpace, 'DEFAULT_FORMAT', {
      type: 'functions',
      name: 'color'
    });
    var XYZ_D65 = new ColorSpace({
      id: 'xyz-d65',
      name: 'XYZ D65',
      coords: {
        x: {
          name: 'X'
        },
        y: {
          name: 'Y'
        },
        z: {
          name: 'Z'
        }
      },
      white: 'D65',
      formats: {
        color: {
          ids: [ 'xyz-d65', 'xyz' ]
        }
      },
      aliases: [ 'xyz' ]
    });
    var RGBColorSpace = function(_ColorSpace2) {
      _inherits(RGBColorSpace, _ColorSpace2);
      var _super = _createSuper(RGBColorSpace);
      function RGBColorSpace(options) {
        var _options$referred;
        var _this;
        _classCallCheck(this, RGBColorSpace);
        if (!options.coords) {
          options.coords = {
            r: {
              range: [ 0, 1 ],
              name: 'Red'
            },
            g: {
              range: [ 0, 1 ],
              name: 'Green'
            },
            b: {
              range: [ 0, 1 ],
              name: 'Blue'
            }
          };
        }
        if (!options.base) {
          options.base = XYZ_D65;
        }
        if (options.toXYZ_M && options.fromXYZ_M) {
          var _options$toBase, _options$fromBase;
          (_options$toBase = options.toBase) !== null && _options$toBase !== void 0 ? _options$toBase : options.toBase = function(rgb) {
            var xyz = multiplyMatrices(options.toXYZ_M, rgb);
            if (_this.white !== _this.base.white) {
              xyz = adapt$1(_this.white, _this.base.white, xyz);
            }
            return xyz;
          };
          (_options$fromBase = options.fromBase) !== null && _options$fromBase !== void 0 ? _options$fromBase : options.fromBase = function(xyz) {
            xyz = adapt$1(_this.base.white, _this.white, xyz);
            return multiplyMatrices(options.fromXYZ_M, xyz);
          };
        }
        (_options$referred = options.referred) !== null && _options$referred !== void 0 ? _options$referred : options.referred = 'display';
        return _this = _super.call(this, options);
      }
      return _createClass(RGBColorSpace);
    }(ColorSpace);
    function parse2(str) {
      var _String;
      var env = {
        str: (_String = String(str)) === null || _String === void 0 ? void 0 : _String.trim()
      };
      hooks.run('parse-start', env);
      if (env.color) {
        return env.color;
      }
      env.parsed = parseFunction(env.str);
      if (env.parsed) {
        var _ret2 = function() {
          var name = env.parsed.name;
          if (name === 'color') {
            var id = env.parsed.args.shift();
            var alpha = env.parsed.rawArgs.indexOf('/') > 0 ? env.parsed.args.pop() : 1;
            var _iterator8 = _createForOfIteratorHelper(ColorSpace.all), _step8;
            try {
              for (_iterator8.s(); !(_step8 = _iterator8.n()).done; ) {
                var space = _step8.value;
                var colorSpec = space.getFormat('color');
                if (colorSpec) {
                  var _colorSpec$ids;
                  if (id === colorSpec.id || (_colorSpec$ids = colorSpec.ids) !== null && _colorSpec$ids !== void 0 && _colorSpec$ids.includes(id)) {
                    var _ret3 = function() {
                      var argCount = Object.keys(space.coords).length;
                      var coords = Array(argCount).fill(0);
                      coords.forEach(function(_, i) {
                        return coords[i] = env.parsed.args[i] || 0;
                      });
                      return {
                        v: {
                          v: {
                            spaceId: space.id,
                            coords: coords,
                            alpha: alpha
                          }
                        }
                      };
                    }();
                    if (_typeof(_ret3) === 'object') {
                      return _ret3.v;
                    }
                  }
                }
              }
            } catch (err) {
              _iterator8.e(err);
            } finally {
              _iterator8.f();
            }
            var didYouMean = '';
            if (id in ColorSpace.registry) {
              var _ColorSpace$registry$, _ColorSpace$registry$2, _ColorSpace$registry$3;
              var cssId = (_ColorSpace$registry$ = ColorSpace.registry[id].formats) === null || _ColorSpace$registry$ === void 0 ? void 0 : (_ColorSpace$registry$2 = _ColorSpace$registry$.functions) === null || _ColorSpace$registry$2 === void 0 ? void 0 : (_ColorSpace$registry$3 = _ColorSpace$registry$2.color) === null || _ColorSpace$registry$3 === void 0 ? void 0 : _ColorSpace$registry$3.id;
              if (cssId) {
                didYouMean = 'Did you mean color('.concat(cssId, ')?');
              }
            }
            throw new TypeError('Cannot parse color('.concat(id, '). ') + (didYouMean || 'Missing a plugin?'));
          } else {
            var _iterator9 = _createForOfIteratorHelper(ColorSpace.all), _step9;
            try {
              var _loop5 = function _loop5() {
                var space = _step9.value;
                var format = space.getFormat(name);
                if (format && format.type === 'function') {
                  var _alpha = 1;
                  if (format.lastAlpha || last(env.parsed.args).alpha) {
                    _alpha = env.parsed.args.pop();
                  }
                  var coords = env.parsed.args;
                  if (format.coordGrammar) {
                    Object.entries(space.coords).forEach(function(_ref44, i) {
                      var _coords$i;
                      var _ref45 = _slicedToArray(_ref44, 2), id = _ref45[0], coordMeta = _ref45[1];
                      var coordGrammar2 = format.coordGrammar[i];
                      var providedType = (_coords$i = coords[i]) === null || _coords$i === void 0 ? void 0 : _coords$i.type;
                      coordGrammar2 = coordGrammar2.find(function(c4) {
                        return c4 == providedType;
                      });
                      if (!coordGrammar2) {
                        var coordName = coordMeta.name || id;
                        throw new TypeError(''.concat(providedType, ' not allowed for ').concat(coordName, ' in ').concat(name, '()'));
                      }
                      var fromRange = coordGrammar2.range;
                      if (providedType === '<percentage>') {
                        fromRange || (fromRange = [ 0, 1 ]);
                      }
                      var toRange = coordMeta.range || coordMeta.refRange;
                      if (fromRange && toRange) {
                        coords[i] = mapRange(fromRange, toRange, coords[i]);
                      }
                    });
                  }
                  return {
                    v: {
                      v: {
                        spaceId: space.id,
                        coords: coords,
                        alpha: _alpha
                      }
                    }
                  };
                }
              };
              for (_iterator9.s(); !(_step9 = _iterator9.n()).done; ) {
                var _ret4 = _loop5();
                if (_typeof(_ret4) === 'object') {
                  return _ret4.v;
                }
              }
            } catch (err) {
              _iterator9.e(err);
            } finally {
              _iterator9.f();
            }
          }
        }();
        if (_typeof(_ret2) === 'object') {
          return _ret2.v;
        }
      } else {
        var _iterator10 = _createForOfIteratorHelper(ColorSpace.all), _step10;
        try {
          for (_iterator10.s(); !(_step10 = _iterator10.n()).done; ) {
            var space = _step10.value;
            for (var formatId in space.formats) {
              var format = space.formats[formatId];
              if (format.type !== 'custom') {
                continue;
              }
              if (format.test && !format.test(env.str)) {
                continue;
              }
              var color = format.parse(env.str);
              if (color) {
                var _color$alpha;
                (_color$alpha = color.alpha) !== null && _color$alpha !== void 0 ? _color$alpha : color.alpha = 1;
                return color;
              }
            }
          }
        } catch (err) {
          _iterator10.e(err);
        } finally {
          _iterator10.f();
        }
      }
      throw new TypeError('Could not parse '.concat(str, ' as a color. Missing a plugin?'));
    }
    function getColor(color) {
      if (!color) {
        throw new TypeError('Empty color reference');
      }
      if (isString(color)) {
        color = parse2(color);
      }
      var space = color.space || color.spaceId;
      if (!(space instanceof ColorSpace)) {
        color.space = ColorSpace.get(space);
      }
      if (color.alpha === void 0) {
        color.alpha = 1;
      }
      return color;
    }
    function getAll(color, space) {
      space = ColorSpace.get(space);
      return space.from(color);
    }
    function get(color, prop) {
      var _ColorSpace$resolveCo = ColorSpace.resolveCoord(prop, color.space), space = _ColorSpace$resolveCo.space, index = _ColorSpace$resolveCo.index;
      var coords = getAll(color, space);
      return coords[index];
    }
    function setAll(color, space, coords) {
      space = ColorSpace.get(space);
      color.coords = space.to(color.space, coords);
      return color;
    }
    function set(color, prop, value) {
      color = getColor(color);
      if (arguments.length === 2 && type(arguments[1]) === 'object') {
        var object = arguments[1];
        for (var p2 in object) {
          set(color, p2, object[p2]);
        }
      } else {
        if (typeof value === 'function') {
          value = value(get(color, prop));
        }
        var _ColorSpace$resolveCo2 = ColorSpace.resolveCoord(prop, color.space), space = _ColorSpace$resolveCo2.space, index = _ColorSpace$resolveCo2.index;
        var coords = getAll(color, space);
        coords[index] = value;
        setAll(color, space, coords);
      }
      return color;
    }
    var XYZ_D50 = new ColorSpace({
      id: 'xyz-d50',
      name: 'XYZ D50',
      white: 'D50',
      base: XYZ_D65,
      fromBase: function fromBase(coords) {
        return adapt$1(XYZ_D65.white, 'D50', coords);
      },
      toBase: function toBase(coords) {
        return adapt$1('D50', XYZ_D65.white, coords);
      },
      formats: {
        color: {}
      }
    });
    var \u03b5$3 = 216 / 24389;
    var \u03b53$1 = 24 / 116;
    var \u03ba$1 = 24389 / 27;
    var white$1 = WHITES.D50;
    var lab = new ColorSpace({
      id: 'lab',
      name: 'Lab',
      coords: {
        l: {
          refRange: [ 0, 100 ],
          name: 'L'
        },
        a: {
          refRange: [ -125, 125 ]
        },
        b: {
          refRange: [ -125, 125 ]
        }
      },
      white: white$1,
      base: XYZ_D50,
      fromBase: function fromBase(XYZ) {
        var xyz = XYZ.map(function(value, i) {
          return value / white$1[i];
        });
        var f = xyz.map(function(value) {
          return value > \u03b5$3 ? Math.cbrt(value) : (\u03ba$1 * value + 16) / 116;
        });
        return [ 116 * f[1] - 16, 500 * (f[0] - f[1]), 200 * (f[1] - f[2]) ];
      },
      toBase: function toBase(Lab) {
        var f = [];
        f[1] = (Lab[0] + 16) / 116;
        f[0] = Lab[1] / 500 + f[1];
        f[2] = f[1] - Lab[2] / 200;
        var xyz = [ f[0] > \u03b53$1 ? Math.pow(f[0], 3) : (116 * f[0] - 16) / \u03ba$1, Lab[0] > 8 ? Math.pow((Lab[0] + 16) / 116, 3) : Lab[0] / \u03ba$1, f[2] > \u03b53$1 ? Math.pow(f[2], 3) : (116 * f[2] - 16) / \u03ba$1 ];
        return xyz.map(function(value, i) {
          return value * white$1[i];
        });
      },
      formats: {
        lab: {
          coords: [ '<number> | <percentage>', '<number>', '<number>' ]
        }
      }
    });
    function constrain(angle) {
      return (angle % 360 + 360) % 360;
    }
    function adjust(arc, angles) {
      if (arc === 'raw') {
        return angles;
      }
      var _angles$map = angles.map(constrain), _angles$map2 = _slicedToArray(_angles$map, 2), a1 = _angles$map2[0], a2 = _angles$map2[1];
      var angleDiff = a2 - a1;
      if (arc === 'increasing') {
        if (angleDiff < 0) {
          a2 += 360;
        }
      } else if (arc === 'decreasing') {
        if (angleDiff > 0) {
          a1 += 360;
        }
      } else if (arc === 'longer') {
        if (-180 < angleDiff && angleDiff < 180) {
          if (angleDiff > 0) {
            a2 += 360;
          } else {
            a1 += 360;
          }
        }
      } else if (arc === 'shorter') {
        if (angleDiff > 180) {
          a1 += 360;
        } else if (angleDiff < -180) {
          a2 += 360;
        }
      }
      return [ a1, a2 ];
    }
    var lch = new ColorSpace({
      id: 'lch',
      name: 'LCH',
      coords: {
        l: {
          refRange: [ 0, 100 ],
          name: 'Lightness'
        },
        c: {
          refRange: [ 0, 150 ],
          name: 'Chroma'
        },
        h: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        }
      },
      base: lab,
      fromBase: function fromBase(Lab) {
        var _Lab = _slicedToArray(Lab, 3), L = _Lab[0], a2 = _Lab[1], b2 = _Lab[2];
        var hue;
        var \u03b52 = .02;
        if (Math.abs(a2) < \u03b52 && Math.abs(b2) < \u03b52) {
          hue = NaN;
        } else {
          hue = Math.atan2(b2, a2) * 180 / Math.PI;
        }
        return [ L, Math.sqrt(Math.pow(a2, 2) + Math.pow(b2, 2)), constrain(hue) ];
      },
      toBase: function toBase(LCH) {
        var _LCH = _slicedToArray(LCH, 3), Lightness = _LCH[0], Chroma = _LCH[1], Hue = _LCH[2];
        if (Chroma < 0) {
          Chroma = 0;
        }
        if (isNaN(Hue)) {
          Hue = 0;
        }
        return [ Lightness, Chroma * Math.cos(Hue * Math.PI / 180), Chroma * Math.sin(Hue * Math.PI / 180) ];
      },
      formats: {
        lch: {
          coords: [ '<number> | <percentage>', '<number>', '<number> | <angle>' ]
        }
      }
    });
    var Gfactor = Math.pow(25, 7);
    var \u03c0$1 = Math.PI;
    var r2d = 180 / \u03c0$1;
    var d2r$1 = \u03c0$1 / 180;
    function deltaE2000(color, sample) {
      var _ref46 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {}, _ref46$kL = _ref46.kL, kL = _ref46$kL === void 0 ? 1 : _ref46$kL, _ref46$kC = _ref46.kC, kC = _ref46$kC === void 0 ? 1 : _ref46$kC, _ref46$kH = _ref46.kH, kH = _ref46$kH === void 0 ? 1 : _ref46$kH;
      var _lab$from = lab.from(color), _lab$from2 = _slicedToArray(_lab$from, 3), L1 = _lab$from2[0], a1 = _lab$from2[1], b1 = _lab$from2[2];
      var C1 = lch.from(lab, [ L1, a1, b1 ])[1];
      var _lab$from3 = lab.from(sample), _lab$from4 = _slicedToArray(_lab$from3, 3), L2 = _lab$from4[0], a2 = _lab$from4[1], b2 = _lab$from4[2];
      var C2 = lch.from(lab, [ L2, a2, b2 ])[1];
      if (C1 < 0) {
        C1 = 0;
      }
      if (C2 < 0) {
        C2 = 0;
      }
      var Cbar = (C1 + C2) / 2;
      var C7 = Math.pow(Cbar, 7);
      var G = .5 * (1 - Math.sqrt(C7 / (C7 + Gfactor)));
      var adash1 = (1 + G) * a1;
      var adash2 = (1 + G) * a2;
      var Cdash1 = Math.sqrt(Math.pow(adash1, 2) + Math.pow(b1, 2));
      var Cdash2 = Math.sqrt(Math.pow(adash2, 2) + Math.pow(b2, 2));
      var h1 = adash1 === 0 && b1 === 0 ? 0 : Math.atan2(b1, adash1);
      var h2 = adash2 === 0 && b2 === 0 ? 0 : Math.atan2(b2, adash2);
      if (h1 < 0) {
        h1 += 2 * \u03c0$1;
      }
      if (h2 < 0) {
        h2 += 2 * \u03c0$1;
      }
      h1 *= r2d;
      h2 *= r2d;
      var \u0394L = L2 - L1;
      var \u0394C = Cdash2 - Cdash1;
      var hdiff = h2 - h1;
      var hsum = h1 + h2;
      var habs = Math.abs(hdiff);
      var \u0394h;
      if (Cdash1 * Cdash2 === 0) {
        \u0394h = 0;
      } else if (habs <= 180) {
        \u0394h = hdiff;
      } else if (hdiff > 180) {
        \u0394h = hdiff - 360;
      } else if (hdiff < -180) {
        \u0394h = hdiff + 360;
      } else {
        console.log('the unthinkable has happened');
      }
      var \u0394H = 2 * Math.sqrt(Cdash2 * Cdash1) * Math.sin(\u0394h * d2r$1 / 2);
      var Ldash = (L1 + L2) / 2;
      var Cdash = (Cdash1 + Cdash2) / 2;
      var Cdash7 = Math.pow(Cdash, 7);
      var hdash;
      if (Cdash1 * Cdash2 === 0) {
        hdash = hsum;
      } else if (habs <= 180) {
        hdash = hsum / 2;
      } else if (hsum < 360) {
        hdash = (hsum + 360) / 2;
      } else {
        hdash = (hsum - 360) / 2;
      }
      var lsq = Math.pow(Ldash - 50, 2);
      var SL = 1 + .015 * lsq / Math.sqrt(20 + lsq);
      var SC = 1 + .045 * Cdash;
      var T = 1;
      T -= .17 * Math.cos((hdash - 30) * d2r$1);
      T += .24 * Math.cos(2 * hdash * d2r$1);
      T += .32 * Math.cos((3 * hdash + 6) * d2r$1);
      T -= .2 * Math.cos((4 * hdash - 63) * d2r$1);
      var SH = 1 + .015 * Cdash * T;
      var \u0394\u03b8 = 30 * Math.exp(-1 * Math.pow((hdash - 275) / 25, 2));
      var RC = 2 * Math.sqrt(Cdash7 / (Cdash7 + Gfactor));
      var RT = -1 * Math.sin(2 * \u0394\u03b8 * d2r$1) * RC;
      var dE = Math.pow(\u0394L / (kL * SL), 2);
      dE += Math.pow(\u0394C / (kC * SC), 2);
      dE += Math.pow(\u0394H / (kH * SH), 2);
      dE += RT * (\u0394C / (kC * SC)) * (\u0394H / (kH * SH));
      return Math.sqrt(dE);
    }
    var \u03b5$2 = 75e-6;
    function inGamut(color) {
      var space = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : color.space;
      var _ref47 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {}, _ref47$epsilon = _ref47.epsilon, epsilon = _ref47$epsilon === void 0 ? \u03b5$2 : _ref47$epsilon;
      color = getColor(color);
      space = ColorSpace.get(space);
      var coords = color.coords;
      if (space !== color.space) {
        coords = space.from(color);
      }
      return space.inGamut(coords, {
        epsilon: epsilon
      });
    }
    function clone2(color) {
      return {
        space: color.space,
        coords: color.coords.slice(),
        alpha: color.alpha
      };
    }
    function toGamut(color) {
      var _ref48 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref48$method = _ref48.method, method = _ref48$method === void 0 ? defaults.gamut_mapping : _ref48$method, _ref48$space = _ref48.space, space = _ref48$space === void 0 ? color.space : _ref48$space;
      if (isString(arguments[1])) {
        space = arguments[1];
      }
      space = ColorSpace.get(space);
      if (inGamut(color, space, {
        epsilon: 0
      })) {
        return color;
      }
      var spaceColor = to(color, space);
      if (method !== 'clip' && !inGamut(color, space)) {
        var clipped = toGamut(clone2(spaceColor), {
          method: 'clip',
          space: space
        });
        if (deltaE2000(color, clipped) > 2) {
          var coordMeta = ColorSpace.resolveCoord(method);
          var mapSpace = coordMeta.space;
          var coordId = coordMeta.id;
          var mappedColor = to(spaceColor, mapSpace);
          var bounds = coordMeta.range || coordMeta.refRange;
          var min = bounds[0];
          var \u03b52 = .01;
          var low = min;
          var high = get(mappedColor, coordId);
          while (high - low > \u03b52) {
            var clipped2 = clone2(mappedColor);
            clipped2 = toGamut(clipped2, {
              space: space,
              method: 'clip'
            });
            var deltaE2 = deltaE2000(mappedColor, clipped2);
            if (deltaE2 - 2 < \u03b52) {
              low = get(mappedColor, coordId);
            } else {
              high = get(mappedColor, coordId);
            }
            set(mappedColor, coordId, (low + high) / 2);
          }
          spaceColor = to(mappedColor, space);
        } else {
          spaceColor = clipped;
        }
      }
      if (method === 'clip' || !inGamut(spaceColor, space, {
        epsilon: 0
      })) {
        var _bounds = Object.values(space.coords).map(function(c4) {
          return c4.range || [];
        });
        spaceColor.coords = spaceColor.coords.map(function(c4, i) {
          var _bounds$i = _slicedToArray(_bounds[i], 2), min = _bounds$i[0], max2 = _bounds$i[1];
          if (min !== void 0) {
            c4 = Math.max(min, c4);
          }
          if (max2 !== void 0) {
            c4 = Math.min(c4, max2);
          }
          return c4;
        });
      }
      if (space !== color.space) {
        spaceColor = to(spaceColor, color.space);
      }
      color.coords = spaceColor.coords;
      return color;
    }
    toGamut.returns = 'color';
    function to(color, space) {
      var _ref49 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {}, inGamut2 = _ref49.inGamut;
      color = getColor(color);
      space = ColorSpace.get(space);
      var coords = space.from(color);
      var ret = {
        space: space,
        coords: coords,
        alpha: color.alpha
      };
      if (inGamut2) {
        ret = toGamut(ret);
      }
      return ret;
    }
    to.returns = 'color';
    function serialize(color) {
      var _ref51, _color$space$getForma;
      var _ref50 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _ref50$precision = _ref50.precision, precision = _ref50$precision === void 0 ? defaults.precision : _ref50$precision, _ref50$format = _ref50.format, format = _ref50$format === void 0 ? 'default' : _ref50$format, _ref50$inGamut = _ref50.inGamut, inGamut$1 = _ref50$inGamut === void 0 ? true : _ref50$inGamut, customOptions = _objectWithoutProperties(_ref50, _excluded9);
      var ret;
      color = getColor(color);
      var formatId = format;
      format = (_ref51 = (_color$space$getForma = color.space.getFormat(format)) !== null && _color$space$getForma !== void 0 ? _color$space$getForma : color.space.getFormat('default')) !== null && _ref51 !== void 0 ? _ref51 : ColorSpace.DEFAULT_FORMAT;
      inGamut$1 || (inGamut$1 = format.toGamut);
      var coords = color.coords;
      coords = coords.map(function(c4) {
        return c4 ? c4 : 0;
      });
      if (inGamut$1 && !inGamut(color)) {
        coords = toGamut(clone2(color), inGamut$1 === true ? void 0 : inGamut$1).coords;
      }
      if (format.type === 'custom') {
        customOptions.precision = precision;
        if (format.serialize) {
          ret = format.serialize(coords, color.alpha, customOptions);
        } else {
          throw new TypeError('format '.concat(formatId, ' can only be used to parse colors, not for serialization'));
        }
      } else {
        var name = format.name || 'color';
        if (format.serializeCoords) {
          coords = format.serializeCoords(coords, precision);
        } else {
          if (precision !== null) {
            coords = coords.map(function(c4) {
              return toPrecision(c4, precision);
            });
          }
        }
        var args = _toConsumableArray(coords);
        if (name === 'color') {
          var _format$ids;
          var cssId = format.id || ((_format$ids = format.ids) === null || _format$ids === void 0 ? void 0 : _format$ids[0]) || color.space.id;
          args.unshift(cssId);
        }
        var alpha = color.alpha;
        if (precision !== null) {
          alpha = toPrecision(alpha, precision);
        }
        var strAlpha = color.alpha < 1 && !format.noAlpha ? ''.concat(format.commas ? ',' : ' /', ' ').concat(alpha) : '';
        ret = ''.concat(name, '(').concat(args.join(format.commas ? ', ' : ' ')).concat(strAlpha, ')');
      }
      return ret;
    }
    var toXYZ_M$5 = [ [ .6369580483012914, .14461690358620832, .1688809751641721 ], [ .2627002120112671, .6779980715188708, .05930171646986196 ], [ 0, .028072693049087428, 1.060985057710791 ] ];
    var fromXYZ_M$5 = [ [ 1.716651187971268, -.355670783776392, -.25336628137366 ], [ -.666684351832489, 1.616481236634939, .0157685458139111 ], [ .017639857445311, -.042770613257809, .942103121235474 ] ];
    var REC2020Linear = new RGBColorSpace({
      id: 'rec2020-linear',
      name: 'Linear REC.2020',
      white: 'D65',
      toXYZ_M: toXYZ_M$5,
      fromXYZ_M: fromXYZ_M$5,
      formats: {
        color: {}
      }
    });
    var \u03b1 = 1.09929682680944;
    var \u03b2 = .018053968510807;
    var REC2020 = new RGBColorSpace({
      id: 'rec2020',
      name: 'REC.2020',
      base: REC2020Linear,
      toBase: function toBase(RGB) {
        return RGB.map(function(val) {
          if (val < \u03b2 * 4.5) {
            return val / 4.5;
          }
          return Math.pow((val + \u03b1 - 1) / \u03b1, 1 / .45);
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(val) {
          if (val >= \u03b2) {
            return \u03b1 * Math.pow(val, .45) - (\u03b1 - 1);
          }
          return 4.5 * val;
        });
      },
      formats: {
        color: {}
      }
    });
    var toXYZ_M$4 = [ [ .4865709486482162, .26566769316909306, .1982172852343625 ], [ .2289745640697488, .6917385218365064, .079286914093745 ], [ 0, .04511338185890264, 1.043944368900976 ] ];
    var fromXYZ_M$4 = [ [ 2.493496911941425, -.9313836179191239, -.40271078445071684 ], [ -.8294889695615747, 1.7626640603183463, .023624685841943577 ], [ .03584583024378447, -.07617238926804182, .9568845240076872 ] ];
    var P3Linear = new RGBColorSpace({
      id: 'p3-linear',
      name: 'Linear P3',
      white: 'D65',
      toXYZ_M: toXYZ_M$4,
      fromXYZ_M: fromXYZ_M$4
    });
    var toXYZ_M$3 = [ [ .41239079926595934, .357584339383878, .1804807884018343 ], [ .21263900587151027, .715168678767756, .07219231536073371 ], [ .01933081871559182, .11919477979462598, .9505321522496607 ] ];
    var fromXYZ_M$3 = [ [ 3.2409699419045226, -1.537383177570094, -.4986107602930034 ], [ -.9692436362808796, 1.8759675015077202, .04155505740717559 ], [ .05563007969699366, -.20397695888897652, 1.0569715142428786 ] ];
    var sRGBLinear = new RGBColorSpace({
      id: 'srgb-linear',
      name: 'Linear sRGB',
      white: 'D65',
      toXYZ_M: toXYZ_M$3,
      fromXYZ_M: fromXYZ_M$3,
      formats: {
        color: {}
      }
    });
    var KEYWORDS = {
      aliceblue: [ 240 / 255, 248 / 255, 1 ],
      antiquewhite: [ 250 / 255, 235 / 255, 215 / 255 ],
      aqua: [ 0, 1, 1 ],
      aquamarine: [ 127 / 255, 1, 212 / 255 ],
      azure: [ 240 / 255, 1, 1 ],
      beige: [ 245 / 255, 245 / 255, 220 / 255 ],
      bisque: [ 1, 228 / 255, 196 / 255 ],
      black: [ 0, 0, 0 ],
      blanchedalmond: [ 1, 235 / 255, 205 / 255 ],
      blue: [ 0, 0, 1 ],
      blueviolet: [ 138 / 255, 43 / 255, 226 / 255 ],
      brown: [ 165 / 255, 42 / 255, 42 / 255 ],
      burlywood: [ 222 / 255, 184 / 255, 135 / 255 ],
      cadetblue: [ 95 / 255, 158 / 255, 160 / 255 ],
      chartreuse: [ 127 / 255, 1, 0 ],
      chocolate: [ 210 / 255, 105 / 255, 30 / 255 ],
      coral: [ 1, 127 / 255, 80 / 255 ],
      cornflowerblue: [ 100 / 255, 149 / 255, 237 / 255 ],
      cornsilk: [ 1, 248 / 255, 220 / 255 ],
      crimson: [ 220 / 255, 20 / 255, 60 / 255 ],
      cyan: [ 0, 1, 1 ],
      darkblue: [ 0, 0, 139 / 255 ],
      darkcyan: [ 0, 139 / 255, 139 / 255 ],
      darkgoldenrod: [ 184 / 255, 134 / 255, 11 / 255 ],
      darkgray: [ 169 / 255, 169 / 255, 169 / 255 ],
      darkgreen: [ 0, 100 / 255, 0 ],
      darkgrey: [ 169 / 255, 169 / 255, 169 / 255 ],
      darkkhaki: [ 189 / 255, 183 / 255, 107 / 255 ],
      darkmagenta: [ 139 / 255, 0, 139 / 255 ],
      darkolivegreen: [ 85 / 255, 107 / 255, 47 / 255 ],
      darkorange: [ 1, 140 / 255, 0 ],
      darkorchid: [ 153 / 255, 50 / 255, 204 / 255 ],
      darkred: [ 139 / 255, 0, 0 ],
      darksalmon: [ 233 / 255, 150 / 255, 122 / 255 ],
      darkseagreen: [ 143 / 255, 188 / 255, 143 / 255 ],
      darkslateblue: [ 72 / 255, 61 / 255, 139 / 255 ],
      darkslategray: [ 47 / 255, 79 / 255, 79 / 255 ],
      darkslategrey: [ 47 / 255, 79 / 255, 79 / 255 ],
      darkturquoise: [ 0, 206 / 255, 209 / 255 ],
      darkviolet: [ 148 / 255, 0, 211 / 255 ],
      deeppink: [ 1, 20 / 255, 147 / 255 ],
      deepskyblue: [ 0, 191 / 255, 1 ],
      dimgray: [ 105 / 255, 105 / 255, 105 / 255 ],
      dimgrey: [ 105 / 255, 105 / 255, 105 / 255 ],
      dodgerblue: [ 30 / 255, 144 / 255, 1 ],
      firebrick: [ 178 / 255, 34 / 255, 34 / 255 ],
      floralwhite: [ 1, 250 / 255, 240 / 255 ],
      forestgreen: [ 34 / 255, 139 / 255, 34 / 255 ],
      fuchsia: [ 1, 0, 1 ],
      gainsboro: [ 220 / 255, 220 / 255, 220 / 255 ],
      ghostwhite: [ 248 / 255, 248 / 255, 1 ],
      gold: [ 1, 215 / 255, 0 ],
      goldenrod: [ 218 / 255, 165 / 255, 32 / 255 ],
      gray: [ 128 / 255, 128 / 255, 128 / 255 ],
      green: [ 0, 128 / 255, 0 ],
      greenyellow: [ 173 / 255, 1, 47 / 255 ],
      grey: [ 128 / 255, 128 / 255, 128 / 255 ],
      honeydew: [ 240 / 255, 1, 240 / 255 ],
      hotpink: [ 1, 105 / 255, 180 / 255 ],
      indianred: [ 205 / 255, 92 / 255, 92 / 255 ],
      indigo: [ 75 / 255, 0, 130 / 255 ],
      ivory: [ 1, 1, 240 / 255 ],
      khaki: [ 240 / 255, 230 / 255, 140 / 255 ],
      lavender: [ 230 / 255, 230 / 255, 250 / 255 ],
      lavenderblush: [ 1, 240 / 255, 245 / 255 ],
      lawngreen: [ 124 / 255, 252 / 255, 0 ],
      lemonchiffon: [ 1, 250 / 255, 205 / 255 ],
      lightblue: [ 173 / 255, 216 / 255, 230 / 255 ],
      lightcoral: [ 240 / 255, 128 / 255, 128 / 255 ],
      lightcyan: [ 224 / 255, 1, 1 ],
      lightgoldenrodyellow: [ 250 / 255, 250 / 255, 210 / 255 ],
      lightgray: [ 211 / 255, 211 / 255, 211 / 255 ],
      lightgreen: [ 144 / 255, 238 / 255, 144 / 255 ],
      lightgrey: [ 211 / 255, 211 / 255, 211 / 255 ],
      lightpink: [ 1, 182 / 255, 193 / 255 ],
      lightsalmon: [ 1, 160 / 255, 122 / 255 ],
      lightseagreen: [ 32 / 255, 178 / 255, 170 / 255 ],
      lightskyblue: [ 135 / 255, 206 / 255, 250 / 255 ],
      lightslategray: [ 119 / 255, 136 / 255, 153 / 255 ],
      lightslategrey: [ 119 / 255, 136 / 255, 153 / 255 ],
      lightsteelblue: [ 176 / 255, 196 / 255, 222 / 255 ],
      lightyellow: [ 1, 1, 224 / 255 ],
      lime: [ 0, 1, 0 ],
      limegreen: [ 50 / 255, 205 / 255, 50 / 255 ],
      linen: [ 250 / 255, 240 / 255, 230 / 255 ],
      magenta: [ 1, 0, 1 ],
      maroon: [ 128 / 255, 0, 0 ],
      mediumaquamarine: [ 102 / 255, 205 / 255, 170 / 255 ],
      mediumblue: [ 0, 0, 205 / 255 ],
      mediumorchid: [ 186 / 255, 85 / 255, 211 / 255 ],
      mediumpurple: [ 147 / 255, 112 / 255, 219 / 255 ],
      mediumseagreen: [ 60 / 255, 179 / 255, 113 / 255 ],
      mediumslateblue: [ 123 / 255, 104 / 255, 238 / 255 ],
      mediumspringgreen: [ 0, 250 / 255, 154 / 255 ],
      mediumturquoise: [ 72 / 255, 209 / 255, 204 / 255 ],
      mediumvioletred: [ 199 / 255, 21 / 255, 133 / 255 ],
      midnightblue: [ 25 / 255, 25 / 255, 112 / 255 ],
      mintcream: [ 245 / 255, 1, 250 / 255 ],
      mistyrose: [ 1, 228 / 255, 225 / 255 ],
      moccasin: [ 1, 228 / 255, 181 / 255 ],
      navajowhite: [ 1, 222 / 255, 173 / 255 ],
      navy: [ 0, 0, 128 / 255 ],
      oldlace: [ 253 / 255, 245 / 255, 230 / 255 ],
      olive: [ 128 / 255, 128 / 255, 0 ],
      olivedrab: [ 107 / 255, 142 / 255, 35 / 255 ],
      orange: [ 1, 165 / 255, 0 ],
      orangered: [ 1, 69 / 255, 0 ],
      orchid: [ 218 / 255, 112 / 255, 214 / 255 ],
      palegoldenrod: [ 238 / 255, 232 / 255, 170 / 255 ],
      palegreen: [ 152 / 255, 251 / 255, 152 / 255 ],
      paleturquoise: [ 175 / 255, 238 / 255, 238 / 255 ],
      palevioletred: [ 219 / 255, 112 / 255, 147 / 255 ],
      papayawhip: [ 1, 239 / 255, 213 / 255 ],
      peachpuff: [ 1, 218 / 255, 185 / 255 ],
      peru: [ 205 / 255, 133 / 255, 63 / 255 ],
      pink: [ 1, 192 / 255, 203 / 255 ],
      plum: [ 221 / 255, 160 / 255, 221 / 255 ],
      powderblue: [ 176 / 255, 224 / 255, 230 / 255 ],
      purple: [ 128 / 255, 0, 128 / 255 ],
      rebeccapurple: [ 102 / 255, 51 / 255, 153 / 255 ],
      red: [ 1, 0, 0 ],
      rosybrown: [ 188 / 255, 143 / 255, 143 / 255 ],
      royalblue: [ 65 / 255, 105 / 255, 225 / 255 ],
      saddlebrown: [ 139 / 255, 69 / 255, 19 / 255 ],
      salmon: [ 250 / 255, 128 / 255, 114 / 255 ],
      sandybrown: [ 244 / 255, 164 / 255, 96 / 255 ],
      seagreen: [ 46 / 255, 139 / 255, 87 / 255 ],
      seashell: [ 1, 245 / 255, 238 / 255 ],
      sienna: [ 160 / 255, 82 / 255, 45 / 255 ],
      silver: [ 192 / 255, 192 / 255, 192 / 255 ],
      skyblue: [ 135 / 255, 206 / 255, 235 / 255 ],
      slateblue: [ 106 / 255, 90 / 255, 205 / 255 ],
      slategray: [ 112 / 255, 128 / 255, 144 / 255 ],
      slategrey: [ 112 / 255, 128 / 255, 144 / 255 ],
      snow: [ 1, 250 / 255, 250 / 255 ],
      springgreen: [ 0, 1, 127 / 255 ],
      steelblue: [ 70 / 255, 130 / 255, 180 / 255 ],
      tan: [ 210 / 255, 180 / 255, 140 / 255 ],
      teal: [ 0, 128 / 255, 128 / 255 ],
      thistle: [ 216 / 255, 191 / 255, 216 / 255 ],
      tomato: [ 1, 99 / 255, 71 / 255 ],
      turquoise: [ 64 / 255, 224 / 255, 208 / 255 ],
      violet: [ 238 / 255, 130 / 255, 238 / 255 ],
      wheat: [ 245 / 255, 222 / 255, 179 / 255 ],
      white: [ 1, 1, 1 ],
      whitesmoke: [ 245 / 255, 245 / 255, 245 / 255 ],
      yellow: [ 1, 1, 0 ],
      yellowgreen: [ 154 / 255, 205 / 255, 50 / 255 ]
    };
    var coordGrammar = Array(3).fill('<percentage> | <number>[0, 255]');
    var coordGrammarNumber = Array(3).fill('<number>[0, 255]');
    var sRGB = new RGBColorSpace({
      id: 'srgb',
      name: 'sRGB',
      base: sRGBLinear,
      fromBase: function fromBase(rgb) {
        return rgb.map(function(val) {
          var sign = val < 0 ? -1 : 1;
          var abs = val * sign;
          if (abs > .0031308) {
            return sign * (1.055 * Math.pow(abs, 1 / 2.4) - .055);
          }
          return 12.92 * val;
        });
      },
      toBase: function toBase(rgb) {
        return rgb.map(function(val) {
          var sign = val < 0 ? -1 : 1;
          var abs = val * sign;
          if (abs < .04045) {
            return val / 12.92;
          }
          return sign * Math.pow((abs + .055) / 1.055, 2.4);
        });
      },
      formats: {
        rgb: {
          coords: coordGrammar
        },
        rgb_number: {
          name: 'rgb',
          commas: true,
          coords: coordGrammarNumber,
          noAlpha: true
        },
        color: {},
        rgba: {
          coords: coordGrammar,
          commas: true,
          lastAlpha: true
        },
        rgba_number: {
          name: 'rgba',
          commas: true,
          coords: coordGrammarNumber
        },
        hex: {
          type: 'custom',
          toGamut: true,
          test: function test(str) {
            return /^#([a-f0-9]{3,4}){1,2}$/i.test(str);
          },
          parse: function parse(str) {
            if (str.length <= 5) {
              str = str.replace(/[a-f0-9]/gi, '$&$&');
            }
            var rgba = [];
            str.replace(/[a-f0-9]{2}/gi, function(component) {
              rgba.push(parseInt(component, 16) / 255);
            });
            return {
              spaceId: 'srgb',
              coords: rgba.slice(0, 3),
              alpha: rgba.slice(3)[0]
            };
          },
          serialize: function serialize(coords, alpha) {
            var _ref52 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {}, _ref52$collapse = _ref52.collapse, collapse = _ref52$collapse === void 0 ? true : _ref52$collapse;
            if (alpha < 1) {
              coords.push(alpha);
            }
            coords = coords.map(function(c4) {
              return Math.round(c4 * 255);
            });
            var collapsible = collapse && coords.every(function(c4) {
              return c4 % 17 === 0;
            });
            var hex = coords.map(function(c4) {
              if (collapsible) {
                return (c4 / 17).toString(16);
              }
              return c4.toString(16).padStart(2, '0');
            }).join('');
            return '#' + hex;
          }
        },
        keyword: {
          type: 'custom',
          test: function test(str) {
            return /^[a-z]+$/i.test(str);
          },
          parse: function parse(str) {
            str = str.toLowerCase();
            var ret = {
              spaceId: 'srgb',
              coords: null,
              alpha: 1
            };
            if (str === 'transparent') {
              ret.coords = KEYWORDS.black;
              ret.alpha = 0;
            } else {
              ret.coords = KEYWORDS[str];
            }
            if (ret.coords) {
              return ret;
            }
          }
        }
      }
    });
    var P3 = new RGBColorSpace({
      id: 'p3',
      name: 'P3',
      base: P3Linear,
      fromBase: sRGB.fromBase,
      toBase: sRGB.toBase,
      formats: {
        color: {
          id: 'display-p3'
        }
      }
    });
    defaults.display_space = sRGB;
    if (typeof CSS !== 'undefined' && CSS.supports) {
      for (var _i15 = 0, _arr3 = [ lab, REC2020, P3 ]; _i15 < _arr3.length; _i15++) {
        var space = _arr3[_i15];
        var coords = space.getMinCoords();
        var color = {
          space: space,
          coords: coords,
          alpha: 1
        };
        var str = serialize(color);
        if (CSS.supports('color', str)) {
          defaults.display_space = space;
          break;
        }
      }
    }
    function _display(color) {
      var _ref53 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var _ref53$space = _ref53.space, space = _ref53$space === void 0 ? defaults.display_space : _ref53$space, options = _objectWithoutProperties(_ref53, _excluded10);
      var ret = serialize(color, options);
      if (typeof CSS === 'undefined' || CSS.supports('color', ret) || !defaults.display_space) {
        ret = new String(ret);
        ret.color = color;
      } else {
        var fallbackColor = to(color, space);
        ret = new String(serialize(fallbackColor, options));
        ret.color = fallbackColor;
      }
      return ret;
    }
    function distance(color1, color2) {
      var space = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'lab';
      space = ColorSpace.get(space);
      var coords1 = space.from(color1);
      var coords2 = space.from(color2);
      return Math.sqrt(coords1.reduce(function(acc, c12, i) {
        var c22 = coords2[i];
        if (isNaN(c12) || isNaN(c22)) {
          return acc;
        }
        return acc + Math.pow(c22 - c12, 2);
      }, 0));
    }
    function equals(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      return color1.space === color2.space && color1.alpha === color2.alpha && color1.coords.every(function(c4, i) {
        return c4 === color2.coords[i];
      });
    }
    function getLuminance(color) {
      return get(color, [ XYZ_D65, 'y' ]);
    }
    function setLuminance(color, value) {
      set(color, [ XYZ_D65, 'y' ], value);
    }
    function register$2(Color3) {
      Object.defineProperty(Color3.prototype, 'luminance', {
        get: function get() {
          return getLuminance(this);
        },
        set: function set(value) {
          setLuminance(this, value);
        }
      });
    }
    var luminance = Object.freeze({
      __proto__: null,
      getLuminance: getLuminance,
      setLuminance: setLuminance,
      register: register$2
    });
    function contrastWCAG21(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      var Y1 = Math.max(getLuminance(color1), 0);
      var Y2 = Math.max(getLuminance(color2), 0);
      if (Y2 > Y1) {
        var _ref54 = [ Y2, Y1 ];
        Y1 = _ref54[0];
        Y2 = _ref54[1];
      }
      return (Y1 + .05) / (Y2 + .05);
    }
    var normBG = .56;
    var normTXT = .57;
    var revTXT = .62;
    var revBG = .65;
    var blkThrs = .022;
    var blkClmp = 1.414;
    var loClip = .1;
    var deltaYmin = 5e-4;
    var scaleBoW = 1.14;
    var loBoWoffset = .027;
    var scaleWoB = 1.14;
    function fclamp(Y) {
      if (Y >= blkThrs) {
        return Y;
      }
      return Y + Math.pow(blkThrs - Y, blkClmp);
    }
    function linearize(val) {
      var sign = val < 0 ? -1 : 1;
      var abs = Math.abs(val);
      return sign * Math.pow(abs, 2.4);
    }
    function contrastAPCA(background, foreground) {
      foreground = getColor(foreground);
      background = getColor(background);
      var S;
      var C;
      var Sapc;
      var R, G, B;
      foreground = to(foreground, 'srgb');
      var _foreground$coords = _slicedToArray(foreground.coords, 3);
      R = _foreground$coords[0];
      G = _foreground$coords[1];
      B = _foreground$coords[2];
      var lumTxt = linearize(R) * .2126729 + linearize(G) * .7151522 + linearize(B) * .072175;
      background = to(background, 'srgb');
      var _background$coords = _slicedToArray(background.coords, 3);
      R = _background$coords[0];
      G = _background$coords[1];
      B = _background$coords[2];
      var lumBg = linearize(R) * .2126729 + linearize(G) * .7151522 + linearize(B) * .072175;
      var Ytxt = fclamp(lumTxt);
      var Ybg = fclamp(lumBg);
      var BoW = Ybg > Ytxt;
      if (Math.abs(Ybg - Ytxt) < deltaYmin) {
        C = 0;
      } else {
        if (BoW) {
          S = Math.pow(Ybg, normBG) - Math.pow(Ytxt, normTXT);
          C = S * scaleBoW;
        } else {
          S = Math.pow(Ybg, revBG) - Math.pow(Ytxt, revTXT);
          C = S * scaleWoB;
        }
      }
      if (Math.abs(C) < loClip) {
        Sapc = 0;
      } else if (C > 0) {
        Sapc = C - loBoWoffset;
      } else {
        Sapc = C + loBoWoffset;
      }
      return Sapc * 100;
    }
    function contrastMichelson(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      var Y1 = Math.max(getLuminance(color1), 0);
      var Y2 = Math.max(getLuminance(color2), 0);
      if (Y2 > Y1) {
        var _ref55 = [ Y2, Y1 ];
        Y1 = _ref55[0];
        Y2 = _ref55[1];
      }
      var denom = Y1 + Y2;
      return denom === 0 ? 0 : (Y1 - Y2) / denom;
    }
    var max = 5e4;
    function contrastWeber(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      var Y1 = Math.max(getLuminance(color1), 0);
      var Y2 = Math.max(getLuminance(color2), 0);
      if (Y2 > Y1) {
        var _ref56 = [ Y2, Y1 ];
        Y1 = _ref56[0];
        Y2 = _ref56[1];
      }
      return Y2 === 0 ? max : (Y1 - Y2) / Y2;
    }
    function contrastLstar(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      var L1 = get(color1, [ lab, 'l' ]);
      var L2 = get(color2, [ lab, 'l' ]);
      return Math.abs(L1 - L2);
    }
    var \u03b5$1 = 216 / 24389;
    var \u03b53 = 24 / 116;
    var \u03ba = 24389 / 27;
    var white = WHITES.D65;
    var lab_d65 = new ColorSpace({
      id: 'lab-d65',
      name: 'Lab D65',
      coords: {
        l: {
          refRange: [ 0, 100 ],
          name: 'L'
        },
        a: {
          refRange: [ -125, 125 ]
        },
        b: {
          refRange: [ -125, 125 ]
        }
      },
      white: white,
      base: XYZ_D65,
      fromBase: function fromBase(XYZ) {
        var xyz = XYZ.map(function(value, i) {
          return value / white[i];
        });
        var f = xyz.map(function(value) {
          return value > \u03b5$1 ? Math.cbrt(value) : (\u03ba * value + 16) / 116;
        });
        return [ 116 * f[1] - 16, 500 * (f[0] - f[1]), 200 * (f[1] - f[2]) ];
      },
      toBase: function toBase(Lab) {
        var f = [];
        f[1] = (Lab[0] + 16) / 116;
        f[0] = Lab[1] / 500 + f[1];
        f[2] = f[1] - Lab[2] / 200;
        var xyz = [ f[0] > \u03b53 ? Math.pow(f[0], 3) : (116 * f[0] - 16) / \u03ba, Lab[0] > 8 ? Math.pow((Lab[0] + 16) / 116, 3) : Lab[0] / \u03ba, f[2] > \u03b53 ? Math.pow(f[2], 3) : (116 * f[2] - 16) / \u03ba ];
        return xyz.map(function(value, i) {
          return value * white[i];
        });
      },
      formats: {
        'lab-d65': {
          coords: [ '<number> | <percentage>', '<number>', '<number>' ]
        }
      }
    });
    var phi = Math.pow(5, .5) * .5 + .5;
    function contrastDeltaPhi(color1, color2) {
      color1 = getColor(color1);
      color2 = getColor(color2);
      var Lstr1 = get(color1, [ lab_d65, 'l' ]);
      var Lstr2 = get(color2, [ lab_d65, 'l' ]);
      var deltaPhiStar = Math.abs(Math.pow(Lstr1, phi) - Math.pow(Lstr2, phi));
      var contrast2 = Math.pow(deltaPhiStar, 1 / phi) * Math.SQRT2 - 40;
      return contrast2 < 7.5 ? 0 : contrast2;
    }
    var contrastMethods = Object.freeze({
      __proto__: null,
      contrastWCAG21: contrastWCAG21,
      contrastAPCA: contrastAPCA,
      contrastMichelson: contrastMichelson,
      contrastWeber: contrastWeber,
      contrastLstar: contrastLstar,
      contrastDeltaPhi: contrastDeltaPhi
    });
    function contrast(background, foreground) {
      var o = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (isString(o)) {
        o = {
          algorithm: o
        };
      }
      var _o = o, algorithm = _o.algorithm, rest = _objectWithoutProperties(_o, _excluded11);
      if (!algorithm) {
        var algorithms = Object.keys(contrastMethods).map(function(a2) {
          return a2.replace(/^contrast/, '');
        }).join(', ');
        throw new TypeError('contrast() function needs a contrast algorithm. Please specify one of: '.concat(algorithms));
      }
      background = getColor(background);
      foreground = getColor(foreground);
      for (var a2 in contrastMethods) {
        if ('contrast' + algorithm.toLowerCase() === a2.toLowerCase()) {
          return contrastMethods[a2](background, foreground, rest);
        }
      }
      throw new TypeError('Unknown contrast algorithm: '.concat(algorithm));
    }
    function uv(color) {
      var _getAll = getAll(color, XYZ_D65), _getAll2 = _slicedToArray(_getAll, 3), X = _getAll2[0], Y = _getAll2[1], Z = _getAll2[2];
      var denom = X + 15 * Y + 3 * Z;
      return [ 4 * X / denom, 9 * Y / denom ];
    }
    function xy(color) {
      var _getAll3 = getAll(color, XYZ_D65), _getAll4 = _slicedToArray(_getAll3, 3), X = _getAll4[0], Y = _getAll4[1], Z = _getAll4[2];
      var sum = X + Y + Z;
      return [ X / sum, Y / sum ];
    }
    function register$1(Color3) {
      Object.defineProperty(Color3.prototype, 'uv', {
        get: function get() {
          return uv(this);
        }
      });
      Object.defineProperty(Color3.prototype, 'xy', {
        get: function get() {
          return xy(this);
        }
      });
    }
    var chromaticity = Object.freeze({
      __proto__: null,
      uv: uv,
      xy: xy,
      register: register$1
    });
    function deltaE76(color, sample) {
      return distance(color, sample, 'lab');
    }
    var \u03c0 = Math.PI;
    var d2r = \u03c0 / 180;
    function deltaECMC(color, sample) {
      var _ref57 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {}, _ref57$l = _ref57.l, l = _ref57$l === void 0 ? 2 : _ref57$l, _ref57$c = _ref57.c, c4 = _ref57$c === void 0 ? 1 : _ref57$c;
      var _lab$from5 = lab.from(color), _lab$from6 = _slicedToArray(_lab$from5, 3), L1 = _lab$from6[0], a1 = _lab$from6[1], b1 = _lab$from6[2];
      var _lch$from = lch.from(lab, [ L1, a1, b1 ]), _lch$from2 = _slicedToArray(_lch$from, 3), C1 = _lch$from2[1], H1 = _lch$from2[2];
      var _lab$from7 = lab.from(sample), _lab$from8 = _slicedToArray(_lab$from7, 3), L2 = _lab$from8[0], a2 = _lab$from8[1], b2 = _lab$from8[2];
      var C2 = lch.from(lab, [ L2, a2, b2 ])[1];
      if (C1 < 0) {
        C1 = 0;
      }
      if (C2 < 0) {
        C2 = 0;
      }
      var \u0394L = L1 - L2;
      var \u0394C = C1 - C2;
      var \u0394a = a1 - a2;
      var \u0394b = b1 - b2;
      var H2 = Math.pow(\u0394a, 2) + Math.pow(\u0394b, 2) - Math.pow(\u0394C, 2);
      var SL = .511;
      if (L1 >= 16) {
        SL = .040975 * L1 / (1 + .01765 * L1);
      }
      var SC = .0638 * C1 / (1 + .0131 * C1) + .638;
      var T;
      if (Number.isNaN(H1)) {
        H1 = 0;
      }
      if (H1 >= 164 && H1 <= 345) {
        T = .56 + Math.abs(.2 * Math.cos((H1 + 168) * d2r));
      } else {
        T = .36 + Math.abs(.4 * Math.cos((H1 + 35) * d2r));
      }
      var C4 = Math.pow(C1, 4);
      var F = Math.sqrt(C4 / (C4 + 1900));
      var SH = SC * (F * T + 1 - F);
      var dE = Math.pow(\u0394L / (l * SL), 2);
      dE += Math.pow(\u0394C / (c4 * SC), 2);
      dE += H2 / Math.pow(SH, 2);
      return Math.sqrt(dE);
    }
    var Yw$1 = 203;
    var XYZ_Abs_D65 = new ColorSpace({
      id: 'xyz-abs-d65',
      name: 'Absolute XYZ D65',
      coords: {
        x: {
          refRange: [ 0, 9504.7 ],
          name: 'Xa'
        },
        y: {
          refRange: [ 0, 1e4 ],
          name: 'Ya'
        },
        z: {
          refRange: [ 0, 10888.3 ],
          name: 'Za'
        }
      },
      base: XYZ_D65,
      fromBase: function fromBase(XYZ) {
        return XYZ.map(function(v) {
          return Math.max(v * Yw$1, 0);
        });
      },
      toBase: function toBase(AbsXYZ) {
        return AbsXYZ.map(function(v) {
          return Math.max(v / Yw$1, 0);
        });
      }
    });
    var b$1 = 1.15;
    var g = .66;
    var n$1 = 2610 / Math.pow(2, 14);
    var ninv$1 = Math.pow(2, 14) / 2610;
    var c1$2 = 3424 / Math.pow(2, 12);
    var c2$2 = 2413 / Math.pow(2, 7);
    var c3$2 = 2392 / Math.pow(2, 7);
    var p = 1.7 * 2523 / Math.pow(2, 5);
    var pinv = Math.pow(2, 5) / (1.7 * 2523);
    var d = -.56;
    var d0 = 16295499532821565e-27;
    var XYZtoCone_M = [ [ .41478972, .579999, .014648 ], [ -.20151, 1.120649, .0531008 ], [ -.0166008, .2648, .6684799 ] ];
    var ConetoXYZ_M = [ [ 1.9242264357876067, -1.0047923125953657, .037651404030618 ], [ .35031676209499907, .7264811939316552, -.06538442294808501 ], [ -.09098281098284752, -.3127282905230739, 1.5227665613052603 ] ];
    var ConetoIab_M = [ [ .5, .5, 0 ], [ 3.524, -4.066708, .542708 ], [ .199076, 1.096799, -1.295875 ] ];
    var IabtoCone_M = [ [ 1, .1386050432715393, .05804731615611886 ], [ .9999999999999999, -.1386050432715393, -.05804731615611886 ], [ .9999999999999998, -.09601924202631895, -.8118918960560388 ] ];
    var Jzazbz = new ColorSpace({
      id: 'jzazbz',
      name: 'Jzazbz',
      coords: {
        jz: {
          refRange: [ 0, 1 ],
          name: 'Jz'
        },
        az: {
          refRange: [ -.5, .5 ]
        },
        bz: {
          refRange: [ -.5, .5 ]
        }
      },
      base: XYZ_Abs_D65,
      fromBase: function fromBase(XYZ) {
        var _XYZ = _slicedToArray(XYZ, 3), Xa = _XYZ[0], Ya = _XYZ[1], Za = _XYZ[2];
        var Xm = b$1 * Xa - (b$1 - 1) * Za;
        var Ym = g * Ya - (g - 1) * Xa;
        var LMS = multiplyMatrices(XYZtoCone_M, [ Xm, Ym, Za ]);
        var PQLMS = LMS.map(function(val) {
          var num = c1$2 + c2$2 * Math.pow(val / 1e4, n$1);
          var denom = 1 + c3$2 * Math.pow(val / 1e4, n$1);
          return Math.pow(num / denom, p);
        });
        var _multiplyMatrices = multiplyMatrices(ConetoIab_M, PQLMS), _multiplyMatrices2 = _slicedToArray(_multiplyMatrices, 3), Iz = _multiplyMatrices2[0], az = _multiplyMatrices2[1], bz = _multiplyMatrices2[2];
        var Jz = (1 + d) * Iz / (1 + d * Iz) - d0;
        return [ Jz, az, bz ];
      },
      toBase: function toBase(Jzazbz2) {
        var _Jzazbz = _slicedToArray(Jzazbz2, 3), Jz = _Jzazbz[0], az = _Jzazbz[1], bz = _Jzazbz[2];
        var Iz = (Jz + d0) / (1 + d - d * (Jz + d0));
        var PQLMS = multiplyMatrices(IabtoCone_M, [ Iz, az, bz ]);
        var LMS = PQLMS.map(function(val) {
          var num = c1$2 - Math.pow(val, pinv);
          var denom = c3$2 * Math.pow(val, pinv) - c2$2;
          var x = 1e4 * Math.pow(num / denom, ninv$1);
          return x;
        });
        var _multiplyMatrices3 = multiplyMatrices(ConetoXYZ_M, LMS), _multiplyMatrices4 = _slicedToArray(_multiplyMatrices3, 3), Xm = _multiplyMatrices4[0], Ym = _multiplyMatrices4[1], Za = _multiplyMatrices4[2];
        var Xa = (Xm + (b$1 - 1) * Za) / b$1;
        var Ya = (Ym + (g - 1) * Xa) / g;
        return [ Xa, Ya, Za ];
      },
      formats: {
        color: {}
      }
    });
    var jzczhz = new ColorSpace({
      id: 'jzczhz',
      name: 'JzCzHz',
      coords: {
        jz: {
          refRange: [ 0, 1 ],
          name: 'Jz'
        },
        cz: {
          refRange: [ 0, 1 ],
          name: 'Chroma'
        },
        hz: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        }
      },
      base: Jzazbz,
      fromBase: function fromBase(jzazbz) {
        var _jzazbz = _slicedToArray(jzazbz, 3), Jz = _jzazbz[0], az = _jzazbz[1], bz = _jzazbz[2];
        var hue;
        var \u03b52 = 2e-4;
        if (Math.abs(az) < \u03b52 && Math.abs(bz) < \u03b52) {
          hue = NaN;
        } else {
          hue = Math.atan2(bz, az) * 180 / Math.PI;
        }
        return [ Jz, Math.sqrt(Math.pow(az, 2) + Math.pow(bz, 2)), constrain(hue) ];
      },
      toBase: function toBase(jzczhz2) {
        return [ jzczhz2[0], jzczhz2[1] * Math.cos(jzczhz2[2] * Math.PI / 180), jzczhz2[1] * Math.sin(jzczhz2[2] * Math.PI / 180) ];
      },
      formats: {
        color: {}
      }
    });
    function deltaEJz(color, sample) {
      var _jzczhz$from = jzczhz.from(color), _jzczhz$from2 = _slicedToArray(_jzczhz$from, 3), Jz1 = _jzczhz$from2[0], Cz1 = _jzczhz$from2[1], Hz1 = _jzczhz$from2[2];
      var _jzczhz$from3 = jzczhz.from(sample), _jzczhz$from4 = _slicedToArray(_jzczhz$from3, 3), Jz2 = _jzczhz$from4[0], Cz2 = _jzczhz$from4[1], Hz2 = _jzczhz$from4[2];
      var \u0394J = Jz1 - Jz2;
      var \u0394C = Cz1 - Cz2;
      if (Number.isNaN(Hz1) && Number.isNaN(Hz2)) {
        Hz1 = 0;
        Hz2 = 0;
      } else if (Number.isNaN(Hz1)) {
        Hz1 = Hz2;
      } else if (Number.isNaN(Hz2)) {
        Hz2 = Hz1;
      }
      var \u0394h = Hz1 - Hz2;
      var \u0394H = 2 * Math.sqrt(Cz1 * Cz2) * Math.sin(\u0394h / 2 * (Math.PI / 180));
      return Math.sqrt(Math.pow(\u0394J, 2) + Math.pow(\u0394C, 2) + Math.pow(\u0394H, 2));
    }
    var c1$1 = 3424 / 4096;
    var c2$1 = 2413 / 128;
    var c3$1 = 2392 / 128;
    var m1 = 2610 / 16384;
    var m2 = 2523 / 32;
    var im1 = 16384 / 2610;
    var im2 = 32 / 2523;
    var XYZtoLMS_M$1 = [ [ .3592, .6976, -.0358 ], [ -.1922, 1.1004, .0755 ], [ .007, .0749, .8434 ] ];
    var LMStoIPT_M = [ [ 2048 / 4096, 2048 / 4096, 0 ], [ 6610 / 4096, -13613 / 4096, 7003 / 4096 ], [ 17933 / 4096, -17390 / 4096, -543 / 4096 ] ];
    var IPTtoLMS_M = [ [ .9999888965628402, .008605050147287059, .11103437159861648 ], [ 1.00001110343716, -.008605050147287059, -.11103437159861648 ], [ 1.0000320633910054, .56004913547279, -.3206339100541203 ] ];
    var LMStoXYZ_M$1 = [ [ 2.0701800566956137, -1.326456876103021, .20661600684785517 ], [ .3649882500326575, .6804673628522352, -.04542175307585323 ], [ -.04959554223893211, -.04942116118675749, 1.1879959417328034 ] ];
    var ictcp = new ColorSpace({
      id: 'ictcp',
      name: 'ICTCP',
      coords: {
        i: {
          refRange: [ 0, 1 ],
          name: 'I'
        },
        ct: {
          refRange: [ -.5, .5 ],
          name: 'CT'
        },
        cp: {
          refRange: [ -.5, .5 ],
          name: 'CP'
        }
      },
      base: XYZ_Abs_D65,
      fromBase: function fromBase(XYZ) {
        var LMS = multiplyMatrices(XYZtoLMS_M$1, XYZ);
        return LMStoICtCp(LMS);
      },
      toBase: function toBase(ICtCp) {
        var LMS = ICtCptoLMS(ICtCp);
        return multiplyMatrices(LMStoXYZ_M$1, LMS);
      },
      formats: {
        color: {}
      }
    });
    function LMStoICtCp(LMS) {
      var PQLMS = LMS.map(function(val) {
        var num = c1$1 + c2$1 * Math.pow(val / 1e4, m1);
        var denom = 1 + c3$1 * Math.pow(val / 1e4, m1);
        return Math.pow(num / denom, m2);
      });
      return multiplyMatrices(LMStoIPT_M, PQLMS);
    }
    function ICtCptoLMS(ICtCp) {
      var PQLMS = multiplyMatrices(IPTtoLMS_M, ICtCp);
      var LMS = PQLMS.map(function(val) {
        var num = Math.max(Math.pow(val, im2) - c1$1, 0);
        var denom = c2$1 - c3$1 * Math.pow(val, im2);
        return 1e4 * Math.pow(num / denom, im1);
      });
      return LMS;
    }
    function deltaEITP(color, sample) {
      var _ictcp$from = ictcp.from(color), _ictcp$from2 = _slicedToArray(_ictcp$from, 3), I1 = _ictcp$from2[0], T1 = _ictcp$from2[1], P1 = _ictcp$from2[2];
      var _ictcp$from3 = ictcp.from(sample), _ictcp$from4 = _slicedToArray(_ictcp$from3, 3), I2 = _ictcp$from4[0], T2 = _ictcp$from4[1], P2 = _ictcp$from4[2];
      return 720 * Math.sqrt(Math.pow(I1 - I2, 2) + .25 * Math.pow(T1 - T2, 2) + Math.pow(P1 - P2, 2));
    }
    var XYZtoLMS_M = [ [ .8190224432164319, .3619062562801221, -.12887378261216414 ], [ .0329836671980271, .9292868468965546, .03614466816999844 ], [ .048177199566046255, .26423952494422764, .6335478258136937 ] ];
    var LMStoXYZ_M = [ [ 1.2268798733741557, -.5578149965554813, .28139105017721583 ], [ -.04057576262431372, 1.1122868293970594, -.07171106666151701 ], [ -.07637294974672142, -.4214933239627914, 1.5869240244272418 ] ];
    var LMStoLab_M = [ [ .2104542553, .793617785, -.0040720468 ], [ 1.9779984951, -2.428592205, .4505937099 ], [ .0259040371, .7827717662, -.808675766 ] ];
    var LabtoLMS_M = [ [ .9999999984505198, .39633779217376786, .2158037580607588 ], [ 1.0000000088817609, -.10556134232365635, -.06385417477170591 ], [ 1.0000000546724108, -.08948418209496575, -1.2914855378640917 ] ];
    var OKLab = new ColorSpace({
      id: 'oklab',
      name: 'OKLab',
      coords: {
        l: {
          refRange: [ 0, 1 ],
          name: 'L'
        },
        a: {
          refRange: [ -.4, .4 ]
        },
        b: {
          refRange: [ -.4, .4 ]
        }
      },
      white: 'D65',
      base: XYZ_D65,
      fromBase: function fromBase(XYZ) {
        var LMS = multiplyMatrices(XYZtoLMS_M, XYZ);
        var LMSg = LMS.map(function(val) {
          return Math.cbrt(val);
        });
        return multiplyMatrices(LMStoLab_M, LMSg);
      },
      toBase: function toBase(OKLab2) {
        var LMSg = multiplyMatrices(LabtoLMS_M, OKLab2);
        var LMS = LMSg.map(function(val) {
          return Math.pow(val, 3);
        });
        return multiplyMatrices(LMStoXYZ_M, LMS);
      },
      formats: {
        oklab: {
          coords: [ '<number> | <percentage>', '<number>', '<number>' ]
        }
      }
    });
    function deltaEOK(color, sample) {
      var _OKLab$from = OKLab.from(color), _OKLab$from2 = _slicedToArray(_OKLab$from, 3), L1 = _OKLab$from2[0], a1 = _OKLab$from2[1], b1 = _OKLab$from2[2];
      var _OKLab$from3 = OKLab.from(sample), _OKLab$from4 = _slicedToArray(_OKLab$from3, 3), L2 = _OKLab$from4[0], a2 = _OKLab$from4[1], b2 = _OKLab$from4[2];
      var \u0394L = L1 - L2;
      var \u0394a = a1 - a2;
      var \u0394b = b1 - b2;
      return Math.sqrt(Math.pow(\u0394L, 2) + Math.pow(\u0394a, 2) + Math.pow(\u0394b, 2));
    }
    var deltaEMethods = Object.freeze({
      __proto__: null,
      deltaE76: deltaE76,
      deltaECMC: deltaECMC,
      deltaE2000: deltaE2000,
      deltaEJz: deltaEJz,
      deltaEITP: deltaEITP,
      deltaEOK: deltaEOK
    });
    function deltaE(c12, c22) {
      var o = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (isString(o)) {
        o = {
          method: o
        };
      }
      var _o2 = o, _o2$method = _o2.method, method = _o2$method === void 0 ? defaults.deltaE : _o2$method, rest = _objectWithoutProperties(_o2, _excluded12);
      c12 = getColor(c12);
      c22 = getColor(c22);
      for (var m3 in deltaEMethods) {
        if ('deltae' + method.toLowerCase() === m3.toLowerCase()) {
          return deltaEMethods[m3](c12, c22, rest);
        }
      }
      throw new TypeError('Unknown deltaE method: '.concat(method));
    }
    function lighten(color) {
      var amount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : .25;
      var space = ColorSpace.get('oklch', 'lch');
      var lightness = [ space, 'l' ];
      return set(color, lightness, function(l) {
        return l * (1 + amount);
      });
    }
    function darken(color) {
      var amount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : .25;
      var space = ColorSpace.get('oklch', 'lch');
      var lightness = [ space, 'l' ];
      return set(color, lightness, function(l) {
        return l * (1 - amount);
      });
    }
    var variations = Object.freeze({
      __proto__: null,
      lighten: lighten,
      darken: darken
    });
    function mix(c12, c22) {
      var p2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : .5;
      var o = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var _ref58 = [ getColor(c12), getColor(c22) ];
      c12 = _ref58[0];
      c22 = _ref58[1];
      if (type(p2) === 'object') {
        var _ref59 = [ .5, p2 ];
        p2 = _ref59[0];
        o = _ref59[1];
      }
      var _o3 = o, space = _o3.space, outputSpace = _o3.outputSpace, premultiplied = _o3.premultiplied;
      var r = range(c12, c22, {
        space: space,
        outputSpace: outputSpace,
        premultiplied: premultiplied
      });
      return r(p2);
    }
    function steps(c12, c22) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var colorRange;
      if (isRange(c12)) {
        colorRange = c12;
        options = c22;
        var _colorRange$rangeArgs = _slicedToArray(colorRange.rangeArgs.colors, 2);
        c12 = _colorRange$rangeArgs[0];
        c22 = _colorRange$rangeArgs[1];
      }
      var _options = options, maxDeltaE = _options.maxDeltaE, deltaEMethod = _options.deltaEMethod, _options$steps = _options.steps, steps2 = _options$steps === void 0 ? 2 : _options$steps, _options$maxSteps = _options.maxSteps, maxSteps = _options$maxSteps === void 0 ? 1e3 : _options$maxSteps, rangeOptions = _objectWithoutProperties(_options, _excluded13);
      if (!colorRange) {
        var _ref60 = [ getColor(c12), getColor(c22) ];
        c12 = _ref60[0];
        c22 = _ref60[1];
        colorRange = range(c12, c22, rangeOptions);
      }
      var totalDelta = deltaE(c12, c22);
      var actualSteps = maxDeltaE > 0 ? Math.max(steps2, Math.ceil(totalDelta / maxDeltaE) + 1) : steps2;
      var ret = [];
      if (maxSteps !== void 0) {
        actualSteps = Math.min(actualSteps, maxSteps);
      }
      if (actualSteps === 1) {
        ret = [ {
          p: .5,
          color: colorRange(.5)
        } ];
      } else {
        var step = 1 / (actualSteps - 1);
        ret = Array.from({
          length: actualSteps
        }, function(_, i) {
          var p2 = i * step;
          return {
            p: p2,
            color: colorRange(p2)
          };
        });
      }
      if (maxDeltaE > 0) {
        var maxDelta = ret.reduce(function(acc, cur, i) {
          if (i === 0) {
            return 0;
          }
          var \u0394\u0395 = deltaE(cur.color, ret[i - 1].color, deltaEMethod);
          return Math.max(acc, \u0394\u0395);
        }, 0);
        while (maxDelta > maxDeltaE) {
          maxDelta = 0;
          for (var _i16 = 1; _i16 < ret.length && ret.length < maxSteps; _i16++) {
            var prev = ret[_i16 - 1];
            var cur = ret[_i16];
            var p2 = (cur.p + prev.p) / 2;
            var _color = colorRange(p2);
            maxDelta = Math.max(maxDelta, deltaE(_color, prev.color), deltaE(_color, cur.color));
            ret.splice(_i16, 0, {
              p: p2,
              color: colorRange(p2)
            });
            _i16++;
          }
        }
      }
      ret = ret.map(function(a2) {
        return a2.color;
      });
      return ret;
    }
    function range(color1, color2) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (isRange(color1)) {
        var r = color1, options2 = color2;
        return range.apply(void 0, _toConsumableArray(r.rangeArgs.colors).concat([ _extends({}, r.rangeArgs.options, options2) ]));
      }
      var space = options.space, outputSpace = options.outputSpace, progression = options.progression, premultiplied = options.premultiplied;
      color1 = getColor(color1);
      color2 = getColor(color2);
      color1 = clone2(color1);
      color2 = clone2(color2);
      var rangeArgs = {
        colors: [ color1, color2 ],
        options: options
      };
      if (space) {
        space = ColorSpace.get(space);
      } else {
        space = ColorSpace.registry[defaults.interpolationSpace] || color1.space;
      }
      outputSpace = outputSpace ? ColorSpace.get(outputSpace) : space;
      color1 = to(color1, space);
      color2 = to(color2, space);
      color1 = toGamut(color1);
      color2 = toGamut(color2);
      if (space.coords.h && space.coords.h.type === 'angle') {
        var arc = options.hue = options.hue || 'shorter';
        var hue = [ space, 'h' ];
        var _ref61 = [ get(color1, hue), get(color2, hue) ], \u03b81 = _ref61[0], \u03b82 = _ref61[1];
        var _adjust = adjust(arc, [ \u03b81, \u03b82 ]);
        var _adjust2 = _slicedToArray(_adjust, 2);
        \u03b81 = _adjust2[0];
        \u03b82 = _adjust2[1];
        set(color1, hue, \u03b81);
        set(color2, hue, \u03b82);
      }
      if (premultiplied) {
        color1.coords = color1.coords.map(function(c4) {
          return c4 * color1.alpha;
        });
        color2.coords = color2.coords.map(function(c4) {
          return c4 * color2.alpha;
        });
      }
      return Object.assign(function(p2) {
        p2 = progression ? progression(p2) : p2;
        var coords = color1.coords.map(function(start, i) {
          var end = color2.coords[i];
          return interpolate(start, end, p2);
        });
        var alpha = interpolate(color1.alpha, color2.alpha, p2);
        var ret = {
          space: space,
          coords: coords,
          alpha: alpha
        };
        if (premultiplied) {
          ret.coords = ret.coords.map(function(c4) {
            return c4 / alpha;
          });
        }
        if (outputSpace !== space) {
          ret = to(ret, outputSpace);
        }
        return ret;
      }, {
        rangeArgs: rangeArgs
      });
    }
    function isRange(val) {
      return type(val) === 'function' && !!val.rangeArgs;
    }
    defaults.interpolationSpace = 'lab';
    function register(Color3) {
      Color3.defineFunction('mix', mix, {
        returns: 'color'
      });
      Color3.defineFunction('range', range, {
        returns: 'function<color>'
      });
      Color3.defineFunction('steps', steps, {
        returns: 'array<color>'
      });
    }
    var interpolation = Object.freeze({
      __proto__: null,
      mix: mix,
      steps: steps,
      range: range,
      isRange: isRange,
      register: register
    });
    var HSL = new ColorSpace({
      id: 'hsl',
      name: 'HSL',
      coords: {
        h: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        },
        s: {
          range: [ 0, 100 ],
          name: 'Saturation'
        },
        l: {
          range: [ 0, 100 ],
          name: 'Lightness'
        }
      },
      base: sRGB,
      fromBase: function fromBase(rgb) {
        var max2 = Math.max.apply(Math, _toConsumableArray(rgb));
        var min = Math.min.apply(Math, _toConsumableArray(rgb));
        var _rgb = _slicedToArray(rgb, 3), r = _rgb[0], g2 = _rgb[1], b2 = _rgb[2];
        var h = NaN, s = 0, l = (min + max2) / 2;
        var d2 = max2 - min;
        if (d2 !== 0) {
          s = l === 0 || l === 1 ? 0 : (max2 - l) / Math.min(l, 1 - l);
          switch (max2) {
           case r:
            h = (g2 - b2) / d2 + (g2 < b2 ? 6 : 0);
            break;

           case g2:
            h = (b2 - r) / d2 + 2;
            break;

           case b2:
            h = (r - g2) / d2 + 4;
          }
          h = h * 60;
        }
        return [ h, s * 100, l * 100 ];
      },
      toBase: function toBase(hsl) {
        var _hsl = _slicedToArray(hsl, 3), h = _hsl[0], s = _hsl[1], l = _hsl[2];
        h = h % 360;
        if (h < 0) {
          h += 360;
        }
        s /= 100;
        l /= 100;
        function f(n2) {
          var k = (n2 + h / 30) % 12;
          var a2 = s * Math.min(l, 1 - l);
          return l - a2 * Math.max(-1, Math.min(k - 3, 9 - k, 1));
        }
        return [ f(0), f(8), f(4) ];
      },
      formats: {
        hsl: {
          toGamut: true,
          coords: [ '<number> | <angle>', '<percentage>', '<percentage>' ]
        },
        hsla: {
          coords: [ '<number> | <angle>', '<percentage>', '<percentage>' ],
          commas: true,
          lastAlpha: true
        }
      }
    });
    var HSV = new ColorSpace({
      id: 'hsv',
      name: 'HSV',
      coords: {
        h: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        },
        s: {
          range: [ 0, 100 ],
          name: 'Saturation'
        },
        v: {
          range: [ 0, 100 ],
          name: 'Value'
        }
      },
      base: HSL,
      fromBase: function fromBase(hsl) {
        var _hsl2 = _slicedToArray(hsl, 3), h = _hsl2[0], s = _hsl2[1], l = _hsl2[2];
        s /= 100;
        l /= 100;
        var v = l + s * Math.min(l, 1 - l);
        return [ h, v === 0 ? 0 : 200 * (1 - l / v), 100 * v ];
      },
      toBase: function toBase(hsv) {
        var _hsv = _slicedToArray(hsv, 3), h = _hsv[0], s = _hsv[1], v = _hsv[2];
        s /= 100;
        v /= 100;
        var l = v * (1 - s / 2);
        return [ h, l === 0 || l === 1 ? 0 : (v - l) / Math.min(l, 1 - l) * 100, l * 100 ];
      },
      formats: {
        color: {
          toGamut: true
        }
      }
    });
    var hwb = new ColorSpace({
      id: 'hwb',
      name: 'HWB',
      coords: {
        h: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        },
        w: {
          range: [ 0, 100 ],
          name: 'Whiteness'
        },
        b: {
          range: [ 0, 100 ],
          name: 'Blackness'
        }
      },
      base: HSV,
      fromBase: function fromBase(hsv) {
        var _hsv2 = _slicedToArray(hsv, 3), h = _hsv2[0], s = _hsv2[1], v = _hsv2[2];
        return [ h, v * (100 - s) / 100, 100 - v ];
      },
      toBase: function toBase(hwb2) {
        var _hwb = _slicedToArray(hwb2, 3), h = _hwb[0], w = _hwb[1], b2 = _hwb[2];
        w /= 100;
        b2 /= 100;
        var sum = w + b2;
        if (sum >= 1) {
          var gray = w / sum;
          return [ h, 0, gray * 100 ];
        }
        var v = 1 - b2;
        var s = v === 0 ? 0 : 1 - w / v;
        return [ h, s * 100, v * 100 ];
      },
      formats: {
        hwb: {
          toGamut: true,
          coords: [ '<number> | <angle>', '<percentage>', '<percentage>' ]
        }
      }
    });
    var toXYZ_M$2 = [ [ .5766690429101305, .1855582379065463, .1882286462349947 ], [ .29734497525053605, .6273635662554661, .07529145849399788 ], [ .02703136138641234, .07068885253582723, .9913375368376388 ] ];
    var fromXYZ_M$2 = [ [ 2.0415879038107465, -.5650069742788596, -.34473135077832956 ], [ -.9692436362808795, 1.8759675015077202, .04155505740717557 ], [ .013444280632031142, -.11836239223101838, 1.0151749943912054 ] ];
    var A98Linear = new RGBColorSpace({
      id: 'a98rgb-linear',
      name: 'Linear Adobe\xae 98 RGB compatible',
      white: 'D65',
      toXYZ_M: toXYZ_M$2,
      fromXYZ_M: fromXYZ_M$2
    });
    var a98rgb = new RGBColorSpace({
      id: 'a98rgb',
      name: 'Adobe\xae 98 RGB compatible',
      base: A98Linear,
      toBase: function toBase(RGB) {
        return RGB.map(function(val) {
          return Math.pow(Math.abs(val), 563 / 256) * Math.sign(val);
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(val) {
          return Math.pow(Math.abs(val), 256 / 563) * Math.sign(val);
        });
      },
      formats: {
        color: {
          id: 'a98-rgb'
        }
      }
    });
    var toXYZ_M$1 = [ [ .7977604896723027, .13518583717574031, .0313493495815248 ], [ .2880711282292934, .7118432178101014, 8565396060525902e-20 ], [ 0, 0, .8251046025104601 ] ];
    var fromXYZ_M$1 = [ [ 1.3457989731028281, -.25558010007997534, -.05110628506753401 ], [ -.5446224939028347, 1.5082327413132781, .02053603239147973 ], [ 0, 0, 1.2119675456389454 ] ];
    var ProPhotoLinear = new RGBColorSpace({
      id: 'prophoto-linear',
      name: 'Linear ProPhoto',
      white: 'D50',
      base: XYZ_D50,
      toXYZ_M: toXYZ_M$1,
      fromXYZ_M: fromXYZ_M$1
    });
    var Et = 1 / 512;
    var Et2 = 16 / 512;
    var prophoto = new RGBColorSpace({
      id: 'prophoto',
      name: 'ProPhoto',
      base: ProPhotoLinear,
      toBase: function toBase(RGB) {
        return RGB.map(function(v) {
          return v < Et2 ? v / 16 : Math.pow(v, 1.8);
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(v) {
          return v >= Et ? Math.pow(v, 1 / 1.8) : 16 * v;
        });
      },
      formats: {
        color: {
          id: 'prophoto-rgb'
        }
      }
    });
    var oklch = new ColorSpace({
      id: 'oklch',
      name: 'OKLCh',
      coords: {
        l: {
          refRange: [ 0, 1 ],
          name: 'Lightness'
        },
        c: {
          refRange: [ 0, .4 ],
          name: 'Chroma'
        },
        h: {
          refRange: [ 0, 360 ],
          type: 'angle',
          name: 'Hue'
        }
      },
      white: 'D65',
      base: OKLab,
      fromBase: function fromBase(oklab) {
        var _oklab = _slicedToArray(oklab, 3), L = _oklab[0], a2 = _oklab[1], b2 = _oklab[2];
        var h;
        var \u03b52 = 2e-4;
        if (Math.abs(a2) < \u03b52 && Math.abs(b2) < \u03b52) {
          h = NaN;
        } else {
          h = Math.atan2(b2, a2) * 180 / Math.PI;
        }
        return [ L, Math.sqrt(Math.pow(a2, 2) + Math.pow(b2, 2)), constrain(h) ];
      },
      toBase: function toBase(oklch2) {
        var _oklch = _slicedToArray(oklch2, 3), L = _oklch[0], C = _oklch[1], h = _oklch[2];
        var a2, b2;
        if (isNaN(h)) {
          a2 = 0;
          b2 = 0;
        } else {
          a2 = C * Math.cos(h * Math.PI / 180);
          b2 = C * Math.sin(h * Math.PI / 180);
        }
        return [ L, a2, b2 ];
      },
      formats: {
        oklch: {
          coords: [ '<number> | <percentage>', '<number>', '<number> | <angle>' ]
        }
      }
    });
    var Yw = 203;
    var n = 2610 / Math.pow(2, 14);
    var ninv = Math.pow(2, 14) / 2610;
    var m = 2523 / Math.pow(2, 5);
    var minv = Math.pow(2, 5) / 2523;
    var c1 = 3424 / Math.pow(2, 12);
    var c2 = 2413 / Math.pow(2, 7);
    var c3 = 2392 / Math.pow(2, 7);
    var rec2100Pq = new RGBColorSpace({
      id: 'rec2100pq',
      name: 'REC.2100-PQ',
      base: REC2020Linear,
      toBase: function toBase(RGB) {
        return RGB.map(function(val) {
          var x = Math.pow(Math.max(Math.pow(val, minv) - c1, 0) / (c2 - c3 * Math.pow(val, minv)), ninv);
          return x * 1e4 / Yw;
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(val) {
          var x = Math.max(val * Yw / 1e4, 0);
          var num = c1 + c2 * Math.pow(x, n);
          var denom = 1 + c3 * Math.pow(x, n);
          return Math.pow(num / denom, m);
        });
      },
      formats: {
        color: {
          id: 'rec2100-pq'
        }
      }
    });
    var a = .17883277;
    var b = .28466892;
    var c = .55991073;
    var scale = 3.7743;
    var rec2100Hlg = new RGBColorSpace({
      id: 'rec2100hlg',
      cssid: 'rec2100-hlg',
      name: 'REC.2100-HLG',
      referred: 'scene',
      base: REC2020Linear,
      toBase: function toBase(RGB) {
        return RGB.map(function(val) {
          if (val <= .5) {
            return Math.pow(val, 2) / 3 * scale;
          }
          return Math.exp((val - c) / a + b) / 12 * scale;
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(val) {
          val /= scale;
          if (val <= 1 / 12) {
            return Math.sqrt(3 * val);
          }
          return a * Math.log(12 * val - b) + c;
        });
      },
      formats: {
        color: {
          id: 'rec2100-hlg'
        }
      }
    });
    var CATs = {};
    hooks.add('chromatic-adaptation-start', function(env) {
      if (env.options.method) {
        env.M = adapt(env.W1, env.W2, env.options.method);
      }
    });
    hooks.add('chromatic-adaptation-end', function(env) {
      if (!env.M) {
        env.M = adapt(env.W1, env.W2, env.options.method);
      }
    });
    function defineCAT(_ref62) {
      var id = _ref62.id, toCone_M = _ref62.toCone_M, fromCone_M = _ref62.fromCone_M;
      CATs[id] = arguments[0];
    }
    function adapt(W1, W2) {
      var id = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Bradford';
      var method = CATs[id];
      var _multiplyMatrices5 = multiplyMatrices(method.toCone_M, W1), _multiplyMatrices6 = _slicedToArray(_multiplyMatrices5, 3), \u03c1s = _multiplyMatrices6[0], \u03b3s = _multiplyMatrices6[1], \u03b2s = _multiplyMatrices6[2];
      var _multiplyMatrices7 = multiplyMatrices(method.toCone_M, W2), _multiplyMatrices8 = _slicedToArray(_multiplyMatrices7, 3), \u03c1d = _multiplyMatrices8[0], \u03b3d = _multiplyMatrices8[1], \u03b2d = _multiplyMatrices8[2];
      var scale2 = [ [ \u03c1d / \u03c1s, 0, 0 ], [ 0, \u03b3d / \u03b3s, 0 ], [ 0, 0, \u03b2d / \u03b2s ] ];
      var scaled_cone_M = multiplyMatrices(scale2, method.toCone_M);
      var adapt_M = multiplyMatrices(method.fromCone_M, scaled_cone_M);
      return adapt_M;
    }
    defineCAT({
      id: 'von Kries',
      toCone_M: [ [ .40024, .7076, -.08081 ], [ -.2263, 1.16532, .0457 ], [ 0, 0, .91822 ] ],
      fromCone_M: [ [ 1.8599364, -1.1293816, .2198974 ], [ .3611914, .6388125, -64e-7 ], [ 0, 0, 1.0890636 ] ]
    });
    defineCAT({
      id: 'Bradford',
      toCone_M: [ [ .8951, .2664, -.1614 ], [ -.7502, 1.7135, .0367 ], [ .0389, -.0685, 1.0296 ] ],
      fromCone_M: [ [ .9869929, -.1470543, .1599627 ], [ .4323053, .5183603, .0492912 ], [ -.0085287, .0400428, .9684867 ] ]
    });
    defineCAT({
      id: 'CAT02',
      toCone_M: [ [ .7328, .4296, -.1624 ], [ -.7036, 1.6975, .0061 ], [ .003, .0136, .9834 ] ],
      fromCone_M: [ [ 1.0961238, -.278869, .1827452 ], [ .454369, .4735332, .0720978 ], [ -.0096276, -.005698, 1.0153256 ] ]
    });
    defineCAT({
      id: 'CAT16',
      toCone_M: [ [ .401288, .650173, -.051461 ], [ -.250268, 1.204414, .045854 ], [ -.002079, .048952, .953127 ] ],
      fromCone_M: [ [ 1.862067855087233, -1.011254630531685, .1491867754444518 ], [ .3875265432361372, .6214474419314753, -.008973985167612518 ], [ -.01584149884933386, -.03412293802851557, 1.04996443687785 ] ]
    });
    Object.assign(WHITES, {
      A: [ 1.0985, 1, .35585 ],
      C: [ .98074, 1, 1.18232 ],
      D55: [ .95682, 1, .92149 ],
      D75: [ .94972, 1, 1.22638 ],
      E: [ 1, 1, 1 ],
      F2: [ .99186, 1, .67393 ],
      F7: [ .95041, 1, 1.08747 ],
      F11: [ 1.00962, 1, .6435 ]
    });
    WHITES.ACES = [ .32168 / .33767, 1, (1 - .32168 - .33767) / .33767 ];
    var toXYZ_M = [ [ .6624541811085053, .13400420645643313, .1561876870049078 ], [ .27222871678091454, .6740817658111484, .05368951740793705 ], [ -.005574649490394108, .004060733528982826, 1.0103391003129971 ] ];
    var fromXYZ_M = [ [ 1.6410233796943257, -.32480329418479, -.23642469523761225 ], [ -.6636628587229829, 1.6153315916573379, .016756347685530137 ], [ .011721894328375376, -.008284441996237409, .9883948585390215 ] ];
    var ACEScg = new RGBColorSpace({
      id: 'acescg',
      name: 'ACEScg',
      coords: {
        r: {
          range: [ 0, 65504 ],
          name: 'Red'
        },
        g: {
          range: [ 0, 65504 ],
          name: 'Green'
        },
        b: {
          range: [ 0, 65504 ],
          name: 'Blue'
        }
      },
      referred: 'scene',
      white: WHITES.ACES,
      toXYZ_M: toXYZ_M,
      fromXYZ_M: fromXYZ_M,
      formats: {
        color: {}
      }
    });
    var \u03b5 = Math.pow(2, -16);
    var ACES_min_nonzero = -.35828683;
    var ACES_cc_max = (Math.log2(65504) + 9.72) / 17.52;
    var acescc = new RGBColorSpace({
      id: 'acescc',
      name: 'ACEScc',
      coords: {
        r: {
          range: [ ACES_min_nonzero, ACES_cc_max ],
          name: 'Red'
        },
        g: {
          range: [ ACES_min_nonzero, ACES_cc_max ],
          name: 'Green'
        },
        b: {
          range: [ ACES_min_nonzero, ACES_cc_max ],
          name: 'Blue'
        }
      },
      referred: 'scene',
      base: ACEScg,
      toBase: function toBase(RGB) {
        var low = (9.72 - 15) / 17.52;
        return RGB.map(function(val) {
          if (val <= low) {
            return (Math.pow(2, val * 17.52 - 9.72) - \u03b5) * 2;
          } else if (val < ACES_cc_max) {
            return Math.pow(2, val * 17.52 - 9.72);
          } else {
            return 65504;
          }
        });
      },
      fromBase: function fromBase(RGB) {
        return RGB.map(function(val) {
          if (val <= 0) {
            return (Math.log2(\u03b5) + 9.72) / 17.52;
          } else if (val < \u03b5) {
            return (Math.log2(\u03b5 + val * .5) + 9.72) / 17.52;
          } else {
            return (Math.log2(val) + 9.72) / 17.52;
          }
        });
      },
      formats: {
        color: {}
      }
    });
    var spaces = Object.freeze({
      __proto__: null,
      XYZ_D65: XYZ_D65,
      XYZ_D50: XYZ_D50,
      XYZ_ABS_D65: XYZ_Abs_D65,
      Lab_D65: lab_d65,
      Lab: lab,
      LCH: lch,
      sRGB_Linear: sRGBLinear,
      sRGB: sRGB,
      HSL: HSL,
      HWB: hwb,
      HSV: HSV,
      P3_Linear: P3Linear,
      P3: P3,
      A98RGB_Linear: A98Linear,
      A98RGB: a98rgb,
      ProPhoto_Linear: ProPhotoLinear,
      ProPhoto: prophoto,
      REC_2020_Linear: REC2020Linear,
      REC_2020: REC2020,
      OKLab: OKLab,
      OKLCH: oklch,
      Jzazbz: Jzazbz,
      JzCzHz: jzczhz,
      ICTCP: ictcp,
      REC_2100_PQ: rec2100Pq,
      REC_2100_HLG: rec2100Hlg,
      ACEScg: ACEScg,
      ACEScc: acescc
    });
    var Color = (_space = new WeakMap(), function() {
      function Color() {
        var _this2 = this;
        _classCallCheck(this, Color);
        _classPrivateFieldInitSpec(this, _space, {
          writable: true,
          value: void 0
        });
        var color;
        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
          args[_key3] = arguments[_key3];
        }
        if (args.length === 1) {
          color = getColor(args[0]);
        }
        var space, coords, alpha;
        if (color) {
          space = color.space || color.spaceId;
          coords = color.coords;
          alpha = color.alpha;
        } else {
          space = args[0];
          coords = args[1];
          alpha = args[2];
        }
        _classPrivateFieldSet(this, _space, ColorSpace.get(space));
        this.coords = coords ? coords.slice() : [ 0, 0, 0 ];
        this.alpha = alpha < 1 ? alpha : 1;
        for (var _i17 = 0; _i17 < this.coords.length; _i17++) {
          if (this.coords[_i17] === 'NaN') {
            this.coords[_i17] = NaN;
          }
        }
        var _loop6 = function _loop6(id) {
          Object.defineProperty(_this2, id, {
            get: function get() {
              return _this2.get(id);
            },
            set: function set(value) {
              return _this2.set(id, value);
            }
          });
        };
        for (var id in _classPrivateFieldGet(this, _space).coords) {
          _loop6(id);
        }
      }
      _createClass(Color, [ {
        key: 'space',
        get: function get() {
          return _classPrivateFieldGet(this, _space);
        }
      }, {
        key: 'spaceId',
        get: function get() {
          return _classPrivateFieldGet(this, _space).id;
        }
      }, {
        key: 'clone',
        value: function clone() {
          return new Color(this.space, this.coords, this.alpha);
        }
      }, {
        key: 'toJSON',
        value: function toJSON() {
          return {
            spaceId: this.spaceId,
            coords: this.coords,
            alpha: this.alpha
          };
        }
      }, {
        key: 'display',
        value: function display() {
          for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
            args[_key4] = arguments[_key4];
          }
          var ret = _display.apply(void 0, [ this ].concat(args));
          ret.color = new Color(ret.color);
          return ret;
        }
      } ], [ {
        key: 'get',
        value: function get(color) {
          if (color instanceof Color) {
            return color;
          }
          for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
            args[_key5 - 1] = arguments[_key5];
          }
          return _construct(Color, [ color ].concat(args));
        }
      }, {
        key: 'defineFunction',
        value: function defineFunction(name, code) {
          var o = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : code;
          var _o$instance = o.instance, instance = _o$instance === void 0 ? true : _o$instance, returns = o.returns;
          var func = function func() {
            var ret = code.apply(void 0, arguments);
            if (returns === 'color') {
              ret = Color.get(ret);
            } else if (returns === 'function<color>') {
              var f = ret;
              ret = function ret() {
                var ret2 = f.apply(void 0, arguments);
                return Color.get(ret2);
              };
              Object.assign(ret, f);
            } else if (returns === 'array<color>') {
              ret = ret.map(function(c4) {
                return Color.get(c4);
              });
            }
            return ret;
          };
          if (!(name in Color)) {
            Color[name] = func;
          }
          if (instance) {
            Color.prototype[name] = function() {
              for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
                args[_key6] = arguments[_key6];
              }
              return func.apply(void 0, [ this ].concat(args));
            };
          }
        }
      }, {
        key: 'defineFunctions',
        value: function defineFunctions(o) {
          for (var name in o) {
            Color.defineFunction(name, o[name], o[name]);
          }
        }
      }, {
        key: 'extend',
        value: function extend(exports) {
          if (exports.register) {
            exports.register(Color);
          } else {
            for (var name in exports) {
              Color.defineFunction(name, exports[name]);
            }
          }
        }
      } ]);
      return Color;
    }());
    Color.defineFunctions({
      get: get,
      getAll: getAll,
      set: set,
      setAll: setAll,
      to: to,
      equals: equals,
      inGamut: inGamut,
      toGamut: toGamut,
      distance: distance,
      toString: serialize
    });
    Object.assign(Color, {
      util: util,
      hooks: hooks,
      WHITES: WHITES,
      Space: ColorSpace,
      spaces: ColorSpace.registry,
      parse: parse2,
      defaults: defaults
    });
    for (var _i18 = 0, _Object$keys2 = Object.keys(spaces); _i18 < _Object$keys2.length; _i18++) {
      var key = _Object$keys2[_i18];
      ColorSpace.register(spaces[key]);
    }
    for (var id in ColorSpace.registry) {
      addSpaceAccessors(id, ColorSpace.registry[id]);
    }
    hooks.add('colorspace-init-end', function(space) {
      var _space$aliases;
      addSpaceAccessors(space.id, space);
      (_space$aliases = space.aliases) === null || _space$aliases === void 0 ? void 0 : _space$aliases.forEach(function(alias) {
        addSpaceAccessors(alias, space);
      });
    });
    function addSpaceAccessors(id, space) {
      Object.keys(space.coords);
      Object.values(space.coords).map(function(c4) {
        return c4.name;
      });
      var propId = id.replace(/-/g, '_');
      Object.defineProperty(Color.prototype, propId, {
        get: function get() {
          var _this3 = this;
          var ret = this.getAll(id);
          if (typeof Proxy === 'undefined') {
            return ret;
          }
          return new Proxy(ret, {
            has: function has(obj, property) {
              try {
                ColorSpace.resolveCoord([ space, property ]);
                return true;
              } catch (e) {}
              return Reflect.has(obj, property);
            },
            get: function get(obj, property, receiver) {
              if (property && _typeof(property) !== 'symbol' && !(property in obj)) {
                var _ColorSpace$resolveCo3 = ColorSpace.resolveCoord([ space, property ]), index = _ColorSpace$resolveCo3.index;
                if (index >= 0) {
                  return obj[index];
                }
              }
              return Reflect.get(obj, property, receiver);
            },
            set: function set(obj, property, value, receiver) {
              if (property && _typeof(property) !== 'symbol' && !(property in obj) || property >= 0) {
                var _ColorSpace$resolveCo4 = ColorSpace.resolveCoord([ space, property ]), index = _ColorSpace$resolveCo4.index;
                if (index >= 0) {
                  obj[index] = value;
                  _this3.setAll(id, obj);
                  return true;
                }
              }
              return Reflect.set(obj, property, value, receiver);
            }
          });
        },
        set: function set(coords) {
          this.setAll(id, coords);
        },
        configurable: true,
        enumerable: true
      });
    }
    Color.extend(deltaEMethods);
    Color.extend({
      deltaE: deltaE
    });
    Color.extend(variations);
    Color.extend({
      contrast: contrast
    });
    Color.extend(chromaticity);
    Color.extend(luminance);
    Color.extend(interpolation);
    Color.extend(contrastMethods);
    var import_es6_promise = __toModule(require_es6_promise());
    var import_typedarray = __toModule(require_typedarray());
    var import_weakmap_polyfill = __toModule(require_weakmap_polyfill());
    var import_has_own = __toModule(require_has_own3());
    if (!('hasOwn' in Object)) {
      Object.hasOwn = import_has_own['default'];
    }
    import_dot['default'].templateSettings.strip = false;
    if (!('Promise' in window)) {
      import_es6_promise['default'].polyfill();
    }
    if (!('Uint32Array' in window)) {
      window.Uint32Array = import_typedarray.Uint32Array;
    }
    if (window.Uint32Array) {
      if (!('some' in window.Uint32Array.prototype)) {
        Object.defineProperty(window.Uint32Array.prototype, 'some', {
          value: Array.prototype.some
        });
      }
      if (!('reduce' in window.Uint32Array.prototype)) {
        Object.defineProperty(window.Uint32Array.prototype, 'reduce', {
          value: Array.prototype.reduce
        });
      }
    }
    var hexRegex = /^#[0-9a-f]{3,8}$/i;
    var hslRegex = /hsl\(\s*([\d.]+)(rad|turn)/;
    var Color2 = function() {
      function Color2(red, green, blue) {
        var alpha = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
        _classCallCheck(this, Color2);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
      }
      _createClass(Color2, [ {
        key: 'toHexString',
        value: function toHexString() {
          var redString = Math.round(this.red).toString(16);
          var greenString = Math.round(this.green).toString(16);
          var blueString = Math.round(this.blue).toString(16);
          return '#' + (this.red > 15.5 ? redString : '0' + redString) + (this.green > 15.5 ? greenString : '0' + greenString) + (this.blue > 15.5 ? blueString : '0' + blueString);
        }
      }, {
        key: 'toJSON',
        value: function toJSON() {
          var red = this.red, green = this.green, blue = this.blue, alpha = this.alpha;
          return {
            red: red,
            green: green,
            blue: blue,
            alpha: alpha
          };
        }
      }, {
        key: 'parseString',
        value: function parseString(colorString) {
          colorString = colorString.replace(hslRegex, function(match, angle, unit) {
            var value = angle + unit;
            switch (unit) {
             case 'rad':
              return match.replace(value, radToDeg(angle));

             case 'turn':
              return match.replace(value, turnToDeg(angle));
            }
          });
          try {
            var _color2 = new Color(colorString).to('srgb');
            this.red = Math.round(clamp(_color2.r, 0, 1) * 255);
            this.green = Math.round(clamp(_color2.g, 0, 1) * 255);
            this.blue = Math.round(clamp(_color2.b, 0, 1) * 255);
            this.alpha = +_color2.alpha;
          } catch (err2) {
            throw new Error('Unable to parse color "'.concat(colorString, '"'));
          }
          return this;
        }
      }, {
        key: 'parseRgbString',
        value: function parseRgbString(colorString) {
          this.parseString(colorString);
        }
      }, {
        key: 'parseHexString',
        value: function parseHexString(colorString) {
          if (!colorString.match(hexRegex) || [ 6, 8 ].includes(colorString.length)) {
            return;
          }
          this.parseString(colorString);
        }
      }, {
        key: 'parseColorFnString',
        value: function parseColorFnString(colorString) {
          this.parseString(colorString);
        }
      }, {
        key: 'getRelativeLuminance',
        value: function getRelativeLuminance() {
          var rSRGB = this.red / 255;
          var gSRGB = this.green / 255;
          var bSRGB = this.blue / 255;
          var r = rSRGB <= .03928 ? rSRGB / 12.92 : Math.pow((rSRGB + .055) / 1.055, 2.4);
          var g2 = gSRGB <= .03928 ? gSRGB / 12.92 : Math.pow((gSRGB + .055) / 1.055, 2.4);
          var b2 = bSRGB <= .03928 ? bSRGB / 12.92 : Math.pow((bSRGB + .055) / 1.055, 2.4);
          return .2126 * r + .7152 * g2 + .0722 * b2;
        }
      } ]);
      return Color2;
    }();
    var color_default = Color2;
    function clamp(value, min, max2) {
      return Math.min(Math.max(min, value), max2);
    }
    function radToDeg(rad) {
      return rad * 180 / Math.PI;
    }
    function turnToDeg(turn) {
      return turn * 360;
    }
    function getOwnBackgroundColor(elmStyle) {
      var bgColor = new color_default();
      bgColor.parseString(elmStyle.getPropertyValue('background-color'));
      if (bgColor.alpha !== 0) {
        var opacity = elmStyle.getPropertyValue('opacity');
        bgColor.alpha = bgColor.alpha * opacity;
      }
      return bgColor;
    }
    var get_own_background_color_default = getOwnBackgroundColor;
    function isOpaque(node) {
      var style = window.getComputedStyle(node);
      return element_has_image_default(node, style) || get_own_background_color_default(style).alpha === 1;
    }
    var is_opaque_default = isOpaque;
    function _isSkipLink(element) {
      if (!element.href) {
        return false;
      }
      var firstPageLink = cache_default.get('firstPageLink', generateFirstPageLink);
      if (!firstPageLink) {
        return true;
      }
      return element.compareDocumentPosition(firstPageLink.actualNode) === element.DOCUMENT_POSITION_FOLLOWING;
    }
    function generateFirstPageLink() {
      var firstPageLink;
      if (!window.location.origin) {
        firstPageLink = query_selector_all_default(axe._tree, 'a:not([href^="#"]):not([href^="/#"]):not([href^="javascript:"])')[0];
      } else {
        firstPageLink = query_selector_all_default(axe._tree, 'a[href]:not([href^="javascript:"])').find(function(link) {
          return !_isCurrentPageLink(link.actualNode);
        });
      }
      return firstPageLink || null;
    }
    var clipRegex2 = /rect\s*\(([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px,?\s*([0-9]+)px\s*\)/;
    var clipPathRegex2 = /(\w+)\((\d+)/;
    function isClipped(style) {
      var matchesClip = style.getPropertyValue('clip').match(clipRegex2);
      var matchesClipPath = style.getPropertyValue('clip-path').match(clipPathRegex2);
      if (matchesClip && matchesClip.length === 5) {
        var position = style.getPropertyValue('position');
        if ([ 'fixed', 'absolute' ].includes(position)) {
          return matchesClip[3] - matchesClip[1] <= 0 && matchesClip[2] - matchesClip[4] <= 0;
        }
      }
      if (matchesClipPath) {
        var type2 = matchesClipPath[1];
        var value = parseInt(matchesClipPath[2], 10);
        switch (type2) {
         case 'inset':
          return value >= 50;

         case 'circle':
          return value === 0;

         default:
        }
      }
      return false;
    }
    function isAreaVisible(el, screenReader, recursed) {
      var mapEl = find_up_default(el, 'map');
      if (!mapEl) {
        return false;
      }
      var mapElName = mapEl.getAttribute('name');
      if (!mapElName) {
        return false;
      }
      var mapElRootNode = get_root_node_default2(el);
      if (!mapElRootNode || mapElRootNode.nodeType !== 9) {
        return false;
      }
      var refs = query_selector_all_default(axe._tree, 'img[usemap="#'.concat(escape_selector_default(mapElName), '"]'));
      if (!refs || !refs.length) {
        return false;
      }
      return refs.some(function(_ref63) {
        var actualNode = _ref63.actualNode;
        return isVisible(actualNode, screenReader, recursed);
      });
    }
    function isVisible(el, screenReader, recursed) {
      var _window$Node2;
      if (!el) {
        throw new TypeError('Cannot determine if element is visible for non-DOM nodes');
      }
      var vNode = el instanceof abstract_virtual_node_default ? el : get_node_from_tree_default(el);
      el = vNode ? vNode.actualNode : el;
      var cacheName = '_isVisible' + (screenReader ? 'ScreenReader' : '');
      var _ref64 = (_window$Node2 = window.Node) !== null && _window$Node2 !== void 0 ? _window$Node2 : {}, DOCUMENT_NODE = _ref64.DOCUMENT_NODE, DOCUMENT_FRAGMENT_NODE = _ref64.DOCUMENT_FRAGMENT_NODE;
      var nodeType = vNode ? vNode.props.nodeType : el.nodeType;
      var nodeName2 = vNode ? vNode.props.nodeName : el.nodeName.toLowerCase();
      if (vNode && typeof vNode[cacheName] !== 'undefined') {
        return vNode[cacheName];
      }
      if (nodeType === DOCUMENT_NODE) {
        return true;
      }
      if ([ 'style', 'script', 'noscript', 'template' ].includes(nodeName2)) {
        return false;
      }
      if (el && nodeType === DOCUMENT_FRAGMENT_NODE) {
        el = el.host;
      }
      if (screenReader) {
        var ariaHiddenValue = vNode ? vNode.attr('aria-hidden') : el.getAttribute('aria-hidden');
        if (ariaHiddenValue === 'true') {
          return false;
        }
      }
      if (!el) {
        var parent2 = vNode.parent;
        var visible3 = true;
        if (parent2) {
          visible3 = isVisible(parent2, screenReader, true);
        }
        if (vNode) {
          vNode[cacheName] = visible3;
        }
        return visible3;
      }
      var style = window.getComputedStyle(el, null);
      if (style === null) {
        return false;
      }
      if (nodeName2 === 'area') {
        return isAreaVisible(el, screenReader, recursed);
      }
      if (style.getPropertyValue('display') === 'none') {
        return false;
      }
      var elHeight = parseInt(style.getPropertyValue('height'));
      var elWidth = parseInt(style.getPropertyValue('width'));
      var scroll = get_scroll_default(el);
      var scrollableWithZeroHeight = scroll && elHeight === 0;
      var scrollableWithZeroWidth = scroll && elWidth === 0;
      var posAbsoluteOverflowHiddenAndSmall = style.getPropertyValue('position') === 'absolute' && (elHeight < 2 || elWidth < 2) && style.getPropertyValue('overflow') === 'hidden';
      if (!screenReader && (isClipped(style) || style.getPropertyValue('opacity') === '0' || scrollableWithZeroHeight || scrollableWithZeroWidth || posAbsoluteOverflowHiddenAndSmall)) {
        return false;
      }
      if (!recursed && (style.getPropertyValue('visibility') === 'hidden' || !screenReader && is_offscreen_default(el))) {
        return false;
      }
      var parent = el.assignedSlot ? el.assignedSlot : el.parentNode;
      var visible2 = false;
      if (parent) {
        visible2 = isVisible(parent, screenReader, true);
      }
      if (vNode) {
        vNode[cacheName] = visible2;
      }
      return visible2;
    }
    var is_visible_default = isVisible;
    function reduceToElementsBelowFloating(elements, targetNode) {
      var floatingPositions = [ 'fixed', 'sticky' ];
      var finalElements = [];
      var targetFound = false;
      for (var index = 0; index < elements.length; ++index) {
        var currentNode = elements[index];
        if (currentNode === targetNode) {
          targetFound = true;
        }
        var style = window.getComputedStyle(currentNode);
        if (!targetFound && floatingPositions.indexOf(style.position) !== -1) {
          finalElements = [];
          continue;
        }
        finalElements.push(currentNode);
      }
      return finalElements;
    }
    var reduce_to_elements_below_floating_default = reduceToElementsBelowFloating;
    function _visuallyContains(node, parent) {
      var parentScrollAncestor = getScrollAncestor(parent);
      do {
        var nextScrollAncestor = getScrollAncestor(node);
        if (nextScrollAncestor === parentScrollAncestor || nextScrollAncestor === parent) {
          return contains2(node, parent);
        }
        node = nextScrollAncestor;
      } while (node);
      return false;
    }
    function getScrollAncestor(node) {
      var vNode = get_node_from_tree_default(node);
      var ancestor = vNode.parent;
      while (ancestor) {
        if (get_scroll_default(ancestor.actualNode)) {
          return ancestor.actualNode;
        }
        ancestor = ancestor.parent;
      }
    }
    function contains2(node, parent) {
      var style = window.getComputedStyle(parent);
      var overflow = style.getPropertyValue('overflow');
      if (style.getPropertyValue('display') === 'inline') {
        return true;
      }
      var clientRects = Array.from(node.getClientRects());
      var boundingRect = parent.getBoundingClientRect();
      var rect = {
        left: boundingRect.left,
        top: boundingRect.top,
        width: boundingRect.width,
        height: boundingRect.height
      };
      if ([ 'scroll', 'auto' ].includes(overflow) || parent instanceof window.HTMLHtmlElement) {
        rect.width = parent.scrollWidth;
        rect.height = parent.scrollHeight;
      }
      if (clientRects.length === 1 && overflow === 'hidden' && style.getPropertyValue('white-space') === 'nowrap') {
        clientRects[0] = rect;
      }
      return clientRects.some(function(clientRect) {
        return !(Math.ceil(clientRect.left) < Math.floor(rect.left) || Math.ceil(clientRect.top) < Math.floor(rect.top) || Math.floor(clientRect.left + clientRect.width) > Math.ceil(rect.left + rect.width) || Math.floor(clientRect.top + clientRect.height) > Math.ceil(rect.top + rect.height));
      });
    }
    function shadowElementsFromPoint(nodeX, nodeY) {
      var root = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : document;
      var i = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      if (i > 999) {
        throw new Error('Infinite loop detected');
      }
      return Array.from(root.elementsFromPoint(nodeX, nodeY) || []).filter(function(nodes) {
        return get_root_node_default2(nodes) === root;
      }).reduce(function(stack, elm) {
        if (is_shadow_root_default(elm)) {
          var shadowStack = shadowElementsFromPoint(nodeX, nodeY, elm.shadowRoot, i + 1);
          stack = stack.concat(shadowStack);
          if (stack.length && _visuallyContains(stack[0], elm)) {
            stack.push(elm);
          }
        } else {
          stack.push(elm);
        }
        return stack;
      }, []);
    }
    var shadow_elements_from_point_default = shadowElementsFromPoint;
    function urlPropsFromAttribute(node, attribute) {
      if (!node.hasAttribute(attribute)) {
        return void 0;
      }
      var nodeName2 = node.nodeName.toUpperCase();
      var parser2 = node;
      if (![ 'A', 'AREA' ].includes(nodeName2) || node.ownerSVGElement) {
        parser2 = document.createElement('a');
        parser2.href = node.getAttribute(attribute);
      }
      var protocol = [ 'https:', 'ftps:' ].includes(parser2.protocol) ? parser2.protocol.replace(/s:$/, ':') : parser2.protocol;
      var parserPathname = /^\//.test(parser2.pathname) ? parser2.pathname : '/'.concat(parser2.pathname);
      var _getPathnameOrFilenam = getPathnameOrFilename(parserPathname), pathname = _getPathnameOrFilenam.pathname, filename = _getPathnameOrFilenam.filename;
      return {
        protocol: protocol,
        hostname: parser2.hostname,
        port: getPort(parser2.port),
        pathname: /\/$/.test(pathname) ? pathname : ''.concat(pathname, '/'),
        search: getSearchPairs(parser2.search),
        hash: getHashRoute(parser2.hash),
        filename: filename
      };
    }
    function getPort(port) {
      var excludePorts = [ '443', '80' ];
      return !excludePorts.includes(port) ? port : '';
    }
    function getPathnameOrFilename(pathname) {
      var filename = pathname.split('/').pop();
      if (!filename || filename.indexOf('.') === -1) {
        return {
          pathname: pathname,
          filename: ''
        };
      }
      return {
        pathname: pathname.replace(filename, ''),
        filename: /index./.test(filename) ? '' : filename
      };
    }
    function getSearchPairs(searchStr) {
      var query = {};
      if (!searchStr || !searchStr.length) {
        return query;
      }
      var pairs = searchStr.substring(1).split('&');
      if (!pairs || !pairs.length) {
        return query;
      }
      for (var index = 0; index < pairs.length; index++) {
        var pair = pairs[index];
        var _pair$split = pair.split('='), _pair$split2 = _slicedToArray(_pair$split, 2), _key7 = _pair$split2[0], _pair$split2$ = _pair$split2[1], value = _pair$split2$ === void 0 ? '' : _pair$split2$;
        query[decodeURIComponent(_key7)] = decodeURIComponent(value);
      }
      return query;
    }
    function getHashRoute(hash) {
      if (!hash) {
        return '';
      }
      var hashRegex = /#!?\/?/g;
      var hasMatch = hash.match(hashRegex);
      if (!hasMatch) {
        return '';
      }
      var _hasMatch = _slicedToArray(hasMatch, 1), matchedStr = _hasMatch[0];
      if (matchedStr === '#') {
        return '';
      }
      return hash;
    }
    var url_props_from_attribute_default = urlPropsFromAttribute;
    function visuallyOverlaps(rect, parent) {
      var parentRect = parent.getBoundingClientRect();
      var parentTop = parentRect.top;
      var parentLeft = parentRect.left;
      var parentScrollArea = {
        top: parentTop - parent.scrollTop,
        bottom: parentTop - parent.scrollTop + parent.scrollHeight,
        left: parentLeft - parent.scrollLeft,
        right: parentLeft - parent.scrollLeft + parent.scrollWidth
      };
      if (rect.left > parentScrollArea.right && rect.left > parentRect.right || rect.top > parentScrollArea.bottom && rect.top > parentRect.bottom || rect.right < parentScrollArea.left && rect.right < parentRect.left || rect.bottom < parentScrollArea.top && rect.bottom < parentRect.top) {
        return false;
      }
      var style = window.getComputedStyle(parent);
      if (rect.left > parentRect.right || rect.top > parentRect.bottom) {
        return style.overflow === 'scroll' || style.overflow === 'auto' || parent instanceof window.HTMLBodyElement || parent instanceof window.HTMLHtmlElement;
      }
      return true;
    }
    var visually_overlaps_default = visuallyOverlaps;
    var nodeIndex2 = 0;
    var VirtualNode = function(_abstract_virtual_nod) {
      _inherits(VirtualNode, _abstract_virtual_nod);
      var _super2 = _createSuper(VirtualNode);
      function VirtualNode(node, parent, shadowId) {
        var _this4;
        _classCallCheck(this, VirtualNode);
        _this4 = _super2.call(this);
        _this4.shadowId = shadowId;
        _this4.children = [];
        _this4.actualNode = node;
        _this4.parent = parent;
        if (!parent) {
          nodeIndex2 = 0;
        }
        _this4.nodeIndex = nodeIndex2++;
        _this4._isHidden = null;
        _this4._cache = {};
        _this4._isXHTML = is_xhtml_default(node.ownerDocument);
        if (node.nodeName.toLowerCase() === 'input') {
          var type2 = node.getAttribute('type');
          type2 = _this4._isXHTML ? type2 : (type2 || '').toLowerCase();
          if (!valid_input_type_default().includes(type2)) {
            type2 = 'text';
          }
          _this4._type = type2;
        }
        if (cache_default.get('nodeMap')) {
          cache_default.get('nodeMap').set(node, _assertThisInitialized(_this4));
        }
        return _this4;
      }
      _createClass(VirtualNode, [ {
        key: 'props',
        get: function get() {
          if (!this._cache.hasOwnProperty('props')) {
            var _this$actualNode = this.actualNode, nodeType = _this$actualNode.nodeType, nodeName2 = _this$actualNode.nodeName, _id = _this$actualNode.id, multiple = _this$actualNode.multiple, nodeValue = _this$actualNode.nodeValue, value = _this$actualNode.value, selected = _this$actualNode.selected, checked = _this$actualNode.checked, indeterminate = _this$actualNode.indeterminate;
            this._cache.props = {
              nodeType: nodeType,
              nodeName: this._isXHTML ? nodeName2 : nodeName2.toLowerCase(),
              id: _id,
              type: this._type,
              multiple: multiple,
              nodeValue: nodeValue,
              value: value,
              selected: selected,
              checked: checked,
              indeterminate: indeterminate
            };
          }
          return this._cache.props;
        }
      }, {
        key: 'attr',
        value: function attr(attrName) {
          if (typeof this.actualNode.getAttribute !== 'function') {
            return null;
          }
          return this.actualNode.getAttribute(attrName);
        }
      }, {
        key: 'hasAttr',
        value: function hasAttr(attrName) {
          if (typeof this.actualNode.hasAttribute !== 'function') {
            return false;
          }
          return this.actualNode.hasAttribute(attrName);
        }
      }, {
        key: 'attrNames',
        get: function get() {
          if (!this._cache.hasOwnProperty('attrNames')) {
            var attrs;
            if (this.actualNode.attributes instanceof window.NamedNodeMap) {
              attrs = this.actualNode.attributes;
            } else {
              attrs = this.actualNode.cloneNode(false).attributes;
            }
            this._cache.attrNames = Array.from(attrs).map(function(attr) {
              return attr.name;
            });
          }
          return this._cache.attrNames;
        }
      }, {
        key: 'getComputedStylePropertyValue',
        value: function getComputedStylePropertyValue(property) {
          var key = 'computedStyle_' + property;
          if (!this._cache.hasOwnProperty(key)) {
            if (!this._cache.hasOwnProperty('computedStyle')) {
              this._cache.computedStyle = window.getComputedStyle(this.actualNode);
            }
            this._cache[key] = this._cache.computedStyle.getPropertyValue(property);
          }
          return this._cache[key];
        }
      }, {
        key: 'isFocusable',
        get: function get() {
          if (!this._cache.hasOwnProperty('isFocusable')) {
            this._cache.isFocusable = _isFocusable(this.actualNode);
          }
          return this._cache.isFocusable;
        }
      }, {
        key: 'tabbableElements',
        get: function get() {
          if (!this._cache.hasOwnProperty('tabbableElements')) {
            this._cache.tabbableElements = get_tabbable_elements_default(this);
          }
          return this._cache.tabbableElements;
        }
      }, {
        key: 'clientRects',
        get: function get() {
          if (!this._cache.hasOwnProperty('clientRects')) {
            this._cache.clientRects = Array.from(this.actualNode.getClientRects()).filter(function(rect) {
              return rect.width > 0;
            });
          }
          return this._cache.clientRects;
        }
      }, {
        key: 'boundingClientRect',
        get: function get() {
          if (!this._cache.hasOwnProperty('boundingClientRect')) {
            this._cache.boundingClientRect = this.actualNode.getBoundingClientRect();
          }
          return this._cache.boundingClientRect;
        }
      } ]);
      return VirtualNode;
    }(abstract_virtual_node_default);
    var virtual_node_default = VirtualNode;
    function tokenList(str) {
      return (str || '').trim().replace(/\s{2,}/g, ' ').split(' ');
    }
    var token_list_default = tokenList;
    var idsKey = ' [idsMap]';
    function getNodesMatchingExpression(domTree, expressions, filter) {
      var selectorMap = domTree[0]._selectorMap;
      if (!selectorMap) {
        return;
      }
      var shadowId = domTree[0].shadowId;
      for (var _i19 = 0; _i19 < expressions.length; _i19++) {
        if (expressions[_i19].length > 1 && expressions[_i19].some(function(expression) {
          return isGlobalSelector(expression);
        })) {
          return;
        }
      }
      var nodeSet = new Set();
      expressions.forEach(function(expression) {
        var _matchingNodes$nodes;
        var matchingNodes = findMatchingNodes(expression, selectorMap, shadowId);
        matchingNodes === null || matchingNodes === void 0 ? void 0 : (_matchingNodes$nodes = matchingNodes.nodes) === null || _matchingNodes$nodes === void 0 ? void 0 : _matchingNodes$nodes.forEach(function(node) {
          if (matchingNodes.isComplexSelector && !_matchesExpression(node, expression)) {
            return;
          }
          nodeSet.add(node);
        });
      });
      var matchedNodes = [];
      nodeSet.forEach(function(node) {
        return matchedNodes.push(node);
      });
      if (filter) {
        matchedNodes = matchedNodes.filter(filter);
      }
      return matchedNodes.sort(function(a2, b2) {
        return a2.nodeIndex - b2.nodeIndex;
      });
    }
    function findMatchingNodes(expression, selectorMap, shadowId) {
      var exp = expression[expression.length - 1];
      var nodes = null;
      var isComplexSelector = expression.length > 1 || !!exp.pseudos || !!exp.classes;
      if (isGlobalSelector(exp)) {
        nodes = selectorMap['*'];
      } else {
        if (exp.id) {
          var _selectorMap$idsKey$e;
          if (!selectorMap[idsKey] || !Object.hasOwn(selectorMap[idsKey], exp.id) || !((_selectorMap$idsKey$e = selectorMap[idsKey][exp.id]) !== null && _selectorMap$idsKey$e !== void 0 && _selectorMap$idsKey$e.length)) {
            return;
          }
          nodes = selectorMap[idsKey][exp.id].filter(function(node) {
            return node.shadowId === shadowId;
          });
        }
        if (exp.tag && exp.tag !== '*') {
          var _selectorMap$exp$tag;
          if (!((_selectorMap$exp$tag = selectorMap[exp.tag]) !== null && _selectorMap$exp$tag !== void 0 && _selectorMap$exp$tag.length)) {
            return;
          }
          var cachedNodes = selectorMap[exp.tag];
          nodes = nodes ? getSharedValues(cachedNodes, nodes) : cachedNodes;
        }
        if (exp.classes) {
          var _selectorMap$Class;
          if (!((_selectorMap$Class = selectorMap['[class]']) !== null && _selectorMap$Class !== void 0 && _selectorMap$Class.length)) {
            return;
          }
          var _cachedNodes = selectorMap['[class]'];
          nodes = nodes ? getSharedValues(_cachedNodes, nodes) : _cachedNodes;
        }
        if (exp.attributes) {
          for (var _i20 = 0; _i20 < exp.attributes.length; _i20++) {
            var _selectorMap;
            var attr = exp.attributes[_i20];
            if (attr.type === 'attrValue') {
              isComplexSelector = true;
            }
            if (!((_selectorMap = selectorMap['['.concat(attr.key, ']')]) !== null && _selectorMap !== void 0 && _selectorMap.length)) {
              return;
            }
            var _cachedNodes2 = selectorMap['['.concat(attr.key, ']')];
            nodes = nodes ? getSharedValues(_cachedNodes2, nodes) : _cachedNodes2;
          }
        }
      }
      return {
        nodes: nodes,
        isComplexSelector: isComplexSelector
      };
    }
    function isGlobalSelector(expression) {
      return expression.tag === '*' && !expression.attributes && !expression.id && !expression.classes;
    }
    function getSharedValues(a2, b2) {
      return a2.filter(function(node) {
        return b2.includes(node);
      });
    }
    function cacheSelector(key, vNode, map) {
      if (!Object.hasOwn(map, key)) {
        map[key] = [];
      }
      map[key].push(vNode);
    }
    function cacheNodeSelectors(vNode, selectorMap) {
      if (vNode.props.nodeType !== 1) {
        return;
      }
      cacheSelector(vNode.props.nodeName, vNode, selectorMap);
      cacheSelector('*', vNode, selectorMap);
      vNode.attrNames.forEach(function(attrName) {
        if (attrName === 'id') {
          selectorMap[idsKey] = selectorMap[idsKey] || {};
          token_list_default(vNode.attr(attrName)).forEach(function(value) {
            cacheSelector(value, vNode, selectorMap[idsKey]);
          });
        }
        cacheSelector('['.concat(attrName, ']'), vNode, selectorMap);
      });
    }
    var hasShadowRoot;
    function _getFlattenedTree() {
      var node = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document.documentElement;
      var shadowId = arguments.length > 1 ? arguments[1] : undefined;
      hasShadowRoot = false;
      var selectorMap = {};
      cache_default.set('nodeMap', new WeakMap());
      cache_default.set('selectorMap', selectorMap);
      var tree = flattenTree(node, shadowId, null);
      tree[0]._selectorMap = selectorMap;
      tree[0]._hasShadowRoot = hasShadowRoot;
      return tree;
    }
    function getSlotChildren(node) {
      var retVal = [];
      node = node.firstChild;
      while (node) {
        retVal.push(node);
        node = node.nextSibling;
      }
      return retVal;
    }
    function createNode(node, parent, shadowId) {
      var vNode = new virtual_node_default(node, parent, shadowId);
      cacheNodeSelectors(vNode, cache_default.get('selectorMap'));
      return vNode;
    }
    function flattenTree(node, shadowId, parent) {
      var retVal, realArray, nodeName2;
      function reduceShadowDOM(res, child, parentVNode) {
        var replacements = flattenTree(child, shadowId, parentVNode);
        if (replacements) {
          res = res.concat(replacements);
        }
        return res;
      }
      if (node.documentElement) {
        node = node.documentElement;
      }
      nodeName2 = node.nodeName.toLowerCase();
      if (is_shadow_root_default(node)) {
        hasShadowRoot = true;
        retVal = createNode(node, parent, shadowId);
        shadowId = 'a' + Math.random().toString().substring(2);
        realArray = Array.from(node.shadowRoot.childNodes);
        retVal.children = realArray.reduce(function(res, child) {
          return reduceShadowDOM(res, child, retVal);
        }, []);
        return [ retVal ];
      } else {
        if (nodeName2 === 'content' && typeof node.getDistributedNodes === 'function') {
          realArray = Array.from(node.getDistributedNodes());
          return realArray.reduce(function(res, child) {
            return reduceShadowDOM(res, child, parent);
          }, []);
        } else if (nodeName2 === 'slot' && typeof node.assignedNodes === 'function') {
          realArray = Array.from(node.assignedNodes());
          if (!realArray.length) {
            realArray = getSlotChildren(node);
          }
          var styl = window.getComputedStyle(node);
          if (false) {} else {
            return realArray.reduce(function(res, child) {
              return reduceShadowDOM(res, child, parent);
            }, []);
          }
        } else {
          if (node.nodeType === 1) {
            retVal = createNode(node, parent, shadowId);
            realArray = Array.from(node.childNodes);
            retVal.children = realArray.reduce(function(res, child) {
              return reduceShadowDOM(res, child, retVal);
            }, []);
            return [ retVal ];
          } else if (node.nodeType === 3) {
            return [ createNode(node, parent) ];
          }
          return void 0;
        }
      }
    }
    function getBaseLang(lang) {
      if (!lang) {
        return '';
      }
      return lang.trim().split('-')[0].toLowerCase();
    }
    var get_base_lang_default = getBaseLang;
    function failureSummary(nodeData) {
      var failingChecks = {};
      failingChecks.none = nodeData.none.concat(nodeData.all);
      failingChecks.any = nodeData.any;
      return Object.keys(failingChecks).map(function(key) {
        if (!failingChecks[key].length) {
          return;
        }
        var sum = axe._audit.data.failureSummaries[key];
        if (sum && typeof sum.failureMessage === 'function') {
          return sum.failureMessage(failingChecks[key].map(function(check) {
            return check.message || '';
          }));
        }
      }).filter(function(i) {
        return i !== void 0;
      }).join('\n\n');
    }
    var failure_summary_default = failureSummary;
    function incompleteFallbackMessage() {
      var message = axe._audit.data.incompleteFallbackMessage;
      if (typeof message === 'function') {
        message = message();
      }
      if (typeof message !== 'string') {
        return '';
      }
      return message;
    }
    var resultKeys = constants_default.resultGroups;
    function processAggregate(results, options) {
      var resultObject = axe.utils.aggregateResult(results);
      resultKeys.forEach(function(key) {
        if (options.resultTypes && !options.resultTypes.includes(key)) {
          (resultObject[key] || []).forEach(function(ruleResult) {
            if (Array.isArray(ruleResult.nodes) && ruleResult.nodes.length > 0) {
              ruleResult.nodes = [ ruleResult.nodes[0] ];
            }
          });
        }
        resultObject[key] = (resultObject[key] || []).map(function(ruleResult) {
          ruleResult = Object.assign({}, ruleResult);
          if (Array.isArray(ruleResult.nodes) && ruleResult.nodes.length > 0) {
            ruleResult.nodes = ruleResult.nodes.map(function(subResult) {
              if (_typeof(subResult.node) === 'object') {
                var serialElm = trimElementSpec(subResult.node, options);
                Object.assign(subResult, serialElm);
              }
              delete subResult.result;
              delete subResult.node;
              normalizeRelatedNodes(subResult, options);
              return subResult;
            });
          }
          resultKeys.forEach(function(resultKey) {
            return delete ruleResult[resultKey];
          });
          delete ruleResult.pageLevel;
          delete ruleResult.result;
          return ruleResult;
        });
      });
      return resultObject;
    }
    function normalizeRelatedNodes(node, options) {
      [ 'any', 'all', 'none' ].forEach(function(type2) {
        if (!Array.isArray(node[type2])) {
          return;
        }
        node[type2].filter(function(checkRes) {
          return Array.isArray(checkRes.relatedNodes);
        }).forEach(function(checkRes) {
          checkRes.relatedNodes = checkRes.relatedNodes.map(function(relatedNode) {
            return trimElementSpec(relatedNode, options);
          });
        });
      });
    }
    function trimElementSpec() {
      var elmSpec = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var runOptions = arguments.length > 1 ? arguments[1] : undefined;
      elmSpec = node_serializer_default.dqElmToSpec(elmSpec, runOptions);
      var serialElm = {};
      if (axe._audit.noHtml) {
        serialElm.html = null;
      } else {
        var _elmSpec$source;
        serialElm.html = (_elmSpec$source = elmSpec.source) !== null && _elmSpec$source !== void 0 ? _elmSpec$source : 'Undefined';
      }
      if (runOptions.elementRef && !elmSpec.fromFrame) {
        var _elmSpec$element;
        serialElm.element = (_elmSpec$element = elmSpec.element) !== null && _elmSpec$element !== void 0 ? _elmSpec$element : null;
      }
      if (runOptions.selectors !== false || elmSpec.fromFrame) {
        var _elmSpec$selector;
        serialElm.target = (_elmSpec$selector = elmSpec.selector) !== null && _elmSpec$selector !== void 0 ? _elmSpec$selector : [ ':root' ];
      }
      if (runOptions.ancestry) {
        var _elmSpec$ancestry;
        serialElm.ancestry = (_elmSpec$ancestry = elmSpec.ancestry) !== null && _elmSpec$ancestry !== void 0 ? _elmSpec$ancestry : [ ':root' ];
      }
      if (runOptions.xpath) {
        var _elmSpec$xpath;
        serialElm.xpath = (_elmSpec$xpath = elmSpec.xpath) !== null && _elmSpec$xpath !== void 0 ? _elmSpec$xpath : [ '/' ];
      }
      return serialElm;
    }
    var dataRegex = /\$\{\s?data\s?\}/g;
    function substitute(str, data) {
      if (typeof data === 'string') {
        return str.replace(dataRegex, data);
      }
      for (var prop in data) {
        if (data.hasOwnProperty(prop)) {
          var regex = new RegExp('\\${\\s?data\\.' + prop + '\\s?}', 'g');
          var replace = typeof data[prop] === 'undefined' ? '' : String(data[prop]);
          str = str.replace(regex, replace);
        }
      }
      return str;
    }
    function processMessage(message, data) {
      if (!message) {
        return;
      }
      if (Array.isArray(data)) {
        data.values = data.join(', ');
        if (typeof message.singular === 'string' && typeof message.plural === 'string') {
          var str2 = data.length === 1 ? message.singular : message.plural;
          return substitute(str2, data);
        }
        return substitute(message, data);
      }
      if (typeof message === 'string') {
        return substitute(message, data);
      }
      if (typeof data === 'string') {
        var _str = message[data];
        return substitute(_str, data);
      }
      var str = message['default'] || incompleteFallbackMessage();
      if (data && data.messageKey && message[data.messageKey]) {
        str = message[data.messageKey];
      }
      return processMessage(str, data);
    }
    var process_message_default = processMessage;
    function getCheckMessage(checkId, type2, data) {
      var check = axe._audit.data.checks[checkId];
      if (!check) {
        throw new Error('Cannot get message for unknown check: '.concat(checkId, '.'));
      }
      if (!check.messages[type2]) {
        throw new Error('Check "'.concat(checkId, '"" does not have a "').concat(type2, '" message.'));
      }
      return process_message_default(check.messages[type2], data);
    }
    var get_check_message_default = getCheckMessage;
    function getCheckOption(check, ruleID, options) {
      var ruleCheckOption = ((options.rules && options.rules[ruleID] || {}).checks || {})[check.id];
      var checkOption = (options.checks || {})[check.id];
      var enabled = check.enabled;
      var opts = check.options;
      if (checkOption) {
        if (checkOption.hasOwnProperty('enabled')) {
          enabled = checkOption.enabled;
        }
        if (checkOption.hasOwnProperty('options')) {
          opts = checkOption.options;
        }
      }
      if (ruleCheckOption) {
        if (ruleCheckOption.hasOwnProperty('enabled')) {
          enabled = ruleCheckOption.enabled;
        }
        if (ruleCheckOption.hasOwnProperty('options')) {
          opts = ruleCheckOption.options;
        }
      }
      return {
        enabled: enabled,
        options: opts,
        absolutePaths: options.absolutePaths
      };
    }
    var get_check_option_default = getCheckOption;
    function _getEnvironmentData() {
      var _win$location;
      var metadata = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var win = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : window;
      if (metadata && _typeof(metadata) === 'object') {
        return metadata;
      } else if (_typeof(win) !== 'object') {
        return {};
      }
      return {
        testEngine: {
          name: 'axe-core',
          version: axe.version
        },
        testRunner: {
          name: axe._audit.brand
        },
        testEnvironment: getTestEnvironment(win),
        timestamp: new Date().toISOString(),
        url: (_win$location = win.location) === null || _win$location === void 0 ? void 0 : _win$location.href
      };
    }
    function getTestEnvironment(win) {
      if (!win.navigator || _typeof(win.navigator) !== 'object') {
        return {};
      }
      var navigator = win.navigator, innerHeight = win.innerHeight, innerWidth = win.innerWidth;
      var _ref65 = getOrientation(win) || {}, angle = _ref65.angle, type2 = _ref65.type;
      return {
        userAgent: navigator.userAgent,
        windowWidth: innerWidth,
        windowHeight: innerHeight,
        orientationAngle: angle,
        orientationType: type2
      };
    }
    function getOrientation(_ref66) {
      var screen = _ref66.screen;
      return screen.orientation || screen.msOrientation || screen.mozOrientation;
    }
    function createFrameContext(frame, _ref67) {
      var focusable = _ref67.focusable, page = _ref67.page;
      return {
        node: frame,
        include: [],
        exclude: [],
        initiator: false,
        focusable: focusable && frameFocusable(frame),
        size: getBoundingSize(frame),
        page: page
      };
    }
    function frameFocusable(frame) {
      var tabIndex = frame.getAttribute('tabindex');
      if (!tabIndex) {
        return true;
      }
      var _int = parseInt(tabIndex, 10);
      return isNaN(_int) || _int >= 0;
    }
    function getBoundingSize(domNode) {
      var width = parseInt(domNode.getAttribute('width'), 10);
      var height = parseInt(domNode.getAttribute('height'), 10);
      if (isNaN(width) || isNaN(height)) {
        var rect = domNode.getBoundingClientRect();
        width = isNaN(width) ? rect.width : width;
        height = isNaN(height) ? rect.height : height;
      }
      return {
        width: width,
        height: height
      };
    }
    function normalizeContext(contextSpec) {
      if (isContextObject(contextSpec)) {
        var msg = ' must be used inside include or exclude. It should not be on the same object.';
        assert2(!objectHasOwn(contextSpec, 'fromFrames'), 'fromFrames' + msg);
        assert2(!objectHasOwn(contextSpec, 'fromShadowDom'), 'fromShadowDom' + msg);
      } else if (isContextProp(contextSpec)) {
        contextSpec = {
          include: contextSpec,
          exclude: []
        };
      } else {
        return {
          include: [ document ],
          exclude: []
        };
      }
      var include = normalizeContextList(contextSpec.include);
      if (include.length === 0) {
        include.push(document);
      }
      var exclude = normalizeContextList(contextSpec.exclude);
      return {
        include: include,
        exclude: exclude
      };
    }
    function isContextSpec(contextSpec) {
      return isContextObject(contextSpec) || isContextProp(contextSpec);
    }
    function normalizeContextList() {
      var selectorList = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var normalizedList = [];
      if (!isArrayLike(selectorList)) {
        selectorList = [ selectorList ];
      }
      for (var _i21 = 0; _i21 < selectorList.length; _i21++) {
        var normalizedSelector = normalizeContextSelector(selectorList[_i21]);
        if (normalizedSelector) {
          normalizedList.push(normalizedSelector);
        }
      }
      return normalizedList;
    }
    function normalizeContextSelector(selector) {
      if (selector instanceof window.Node) {
        return selector;
      }
      if (typeof selector === 'string') {
        return [ selector ];
      }
      if (isLabelledFramesSelector(selector)) {
        assertLabelledFrameSelector(selector);
        selector = selector.fromFrames;
      } else if (isLabelledShadowDomSelector(selector)) {
        selector = [ selector ];
      }
      return normalizeFrameSelectors(selector);
    }
    function normalizeFrameSelectors(frameSelectors) {
      if (!Array.isArray(frameSelectors)) {
        return;
      }
      var normalizedSelectors = [];
      var _iterator11 = _createForOfIteratorHelper(frameSelectors), _step11;
      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done; ) {
          var selector = _step11.value;
          if (isLabelledShadowDomSelector(selector)) {
            assertLabelledShadowDomSelector(selector);
            selector = selector.fromShadowDom;
          }
          if (typeof selector !== 'string' && !isShadowSelector(selector)) {
            return;
          }
          normalizedSelectors.push(selector);
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }
      return normalizedSelectors;
    }
    function isContextObject(contextSpec) {
      return [ 'include', 'exclude' ].some(function(prop) {
        return objectHasOwn(contextSpec, prop) && isContextProp(contextSpec[prop]);
      });
    }
    function isContextProp(contextList) {
      return typeof contextList === 'string' || contextList instanceof window.Node || isLabelledFramesSelector(contextList) || isLabelledShadowDomSelector(contextList) || isArrayLike(contextList);
    }
    function isLabelledFramesSelector(selector) {
      return objectHasOwn(selector, 'fromFrames');
    }
    function isLabelledShadowDomSelector(selector) {
      return objectHasOwn(selector, 'fromShadowDom');
    }
    function assertLabelledFrameSelector(selector) {
      assert2(Array.isArray(selector.fromFrames), 'fromFrames property must be an array');
      assert2(selector.fromFrames.every(function(fromFrameSelector) {
        return !objectHasOwn(fromFrameSelector, 'fromFrames');
      }), 'Invalid context; fromFrames selector must be appended, rather than nested');
      assert2(!objectHasOwn(selector, 'fromShadowDom'), 'fromFrames and fromShadowDom cannot be used on the same object');
    }
    function assertLabelledShadowDomSelector(selector) {
      assert2(Array.isArray(selector.fromShadowDom), 'fromShadowDom property must be an array');
      assert2(selector.fromShadowDom.every(function(fromShadowDomSelector) {
        return !objectHasOwn(fromShadowDomSelector, 'fromFrames');
      }), 'shadow selector must be inside fromFrame instead');
      assert2(selector.fromShadowDom.every(function(fromShadowDomSelector) {
        return !objectHasOwn(fromShadowDomSelector, 'fromShadowDom');
      }), 'fromShadowDom selector must be appended, rather than nested');
    }
    function isShadowSelector(selector) {
      return Array.isArray(selector) && selector.every(function(str) {
        return typeof str === 'string';
      });
    }
    function isArrayLike(arr) {
      return arr && _typeof(arr) === 'object' && typeof arr.length === 'number' && arr instanceof window.Node === false;
    }
    function assert2(bool, str) {
      assert_default(bool, 'Invalid context; '.concat(str, '\nSee: https://github.com/dequelabs/axe-core/blob/master/doc/context.md'));
    }
    function objectHasOwn(obj, prop) {
      if (!obj || _typeof(obj) !== 'object') {
        return false;
      }
      return Object.prototype.hasOwnProperty.call(obj, prop);
    }
    function parseSelectorArray(context, type2) {
      var result = [];
      for (var _i22 = 0, l = context[type2].length; _i22 < l; _i22++) {
        var item = context[type2][_i22];
        if (item instanceof window.Node) {
          if (item.documentElement instanceof window.Node) {
            result.push(context.flatTree[0]);
          } else {
            result.push(get_node_from_tree_default(item));
          }
        } else if (item && item.length) {
          if (item.length > 1) {
            pushUniqueFrameSelector(context, type2, item);
          } else {
            var nodeList = _shadowSelectAll(item[0]);
            result.push.apply(result, _toConsumableArray(nodeList.map(function(node) {
              return get_node_from_tree_default(node);
            })));
          }
        }
      }
      return result.filter(function(r) {
        return r;
      });
    }
    function pushUniqueFrameSelector(context, type2, selectorArray) {
      context.frames = context.frames || [];
      var frameSelector = selectorArray.shift();
      var frames = _shadowSelectAll(frameSelector);
      frames.forEach(function(frame) {
        var frameContext = context.frames.find(function(result) {
          return result.node === frame;
        });
        if (!frameContext) {
          frameContext = createFrameContext(frame, context);
          context.frames.push(frameContext);
        }
        frameContext[type2].push(selectorArray);
      });
    }
    function Context(spec, flatTree) {
      var _spec, _spec2, _spec3, _spec4, _this5 = this;
      spec = _clone(spec);
      this.frames = [];
      this.page = typeof ((_spec = spec) === null || _spec === void 0 ? void 0 : _spec.page) === 'boolean' ? spec.page : void 0;
      this.initiator = typeof ((_spec2 = spec) === null || _spec2 === void 0 ? void 0 : _spec2.initiator) === 'boolean' ? spec.initiator : true;
      this.focusable = typeof ((_spec3 = spec) === null || _spec3 === void 0 ? void 0 : _spec3.focusable) === 'boolean' ? spec.focusable : true;
      this.size = _typeof((_spec4 = spec) === null || _spec4 === void 0 ? void 0 : _spec4.size) === 'object' ? spec.size : {};
      spec = normalizeContext(spec);
      this.flatTree = flatTree !== null && flatTree !== void 0 ? flatTree : _getFlattenedTree(getRootNode2(spec));
      this.exclude = spec.exclude;
      this.include = spec.include;
      this.include = parseSelectorArray(this, 'include');
      this.exclude = parseSelectorArray(this, 'exclude');
      _select('frame, iframe', this).forEach(function(frame) {
        if (_isNodeInContext(frame, _this5)) {
          pushUniqueFrame(_this5, frame.actualNode);
        }
      });
      if (typeof this.page === 'undefined') {
        this.page = isPageContext(this);
        this.frames.forEach(function(frame) {
          frame.page = _this5.page;
        });
      }
      validateContext(this);
      if (!Array.isArray(this.include)) {
        this.include = Array.from(this.include);
      }
      this.include.sort(node_sorter_default);
    }
    function pushUniqueFrame(context, frame) {
      if (!_isVisibleToScreenReaders(frame) || find_by_default(context.frames, 'node', frame)) {
        return;
      }
      context.frames.push(createFrameContext(frame, context));
    }
    function isPageContext(_ref68) {
      var include = _ref68.include;
      return include.length === 1 && include[0].actualNode === document.documentElement;
    }
    function validateContext(context) {
      if (context.include.length === 0 && context.frames.length === 0) {
        var env = _respondable.isInFrame() ? 'frame' : 'page';
        throw new Error('No elements found for include in ' + env + ' Context');
      }
    }
    function getRootNode2(_ref69) {
      var include = _ref69.include, exclude = _ref69.exclude;
      var selectors = Array.from(include).concat(Array.from(exclude));
      for (var _i23 = 0; _i23 < selectors.length; _i23++) {
        var item = selectors[_i23];
        if (item instanceof window.Element) {
          return item.ownerDocument.documentElement;
        }
        if (item instanceof window.Document) {
          return item.documentElement;
        }
      }
      return document.documentElement;
    }
    function _getFrameContexts(context) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (options.iframes === false) {
        return [];
      }
      var _Context = new Context(context), frames = _Context.frames;
      return frames.map(function(_ref70) {
        var node = _ref70.node, frameContext = _objectWithoutProperties(_ref70, _excluded14);
        frameContext.initiator = false;
        var frameSelector = _getAncestry(node);
        return {
          frameSelector: frameSelector,
          frameContext: frameContext
        };
      });
    }
    function _getRule(ruleId) {
      var rule = axe._audit.rules.find(function(_ref71) {
        var id = _ref71.id;
        return id === ruleId;
      });
      if (!rule) {
        throw new Error('Cannot find rule by id: '.concat(ruleId));
      }
      return rule;
    }
    function getScroll(elm) {
      var buffer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var overflowX = elm.scrollWidth > elm.clientWidth + buffer;
      var overflowY = elm.scrollHeight > elm.clientHeight + buffer;
      if (!(overflowX || overflowY)) {
        return;
      }
      var style = window.getComputedStyle(elm);
      var scrollableX = isScrollable(style, 'overflow-x');
      var scrollableY = isScrollable(style, 'overflow-y');
      if (overflowX && scrollableX || overflowY && scrollableY) {
        return {
          elm: elm,
          top: elm.scrollTop,
          left: elm.scrollLeft
        };
      }
    }
    function isScrollable(style, prop) {
      var overflowProp = style.getPropertyValue(prop);
      return [ 'scroll', 'auto' ].includes(overflowProp);
    }
    var get_scroll_default = memoize_default(getScroll);
    function getElmScrollRecursive(root) {
      return Array.from(root.children || root.childNodes || []).reduce(function(scrolls, elm) {
        var scroll = get_scroll_default(elm);
        if (scroll) {
          scrolls.push(scroll);
        }
        return scrolls.concat(getElmScrollRecursive(elm));
      }, []);
    }
    function getScrollState() {
      var win = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;
      var root = win.document.documentElement;
      var windowScroll = [ win.pageXOffset !== void 0 ? {
        elm: win,
        top: win.pageYOffset,
        left: win.pageXOffset
      } : {
        elm: root,
        top: root.scrollTop,
        left: root.scrollLeft
      } ];
      return windowScroll.concat(getElmScrollRecursive(document.body));
    }
    var get_scroll_state_default = getScrollState;
    function _getStandards() {
      return _clone(standards_default);
    }
    function getStyleSheetFactory(dynamicDoc) {
      if (!dynamicDoc) {
        throw new Error('axe.utils.getStyleSheetFactory should be invoked with an argument');
      }
      return function(options) {
        var data = options.data, _options$isCrossOrigi = options.isCrossOrigin, isCrossOrigin = _options$isCrossOrigi === void 0 ? false : _options$isCrossOrigi, shadowId = options.shadowId, root = options.root, priority = options.priority, _options$isLink = options.isLink, isLink = _options$isLink === void 0 ? false : _options$isLink;
        var style = dynamicDoc.createElement('style');
        if (isLink) {
          var text = dynamicDoc.createTextNode('@import "'.concat(data.href, '"'));
          style.appendChild(text);
        } else {
          style.appendChild(dynamicDoc.createTextNode(data));
        }
        dynamicDoc.head.appendChild(style);
        return {
          sheet: style.sheet,
          isCrossOrigin: isCrossOrigin,
          shadowId: shadowId,
          root: root,
          priority: priority
        };
      };
    }
    var get_stylesheet_factory_default = getStyleSheetFactory;
    var styleSheet;
    function injectStyle(style) {
      if (styleSheet && styleSheet.parentNode) {
        if (styleSheet.styleSheet === void 0) {
          styleSheet.appendChild(document.createTextNode(style));
        } else {
          styleSheet.styleSheet.cssText += style;
        }
        return styleSheet;
      }
      if (!style) {
        return;
      }
      var head = document.head || document.getElementsByTagName('head')[0];
      styleSheet = document.createElement('style');
      styleSheet.type = 'text/css';
      if (styleSheet.styleSheet === void 0) {
        styleSheet.appendChild(document.createTextNode(style));
      } else {
        styleSheet.styleSheet.cssText = style;
      }
      head.appendChild(styleSheet);
      return styleSheet;
    }
    var inject_style_default = injectStyle;
    function isHidden(el, recursed) {
      var node = get_node_from_tree_default(el);
      if (el.nodeType === 9) {
        return false;
      }
      if (el.nodeType === 11) {
        el = el.host;
      }
      if (node && node._isHidden !== null) {
        return node._isHidden;
      }
      var style = window.getComputedStyle(el, null);
      if (!style || !el.parentNode || style.getPropertyValue('display') === 'none' || !recursed && style.getPropertyValue('visibility') === 'hidden' || el.getAttribute('aria-hidden') === 'true') {
        return true;
      }
      var parent = el.assignedSlot ? el.assignedSlot : el.parentNode;
      var hidden = isHidden(parent, true);
      if (node) {
        node._isHidden = hidden;
      }
      return hidden;
    }
    var is_hidden_default = isHidden;
    function isHtmlElement(node) {
      var _node$props$nodeName, _node$props;
      var nodeName2 = (_node$props$nodeName = (_node$props = node.props) === null || _node$props === void 0 ? void 0 : _node$props.nodeName) !== null && _node$props$nodeName !== void 0 ? _node$props$nodeName : node.nodeName.toLowerCase();
      if (node.namespaceURI === 'http://www.w3.org/2000/svg') {
        return false;
      }
      return !!standards_default.htmlElms[nodeName2];
    }
    var is_html_element_default = isHtmlElement;
    function _isNodeInContext(node, _ref72) {
      var _ref72$include = _ref72.include, include = _ref72$include === void 0 ? [] : _ref72$include, _ref72$exclude = _ref72.exclude, exclude = _ref72$exclude === void 0 ? [] : _ref72$exclude;
      var filterInclude = include.filter(function(candidate) {
        return _contains(candidate, node);
      });
      if (filterInclude.length === 0) {
        return false;
      }
      var filterExcluded = exclude.filter(function(candidate) {
        return _contains(candidate, node);
      });
      if (filterExcluded.length === 0) {
        return true;
      }
      var deepestInclude = getDeepest(filterInclude);
      var deepestExclude = getDeepest(filterExcluded);
      return _contains(deepestExclude, deepestInclude);
    }
    function getDeepest(collection) {
      var deepest;
      var _iterator12 = _createForOfIteratorHelper(collection), _step12;
      try {
        for (_iterator12.s(); !(_step12 = _iterator12.n()).done; ) {
          var node = _step12.value;
          if (!deepest || !_contains(node, deepest)) {
            deepest = node;
          }
        }
      } catch (err) {
        _iterator12.e(err);
      } finally {
        _iterator12.f();
      }
      return deepest;
    }
    function _matchAncestry(ancestryA, ancestryB) {
      if (ancestryA.length !== ancestryB.length) {
        return false;
      }
      return ancestryA.every(function(selectorA, ancestorIndex) {
        var selectorB = ancestryB[ancestorIndex];
        if (!Array.isArray(selectorA)) {
          return selectorA === selectorB;
        }
        if (selectorA.length !== selectorB.length) {
          return false;
        }
        return selectorA.every(function(str, selectorIndex) {
          return selectorB[selectorIndex] === str;
        });
      });
    }
    function nodeSorter(nodeA, nodeB) {
      nodeA = nodeA.actualNode || nodeA;
      nodeB = nodeB.actualNode || nodeB;
      if (nodeA === nodeB) {
        return 0;
      }
      if (nodeA.compareDocumentPosition(nodeB) & 4) {
        return -1;
      } else {
        return 1;
      }
    }
    var node_sorter_default = nodeSorter;
    function _nodeLookup(node) {
      if (node instanceof abstract_virtual_node_default) {
        return {
          vNode: node,
          domNode: node.actualNode
        };
      }
      return {
        vNode: get_node_from_tree_default(node),
        domNode: node
      };
    }
    function parseSameOriginStylesheet(sheet, options, priority, importedUrls) {
      var isCrossOrigin = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var rules = Array.from(sheet.cssRules);
      if (!rules) {
        return Promise.resolve();
      }
      var cssImportRules = rules.filter(function(r) {
        return r.type === 3;
      });
      if (!cssImportRules.length) {
        return Promise.resolve({
          isCrossOrigin: isCrossOrigin,
          priority: priority,
          root: options.rootNode,
          shadowId: options.shadowId,
          sheet: sheet
        });
      }
      var cssImportUrlsNotAlreadyImported = cssImportRules.filter(function(rule) {
        return rule.href;
      }).map(function(rule) {
        return rule.href;
      }).filter(function(url) {
        return !importedUrls.includes(url);
      });
      var promises = cssImportUrlsNotAlreadyImported.map(function(importUrl, cssRuleIndex) {
        var newPriority = [].concat(_toConsumableArray(priority), [ cssRuleIndex ]);
        var isCrossOriginRequest = /^https?:\/\/|^\/\//i.test(importUrl);
        return parse_crossorigin_stylesheet_default(importUrl, options, newPriority, importedUrls, isCrossOriginRequest);
      });
      var nonImportCSSRules = rules.filter(function(r) {
        return r.type !== 3;
      });
      if (!nonImportCSSRules.length) {
        return Promise.all(promises);
      }
      promises.push(Promise.resolve(options.convertDataToStylesheet({
        data: nonImportCSSRules.map(function(rule) {
          return rule.cssText;
        }).join(),
        isCrossOrigin: isCrossOrigin,
        priority: priority,
        root: options.rootNode,
        shadowId: options.shadowId
      })));
      return Promise.all(promises);
    }
    var parse_sameorigin_stylesheet_default = parseSameOriginStylesheet;
    function parseStylesheet(sheet, options, priority, importedUrls) {
      var isCrossOrigin = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var isSameOrigin = isSameOriginStylesheet(sheet);
      if (isSameOrigin) {
        return parse_sameorigin_stylesheet_default(sheet, options, priority, importedUrls, isCrossOrigin);
      }
      return parse_crossorigin_stylesheet_default(sheet.href, options, priority, importedUrls, true);
    }
    function isSameOriginStylesheet(sheet) {
      try {
        var rules = sheet.cssRules;
        if (!rules && sheet.href) {
          return false;
        }
        return true;
      } catch (e) {
        return false;
      }
    }
    var parse_stylesheet_default = parseStylesheet;
    function parseCrossOriginStylesheet(url, options, priority, importedUrls, isCrossOrigin) {
      importedUrls.push(url);
      return new Promise(function(resolve, reject) {
        var request = new window.XMLHttpRequest();
        request.open('GET', url);
        request.timeout = constants_default.preload.timeout;
        request.addEventListener('error', reject);
        request.addEventListener('timeout', reject);
        request.addEventListener('loadend', function(event) {
          if (event.loaded && request.responseText) {
            return resolve(request.responseText);
          }
          reject(request.responseText);
        });
        request.send();
      }).then(function(data) {
        var result = options.convertDataToStylesheet({
          data: data,
          isCrossOrigin: isCrossOrigin,
          priority: priority,
          root: options.rootNode,
          shadowId: options.shadowId
        });
        return parse_stylesheet_default(result.sheet, options, priority, importedUrls, result.isCrossOrigin);
      });
    }
    var parse_crossorigin_stylesheet_default = parseCrossOriginStylesheet;
    var performanceTimer = function() {
      function now() {
        if (window.performance && window.performance) {
          return window.performance.now();
        }
      }
      var originalTime = null;
      var lastRecordedTime = now();
      return {
        start: function start() {
          this.mark('mark_axe_start');
        },
        end: function end() {
          this.mark('mark_axe_end');
          this.measure('axe', 'mark_axe_start', 'mark_axe_end');
          this.logMeasures('axe');
        },
        auditStart: function auditStart() {
          this.mark('mark_audit_start');
        },
        auditEnd: function auditEnd() {
          this.mark('mark_audit_end');
          this.measure('audit_start_to_end', 'mark_audit_start', 'mark_audit_end');
          this.logMeasures();
        },
        mark: function mark(markName) {
          if (window.performance && window.performance.mark !== void 0) {
            window.performance.mark(markName);
          }
        },
        measure: function measure(measureName, startMark, endMark) {
          if (window.performance && window.performance.measure !== void 0) {
            window.performance.measure(measureName, startMark, endMark);
          }
        },
        logMeasures: function logMeasures(measureName) {
          function logMeasure(req2) {
            log_default('Measure ' + req2.name + ' took ' + req2.duration + 'ms');
          }
          if (window.performance && window.performance.getEntriesByType !== void 0) {
            var axeStart = window.performance.getEntriesByName('mark_axe_start')[0];
            var measures = window.performance.getEntriesByType('measure').filter(function(measure) {
              return measure.startTime >= axeStart.startTime;
            });
            for (var i = 0; i < measures.length; ++i) {
              var req = measures[i];
              if (req.name === measureName) {
                logMeasure(req);
                return;
              }
              logMeasure(req);
            }
          }
        },
        timeElapsed: function timeElapsed() {
          return now() - lastRecordedTime;
        },
        reset: function reset() {
          if (!originalTime) {
            originalTime = now();
          }
          lastRecordedTime = now();
        }
      };
    }();
    var performance_timer_default = performanceTimer;
    if (typeof Object.assign !== 'function') {
      (function() {
        Object.assign = function(target) {
          if (target === void 0 || target === null) {
            throw new TypeError('Cannot convert undefined or null to object');
          }
          var output = Object(target);
          for (var index = 1; index < arguments.length; index++) {
            var source = arguments[index];
            if (source !== void 0 && source !== null) {
              for (var nextKey in source) {
                if (source.hasOwnProperty(nextKey)) {
                  output[nextKey] = source[nextKey];
                }
              }
            }
          }
          return output;
        };
      })();
    }
    if (!Array.prototype.find) {
      Object.defineProperty(Array.prototype, 'find', {
        value: function value(predicate) {
          if (this === null) {
            throw new TypeError('Array.prototype.find called on null or undefined');
          }
          if (typeof predicate !== 'function') {
            throw new TypeError('predicate must be a function');
          }
          var list = Object(this);
          var length = list.length >>> 0;
          var thisArg = arguments[1];
          var value;
          for (var i = 0; i < length; i++) {
            value = list[i];
            if (predicate.call(thisArg, value, i, list)) {
              return value;
            }
          }
          return void 0;
        }
      });
    }
    if (!Array.prototype.findIndex) {
      Object.defineProperty(Array.prototype, 'findIndex', {
        value: function value(predicate, thisArg) {
          if (this === null) {
            throw new TypeError('Array.prototype.find called on null or undefined');
          }
          if (typeof predicate !== 'function') {
            throw new TypeError('predicate must be a function');
          }
          var list = Object(this);
          var length = list.length >>> 0;
          var value;
          for (var i = 0; i < length; i++) {
            value = list[i];
            if (predicate.call(thisArg, value, i, list)) {
              return i;
            }
          }
          return -1;
        }
      });
    }
    function _pollyfillElementsFromPoint() {
      if (document.elementsFromPoint) {
        return document.elementsFromPoint;
      }
      if (document.msElementsFromPoint) {
        return document.msElementsFromPoint;
      }
      var usePointer = function() {
        var element = document.createElement('x');
        element.style.cssText = 'pointer-events:auto';
        return element.style.pointerEvents === 'auto';
      }();
      var cssProp = usePointer ? 'pointer-events' : 'visibility';
      var cssDisableVal = usePointer ? 'none' : 'hidden';
      var style = document.createElement('style');
      style.innerHTML = usePointer ? '* { pointer-events: all }' : '* { visibility: visible }';
      return function(x, y) {
        var current, i, d2;
        var elements = [];
        var previousPointerEvents = [];
        document.head.appendChild(style);
        while ((current = document.elementFromPoint(x, y)) && elements.indexOf(current) === -1) {
          elements.push(current);
          previousPointerEvents.push({
            value: current.style.getPropertyValue(cssProp),
            priority: current.style.getPropertyPriority(cssProp)
          });
          current.style.setProperty(cssProp, cssDisableVal, 'important');
        }
        if (elements.indexOf(document.documentElement) < elements.length - 1) {
          elements.splice(elements.indexOf(document.documentElement), 1);
          elements.push(document.documentElement);
        }
        for (i = previousPointerEvents.length; !!(d2 = previousPointerEvents[--i]); ) {
          elements[i].style.setProperty(cssProp, d2.value ? d2.value : '', d2.priority);
        }
        document.head.removeChild(style);
        return elements;
      };
    }
    if (typeof window.addEventListener === 'function') {
      document.elementsFromPoint = _pollyfillElementsFromPoint();
    }
    if (!Array.prototype.includes) {
      Object.defineProperty(Array.prototype, 'includes', {
        value: function value(searchElement) {
          var O = Object(this);
          var len = parseInt(O.length, 10) || 0;
          if (len === 0) {
            return false;
          }
          var n2 = parseInt(arguments[1], 10) || 0;
          var k;
          if (n2 >= 0) {
            k = n2;
          } else {
            k = len + n2;
            if (k < 0) {
              k = 0;
            }
          }
          var currentElement;
          while (k < len) {
            currentElement = O[k];
            if (searchElement === currentElement || searchElement !== searchElement && currentElement !== currentElement) {
              return true;
            }
            k++;
          }
          return false;
        }
      });
    }
    if (!Array.prototype.some) {
      Object.defineProperty(Array.prototype, 'some', {
        value: function value(fun) {
          if (this == null) {
            throw new TypeError('Array.prototype.some called on null or undefined');
          }
          if (typeof fun !== 'function') {
            throw new TypeError();
          }
          var t = Object(this);
          var len = t.length >>> 0;
          var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
          for (var i = 0; i < len; i++) {
            if (i in t && fun.call(thisArg, t[i], i, t)) {
              return true;
            }
          }
          return false;
        }
      });
    }
    if (!Array.from) {
      Object.defineProperty(Array, 'from', {
        value: function() {
          var toStr = Object.prototype.toString;
          var isCallable = function isCallable(fn) {
            return typeof fn === 'function' || toStr.call(fn) === '[object Function]';
          };
          var toInteger = function toInteger(value) {
            var number = Number(value);
            if (isNaN(number)) {
              return 0;
            }
            if (number === 0 || !isFinite(number)) {
              return number;
            }
            return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
          };
          var maxSafeInteger = Math.pow(2, 53) - 1;
          var toLength = function toLength(value) {
            var len = toInteger(value);
            return Math.min(Math.max(len, 0), maxSafeInteger);
          };
          return function from(arrayLike) {
            var C = this;
            var items = Object(arrayLike);
            if (arrayLike == null) {
              throw new TypeError('Array.from requires an array-like object - not null or undefined');
            }
            var mapFn = arguments.length > 1 ? arguments[1] : void 0;
            var T;
            if (typeof mapFn !== 'undefined') {
              if (!isCallable(mapFn)) {
                throw new TypeError('Array.from: when provided, the second argument must be a function');
              }
              if (arguments.length > 2) {
                T = arguments[2];
              }
            }
            var len = toLength(items.length);
            var A = isCallable(C) ? Object(new C(len)) : new Array(len);
            var k = 0;
            var kValue;
            while (k < len) {
              kValue = items[k];
              if (mapFn) {
                A[k] = typeof T === 'undefined' ? mapFn(kValue, k) : mapFn.call(T, kValue, k);
              } else {
                A[k] = kValue;
              }
              k += 1;
            }
            A.length = len;
            return A;
          };
        }()
      });
    }
    if (!String.prototype.includes) {
      String.prototype.includes = function(search, start) {
        if (typeof start !== 'number') {
          start = 0;
        }
        if (start + search.length > this.length) {
          return false;
        } else {
          return this.indexOf(search, start) !== -1;
        }
      };
    }
    if (!Array.prototype.flat) {
      Object.defineProperty(Array.prototype, 'flat', {
        configurable: true,
        value: function flat() {
          var depth = isNaN(arguments[0]) ? 1 : Number(arguments[0]);
          return depth ? Array.prototype.reduce.call(this, function(acc, cur) {
            if (Array.isArray(cur)) {
              acc.push.apply(acc, flat.call(cur, depth - 1));
            } else {
              acc.push(cur);
            }
            return acc;
          }, []) : Array.prototype.slice.call(this);
        },
        writable: true
      });
    }
    if (window.Node && !('isConnected' in window.Node.prototype)) {
      Object.defineProperty(window.Node.prototype, 'isConnected', {
        get: function get() {
          return !this.ownerDocument || !(this.ownerDocument.compareDocumentPosition(this) & this.DOCUMENT_POSITION_DISCONNECTED);
        }
      });
    }
    function uniqueArray(arr1, arr2) {
      return arr1.concat(arr2).filter(function(elem, pos, arr) {
        return arr.indexOf(elem) === pos;
      });
    }
    var unique_array_default = uniqueArray;
    function createLocalVariables(vNodes, anyLevel, thisLevel, parentShadowId, recycledLocalVariable) {
      var retVal = recycledLocalVariable || {};
      retVal.vNodes = vNodes;
      retVal.vNodesIndex = 0;
      retVal.anyLevel = anyLevel;
      retVal.thisLevel = thisLevel;
      retVal.parentShadowId = parentShadowId;
      return retVal;
    }
    function matchExpressions(domTree, expressions, filter) {
      var recycledLocalVariables = cache_default.get('qsa.recycledLocalVariables', function() {
        return [];
      });
      var stack = [];
      var vNodes = Array.isArray(domTree) ? domTree : [ domTree ];
      var currentLevel = createLocalVariables(vNodes, expressions, null, domTree[0].shadowId, recycledLocalVariables.pop());
      var result = [];
      while (currentLevel.vNodesIndex < currentLevel.vNodes.length) {
        var _currentLevel$anyLeve, _currentLevel$thisLev;
        var vNode = currentLevel.vNodes[currentLevel.vNodesIndex++];
        var childOnly = null;
        var childAny = null;
        var combinedLength = (((_currentLevel$anyLeve = currentLevel.anyLevel) === null || _currentLevel$anyLeve === void 0 ? void 0 : _currentLevel$anyLeve.length) || 0) + (((_currentLevel$thisLev = currentLevel.thisLevel) === null || _currentLevel$thisLev === void 0 ? void 0 : _currentLevel$thisLev.length) || 0);
        var added = false;
        for (var _i24 = 0; _i24 < combinedLength; _i24++) {
          var _currentLevel$anyLeve2, _currentLevel$anyLeve3, _currentLevel$anyLeve4;
          var exp = _i24 < (((_currentLevel$anyLeve2 = currentLevel.anyLevel) === null || _currentLevel$anyLeve2 === void 0 ? void 0 : _currentLevel$anyLeve2.length) || 0) ? currentLevel.anyLevel[_i24] : currentLevel.thisLevel[_i24 - (((_currentLevel$anyLeve3 = currentLevel.anyLevel) === null || _currentLevel$anyLeve3 === void 0 ? void 0 : _currentLevel$anyLeve3.length) || 0)];
          if ((!exp[0].id || vNode.shadowId === currentLevel.parentShadowId) && _matchesExpression(vNode, exp[0])) {
            if (exp.length === 1) {
              if (!added && (!filter || filter(vNode))) {
                result.push(vNode);
                added = true;
              }
            } else {
              var rest = exp.slice(1);
              if ([ ' ', '>' ].includes(rest[0].combinator) === false) {
                throw new Error('axe.utils.querySelectorAll does not support the combinator: ' + exp[1].combinator);
              }
              if (rest[0].combinator === '>') {
                (childOnly = childOnly || []).push(rest);
              } else {
                (childAny = childAny || []).push(rest);
              }
            }
          }
          if ((!exp[0].id || vNode.shadowId === currentLevel.parentShadowId) && (_currentLevel$anyLeve4 = currentLevel.anyLevel) !== null && _currentLevel$anyLeve4 !== void 0 && _currentLevel$anyLeve4.includes(exp)) {
            (childAny = childAny || []).push(exp);
          }
        }
        if (vNode.children && vNode.children.length) {
          stack.push(currentLevel);
          currentLevel = createLocalVariables(vNode.children, childAny, childOnly, vNode.shadowId, recycledLocalVariables.pop());
        }
        while (currentLevel.vNodesIndex === currentLevel.vNodes.length && stack.length) {
          recycledLocalVariables.push(currentLevel);
          currentLevel = stack.pop();
        }
      }
      return result;
    }
    function querySelectorAllFilter(domTree, selector, filter) {
      domTree = Array.isArray(domTree) ? domTree : [ domTree ];
      var expressions = _convertSelector(selector);
      var nodes = getNodesMatchingExpression(domTree, expressions, filter);
      if (nodes) {
        return nodes;
      }
      return matchExpressions(domTree, expressions, filter);
    }
    var query_selector_all_filter_default = querySelectorAllFilter;
    function preloadCssom(_ref73) {
      var _ref73$treeRoot = _ref73.treeRoot, treeRoot = _ref73$treeRoot === void 0 ? axe._tree[0] : _ref73$treeRoot;
      var rootNodes = getAllRootNodesInTree(treeRoot);
      if (!rootNodes.length) {
        return Promise.resolve();
      }
      var dynamicDoc = document.implementation.createHTMLDocument('Dynamic document for loading cssom');
      var convertDataToStylesheet = get_stylesheet_factory_default(dynamicDoc);
      return getCssomForAllRootNodes(rootNodes, convertDataToStylesheet).then(function(assets) {
        return flattenAssets(assets);
      });
    }
    var preload_cssom_default = preloadCssom;
    function getAllRootNodesInTree(tree) {
      var ids = [];
      var rootNodes = query_selector_all_filter_default(tree, '*', function(node) {
        if (ids.includes(node.shadowId)) {
          return false;
        }
        ids.push(node.shadowId);
        return true;
      }).map(function(node) {
        return {
          shadowId: node.shadowId,
          rootNode: get_root_node_default(node.actualNode)
        };
      });
      return unique_array_default(rootNodes, []);
    }
    function getCssomForAllRootNodes(rootNodes, convertDataToStylesheet) {
      var promises = [];
      rootNodes.forEach(function(_ref74, index) {
        var rootNode = _ref74.rootNode, shadowId = _ref74.shadowId;
        var sheets = getStylesheetsOfRootNode(rootNode, shadowId, convertDataToStylesheet);
        if (!sheets) {
          return Promise.all(promises);
        }
        var rootIndex = index + 1;
        var parseOptions = {
          rootNode: rootNode,
          shadowId: shadowId,
          convertDataToStylesheet: convertDataToStylesheet,
          rootIndex: rootIndex
        };
        var importedUrls = [];
        var p2 = Promise.all(sheets.map(function(sheet, sheetIndex) {
          var priority = [ rootIndex, sheetIndex ];
          return parse_stylesheet_default(sheet, parseOptions, priority, importedUrls);
        }));
        promises.push(p2);
      });
      return Promise.all(promises);
    }
    function flattenAssets(assets) {
      return assets.reduce(function(acc, val) {
        return Array.isArray(val) ? acc.concat(flattenAssets(val)) : acc.concat(val);
      }, []);
    }
    function getStylesheetsOfRootNode(rootNode, shadowId, convertDataToStylesheet) {
      var sheets;
      if (rootNode.nodeType === 11 && shadowId) {
        sheets = getStylesheetsFromDocumentFragment(rootNode, convertDataToStylesheet);
      } else {
        sheets = getStylesheetsFromDocument(rootNode);
      }
      return filterStylesheetsWithSameHref(sheets);
    }
    function getStylesheetsFromDocumentFragment(rootNode, convertDataToStylesheet) {
      return Array.from(rootNode.children).filter(filerStyleAndLinkAttributesInDocumentFragment).reduce(function(out, node) {
        var nodeName2 = node.nodeName.toUpperCase();
        var data = nodeName2 === 'STYLE' ? node.textContent : node;
        var isLink = nodeName2 === 'LINK';
        var stylesheet = convertDataToStylesheet({
          data: data,
          isLink: isLink,
          root: rootNode
        });
        if (stylesheet.sheet) {
          out.push(stylesheet.sheet);
        }
        return out;
      }, []);
    }
    function getStylesheetsFromDocument(rootNode) {
      return Array.from(rootNode.styleSheets).filter(function(sheet) {
        if (!sheet.media) {
          return false;
        }
        return filterMediaIsPrint(sheet.media.mediaText);
      });
    }
    function filerStyleAndLinkAttributesInDocumentFragment(node) {
      var nodeName2 = node.nodeName.toUpperCase();
      var linkHref = node.getAttribute('href');
      var linkRel = node.getAttribute('rel');
      var isLink = nodeName2 === 'LINK' && linkHref && linkRel && node.rel.toUpperCase().includes('STYLESHEET');
      var isStyle = nodeName2 === 'STYLE';
      return isStyle || isLink && filterMediaIsPrint(node.media);
    }
    function filterMediaIsPrint(media) {
      if (!media) {
        return true;
      }
      return !media.toUpperCase().includes('PRINT');
    }
    function filterStylesheetsWithSameHref(sheets) {
      var hrefs = [];
      return sheets.filter(function(sheet) {
        if (!sheet.href) {
          return true;
        }
        if (hrefs.includes(sheet.href)) {
          return false;
        }
        hrefs.push(sheet.href);
        return true;
      });
    }
    function preloadMedia(_ref75) {
      var _ref75$treeRoot = _ref75.treeRoot, treeRoot = _ref75$treeRoot === void 0 ? axe._tree[0] : _ref75$treeRoot;
      var mediaVirtualNodes = query_selector_all_filter_default(treeRoot, 'video, audio', function(_ref76) {
        var actualNode = _ref76.actualNode;
        if (actualNode.hasAttribute('src')) {
          return !!actualNode.getAttribute('src');
        }
        var sourceWithSrc = Array.from(actualNode.getElementsByTagName('source')).filter(function(source) {
          return !!source.getAttribute('src');
        });
        if (sourceWithSrc.length <= 0) {
          return false;
        }
        return true;
      });
      return Promise.all(mediaVirtualNodes.map(function(_ref77) {
        var actualNode = _ref77.actualNode;
        return isMediaElementReady(actualNode);
      }));
    }
    var preload_media_default = preloadMedia;
    function isMediaElementReady(elm) {
      return new Promise(function(resolve) {
        if (elm.readyState > 0) {
          resolve(elm);
        }
        function onMediaReady() {
          elm.removeEventListener('loadedmetadata', onMediaReady);
          resolve(elm);
        }
        elm.addEventListener('loadedmetadata', onMediaReady);
      });
    }
    function _preload(options) {
      var preloadFunctionsMap = {
        cssom: preload_cssom_default,
        media: preload_media_default
      };
      if (!_shouldPreload(options)) {
        return Promise.resolve();
      }
      return new Promise(function(resolve, reject) {
        var _getPreloadConfig2 = _getPreloadConfig(options), assets = _getPreloadConfig2.assets, timeout = _getPreloadConfig2.timeout;
        var preloadTimeout = setTimeout(function() {
          return reject(new Error('Preload assets timed out.'));
        }, timeout);
        Promise.all(assets.map(function(asset) {
          return preloadFunctionsMap[asset](options).then(function(results) {
            return _defineProperty({}, asset, results);
          });
        })).then(function(results) {
          var preloadAssets = results.reduce(function(out, result) {
            return _extends({}, out, result);
          }, {});
          clearTimeout(preloadTimeout);
          resolve(preloadAssets);
        })['catch'](function(err2) {
          clearTimeout(preloadTimeout);
          reject(err2);
        });
      });
    }
    function isValidPreloadObject(preloadObj) {
      return _typeof(preloadObj) === 'object' && Array.isArray(preloadObj.assets);
    }
    function _shouldPreload(options) {
      if (!options || options.preload === void 0 || options.preload === null) {
        return true;
      }
      if (typeof options.preload === 'boolean') {
        return options.preload;
      }
      return isValidPreloadObject(options.preload);
    }
    function _getPreloadConfig(options) {
      var _constants_default$pr = constants_default.preload, assets = _constants_default$pr.assets, timeout = _constants_default$pr.timeout;
      var config = {
        assets: assets,
        timeout: timeout
      };
      if (!options.preload) {
        return config;
      }
      if (typeof options.preload === 'boolean') {
        return config;
      }
      var areRequestedAssetsValid = options.preload.assets.every(function(a2) {
        return assets.includes(a2.toLowerCase());
      });
      if (!areRequestedAssetsValid) {
        throw new Error('Requested assets, not supported. Supported assets are: '.concat(assets.join(', '), '.'));
      }
      config.assets = unique_array_default(options.preload.assets.map(function(a2) {
        return a2.toLowerCase();
      }), []);
      if (options.preload.timeout && typeof options.preload.timeout === 'number' && !isNaN(options.preload.timeout)) {
        config.timeout = options.preload.timeout;
      }
      return config;
    }
    function _publishMetaData(ruleResult) {
      var checksData = axe._audit.data.checks || {};
      var rulesData = axe._audit.data.rules || {};
      var rule = find_by_default(axe._audit.rules, 'id', ruleResult.id) || {};
      ruleResult.tags = _clone(rule.tags || []);
      var shouldBeTrue = extender(checksData, true, rule);
      var shouldBeFalse = extender(checksData, false, rule);
      ruleResult.nodes.forEach(function(detail) {
        detail.any.forEach(shouldBeTrue);
        detail.all.forEach(shouldBeTrue);
        detail.none.forEach(shouldBeFalse);
      });
      extend_meta_data_default(ruleResult, _clone(rulesData[ruleResult.id] || {}));
    }
    function getIncompleteReason(checkData, messages) {
      function getDefaultMsg(message) {
        if (message.incomplete && message.incomplete['default']) {
          return message.incomplete['default'];
        } else {
          return incompleteFallbackMessage();
        }
      }
      if (checkData && checkData.missingData) {
        try {
          var msg = messages.incomplete[checkData.missingData[0].reason];
          if (!msg) {
            throw new Error();
          }
          return msg;
        } catch (e) {
          if (typeof checkData.missingData === 'string') {
            return messages.incomplete[checkData.missingData];
          } else {
            return getDefaultMsg(messages);
          }
        }
      } else if (checkData && checkData.messageKey) {
        return messages.incomplete[checkData.messageKey];
      } else {
        return getDefaultMsg(messages);
      }
    }
    function extender(checksData, shouldBeTrue, rule) {
      return function(check) {
        var sourceData = checksData[check.id] || {};
        var messages = sourceData.messages || {};
        var data = Object.assign({}, sourceData);
        delete data.messages;
        if (!rule.reviewOnFail && check.result === void 0) {
          if (_typeof(messages.incomplete) === 'object' && !Array.isArray(check.data)) {
            data.message = getIncompleteReason(check.data, messages);
          }
          if (!data.message) {
            data.message = messages.incomplete;
          }
        } else {
          data.message = check.result === shouldBeTrue ? messages.pass : messages.fail;
        }
        if (typeof data.message !== 'function') {
          data.message = process_message_default(data.message, check.data);
        }
        extend_meta_data_default(check, data);
      };
    }
    function querySelectorAll(domTree, selector) {
      return query_selector_all_filter_default(domTree, selector);
    }
    var query_selector_all_default = querySelectorAll;
    function matchTags(rule, runOnly) {
      var include, exclude, matching;
      var defaultExclude = axe._audit && axe._audit.tagExclude ? axe._audit.tagExclude : [];
      if (runOnly.hasOwnProperty('include') || runOnly.hasOwnProperty('exclude')) {
        include = runOnly.include || [];
        include = Array.isArray(include) ? include : [ include ];
        exclude = runOnly.exclude || [];
        exclude = Array.isArray(exclude) ? exclude : [ exclude ];
        exclude = exclude.concat(defaultExclude.filter(function(tag) {
          return include.indexOf(tag) === -1;
        }));
      } else {
        include = Array.isArray(runOnly) ? runOnly : [ runOnly ];
        exclude = defaultExclude.filter(function(tag) {
          return include.indexOf(tag) === -1;
        });
      }
      matching = include.some(function(tag) {
        return rule.tags.indexOf(tag) !== -1;
      });
      if (matching || include.length === 0 && rule.enabled !== false) {
        return exclude.every(function(tag) {
          return rule.tags.indexOf(tag) === -1;
        });
      } else {
        return false;
      }
    }
    function ruleShouldRun(rule, context, options) {
      var runOnly = options.runOnly || {};
      var ruleOptions = (options.rules || {})[rule.id];
      if (rule.pageLevel && !context.page) {
        return false;
      } else if (runOnly.type === 'rule') {
        return runOnly.values.indexOf(rule.id) !== -1;
      } else if (ruleOptions && typeof ruleOptions.enabled === 'boolean') {
        return ruleOptions.enabled;
      } else if (runOnly.type === 'tag' && runOnly.values) {
        return matchTags(rule, runOnly.values);
      } else {
        return matchTags(rule, []);
      }
    }
    var rule_should_run_default = ruleShouldRun;
    function _filterHtmlAttrs(element, filterAttrs) {
      if (!filterAttrs) {
        return element;
      }
      var node = element.cloneNode(false);
      var attributes2 = get_node_attributes_default(node);
      if (node.nodeType === 1) {
        var outerHTML = node.outerHTML;
        node = cache_default.get(outerHTML, function() {
          return setNodeAttributes(node, attributes2, element, filterAttrs);
        });
      } else {
        node = setNodeAttributes(node, attributes2, element, filterAttrs);
      }
      Array.from(element.childNodes).forEach(function(child) {
        node.appendChild(_filterHtmlAttrs(child, filterAttrs));
      });
      return node;
    }
    function setNodeAttributes(node, attributes2, element, filterAttrs) {
      if (!attributes2) {
        return node;
      }
      node = document.createElement(node.nodeName);
      Array.from(attributes2).forEach(function(attr) {
        if (!attributeMatches(element, attr.name, filterAttrs)) {
          node.setAttribute(attr.name, attr.value);
        }
      });
      return node;
    }
    function attributeMatches(node, attrName, filterAttrs) {
      if (typeof filterAttrs[attrName] === 'undefined') {
        return false;
      }
      if (filterAttrs[attrName] === true) {
        return true;
      }
      return element_matches_default(node, filterAttrs[attrName]);
    }
    function _select(selector, context) {
      var result = [];
      var candidate;
      if (axe._selectCache) {
        for (var j = 0, l = axe._selectCache.length; j < l; j++) {
          var item = axe._selectCache[j];
          if (item.selector === selector) {
            return item.result;
          }
        }
      }
      var outerIncludes = getOuterIncludes(context.include);
      var isInContext = getContextFilter(context);
      for (var _i25 = 0; _i25 < outerIncludes.length; _i25++) {
        candidate = outerIncludes[_i25];
        var nodes = query_selector_all_filter_default(candidate, selector, isInContext);
        result = mergeArrayUniques(result, nodes);
      }
      if (axe._selectCache) {
        axe._selectCache.push({
          selector: selector,
          result: result
        });
      }
      return result;
    }
    function getOuterIncludes(includes) {
      return includes.reduce(function(res, el) {
        if (!res.length || !_contains(res[res.length - 1], el)) {
          res.push(el);
        }
        return res;
      }, []);
    }
    function getContextFilter(context) {
      if (!context.exclude || context.exclude.length === 0) {
        return null;
      }
      return function(node) {
        return _isNodeInContext(node, context);
      };
    }
    function mergeArrayUniques(arr1, arr2) {
      if (arr1.length === 0) {
        return arr2;
      }
      if (arr1.length < arr2.length) {
        var temp = arr1;
        arr1 = arr2;
        arr2 = temp;
      }
      for (var _i26 = 0, l = arr2.length; _i26 < l; _i26++) {
        if (!arr1.includes(arr2[_i26])) {
          arr1.push(arr2[_i26]);
        }
      }
      return arr1;
    }
    function setScroll(elm, top, left) {
      if (elm === window) {
        return elm.scroll(left, top);
      } else {
        elm.scrollTop = top;
        elm.scrollLeft = left;
      }
    }
    function setScrollState(scrollState) {
      scrollState.forEach(function(_ref79) {
        var elm = _ref79.elm, top = _ref79.top, left = _ref79.left;
        return setScroll(elm, top, left);
      });
    }
    var set_scroll_state_default = setScrollState;
    function _shadowSelect(selectors) {
      var selectorArr = Array.isArray(selectors) ? _toConsumableArray(selectors) : [ selectors ];
      return selectRecursive(selectorArr, document);
    }
    function selectRecursive(selectors, doc) {
      var selectorStr = selectors.shift();
      var elm = selectorStr ? doc.querySelector(selectorStr) : null;
      if (selectors.length === 0) {
        return elm;
      }
      if (!(elm !== null && elm !== void 0 && elm.shadowRoot)) {
        return null;
      }
      return selectRecursive(selectors, elm.shadowRoot);
    }
    function _shadowSelectAll(selectors) {
      var doc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;
      var selectorArr = Array.isArray(selectors) ? _toConsumableArray(selectors) : [ selectors ];
      if (selectors.length === 0) {
        return [];
      }
      return selectAllRecursive(selectorArr, doc);
    }
    function selectAllRecursive(_ref80, doc) {
      var _ref81 = _toArray(_ref80), selectorStr = _ref81[0], restSelector = _ref81.slice(1);
      var elms = doc.querySelectorAll(selectorStr);
      if (restSelector.length === 0) {
        return Array.from(elms);
      }
      var selected = [];
      var _iterator13 = _createForOfIteratorHelper(elms), _step13;
      try {
        for (_iterator13.s(); !(_step13 = _iterator13.n()).done; ) {
          var elm = _step13.value;
          if (elm !== null && elm !== void 0 && elm.shadowRoot) {
            selected.push.apply(selected, _toConsumableArray(selectAllRecursive(restSelector, elm.shadowRoot)));
          }
        }
      } catch (err) {
        _iterator13.e(err);
      } finally {
        _iterator13.f();
      }
      return selected;
    }
    function validInputTypes() {
      return [ 'hidden', 'text', 'search', 'tel', 'url', 'email', 'password', 'date', 'month', 'week', 'time', 'datetime-local', 'number', 'range', 'color', 'checkbox', 'radio', 'file', 'submit', 'image', 'reset', 'button' ];
    }
    var valid_input_type_default = validInputTypes;
    var langs = [ , [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, 1, 1, , 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, , , , , , 1, 1, 1, 1, , , 1, 1, 1, , 1, , 1, , 1, 1 ], [ 1, 1, 1, , 1, 1, , 1, 1, 1, , 1, , , 1, 1, 1, , , 1, 1, 1, , , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , , , , 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1 ], [ , 1, , , , , , 1, , 1, , , , , 1, , 1, , , , 1, 1, , 1, , , 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, 1, 1, 1, , , 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, 1, , , 1, , , , , 1, 1, 1, , 1, , 1, , 1, , , , , , 1 ], [ 1, , 1, 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, , 1, , 1, , , , , 1, , 1, 1, 1, 1, 1, , , , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, , 1, , 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , 1, , , 1, , 1, , , , 1, 1, 1, , , , , , , , , , , 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1 ], [ 1, 1, 1, 1, 1, , , 1, , , 1, , , 1, 1, 1, , , , , 1, , , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1 ], [ , 1, , 1, 1, 1, , 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, , , 1, 1, , , , , , 1, 1 ], [ 1, 1, 1, , , , , 1, , , , 1, 1, , 1, , , , , , 1, , , , , 1 ], [ , 1, , , 1, , , 1, , , , , , 1 ], [ , 1, , 1, , , , 1, , , , 1 ], [ 1, , 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , , 1, , , 1, , 1, 1, , 1, , 1, , , , , 1, , 1 ], [ , 1, , , , 1, , , 1, 1, , 1, , 1, 1, 1, 1, , 1, 1, , , 1, , , 1 ], [ , 1, 1, , , , , , 1, , , , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], [ , 1, , 1, 1, 1, , , 1, 1, 1, 1, 1, 1, , 1, , , , , 1, 1, , 1, , 1 ], [ , 1, , 1, , 1, , 1, , 1, , 1, 1, 1, 1, 1, , , 1, 1, 1 ], [ , 1, 1, 1, , , , 1, 1, 1, , 1, 1, , , 1, 1, , 1, 1, 1, 1, , 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, , 1, 1, 1, , 1, , , , , 1, 1, 1, , , 1, , 1, , , 1, 1 ], [ , , , , 1, , , , , , , , , , , , , , , , , 1 ], [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, , 1, 1, 1, , 1, 1, , , , 1, 1, 1, 1, 1, , , 1, 1, 1, , , , , 1 ], [ 1, 1, 1, 1, , , , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , , , , , , 1, , , , , , , 1 ], [ , 1, 1, , 1, 1, , 1, , , , , , , , , , , , , 1 ], , [ 1, 1, 1, , , , , , , , , , , , , 1 ], [ , , , , , , , , 1, , , 1, , , 1, 1, , , , , 1 ] ], [ , [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ , , , 1, , , , , , , , , , , , , , , 1 ], [ , 1, , , 1, 1, , 1, , 1, 1, , , , 1, 1, , , 1, 1, , , , 1 ], [ 1, , , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, , , 1, , , , 1 ], , [ , 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, , 1, 1, , , 1, 1, 1, 1, , 1, 1, , 1 ], [ , 1, , , 1, , , 1, , 1, , , 1, 1, 1, 1, , , 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, , , 1, , , 1, , 1 ], [ , 1, , , , , , , , , , 1, 1, , , , , , 1, 1, , , , , 1 ], [ , , , , , , , 1, , , , 1, , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, , , , 1, 1, 1, 1, 1, , , 1, 1, , 1, 1, 1, 1, 1 ], [ , 1, , , 1, 1, , 1, , 1, 1, 1, , , 1, 1, , , 1, , 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, , 1, 1, , 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ , , , , , , , , , , , , , , , , 1 ], , [ , 1, 1, 1, 1, 1, , 1, 1, 1, , , 1, , 1, 1, , 1, 1, 1, 1, 1, , 1, , 1 ], [ , , 1, , , 1, , , 1, 1, , , 1, , 1, 1, , 1 ], [ , 1, 1, , 1, , , , 1, 1, , 1, , 1, 1, 1, 1, , 1, 1, 1, 1, , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ 1, 1 ], [ , 1, , , , , , , , , , 1, 1, , , , , , 1, 1, , 1, , 1, , 1, 1 ], , [ , 1, 1, , 1, , , 1, , 1, , , , 1, 1, 1, , , , , , 1, , , , 1 ], [ 1, 1, , , 1, 1, , 1, , , , , 1, , 1 ] ], [ , [ , 1 ], [ , , , 1, , , , 1, , , , 1, , , , 1, , , 1, , , 1 ], [ , , , , , , , , , , , , , , , , , , 1, 1, , , , , , 1 ], , [ 1, , , , , 1 ], [ , 1, , , , 1, , , , 1 ], [ , 1, , , , , , , , , , , 1, , , 1, , , , , , , , , 1, 1 ], [ , , , , , , , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , , , 1, , , , 1, , 1 ], [ , 1 ], [ , 1, , 1, , 1, , 1, , 1, , 1, 1, 1, , 1, 1, , 1, , , , , , , 1 ], [ 1, , , , , 1, , , 1, 1, , 1, , 1, , 1, 1, , , , , 1, , , 1 ], [ , 1, 1, , , 1, , 1, , 1, , 1, , 1, 1, 1, 1, , , 1, , 1, , 1, 1, 1 ], [ 1, 1, 1, 1, 1, , 1, , 1, , , , 1, 1, 1, 1, , 1, 1, , , 1, 1, 1, 1 ], [ 1, , , , , , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , 1 ], , [ , 1, , , , , , 1, 1, 1, , 1, , , , 1, , , 1, 1, 1, , , 1 ], [ 1, , , , , 1, , 1, 1, 1, , 1, 1, 1, 1, 1, , 1, , 1, , 1, , , 1, 1 ], [ 1, , 1, 1, , , , , 1, , , , , , 1, 1, , , 1, 1, 1, 1, , , 1, , 1 ], [ 1, , , , , , , , , , , , , , , , , 1 ], [ , , , , , 1, , , 1, , , , , , 1 ], [ , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , , 1 ], [ , 1, , , , , , , , , , , , , , 1 ], [ , 1, , , , 1 ] ], [ , [ 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, , 1, 1, , , 1, 1, 1 ], [ , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , 1 ], , [ , , , , , , , , , , , , , , , , , , 1 ], [ 1, , , , , , , , , 1, , , , 1 ], [ , , , , , , , , , , , , , , , , , , 1 ], , [ 1, 1, , , , 1, 1, , , , , , 1, , , , 1, , 1, , 1, 1, , 1 ], [ 1 ], [ , , , , , , , , , , , 1, , , , , , , , , , , 1 ], [ , 1, , , , , , , 1, 1, , , 1, , 1, , , , 1, , , , , , , 1 ], [ , , , , , , , , , , , , , , , , 1, , , , , 1 ], [ , , 1, , , , , 1, , 1 ], [ 1, , , , 1, , , , , 1, , , , 1, 1, , , , 1, 1, , , , , 1 ], [ , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , 1 ], [ 1, , , 1, 1, , , , , , , 1, , 1, , 1, 1, 1, 1, 1, 1 ], [ , , , , , 1, , , , , , , 1, , , , , , , 1 ], , [ , , 1, 1, 1, 1, 1, , 1, 1, 1, , , 1, 1, , , 1, 1, , 1, 1, 1, , , 1 ], [ , , , , , , , , , , , , , , , , , , 1 ], [ , 1, , , , 1 ], , [ 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , , , 1, 1, 1, 1, , , , , , 1, , 1, , , , 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , , 1 ], [ , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, , 1, , , 1, 1, 1, 1, 1 ], [ , , , , , , , , , , , 1, , , , , , , , , 1, , , , 1 ], [ , 1, 1, , 1, 1, , 1, , , , 1, 1, , 1, 1, , , 1, , 1, 1, , 1 ], [ , 1, , 1, , 1, , , 1, , , 1, 1, , 1, 1, , , 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, , , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , , , , , , , , , 1, , 1, , 1, 1, , , , 1, , , 1 ], [ , 1, , , 1, 1, , , , , , , , , 1, 1, 1, , , , , 1 ], [ 1, , , 1, 1, , , , 1, 1, 1, 1, 1, , , 1, , , 1, , , 1, , 1, , 1 ], [ , 1, 1, , 1, 1, , 1, 1, , , , 1, 1, 1, , , 1, 1, , , 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, , 1, , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, , , , 1, , , , , , , , , 1 ], [ , 1, , , , , , , , 1, , , , , 1, , , , 1, , , 1 ], [ , 1, 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , , , 1, , 1, , , , , 1, 1, 1, 1, 1, , , 1, , , , 1 ], [ , 1, , , , , , , , 1, , , , , , , , , , , , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ 1, 1, , 1, , 1, 1, , , , 1, , 1, 1, 1, 1, 1, , 1, 1, , , , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, , 1, 1, , , 1, 1, , , , 1, , 1, 1, , 1, 1 ], [ , , , , , , , , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, , 1, 1, 1, 1, , 1, , , 1, 1, 1, 1, , , 1, , , , , , , 1 ], [ , 1, , , , , , , , 1, , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1 ], [ , 1, 1, , , , , , , , , , , , 1, 1, , , , , , 1 ], [ , 1, , , , , , , 1 ], [ , , , , , , , , , , , , , , 1, , , , , 1, , , , , , 1 ], [ 1, 1, , , 1, , , 1, 1, 1, , , , 1 ], , [ , , , , , , , , , , , , , 1, , , , , , , , , , 1 ], [ , , , , , , , , , 1, , , , , , , , , 1, , , , , , , 1 ], [ 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1, , , 1, , 1, , , 1, 1 ], [ , , , , , , , , , 1 ], [ , 1, , , , 1, , , , , , 1, , , 1, , , , , 1 ], [ , 1, 1, , 1, 1, , , , , , , , , , , , , , , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , 1, 1, , 1, 1, 1, 1, , , , 1, 1, , , , 1, , 1 ], [ 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, , 1, 1, , 1, 1 ], [ , , , , , , , , , , , , , , , 1, , , , 1 ], , [ 1, 1, , 1, , 1, , , , , , 1, , 1, , 1, 1, , 1, , 1, 1, , 1, 1, , 1 ], [ , , 1, , , , , , 1, , , , 1, , 1, , , , , 1 ], [ 1, , , , , , , , , 1, , , , , , 1, , , , 1, , 1, , , 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , 1, , 1, , , , , , 1, , , 1, , , , , , , , 1 ], [ , 1, , 1, , , , , , , , , , , , 1 ], , [ 1, 1, , , , , , , , , , , , , , , , , , , , , , 1, 1 ], [ 1 ] ], [ , [ 1, , , , , , , , , 1, , , , , 1, , 1, , 1 ], [ , 1, 1, , 1, 1, , 1, 1, 1, , , 1, 1, 1, , , , 1, , , 1, , , , 1 ], [ , 1, , , , , , , 1, , , , 1, , , , , , 1 ], [ 1, 1, 1, 1, 1, 1, , , , 1, , , , , , , , , 1, 1, 1, 1 ], [ 1 ], [ , 1, 1, , , 1, 1, , , , , 1, , 1, , , , , , , , 1, , , , 1 ], [ 1, , 1, , , 1, , 1, , , , , 1, 1, 1, 1, , , , 1, , , , 1 ], [ , , 1, , , , , , , 1, , , , , , , 1, , , , , , , 1 ], [ 1, , , , , , , , , , , , , , 1, , , , 1 ], [ , , , 1, , 1, , , , , 1, , , , 1, 1, , , , 1 ], [ 1, , , , , 1, , , , 1, , 1, 1, , , 1, 1, , 1, 1, 1, , 1, 1, 1, , 1 ], [ , 1, 1, , , , , 1, , 1, , 1, 1, 1, , 1, 1, , , 1, , 1, 1, 1 ], [ , 1, , , , 1, , , , 1, , , 1, , 1, 1, , , 1, 1, , , , , , 1 ], [ 1, , 1, 1, , 1, , 1, 1, , 1, , 1, 1, 1, 1, 1, , , 1, 1, , , , , , 1 ], [ 1, , , , , , , , , , , , , , , , , , 1, , , 1, , 1 ], [ , , , , , , , , , 1, , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , , , 1, , 1 ], [ , 1, , , , 1, , , 1, 1, , 1, , , 1, 1, , , 1, , , 1, , , 1, 1 ], [ 1, 1, , 1, 1, 1, , 1, 1, 1, , 1, , 1, 1, 1, , , 1, , 1, 1 ], [ 1, , 1, 1, 1, 1, , , , 1, , 1, 1, 1, , 1, , , 1, 1, 1, , 1, 1, 1, 1, 1 ], [ 1, , , , , , , , , , , , , 1 ], [ , , 1, , , , , , , , , , , , , , , , , , , , 1 ], [ 1, , , , , , , , , , , 1, , 1, , 1, , , , 1 ], [ , , , 1, , , , , , , , , 1 ], [ , 1, , , , , , , , , , , , , , 1, , , , , , , , , 1 ], [ , , , , , , , , 1, 1, , , , , , , , , 1, , , , , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , , 1, 1, 1 ], [ , , , , , 1, , , , 1, 1, 1, , , 1, 1, , , 1, , 1, 1, , 1 ], [ , , , , , , , , , , , , , , , , , , , 1, 1 ], [ , 1, , , , , , 1, , , , , , , , , , , , , 1 ], [ , , 1, , , 1, , 1, 1, 1, , 1, 1, , 1, , , , 1, , 1, 1 ], , [ , , 1, , , 1, , , , , , 1, , , , 1 ], [ , , , , , , , , , 1, , , , , , , , , , 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, , , 1, 1, , 1, , 1, , , 1, 1, 1, , , 1 ], [ , , , , , 1, , , , , , , , , , , , , 1 ], [ , 1, , , , , , , , , , , , 1, , 1, 1, , 1, , , 1 ], [ , , , , , 1, , , , , , , , , , , , , , 1 ], [ , 1, 1, 1, 1, , , , , 1, , , 1, , 1, , , , 1, 1, , , , 1, 1 ], [ , 1, , , 1, , , 1, , 1, 1, , 1, , , , , , , 1 ], [ , , 1, , 1, , , 1, , , , , , , , , , , 1, 1, , , , 1 ], [ , 1, , , , , , , , , , , , , , , , , 1, , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, , , , , , , , , , , , , , , , 1, , 1, 1 ], [ , , , , , , , , , , , , 1 ], , [ , 1, 1, 1, 1, , , , 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, , 1 ], [ 1, , , , 1, , , , , , , , , , 1 ], [ 1, , , , , , , , , 1 ], , [ , 1, , , , 1, , , , , , , , , , , , , , , , , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, , , , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , 1, 1, 1, 1, , 1, , , , 1, 1, , , 1, 1, , 1 ], [ , 1, 1, , 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , , , , , , , , , , 1 ], [ 1, 1, 1, , , , , 1, 1, 1, , 1, 1, 1, 1, , , 1, 1, , 1, 1, , , , , 1 ], [ , 1, , , , , , , 1, 1, , , 1, 1, 1, , 1, , , 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, , , , 1, , , , 1, , , 1, , , , 1, , , , , , , 1, 1 ], [ , 1, 1, 1, 1, 1, , , 1, 1, 1, , 1, 1, 1, 1, , , 1, 1, 1, 1, , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, , 1, , , 1, 1, 1, 1, , 1, 1, 1, 1, , , , 1, , 1, , 1, , , 1 ], [ 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , 1, , , , , , , , , 1, 1, , , , , , , , , 1 ], , [ , 1, , 1, , 1, , 1, , 1, , 1, 1, 1, 1, 1, , , 1, , 1, , 1, , , , 1 ], [ , 1, , , 1, 1, , 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1, 1, , 1, , , 1 ], [ 1, , , 1, , , , 1, 1, 1, , , , , 1, 1, , , , 1, , 1 ], [ 1, 1, , 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ 1, 1, , , , , , , , 1, , 1, , , , , , , , 1, , 1 ], [ , 1, , , , 1, , 1, 1, , , , 1, 1, , 1, , , , 1, 1, 1, , 1 ], , [ , 1, , , , , , 1, , , , , , , 1 ], [ , , , , , , , , 1, , , , 1, , 1, , , , , , , , , , , , 1 ] ], [ , [ , 1, 1, , 1, 1, 1, 1, , 1, 1, 1, , 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], [ , 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, , 1 ], [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , 1, , , , , , , , 1, , , , , , 1, , , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, , , , 1, 1, 1, , 1, 1, 1, 1, , , 1, 1, 1, 1, , , 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ 1, 1, , 1, , 1, , 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, , , 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, , , , , 1, 1, 1, , , 1, , 1, 1, , , , 1, , 1, , , 1, 1 ], [ , , , , , , , 1, , , , 1, 1, 1, 1, 1, , 1, , , , , , , , 1 ], [ 1, 1, 1, 1, , 1, 1, 1, , 1, , 1, 1, 1, 1, , 1, , 1, , 1, 1, , , 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , , 1, 1, , 1, , 1, 1, 1, , 1, , 1, 1, , 1, 1, , 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , , , , , , , 1, , , , , 1, , 1 ], [ , 1, 1, 1, , 1, , 1, , 1, , , , 1, , 1, , , 1, , , , , , 1, 1 ], [ , 1, , , 1, 1, , 1, , 1, , 1, 1, 1, 1, 1, , 1, 1, , , 1, , , 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, , , , , 1, , 1, , 1, , , , , , 1, , 1, , , , 1, 1 ] ], [ , [ , 1, , 1, , , , , , , , , , , , , , , 1, , , , 1 ], [ , , , , , , , , , 1, , 1, 1, 1, , 1, , , 1, , 1, 1 ], [ 1, 1, , , , , , , 1, , , , , , , 1, , , , , , 1 ], [ , 1, , , , , , , , , , 1, , , , , , , , , 1, 1 ], , [ , , , , , , , , , , , , , , , 1, , , , 1, , 1 ], [ , , 1, 1, , 1, , 1, , , , , , , , 1, , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , , 1, 1 ], [ , 1, , , , , , , , , , , , , 1 ], [ 1, , 1, 1, , , , 1, , , , , , , , , 1, , , 1, , , 1, 1 ], [ , 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, , 1, 1, , 1 ], [ , 1, , , 1, 1, , , , , , 1, , 1, , 1, , , 1, , 1, 1 ], [ 1, 1, 1, 1, , 1, , 1, , 1, , 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ , 1, 1, , , 1, , 1, , 1, 1, 1, , , 1, 1, 1, , 1, 1, 1, 1, , 1, 1 ], [ , , , , 1, , , 1, , , , , , , 1, , , , 1, 1 ], [ , 1, , , , , , , , , , 1, , 1, , 1, , , , , 1, , , , , 1 ], , [ 1, 1, , 1, , 1, , 1, 1, , , , , , 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, , , , , , 1, , , , , , 1, 1, , , , 1, 1, , , 1 ], [ , 1, 1, , 1, 1, , , , 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, , , 1, , , , 1, , , , 1, 1 ], [ , , , , 1 ], [ , , , , , , , , , 1, , , 1 ], , [ , , 1, , 1, , , , , , , , , 1, , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , 1, 1, , 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, , , , , 1 ], [ , 1, , 1, , , , , , 1, , , , , 1, 1, , , , , 1, 1 ], [ , 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, , , 1, , 1, 1, 1 ], [ , 1, , , , 1, , , , , , , 1 ], [ , 1, , , 1, , , 1, , 1, , 1, 1, , 1, , , , , 1, , 1, , , , 1, 1 ], [ , 1, , , 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, 1, , , , 1, 1, , , , , , 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1 ], [ , 1, , , , 1, , , , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , 1, , , , , , , , 1, , , , , , , , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, , 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1 ], [ 1, 1, , , , , , , 1, 1, , , , , 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, , 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1 ], , [ , 1, 1, , , , , 1, , 1, , , , 1, 1, 1, , , 1, , , , , 1 ], [ , , , , , , , , , , , , , 1 ], [ , , , , , 1, , , , , , , , 1, 1, , , , , 1, , 1, , , 1, 1 ], [ , , , , , , , , , , , , , , 1 ] ], [ , [ , 1 ], , , , , , , , , , , , , , , , , , , , [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, , , 1, 1, 1, 1, 1 ], [ , 1, , 1, , 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, , , 1, , , , 1, , 1, 1 ], [ , 1, , 1, , 1, , , 1, , , , , 1, , , , , , 1, 1 ], [ , 1, , 1, , , , , 1, , , , 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ , 1, , , , , , , , , , , , , , , 1 ] ], [ , [ , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , 1, , , , , , , , , 1, 1, , , , 1 ], [ , , , , , , 1 ], [ , , 1 ], [ , 1, 1, , , 1, , 1, , 1, 1, , 1, 1, 1, , , , 1, 1, 1, , , , , 1 ], , [ , 1, , , , 1, , , , , , 1, , , 1, , , , 1, 1, , 1 ], [ , , , , , , , 1, , , , , , , , , 1 ], [ , 1, , , , 1, 1, , , , , , 1, 1, 1, , , , 1, , 1, 1 ], [ , , , , , , , 1, , 1, , , , , , , , , , 1 ], [ , 1, 1, , , , , , 1, 1, , , , 1, , , , , , , 1, , , 1 ], , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , , 1, , , 1, , , , , 1, , 1, , 1, , 1, , , , , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , , , , 1, 1, , 1, 1, , 1, , , 1, , 1 ], [ , , , , , , , , , , , , , , 1, , , , , , 1 ], , [ , , , , , , , , , 1, , , , , , 1, , , , , 1 ], [ , , 1, , , , , , , 1, , , 1, 1 ], [ , , , 1, , , , , 1, , , , , 1, , , , , , 1, , , , 1 ], [ 1, , 1, 1, , 1, 1, 1, 1, 1, , 1, , , , 1, 1, 1, , , 1, 1, , , , 1, 1 ], , [ 1, 1, , , , , , , , , , 1, , 1, , 1, , , 1 ], [ , , , , 1, , , , , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , 1, , , , , 1, , 1 ], [ , , , , , , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , , 1, , , 1, , , , , , , , 1, , , , , , 1, , , , 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, 1, , 1, , , , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , , 1, 1, 1, 1, , 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ 1, 1, , , , , , , 1, , 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], [ 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ 1, 1, 1, 1, , 1, , 1, , 1, 1, 1, 1, 1, , , , 1, 1, 1, 1, , 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, , 1, , , , , , 1, , 1, , , , , 1, 1, , , , , 1 ], [ 1, , 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , 1, 1, , 1, , 1, , , , 1, 1, 1, 1, 1, , , 1, 1, , 1, , 1 ], [ , 1, 1, 1, 1, , , , , 1, , 1, 1, 1, 1, 1, , , 1, 1, , , , 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, , , , , 1, , 1, , 1, , , 1, , , 1, 1, , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , , , , , , , 1, , , , , 1, 1, , , 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , , 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , , , 1, , 1, 1, , 1, 1, 1, 1, 1, , , 1, , 1, , 1 ], [ 1, 1, 1, , 1, 1, 1, 1, , , , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , , 1, , , , , , , , , , 1, 1, 1, 1, 1, 1, 1, , 1, 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , 1, 1, , , , , , 1, 1, 1, 1, 1, , , , 1, 1, 1, , 1, 1, 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1 ], [ , 1, 1, 1, , 1, , 1, 1, 1, 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, , , 1, 1 ], [ 1, 1, , , , 1, , , 1, 1, 1, , 1, , 1, , 1, , 1, 1, 1, 1, 1, , 1, , 1 ], [ , 1, , , , , , , 1, , 1, , 1, 1, 1, 1, , , , , , , , , 1 ] ], [ , [ , , , , , , , , , , , , , 1, 1, , , , 1 ], [ , 1, , , , , , , , 1, , , 1, , , , , , 1, , , 1, , , , 1 ], , [ , 1, , , , 1, , 1, , 1, 1, , 1, 1, , , , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , 1 ], [ 1, 1, 1, , , 1, , , , , , , , , 1, 1, , , , , , , , , , 1 ], [ , 1, , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , , , , , , 1, , , 1 ], [ , , , , , , , , , 1 ], [ 1, 1, , , , , , 1, 1, 1, , 1, 1, , , , 1, 1, , 1, , 1, 1, 1, , 1 ], [ , 1, 1, 1, , 1, 1, , , 1, , 1, 1, 1, 1, , , , , , , 1, , 1 ], [ , 1, 1, 1, 1, , , 1, , 1, , , , 1, 1, 1, 1, , 1, 1, , 1 ], [ , 1, , , 1, 1, , 1, , , , 1, , 1, 1, , 1, , 1, , , 1, , , 1, , 1 ], [ , , , , , , , , , , , 1 ], [ , , , , , , , , , 1, , , , , , , , , , , , , 1 ], , [ 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , , , , 1, 1, , 1, , , , , 1, , , 1, , 1 ], [ , 1, , , , 1, , , 1, , , , , , , , 1, , 1, , , 1 ], [ , , , , , , , , , , , , , 1, 1, , , , 1, , , 1 ], [ , , , , , 1, , , 1, , , , 1 ], [ , 1 ], , [ , 1 ], [ 1, , , , , , , , , , , , , , 1, , , , , 1 ] ], [ , [ , 1, , , , 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, , 1, 1, , 1, 1, , , 1 ], [ , , 1, , , , , , , , , 1 ], , , [ 1, , , 1, 1, , , , , , , , 1, 1, , 1, 1, , 1 ], , [ , , , , , , , , , , , , , , , , , , 1, , 1 ], , [ 1, , , 1, 1, , 1, 1, , , , , 1, , 1, , , , , 1, 1, , 1 ], , [ , 1, , , , , , , , 1, 1, 1, 1, 1, , 1, 1, , , , 1, 1 ], [ , , , , , , , , , , , , , , , , 1, , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , , , , , , , , , , , 1, , 1, , , 1 ], [ 1, , , , , , , , , , , , , , , , , , 1, , 1 ], , , [ , 1, , , , , , , , , , , , , , 1, , , , 1, 1 ], [ , , , , , , , , , 1, , , 1, , , , , , , , , , 1 ], [ , , , , , , , , , , , , , , , 1 ], [ , , , , , , , , , , , , , 1, 1, , , , , , 1 ], , [ , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , , 1, 1, , 1, 1, 1, 1, 1, 1, , , 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, , , , , , , , 1 ], [ , , , , 1, , , 1, , , 1, 1, , , , , , , , , , 1, , , , 1 ], [ , 1, , 1, 1, , , 1, 1, 1, , , , 1, 1, 1, 1, , 1, 1, 1, 1, , 1 ], [ , , , , , , , 1 ], [ , 1, 1, , , , , 1, , 1, , , , , , 1, , , , , , 1, , 1, , 1 ], [ , 1, , , , , , 1, , , , 1, , , , , , , , , , 1 ], [ , , 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, , 1, 1, 1, 1, , 1 ], [ , 1, , , , , , , , 1 ], [ , 1, 1, , 1, , , , , , , , 1, , , , , , 1, , , 1, , 1, , 1 ], [ , 1, , 1, , 1, , 1, 1, 1, , 1, 1, 1, , 1, , , 1, 1, , 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , , 1, 1, , , , 1, 1, 1, , , , 1, 1, , , 1, 1 ], [ , , 1, 1, 1, 1, , 1, , 1, , 1, , 1, 1, 1, 1, , , , , 1, , 1, , 1 ], [ 1, 1, 1, 1, 1, 1, 1, 1, , 1, , 1, , 1, 1, 1, , , 1, 1, , , , 1, , 1 ], [ , , , 1 ], , [ , 1, 1, , 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, , 1, 1, 1, 1, 1, 1 ], [ , 1, , , , , , 1, , 1, , 1, , , , , , , 1, 1, , 1, 1 ], [ , , , , , , 1, , 1, 1, , 1, , 1, , , , , , , , , , 1 ], [ , 1, 1, , 1, , , , 1, , , , 1, 1, 1, , , , 1, , 1, 1, 1, , 1, 1 ], , [ , 1, 1, , , , , , , , , , , , , 1, , , 1, , , , , 1 ], [ , 1, , , , , , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, , , , , , , 1, , , , 1, , , , , 1, , , , , , , 1 ] ], [ , [ , 1, 1, 1, 1, 1, , 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, , 1, , 1, 1, , , 1, 1, 1, 1, , 1, , , , , 1, 1, 1 ], [ , , 1, 1, , 1, , 1, 1, , , , 1, 1, 1, 1, , , 1, , 1, 1, 1, 1, , 1 ], [ , 1, , 1, , , , , , , , 1, , 1, , 1, , , , , , , , , , 1 ], [ , , 1, , 1, , , 1, , , , , 1, 1, , , 1, , 1, 1, 1, 1 ], [ , 1 ], [ , 1, 1, , 1, , 1, 1, , 1, , , 1, 1, 1, , , , 1, , , 1, , 1 ], [ 1, 1, , 1, 1, 1, , , , , , , , , , , , , 1, , 1, 1, 1 ], [ , 1, 1, , , , , , , 1, , , 1, , 1, , 1, , 1, 1, , , 1, , , 1 ], [ , , 1, , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, 1, 1, 1, , 1, , 1, , , , , 1, 1, 1, , , 1, , 1, , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, , , 1, 1, 1, , 1, , 1, 1, 1, , , 1, 1, 1, 1, , , , 1, 1 ], [ , , , 1, 1, , , 1, , 1, , 1, , 1, 1, 1, 1, , 1, , , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , , , , , , , , , , , , , , , , , 1 ], [ , 1, 1, , 1, 1, , 1, , 1, , , , 1, 1, , , 1, 1, , 1, 1, , 1 ], [ , 1, 1, 1, 1, 1, , , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, , , 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1 ], [ , 1, 1, , 1, , , 1, , , 1, , 1, 1, 1, 1, 1, , 1, , 1, 1 ], [ , , , , , 1, , , , 1, , , , , 1, 1, , , , 1 ], [ , 1, , 1, 1, 1, , 1, , , 1, 1, 1, , , 1, , , 1, , 1, , , 1 ], [ , , 1, , , , , , , , , 1, , 1, , , , , 1, , 1 ], [ , 1, 1, , , , , , , , 1, 1, 1, , , , , , , , 1, , , , , 1 ], [ , , , , , , , , 1, , , , , 1, , , 1 ] ], [ , [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, 1, , 1, 1, , , 1, 1, 1, 1, 1, 1, 1, 1, , , , , , , , , 1, 1 ], [ , , , , , , , , 1, , , , 1, , 1, , 1 ], [ , 1, , , 1, 1, , 1, , , , 1, , , , , , , , 1 ], [ , 1, , 1, , 1, , , , 1, 1, , 1, , 1, , , , 1, 1, 1, 1, 1, , , 1 ], , [ , 1, , , , , , , , 1, , , 1, 1, , , 1, , 1, 1, , 1, , 1 ], [ , 1, , , 1, , , , , , , , 1, , , , , , , 1 ], [ 1, 1, , , , , 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1 ], , [ , 1, , , , , , 1, , 1, , 1, 1, 1, 1, 1, , , 1, , 1, 1, , , , 1 ], [ , 1, 1, , , 1, , 1, , 1, , , 1, 1, 1, 1, , , 1, , , 1, , , , 1 ], [ , 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , , , 1, , 1 ], [ , 1, , , 1, 1, , 1, 1, , , 1, 1, , 1, 1, , 1, , 1, , 1 ], [ 1, , 1, , , , , 1, , 1, , 1, 1, 1, 1, , , , , 1, 1, , , , 1, 1 ], [ , 1, 1, , , , , 1, 1, , , 1, , 1, 1, 1, 1, , , , , , , , , , 1 ], , [ , 1, 1, , , 1, , , , 1, , 1, 1, 1, 1, 1, , , , 1, , , , 1, , 1 ], [ , , , 1, 1, , , 1, , , , , 1, , 1, 1, 1, , 1, 1, , , , , , 1 ], [ , 1, , , , , , , , , , , 1, , , , 1, , , , , , , 1, , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, , 1, 1, 1, , 1, 1, , 1, 1, 1, 1 ], [ , 1, , , , , , , , , , , , , , , , , , , 1 ], [ , 1, , , , , , 1, , , , , 1, , 1, , , 1, 1, , 1, 1, , 1 ], [ , 1, , , , , , 1, , , , , 1, 1, , , , , , , , 1, , , , 1 ], [ , , , , , , , , , , , , , , , , , , 1, , , 1, , , , , 1 ], [ , , , , , , , 1, , , , 1 ] ], [ , [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , 1, , 1, , , , , , , 1, , , , , , , , 1, , , 1 ], [ , 1, , , , , , , 1 ], [ , , , , , , , , , , 1 ], [ , 1, , , , , , 1, 1, , , , , , 1 ], , [ , 1, 1, , , , , , 1, , , , , 1, 1, , , , 1 ], [ 1, , 1, , 1, , , , , 1, , , , , 1, , , , , , , , , 1, 1 ], [ , 1, 1, , , , , , , , , 1, 1, 1, 1, , , , 1, , , , , 1, , , 1 ], , [ , 1, 1, , 1, , , 1, 1, , , 1, , , 1, 1, 1, , 1, , 1, 1, 1, , , , 1 ], [ , , , , , 1, , , , , 1, , , 1, 1, , , 1, , 1, , , , 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , 1, , , 1, 1, , 1, , , , 1, , , , , , , , 1 ], [ , , , 1, , , , , 1, , , , , 1, , 1, , 1, 1, 1 ], [ , 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ], [ , , , , , 1 ], [ , 1, , , , , , 1, , , , , , , 1, 1, 1, , , 1 ], [ , 1, , , , , , , , , , 1, 1, 1, , , , , 1, , , 1 ], [ , , , , , 1, , 1, , , , , 1, 1, 1, , 1, 1, , 1, 1, 1, , , 1, 1 ], [ 1, 1, , , , , , , 1, , , , , 1, 1, , , , , , , , , , , 1 ], , [ , 1 ], [ , , , , , , , , , , , , , , , , , , , , , , , , 1 ], [ , , 1, , , , , 1, , , 1, , , , 1, , 1 ], [ , 1, , , , , , , , , 1 ] ] ];
    function isValidLang(lang) {
      var array = langs;
      while (lang.length < 3) {
        lang += '`';
      }
      for (var _i27 = 0; _i27 <= lang.length - 1; _i27++) {
        var index = lang.charCodeAt(_i27) - 96;
        array = array[index];
        if (!array) {
          return false;
        }
      }
      return true;
    }
    function _validLangs(langArray) {
      langArray = Array.isArray(langArray) ? langArray : langs;
      var codes = [];
      langArray.forEach(function(lang, index) {
        var _char3 = String.fromCharCode(index + 96).replace('`', '');
        if (Array.isArray(lang)) {
          codes = codes.concat(_validLangs(lang).map(function(newLang) {
            return _char3 + newLang;
          }));
        } else {
          codes.push(_char3);
        }
      });
      return codes;
    }
    var valid_langs_default = isValidLang;
    var SerialVirtualNode = function(_abstract_virtual_nod2) {
      _inherits(SerialVirtualNode, _abstract_virtual_nod2);
      var _super3 = _createSuper(SerialVirtualNode);
      function SerialVirtualNode(serialNode) {
        var _this6;
        _classCallCheck(this, SerialVirtualNode);
        _this6 = _super3.call(this);
        _this6._props = normaliseProps(serialNode);
        _this6._attrs = normaliseAttrs(serialNode);
        return _this6;
      }
      _createClass(SerialVirtualNode, [ {
        key: 'props',
        get: function get() {
          return this._props;
        }
      }, {
        key: 'attr',
        value: function attr(attrName) {
          var _this$_attrs$attrName;
          return (_this$_attrs$attrName = this._attrs[attrName]) !== null && _this$_attrs$attrName !== void 0 ? _this$_attrs$attrName : null;
        }
      }, {
        key: 'hasAttr',
        value: function hasAttr(attrName) {
          return this._attrs[attrName] !== void 0;
        }
      }, {
        key: 'attrNames',
        get: function get() {
          return Object.keys(this._attrs);
        }
      } ]);
      return SerialVirtualNode;
    }(abstract_virtual_node_default);
    var nodeNamesToTypes = {
      '#cdata-section': 2,
      '#text': 3,
      '#comment': 8,
      '#document': 9,
      '#document-fragment': 11
    };
    var nodeTypeToName = {};
    var nodeNames = Object.keys(nodeNamesToTypes);
    nodeNames.forEach(function(nodeName2) {
      nodeTypeToName[nodeNamesToTypes[nodeName2]] = nodeName2;
    });
    function normaliseProps(serialNode) {
      var _serialNode$nodeName, _ref82, _serialNode$nodeType;
      var nodeName2 = (_serialNode$nodeName = serialNode.nodeName) !== null && _serialNode$nodeName !== void 0 ? _serialNode$nodeName : nodeTypeToName[serialNode.nodeType];
      var nodeType = (_ref82 = (_serialNode$nodeType = serialNode.nodeType) !== null && _serialNode$nodeType !== void 0 ? _serialNode$nodeType : nodeNamesToTypes[serialNode.nodeName]) !== null && _ref82 !== void 0 ? _ref82 : 1;
      assert_default(typeof nodeType === 'number', 'nodeType has to be a number, got \''.concat(nodeType, '\''));
      assert_default(typeof nodeName2 === 'string', 'nodeName has to be a string, got \''.concat(nodeName2, '\''));
      nodeName2 = nodeName2.toLowerCase();
      var type2 = null;
      if (nodeName2 === 'input') {
        type2 = (serialNode.type || serialNode.attributes && serialNode.attributes.type || '').toLowerCase();
        if (!valid_input_type_default().includes(type2)) {
          type2 = 'text';
        }
      }
      var props = _extends({}, serialNode, {
        nodeType: nodeType,
        nodeName: nodeName2
      });
      if (type2) {
        props.type = type2;
      }
      delete props.attributes;
      return Object.freeze(props);
    }
    function normaliseAttrs(_ref83) {
      var _ref83$attributes = _ref83.attributes, attributes2 = _ref83$attributes === void 0 ? {} : _ref83$attributes;
      var attrMap = {
        htmlFor: 'for',
        className: 'class'
      };
      return Object.keys(attributes2).reduce(function(attrs, attrName) {
        var value = attributes2[attrName];
        assert_default(_typeof(value) !== 'object' || value === null, 'expects attributes not to be an object, \''.concat(attrName, '\' was'));
        if (value !== void 0) {
          var mappedName = attrMap[attrName] || attrName;
          attrs[mappedName] = value !== null ? String(value) : null;
        }
        return attrs;
      }, {});
    }
    var serial_virtual_node_default = SerialVirtualNode;
    function cleanup(resolve, reject) {
      resolve = resolve || function res() {};
      reject = reject || axe.log;
      if (!axe._audit) {
        throw new Error('No audit configured');
      }
      var q = axe.utils.queue();
      var cleanupErrors = [];
      Object.keys(axe.plugins).forEach(function(key) {
        q.defer(function(res) {
          var rej = function rej2(err2) {
            cleanupErrors.push(err2);
            res();
          };
          try {
            axe.plugins[key].cleanup(res, rej);
          } catch (err2) {
            rej(err2);
          }
        });
      });
      var flattenedTree = axe.utils.getFlattenedTree(document.body);
      axe.utils.querySelectorAll(flattenedTree, 'iframe, frame').forEach(function(node) {
        q.defer(function(res, rej) {
          return axe.utils.sendCommandToFrame(node.actualNode, {
            command: 'cleanup-plugin'
          }, res, rej);
        });
      });
      q.then(function(results) {
        if (cleanupErrors.length === 0) {
          resolve(results);
        } else {
          reject(cleanupErrors);
        }
      })['catch'](reject);
    }
    var cleanup_default = cleanup;
    var reporters = {};
    var defaultReporter;
    function hasReporter(reporterName) {
      return reporters.hasOwnProperty(reporterName);
    }
    function getReporter(reporter) {
      if (typeof reporter === 'string' && reporters[reporter]) {
        return reporters[reporter];
      }
      if (typeof reporter === 'function') {
        return reporter;
      }
      return defaultReporter;
    }
    function addReporter(name, cb, isDefault) {
      reporters[name] = cb;
      if (isDefault) {
        defaultReporter = cb;
      }
    }
    function configure(spec) {
      var audit;
      audit = axe._audit;
      if (!audit) {
        throw new Error('No audit configured');
      }
      if (spec.axeVersion || spec.ver) {
        var specVersion = spec.axeVersion || spec.ver;
        if (!/^\d+\.\d+\.\d+(-canary)?/.test(specVersion)) {
          throw new Error('Invalid configured version '.concat(specVersion));
        }
        var _specVersion$split = specVersion.split('-'), _specVersion$split2 = _slicedToArray(_specVersion$split, 2), version = _specVersion$split2[0], canary = _specVersion$split2[1];
        var _version$split$map = version.split('.').map(Number), _version$split$map2 = _slicedToArray(_version$split$map, 3), major = _version$split$map2[0], minor = _version$split$map2[1], patch = _version$split$map2[2];
        var _axe$version$split = axe.version.split('-'), _axe$version$split2 = _slicedToArray(_axe$version$split, 2), axeVersion = _axe$version$split2[0], axeCanary = _axe$version$split2[1];
        var _axeVersion$split$map = axeVersion.split('.').map(Number), _axeVersion$split$map2 = _slicedToArray(_axeVersion$split$map, 3), axeMajor = _axeVersion$split$map2[0], axeMinor = _axeVersion$split$map2[1], axePatch = _axeVersion$split$map2[2];
        if (major !== axeMajor || axeMinor < minor || axeMinor === minor && axePatch < patch || major === axeMajor && minor === axeMinor && patch === axePatch && canary && canary !== axeCanary) {
          throw new Error('Configured version '.concat(specVersion, ' is not compatible with current axe version ').concat(axe.version));
        }
      }
      if (spec.reporter && (typeof spec.reporter === 'function' || hasReporter(spec.reporter))) {
        audit.reporter = spec.reporter;
      }
      if (spec.checks) {
        if (!Array.isArray(spec.checks)) {
          throw new TypeError('Checks property must be an array');
        }
        spec.checks.forEach(function(check) {
          if (!check.id) {
            throw new TypeError('Configured check '.concat(JSON.stringify(check), ' is invalid. Checks must be an object with at least an id property'));
          }
          audit.addCheck(check);
        });
      }
      var modifiedRules = [];
      if (spec.rules) {
        if (!Array.isArray(spec.rules)) {
          throw new TypeError('Rules property must be an array');
        }
        spec.rules.forEach(function(rule) {
          if (!rule.id) {
            throw new TypeError('Configured rule '.concat(JSON.stringify(rule), ' is invalid. Rules must be an object with at least an id property'));
          }
          modifiedRules.push(rule.id);
          audit.addRule(rule);
        });
      }
      if (spec.disableOtherRules) {
        audit.rules.forEach(function(rule) {
          if (modifiedRules.includes(rule.id) === false) {
            rule.enabled = false;
          }
        });
      }
      if (typeof spec.branding !== 'undefined') {
        audit.setBranding(spec.branding);
      } else {
        audit._constructHelpUrls();
      }
      if (spec.tagExclude) {
        audit.tagExclude = spec.tagExclude;
      }
      if (spec.locale) {
        audit.applyLocale(spec.locale);
      }
      if (spec.standards) {
        configureStandards(spec.standards);
      }
      if (spec.noHtml) {
        audit.noHtml = true;
      }
      if (spec.allowedOrigins) {
        if (!Array.isArray(spec.allowedOrigins)) {
          throw new TypeError('Allowed origins property must be an array');
        }
        if (spec.allowedOrigins.includes('*')) {
          throw new Error('"*" is not allowed. Use "'.concat(constants_default.allOrigins, '" instead'));
        }
        audit.setAllowedOrigins(spec.allowedOrigins);
      }
    }
    var configure_default = configure;
    function frameMessenger2(frameHandler) {
      _respondable.updateMessenger(frameHandler);
    }
    function getRules(tags) {
      tags = tags || [];
      var matchingRules = !tags.length ? axe._audit.rules : axe._audit.rules.filter(function(item) {
        return !!tags.filter(function(tag) {
          return item.tags.indexOf(tag) !== -1;
        }).length;
      });
      var ruleData = axe._audit.data.rules || {};
      return matchingRules.map(function(matchingRule) {
        var rd = ruleData[matchingRule.id] || {};
        return {
          ruleId: matchingRule.id,
          description: rd.description,
          help: rd.help,
          helpUrl: rd.helpUrl,
          tags: matchingRule.tags,
          actIds: matchingRule.actIds
        };
      });
    }
    var get_rules_default = getRules;
    var aria_exports = {};
    __export(aria_exports, {
      allowedAttr: function allowedAttr() {
        return allowed_attr_default;
      },
      arialabelText: function arialabelText() {
        return _arialabelText;
      },
      arialabelledbyText: function arialabelledbyText() {
        return arialabelledby_text_default;
      },
      getAccessibleRefs: function getAccessibleRefs() {
        return get_accessible_refs_default;
      },
      getElementUnallowedRoles: function getElementUnallowedRoles() {
        return get_element_unallowed_roles_default;
      },
      getExplicitRole: function getExplicitRole() {
        return get_explicit_role_default;
      },
      getImplicitRole: function getImplicitRole() {
        return implicit_role_default;
      },
      getOwnedVirtual: function getOwnedVirtual() {
        return get_owned_virtual_default;
      },
      getRole: function getRole() {
        return get_role_default;
      },
      getRoleType: function getRoleType() {
        return get_role_type_default;
      },
      getRolesByType: function getRolesByType() {
        return get_roles_by_type_default;
      },
      getRolesWithNameFromContents: function getRolesWithNameFromContents() {
        return get_roles_with_name_from_contents_default;
      },
      implicitNodes: function implicitNodes() {
        return implicit_nodes_default;
      },
      implicitRole: function implicitRole() {
        return implicit_role_default;
      },
      isAccessibleRef: function isAccessibleRef() {
        return is_accessible_ref_default;
      },
      isAriaRoleAllowedOnElement: function isAriaRoleAllowedOnElement() {
        return is_aria_role_allowed_on_element_default;
      },
      isComboboxPopup: function isComboboxPopup() {
        return _isComboboxPopup;
      },
      isUnsupportedRole: function isUnsupportedRole() {
        return is_unsupported_role_default;
      },
      isValidRole: function isValidRole() {
        return is_valid_role_default;
      },
      label: function label() {
        return label_default2;
      },
      labelVirtual: function labelVirtual() {
        return label_virtual_default;
      },
      lookupTable: function lookupTable() {
        return lookup_table_default;
      },
      namedFromContents: function namedFromContents() {
        return named_from_contents_default;
      },
      requiredAttr: function requiredAttr() {
        return required_attr_default;
      },
      requiredContext: function requiredContext() {
        return required_context_default;
      },
      requiredOwned: function requiredOwned() {
        return required_owned_default;
      },
      validateAttr: function validateAttr() {
        return validate_attr_default;
      },
      validateAttrValue: function validateAttrValue() {
        return validate_attr_value_default;
      }
    });
    function allowedAttr(role) {
      var roleDef = standards_default.ariaRoles[role];
      var attrs = _toConsumableArray(get_global_aria_attrs_default());
      if (!roleDef) {
        return attrs;
      }
      if (roleDef.allowedAttrs) {
        attrs.push.apply(attrs, _toConsumableArray(roleDef.allowedAttrs));
      }
      if (roleDef.requiredAttrs) {
        attrs.push.apply(attrs, _toConsumableArray(roleDef.requiredAttrs));
      }
      return attrs;
    }
    var allowed_attr_default = allowedAttr;
    var idRefsRegex = /^idrefs?$/;
    function cacheIdRefs(node, idRefs, refAttrs) {
      if (node.hasAttribute) {
        if (node.nodeName.toUpperCase() === 'LABEL' && node.hasAttribute('for')) {
          var _id2 = node.getAttribute('for');
          if (!idRefs.has(_id2)) {
            idRefs.set(_id2, [ node ]);
          } else {
            idRefs.get(_id2).push(node);
          }
        }
        for (var _i28 = 0; _i28 < refAttrs.length; ++_i28) {
          var attr = refAttrs[_i28];
          var attrValue = sanitize_default(node.getAttribute(attr) || '');
          if (!attrValue) {
            continue;
          }
          var _iterator14 = _createForOfIteratorHelper(token_list_default(attrValue)), _step14;
          try {
            for (_iterator14.s(); !(_step14 = _iterator14.n()).done; ) {
              var token = _step14.value;
              if (!idRefs.has(token)) {
                idRefs.set(token, [ node ]);
              } else {
                idRefs.get(token).push(node);
              }
            }
          } catch (err) {
            _iterator14.e(err);
          } finally {
            _iterator14.f();
          }
        }
      }
      for (var _i29 = 0; _i29 < node.childNodes.length; _i29++) {
        if (node.childNodes[_i29].nodeType === 1) {
          cacheIdRefs(node.childNodes[_i29], idRefs, refAttrs);
        }
      }
    }
    function getAccessibleRefs(node) {
      var _idRefs$get;
      node = node.actualNode || node;
      var root = get_root_node_default2(node);
      root = root.documentElement || root;
      var idRefsByRoot = cache_default.get('idRefsByRoot', function() {
        return new Map();
      });
      var idRefs = idRefsByRoot.get(root);
      if (!idRefs) {
        idRefs = new Map();
        idRefsByRoot.set(root, idRefs);
        var refAttrs = Object.keys(standards_default.ariaAttrs).filter(function(attr) {
          var type2 = standards_default.ariaAttrs[attr].type;
          return idRefsRegex.test(type2);
        });
        cacheIdRefs(root, idRefs, refAttrs);
      }
      return (_idRefs$get = idRefs.get(node.id)) !== null && _idRefs$get !== void 0 ? _idRefs$get : [];
    }
    var get_accessible_refs_default = getAccessibleRefs;
    function isAriaRoleAllowedOnElement(node, role) {
      var vNode = node instanceof abstract_virtual_node_default ? node : get_node_from_tree_default(node);
      var implicitRole3 = implicit_role_default(vNode);
      var spec = get_element_spec_default(vNode);
      if (Array.isArray(spec.allowedRoles)) {
        return spec.allowedRoles.includes(role);
      }
      if (role === implicitRole3) {
        return false;
      }
      return !!spec.allowedRoles;
    }
    var is_aria_role_allowed_on_element_default = isAriaRoleAllowedOnElement;
    var dpubRoles2 = [ 'doc-backlink', 'doc-biblioentry', 'doc-biblioref', 'doc-cover', 'doc-endnote', 'doc-glossref', 'doc-noteref' ];
    var landmarkRoles = {
      header: 'banner',
      footer: 'contentinfo'
    };
    function getRoleSegments(vNode) {
      var roles = [];
      if (!vNode) {
        return roles;
      }
      if (vNode.hasAttr('role')) {
        var nodeRoles = token_list_default(vNode.attr('role').toLowerCase());
        roles = roles.concat(nodeRoles);
      }
      return roles.filter(function(role) {
        return is_valid_role_default(role);
      });
    }
    function getElementUnallowedRoles(node) {
      var allowImplicit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var _nodeLookup21 = _nodeLookup(node), vNode = _nodeLookup21.vNode;
      if (!is_html_element_default(vNode)) {
        return [];
      }
      var nodeName2 = vNode.props.nodeName;
      var implicitRole3 = implicit_role_default(vNode) || landmarkRoles[nodeName2];
      var roleSegments = getRoleSegments(vNode);
      return roleSegments.filter(function(role) {
        return !roleIsAllowed(role, vNode, allowImplicit, implicitRole3);
      });
    }
    function roleIsAllowed(role, vNode, allowImplicit, implicitRole3) {
      if (allowImplicit && role === implicitRole3) {
        return true;
      }
      if (dpubRoles2.includes(role) && get_role_type_default(role) !== implicitRole3) {
        return false;
      }
      return is_aria_role_allowed_on_element_default(vNode, role);
    }
    var get_element_unallowed_roles_default = getElementUnallowedRoles;
    function getAriaRolesByType(type2) {
      return Object.keys(standards_default.ariaRoles).filter(function(roleName) {
        return standards_default.ariaRoles[roleName].type === type2;
      });
    }
    var get_aria_roles_by_type_default = getAriaRolesByType;
    function getRolesByType(roleType) {
      return get_aria_roles_by_type_default(roleType);
    }
    var get_roles_by_type_default = getRolesByType;
    function getAriaRolesSupportingNameFromContent() {
      return cache_default.get('ariaRolesNameFromContent', function() {
        return Object.keys(standards_default.ariaRoles).filter(function(roleName) {
          return standards_default.ariaRoles[roleName].nameFromContent;
        });
      });
    }
    var get_aria_roles_supporting_name_from_content_default = getAriaRolesSupportingNameFromContent;
    function getRolesWithNameFromContents() {
      return get_aria_roles_supporting_name_from_content_default();
    }
    var get_roles_with_name_from_contents_default = getRolesWithNameFromContents;
    var isNull = function isNull(value) {
      return value === null;
    };
    var isNotNull = function isNotNull(value) {
      return value !== null;
    };
    var lookupTable = {};
    lookupTable.attributes = {
      'aria-activedescendant': {
        type: 'idref',
        allowEmpty: true,
        unsupported: false
      },
      'aria-atomic': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-autocomplete': {
        type: 'nmtoken',
        values: [ 'inline', 'list', 'both', 'none' ],
        unsupported: false
      },
      'aria-busy': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-checked': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'mixed', 'undefined' ],
        unsupported: false
      },
      'aria-colcount': {
        type: 'int',
        unsupported: false
      },
      'aria-colindex': {
        type: 'int',
        unsupported: false
      },
      'aria-colspan': {
        type: 'int',
        unsupported: false
      },
      'aria-controls': {
        type: 'idrefs',
        allowEmpty: true,
        unsupported: false
      },
      'aria-current': {
        type: 'nmtoken',
        allowEmpty: true,
        values: [ 'page', 'step', 'location', 'date', 'time', 'true', 'false' ],
        unsupported: false
      },
      'aria-describedby': {
        type: 'idrefs',
        allowEmpty: true,
        unsupported: false
      },
      'aria-describedat': {
        unsupported: true,
        unstandardized: true
      },
      'aria-details': {
        type: 'idref',
        allowEmpty: true,
        unsupported: false
      },
      'aria-disabled': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-dropeffect': {
        type: 'nmtokens',
        values: [ 'copy', 'move', 'reference', 'execute', 'popup', 'none' ],
        unsupported: false
      },
      'aria-errormessage': {
        type: 'idref',
        allowEmpty: true,
        unsupported: false
      },
      'aria-expanded': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ],
        unsupported: false
      },
      'aria-flowto': {
        type: 'idrefs',
        allowEmpty: true,
        unsupported: false
      },
      'aria-grabbed': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ],
        unsupported: false
      },
      'aria-haspopup': {
        type: 'nmtoken',
        allowEmpty: true,
        values: [ 'true', 'false', 'menu', 'listbox', 'tree', 'grid', 'dialog' ],
        unsupported: false
      },
      'aria-hidden': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-invalid': {
        type: 'nmtoken',
        allowEmpty: true,
        values: [ 'true', 'false', 'spelling', 'grammar' ],
        unsupported: false
      },
      'aria-keyshortcuts': {
        type: 'string',
        allowEmpty: true,
        unsupported: false
      },
      'aria-label': {
        type: 'string',
        allowEmpty: true,
        unsupported: false
      },
      'aria-labelledby': {
        type: 'idrefs',
        allowEmpty: true,
        unsupported: false
      },
      'aria-level': {
        type: 'int',
        unsupported: false
      },
      'aria-live': {
        type: 'nmtoken',
        values: [ 'off', 'polite', 'assertive' ],
        unsupported: false
      },
      'aria-modal': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-multiline': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-multiselectable': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-orientation': {
        type: 'nmtoken',
        values: [ 'horizontal', 'vertical' ],
        unsupported: false
      },
      'aria-owns': {
        type: 'idrefs',
        allowEmpty: true,
        unsupported: false
      },
      'aria-placeholder': {
        type: 'string',
        allowEmpty: true,
        unsupported: false
      },
      'aria-posinset': {
        type: 'int',
        unsupported: false
      },
      'aria-pressed': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'mixed', 'undefined' ],
        unsupported: false
      },
      'aria-readonly': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-relevant': {
        type: 'nmtokens',
        values: [ 'additions', 'removals', 'text', 'all' ],
        unsupported: false
      },
      'aria-required': {
        type: 'boolean',
        values: [ 'true', 'false' ],
        unsupported: false
      },
      'aria-roledescription': {
        type: 'string',
        allowEmpty: true,
        unsupported: false
      },
      'aria-rowcount': {
        type: 'int',
        unsupported: false
      },
      'aria-rowindex': {
        type: 'int',
        unsupported: false
      },
      'aria-rowspan': {
        type: 'int',
        unsupported: false
      },
      'aria-selected': {
        type: 'nmtoken',
        values: [ 'true', 'false', 'undefined' ],
        unsupported: false
      },
      'aria-setsize': {
        type: 'int',
        unsupported: false
      },
      'aria-sort': {
        type: 'nmtoken',
        values: [ 'ascending', 'descending', 'other', 'none' ],
        unsupported: false
      },
      'aria-valuemax': {
        type: 'decimal',
        unsupported: false
      },
      'aria-valuemin': {
        type: 'decimal',
        unsupported: false
      },
      'aria-valuenow': {
        type: 'decimal',
        unsupported: false
      },
      'aria-valuetext': {
        type: 'string',
        unsupported: false
      }
    };
    lookupTable.globalAttributes = [ 'aria-atomic', 'aria-busy', 'aria-controls', 'aria-current', 'aria-describedby', 'aria-details', 'aria-disabled', 'aria-dropeffect', 'aria-flowto', 'aria-grabbed', 'aria-haspopup', 'aria-hidden', 'aria-invalid', 'aria-keyshortcuts', 'aria-label', 'aria-labelledby', 'aria-live', 'aria-owns', 'aria-relevant', 'aria-roledescription' ];
    lookupTable.role = {
      alert: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      alertdialog: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-modal', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'dialog', 'section' ]
      },
      application: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage', 'aria-activedescendant' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'article', 'audio', 'embed', 'iframe', 'object', 'section', 'svg', 'video' ]
      },
      article: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'article' ],
        unsupported: false
      },
      banner: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'header' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      button: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-pressed', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'button', 'input[type="button"]', 'input[type="image"]', 'input[type="reset"]', 'input[type="submit"]', 'summary' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      cell: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-colindex', 'aria-colspan', 'aria-rowindex', 'aria-rowspan', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'row' ],
        implicit: [ 'td', 'th' ],
        unsupported: false
      },
      checkbox: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-checked', 'aria-required', 'aria-readonly', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'input[type="checkbox"]' ],
        unsupported: false,
        allowedElements: [ 'button' ]
      },
      columnheader: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-required', 'aria-readonly', 'aria-selected', 'aria-sort', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'row' ],
        implicit: [ 'th' ],
        unsupported: false
      },
      combobox: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-autocomplete', 'aria-required', 'aria-activedescendant', 'aria-orientation', 'aria-errormessage' ],
          required: [ 'aria-expanded' ]
        },
        owned: {
          all: [ 'listbox', 'tree', 'grid', 'dialog', 'textbox' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: 'input',
          properties: {
            type: [ 'text', 'search', 'tel', 'url', 'email' ]
          }
        } ]
      },
      command: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      complementary: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'aside' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      composite: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      contentinfo: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'footer' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      definition: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'dd', 'dfn' ],
        unsupported: false
      },
      dialog: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-modal', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'dialog' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      directory: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      document: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'body' ],
        unsupported: false,
        allowedElements: [ 'article', 'embed', 'iframe', 'object', 'section', 'svg' ]
      },
      'doc-abstract': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-acknowledgments': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-afterword': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-appendix': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-backlink': {
        type: 'link',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      'doc-biblioentry': {
        type: 'listitem',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: [ 'doc-bibliography' ],
        unsupported: false,
        allowedElements: [ 'li' ]
      },
      'doc-bibliography': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'doc-biblioentry' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-biblioref': {
        type: 'link',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      'doc-chapter': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-colophon': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-conclusion': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-cover': {
        type: 'img',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false
      },
      'doc-credit': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-credits': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-dedication': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-endnote': {
        type: 'listitem',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: [ 'doc-endnotes' ],
        unsupported: false,
        allowedElements: [ 'li' ]
      },
      'doc-endnotes': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'doc-endnote' ]
        },
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-epigraph': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false
      },
      'doc-epilogue': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-errata': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-example': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'aside', 'section' ]
      },
      'doc-footnote': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'aside', 'footer', 'header' ]
      },
      'doc-foreword': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-glossary': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: [ 'term', 'definition' ],
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'dl' ]
      },
      'doc-glossref': {
        type: 'link',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      'doc-index': {
        type: 'navigation',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'nav', 'section' ]
      },
      'doc-introduction': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-noteref': {
        type: 'link',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      'doc-notice': {
        type: 'note',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-pagebreak': {
        type: 'separator',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'hr' ]
      },
      'doc-pagelist': {
        type: 'navigation',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'nav', 'section' ]
      },
      'doc-part': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-preface': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-prologue': {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-pullquote': {
        type: 'none',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'aside', 'section' ]
      },
      'doc-qna': {
        type: 'section',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      'doc-subtitle': {
        type: 'sectionhead',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: {
          nodeName: [ 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ]
        }
      },
      'doc-tip': {
        type: 'note',
        attributes: {
          allowed: [ 'aria-expanded' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'aside' ]
      },
      'doc-toc': {
        type: 'navigation',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        namefrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'nav', 'section' ]
      },
      feed: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'article' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'article', 'aside', 'section' ]
      },
      figure: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'figure' ],
        unsupported: false
      },
      form: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'form' ],
        unsupported: false
      },
      grid: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-colcount', 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-rowcount', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'rowgroup', 'row' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'table' ],
        unsupported: false
      },
      gridcell: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-selected', 'aria-readonly', 'aria-required', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'row' ],
        implicit: [ 'td', 'th' ],
        unsupported: false
      },
      group: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'details', 'optgroup' ],
        unsupported: false,
        allowedElements: [ 'dl', 'figcaption', 'fieldset', 'figure', 'footer', 'header', 'ol', 'ul' ]
      },
      heading: {
        type: 'structure',
        attributes: {
          required: [ 'aria-level' ],
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ],
        unsupported: false
      },
      img: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'img' ],
        unsupported: false,
        allowedElements: [ 'embed', 'iframe', 'object', 'svg' ]
      },
      input: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      landmark: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      link: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'a[href]', 'area[href]' ],
        unsupported: false,
        allowedElements: [ 'button', {
          nodeName: 'input',
          properties: {
            type: [ 'image', 'button' ]
          }
        } ]
      },
      list: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: {
          all: [ 'listitem' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'ol', 'ul', 'dl' ],
        unsupported: false
      },
      listbox: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          all: [ 'option' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'select' ],
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      listitem: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'list' ],
        implicit: [ 'li', 'dt' ],
        unsupported: false
      },
      log: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      main: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'main' ],
        unsupported: false,
        allowedElements: [ 'article', 'section' ]
      },
      marquee: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      math: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'math' ],
        unsupported: false
      },
      menu: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'menuitem', 'menuitemradio', 'menuitemcheckbox' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'menu[type="context"]' ],
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      menubar: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'menuitem', 'menuitemradio', 'menuitemcheckbox' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      menuitem: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-posinset', 'aria-setsize', 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'menu', 'menubar' ],
        implicit: [ 'menuitem[type="command"]' ],
        unsupported: false,
        allowedElements: [ 'button', 'li', {
          nodeName: 'iput',
          properties: {
            type: [ 'image', 'button' ]
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      menuitemcheckbox: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-checked', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'menu', 'menubar' ],
        implicit: [ 'menuitem[type="checkbox"]' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'button', 'li' ]
        }, {
          nodeName: 'input',
          properties: {
            type: [ 'checkbox', 'image', 'button' ]
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      menuitemradio: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-checked', 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'menu', 'menubar' ],
        implicit: [ 'menuitem[type="radio"]' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'button', 'li' ]
        }, {
          nodeName: 'input',
          properties: {
            type: [ 'image', 'button', 'radio' ]
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      navigation: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'nav' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      none: {
        type: 'structure',
        attributes: null,
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'article', 'aside', 'dl', 'embed', 'figcaption', 'fieldset', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hr', 'iframe', 'li', 'ol', 'section', 'ul' ]
        }, {
          nodeName: 'img',
          attributes: {
            alt: isNotNull
          }
        } ]
      },
      note: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'aside' ]
      },
      option: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-checked', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'listbox' ],
        implicit: [ 'option' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'button', 'li' ]
        }, {
          nodeName: 'input',
          properties: {
            type: [ 'checkbox', 'button' ]
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      presentation: {
        type: 'structure',
        attributes: null,
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'article', 'aside', 'dl', 'embed', 'figcaption', 'fieldset', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hr', 'iframe', 'li', 'ol', 'section', 'ul' ]
        }, {
          nodeName: 'img',
          attributes: {
            alt: isNotNull
          }
        } ]
      },
      progressbar: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-valuetext', 'aria-valuenow', 'aria-valuemax', 'aria-valuemin', 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'progress' ],
        unsupported: false
      },
      radio: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-selected', 'aria-posinset', 'aria-setsize', 'aria-required', 'aria-errormessage', 'aria-checked' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'input[type="radio"]' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'button', 'li' ]
        }, {
          nodeName: 'input',
          properties: {
            type: [ 'image', 'button' ]
          }
        } ]
      },
      radiogroup: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-required', 'aria-expanded', 'aria-readonly', 'aria-errormessage', 'aria-orientation' ]
        },
        owned: {
          all: [ 'radio' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: {
          nodeName: [ 'ol', 'ul', 'fieldset' ]
        }
      },
      range: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      region: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'section[aria-label]', 'section[aria-labelledby]', 'section[title]' ],
        unsupported: false,
        allowedElements: {
          nodeName: [ 'article', 'aside' ]
        }
      },
      roletype: {
        type: 'abstract',
        unsupported: false
      },
      row: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-colindex', 'aria-expanded', 'aria-level', 'aria-selected', 'aria-rowindex', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'cell', 'columnheader', 'rowheader', 'gridcell' ]
        },
        nameFrom: [ 'author', 'contents' ],
        context: [ 'rowgroup', 'grid', 'treegrid', 'table' ],
        implicit: [ 'tr' ],
        unsupported: false
      },
      rowgroup: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-errormessage' ]
        },
        owned: {
          all: [ 'row' ]
        },
        nameFrom: [ 'author', 'contents' ],
        context: [ 'grid', 'table', 'treegrid' ],
        implicit: [ 'tbody', 'thead', 'tfoot' ],
        unsupported: false
      },
      rowheader: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-colindex', 'aria-colspan', 'aria-expanded', 'aria-rowindex', 'aria-rowspan', 'aria-required', 'aria-readonly', 'aria-selected', 'aria-sort', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'row' ],
        implicit: [ 'th' ],
        unsupported: false
      },
      scrollbar: {
        type: 'widget',
        attributes: {
          required: [ 'aria-controls', 'aria-valuenow' ],
          allowed: [ 'aria-valuetext', 'aria-orientation', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false
      },
      search: {
        type: 'landmark',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: {
          nodeName: [ 'aside', 'form', 'section' ]
        }
      },
      searchbox: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-readonly', 'aria-required', 'aria-placeholder', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'input[type="search"]' ],
        unsupported: false,
        allowedElements: {
          nodeName: 'input',
          properties: {
            type: 'text'
          }
        }
      },
      section: {
        nameFrom: [ 'author', 'contents' ],
        type: 'abstract',
        unsupported: false
      },
      sectionhead: {
        nameFrom: [ 'author', 'contents' ],
        type: 'abstract',
        unsupported: false
      },
      select: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      },
      separator: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-orientation', 'aria-valuenow', 'aria-valuemax', 'aria-valuemin', 'aria-valuetext', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'hr' ],
        unsupported: false,
        allowedElements: [ 'li' ]
      },
      slider: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-valuetext', 'aria-orientation', 'aria-readonly', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ],
          required: [ 'aria-valuenow' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'input[type="range"]' ],
        unsupported: false
      },
      spinbutton: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-valuetext', 'aria-required', 'aria-readonly', 'aria-errormessage', 'aria-valuemax', 'aria-valuemin' ],
          required: [ 'aria-valuenow' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'input[type="number"]' ],
        unsupported: false,
        allowedElements: {
          nodeName: 'input',
          properties: {
            type: [ 'text', 'tel' ]
          }
        }
      },
      status: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'output' ],
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      structure: {
        type: 'abstract',
        unsupported: false
      },
      switch: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-errormessage' ],
          required: [ 'aria-checked' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'button', {
          nodeName: 'input',
          properties: {
            type: [ 'checkbox', 'image', 'button' ]
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      tab: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-selected', 'aria-expanded', 'aria-setsize', 'aria-posinset', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'tablist' ],
        unsupported: false,
        allowedElements: [ {
          nodeName: [ 'button', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'li' ]
        }, {
          nodeName: 'input',
          properties: {
            type: 'button'
          }
        }, {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      table: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-colcount', 'aria-rowcount', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'rowgroup', 'row' ]
        },
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'table' ],
        unsupported: false
      },
      tablist: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          all: [ 'tab' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      tabpanel: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'section' ]
      },
      term: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        implicit: [ 'dt' ],
        unsupported: false
      },
      textbox: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-autocomplete', 'aria-multiline', 'aria-readonly', 'aria-required', 'aria-placeholder', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'input[type="text"]', 'input[type="email"]', 'input[type="password"]', 'input[type="tel"]', 'input[type="url"]', 'input:not([type])', 'textarea' ],
        unsupported: false
      },
      timer: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false
      },
      toolbar: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author' ],
        context: null,
        implicit: [ 'menu[type="toolbar"]' ],
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      tooltip: {
        type: 'structure',
        attributes: {
          allowed: [ 'aria-expanded', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: null,
        unsupported: false
      },
      tree: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-multiselectable', 'aria-required', 'aria-expanded', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          all: [ 'treeitem' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false,
        allowedElements: [ 'ol', 'ul' ]
      },
      treegrid: {
        type: 'composite',
        attributes: {
          allowed: [ 'aria-activedescendant', 'aria-colcount', 'aria-expanded', 'aria-level', 'aria-multiselectable', 'aria-readonly', 'aria-required', 'aria-rowcount', 'aria-orientation', 'aria-errormessage' ]
        },
        owned: {
          one: [ 'rowgroup', 'row' ]
        },
        nameFrom: [ 'author' ],
        context: null,
        unsupported: false
      },
      treeitem: {
        type: 'widget',
        attributes: {
          allowed: [ 'aria-checked', 'aria-selected', 'aria-expanded', 'aria-level', 'aria-posinset', 'aria-setsize', 'aria-errormessage' ]
        },
        owned: null,
        nameFrom: [ 'author', 'contents' ],
        context: [ 'group', 'tree' ],
        unsupported: false,
        allowedElements: [ 'li', {
          nodeName: 'a',
          attributes: {
            href: isNotNull
          }
        } ]
      },
      widget: {
        type: 'abstract',
        unsupported: false
      },
      window: {
        nameFrom: [ 'author' ],
        type: 'abstract',
        unsupported: false
      }
    };
    lookupTable.implicitHtmlRole = implicit_html_roles_default;
    lookupTable.elementsAllowedNoRole = [ {
      nodeName: [ 'base', 'body', 'caption', 'col', 'colgroup', 'datalist', 'dd', 'details', 'dt', 'head', 'html', 'keygen', 'label', 'legend', 'main', 'map', 'math', 'meta', 'meter', 'noscript', 'optgroup', 'param', 'picture', 'progress', 'script', 'source', 'style', 'template', 'textarea', 'title', 'track' ]
    }, {
      nodeName: 'area',
      attributes: {
        href: isNotNull
      }
    }, {
      nodeName: 'input',
      properties: {
        type: [ 'color', 'data', 'datatime', 'file', 'hidden', 'month', 'number', 'password', 'range', 'reset', 'submit', 'time', 'week' ]
      }
    }, {
      nodeName: 'link',
      attributes: {
        href: isNotNull
      }
    }, {
      nodeName: 'menu',
      attributes: {
        type: 'context'
      }
    }, {
      nodeName: 'menuitem',
      attributes: {
        type: [ 'command', 'checkbox', 'radio' ]
      }
    }, {
      nodeName: 'select',
      condition: function condition(vNode) {
        if (!(vNode instanceof axe.AbstractVirtualNode)) {
          vNode = axe.utils.getNodeFromTree(vNode);
        }
        return Number(vNode.attr('size')) > 1;
      },
      properties: {
        multiple: true
      }
    }, {
      nodeName: [ 'clippath', 'cursor', 'defs', 'desc', 'feblend', 'fecolormatrix', 'fecomponenttransfer', 'fecomposite', 'feconvolvematrix', 'fediffuselighting', 'fedisplacementmap', 'fedistantlight', 'fedropshadow', 'feflood', 'fefunca', 'fefuncb', 'fefuncg', 'fefuncr', 'fegaussianblur', 'feimage', 'femerge', 'femergenode', 'femorphology', 'feoffset', 'fepointlight', 'fespecularlighting', 'fespotlight', 'fetile', 'feturbulence', 'filter', 'hatch', 'hatchpath', 'lineargradient', 'marker', 'mask', 'meshgradient', 'meshpatch', 'meshrow', 'metadata', 'mpath', 'pattern', 'radialgradient', 'solidcolor', 'stop', 'switch', 'view' ]
    } ];
    lookupTable.elementsAllowedAnyRole = [ {
      nodeName: 'a',
      attributes: {
        href: isNull
      }
    }, {
      nodeName: 'img',
      attributes: {
        alt: isNull
      }
    }, {
      nodeName: [ 'abbr', 'address', 'canvas', 'div', 'p', 'pre', 'blockquote', 'ins', 'del', 'output', 'span', 'table', 'tbody', 'thead', 'tfoot', 'td', 'em', 'strong', 'small', 's', 'cite', 'q', 'dfn', 'abbr', 'time', 'code', 'var', 'samp', 'kbd', 'sub', 'sup', 'i', 'b', 'u', 'mark', 'ruby', 'rt', 'rp', 'bdi', 'bdo', 'br', 'wbr', 'th', 'tr' ]
    } ];
    lookupTable.evaluateRoleForElement = {
      A: function A(_ref84) {
        var node = _ref84.node, out = _ref84.out;
        if (node.namespaceURI === 'http://www.w3.org/2000/svg') {
          return true;
        }
        if (node.href.length) {
          return out;
        }
        return true;
      },
      AREA: function AREA(_ref85) {
        var node = _ref85.node;
        return !node.href;
      },
      BUTTON: function BUTTON(_ref86) {
        var node = _ref86.node, role = _ref86.role, out = _ref86.out;
        if (node.getAttribute('type') === 'menu') {
          return role === 'menuitem';
        }
        return out;
      },
      IMG: function IMG(_ref87) {
        var node = _ref87.node, role = _ref87.role, out = _ref87.out;
        switch (node.alt) {
         case null:
          return out;

         case '':
          return role === 'presentation' || role === 'none';

         default:
          return role !== 'presentation' && role !== 'none';
        }
      },
      INPUT: function INPUT(_ref88) {
        var node = _ref88.node, role = _ref88.role, out = _ref88.out;
        switch (node.type) {
         case 'button':
         case 'image':
          return out;

         case 'checkbox':
          if (role === 'button' && node.hasAttribute('aria-pressed')) {
            return true;
          }
          return out;

         case 'radio':
          return role === 'menuitemradio';

         case 'text':
          return role === 'combobox' || role === 'searchbox' || role === 'spinbutton';

         case 'tel':
          return role === 'combobox' || role === 'spinbutton';

         case 'url':
         case 'search':
         case 'email':
          return role === 'combobox';

         default:
          return false;
        }
      },
      LI: function LI(_ref89) {
        var node = _ref89.node, out = _ref89.out;
        var hasImplicitListitemRole = axe.utils.matchesSelector(node, 'ol li, ul li');
        if (hasImplicitListitemRole) {
          return out;
        }
        return true;
      },
      MENU: function MENU(_ref90) {
        var node = _ref90.node;
        if (node.getAttribute('type') === 'context') {
          return false;
        }
        return true;
      },
      OPTION: function OPTION(_ref91) {
        var node = _ref91.node;
        var withinOptionList = axe.utils.matchesSelector(node, 'select > option, datalist > option, optgroup > option');
        return !withinOptionList;
      },
      SELECT: function SELECT(_ref92) {
        var node = _ref92.node, role = _ref92.role;
        return !node.multiple && node.size <= 1 && role === 'menu';
      },
      SVG: function SVG(_ref93) {
        var node = _ref93.node, out = _ref93.out;
        if (node.parentNode && node.parentNode.namespaceURI === 'http://www.w3.org/2000/svg') {
          return true;
        }
        return out;
      }
    };
    lookupTable.rolesOfType = {
      widget: [ 'button', 'checkbox', 'dialog', 'gridcell', 'link', 'log', 'marquee', 'menuitem', 'menuitemcheckbox', 'menuitemradio', 'option', 'progressbar', 'radio', 'scrollbar', 'searchbox', 'slider', 'spinbutton', 'status', 'switch', 'tab', 'tabpanel', 'textbox', 'timer', 'tooltip', 'tree', 'treeitem' ]
    };
    var lookup_table_default = lookupTable;
    function implicitNodes(role) {
      var implicit = null;
      var roles = lookup_table_default.role[role];
      if (roles && roles.implicit) {
        implicit = _clone(roles.implicit);
      }
      return implicit;
    }
    var implicit_nodes_default = implicitNodes;
    function isAccessibleRef(node) {
      return !!get_accessible_refs_default(node).length;
    }
    var is_accessible_ref_default = isAccessibleRef;
    function _isComboboxPopup(virtualNode) {
      var _popupRoles;
      var _ref94 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, popupRoles = _ref94.popupRoles;
      var role = get_role_default(virtualNode);
      (_popupRoles = popupRoles) !== null && _popupRoles !== void 0 ? _popupRoles : popupRoles = aria_attrs_default['aria-haspopup'].values;
      if (!popupRoles.includes(role)) {
        return false;
      }
      var vParent = nearestParentWithRole(virtualNode);
      if (isCombobox(vParent)) {
        return true;
      }
      var id = virtualNode.props.id;
      if (!id) {
        return false;
      }
      if (!virtualNode.actualNode) {
        throw new Error('Unable to determine combobox popup without an actualNode');
      }
      var root = get_root_node_default(virtualNode.actualNode);
      var ownedCombobox = root.querySelectorAll('[aria-owns~="'.concat(id, '"][role~="combobox"]:not(select),\n     [aria-controls~="').concat(id, '"][role~="combobox"]:not(select)'));
      return Array.from(ownedCombobox).some(isCombobox);
    }
    var isCombobox = function isCombobox(node) {
      return node && get_role_default(node) === 'combobox';
    };
    function nearestParentWithRole(vNode) {
      while (vNode = vNode.parent) {
        if (get_role_default(vNode, {
          noPresentational: true
        }) !== null) {
          return vNode;
        }
      }
      return null;
    }
    function label2(node) {
      node = get_node_from_tree_default(node);
      return label_virtual_default(node);
    }
    var label_default2 = label2;
    function requiredAttr(role) {
      var roleDef = standards_default.ariaRoles[role];
      if (!roleDef || !Array.isArray(roleDef.requiredAttrs)) {
        return [];
      }
      return _toConsumableArray(roleDef.requiredAttrs);
    }
    var required_attr_default = requiredAttr;
    function requiredContext(role) {
      var roleDef = standards_default.ariaRoles[role];
      if (!roleDef || !Array.isArray(roleDef.requiredContext)) {
        return null;
      }
      return _toConsumableArray(roleDef.requiredContext);
    }
    var required_context_default = requiredContext;
    function requiredOwned(role) {
      var roleDef = standards_default.ariaRoles[role];
      if (!roleDef || !Array.isArray(roleDef.requiredOwned)) {
        return null;
      }
      return _toConsumableArray(roleDef.requiredOwned);
    }
    var required_owned_default = requiredOwned;
    function validateAttrValue(vNode, attr) {
      vNode = vNode instanceof abstract_virtual_node_default ? vNode : get_node_from_tree_default(vNode);
      var matches4;
      var list;
      var value = vNode.attr(attr);
      var attrInfo = standards_default.ariaAttrs[attr];
      if (!attrInfo) {
        return true;
      }
      if (attrInfo.allowEmpty && (!value || value.trim() === '')) {
        return true;
      }
      switch (attrInfo.type) {
       case 'boolean':
        return [ 'true', 'false' ].includes(value.toLowerCase());

       case 'nmtoken':
        return typeof value === 'string' && attrInfo.values.includes(value.toLowerCase());

       case 'nmtokens':
        list = token_list_default(value);
        return list.reduce(function(result, token) {
          return result && attrInfo.values.includes(token);
        }, list.length !== 0);

       case 'idref':
        try {
          var doc = get_root_node_default2(vNode.actualNode);
          return !!(value && doc.getElementById(value));
        } catch (e) {
          throw new TypeError('Cannot resolve id references for partial DOM');
        }

       case 'idrefs':
        return idrefs_default(vNode, attr).some(function(node) {
          return !!node;
        });

       case 'string':
        return value.trim() !== '';

       case 'decimal':
        matches4 = value.match(/^[-+]?([0-9]*)\.?([0-9]*)$/);
        return !!(matches4 && (matches4[1] || matches4[2]));

       case 'int':
        var minValue = typeof attrInfo.minValue !== 'undefined' ? attrInfo.minValue : -Infinity;
        return /^[-+]?[0-9]+$/.test(value) && parseInt(value) >= minValue;
      }
    }
    var validate_attr_value_default = validateAttrValue;
    function validateAttr(att) {
      var attrDefinition = standards_default.ariaAttrs[att];
      return !!attrDefinition;
    }
    var validate_attr_default = validateAttr;
    function abstractroleEvaluate(node, options, virtualNode) {
      var abstractRoles = token_list_default(virtualNode.attr('role')).filter(function(role) {
        return get_role_type_default(role) === 'abstract';
      });
      if (abstractRoles.length > 0) {
        this.data(abstractRoles);
        return true;
      }
      return false;
    }
    var abstractrole_evaluate_default = abstractroleEvaluate;
    function ariaAllowedAttrEvaluate(node, options, virtualNode) {
      var invalid = [];
      var role = get_role_default(virtualNode);
      var allowed = allowed_attr_default(role);
      if (Array.isArray(options[role])) {
        allowed = unique_array_default(options[role].concat(allowed));
      }
      var _iterator15 = _createForOfIteratorHelper(virtualNode.attrNames), _step15;
      try {
        for (_iterator15.s(); !(_step15 = _iterator15.n()).done; ) {
          var attrName = _step15.value;
          if (validate_attr_default(attrName) && !allowed.includes(attrName)) {
            invalid.push(attrName);
          }
        }
      } catch (err) {
        _iterator15.e(err);
      } finally {
        _iterator15.f();
      }
      if (!invalid.length) {
        return true;
      }
      this.data(invalid.map(function(attrName) {
        return attrName + '="' + virtualNode.attr(attrName) + '"';
      }));
      if (!role && !is_html_element_default(virtualNode) && !_isFocusable(virtualNode)) {
        return void 0;
      }
      return false;
    }
    function ariaAllowedRoleEvaluate(node) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var virtualNode = arguments.length > 2 ? arguments[2] : undefined;
      var _options$allowImplici = options.allowImplicit, allowImplicit = _options$allowImplici === void 0 ? true : _options$allowImplici, _options$ignoredTags = options.ignoredTags, ignoredTags = _options$ignoredTags === void 0 ? [] : _options$ignoredTags;
      var nodeName2 = virtualNode.props.nodeName;
      if (ignoredTags.map(function(tag) {
        return tag.toLowerCase();
      }).includes(nodeName2)) {
        return true;
      }
      var unallowedRoles = get_element_unallowed_roles_default(virtualNode, allowImplicit);
      if (unallowedRoles.length) {
        this.data(unallowedRoles);
        if (!_isVisibleToScreenReaders(virtualNode)) {
          return void 0;
        }
        return false;
      }
      return true;
    }
    var aria_allowed_role_evaluate_default = ariaAllowedRoleEvaluate;
    function ariaBusyEvaluate(node, options, virtualNode) {
      return virtualNode.attr('aria-busy') === 'true';
    }
    function ariaConditionalCheckboxAttr(node, options, virtualNode) {
      var _virtualNode$props = virtualNode.props, nodeName2 = _virtualNode$props.nodeName, type2 = _virtualNode$props.type;
      var ariaChecked = normalizeAriaChecked(virtualNode.attr('aria-checked'));
      if (nodeName2 !== 'input' || type2 !== 'checkbox' || !ariaChecked) {
        return true;
      }
      var checkState = getCheckState(virtualNode);
      if (ariaChecked === checkState) {
        return true;
      }
      this.data({
        messageKey: 'checkbox',
        checkState: checkState
      });
      return false;
    }
    function getCheckState(vNode) {
      if (vNode.props.indeterminate) {
        return 'mixed';
      }
      return vNode.props.checked ? 'true' : 'false';
    }
    function normalizeAriaChecked(ariaCheckedVal) {
      if (!ariaCheckedVal) {
        return '';
      }
      ariaCheckedVal = ariaCheckedVal.toLowerCase();
      if ([ 'mixed', 'true' ].includes(ariaCheckedVal)) {
        return ariaCheckedVal;
      }
      return 'false';
    }
    function ariaConditionalRowAttr(node) {
      var _invalidTableRowAttrs, _invalidTableRowAttrs2;
      var _ref95 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, invalidTableRowAttrs = _ref95.invalidTableRowAttrs;
      var virtualNode = arguments.length > 2 ? arguments[2] : undefined;
      var invalidAttrs = (_invalidTableRowAttrs = invalidTableRowAttrs === null || invalidTableRowAttrs === void 0 ? void 0 : (_invalidTableRowAttrs2 = invalidTableRowAttrs.filter) === null || _invalidTableRowAttrs2 === void 0 ? void 0 : _invalidTableRowAttrs2.call(invalidTableRowAttrs, function(invalidAttr) {
        return virtualNode.hasAttr(invalidAttr);
      })) !== null && _invalidTableRowAttrs !== void 0 ? _invalidTableRowAttrs : [];
      if (invalidAttrs.length === 0) {
        return true;
      }
      var owner = getRowOwner(virtualNode);
      var ownerRole = owner && get_role_default(owner);
      if (!ownerRole || ownerRole === 'treegrid') {
        return true;
      }
      var messageKey = 'row'.concat(invalidAttrs.length > 1 ? 'Plural' : 'Singular');
      this.data({
        messageKey: messageKey,
        invalidAttrs: invalidAttrs,
        ownerRole: ownerRole
      });
      return false;
    }
    function getRowOwner(virtualNode) {
      if (!virtualNode.parent) {
        return;
      }
      var rowOwnerQuery = 'table:not([role]), [role~="treegrid"], [role~="table"], [role~="grid"]';
      return closest_default(virtualNode, rowOwnerQuery);
    }
    var conditionalRoleMap = {
      row: ariaConditionalRowAttr,
      checkbox: ariaConditionalCheckboxAttr
    };
    function ariaConditionalAttrEvaluate(node, options, virtualNode) {
      var role = get_role_default(virtualNode);
      if (!conditionalRoleMap[role]) {
        return true;
      }
      return conditionalRoleMap[role].call(this, node, options, virtualNode);
    }
    function ariaErrormessageEvaluate(node, options, virtualNode) {
      options = Array.isArray(options) ? options : [];
      var errorMessageAttr = virtualNode.attr('aria-errormessage');
      var hasAttr = virtualNode.hasAttr('aria-errormessage');
      var invaid = virtualNode.attr('aria-invalid');
      var hasInvallid = virtualNode.hasAttr('aria-invalid');
      if (!hasInvallid || invaid === 'false') {
        return true;
      }
      function validateAttrValue2(attr) {
        if (attr.trim() === '') {
          return standards_default.ariaAttrs['aria-errormessage'].allowEmpty;
        }
        var idref;
        try {
          idref = attr && idrefs_default(virtualNode, 'aria-errormessage')[0];
        } catch (e) {
          this.data({
            messageKey: 'idrefs',
            values: token_list_default(attr)
          });
          return void 0;
        }
        if (idref) {
          if (!_isVisibleToScreenReaders(idref)) {
            this.data({
              messageKey: 'hidden',
              values: token_list_default(attr)
            });
            return false;
          }
          return idref.getAttribute('role') === 'alert' || idref.getAttribute('aria-live') === 'assertive' || idref.getAttribute('aria-live') === 'polite' || token_list_default(virtualNode.attr('aria-describedby')).indexOf(attr) > -1;
        }
        return;
      }
      if (options.indexOf(errorMessageAttr) === -1 && hasAttr) {
        this.data(token_list_default(errorMessageAttr));
        return validateAttrValue2.call(this, errorMessageAttr);
      }
      return true;
    }
    function ariaHiddenBodyEvaluate(node, options, virtualNode) {
      return virtualNode.attr('aria-hidden') !== 'true';
    }
    var aria_hidden_body_evaluate_default = ariaHiddenBodyEvaluate;
    function ariaLevelEvaluate(node, options, virtualNode) {
      var ariaHeadingLevel = virtualNode.attr('aria-level');
      var ariaLevel = parseInt(ariaHeadingLevel, 10);
      if (ariaLevel > 6) {
        return void 0;
      }
      return true;
    }
    var aria_level_evaluate_default = ariaLevelEvaluate;
    function ariaProhibitedAttrEvaluate(node) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var virtualNode = arguments.length > 2 ? arguments[2] : undefined;
      var elementsAllowedAriaLabel = (options === null || options === void 0 ? void 0 : options.elementsAllowedAriaLabel) || [];
      var nodeName2 = virtualNode.props.nodeName;
      var role = get_role_default(virtualNode, {
        chromium: true
      });
      var prohibitedList = listProhibitedAttrs(role, nodeName2, elementsAllowedAriaLabel);
      var prohibited = prohibitedList.filter(function(attrName) {
        if (!virtualNode.attrNames.includes(attrName)) {
          return false;
        }
        return sanitize_default(virtualNode.attr(attrName)) !== '';
      });
      if (prohibited.length === 0) {
        return false;
      }
      var messageKey = virtualNode.hasAttr('role') ? 'hasRole' : 'noRole';
      messageKey += prohibited.length > 1 ? 'Plural' : 'Singular';
      this.data({
        role: role,
        nodeName: nodeName2,
        messageKey: messageKey,
        prohibited: prohibited
      });
      var textContent = subtree_text_default(virtualNode, {
        subtreeDescendant: true
      });
      if (sanitize_default(textContent) !== '') {
        return void 0;
      }
      return true;
    }
    function listProhibitedAttrs(role, nodeName2, elementsAllowedAriaLabel) {
      var roleSpec = standards_default.ariaRoles[role];
      if (roleSpec) {
        return roleSpec.prohibitedAttrs || [];
      }
      if (!!role || elementsAllowedAriaLabel.includes(nodeName2)) {
        return [];
      }
      return [ 'aria-label', 'aria-labelledby' ];
    }
    var standards_exports = {};
    __export(standards_exports, {
      getAriaRolesByType: function getAriaRolesByType() {
        return get_aria_roles_by_type_default;
      },
      getAriaRolesSupportingNameFromContent: function getAriaRolesSupportingNameFromContent() {
        return get_aria_roles_supporting_name_from_content_default;
      },
      getElementSpec: function getElementSpec() {
        return get_element_spec_default;
      },
      getElementsByContentType: function getElementsByContentType() {
        return get_elements_by_content_type_default;
      },
      getGlobalAriaAttrs: function getGlobalAriaAttrs() {
        return get_global_aria_attrs_default;
      },
      implicitHtmlRoles: function implicitHtmlRoles() {
        return implicit_html_roles_default;
      }
    });
    function ariaRequiredAttrEvaluate(node) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var virtualNode = arguments.length > 2 ? arguments[2] : undefined;
      var role = get_explicit_role_default(virtualNode);
      var attrs = virtualNode.attrNames;
      var requiredAttrs = required_attr_default(role);
      if (Array.isArray(options[role])) {
        requiredAttrs = unique_array_default(options[role], requiredAttrs);
      }
      if (!role || !attrs.length || !requiredAttrs.length) {
        return true;
      }
      if (isStaticSeparator(virtualNode, role) || isClosedCombobox(virtualNode, role)) {
        return true;
      }
      var elmSpec = get_element_spec_default(virtualNode);
      var missingAttrs = requiredAttrs.filter(function(requiredAttr2) {
        return !virtualNode.attr(requiredAttr2) && !hasImplicitAttr(elmSpec, requiredAttr2);
      });
      if (missingAttrs.length) {
        this.data(missingAttrs);
        return false;
      }
      return true;
    }
    function isStaticSeparator(vNode, role) {
      return role === 'separator' && !_isFocusable(vNode);
    }
    function hasImplicitAttr(elmSpec, attr) {
      var _elmSpec$implicitAttr;
      return ((_elmSpec$implicitAttr = elmSpec.implicitAttrs) === null || _elmSpec$implicitAttr === void 0 ? void 0 : _elmSpec$implicitAttr[attr]) !== void 0;
    }
    function isClosedCombobox(vNode, role) {
      return role === 'combobox' && vNode.attr('aria-expanded') === 'false';
    }
    function ariaRequiredChildrenEvaluate(node, options, virtualNode) {
      var reviewEmpty = options && Array.isArray(options.reviewEmpty) ? options.reviewEmpty : [];
      var explicitRole2 = get_explicit_role_default(virtualNode, {
        dpub: true
      });
      var required = required_owned_default(explicitRole2);
      if (required === null) {
        return true;
      }
      var ownedRoles = getOwnedRoles(virtualNode, required);
      var unallowed = ownedRoles.filter(function(_ref96) {
        var role = _ref96.role, vNode = _ref96.vNode;
        return vNode.props.nodeType === 1 && !required.includes(role);
      });
      if (unallowed.length) {
        this.relatedNodes(unallowed.map(function(_ref97) {
          var vNode = _ref97.vNode;
          return vNode;
        }));
        this.data({
          messageKey: 'unallowed',
          values: unallowed.map(function(_ref98) {
            var vNode = _ref98.vNode, attr = _ref98.attr;
            return getUnallowedSelector(vNode, attr);
          }).filter(function(selector, index, array) {
            return array.indexOf(selector) === index;
          }).join(', ')
        });
        return false;
      }
      if (hasRequiredChildren(required, ownedRoles)) {
        return true;
      }
      this.data(required);
      if (reviewEmpty.includes(explicitRole2) && !ownedRoles.some(isContent)) {
        return void 0;
      }
      return false;
    }
    function getOwnedRoles(virtualNode, required) {
      var vNode;
      var ownedRoles = [];
      var ownedVirtual = get_owned_virtual_default(virtualNode);
      var _loop7 = function _loop7() {
        if (vNode.props.nodeType === 3) {
          ownedRoles.push({
            vNode: vNode,
            role: null
          });
        }
        if (vNode.props.nodeType !== 1 || !_isVisibleToScreenReaders(vNode)) {
          return 'continue';
        }
        var role = get_role_default(vNode, {
          noPresentational: true
        });
        var globalAriaAttr = getGlobalAriaAttr(vNode);
        var hasGlobalAriaOrFocusable = !!globalAriaAttr || _isFocusable(vNode);
        if (!role && !hasGlobalAriaOrFocusable || [ 'group', 'rowgroup' ].includes(role) && required.some(function(requiredRole) {
          return requiredRole === role;
        })) {
          ownedVirtual.push.apply(ownedVirtual, _toConsumableArray(vNode.children));
        } else if (role || hasGlobalAriaOrFocusable) {
          var attr = globalAriaAttr || 'tabindex';
          ownedRoles.push({
            role: role,
            attr: attr,
            vNode: vNode
          });
        }
      };
      while (vNode = ownedVirtual.shift()) {
        var _ret5 = _loop7();
        if (_ret5 === 'continue') {
          continue;
        }
      }
      return ownedRoles;
    }
    function hasRequiredChildren(required, ownedRoles) {
      return ownedRoles.some(function(_ref99) {
        var role = _ref99.role;
        return role && required.includes(role);
      });
    }
    function getGlobalAriaAttr(vNode) {
      return get_global_aria_attrs_default().find(function(attr) {
        return vNode.hasAttr(attr);
      });
    }
    function getUnallowedSelector(vNode, attr) {
      var _vNode$props = vNode.props, nodeName2 = _vNode$props.nodeName, nodeType = _vNode$props.nodeType;
      if (nodeType === 3) {
        return '#text';
      }
      var role = get_explicit_role_default(vNode, {
        dpub: true
      });
      if (role) {
        return '[role='.concat(role, ']');
      }
      if (attr) {
        return nodeName2 + '['.concat(attr, ']');
      }
      return nodeName2;
    }
    function isContent(_ref100) {
      var vNode = _ref100.vNode;
      if (vNode.props.nodeType === 3) {
        return vNode.props.nodeValue.trim().length > 0;
      }
      return has_content_virtual_default(vNode, false, true);
    }
    function getMissingContext(virtualNode, ownGroupRoles, reqContext, includeElement) {
      var explicitRole2 = get_explicit_role_default(virtualNode);
      if (!reqContext) {
        reqContext = required_context_default(explicitRole2);
      }
      if (!reqContext) {
        return null;
      }
      var allowsGroup = reqContext.includes('group');
      var vNode = includeElement ? virtualNode : virtualNode.parent;
      while (vNode) {
        var role = get_role_default(vNode, {
          noPresentational: true
        });
        if (!role) {
          vNode = vNode.parent;
        } else if (role === 'group' && allowsGroup) {
          if (ownGroupRoles.includes(explicitRole2)) {
            reqContext.push(explicitRole2);
          }
          reqContext = reqContext.filter(function(r) {
            return r !== 'group';
          });
          vNode = vNode.parent;
        } else if (reqContext.includes(role)) {
          return null;
        } else {
          return reqContext;
        }
      }
      return reqContext;
    }
    function getAriaOwners(element) {
      var owners = [], o = null;
      while (element) {
        if (element.getAttribute('id')) {
          var _id3 = escape_selector_default(element.getAttribute('id'));
          var doc = get_root_node_default2(element);
          o = doc.querySelector('[aria-owns~='.concat(_id3, ']'));
          if (o) {
            owners.push(o);
          }
        }
        element = element.parentElement;
      }
      return owners.length ? owners : null;
    }
    function ariaRequiredParentEvaluate(node, options, virtualNode) {
      var ownGroupRoles = options && Array.isArray(options.ownGroupRoles) ? options.ownGroupRoles : [];
      var missingParents = getMissingContext(virtualNode, ownGroupRoles);
      if (!missingParents) {
        return true;
      }
      var owners = getAriaOwners(node);
      if (owners) {
        for (var _i30 = 0, l = owners.length; _i30 < l; _i30++) {
          missingParents = getMissingContext(get_node_from_tree_default(owners[_i30]), ownGroupRoles, missingParents, true);
          if (!missingParents) {
            return true;
          }
        }
      }
      this.data(missingParents);
      return false;
    }
    var aria_required_parent_evaluate_default = ariaRequiredParentEvaluate;
    function ariaRoledescriptionEvaluate(node) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var virtualNode = arguments.length > 2 ? arguments[2] : undefined;
      var role = get_role_default(virtualNode);
      var supportedRoles = options.supportedRoles || [];
      if (supportedRoles.includes(role)) {
        return true;
      }
      if (role && role !== 'presentation' && role !== 'none') {
        return void 0;
      }
      return false;
    }
    var aria_roledescription_evaluate_default = ariaRoledescriptionEvaluate;
    function ariaUnsupportedAttrEvaluate(node, options, virtualNode) {
      var unsupportedAttrs = virtualNode.attrNames.filter(function(name) {
        var attribute = standards_default.ariaAttrs[name];
        if (!validate_attr_default(name)) {
          return false;
        }
        var unsupported = attribute.unsupported;
        if (_typeof(unsupported) !== 'object') {
          return !!unsupported;
        }
        return !matches_default2(node, unsupported.exceptions);
      });
      if (unsupportedAttrs.length) {
        this.data(unsupportedAttrs);
        return true;
      }
      return false;
    }
    var aria_unsupported_attr_evaluate_default = ariaUnsupportedAttrEvaluate;
    function ariaValidAttrEvaluate(node, options, virtualNode) {
      options = Array.isArray(options.value) ? options.value : [];
      var invalid = [];
      var aria = /^aria-/;
      virtualNode.attrNames.forEach(function(attr) {
        if (options.indexOf(attr) === -1 && aria.test(attr) && !validate_attr_default(attr)) {
          invalid.push(attr);
        }
      });
      if (invalid.length) {
        this.data(invalid);
        return false;
      }
      return true;
    }
    var aria_valid_attr_evaluate_default = ariaValidAttrEvaluate;
    function ariaValidAttrValueEvaluate(node, options, virtualNode) {
      options = Array.isArray(options.value) ? options.value : [];
      var needsReview = '';
      var messageKey = '';
      var invalid = [];
      var aria = /^aria-/;
      var skipAttrs = [ 'aria-errormessage' ];
      var preChecks = {
        'aria-controls': function ariaControls() {
          return virtualNode.attr('aria-expanded') !== 'false' && virtualNode.attr('aria-selected') !== 'false';
        },
        'aria-current': function ariaCurrent(validValue) {
          if (!validValue) {
            needsReview = 'aria-current="'.concat(virtualNode.attr('aria-current'), '"');
            messageKey = 'ariaCurrent';
          }
          return;
        },
        'aria-owns': function ariaOwns() {
          return virtualNode.attr('aria-expanded') !== 'false';
        },
        'aria-describedby': function ariaDescribedby(validValue) {
          if (!validValue) {
            needsReview = 'aria-describedby="'.concat(virtualNode.attr('aria-describedby'), '"');
            messageKey = axe._tree && axe._tree[0]._hasShadowRoot ? 'noIdShadow' : 'noId';
          }
          return;
        },
        'aria-labelledby': function ariaLabelledby(validValue) {
          if (!validValue) {
            needsReview = 'aria-labelledby="'.concat(virtualNode.attr('aria-labelledby'), '"');
            messageKey = axe._tree && axe._tree[0]._hasShadowRoot ? 'noIdShadow' : 'noId';
          }
        }
      };
      virtualNode.attrNames.forEach(function(attrName) {
        if (skipAttrs.includes(attrName) || options.includes(attrName) || !aria.test(attrName)) {
          return;
        }
        var validValue;
        var attrValue = virtualNode.attr(attrName);
        try {
          validValue = validate_attr_value_default(virtualNode, attrName);
        } catch (e) {
          needsReview = ''.concat(attrName, '="').concat(attrValue, '"');
          messageKey = 'idrefs';
          return;
        }
        if ((preChecks[attrName] ? preChecks[attrName](validValue) : true) && !validValue) {
          if (attrValue === '' && !isStringType(attrName)) {
            needsReview = attrName;
            messageKey = 'empty';
          } else {
            invalid.push(''.concat(attrName, '="').concat(attrValue, '"'));
          }
        }
      });
      if (invalid.length) {
        this.data(invalid);
        return false;
      }
      if (needsReview) {
        this.data({
          messageKey: messageKey,
          needsReview: needsReview
        });
        return void 0;
      }
      return true;
    }
    function isStringType(attrName) {
      var _standards_default$ar;
      return ((_standards_default$ar = standards_default.ariaAttrs[attrName]) === null || _standards_default$ar === void 0 ? void 0 : _standards_default$ar.type) === 'string';
    }
    function brailleLabelEquivalentEvaluate(node, options, virtualNode) {
      var _virtualNode$attr;
      var brailleLabel = (_virtualNode$attr = virtualNode.attr('aria-braillelabel')) !== null && _virtualNode$attr !== void 0 ? _virtualNode$attr : '';
      if (!brailleLabel.trim()) {
        return true;
      }
      try {
        return sanitize_default(_accessibleTextVirtual(virtualNode)) !== '';
      } catch (_unused) {
        return void 0;
      }
    }
    function brailleRoleDescriptionEquivalentEvaluate(node, options, virtualNode) {
      var _virtualNode$attr2;
      var brailleRoleDesc = (_virtualNode$attr2 = virtualNode.attr('aria-brailleroledescription')) !== null && _virtualNode$attr2 !== void 0 ? _virtualNode$attr2 : '';
      if (sanitize_default(brailleRoleDesc) === '') {
        return true;
      }
      var roleDesc = virtualNode.attr('aria-roledescription');
      if (typeof roleDesc !== 'string') {
        this.data({
          messageKey: 'noRoleDescription'
        });
        return false;
      }
      if (sanitize_default(roleDesc) === '') {
        this.data({
          messageKey: 'emptyRoleDescription'
        });
        return false;
      }
      return true;
    }
    function deprecatedroleEvaluate(node, options, virtualNode) {
      var role = get_role_default(virtualNode, {
        dpub: true,
        fallback: true
      });
      var roleDefinition = standards_default.ariaRoles[role];
      if (!(roleDefinition !== null && roleDefinition !== void 0 && roleDefinition.deprecated)) {
        return false;
      }
      this.data(role);
      return true;
    }
    function nonePresentationOnElementWithNoImplicitRole(virtualNode, explicitRoles) {
      var hasImplicitRole = implicit_role_default(virtualNode);
      return !hasImplicitRole && explicitRoles.length === 2 && explicitRoles.includes('none') && explicitRoles.includes('presentation');
    }
    function fallbackroleEvaluate(node, options, virtualNode) {
      var explicitRoles = token_list_default(virtualNode.attr('role'));
      if (explicitRoles.length <= 1) {
        return false;
      }
      return nonePresentationOnElementWithNoImplicitRole(virtualNode, explicitRoles) ? void 0 : true;
    }
    var fallbackrole_evaluate_default = fallbackroleEvaluate;
    function hasGlobalAriaAttributeEvaluate(node, options, virtualNode) {
      var globalAttrs = get_global_aria_attrs_default().filter(function(attr) {
        return virtualNode.hasAttr(attr);
      });
      this.data(globalAttrs);
      return globalAttrs.length > 0;
    }
    var has_global_aria_attribute_evaluate_default = hasGlobalAriaAttributeEvaluate;
    function hasWidgetRoleEvaluate(node) {
      var role = node.getAttribute('role');
      if (role === null) {
        return false;
      }
      var roleType = get_role_type_default(role);
      return roleType === 'widget' || roleType === 'composite';
    }
    var has_widget_role_evaluate_default = hasWidgetRoleEvaluate;
    function invalidroleEvaluate(node, options, virtualNode) {
      var allRoles = token_list_default(virtualNode.attr('role'));
      var allInvalid = allRoles.every(function(role) {
        return !is_valid_role_default(role, {
          allowAbstract: true
        });
      });
      if (allInvalid) {
        this.data(allRoles);
        return true;
      }
      return false;
    }
    var invalidrole_evaluate_default = invalidroleEvaluate;
    function isElementFocusableEvaluate(node, options, virtualNode) {
      return _isFocusable(virtualNode);
    }
    var is_element_focusable_evaluate_default = isElementFocusableEvaluate;
    function noImplicitExplicitLabelEvaluate(node, options, virtualNode) {
      var role = get_role_default(virtualNode, {
        noImplicit: true
      });
      this.data(role);
      var label3;
      var accText;
      try {
        label3 = sanitize_default(label_text_default(virtualNode)).toLowerCase();
        accText = sanitize_default(_accessibleTextVirtual(virtualNode)).toLowerCase();
      } catch (e) {
        return void 0;
      }
      if (!accText && !label3) {
        return false;
      }
      if (!accText && label3) {
        return void 0;
      }
      if (!accText.includes(label3)) {
        return void 0;
      }
      return false;
    }
    var no_implicit_explicit_label_evaluate_default = noImplicitExplicitLabelEvaluate;
    function unsupportedroleEvaluate(node, options, virtualNode) {
      var role = get_role_default(virtualNode, {
        dpub: true,
        fallback: true
      });
      var isUnsupported = is_unsupported_role_default(role);
      if (isUnsupported) {
        this.data(role);
      }
      return isUnsupported;
    }
    var unsupportedrole_evaluate_default = unsupportedroleEvaluate;
    var VALID_TAG_NAMES_FOR_SCROLLABLE_REGIONS = {
      ARTICLE: true,
      ASIDE: true,
      NAV: true,
      SECTION: true
    };
    var VALID_ROLES_FOR_SCROLLABLE_REGIONS = {
      application: true,
      article: true,
      banner: false,
      complementary: true,
      contentinfo: true,
      form: true,
      main: true,
      navigation: true,
      region: true,
      search: false
    };
    function validScrollableTagName(node) {
      var nodeName2 = node.nodeName.toUpperCase();
      return VALID_TAG_NAMES_FOR_SCROLLABLE_REGIONS[nodeName2] || false;
    }
    function validScrollableRole(node, options) {
      var role = get_explicit_role_default(node);
      if (!role) {
        return false;
      }
      return VALID_ROLES_FOR_SCROLLABLE_REGIONS[role] || options.roles.includes(role) || false;
    }
    function validScrollableSemanticsEvaluate(node, options) {
      return validScrollableRole(node, options) || validScrollableTagName(node);
    }
    var valid_scrollable_semantics_evaluate_default = validScrollableSemanticsEvaluate;
    var color_exports = {};
    __export(color_exports, {
      Color: function Color() {
        return color_default;
      },
      centerPointOfRect: function centerPointOfRect() {
        return center_point_of_rect_default;
      },
      elementHasImage: function elementHasImage() {
        return element_has_image_default;
      },
      elementIsDistinct: function elementIsDistinct() {
        return element_is_distinct_default;
      },
      filteredRectStack: function filteredRectStack() {
        return filtered_rect_stack_default;
      },
      flattenColors: function flattenColors() {
        return flatten_colors_default;
      },
      flattenShadowColors: function flattenShadowColors() {
        return _flattenShadowColors;
      },
      getBackgroundColor: function getBackgroundColor() {
        return _getBackgroundColor2;
      },
      getBackgroundStack: function getBackgroundStack() {
        return _getBackgroundStack;
      },
      getContrast: function getContrast() {
        return get_contrast_default;
      },
      getForegroundColor: function getForegroundColor() {
        return _getForegroundColor;
      },
      getOwnBackgroundColor: function getOwnBackgroundColor() {
        return get_own_background_color_default;
      },
      getRectStack: function getRectStack() {
        return get_rect_stack_default;
      },
      getStackingContext: function getStackingContext() {
        return _getStackingContext;
      },
      getStrokeColorsFromShadows: function getStrokeColorsFromShadows() {
        return _getStrokeColorsFromShadows;
      },
      getTextShadowColors: function getTextShadowColors() {
        return _getTextShadowColors;
      },
      hasValidContrastRatio: function hasValidContrastRatio() {
        return has_valid_contrast_ratio_default;
      },
      incompleteData: function incompleteData() {
        return incomplete_data_default;
      },
      parseTextShadows: function parseTextShadows() {
        return _parseTextShadows;
      },
      stackingContextToColor: function stackingContextToColor() {
        return _stackingContextToColor;
      }
    });
    function centerPointOfRect(rect) {
      if (rect.left > window.innerWidth) {
        return void 0;
      }
      if (rect.top > window.innerHeight) {
        return void 0;
      }
      var x = Math.min(Math.ceil(rect.left + rect.width / 2), window.innerWidth - 1);
      var y = Math.min(Math.ceil(rect.top + rect.height / 2), window.innerHeight - 1);
      return {
        x: x,
        y: y
      };
    }
    var center_point_of_rect_default = centerPointOfRect;
    function _getFonts(style) {
      return style.getPropertyValue('font-family').split(/[,;]/g).map(function(font) {
        return font.trim().toLowerCase();
      });
    }
    function elementIsDistinct(node, ancestorNode) {
      var nodeStyle = window.getComputedStyle(node);
      if (nodeStyle.getPropertyValue('background-image') !== 'none') {
        return true;
      }
      var hasBorder = [ 'border-bottom', 'border-top', 'outline' ].reduce(function(result, edge) {
        var borderClr = new color_default();
        borderClr.parseString(nodeStyle.getPropertyValue(edge + '-color'));
        return result || nodeStyle.getPropertyValue(edge + '-style') !== 'none' && parseFloat(nodeStyle.getPropertyValue(edge + '-width')) > 0 && borderClr.alpha !== 0;
      }, false);
      if (hasBorder) {
        return true;
      }
      var parentStyle = window.getComputedStyle(ancestorNode);
      if (_getFonts(nodeStyle)[0] !== _getFonts(parentStyle)[0]) {
        return true;
      }
      var hasStyle = [ 'text-decoration-line', 'text-decoration-style', 'font-weight', 'font-style', 'font-size' ].reduce(function(result, cssProp) {
        return result || nodeStyle.getPropertyValue(cssProp) !== parentStyle.getPropertyValue(cssProp);
      }, false);
      var tDec = nodeStyle.getPropertyValue('text-decoration');
      if (tDec.split(' ').length < 3) {
        hasStyle = hasStyle || tDec !== parentStyle.getPropertyValue('text-decoration');
      }
      return hasStyle;
    }
    var element_is_distinct_default = elementIsDistinct;
    function getRectStack2(elm) {
      var boundingStack = get_element_stack_default(elm);
      var filteredArr = get_text_element_stack_default(elm);
      if (!filteredArr || filteredArr.length <= 1) {
        return [ boundingStack ];
      }
      if (filteredArr.some(function(stack) {
        return stack === void 0;
      })) {
        return null;
      }
      filteredArr.splice(0, 0, boundingStack);
      return filteredArr;
    }
    var get_rect_stack_default = getRectStack2;
    function filteredRectStack(elm) {
      var rectStack = get_rect_stack_default(elm);
      if (rectStack && rectStack.length === 1) {
        return rectStack[0];
      }
      if (rectStack && rectStack.length > 1) {
        var boundingStack = rectStack.shift();
        var isSame;
        rectStack.forEach(function(rectList, index) {
          if (index === 0) {
            return;
          }
          var rectA = rectStack[index - 1], rectB = rectStack[index];
          isSame = rectA.every(function(element, elementIndex) {
            return element === rectB[elementIndex];
          }) || boundingStack.includes(elm);
        });
        if (!isSame) {
          incomplete_data_default.set('bgColor', 'elmPartiallyObscuring');
          return null;
        }
        return rectStack[0];
      }
      incomplete_data_default.set('bgColor', 'outsideViewport');
      return null;
    }
    var filtered_rect_stack_default = filteredRectStack;
    function clamp2(value, min, max2) {
      return Math.min(Math.max(min, value), max2);
    }
    var blendFunctions = {
      normal: function normal(Cb, Cs) {
        return Cs;
      },
      multiply: function multiply(Cb, Cs) {
        return Cs * Cb;
      },
      screen: function screen(Cb, Cs) {
        return Cb + Cs - Cb * Cs;
      },
      overlay: function overlay(Cb, Cs) {
        return this['hard-light'](Cs, Cb);
      },
      darken: function darken(Cb, Cs) {
        return Math.min(Cb, Cs);
      },
      lighten: function lighten(Cb, Cs) {
        return Math.max(Cb, Cs);
      },
      'color-dodge': function colorDodge(Cb, Cs) {
        return Cb === 0 ? 0 : Cs === 1 ? 1 : Math.min(1, Cb / (1 - Cs));
      },
      'color-burn': function colorBurn(Cb, Cs) {
        return Cb === 1 ? 1 : Cs === 0 ? 0 : 1 - Math.min(1, (1 - Cb) / Cs);
      },
      'hard-light': function hardLight(Cb, Cs) {
        return Cs <= .5 ? this.multiply(Cb, 2 * Cs) : this.screen(Cb, 2 * Cs - 1);
      },
      'soft-light': function softLight(Cb, Cs) {
        if (Cs <= .5) {
          return Cb - (1 - 2 * Cs) * Cb * (1 - Cb);
        } else {
          var D = Cb <= .25 ? ((16 * Cb - 12) * Cb + 4) * Cb : Math.sqrt(Cb);
          return Cb + (2 * Cs - 1) * (D - Cb);
        }
      },
      difference: function difference(Cb, Cs) {
        return Math.abs(Cb - Cs);
      },
      exclusion: function exclusion(Cb, Cs) {
        return Cb + Cs - 2 * Cb * Cs;
      }
    };
    function simpleAlphaCompositing(Cs, \u03b1s, Cb, \u03b1b, blendMode) {
      return \u03b1s * (1 - \u03b1b) * Cs + \u03b1s * \u03b1b * blendFunctions[blendMode](Cb / 255, Cs / 255) * 255 + (1 - \u03b1s) * \u03b1b * Cb;
    }
    function flattenColors(sourceColor, backdrop) {
      var blendMode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'normal';
      var r = simpleAlphaCompositing(sourceColor.red, sourceColor.alpha, backdrop.red, backdrop.alpha, blendMode);
      var g2 = simpleAlphaCompositing(sourceColor.green, sourceColor.alpha, backdrop.green, backdrop.alpha, blendMode);
      var b2 = simpleAlphaCompositing(sourceColor.blue, sourceColor.alpha, backdrop.blue, backdrop.alpha, blendMode);
      var \u03b1o = clamp2(sourceColor.alpha + backdrop.alpha * (1 - sourceColor.alpha), 0, 1);
      if (\u03b1o === 0) {
        return new color_default(r, g2, b2, \u03b1o);
      }
      var Cr = Math.round(r / \u03b1o);
      var Cg = Math.round(g2 / \u03b1o);
      var Cb = Math.round(b2 / \u03b1o);
      return new color_default(Cr, Cg, Cb, \u03b1o);
    }
    var flatten_colors_default = flattenColors;
    function _flattenShadowColors(fgColor, bgColor) {
      var alpha = fgColor.alpha;
      var r = (1 - alpha) * bgColor.red + alpha * fgColor.red;
      var g2 = (1 - alpha) * bgColor.green + alpha * fgColor.green;
      var b2 = (1 - alpha) * bgColor.blue + alpha * fgColor.blue;
      var a2 = fgColor.alpha + bgColor.alpha * (1 - fgColor.alpha);
      return new color_default(r, g2, b2, a2);
    }
    function _getBackgroundStack(node) {
      var stacks = get_text_element_stack_default(node).map(function(stack) {
        stack = reduce_to_elements_below_floating_default(stack, node);
        stack = sortPageBackground(stack);
        return stack;
      });
      for (var index = 0; index < stacks.length; index++) {
        var stack = stacks[index];
        if (stack[0] !== node) {
          incomplete_data_default.set('bgColor', 'bgOverlap');
          return null;
        }
        if (index !== 0 && !shallowArraysEqual(stack, stacks[0])) {
          incomplete_data_default.set('bgColor', 'elmPartiallyObscuring');
          return null;
        }
      }
      return stacks[0] || null;
    }
    function sortPageBackground(elmStack) {
      var bodyIndex = elmStack.indexOf(document.body);
      var bgNodes = elmStack;
      var htmlBgColor = get_own_background_color_default(window.getComputedStyle(document.documentElement));
      if (bodyIndex > 1 && htmlBgColor.alpha === 0 && !element_has_image_default(document.documentElement)) {
        if (bodyIndex > 1) {
          bgNodes.splice(bodyIndex, 1);
          bgNodes.push(document.body);
        }
        var htmlIndex = bgNodes.indexOf(document.documentElement);
        if (htmlIndex > 0) {
          bgNodes.splice(htmlIndex, 1);
          bgNodes.push(document.documentElement);
        }
      }
      return bgNodes;
    }
    function shallowArraysEqual(a2, b2) {
      if (a2 === b2) {
        return true;
      }
      if (a2 === null || b2 === null) {
        return false;
      }
      if (a2.length !== b2.length) {
        return false;
      }
      for (var i = 0; i < a2.length; ++i) {
        if (a2[i] !== b2[i]) {
          return false;
        }
      }
      return true;
    }
    var SHADOW_STROKE_ALPHA = .54;
    var VISIBLE_SHADOW_MIN_PX = .5;
    var OPAQUE_STROKE_OFFSET_MIN_PX = 1.5;
    var edges = [ 'top', 'right', 'bottom', 'left' ];
    function _getStrokeColorsFromShadows(parsedShadows) {
      var _ref101 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, _ref101$ignoreEdgeCou = _ref101.ignoreEdgeCount, ignoreEdgeCount = _ref101$ignoreEdgeCou === void 0 ? false : _ref101$ignoreEdgeCou;
      var shadowMap = getShadowColorsMap(parsedShadows);
      var shadowsByColor = Object.entries(shadowMap).map(function(_ref102) {
        var _ref103 = _slicedToArray(_ref102, 2), colorStr = _ref103[0], sides = _ref103[1];
        var edgeCount = edges.filter(function(side) {
          return sides[side].length !== 0;
        }).length;
        return {
          colorStr: colorStr,
          sides: sides,
          edgeCount: edgeCount
        };
      });
      if (!ignoreEdgeCount && shadowsByColor.some(function(_ref104) {
        var edgeCount = _ref104.edgeCount;
        return edgeCount > 1 && edgeCount < 4;
      })) {
        return null;
      }
      return shadowsByColor.map(shadowGroupToColor).filter(function(shadow) {
        return shadow !== null;
      });
    }
    function getShadowColorsMap(parsedShadows) {
      var colorMap = {};
      var _iterator16 = _createForOfIteratorHelper(parsedShadows), _step16;
      try {
        for (_iterator16.s(); !(_step16 = _iterator16.n()).done; ) {
          var _colorMap$colorStr;
          var _step16$value = _step16.value, colorStr = _step16$value.colorStr, pixels = _step16$value.pixels;
          (_colorMap$colorStr = colorMap[colorStr]) !== null && _colorMap$colorStr !== void 0 ? _colorMap$colorStr : colorMap[colorStr] = {
            top: [],
            right: [],
            bottom: [],
            left: []
          };
          var borders = colorMap[colorStr];
          var _pixels = _slicedToArray(pixels, 2), offsetX = _pixels[0], offsetY = _pixels[1];
          if (offsetX > VISIBLE_SHADOW_MIN_PX) {
            borders.right.push(offsetX);
          } else if (-offsetX > VISIBLE_SHADOW_MIN_PX) {
            borders.left.push(-offsetX);
          }
          if (offsetY > VISIBLE_SHADOW_MIN_PX) {
            borders.bottom.push(offsetY);
          } else if (-offsetY > VISIBLE_SHADOW_MIN_PX) {
            borders.top.push(-offsetY);
          }
        }
      } catch (err) {
        _iterator16.e(err);
      } finally {
        _iterator16.f();
      }
      return colorMap;
    }
    function shadowGroupToColor(_ref105) {
      var colorStr = _ref105.colorStr, sides = _ref105.sides, edgeCount = _ref105.edgeCount;
      if (edgeCount !== 4) {
        return null;
      }
      var strokeColor = new color_default();
      strokeColor.parseString(colorStr);
      var density = 0;
      var isSolid = true;
      edges.forEach(function(edge) {
        density += sides[edge].length / 4;
        isSolid && (isSolid = sides[edge].every(function(offset) {
          return offset > OPAQUE_STROKE_OFFSET_MIN_PX;
        }));
      });
      if (!isSolid) {
        strokeColor.alpha = 1 - Math.pow(SHADOW_STROKE_ALPHA, density);
      }
      return strokeColor;
    }
    function _parseTextShadows(textShadow) {
      var current = {
        pixels: []
      };
      var str = textShadow.trim();
      var shadows = [ current ];
      if (!str) {
        return [];
      }
      while (str) {
        var colorMatch = str.match(/^[a-z]+(\([^)]+\))?/i) || str.match(/^#[0-9a-f]+/i);
        var pixelMatch = str.match(/^([0-9.-]+)px/i) || str.match(/^(0)/);
        if (colorMatch) {
          assert_default(!current.colorStr, 'Multiple colors identified in text-shadow: '.concat(textShadow));
          str = str.replace(colorMatch[0], '').trim();
          current.colorStr = colorMatch[0];
        } else if (pixelMatch) {
          assert_default(current.pixels.length < 3, 'Too many pixel units in text-shadow: '.concat(textShadow));
          str = str.replace(pixelMatch[0], '').trim();
          var pixelUnit = parseFloat((pixelMatch[1][0] === '.' ? '0' : '') + pixelMatch[1]);
          current.pixels.push(pixelUnit);
        } else if (str[0] === ',') {
          assert_default(current.pixels.length >= 2, 'Missing pixel value in text-shadow: '.concat(textShadow));
          current = {
            pixels: []
          };
          shadows.push(current);
          str = str.substr(1).trim();
        } else {
          throw new Error('Unable to process text-shadows: '.concat(str));
        }
      }
      shadows.forEach(function(_ref106) {
        var pixels = _ref106.pixels;
        if (pixels.length === 2) {
          pixels.push(0);
        }
      });
      return shadows;
    }
    function _getTextShadowColors(node) {
      var _ref107 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {}, minRatio = _ref107.minRatio, maxRatio = _ref107.maxRatio, ignoreEdgeCount = _ref107.ignoreEdgeCount;
      var shadowColors = [];
      var style = window.getComputedStyle(node);
      var textShadow = style.getPropertyValue('text-shadow');
      if (textShadow === 'none') {
        return shadowColors;
      }
      var fontSizeStr = style.getPropertyValue('font-size');
      var fontSize = parseInt(fontSizeStr);
      assert_default(isNaN(fontSize) === false, 'Unable to determine font-size value '.concat(fontSizeStr));
      var thinShadows = [];
      var shadows = _parseTextShadows(textShadow);
      var _iterator17 = _createForOfIteratorHelper(shadows), _step17;
      try {
        for (_iterator17.s(); !(_step17 = _iterator17.n()).done; ) {
          var shadow = _step17.value;
          var colorStr = shadow.colorStr || style.getPropertyValue('color');
          var _shadow$pixels = _slicedToArray(shadow.pixels, 3), offsetX = _shadow$pixels[0], offsetY = _shadow$pixels[1], _shadow$pixels$ = _shadow$pixels[2], blurRadius = _shadow$pixels$ === void 0 ? 0 : _shadow$pixels$;
          if (maxRatio && blurRadius >= fontSize * maxRatio) {
            continue;
          }
          if (minRatio && blurRadius < fontSize * minRatio) {
            thinShadows.push({
              colorStr: colorStr,
              pixels: shadow.pixels
            });
            continue;
          }
          if (thinShadows.length > 0) {
            var _strokeColors = _getStrokeColorsFromShadows(thinShadows, {
              ignoreEdgeCount: ignoreEdgeCount
            });
            if (_strokeColors === null) {
              return null;
            }
            shadowColors.push.apply(shadowColors, _toConsumableArray(_strokeColors));
            thinShadows.splice(0, thinShadows.length);
          }
          var _color3 = textShadowColor({
            colorStr: colorStr,
            offsetX: offsetX,
            offsetY: offsetY,
            blurRadius: blurRadius,
            fontSize: fontSize
          });
          shadowColors.push(_color3);
        }
      } catch (err) {
        _iterator17.e(err);
      } finally {
        _iterator17.f();
      }
      if (thinShadows.length > 0) {
        var strokeColors = _getStrokeColorsFromShadows(thinShadows, {
          ignoreEdgeCount: ignoreEdgeCount
        });
        if (strokeColors === null) {
          return null;
        }
        shadowColors.push.apply(shadowColors, _toConsumableArray(strokeColors));
      }
      return shadowColors;
    }
    function textShadowColor(_ref108) {
      var colorStr = _ref108.colorStr, offsetX = _ref108.offsetX, offsetY = _ref108.offsetY, blurRadius = _ref108.blurRadius, fontSize = _ref108.fontSize;
      if (offsetX > blurRadius || offsetY > blurRadius) {
        return new color_default(0, 0, 0, 0);
      }
      var shadowColor = new color_default();
      shadowColor.parseString(colorStr);
      shadowColor.alpha *= blurRadiusToAlpha(blurRadius, fontSize);
      return shadowColor;
    }
    function blurRadiusToAlpha(blurRadius, fontSize) {
      if (blurRadius === 0) {
        return 1;
      }
      var relativeBlur = blurRadius / fontSize;
      return .185 / (relativeBlur + .4);
    }
    function _getStackingContext(elm, elmStack) {
      var _elmStack;
      var virtualNode = get_node_from_tree_default(elm);
      if (virtualNode._stackingContext) {
        return virtualNode._stackingContext;
      }
      var stackingContext = [];
      var contextMap = new Map();
      elmStack = (_elmStack = elmStack) !== null && _elmStack !== void 0 ? _elmStack : _getBackgroundStack(elm);
      elmStack.forEach(function(bgElm) {
        var _stackingOrder2;
        var bgVNode = get_node_from_tree_default(bgElm);
        var bgColor = getOwnBackgroundColor2(bgVNode);
        var stackingOrder = bgVNode._stackingOrder.filter(function(_ref109) {
          var vNode = _ref109.vNode;
          return !!vNode;
        });
        stackingOrder.forEach(function(_ref110, index) {
          var _stackingOrder;
          var vNode = _ref110.vNode;
          var ancestorVNode2 = (_stackingOrder = stackingOrder[index - 1]) === null || _stackingOrder === void 0 ? void 0 : _stackingOrder.vNode;
          var context2 = addToStackingContext(contextMap, vNode, ancestorVNode2);
          if (index === 0 && !contextMap.get(vNode)) {
            stackingContext.unshift(context2);
          }
          contextMap.set(vNode, context2);
        });
        var ancestorVNode = (_stackingOrder2 = stackingOrder[stackingOrder.length - 1]) === null || _stackingOrder2 === void 0 ? void 0 : _stackingOrder2.vNode;
        var context = addToStackingContext(contextMap, bgVNode, ancestorVNode);
        if (!stackingOrder.length) {
          stackingContext.unshift(context);
        }
        context.bgColor = bgColor;
      });
      virtualNode._stackingContext = stackingContext;
      return stackingContext;
    }
    function _stackingContextToColor(context) {
      var _context$descendants;
      if (!((_context$descendants = context.descendants) !== null && _context$descendants !== void 0 && _context$descendants.length)) {
        var color2 = context.bgColor;
        color2.alpha *= context.opacity;
        return {
          color: color2,
          blendMode: context.blendMode
        };
      }
      var sourceColor = context.descendants.reduce(reduceToColor, createStackingContext2());
      var color = flatten_colors_default(sourceColor, context.bgColor, context.descendants[0].blendMode);
      color.alpha *= context.opacity;
      return {
        color: color,
        blendMode: context.blendMode
      };
    }
    function reduceToColor(backdropContext, sourceContext) {
      var backdrop;
      if (backdropContext instanceof color_default) {
        backdrop = backdropContext;
      } else {
        backdrop = _stackingContextToColor(backdropContext).color;
      }
      var sourceColor = _stackingContextToColor(sourceContext).color;
      return flatten_colors_default(sourceColor, backdrop, sourceContext.blendMode);
    }
    function createStackingContext2(vNode, ancestorContext) {
      var _vNode$getComputedSty;
      return {
        vNode: vNode,
        ancestor: ancestorContext,
        opacity: parseFloat((_vNode$getComputedSty = vNode === null || vNode === void 0 ? void 0 : vNode.getComputedStylePropertyValue('opacity')) !== null && _vNode$getComputedSty !== void 0 ? _vNode$getComputedSty : 1),
        bgColor: new color_default(0, 0, 0, 0),
        blendMode: normalizeBlendMode(vNode === null || vNode === void 0 ? void 0 : vNode.getComputedStylePropertyValue('mix-blend-mode')),
        descendants: []
      };
    }
    function normalizeBlendMode(blendmode) {
      return !!blendmode ? blendmode : void 0;
    }
    function addToStackingContext(contextMap, vNode, ancestorVNode) {
      var _contextMap$get;
      var ancestorContext = contextMap.get(ancestorVNode);
      var context = (_contextMap$get = contextMap.get(vNode)) !== null && _contextMap$get !== void 0 ? _contextMap$get : createStackingContext2(vNode, ancestorContext);
      if (ancestorContext && ancestorVNode !== vNode && !ancestorContext.descendants.includes(context)) {
        ancestorContext.descendants.unshift(context);
      }
      return context;
    }
    function getOwnBackgroundColor2(vNode) {
      var bgColor = new color_default();
      bgColor.parseString(vNode.getComputedStylePropertyValue('background-color'));
      return bgColor;
    }
    function _getBackgroundColor2(elm) {
      var bgElms = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var shadowOutlineEmMax = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : .1;
      var vNode = get_node_from_tree_default(elm);
      var bgColorCache = vNode._cache.getBackgroundColor;
      if (bgColorCache) {
        bgElms.push.apply(bgElms, _toConsumableArray(bgColorCache.bgElms));
        incomplete_data_default.set('bgColor', bgColorCache.incompleteData);
        return bgColorCache.bgColor;
      }
      var bgColor = _getBackgroundColor(elm, bgElms, shadowOutlineEmMax);
      vNode._cache.getBackgroundColor = {
        bgColor: bgColor,
        bgElms: bgElms,
        incompleteData: incomplete_data_default.get('bgColor')
      };
      return bgColor;
    }
    function _getBackgroundColor(elm, bgElms, shadowOutlineEmMax) {
      var _getTextShadowColors2, _bgColors;
      var elmStack = _getBackgroundStack(elm);
      if (!elmStack) {
        return null;
      }
      var textRects = get_visible_child_text_rects_default(elm);
      var bgColors = (_getTextShadowColors2 = _getTextShadowColors(elm, {
        minRatio: shadowOutlineEmMax,
        ignoreEdgeCount: true
      })) !== null && _getTextShadowColors2 !== void 0 ? _getTextShadowColors2 : [];
      if (bgColors.length) {
        bgColors = [ {
          color: bgColors.reduce(_flattenShadowColors)
        } ];
      }
      for (var _i31 = 0; _i31 < elmStack.length; _i31++) {
        var bgElm = elmStack[_i31];
        var bgElmStyle = window.getComputedStyle(bgElm);
        if (element_has_image_default(bgElm, bgElmStyle)) {
          bgElms.push(bgElm);
          return null;
        }
        var bgColor = get_own_background_color_default(bgElmStyle);
        if (bgColor.alpha === 0) {
          continue;
        }
        if (bgElmStyle.getPropertyValue('display') !== 'inline' && !fullyEncompasses(bgElm, textRects)) {
          bgElms.push(bgElm);
          incomplete_data_default.set('bgColor', 'elmPartiallyObscured');
          return null;
        }
        bgElms.push(bgElm);
        if (bgColor.alpha === 1) {
          break;
        }
      }
      var stackingContext = _getStackingContext(elm, elmStack);
      bgColors = stackingContext.map(_stackingContextToColor).concat(bgColors);
      var pageBgs = getPageBackgroundColors(elm, elmStack.includes(document.body));
      (_bgColors = bgColors).unshift.apply(_bgColors, _toConsumableArray(pageBgs));
      if (bgColors.length === 0) {
        return new color_default(255, 255, 255, 1);
      }
      var blendedColor = bgColors.reduce(function(bgColor, fgColor) {
        return flatten_colors_default(fgColor.color, bgColor.color instanceof color_default ? bgColor.color : bgColor, fgColor.blendMode);
      });
      return flatten_colors_default(blendedColor.color instanceof color_default ? blendedColor.color : blendedColor, new color_default(255, 255, 255, 1));
    }
    function fullyEncompasses(node, rects) {
      rects = Array.isArray(rects) ? rects : [ rects ];
      var nodeRect = node.getBoundingClientRect();
      var right = nodeRect.right, bottom = nodeRect.bottom;
      var style = window.getComputedStyle(node);
      var overflow = style.getPropertyValue('overflow');
      if ([ 'scroll', 'auto' ].includes(overf