<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Social settings.
 *
 * @return array
 */

$category = _x('Social', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'social';

return [
    self::add_input([
        'id' => 171,
        'adv' => false,
        'index' => 'social_fb',
        'name' => _x('Facebook', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Facebook page link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('facebook', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 172,
        'adv' => false,
        'index' => 'social_twitter',
        'name' => _x('X (Twitter)', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('X (Twitter) account link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('twitter x', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 173,
        'adv' => false,
        'index' => 'social_youtube',
        'name' => _x('YouTube', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Youtube channel link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('youtube', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 174,
        'adv' => false,
        'index' => 'social_instagram',
        'name' => _x('Instagram', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Instagram account link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('instagram', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 175,
        'adv' => false,
        'index' => 'social_linkedin',
        'name' => _x('LinkedIn', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('LinkedIn profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('linkedin', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 176,
        'adv' => false,
        'index' => 'social_pinterest',
        'name' => _x('Pinterest', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Pinterest profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('pinterest', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 177,
        'adv' => false,
        'index' => 'social_twitch',
        'name' => _x('Twitch', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Twitch account link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('twitch', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 181,
        'adv' => false,
        'index' => 'social_snapchat',
        'name' => _x('Snapchat', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Snapchat profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('snapchat', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 182,
        'adv' => false,
        'index' => 'social_reddit',
        'name' => _x('Reddit', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Reddit profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('reddit', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 183,
        'adv' => false,
        'index' => 'social_tiktok',
        'name' => _x('TikTok', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('TikTok profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('tiktok', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 184,
        'adv' => false,
        'index' => 'social_whatsapp',
        'name' => _x('Whatsapp', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Whatsapp shortlink.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('whatsapp', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 185,
        'adv' => false,
        'index' => 'social_vimeo',
        'name' => _x('Vimeo', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Vimeo channel link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('vimeo', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 186,
        'adv' => false,
        'index' => 'social_wechat',
        'name' => _x('WeChat', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('WeChat profile link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('wechat', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 187,
        'adv' => false,
        'index' => 'social_messenger',
        'name' => _x('Messenger', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Messenger username link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('messenger', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 247,
        'adv' => false,
        'index' => 'social_discord',
        'name' => _x('Discord', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Discord channel link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('discord', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 248,
        'adv' => false,
        'index' => 'social_telegram',
        'name' => _x('Telegram', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Telegram link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('telegram', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 301,
        'adv' => false,
        'index' => 'social_opensea',
        'name' => _x('OpenSea', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('OpenSea link.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('open sea, opensea', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'l',
        'accept' => 'url',
        'default' => '',
        'responsive' => false,
        'module' => 'frontend',
    ]),
];