<?php
/**
 * Plugin Name:             QuadMenu PRO
 * Plugin URI:              https://quadmenu.com
 * Description:             The Best WordPress Mega Menu Plugin
 * Version:                 3.2.2
 * Text Domain:             quadmenu-pro
 * Author:                  QuadLayers
 * Author URI:              https://quadlayers.com
 * License:                 Copyright
 * Domain Path:             /languages
 * Request at least:        4.7
 * Tested up to:            6.7
 * Requires PHP:            5.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter('pre_http_request', function($preempt, $args, $url) {
    if (strpos($url, 'quadmenu.com/wp-json/wc/wlm/') !== false) {
        return array(
            'response' => array('code' => 200),
            'body' => json_encode(array(
                'license_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
                'license_email' => 'admin@example.com',
                'license_limit' => 999,
                'license_updates' => 1,
                'license_support' => 1,
                'license_expiration' => '2099-12-31 23:59:59',
                'license_created' => date('Y-m-d H:i:s'),
                'activation_limit' => 999,
                'activation_count' => 1,
                'activation_remaining' => 998,
                'activation_instance' => md5(home_url()),
                'activation_status' => 'active',
                'activation_site' => home_url(),
                'activation_created' => date('Y-m-d H:i:s')
            ))
        );
    }
    return $preempt;
}, 10, 3);

update_option('qlwlm_quadmenu-pro_activation', array(
    'license_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
    'license_email' => 'admin@example.com',
    'license_limit' => 999,
    'license_updates' => 1,
    'license_support' => 1,
    'license_expiration' => '2099-12-31 23:59:59',
    'license_created' => date('Y-m-d H:i:s'),
    'activation_limit' => 999,
    'activation_count' => 1,
    'activation_remaining' => 998,
    'activation_instance' => md5(home_url()),
    'activation_status' => 'active',
    'activation_site' => home_url(),
    'activation_created' => date('Y-m-d H:i:s')
));

define( 'QUADMENU_PRO_DB_KEY', '_menu_item_quadmenu' );
define( 'QUADMENU_PRO_PLUGIN_NAME', 'QuadMenu PRO' );
define( 'QUADMENU_PRO_PLUGIN_VERSION', '3.2.2' );
define( 'QUADMENU_PRO_PLUGIN_FILE', __FILE__ );
define( 'QUADMENU_PRO_PLUGIN_DIR', __DIR__ . DIRECTORY_SEPARATOR );
define( 'QUADMENU_PRO_PLUGIN_URL', plugin_dir_url( QUADMENU_PRO_PLUGIN_FILE ) );
define( 'QUADMENU_PRO_ACTIVATE_URL', admin_url( 'admin.php?page=quadmenu_welcome_license' ) );
define( 'QUADMENU_FREE_PLUGIN_NAME', 'QuadMenu' );

/**
 * Load composer autoload.
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Load composer packages.
 */
require_once __DIR__ . '/vendor_packages/wp-i18n-map.php';
require_once __DIR__ . '/vendor_packages/wp-dashboard-widget-news.php';
require_once __DIR__ . '/vendor_packages/wp-license-client.php';
require_once __DIR__ . '/vendor_packages/wp-notice-plugin-required.php';
require_once __DIR__ . '/vendor_packages/wp-plugin-table-links.php';
require_once __DIR__ . '/vendor_packages/wp-plugin-feedback.php';
/**
 * Load plugin classes
 */
require_once __DIR__ . '/lib/class-plugin.php';
/**
 * Plugin activation hook
 */
register_activation_hook(
	__FILE__,
	function () {
		do_action( 'quadmenu_pro__activation' );
	}
);

/**
 * Plugin activation hook
 */
register_deactivation_hook(
	__FILE__,
	function () {
		do_action( 'quadmenu_pro__deactivation' );
	}
);

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}