<?php

namespace QuadLayers\QuadMenu_PRO\Integrations\Divi;

define( 'QUADMENU_DIVI_URL', plugin_dir_url( __FILE__ ) );

class Load {

	protected static $instance;

	private function __construct() {

		add_action( 'init', array( $this, 'hooks' ), -30 );

		add_action( 'init', array( $this, 'options' ), -25 );

		add_action( 'init', array( $this, 'customizer' ), -5 );

		// add_action('init', array($this, 'primary_menu'));

		add_action( 'wp_footer', array( $this, 'footer' ) );

		add_filter( 'wp_nav_menu_args', array( $this, 'fix_et_builder_module' ), 100000 - 1, 1 );
	}

	public function fix_et_builder_module( $args ) {
		global $quadmenu_active_locations;

		if ( ! empty( $args['menu'] ) && ! empty( $args['menu_class'] ) && $args['menu_class'] == 'et-menu nav' && empty( $args['theme_location'] ) ) {

			$nav_menu_selected_id = $args['menu'];
			$menu_locations       = get_nav_menu_locations();

			$locations = array_intersect( array_keys( $menu_locations, $nav_menu_selected_id ), array_keys( (array) $quadmenu_active_locations ) );

			if ( count( $locations ) && in_array( 'primary-menu', $locations ) ) {

				$theme_location = reset( $locations );

				$args['theme_location'] = $theme_location;

			}
		}

		return $args;
	}

	public function is_divi() {

		if ( ! function_exists( 'et_divi_fonts_url' ) ) {
			return false;
		}

		if ( ! function_exists( 'et_get_option' ) ) {
			return false;
		}

		return true;
	}

	public function hooks() {

		if ( ! $this->is_divi() ) {
			return;
		}

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ) );

		add_filter( 'quadmenu_compiler_files', array( $this, 'files' ) );

		add_filter( 'quadmenu_redux_args', array( $this, 'args' ) );

		add_action( 'admin_menu', array( $this, 'remove' ), 999 );
	}

	public function enqueue() {

		if ( is_file( QUADMENU_UPLOAD_DIR . 'quadmenu-divi.css' ) ) {
			wp_enqueue_style( 'quadmenu-divi', QUADMENU_UPLOAD_URL . 'quadmenu-divi.css', array(), filemtime( QUADMENU_UPLOAD_DIR . 'quadmenu-divi.css' ), 'all' );
		}
	}

	public function files( $files ) {

		$files[] = QUADMENU_PRO_PLUGIN_URL . 'assets/divi/quadmenu-divi.less';

		return $files;
	}

	public function args( $args ) {

		$args['customizer']                = false;
		$args['disable_google_fonts_link'] = true;

		return $args;
	}

	public function remove() {
		remove_submenu_page( 'quadmenu_welcome', 'customize.php?quadmenu_customize' );
	}

	public function options() {

		if ( ! $this->is_divi() ) {
			return;
		}

		new \QuadLayers\QuadMenu_PRO\Integrations\Divi\Options();
	}

	public function customizer() {

		if ( ! $this->is_divi() ) {
			return;
		}

		if ( ! is_customize_preview() ) {
			return;
		}

		new \QuadLayers\QuadMenu_PRO\Integrations\Divi\Customizer();
	}

	// public function primary_menu() {
	//
	// if (!self::is_divi())
	// return;
	//
	// if (!function_exists('is_quadmenu_location'))
	// return;
	//
	// if (!is_quadmenu_location('primary-menu'))
	// return;
	//
	// if (has_action('et_header_top', 'et_add_mobile_navigation')) {
	// remove_action('et_header_top', 'et_add_mobile_navigation');
	// add_action('et_header_top', array($this, 'primary_menu_integration'));
	// }
	// }

	public function footer() {

		if ( ! self::is_divi() ) {
			return;
		}
		?>
		<script>

		(function ($) {

			quadmenu_duplicate = function (selector) {

				const menus = document.querySelectorAll(selector)

				menus.forEach((menu)=> {

					let is_builder = !!menu.closest('.et_pb_menu_inner_container')

					let menu_container = menu.closest('#et-top-navigation') || menu.closest('.et_pb_menu_inner_container')

					if(!menu_container) {
						return;
					}

					let append_to = menu_container.querySelector('.mobile_nav')

					if(!append_to) {
						return;
					}

					if (append_to.querySelector('nav#quadmenu')) {
						return;
					}

					const quadmenu = menu.cloneNode(true)

					quadmenu.dataset.template = 'inherit'

					const wrapQuadmenu = document.createElement('div');
					wrapQuadmenu.className = 'et_mobile_menu';
					wrapQuadmenu.appendChild(quadmenu);

					append_to.append(wrapQuadmenu)

					/*
					setTimeout(function () {
						var $quadmenu = $(append_to).find('nav#quadmenu');
						if($quadmenu.length) {
							$quadmenu.quadmenu();
						}
					}, 200); */

					append_to.addEventListener('click', (e)=> {

						const button = e.target
						const is_link = e.target.closest('a')

						if (!is_builder) {
							return
						}

						if (is_link) {
							e.stopImmediatePropagation();
							return
						}

						e.preventDefault();
						e.stopPropagation();

						if(append_to.classList.contains('opened')) {
							append_to.classList.remove('opened')
							append_to.classList.add('closed')
						} else {
							append_to.classList.add('opened')
							append_to.classList.remove('closed')
						}

					})

				})
			};

			quadmenu_duplicate('#quadmenu');

		})(jQuery);
		</script>
		<?php
	}

	// public function primary_menu_integration() {
	//
	// if (is_customize_preview() || ( 'slide' !== et_get_option('header_style', 'left') && 'fullscreen' !== et_get_option('header_style', 'left') )) {
	/*
			?>
	<div id="et_mobile_nav_menu">
	<div class="mobile_nav closed">
	<span class="select_page">//<?php esc_html_e('Select Page', 'Divi'); ?></span>
	<span class="mobile_menu_bar mobile_menu_bar_toggle"></span>
	<div class="et_mobile_menu">
	//<?php wp_nav_menu(array('theme_location' => 'primary-menu', 'layout' => 'inherit')); ?>
	</div>
	</div>
	</div>

	<?php */
	// }
	// }

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
