<?php

namespace QuadLayers\QuadMenu_PRO\Backend;

class Load {

	protected static $instance;

	private function __construct() {
		add_action( 'admin_init', array( $this, 'navmenu' ), 40 );
		add_filter( 'quadmenu_custom_nav_menu_items', array( $this, 'nav_menu_items' ) );
		add_filter( 'quadmenu_nav_menu_item_fields', array( $this, 'nav_menu_item_fields' ), 10, 2 );
		add_filter( 'quadmenu_remove_nav_menu_item', array( $this, 'remove_nav_menu_item' ) );
		add_filter( 'quadmenu_setup_nav_menu_item', array( $this, 'remove_nav_menu_login' ), 10 );
		add_filter( 'redux/options/' . QUADMENU_DB_OPTIONS . '/sections', array( $this, 'social' ), 90 );
	}

	public function navmenu() {
		if ( function_exists( 'is_quadmenu' ) && is_quadmenu() ) {
			new \QuadLayers\QuadMenu_PRO\Backend\Walker\QuadMenu_Nav_Menu_Panel();
			new \QuadLayers\QuadMenu_PRO\Backend\Walker\QuadMenu_Nav_Menu_Carousel();
			new \QuadLayers\QuadMenu_PRO\Backend\Walker\QuadMenu_Nav_Menu_Tab();
			new \QuadLayers\QuadMenu_PRO\Backend\Walker\QuadMenu_Nav_Menu_Tabs();
			new \QuadLayers\QuadMenu_PRO\Backend\Walker\QuadMenu_Nav_Menu_Account();
		}
	}

	public function nav_menu_items( $items ) {

		$items['social'] = array(
			'label'  => esc_html__( 'QuadMenu Social', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Social', 'quadmenu-pro' ),
			'panels' => array(
				'general' => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'float', 'hidden', 'social' ),
				),
				'icon'    => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
			),
			'desc'   => esc_html__( 'Icon list of your social networks.', 'quadmenu-pro' ),
			'parent' => 'main',
			'depth'  => 0,
		);
		$items['login']  = array(
			'label'  => esc_html__( 'QuadMenu Login', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Login', 'quadmenu-pro' ),
			'panels' => array(
				'general' => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'float', 'dropdown', 'hidden' ),
				),
				'login'   => array(
					'title'    => esc_html__( 'Login', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-unlock',
					'settings' => array( 'register', 'password', 'login' ),
				),
				'logout'  => array(
					'title'    => esc_html__( 'Logout', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-lock',
					'settings' => array( 'avatar', 'name', 'logout' ),
				),
				/*
					'register' => array(
			'title' => esc_html__('Register', 'quadmenu'),
			'icon' => 'dashicons dashicons-admin-users',
			'settings' => array('register'),
			), */
			),
			'desc'   => esc_html__( 'A login and register widget for your users.', 'quadmenu-pro' ),
			'parent' => 'main',
			'depth'  => 0,
		);
		$items['tabs']     = array(
			'label'  => esc_html__( 'QuadMenu Tabs', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Tabs', 'quadmenu-pro' ),
			'panels' => array(
				'general'    => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'dropdown', 'hidden' ),
				),
				'icon'       => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'background' => array(
					'title'    => esc_html__( 'Background', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-format-image',
					'settings' => array( 'background' ),
				),
				'width'      => array(
					'title'    => esc_html__( 'Width', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-align-left',
					'settings' => array( 'dropdown', 'stretch', 'width' ),
				),
			),
			'desc'   => esc_html__( 'A tab menu which can wrap any type of widget.', 'quadmenu-pro' ),
			'parent' => 'main',
			'depth'  => 0,
		);
		$items['carousel'] = array(
			'label'  => esc_html__( 'QuadMenu Carousel', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Carousel', 'quadmenu-pro' ),
			'panels' => array(
				'general'    => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden' ),
				),
				'icon'       => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'background' => array(
					'title'    => esc_html__( 'Background', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-format-image',
					'settings' => array( 'background' ),
				),
				'width'      => array(
					'title'    => esc_html__( 'Width', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-align-left',
					'settings' => array( 'dropdown', 'stretch', 'width' ),
				),
				'carousel'   => array(
					'title'    => esc_html__( 'Carousel', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-image-flip-horizontal',
					'settings' => array( 'speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination' ),
					// 'settings' => array('speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination', 'controls'),
				),
			),
			'desc'   => esc_html__( 'A carousel menu which can wrap any type of widget.', 'quadmenu-pro' ),
			'parent' => 'main',
			'depth'  => 0,
		);
		// Subitems
		// -------------------------------------------------------------
		$items['tab']    = array(
			'label'  => esc_html__( 'Tab', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Tab', 'quadmenu-pro' ),
			'panels' => array(
				'general' => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'hidden' ),
				),
				'icon'    => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
			),
			'desc'   => esc_html__( 'Tab for QuadMenu Tabs.', 'quadmenu-pro' ),
			'parent' => 'tabs',
		);
		$items['panel']  = array(
			'label'  => esc_html__( 'Panel', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Panel', 'quadmenu-pro' ),
			'panels' => array(),
			'desc'   => esc_html__( 'Panel for QuadMenu Carousel.', 'quadmenu-pro' ),
			'parent' => 'carousel',
		);
		$items['button'] = array(
			'label'  => esc_html__( 'QuadMenu Button', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Button', 'quadmenu-pro' ),
			'panels' => array(
				'general' => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'float', 'hidden', 'dropdown' ),
				),
				'icon'    => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
			),
			'desc'   => esc_html__( 'Add button element.', 'quadmenu-pro' ),
			'depth'  => 0,
			// 'parent' => array('main', 'column', 'custom', 'login', 'post_type', 'post_type_archive', 'taxonomy'),
		);

		// Archives
		// ---------------------------------------------------------------------

		$items['post_type_archive'] = array(
			'label'  => esc_html__( 'Posts', 'quadmenu-pro' ),
			'title'  => esc_html__( 'Posts', 'quadmenu-pro' ),
			'panels' => array(
				'general'          => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden', 'dropdown' ),
				),
				'icon'             => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'query'            => array(
					'title'    => esc_html__( 'Query', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-update',
					'settings' => array( 'limit', 'orderby', 'order' ),
				),
				'archive_carousel' => array(
					'title'    => esc_html__( 'Carousel', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-image-flip-horizontal',
					'settings' => array( 'items', 'speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination', 'navigation' ),
				),
				'content'          => array(
					'title'    => esc_html__( 'Posts', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-format-aside',
					'settings' => array( 'thumb', 'excerpt' ),
				),
			),
			'parent' => array( 'main', 'column', 'custom', 'post_type', 'post_type_archive', 'taxonomy' ),
		);

		$items['taxonomy'] = array(
			'panels' => array(
				'general'          => array(
					'title'    => esc_html__( 'General', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-admin-settings',
					'settings' => array( 'subtitle', 'badge', 'float', 'hidden', 'dropdown' ),
				),
				'icon'             => array(
					'title'    => esc_html__( 'Icon', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-art',
					'settings' => array( 'icon' ),
				),
				'query'            => array(
					'title'    => esc_html__( 'Query', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-update',
					'settings' => array( 'limit', 'orderby', 'order' ),
				),
				'archive_carousel' => array(
					'title'    => esc_html__( 'Carousel', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-image-flip-horizontal',
					'settings' => array( 'items', 'speed', 'autoplay', 'autoplay_speed', 'dots', 'pagination', 'navigation' ),
				),
				'content'          => array(
					'title'    => esc_html__( 'Posts', 'quadmenu-pro' ),
					'icon'     => 'dashicons dashicons-format-aside',
					'settings' => array( 'thumb', 'excerpt' ),
				),
			),
			'parent' => array( 'main', 'column', 'custom', 'post_type', 'post_type_archive', 'taxonomy' ),
		);

		return $items;
	}

	public function nav_menu_item_fields( $settings, $menu_obj ) {

		$settings['password'] = array(
			'id'          => 'quadmenu-settings[password]',
			'db'          => 'password',
			'title'       => esc_html__( 'Reset Password', 'quadmenu-pro' ),
			'placeholder' => wp_lostpassword_url( get_permalink() ),
			'type'        => 'text',
			'default'     => '',
		);

		$settings['register'] = array(
			'id'          => 'quadmenu-settings[register]',
			'db'          => 'register',
			'title'       => esc_html__( 'Register' ),
			'placeholder' => esc_html__( 'Custom register account link' ),
			'type'        => 'text',
			'default'     => '',
		);

		$settings['login'] = array(
			'id'          => 'quadmenu-settings[login]',
			'db'          => 'login',
			'type'        => 'icon',
			'placeholder' => esc_html__( 'Search', 'quadmenu-pro' ),
			'default'     => 'dashicons dashicons-unlock',
		);

		$settings['logout'] = array(
			'id'          => 'quadmenu-settings[logout]',
			'db'          => 'logout',
			'type'        => 'icon',
			'placeholder' => esc_html__( 'Search', 'quadmenu-pro' ),
			'default'     => 'dashicons dashicons-lock',
		);

		$settings['name'] = array(
			'id'      => 'quadmenu-settings[name]',
			'db'      => 'name',
			'type'    => 'select',
			'title'   => esc_html__( 'Name', 'quadmenu-pro' ),
			'ops'     => array(
				'user_login'   => esc_html__( 'Username' ),
				'nickname'     => esc_html__( 'Nickname' ),
				'display_name' => esc_html__( 'Display name' ),
			),
			'default' => 'user_login',
		);

		$settings['avatar'] = array(
			'id'          => 'quadmenu-settings[avatar]',
			'db'          => 'avatar',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Avatar', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Display user avatar', 'quadmenu-pro' ),
			'default'     => 'off',
		);

		$settings['account'] = array(
			'id'          => 'quadmenu-settings[account]',
			'db'          => 'account',
			'title'       => esc_html__( 'Account' ),
			'placeholder' => esc_html__( 'Custom my account link', 'quadmenu-pro' ),
			'type'        => 'text',
			'default'     => '',
		);

		$settings['login_text'] = array(
			'id'      => 'quadmenu-settings[login_text]',
			'db'      => 'login_text',
			'title'   => esc_html__( 'Footer', 'quadmenu-pro' ),
			'type'    => 'textarea',
			'default' => '',
		);

		// Carousel
		// ---------------------------------------------------------------------

		$settings['speed'] = array(
			'id'      => 'quadmenu-settings[speed]',
			'db'      => 'speed',
			'type'    => 'number',
			'title'   => esc_html__( 'Speed', 'quadmenu-pro' ),
			'ops'     => array(
				'step' => 100,
				'min'  => 100,
				'max'  => 10000,
			),
			'default' => 1500,
		);

		$settings['autoplay'] = array(
			'id'          => 'quadmenu-settings[autoplay]',
			'db'          => 'autoplay',
			'type'        => 'checkbox',
			'title'       => esc_html__( 'Autoplay', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Run carousel automatically', 'quadmenu-pro' ),
			'default'     => 'off',
		);

		$settings['autoplay_speed'] = array(
			'id'          => 'quadmenu-settings[autoplay_speed]',
			'db'          => 'autoplay_speed',
			'type'        => 'number',
			'title'       => esc_html__( 'Autoplay Speed', 'quadmenu-pro' ),
			'placeholder' => esc_html__( 'Time between 2 consecutive slides (in ms)', 'quadmenu-pro' ),
			'ops'         => array(
				'step' => 100,
				'min'  => 100,
				'max'  => 10000,
			),
			'default'     => 500,
		);

		$settings['dots'] = array(
			'id'          => 'quadmenu-settings[dots]',
			'db'          => 'dots',
			'type'        => 'checkbox',
			'placeholder' => esc_html__( 'Show dots control', 'quadmenu-pro' ),
			'title'       => esc_html__( 'Dots', 'quadmenu-pro' ),
			'default'     => 'off',
		);

		$settings['pagination'] = array(
			'id'          => 'quadmenu-settings[pagination]',
			'db'          => 'pagination',
			'type'        => 'checkbox',
			'placeholder' => esc_html__( 'Show pagination control', 'quadmenu-pro' ),
			'title'       => esc_html__( 'Pagination', 'quadmenu-pro' ),
			'default'     => 'on',
		);

		$settings['navigation'] = array(
			'id'          => 'quadmenu-settings[navigation]',
			'db'          => 'navigation',
			'type'        => 'checkbox',
			'placeholder' => esc_html__( 'Show navigation control', 'quadmenu-pro' ),
			'title'       => esc_html__( 'Navigation', 'quadmenu-pro' ),
			'default'     => 'off',
		);

		/*
			$settings['controls'] = array(
			'id' => 'quadmenu-settings[controls]',
			'db' => 'controls',
			'type' => 'select',
			'title' => esc_html__('Controls', 'quadmenu'),
			'ops' => array(
			'middle' => esc_html__('Middle', 'quadmenu'),
			'center' => esc_html__('Center', 'quadmenu'),
			'left' => esc_html__('Bottom Left', 'quadmenu'),
			'right' => esc_html__('Bottom Right', 'quadmenu'),
			),
			'default' => 'left',
			); */

		// Query
		// ---------------------------------------------------------------------

		$settings['items'] = array(
			'id'      => 'quadmenu-settings[items]',
			'db'      => 'items',
			'type'    => 'number',
			'title'   => esc_html__( 'Items', 'quadmenu-pro' ),
			'depth'   => array( 1, 2, 3, 4 ),
			'ops'     => array(
				'step' => 1,
				'min'  => 0,
				'max'  => 6,
			),
			'default' => 0,
		);

		$settings['limit'] = array(
			'id'      => 'quadmenu-settings[limit]',
			'db'      => 'limit',
			'type'    => 'number',
			'depth'   => array( 1, 2, 3, 4 ),
			'title'   => esc_html__( 'Limit', 'quadmenu-pro' ),
			'ops'     => array(
				'step' => 1,
				'min'  => 1,
				'max'  => 12,
			),
			'default' => 3,
		);

		$settings['orderby'] = array(
			'id'      => 'quadmenu-settings[orderby]',
			'db'      => 'orderby',
			'type'    => 'select',
			'depth'   => array( 1, 2, 3, 4 ),
			'title'   => esc_html__( 'Orderby', 'quadmenu-pro' ),
			'ops'     => array(
				'date'  => esc_html__( 'Date', 'quadmenu-pro' ),
				'title' => esc_html__( 'Title', 'quadmenu-pro' ),
			),
			'default' => 'date',
		);

		$settings['order'] = array(
			'id'      => 'quadmenu-settings[order]',
			'db'      => 'order',
			'type'    => 'select',
			'depth'   => array( 1, 2, 3, 4 ),
			'title'   => esc_html__( 'Order', 'quadmenu-pro' ),
			'ops'     => array(
				'ASC'  => esc_html__( 'Ascending', 'quadmenu-pro' ),
				'DESC' => esc_html__( 'Descending', 'quadmenu-pro' ),
			),
			'default' => 'DESC',
		);

		return $settings;
	}

	public function remove_nav_menu_item( $remove ) {

		$remove[] = 'tab';
		$remove[] = 'tabs';
		$remove[] = 'panel';
		$remove[] = 'carousel';

		return $remove;
	}

	public function remove_nav_menu_login( $item ) {

		if ( ! is_admin() && ! is_user_logged_in() && isset( $item->quadmenu_menu_item_parent ) && $item->quadmenu_menu_item_parent == 'login' ) {
			$item->_invalid = true;
		}

		return $item;
	}

	public function social( $sections ) {

		$sections[] = array(
			'id'          => 'quadmenu_social',
			'title'       => esc_html__( 'Social', 'quadmenu-pro' ),
			'heading'     => false,
			'icon'        => 'dashicons dashicons-share',
			'class'       => 'quadmenu_social',
			'permissions' => 'edit_theme_options',
			'fields'      => array(
				array(
					'id'          => 'social',
					'type'        => 'icons',
					'title'       => esc_html__( 'Networks', 'quadmenu-pro' ),
					'subtitle'    => esc_html__( 'Add your social networks', 'quadmenu-pro' ),
					'placeholder' => array(
						'title' => esc_html__( 'Title', 'quadmenu-pro' ),
						'icon'  => esc_html__( 'Icon', 'quadmenu-pro' ),
						'url'   => esc_html__( 'Link', 'quadmenu-pro' ),
					),
					'show'        => array(
						'upload'      => false,
						'description' => false,
						'key'         => false,
						'title'       => true,
						'icon'        => true,
						'url'         => true,
					),
					'default'     => apply_filters(
						'quadmenu_default_options_social',
						array(
							array(
								'title' => 'Facebook',
								'icon'  => 'dashicons dashicons-facebook-alt',
								'url'   => 'https://quadmenu.com/demo-corporate/?utm_source=quadmenu_plugin_pro&utm_medium=social&utm_campaign=facebook',
							),
							array(
								'title' => 'Twitter',
								'icon'  => 'dashicons dashicons-twitter',
								'url'   => 'https://quadmenu.com/demo-corporate/?utm_source=quadmenu_plugin_pro&utm_medium=social&utm_campaign=twitter',
							),
							array(
								'title' => 'Google',
								'icon'  => 'dashicons dashicons-googleplus',
								'url'   => 'https://quadmenu.com/demo-corporate/?utm_source=quadmenu_plugin_pro&utm_medium=social&utm_campaign=google',
							),
							array(
								'title' => 'RSS',
								'icon'  => 'dashicons dashicons-rss',
								'url'   => 'https://quadmenu.com/demo-corporate/?utm_source=quadmenu_plugin_pro&utm_medium=social&utm_campaign=rss',
							),
						)
					),
				),
			),
		);

		return $sections;
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
