<?php

/**
 * Fired during plugin activation
 *
 * @since      1.0.0
 *
 * @package    VIWCPF_Woocommerce_Product_Filters
 * @subpackage VIWCPF_Woocommerce_Product_Filters/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    VIWCPF_Woocommerce_Product_Filters
 * @subpackage VIWCPF_Woocommerce_Product_Filters/includes
 * @author     Villatheme
 */
class VIWCPF_Woocommerce_Product_Filters_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		if ( ! get_option( 'viwcpf_setting_params' ) ) {
			$default_option = new VIWCPF_Woocommerce_Product_Filters_Data();
			$args_option = $default_option->get_default();
			add_option( 'viwcpf_setting_params', $args_option );

		}

	}

	public function after_activated( $plugin ) {}

}
