<?php

namespace Colorizer;

function add_editor() {
    add_action('add_meta_boxes', function($post_type, $post) {
        if( $post_type == 'product' && wc_get_product($post)->is_type('variable') ) {
            add_meta_box( 'colorizerbox', 'Colorizer', 'Colorizer\display_meta_box', 'product', 'normal', 'high');
        }
    }, 10, 2);
    
    add_action( 'admin_enqueue_scripts', function($hook_suffix) {
        if( $hook_suffix !== 'post.php' || get_post_type() !== 'product') return;
        $id = get_the_ID();
        $product = wc_get_product($id);
        if( !wc_get_product($id)->is_type('variable') ) return;
        
        
        $modifier = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
        wp_enqueue_media();
        wp_enqueue_style('colorizer', plugins_url("assets/css/style$modifier.css", __FILE__ ));
        wp_enqueue_script('vue2', plugins_url("assets/js/editor/vue$modifier.js", __FILE__ ));
        wp_enqueue_script('fabric', plugins_url("assets/js/editor/fabric$modifier.js", __FILE__ ));
        wp_enqueue_script('sortable', plugins_url("assets/js/editor/sortable$modifier.js", __FILE__ ));
        wp_enqueue_script('colorizer-editor', plugins_url("assets/js/editor/editor$modifier.js", __FILE__ ));
        wp_localize_script('colorizer-editor', 'colorizer', [
            'images' => product_images($product),
            'attributes' => product_attributes($product),
            'models' => get_post_meta($id, 'colorizer_data', true)
        ]);
        wp_enqueue_script('colorizer', plugins_url("assets/js/editor/colorizer.js", __FILE__ ));
    } );
}

add_editor();

function display_meta_box($post) {
    echo '<div is="colorizer" id="colorizer-wrapper"></div>';
    echo '<pre>';
        print_r(get_post_meta($post, 'colorizer_data', true));
    echo '</pre>';
}

add_action('save_post', function($post_id) {
    if( !get_post_type($post_id) === 'product' || !isset($_REQUEST['colorizer_data']) ) return;
    
    $data = $_REQUEST['colorizer_data'];
    if( $data ) update_post_meta($post_id, 'colorizer_data', $data);
});