<?php
namespace Colorizer;

add_action( 'admin_enqueue_scripts', function($hook_suffix) {
    if( $hook_suffix !== 'post.php' && get_post_type() != 'order') return;
    wp_enqueue_script( 'colorizer-order-edit', plugins_url('assets/js/order-edit.js', __FILE__ ) );
} );

// Don't show base64 item meta
add_filter('woocommerce_hidden_order_itemmeta', function($keys) {
    $keys[] = '_colorizer_thumbnail';
    return $keys;
});

// Show saved thumbnails in order (using js, sadly :( )
add_action('woocommerce_before_order_itemmeta', function($item_id, $item ) {
    $image = $item->get_meta('_colorizer_thumbnail', true);
    if( !$image || ! is_base64_jpeg($image)) return $html;
    // We can't simply add src=$image using woocommerce_admin_order_item_thumbnail, because data: protocol is not supported by default and the $thumbnail is escaped with wp_kses_post.
    // Enabling this protocol globally is not a good idea either. So the only way is to replace it using JS.
    echo '<input type="hidden" value="'.$image.'" class="colorizer_thumbnail">';
}, 1000, 2);