<?php

namespace Colorizer;

function init() {
    if( is_admin() ) {
        // Add attribute settings
        require_once('attribute-settings.php');

        // Add admin editor
        require_once('product-edit.php');

        // Order edit
        // This still has to be tested
        // require_once('order-edit.php');
    } else {
        require_once('front.php');
    }
}

function product_images($product) {
    $main_image_url = wp_get_attachment_url($product->get_image_id());
    $gallery_ids = $product->get_gallery_image_ids();

    $images = [];
    if( $main_image_url ) $images[] = $main_image_url;
    foreach($gallery_ids as $id) {
        $url = wp_get_attachment_url($id);
        if( $url ) $images[] = $url;
    }
    return $images;
}

function product_attributes($product) {
    $all_attributes = $product->get_attributes();
    $variation_attributes = [];
    $upload_dir = wp_upload_dir();
    foreach($all_attributes as $name => $attr) {
        if( $attr->get_variation() ) {
            $attribute_values = [];
            foreach($attr->get_terms() as $term) {
                $pattern = get_term_meta($term->term_id, 'colorizer_pattern', true);
                $attribute_values[] = [
                    'id' => $term->term_id,
                    'name' => $term->name,
                    'slug' => $term->slug,
                    'color' => get_term_meta($term->term_id, 'colorizer_color', true),
                    'pattern' => $pattern ? $upload_dir['baseurl'].$pattern : false,
                ];
            }
            $variation_attributes[] = [
                'name' => wc_attribute_label( urldecode($name) ),
                'slug' => $name,
                'id' => $attr->get_id(),
                'values' => $attribute_values
            ];
        }
    }
    return $variation_attributes;
}

function is_base64_jpeg($string) {
    $beginning = 'data:image/jpeg;base64';
    return substr($string, 0, strlen($beginning)) === $beginning;
}

function is_base64_png($string) {
    $beginning = 'data:image/png;base64';
    return substr($string, 0, strlen($beginning)) === $beginning;
}