<?php

namespace Colorizer;

function wc_taxonomies() {
    static $saved = null;
    if( $saved !== null ) return $saved;

    $saved = wc_get_attribute_taxonomies();
    foreach($saved as &$term) {
        $term->taxonomy_slug = "pa_{$term->attribute_name}";
    }
    return $saved;
}

function add_term_color_picker() {
    // Color picker
    add_action( 'admin_enqueue_scripts', function($hook_suffix) {
        if( $hook_suffix !== 'term.php' && $hook_suffix !== 'edit-tags.php') return;
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_style( 'colorizer-admin',  plugins_url('assets/css/admin.css', __FILE__ ), [], false );
        wp_enqueue_script( 'colorizer-color-picker', plugins_url('assets/js/term-edit.js', __FILE__ ), [ 'wp-color-picker' ], false, true );
    } );

    // Add templates
    foreach( wc_taxonomies() as $term ) {
        add_action("{$term->taxonomy_slug}_edit_form_fields", 'Colorizer\color_term_edit_screen');
        add_action( "{$term->taxonomy_slug}_add_form_fields", 'Colorizer\color_term_new_screen');
        add_action("{$term->taxonomy_slug}_edit_form_fields", 'Colorizer\pattern_term_screen');
        add_action( "{$term->taxonomy_slug}_add_form_fields", 'Colorizer\pattern_term_screen');
        add_action( "{$term->taxonomy_slug}_term_new_form_tag", 'Colorizer\pattern_multipart_form');
        add_action( "{$term->taxonomy_slug}_term_edit_form_tag", 'Colorizer\pattern_multipart_form');
    }

    // Save color
    add_action('edit_terms', 'Colorizer\save_term_color', 10, 1);
    add_action('create_term', 'Colorizer\save_term_color', 10, 1);

    // Save pattern
    add_action('edit_terms', 'Colorizer\save_term_pattern', 10, 1);
    add_action('create_term', 'Colorizer\save_term_pattern', 10, 1);
}
add_term_color_picker();

// Helper functions
function color_term_edit_screen($term) {
    $label = __('Color', 'colorizer2');
    $description = __('Select color if you want this term to colorize your products', 'colorizer2');
    $color = get_term_meta($term->term_id, 'colorizer_color', true);

    echo '<tr class="form-field term-description-wrap">';
        echo '<th scope="row"><label for="colorizer_color">' . $label . '</label></th>';
        echo '<td><input type="text" value="'.$color.'" name="colorizer_color" id="colorizer_color" class="large-text">';
        echo '<p class="description">'.$description.'</p></td>';
    echo '</tr>';
}

function color_term_new_screen() {
    $label = __('Color', 'colorizer2');
    $description = __('Select color if you want this term to colorize your products', 'colorizer2');

    echo '<div class="form-field">';
		echo '<label for="attribute_name">'.$label.'</label>';
		echo '<input type="text" name="colorizer_color" id="colorizer_color" class="large-text">';
		echo '<p class="description">'.$description.'</p>';
	echo '</div>';
}

function pattern_multipart_form() {
    echo ' enctype="multipart/form-data"';
}

function pattern_term_screen($term) {
    $label = __('Pattern', 'colorizer2');
    $description = __('Upload a pattern image to add to this color', 'colorizer2');

    echo '<tr class="form-field term-description-wrap">';
        echo '<th scope="row"><label for="colorizer_pattern">'.$label.'</label></th>';

        if ($term instanceof \WP_Term) {
            $pattern = get_term_meta( $term->term_id, 'colorizer_pattern', true );

            echo '<td><input type="file" name="colorizer_pattern" id="colorizer_pattern">';

            if ($pattern) {
                $upload_dir = wp_upload_dir();
                echo '<img class="colorizer_pattern_preview" src="'.$upload_dir['baseurl'].$pattern.'" alt="" />';
                echo '<label><input type="checkbox" name="colorizer_pattern_remove"> Remove pattern</label>';
            }

            echo '<p class="description">'.$description.'</p></td>';
        } else {
            echo '<td><p class="description">'.__('Please save the color and edit it to add a pattern', 'colorizer2').'</p></td>';
        }
    echo '</tr>';
}

function save_term_color($term) {
    if( !isset($_REQUEST['colorizer_color']) ) return;
    $color_not_validated = $_REQUEST['colorizer_color'];
    $color = sanitize_hex_color($color_not_validated);
    if( !$color ) return;
    update_term_meta($term, 'colorizer_color', $color);
}

function save_term_pattern($term_id) {
    if ( isset( $_REQUEST['colorizer_pattern_remove'] ) && $_REQUEST['colorizer_pattern_remove'] === 'on' ) {
        remove_term_pattern_file( $term_id );
        delete_term_meta( $term_id, 'colorizer_pattern' );
        return;
    }

    if( !isset($_REQUEST['colorizer_color']) || !isset($_FILES['colorizer_pattern']) ) return;
    $file = wp_handle_upload($_FILES['colorizer_pattern'], ['test_form' => false]);

    if (isset($file['error'])) {
        return;
    }

    // Remove old pattern (if exists)
    remove_term_pattern_file( $term_id );

    $upload_dir = wp_upload_dir();
    $pattern = str_replace($upload_dir['basedir'],'', $file['file']);
    update_term_meta($term_id, 'colorizer_pattern', $pattern);
}

function remove_term_pattern_file( $term_id ) {
    $upload_dir = wp_upload_dir();
    $pattern = get_term_meta( $term_id, 'colorizer_pattern', true );
    if ( $pattern ) {
        @unlink( $upload_dir['basedir'] . $pattern );
    }
}
