'use strict'

/* global Vue */
/* global EditorModel */
/* global colorizer */

Vue.component('colorizer', {
    data: function() {
        const models = colorizer.models.length ? JSON.parse(colorizer.models).map( EditorModel.fromObject ) : [];
        while( colorizer.images.length > models.length ) {
            models.push(new EditorModel( colorizer.images[models.length] ));
        }
        return {
            images: colorizer.images,
            models: models,
            selected: null
        }
    },
    template: `
        <div v-if="images" class="colorizer">
            <div class="images-select">
                <span @click="changeSelected(index)" :class="{selected: index === selected}" v-for="(src, index) in images" :key="index"><img :src="src"></span>
            </div>
            <colorizer-editor @modelChanged="(m) => models[selected] = m" ref="editor" :style="{display: selected === null ? 'none' : 'flex'}"></colorizer-editor>
            <input type="hidden" id="colorizer_data" name="colorizer_data" value="">
        </div>
        <div v-else="!images">
            Add images (product image and gallery) first!
        </div>
    `,
    methods: {
        changeSelected: function(index) {
            this.selected = index;
            this.$refs.editor.setModel(this.models[index]);
        }
    },
    mounted: function() {
      if( this.images ) {
          const self = this;
          document.getElementById('post').addEventListener("submit", function(e){
             document.getElementById('colorizer_data').value = '[' + self.models.map((m) => m.toJson()).join(',') + ']';
          }, false);
      }
    }
})