<?php get_header() ?>

<div class="container">
  <div class="row justify-content-center">
    <div class="col-lg-9 border-left border-right <?php echo esc_attr(get_theme_mod('sidebar_in_post','order-0')) ?>">

      <!-- content -->
        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
          <article <?php post_class("row justify-content-center post-container clearfix") ?> >
            <?php if(has_post_thumbnail()&& get_theme_mod('want_featured_img_in_post', 1) ): ?>
              <div class="featured-img lazy" data-src="<?php the_post_thumbnail_url('weart_featured') ?>"></div>
            <?php endif; ?>
            <header class="col-12 dropcap pt-3">
              <?php if(get_theme_mod('want_category_meta',1)){ ?><div class="category text-uppercase f-meta mt-4"><?php the_category(', ') ?></div><?php } ?>
              <h1 class="title my-3"><?php the_title() ?></h1>
              <?php if(get_theme_mod('want_excerpt',1)){ ?><div class="lead my-4 c-title"><?php the_excerpt() ?></div><?php } ?>
              <?php weart_meta('single') ?>
              <hr>
            </header>

            <?php //article leaderboard banner
            if ( !empty( get_theme_mod('post_banner', '')) ){ ?>
              <div id="post_banner" class="ads col-12">
                <div class="inner">
                  <?php echo get_theme_mod( 'post_banner', '' );	?>
                </div>
                <hr class="my-3 w-100">
              </div>
            <?php } //end ?>

            <div class="col-lg-10 content">
              <?php the_content() ?>

              <div class="content-pager cf">
                <?php wp_link_pages() ?>
              </div>

              <?php if( get_theme_mod('want_share',1) && shortcode_exists( 'ssba-buttons' ) ) { ?>
                <?php echo do_shortcode('[ssba-buttons]') ?>
              <?php } ?>
            </div>
          </article><!-- article -->
        <?php endwhile; endif; ?>
      <!-- end -->

      <!-- related -->
        <?php if( get_theme_mod('want_related_posts', '1') ): ?>
          <div class="related my-4">
            <?php weart_single_title( esc_html__('Realted Posts','newspaper')) ?>
            <div class="row justify-content-center my-5">

              <div class="col-lg-10">

                <?php $categories = get_the_category($post->ID);
                $category_ids = array();
                foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;
                $the_query = new WP_Query( array(
                  'posts_per_page' => 5,
                  'category__in' => $category_ids,
                  'post__not_in' => array($post->ID),
                  'ignore_sticky_posts'=>1,
                  'orderby'=>get_theme_mod( 'what_related', 'rand' ),
                  'order'=> 'DESC',
                ));
                if($the_query->have_posts()){ while($the_query->have_posts()){ $the_query->the_post(); ?>
                  <a href="<?php the_permalink() ?>" title="<?php the_title_attribute() ?>">
                    <div class="row align-items-center item py-3">
                      <div class="col-md-4 border-right">
                        <div class="img lazy" data-src="<?php the_post_thumbnail_url('weart-featured') ?>"></div>
                      </div>
                      <div class="col">
                        <h2 class="h4"><?php the_title() ?></h2>
                        <?php the_excerpt() ?>
                      </div>
                    </div>
                  </a>
                  <hr class="m-0">
                <?php } wp_reset_postdata(); } ?>


              </div>

            </div>
          </div><!-- related -->
        <?php endif; ?>
      <!-- end -->

      <div class="post-comments">
        <?php comments_template( '', true );  ?>
      </div>

    </div><!-- col-lg-9 -->
    <?php get_sidebar() ?>
  </div><!-- row -->
</div><!-- container -->

<?php get_footer() ?>