<?php

function weart_item($args = array()){
  $large = !isset($args['large'])? '' : 'tag-large';
  ?>
    <article <?php post_class('col-lg-3 col-md-6 article-list border item-hover infinite-post '.$large) ?>>
      <a href="<?php the_permalink() ?>" title="<?php the_title_attribute() ?>">
        <div class="inner pt-3">
          <?php if ( has_post_thumbnail()) : ?>
            <div class="featured-img lazy mb-3" data-src="<?php the_post_thumbnail_url( 'weart-featured' ); ?>"></div>
          <?php endif; ?>
          <h2 class="title h3"><?php the_title() ?></h2>
          <div class="excerpt"><?php the_excerpt() ?></div>
          <?php weart_meta('home') ?>
          <hr class="my-0">
        </div>
      </a>
    </article>
  <?php
} /* weart_item() */

function weart_meta( $place ){
  ?>
    <div class="meta f-meta my-3">
      <span class="author"><?php esc_html_e('By ','newspaper'); the_author(); ?></span>
      <span class="cat"><?php esc_html_e(', in ','newspaper'); foreach((get_the_category()) as $category) { echo esc_attr($category->cat_name) . esc_html(' '); } ?></span>
      <span class="date"><?php esc_html_e(', at ','newspaper'); the_time( get_option( 'date_format' ) ); ?></span>
      <?php if($place === "single"){ ?>
        <span class="cat"><?php the_tags(); ?></span>
      <?php } ?>
    </div>
  <?php
} /* weart_meta() */

function weart_single_title($title){
  ?>
    <div class="sinlge-title mb-5">
      <h3 class="f-meta c-meta h4"><span><?php echo esc_attr($title) ?></span></h3>
      <hr>
    </div><!-- title -->
  <?php
} /* weart_single_title() */

function weart_navigation(){
  $next_posts = get_next_posts_link(true); if( get_theme_mod( 'want_infinite_scroll', 1 ) &&  !empty( $next_posts ) ){ ?>
    <div class="infinite-nav d-none"><?php next_posts_link(); ?></div>
  <?php }else{ ?>
    <hr class="m-0 border-double">
    <div class="row f-meta text-uppercase text-center">
      <?php $prev_posts = get_previous_posts_link(true); if(!empty( $prev_posts )){ ?>
        <div class="col-lg-6 mr-auto border-left py-2">
          <?php previous_posts_link(); ?>
        </div>
      <?php } $next_posts = get_next_posts_link(true); if(!empty( $next_posts )){ ?>
        <div class="col-lg-6 ml-auto border-left py-2">
          <?php next_posts_link(); ?>
        </div>
      <?php } ?>
    </div><!-- .row -->
  <?php }
} /* weart_navigation() */

function weart_latest(){
  ?>
    <!-- masonry grid articles -->
      <div class="row infinite-scroll" id="masonry">
        <div class="grid-sizer col-lg-3 col-md-6"></div>
        <?php $i=1; if ( have_posts() ) : while ( have_posts() ) : the_post();
          if($i===1 && get_theme_mod('want_large_first_post',1)){
            weart_item(array('large'=>true));
          }else{
            weart_item();
          }
        $i++; endwhile; endif; ?>
      </div>
    <!-- end -->
  <?php
} /* weart_latest() */