<!doctype html>
<html <?php language_attributes() ?>>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <?php wp_head() ?>
</head>
<body <?php body_class() ?>>

<?php //header leaderboard banner
if ( !empty( get_theme_mod('header_leaderboard', '')) ){ ?>
  <div id="header_leaderboard" class="ads mb-5">
    <div class="inner">
      <?php echo get_theme_mod( 'header_leaderboard', '' );	?>
    </div>
  </div>
<?php } //end ?>

<header>
  <div class="<?php echo get_theme_mod('header_width', 'container') ?>">
    <div class="row justify-content-center align-items-center mb-2 mt-3">
      <div class="left f-meta">
        <?php echo date('l, F j, Y'); ?>
      </div>
      <div class="col-12 logo text-center">
        <?php if ( has_custom_logo() ) {
            the_custom_logo();
        }else{
          if ( is_front_page() && is_home() ) : ?>
            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
          <?php else : ?>
            <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
          <?php endif;
        } ?>
      </div>
      <div class="right f-meta">
        <?php bloginfo('description') ?>
      </div>
    </div>
    <hr class="m-0">
  </div>
</header>

<?php if(has_nav_menu('desktop-menu')): ?>
  <div id="header-nav">
    <nav class="navbar navbar-expand-md f-meta py-1" role="navigation">
      <div class="<?php echo get_theme_mod('header_width', 'container') ?>">

        <button class="btn btn-sm bars">
          <i class="fas fa-bars"></i>
        </button>

        <?php if(get_theme_mod('want_wooicon', 1) && function_exists('wc_get_cart_url')): ?>
          <a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="nav-text woo-icon">
            <i class="fas fa-shopping-cart"></i> <span><?php echo woocommerce_header_add_to_cart_fragment()['#cart-count'];?></span>
          </a>
        <?php endif; ?>

        <?php if(has_nav_menu('desktop-menu')): wp_nav_menu(array(
          'theme_location'    => 'desktop-menu',
          'depth'             => 2,
          'container'         => 'div',
          'container_class'   => 'collapse navbar-collapse',
          'container_id'      => 'dd',
          'menu_class'        => 'nav navbar-nav mx-auto',
          'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
          'walker'            => new WP_Bootstrap_Navwalker(),
        )); endif; ?>

        <?php if(has_nav_menu('social-menu')): wp_nav_menu(array(
          'theme_location'    => 'social-menu',
          'depth'             => 1,
          'container'         => 'div',
          'container_class'   => 'social-channels d-none',
          'container_id'      => 'social',
          'menu_id'           => 'menu-social',
          'menu_class'        => 'nav navbar-nav mx-auto',
          'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
          'walker'            => new WP_Bootstrap_Navwalker(),
        )); endif; ?>

        <button class="btn btn-sm" data-toggle="modal" data-target="#searchPopUp">
          <i class="fas fa-search"></i>
        </button>

      </div>
    </nav>
    <div class="<?php echo get_theme_mod('header_width', 'container') ?>"><hr class="m-0 border-black border-2x"></div>
  </div>
<?php endif; ?>

<div id="mobile_menu" class="">
  <div id="mm_inner" class="inner">
    <div class="bg-light">
      <div class="d-flex p-3">
        <button type="button" class="close bars mx-auto" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="logo text-center pb-3">
        <?php if ( has_custom_logo() ) {
            the_custom_logo();
        }else{ ?>
          <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
        <?php } ?>
      </div>
    </div>
    <?php if(has_nav_menu('mobile-menu')): wp_nav_menu(array(
      'theme_location'    => 'mobile-menu',
      'container'         => 'div',
      'container_class'   => 'mobile-menu-ul f-meta',
    )); endif; ?>
  </div>
</div>