<?php

////////////////////////////////////////////////////////////
// google fonts import the right way
  if ( ! function_exists( 'weart_fonts_url' ) ) :
  function weart_fonts_url() {
      $fonts_url = '';
      $fonts     = array();
      $subsets   = '';
      if ( 'off' !== esc_html( 'on' ) ) {
          $fonts[] = get_theme_mod('text_font', 'Montserrat');
      }
      if ( 'off' !== esc_html( 'on' ) ) {
          $fonts[] = get_theme_mod('text_font', 'Playfair Display:400,700');
      }
      if ( 'off' !== esc_html( 'on' ) ) {
          $fonts[] = get_theme_mod('text_font', 'Lora:400,700');
      }
      if ( $fonts ) {
          $fonts_url = add_query_arg( array(
              'family' => urlencode( implode( '|', $fonts ) ),
              'subset' => urlencode( $subsets ),
          ), 'https://fonts.googleapis.com/css' );
      }
      return $fonts_url;
  } endif;



////////////////////////////////////////////////////////////
// Enqueue scripts and styles.
  if ( ! function_exists( 'weart_scripts' ) ) :
  function weart_scripts() {

    /* STYLES */
      wp_enqueue_style( 'fontawesome-all-min', get_template_directory_uri() . '/assets/fonts/fontawesome/css/all.min.css', array(), null  );
      wp_enqueue_style( 'newspaper-weart-fonts', weart_fonts_url(), array(), null );
      wp_enqueue_style( 'newspaper-weart-style', get_template_directory_uri() . '/assets/weart.css', array(), null  );
      wp_enqueue_style( 'newspaper-style', get_stylesheet_uri() );

    /*SCRIPTS*/

    // masonry
    	wp_enqueue_script( 'jquery-masonry', false, array( 'jquery'), false, true );

    // infinite
      wp_register_script('jquery-infinitescroll-min', get_template_directory_uri() . '/assets/js/jquery.infinitescroll.min.js', array( 'jquery' ), null, true );
      wp_enqueue_script('jquery-infinitescroll-min');

    // lazyload
      wp_register_script( 'lazyload-min', get_template_directory_uri() . '/assets/js/lazyload.min.js', null, null, true );
      wp_enqueue_script( 'lazyload-min' );

    // Bootstrap
      wp_register_script( 'bootstrap-boundle-min', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array( 'jquery' ), null, true );
      wp_enqueue_script( 'bootstrap-boundle-min' );

    // Theme Main JS
      wp_register_script( 'newspaper-weart', get_template_directory_uri() . '/assets/weart.js', array( 'jquery' ), null, true );
      wp_enqueue_script( 'newspaper-weart' );

    /* COMMENT REPLY */
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { wp_enqueue_script( 'comment-reply' ); }

  } endif;
  add_action( 'wp_enqueue_scripts', 'weart_scripts' );
