<?php

////////////////////////////////////////////////////////////
// first run setup
  if ( ! function_exists( 'weart_setup' ) ) :

    function weart_setup() {
      load_theme_textdomain( 'newspaper', get_template_directory() . '/languages' );
      add_theme_support( 'automatic-feed-links' );
      add_theme_support( 'title-tag' );
      add_theme_support('editor_style');

      //register nav menus
      register_nav_menus( array(
        'mobile-menu' => 'Mobile Menu',
        'social-menu' => 'Social Menu',
        'desktop-menu' => 'Desktop Menu',
        'footer-menu' => 'Footer Menu',
        ) );

      //custom featured image size
      add_theme_support( 'post-thumbnails' );
      add_image_size( 'weart-list', 99999, 100 );
      add_image_size( 'weart-grid-small', 500, 99999 );
      add_image_size( 'weart-grid-big', 690, 99999);
      add_image_size( 'weart-featured', 1024, 9999 );

      //html5 support & background & logo
      add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
      add_theme_support( 'custom-background', apply_filters( 'weart_custom_background_args', array(
        'default-color' => 'fefefe',
        'default-image' => '',
      ) ) );
      add_theme_support( 'custom-logo', array(
        'flex-height'   => true,
        'flex-widht'    => true,
        'header-text'   => array( 'site-title', 'site-description' )
      ) );

      //post formats
      add_theme_support( 'post-formats', array(
        'video',
        'gallery',
        'audio',
      ) );

    }

  endif;
  add_action( 'after_setup_theme', 'weart_setup' );


////////////////////////////////////////////////////////////
// Set the content width in pixels, based on the theme's design and stylesheet.
// @global int $content_width
  function weart_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'weart_content_width', 820 );
  }
  add_action( 'after_setup_theme', 'weart_content_width', 0 );


////////////////////////////////////////////////////////////
//excerts
  function weart_excerpt_length( $length ) {
    return 20;
  }
  add_filter( 'excerpt_length', 'weart_excerpt_length', 999 );

  function weart_excerpt_more( $more ) {
    return '...';
  }
  add_filter( 'excerpt_more', 'weart_excerpt_more' );


////////////////////////////////////////////////////////////
// editor style
  function weart_add_editor_styles() {
   add_editor_style( get_template_directory_uri() . '/assets/editor-style.css' );
  }
  add_action( 'init', 'weart_add_editor_styles' );


////////////////////////////////////////////////////////////
// Video embed responsive
  function weart_oembed_filter($html) {
      $return = '<div class="embed-responsive embed-responsive-16by9">'.$html.'</div>';
      return $return;
  }
  add_filter( 'embed_oembed_html', 'weart_oembed_filter', 10, 4 ) ;
  add_filter( 'video_embed_html', 'weart_oembed_filter' ); // Jetpack


////////////////////////////////////////////////////////////
// facebook opengraph and twitter card meta add
  function weart_doctype_opengraph($output) {
      return $output . '
      prefix="og: http://ogp.me/ns#"';
  }
  add_filter('language_attributes', 'weart_doctype_opengraph');

  function weart_social_meta() {
    global $post;
    if(is_single()) {
      if(has_post_thumbnail($post->ID)) {
        $img_src = wp_get_attachment_image_src(get_post_thumbnail_id( $post->ID ), 'large');
      }else { $img_src = ''; }

      if($excerpt = $post->post_excerpt) {
        $excerpt = strip_tags($post->post_excerpt);
        $excerpt = str_replace("", "'", $excerpt);
      } else {
        $excerpt = get_bloginfo('description');
      } ?>
      <!-- facebook -->
      <meta property="og:type" content="article"/>
      <meta property="og:title" content="<?php the_title(); ?>"/>
      <meta property="og:description" content="<?php echo strip_tags(get_the_excerpt()); ?>"/>
      <meta property="og:url" content="<?php the_permalink(); ?>"/>
      <meta property="og:image" content="<?php if( !empty($img_src) ){ echo esc_url($img_src[0]); } ?>"/>
      <meta property="og:site_name" content="<?php bloginfo('name'); ?>"/>
      <!-- twitter -->
      <meta name="twitter:card" content="summary" />
      <meta name="twitter:title" content="<?php the_title(); ?>" />
      <meta name="twitter:description" content="<?php echo strip_tags(get_the_excerpt()); ?>" />
      <meta name="twitter:url" content="<?php the_permalink(); ?>" />
      <meta name="twitter:image" content="<?php if( !empty($img_src) ){ echo esc_url($img_src[0]); } ?>" />
    <?php } else { return; }
  }
  add_action('wp_head', 'weart_social_meta', 5);

////////////////////////////////////////////////////////////
// Mega menu

  add_filter( 'walker_nav_menu_start_el', 'weart_desktop_menu', 10, 4 );

  function weart_desktop_menu( $item_output, $item, $depth, $args ) {
    global $wp_query;
      // The mega dropdown only applies to the main navigation.
      // Your theme location name may be different, "main" is just something I tend to use.
      if ( 'desktop-menu' !== $args->theme_location )
          return $item_output;

      // The mega dropdown needs to be added to one specific menu item.
      // I like to add a custom CSS class for that menu via the admin area.
      // You could also do an item ID check.
      if ( in_array( 'weart-megamenu', $item->classes ) ) {
        global $wp_query;
        global $post;
        $subposts = get_posts( array(
          'numberposts' => 4,
          'cat' => $item->object_id,
        ));
        $item_output .= '<div class="weart-megamenu bg-white border-top shadow"><div class="container border"><div class="row">';
          foreach( $subposts as $post ) : setup_postdata( $post );
          $item_output .= '<div class="col-lg-3 col-md-6 border item py-3 item-hover"><a href="'. get_permalink( $post->ID ) .'"><div class="row align-items-center no-gutters">';
            if(has_post_thumbnail($post)){ $item_output .= '<div class="col-3 mr-3"><div class="img lazy" data-src="'.get_the_post_thumbnail_url( $post->ID, 'weart-featured' ).'"></div></div>'; }
            $item_output .= '<div class="col mr-3"><span class="title f-meta">'.get_the_title( $post->ID ).'</span></div>';
          $item_output .= '</div></a></div>';
          endforeach; wp_reset_postdata();
        $item_output .= '</div></div></div>';
      }
      return $item_output;
  }

//Exclude pages from WordPress Search
////////////////////////////////////////////////////////////
  if (!is_admin()) {
    function wpb_search_filter($query) {
      if ($query->is_search) { $query->set('post_type','post'); }
      return $query;
    }
    add_filter('pre_get_posts','wpb_search_filter');
  }