<?php
function weart_color_changer() {
  wp_enqueue_style( 'main-style', get_stylesheet_uri() );

  // title
    $title_color = get_theme_mod( 'title_color', '#121212' ); //E.g. #FF0000
    if( !empty($title_color) ){
      $title = "
      .border-black{
        border-color: $title_color !important; }

      h1, h2, h3, h4, h5, h6, .h1,
      .woocommerce div.product .product_title, .h2, .h3, .h4,
      .woocommerce div.product h1, .woocommerce div.product h2,
      .woocommerce div.product h3, .woocommerce div.product h4,
      .woocommerce div.product #reviews #review_form #respond #reply-title,
      .h5, .h6, .single .content .wp-block-latest-posts li,
      .page .content .wp-block-latest-posts li,
      .single .post-container .lead p,
      header .logo a,
      #header-nav a,
      .sidebar .widget_rss ul li a.rsswidget, .f-title {
        color: $title_color !important; }

      .featured-img:after,
      .woocommerce .button, .woocommerce #review_form #respond .form-submit input,
      .woocommerce .price_slider .ui-slider-range, .woocommerce .price_slider .ui-slider-handle{
          background-color: $title_color !important; }
                ";
      wp_add_inline_style( 'main-style', $title );
    };
  // end

  // text
    $text_color = get_theme_mod( 'text_color', '#555' ); //E.g. #FF0000
    if( !empty($text_color) ){
      $text = "
                body,a{
                  color: $text_color !important;
                }
                ";
      wp_add_inline_style( 'main-style', $text );
    };
  // end

  // link
    $link_color = get_theme_mod( 'link_color', '#2e6d9d' ); //E.g. #FF0000
    if( !empty($link_color) ){
      $link = "
                a, a:hover,
                #header-nav a:hover,
                .woocommerce .woocommerce-error:before,
                .woocommerce .woocommerce-info:before,
                .woocommerce .woocommerce-message:before,
                header .logo a:hover{
                  color: $link_color !important;
                }

                .woocommerce span.onsale{
                  background-color: $link_color !important }

                .woocommerce .woocommerce-error, .woocommerce .woocommerce-info, .woocommerce .woocommerce-message {
                  border-top-color: $link_color !important; }
                ";
      wp_add_inline_style( 'main-style', $link );
    };
  // end

  // border
    $border_color = get_theme_mod( 'border_color', '#aaa' ); //E.g. #FF0000
    if( !empty($border_color) ){
      $border = "
      .border, .border-left, .border-right,
      .border-bottom, .single ul.comment-list li.comment,
      .item-hover:hover,
      #mobile_menu #mm_inner .mobile-menu-ul ul li,
      .single .content table td, .single .content table th,
      .page .content table td, .page .content table th,
      .sidebar .widget_nav_menu ul li,
      .sidebar table td, .sidebar table th ,
      .woocommerce ul.product_list_widget li,
      .woocommerce .total,
      .woocommerce div.product form.cart .quantity input,
      .woocommerce .comment-form-comment input[type='email'],
      .woocommerce .comment-form-comment input[type='name'],
      .woocommerce .comment-form-comment input[type='text'],
      .woocommerce .comment-form-comment textarea,
      .woocommerce div.product #reviews #review_form #respond .form-submit input[type='submit'],
      .woocommerce div.product #reviews #review_form #respond .comment-form-comment textarea, .woocommerce div.product #reviews #review_form #respond .comment-form-comment input,
      .woocommerce div.product #reviews #review_form #respond .comment-form-email textarea,
      .woocommerce div.product #reviews #review_form #respond .comment-form-email input,
      .woocommerce div.product #reviews #review_form #respond .comment-form-author textarea,
      .woocommerce div.product #reviews #review_form #respond .comment-form-author input ,
      .woocommerce .checkout input, .woocommerce .checkout textarea, .woocommerce .checkout select,
      .single .content blockquote, .page .content blockquote,
      .page ul.comment-list li.comment, .border-top, hr, .hr {
        border-color: $border_color !important; }

      .item-hover {
        border-color: transparent transparent transparent $border_color !important; }

      .single .content blockquote:before,
      .woocommerce ul.products li.product .star-rating,
      .page .content blockquote:before{
        color: $border_color !important }
                ";
      wp_add_inline_style( 'main-style', $border );
    };
  // end

  // meta
    $meta_color = get_theme_mod( 'meta_color', '#848484' ); //E.g. #FF0000
    if( !empty($meta_color) ){
      $meta = "
                .c-meta,.meta,
                .single .content .wp-block-subhead, .page .content .wp-block-subhead,
                .single div.ssba .ssba-share-text, .page div.ssba .ssba-share-text,
                .single .content .wp-caption-text, .page .content .wp-caption-text {
                  color: $meta_color !important; }

                .woocommerce .price_slider.ui-widget-content{
                  backgrund-color: $meta_color !important; }
                ";
      wp_add_inline_style( 'main-style', $meta );
    };
  // end

} add_action( 'wp_enqueue_scripts', 'weart_color_changer' );
