<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'back_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/CMB2/CMB2
 */

/**
 * Get the bootstrap! If using the plugin from wordpress.org, REMOVE THIS!
 */

if ( file_exists( dirname( __FILE__ ) . '/cmb2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/cmb2/init.php';
} elseif ( file_exists( dirname( __FILE__ ) . '/CMB2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/CMB2/init.php';
}

/**
 * Conditionally displays a metabox when used as a callback in the 'show_on_cb' cmb2_box parameter
 *
 * @param  CMB2 $cmb CMB2 object.
 *
 * @return bool      True if metabox should show
 */
function back_show_if_front_page( $cmb ) {
	// Don't show this metabox if it's not the front page template.
	if ( get_option( 'page_on_front' ) !== $cmb->object_id ) {
		return false;
	}
	return true;
}



/**
 * Conditionally displays a field when used as a callback in the 'show_on_cb' field parameter
 *
 * @param  CMB2_Field $field Field object.
 *
 * @return bool              True if metabox should show
 */
function rs_hide_if_no_cats( $field ) {
	// Don't show this field if not in the cats category.
	if ( ! has_tag( 'cats', $field->object_id ) ) {
		return false;
	}
	return true;
}

/**
 * Manually render a field.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function rs_render_row_cb( $field_args, $field ) {
	$classes     = $field->row_classes();
	$id          = $field->args( 'id' );
	$label       = $field->args( 'name' );
	$name        = $field->args( '_name' );
	$value       = $field->escaped_value();
	$description = $field->args( 'description' );
	?>
	<div class="custom-field-row <?php echo esc_attr( $classes ); ?>">
		<p><label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label></p>
		<p><input id="<?php echo esc_attr( $id ); ?>" type="text" name="<?php echo esc_attr( $name ); ?>" value="<?php echo $value; ?>"/></p>
		<p class="description"><?php echo esc_html( $description ); ?></p>
	</div>
	<?php
}

/**
 * Manually render a field column display.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function rs_display_text_small_column( $field_args, $field ) {
	?>
	<div class="custom-column-display <?php echo esc_attr( $field->row_classes() ); ?>">
		<p><?php echo $field->escaped_value(); ?></p>
		<p class="description"><?php echo esc_html( $field->args( 'description' ) ); ?></p>
	</div>
	<?php
}

/**
 * Conditionally displays a message if the $post_id is 2
 *
 * @param  array      $field_args Array of field parameters.
 * @param  CMB2_Field $field      Field object.
 */
function rs_before_row_if_2( $field_args, $field ) {
	if ( 2 == $field->object_id ) {
		echo '<p>Testing <b>"before_row"</b> parameter (on $post_id 2)</p>';
	} else {
		echo '<p>Testing <b>"before_row"</b> parameter (<b>NOT</b> on $post_id 2)</p>';
	}
}


add_action( 'cmb2_admin_init', 'back_register_header_post_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */
function back_register_header_post_metabox() {
	$prefix = 'backs_demo_'; 

  /**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demos = new_cmb2_box( array(
	'id'            => $prefix . 'metabox',
	'title'         => esc_html__( 'Post Settings', 'back' ),
	'object_types'  => array( 'post' ), // Post type
    'context'      => 'normal',
    'priority'     => 'high',
    'show_names'      => true,
		
	) );

	$cmb_demos->add_field( array(
		'name' => esc_html__( 'Youtube Video Link', 'back' ),
		'desc' => '',
		'id'   => 'posts_video',
		'type' => 'text',
		'desc' => esc_html__( 'Ex: Video link here (Note:Only For Video Post Format)', 'back' ),
	) );
}


add_action( 'cmb2_admin_init', 'back_register_header_metabox' );
function back_register_header_metabox() {
	$prefix = 'back_'; 

 /**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_back = new_cmb2_box( array(
		'id'      => $prefix . 'metabox',
		'title'     => esc_html__( 'Page Options', 'back' ),
		'object_types' => array( 'mp-event','page','post','product','archive' ), // Post type
		'vertical_tabs' => true, // Set vertical tabs, default false
		'tabs' => array(

	      	array(
		        'id'  => 'tab-2',
		        'icon' => 'dashicons-admin-generic',
		        'title' => 'Topbar Settings',
		        'fields' => array(
		          	'select-top',
		        ),
	 		), 
	      	array(
		        'id'  => 'tab-3',
		        'icon' => 'dashicons-admin-generic',
		        'title' => 'Header Settings',
		        'fields' => array(
		          	'header_select',
		        ),
	 		),
	      	array(
		        'id'  => 'tab-5',
		        'icon' => 'dashicons-admin-generic',
		        'title' => 'Banner Settings',
		        'fields' => array(
		          	'banner_image',
		          	'banner_hide',
		          	'content_banner',
		          	'select-title',
		          	'select-bread',
		        ),
	 		),
	 		array(
		        'id'  => 'tab-6',
		        'icon' => 'dashicons-admin-generic',
		        'title' => 'Footer Settings',
		        'fields' => array(
		          	'back_footer_hide'
		        ),
	 		),
 		)		
)	);



	$cmb_back->add_field( array(
		'name'             => esc_html__( 'Select Header Style', 'back' ),
		'desc'             => esc_html__( 'chosse your individual header style', 'back' ),
		'id'               => 'header_select',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'header1' => esc_html__( 'Header Style 1', 'back' ),
			'header2' => esc_html__( 'Header Style 2', 'back' ),												
			'header3' => esc_html__( 'Header Style 3', 'back' ),												
			'header4' => esc_html__( 'Header Style 4', 'back' )													
		),
	));



	$cmb_back->add_field( array(
		'name'             => esc_html__( 'Show Top Bar', 'back' ),
		'desc'             => esc_html__( 'You can show/hide topbar', 'back' ),
		'id'               => 'select-top',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'show' => esc_html__( 'Show', 'back' ),
			'hide' => esc_html__( 'Hide', 'back' ),			
		),
	) );	


	$cmb_back->add_field( array(
		'name' => esc_html__( 'Select Banner Image', 'back' ),
		'desc' => esc_html__( 'Upload an image or enter a URL for page banner.', 'back' ),
		'id'   => 'banner_image',
		'type' => 'file',
	));
    
    $cmb_back->add_field( array(
		'name'             => esc_html__( 'Banner Hide', 'back' ),
		'desc'             => esc_html__( 'You Can Show or Hide Banner', 'back' ),
		'id'               => 'banner_hide',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'show' => esc_html__( 'Show', 'back' ),
			'hide' => esc_html__( 'Hide', 'back' ),			
		),
	));
    
    $cmb_back->add_field( array(
		'name'             => esc_html__( 'Footer Show/Hide', 'back' ),
		'desc'             => esc_html__( 'You Can Show or Hide Footer', 'back' ),
		'id'               => 'back_footer_hide',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'show' => esc_html__( 'Show', 'back' ),
			'hide' => esc_html__( 'Hide', 'back' ),			
		),
	));


	$cmb_back->add_field( array(
		'name'    => esc_html__( 'Page Banner Text', 'back' ),
		'desc'    => esc_html__( 'Enter some text in banner', 'back' ),
		'id'      => 'content_banner',
		'type'    => 'textarea_small',
	));

	$cmb_back->add_field( array(
		'name'             => esc_html__( 'Show Page Title', 'back' ),
		'desc'             => esc_html__( 'You can show/hide page title', 'back' ),
		'id'               => 'select-title',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'show' => esc_html__( 'Show', 'back' ),
			'hide' => esc_html__( 'Hide', 'back' ),			
		),
	));

	$cmb_back->add_field( array(
		'name'             => esc_html__( 'Show Breadcurmbs', 'back' ),
		'desc'             => esc_html__( 'You can show/hide  breadcurmbs here', 'back' ),
		'id'               => 'select-bread',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'show' => esc_html__( 'Show', 'back' ),
			'hide' => esc_html__( 'Hide', 'back' ),			
		),
	));
}



//page section metabox
add_action( 'cmb2_admin_init', 'back_register_category_grid_metabox' );
function back_register_category_grid_metabox() {
	$prefix = 'backterm_'; 
	$cmb_category = new_cmb2_box( array(
		'id'            => $prefix . 'metabox-post',
		'title'         => esc_html__( 'Category', 'back' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category' ),
	) );

	$cmb_category->add_field( array(
		'name'             => esc_html__( 'Select Category Style', 'back' ),
		'desc'             => esc_html__( 'Chosse your individual category style', 'back' ),
		'id'               => 'back_category_select',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'cate_style1' => esc_html__( 'Category Style One', 'back' ),
			'cate_style2' => esc_html__( 'Category Style Two', 'back' ),
			'cate_style3' => esc_html__( 'Category Style Three', 'back' ),							
			'cate_style4' => esc_html__( 'Category Style Four', 'back' ),						
		),
	));

	$cmb_category->add_field( array(
		'name'             => esc_html__( 'Select Sidebar', 'back' ),
		'desc'             => esc_html__( 'Chosse your column', 'back' ),
		'id'               => 'back_blog_cate_sidebar',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'full' => esc_html__( 'Full Width', 'back' ),
			'2right' => esc_html__( 'Right Sidebar', 'back' ),
			'2left' => esc_html__( 'Left Sidebar', 'back' ),												
		),
	));

	$cmb_category->add_field( array(
		'name'             => esc_html__( 'Select Column', 'back' ),
		'desc'             => esc_html__( 'Chosse your column', 'back' ),
		'id'               => 'back_blog_cate_grid',
		'type'             => 'select',
		'show_option_none' => 'Default',
		'options'          => array(
			'12' => esc_html__( '1 Column', 'back' ),
			'6' => esc_html__( '2 Column', 'back' ),
			'4' => esc_html__( '3 Column', 'back' ),							
			'3' => esc_html__( '4 Column', 'back' ),						
		),
	));

	$cmb_category->add_field( array(
		'name' => esc_html__( 'Category Image', 'back' ),
		'id'   => 'category-images',
		'type' => 'file',
	) );

	$cmb_category->add_field( array(
		'name'    => esc_html__( 'Category Color', 'back' ),
		'desc'    => esc_html__( 'Category Color', 'back' ),
		'id'      => 'category_bg_color',
		'type'    => 'colorpicker',
		'default' => '',
		'options' => array( 'alpha' => true ),		
	) );
}

/**
 * Callback to define the optionss-saved message.
 *
 * @param CMB2  $cmb The CMB2 object.
 * @param array $args {
 *     An array of message arguments
 *
 *     @type bool   $is_options_page Whether current page is this options page.
 *     @type bool   $should_notify   Whether options were saved and we should be notified.
 *     @type bool   $is_updated      Whether options were updated with save (or stayed the same).
 *     @type string $setting         For add_settings_error(), Slug title of the setting to which
 *                                   this error applies.
 *     @type string $code            For add_settings_error(), Slug-name to identify the error.
 *                                   Used as part of 'id' attribute in HTML output.
 *     @type string $message         For add_settings_error(), The formatted message text to display
 *                                   to the user (will be shown inside styled `<div>` and `<p>` tags).
 *                                   Will be 'Settings updated.' if $is_updated is true, else 'Nothing to update.'
 *     @type string $type            For add_settings_error(), Message type, controls HTML class.
 *                                   Accepts 'error', 'updated', '', 'notice-warning', etc.
 *                                   Will be 'updated' if $is_updated is true, else 'notice-warning'.
 * }
 */
function rs_options_page_message_callback( $cmb, $args ) {
	if ( ! empty( $args['should_notify'] ) ) {

		if ( $args['is_updated'] ) {

			// Modify the updated message.
			$args['message'] = sprintf( esc_html__( '%s &mdash; Updated!', 'back' ), $cmb->prop( 'title' ) );
		}

		add_settings_error( $args['setting'], $args['code'], $args['message'], $args['type'] );
	}
}

/**
 * Only show this box in the CMB2 REST API if the user is logged in.
 *
 * @param  bool                 $is_allowed     Whether this box and its fields are allowed to be viewed.
 * @param  CMB2_REST_Controller $cmb_controller The controller object.
 *                                              CMB2 object available via `$cmb_controller->rest_box->cmb`.
 *
 * @return bool                 Whether this box and its fields are allowed to be viewed.
 */
function rs_limit_rest_view_to_logged_in_users( $is_allowed, $cmb_controller ) {
	if ( ! is_user_logged_in() ) {
		$is_allowed = false;
	}

	return $is_allowed;
}

