<?php 
// Register and load the widget
function back_categories_widget() {
    register_widget( 'backcategories_widget' );
}
add_action( 'widgets_init', 'back_categories_widget' );

//Contact info Widget 
class backcategories_widget extends WP_Widget {
 
   /** constructor */
   function __construct() {
    parent::__construct(
      'backcategories_widget', 
      __('Back Categories Widget', 'back'),
      array( 'description' => __( 'Display your Categories Widget', 'back' ), )
    );
  }

 
    /** @see WP_Widget::widget */
    function widget($args, $instance) { 
        extract( $args );
        $title    = apply_filters('widget_title', $instance['title']);  
        echo wp_kses_post($before_widget); 
        if ( $title )
        echo wp_kses_post($before_title . $title . $after_title); ?>
  <div class="back-post-category back_sidebar_categories">
      <div class="back-addon-category">
          <?php 

            $post_categories = get_terms( 'category',
                $args['number']         = 1
            ); 
            
            $post_options = [];
              foreach ( $post_categories as $category ) {
                  $post_options[ $category->slug ] = $category->name;
              } 
            
              $categories = $post_options; 
              $unique = rand(100,31120);  
              foreach ( $categories as $category ) {
              $category =  get_term_by('slug', $category, 'category');       
              $theCatId = $category->term_id;                  
              $cate_img     = get_term_meta($theCatId, 'category-images', true);
              $cate_bg     = get_term_meta($theCatId, 'category_bg_color', true);
              $count = $category->count;
              $cate_bg = ($cate_bg) ? "Style=background:$cate_bg" : "" ;
              ?>
              <?php if(!empty($cate_img)){?>
              <div class="blog-item">
                  <div class="single-category">                                
                      <div class="category-part" style="background-image: url(<?php echo esc_url( $cate_img ); ?>); background-position: center top;">
                          
                            <div class="cat_overlay_bg"></div>                          
                            <div class="category">
                              <a href="<?php echo esc_url( get_category_link($category->term_id) ); ?>"><?php echo esc_html($category->name);?></a>
                              <span><?php echo esc_html($category->count);?></span>
                            </div>
                      </div>                                
                  </div>                              
              </div>
            <?php } ?>

              <?php };
              wp_reset_query();  ?>              
      </div>
  </div>
    <?php echo wp_kses_post($after_widget); ?>
     <?php
    }
    /**
    * Back-end widget fields
    */
    public function field_generator( $instance ) {
      $output = '';
      echo $output;
    }

    public function form( $instance ) {
      $title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'back' );
      ?>
      <p>
      <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'back' ); ?></label>
      <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
      </p>
      <?php
      $this->field_generator( $instance );
    }

    /**
    * Sanitize widget form values as they are saved
    */
    public function update( $new_instance, $old_instance ) {
      $instance = array();
      $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
      return $instance;
    }
} // end class

