<?php
/**
 * Back Blog Grid.
 *
 * Back Elementor widget that load blog post into grid style.
 *
 * @since 1.0.0
*/

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;


defined( 'ABSPATH' ) || die();

class backaddon_Elementor_pro_Blog_Grid_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve back Blog Grid widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'back_blog_grid';
	}		

	/**
	 * Get widget title.
	 *
	 * Retrieve back Blog Grid widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Back Posts Grid', 'back' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Blog Grid widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'glyph-icon flaticon-blogging';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Blog Grid widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
        return [ 'backthemecore_category' ];
    }

	/**
	 * Register Blog Grid widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {		
	    $post_dropdown[0] = 'Select Post';
        $back_query = new wp_Query(array(
            'post_type'      => 'post',
            'posts_per_page' => '-1',                                          
        )); 

        if ( $back_query->have_posts() ):
            while($back_query->have_posts()): $back_query->the_post();       
                $id    = get_the_ID($back_query->ID);
                $title = get_the_title($back_query->ID);
                $post_dropdown[$id] = $title;
            endwhile;
            wp_reset_query(); 
        endif;    

	   
        //Default Settings Here
		$this->start_controls_section(
			'_section_settings',
			[
				'label' => esc_html__( 'Default Settings', 'back' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

	        $this->add_control(
	            'blog_content_postion_style',
	            [
	                'label' => esc_html__( 'Blog Layout', 'back' ),
	                'type' => Controls_Manager::SELECT,
	                'default' => 'default',
	                'options' => [
	                    'default' => esc_html__( 'Default', 'back' ),
                        'style_two' => esc_html__( 'Style Two', 'back' ),
	                    'transparent' => esc_html__( 'Transparent', 'back' ),
	                ],                
	            ]
	        );

	        $this->add_control(
	            'pre_blog_posts_is_manual_selection',
	            [
	                'label' => esc_html__( 'Select posts by:', 'back' ),
	                'type' => Controls_Manager::SELECT,
	                'default' => '',
	                'options' => [
	                    'recent'    => esc_html__( 'Recent Post', 'back' ),
	                    'yes'       => esc_html__( 'Selected Post', 'back' ),
	                    ''        => esc_html__( 'Category Post', 'back' ),
	                ],
	            ]
	        ); 

                

        $this->add_control(
            'category',
            [
                'label'   => esc_html__( 'Category', 'back' ),
                'type'    => Controls_Manager::SELECT2, 
                'default' => 0,         
                'options' => $this->getCategories(), 
                'multiple' => true, 
                'condition' => [ 'pre_blog_posts_is_manual_selection' => '' ],      
            ]
        );

        $this->add_control(
            'select_posts',
            [
                'label'   => esc_html__( 'Select Posts', 'back' ),
                'type'    => Controls_Manager::SELECT2, 
                'default' => 0,         
                'options' => [      
                        
                ]+ $post_dropdown,
                'multiple' => true, 
                'condition' => [ 'pre_blog_posts_is_manual_selection' => 'yes' ],      
            ]
        );

        $this->add_control(
            'pre_posts_most_view',
            [
                'label'   => esc_html__( 'Most View', 'back' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''                          => esc_html__( 'Default', 'back' ),
                    'post_views'  => esc_html__( 'Most View', 'back' ),
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'pre_posts_order_by',
            [
                'label'   => esc_html__( 'Order by', 'back' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'date'          => esc_html__( 'Date', 'back' ),
                    'title'         => esc_html__( 'Title', 'back' ),
                    'author'        => esc_html__( 'Author', 'back' ),
                    'modified'      => esc_html__( 'Modified', 'back' ),
                    'meta_value_num' => esc_html__( 'Meta Value Number', 'back' ),
                    'comment_count' => esc_html__( 'Comments', 'back' ),
                ],
                'default' => 'date',
            ]
        );

        $this->add_control(
            'pre_posts_sort',
            [
                'label'   => esc_html__( 'Order', 'back' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'ASC'  => esc_html__( 'ASC', 'back' ),
                    'DESC' => esc_html__( 'DESC', 'back' ),
                ],
                'default' => 'DESC',
            ]
        );

	
		$this->add_control(
			'blog_columns',
			[
				'label'   => esc_html__( 'Columns', 'back' ),
				'type'    => Controls_Manager::SELECT,	
                'default' => 4,			
				'options' => [
					'6' => esc_html__( '2 Column', 'back' ),
					'4' => esc_html__( '3 Column', 'back' ),
					'3' => esc_html__( '4 Column', 'back' ),
					'2' => esc_html__( '6 Column', 'back' ),
					'12' => esc_html__( '1 Column', 'back' ),					
				],		
			]
		);
        $this->add_control(
            'blog_columns_md',
            [
                'label'   => esc_html__( 'Columns Media', 'back' ),
                'type'    => Controls_Manager::SELECT,  
                'default' => 12,            
                'options' => [
                    '6' => esc_html__( '2 Column', 'back' ),
                    '4' => esc_html__( '3 Column', 'back' ),
                    '3' => esc_html__( '4 Column', 'back' ),
                    '2' => esc_html__( '6 Column', 'back' ),
                    '12' => esc_html__( '1 Column', 'back' ),                 
                ],      
            ]
        );      
          
        $this->add_control(
            'blog_item_offset',
            [
                'label' => esc_html__( 'Offset', 'back' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( '0', 'back' ),
            ]
        );

		$this->add_control(
			'per_page',
			[
				'label' => esc_html__( 'Item Limit', 'back' ),
				'type' => Controls_Manager::NUMBER,
                'dynamic' => [ 'active' => true ],
				'default' => esc_html__( '6', 'back' ),
                'condition' => [ 'pre_blog_posts_is_manual_selection!' => 'yes' ], 
			]
		);

        $this->end_controls_section();


        //Thumbnail Settings Here
        $this->start_controls_section(
            '_images_settings',
            [
                'label' => esc_html__( 'Thumbnail Settings', 'back' ),
            ]
        );  

        $this->add_control(
            'blog_image_show_hide',
            [
                'label' => esc_html__( 'Show Thumbnail', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        ); 

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ],
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ],
            ]
        );  

        $this->add_responsive_control(
            'thumbnail_width',
            [
                'label' => esc_html__( 'Width', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap' => 'flex: 0 0 {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ], 
            ]
        ); 

        $this->add_responsive_control(
            'thumbnail_height',
            [
                'label' => esc_html__( 'Height', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1400,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .blog-inner-wrap .back-image-wrap img' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ], 
            ]
        ); 

        $this->add_control(
            'blog_thumbnail',
            [
                'label' => esc_html__( 'Thumbnail Position', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Default', 'back' ),
                    'left' => esc_html__( 'Left', 'back' ),
                    'right' => esc_html__( 'Right', 'back' ),
                ],
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ],             
            ]
        );

        $this->add_control(
            'content_alignment',
            [
                'label' => esc_html__( 'Content Alignments', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'top',
                'options' => [
                    'top' => esc_html__( 'Top', 'back' ),
                    'back__center' => esc_html__( 'Center', 'back' ),
                ],
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ],             
            ]
        );

        $this->end_controls_section();


        //Title Settings Here
        $this->start_controls_section(
            '_title_settings',
            [
                'label' => esc_html__( 'Title Settings', 'back' ),
            ]
        ); 

        $this->add_control(
            'blog_title_show_hide',
            [
                'label' => esc_html__( 'Title', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        ); 

        $this->add_control(
            'blog_title_word_show',
            [
                'label' => esc_html__( 'Word Limit', 'back' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( '200', 'back' ),
                'condition' => [
                    'blog_title_show_hide' => 'yes',
                ]
            ]
        );  

        $this->end_controls_section();


        //Meta Settings Here
        $this->start_controls_section(
            '_meta_settings',
            [
                'label' => esc_html__( 'Meta Settings', 'back' ),
            ]
        );	

        $this->add_control(
            'blog_meta_show_hide',
            [
                'label' => esc_html__( 'Show Meta', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        );	


		$this->add_control(
            'blog_cat_show_hide',
            [
                'label' => esc_html__( 'Show Category', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]                
            ]
        );		

        $this->add_control(
            'author_meta',
            [
                'label' => __( 'Author', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'back' ),
                'label_off' => __( 'Hide', 'back' ),
                'default' => 'yes',
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'blog_comments_show_hide',
            [
                'label' => esc_html__( 'Show Comments', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]                
            ]
        ); 

        $this->add_control(
            'blog_avatar_show_hide',
            [
                'label' => esc_html__( 'Show Author Image', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],    
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                    'author_meta' => 'yes',
                ]            
            ]
        );


        $this->add_control(
            'date_meta',
            [
                'label' => __( 'Date', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'back' ),
                'label_off' => __( 'Hide', 'back' ),
                'default' => 'yes',
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'reverse_meta',
            [
                'label' => __( 'Meta Reverse (Horizontal)', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'back' ),
                'label_off' => __( 'Hide', 'back' ),
                'default' => '',
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'reverse_meta_vertical',
            [
                'label' => __( 'Meta Reverse (Vertical)', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'back' ),
                'label_off' => __( 'Hide', 'back' ),
                'default' => '',
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ]
            ]
        ); 

        $this->add_control(
            'blog_meta_alignment',
            [
                'label' => esc_html__( 'Meta Alignment', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'inlines',
                'options' => [
                    'inlines' => esc_html__( 'Inline', 'back' ),
                    'blocks' => esc_html__( 'Block', 'back' ),
                ], 
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ],            
            ]
        );

        $this->add_control(
            'blog_meta_style',
            [
                'label' => esc_html__( 'Meta Position', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => esc_html__( 'Default', 'back' ),
                    'style2' => esc_html__( 'Top', 'back' ),
                ], 
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ],            
            ]
        );

        $this->add_control(
            'blog_cate_style',
            [
                'label' => esc_html__( 'Category Position', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'style2',
                'options' => [
                    'style1' => esc_html__( 'Default', 'back' ),
                    'style2' => esc_html__( 'Bottom', 'back' ),
                ], 
                'condition' => [
                    'blog_cat_show_hide' => 'yes',
                ],            
            ]
        );

        $this->add_control(
            'blog_category_style',
            [
                'label' => esc_html__( 'Category Layout', 'back' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Default', 'back' ),
                    'background' => esc_html__( 'Background', 'back' ),
                    'borders' => esc_html__( 'Border', 'back' ),
                ],             
            ]
        );

        $this->end_controls_section();


        //Content Settings Here
        $this->start_controls_section(
            '_content_settings',
            [
                'label' => esc_html__( 'Content Settings', 'back' ),
            ]
        );  

		$this->add_control(
            'blog_content_show_hide',
            [
                'label' => esc_html__( 'Show Content', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        );

		$this->add_control(
			'blog_word_show',
			[
				'label' => esc_html__( 'Content Limit', 'back' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( '20', 'back' ),
				'separator' => 'before',
				'condition' => [
                    'blog_content_show_hide' => 'yes',
                ]
			]
		);

        $this->end_controls_section();


        //Button Settings Here
        $this->start_controls_section(
            '_button_settings',
            [
                'label' => esc_html__( 'Button Settings', 'back' ),
            ]
        );

		$this->add_control(
            'blog_readmore_show_hide',
            [
                'label' => esc_html__( 'Show', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        );


        $this->add_control(
            'blog_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'back' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Read More',
                'placeholder' => esc_html__( 'Button Text', 'back' ),
                'condition' => [
                    'blog_readmore_show_hide' => 'yes',
                ]
            ]
        );

		$this->add_control(
		    'blog_btn_icon_position',
		    [
		        'label' => esc_html__( 'Icon Position', 'back' ),
		        'type' => Controls_Manager::CHOOSE,
		        'label_block' => false,
		        'options' => [
		            'before' => [
		                'title' => esc_html__( 'Before', 'back' ),
		                'icon' => 'eicon-h-align-left',
		            ],
		            'after' => [
		                'title' => esc_html__( 'After', 'back' ),
		                'icon' => 'eicon-h-align-right',
		            ],
		        ],
		        'default' => 'after',
		        'toggle' => false,
		    ]
		); 

		$this->add_control(
		    'blog_btn_icon_spacing',
		    [
		        'label' => esc_html__( 'Icon Spacing', 'back' ),
		        'type' => Controls_Manager::SLIDER,
		        'default' => [
		            'size' => 10
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn.icon-before i' => 'margin-right: {{SIZE}}{{UNIT}};',
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn.icon-after i' => 'margin-left: {{SIZE}}{{UNIT}};',
		        ],
		    ]
		);

        $this->end_controls_section();


        //Video Settings Here
        $this->start_controls_section(
            '_video_settings',
            [
                'label' => esc_html__( 'Video Settings', 'back' ),
            ]
        );

        $this->add_control(
            'video_icon',
            [
                'label' => __( 'Video Icon', 'back' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'reguler',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'video_bg',
                'label' => esc_html__( 'Background Color', 'back' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a i:before, {{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a'
            ]
        );

        $this->add_control(
            'video_icon_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a i:before' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_video_width',
            [
                'label' => esc_html__( 'Width', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 30,
                        'max' => 200,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a i:before, {{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a' => 'width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',                                     
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_video_size',
            [
                'label' => esc_html__( 'Icon Size', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a i:before' => 'font-size: {{SIZE}}{{UNIT}};',                                     
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_video_size_svg',
            [
                'label' => esc_html__( 'Icon Size Svg', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a svg' => 'height: {{SIZE}}{{UNIT}};',                                     
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_video_position_left',
            [
                'label' => esc_html__( 'Position (Left/Right)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a' => 'left: {{SIZE}}{{UNIT}};',                   
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_video_position_top',
            [
                'label' => esc_html__( 'Position (Top/Bottom)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .video__post a' => 'top: {{SIZE}}{{UNIT}};',                   
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_pagination_settings',
            [
                'label' => esc_html__( 'Pagination Settings', 'back' ),
            ]
        );

        $this->add_control(
            'blog_pagination_show_hide',
            [
                'label' => esc_html__( 'Show Pagination', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        );
				
		$this->end_controls_section();


        $this->start_controls_section(
            '_scroll_settings',
            [
                'label' => esc_html__( 'Scroll Settings', 'back' ),
            ]
        );

        $this->add_control(
            'blog_scroll_show_hide',
            [
                'label' => esc_html__( 'Show Scroll', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        );

        $this->add_responsive_control(
            'scroll_height',
            [
                'label'      => esc_html__( 'Scroll Height', 'back' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1400,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .prelements-blog-list.back__scroll__yes' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_scroll_show_hide' => 'yes',
                ],
            ]
        );
                
        $this->end_controls_section();

        //Default Style Here
		$this->start_controls_section(
			'section_slider_style',
			[
				'label' => esc_html__( 'Default Style', 'back' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'back' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .back-blog-grid .back-blog-item, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-image-wrap::before',
                
            ]
        );

        $this->add_responsive_control(
            'bg_height',
            [
                'label' => esc_html__( 'Overlay Background Height', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .blog-inner-wrap .back-image-wrap:before' => 'height: {{SIZE}}{{UNIT}};',                   
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .back-blog-grid .back-blog-item',
            ]
        );
        

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => esc_html__( 'Item Shadow', 'back' ),
                'selector' => '{{WRAPPER}} .back-blog-grid .back-blog-item',
            ]
        );	

        $this->add_responsive_control(
            'blog_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        ); 

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'back' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'back' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'back' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'back' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justify', 'back' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content' => 'text-align: {{VALUE}}'
                ],
            ]
        );  

        $this->add_control(
            'text_hover_color',
            [
                'label' => esc_html__( 'Hover Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item:hover .back-blog-content .back-blog-meta' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-blog-grid .back-blog-item:hover .back-blog-content h3.back-post-title a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-blog-grid .back-blog-item:hover .back-blog-content p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-blog-grid .back-blog-item:hover .back-blog-content .blog-btn-part .blog-btn' => 'color: {{VALUE}};',

                ],               
            ]
        ); 

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_hover',
                'label' => esc_html__( 'Background Hover', 'back' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .back-blog-grid .back-blog-item:hover, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-image-wrap:hover',
                
            ]
        );    
	    
        $this->add_responsive_control(
            'item_padding_contents',
            [
                'label' => esc_html__( 'Content Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Category Style Here
        $this->start_controls_section(
            'section_category_style',
            [
                'label' => esc_html__( 'Category Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_cat_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'blog_cat_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list a, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-cat-list a' => 'background: {{VALUE}};',
                ],               
            ]
        );

        $this->add_control(
            'blog_cat_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list a, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-cat-list a' => 'color: {{VALUE}};',

                ],               
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cate_typography',
                'label' => esc_html__( 'Typography', 'back' ),
                'selector' => 
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list a, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-cat-list a',
            ]
        );

        $this->add_responsive_control(
            'cats_padding',
            [
                'label' => esc_html__( 'Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list a, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-cat-list a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cats_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list a, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-cat-list a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_cat_position_left',
            [
                'label' => esc_html__( 'Position (Left/Right)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list' => 'left: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_cate_style' => 'style1',
                ]
            ]
        );

        $this->add_responsive_control(
            'blog_cat_position_top',
            [
                'label' => esc_html__( 'Position (Top/Bottom)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-cat-list' => 'top: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_cate_style' => 'style1',
                ]
            ]
        );

        $this->end_controls_section();

        //Thumbnail Style Here
        $this->start_controls_section(
            'section_image_style',
            [
                'label' => esc_html__( 'Thumbnail Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'blog_image_show_grayscale',
            [
                'label' => esc_html__( 'Show Grayscale at Hover', 'back' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => esc_html__( 'Show', 'back' ),
                    'label_off' => esc_html__( 'Hide', 'back' ),
                ],                
            ]
        ); 

        $this->add_responsive_control(
            'img_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap img, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-image-wrap:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_padding',
            [
                'label' => esc_html__( 'Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Meta Style Here
        $this->start_controls_section(
            'section_meta_style',
            [
                'label' => esc_html__( 'Meta Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_meta_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'blog_meta_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-item .back-blog-meta i' => 'color: {{VALUE}};',
                ],                
            ]
        );        

        $this->add_control(
            'blog_meta_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-item .back-blog-meta' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-blog-item .back-blog-meta a' => 'color: {{VALUE}};',
                ],                
            ]
        );

        $this->add_control(
            'blog_meta_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-blog-meta, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta' => 'background: {{VALUE}};',
                ], 
                'condition' => [
                    'blog_meta_style' => ['style2', 'style1'],
                ]               
            ]
        );

        $this->add_responsive_control(
            'dates_padding',
            [
                'label' => esc_html__( 'Meta Padding', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item.back-blog-meta-style2 .back-image-wrap .back-blog-meta, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_meta_style' => ['style2', 'style1'],
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_meta_border_radius',
            [
                'label' => esc_html__( 'Meta Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-blog-meta, {{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_meta_style' => ['style2', 'style1'],
                ],
            ]
        );

        $this->add_responsive_control(
            'blog4_date_position',
            [
                'label' => esc_html__( 'Date Position (Left/Right)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-blog-meta' => 'left: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_meta_style' => 'style2',
                ]  
            ]
        );
        $this->add_responsive_control(
            'blog_top_date_position',
            [
                'label' => esc_html__( 'Date Position (Top/Bottom)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-image-wrap .back-blog-meta' => 'bottom: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_meta_style' => 'style2',
                ]  
            ]
        );        

        $this->add_responsive_control(
            'blog_top_date_rotate',
            [
                'label' => esc_html__( 'Rotate', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 360,
                    ],
                ],
                
                'selectors' => [
                '{{WRAPPER}} .back-blog-grid .back-blog-item.back-blog-meta-style2 .back-image-wrap .back-blog-meta' => 'transform: rotate({{SIZE}}deg);',
                ],
                'condition' => [
                    'blog_meta_style' => 'style2',
                ]  
            ]
        );

        $this->add_responsive_control(
            'icons_margin',
            [
                'label' => esc_html__( 'Icon Margin', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => esc_html__( 'Typography', 'back' ),
                'selector' => 
                    '{{WRAPPER}} .back-blog-grid .back-blog-meta',
            ]
        );

        $this->add_responsive_control(
            'author_image_width',
            [
                'label' => esc_html__( 'Author Image Width', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-avatar-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_avatar_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'blog_author_image_position_left',
            [
                'label' => esc_html__( 'Author Image Position (Left/Right)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-avatar-image img' => 'left: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_avatar_show_hide' => 'yes',
                ]
            ]
        );

        $this->add_responsive_control(
            'blog_author_position_top',
            [
                'label' => esc_html__( 'Author Image Position (Top/Bottom)', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-avatar-image img' => 'top: {{SIZE}}{{UNIT}};',                   
                ],
                'condition' => [
                    'blog_avatar_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'media_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-avatar-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_avatar_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => esc_html__( 'Meta Margin', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-blog-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        //Title Style Here
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_title_show_hide' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content h3.back-post-title a' => 'color: {{VALUE}};',

                ],                
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__( 'Hover Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content h3.back-post-title a:hover, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-blog-content .back-post-title a:hover' => 'color: {{VALUE}};',
                ],                
            ]
        );

        $this->add_control(
            'title_color_hover_line',
            [
                'label' => esc_html__( 'Line hover color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content h3.back-post-title a:hover, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-blog-content .back-post-title a:hover' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 100%);',
                ],                
            ]            
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'back' ),
				'selector' => 
                    '{{WRAPPER}} .back-blog-item .back-blog-content h3.back-post-title a, {{WRAPPER}} .back-blog-item .back-blog-content h3.back-post-title, {{WRAPPER}} .back-blog-item .back-blog-content .back-post-title',
			]
		);

        $this->add_responsive_control(
            'titles_margin',
            [
                'label' => esc_html__( 'Margin', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content .back-post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        //Content Style Here
        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__( 'Content Style', 'back' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Color', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-item .back-blog-content p.back-content' => 'color: {{VALUE}};',

                ], 
                'condition' => [
                    'blog_content_show_hide' => 'yes',
                ],               
            ]
        );

        $this->add_control(
            'content_color_bg',
            [
                'label' => esc_html__( 'Background', 'back' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .back-blog-item .back-blog-content' => 'background: {{VALUE}};',

                ],               
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => esc_html__( 'Typography', 'back' ),
                'condition' => [
                    'blog_content_show_hide' => 'yes',
                ],
                'selector' => 
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content p.back-content',

            ]
        );

        $this->add_responsive_control(
		    'blog_content_padding',
		    [
		        'label' => esc_html__( 'Padding', 'back' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 30,
                ],  
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],

		    ]
		);

        $this->add_responsive_control(
            'content_margin',
            [
                'label' => esc_html__( 'Margin', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_space',
            [
                'label' => esc_html__( 'Content Spacing', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-blog-grid .back-blog-item .back-blog-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__( 'Content Width', 'back' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .blog-inner-wrap .back-blog-content' => 'width: {{SIZE}}{{UNIT}};',                   
                ],
            ]
        );

        $this->add_control(
            'blog_content_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-inner-wrap .back-blog-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_shadow',
                'label' => esc_html__( 'Item Shadow', 'back' ),
                'selector' => '{{WRAPPER}} .blog-inner-wrap .back-blog-content',
            ]
        );  

		$this->end_controls_section();


		//Read More Style Here
		$this->start_controls_section(
		    '_section_style_button',
		    [
		        'label' => esc_html__( 'Button Style', 'back' ),
		        'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_readmore_show_hide' => 'yes',
                ],
		    ]
		);

		$this->add_responsive_control(
		    'blog_btn_link_padding',
		    [
		        'label' => esc_html__( 'Padding', 'back' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);

		$this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
		        'name' => 'btn_typography',
		        'selector' => '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn',
		    ]
		);

		$this->add_control(
		    'blog_btn_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'back' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);

		$this->add_group_control(
		    Group_Control_Box_Shadow::get_type(),
		    [
		        'name' => 'blog_btn_box_shadow',
		        'selector' => '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn',
		    ]
		);

		$this->add_control(
		    'hr',
		    [
		        'type' => Controls_Manager::DIVIDER,
		        'style' => 'thick',
		    ]
		);

		$this->start_controls_tabs( '_tabs_button' );

		$this->start_controls_tab(
		    '_blog_btn_normal',
		    [
		        'label' => esc_html__( 'Normal', 'back' ),
		    ]
		);

		$this->add_control(
		    'link_color',
		    [
		        'label' => esc_html__( 'Text Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '',
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-blog-content .blog-btn-part .blog-btn' => 'color: {{VALUE}};',
		        ],
		    ]
		);

		$this->add_control(
		    'blog_btn_bg_color',
		    [
		        'label' => esc_html__( 'Background Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn' => 'background-color: {{VALUE}};',
		        ],
		    ]
		);

		$this->end_controls_tab();


		$this->start_controls_tab(
		    '_blog_btn_button_hover',
		    [
		        'label' => esc_html__( 'Hover', 'back' ),
		    ]
		);

		$this->add_control(
		    'blog_btn_hover_color',
		    [
		        'label' => esc_html__( 'Text Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'selectors' => [
                    '{{WRAPPER}} .back-blog-item .back-blog-content:hover .blog-btn, {{WRAPPER}} .back-blog-grid .back-blog-item.transparent .blog-inner-wrap .back-blog-content .blog-btn-part .blog-btn:hover, {{WRAPPER}} .back-blog-item .back-blog-content:focus .blog-btn ' => 'color: {{VALUE}};',
                ],
		    ]
		);

		$this->add_control(
		    'blog_btn_hover_bg_color',
		    [
		        'label' => esc_html__( 'Background Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content:hover .blog-btn' => 'background-color: {{VALUE}};',
		        ],
		    ]
		);

		$this->add_control(
		    'blog_btn_hover_border_color',
		    [
		        'label' => esc_html__( 'Border Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'condition' => [
		            'button_border_border!' => '',
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-item .back-blog-content .blog-btn:hover, {{WRAPPER}} .back-blog-item .back-blog-content .blog-btn:focus' => 'border-color: {{VALUE}};',
		        ],
		    ]
		);

		$this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();



		// Start Blog Pagination Style
		$this->start_controls_section(
		    '_blog_pagination_style',
		    [
		        'label' => esc_html__( 'Pagination Style', 'back' ),
		        'tab' => Controls_Manager::TAB_STYLE,
		        'condition' => [
                    'blog_pagination_show_hide' => 'yes',
                ]
		    ]
		);

		$this->add_control(
		    'blog_pagi_color',
		    [
		        'label' => esc_html__( 'Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '',
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links a' => 'color: {{VALUE}};',
		        ],		        
		    ]
		);

		$this->add_control(
		    'blog_pagi_hover_color',
		    [
		        'label' => esc_html__( 'Hover Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '',
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links a:hover' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links span.current' => 'color: {{VALUE}};',
		        ],		        
		    ]
		);

		$this->add_control(
		    'blog_pagi_divider_color',
		    [
		        'label' => esc_html__( 'Divider Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '',
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links a' => 'border-color: {{VALUE}};',
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links span.current' => 'border-color: {{VALUE}};',
		        ],		        
		    ]
		);

		$this->add_control(
		    'blog_pagiesc_html__bg_color',
		    [
		        'label' => esc_html__( 'Background Color', 'back' ),
		        'type' => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links' => 'background-color: {{VALUE}};',
		        ],		        
		    ]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_pagi_shadow',
				'label' => esc_html__( 'Box Shadow', 'back' ),
				'selector' => '{{WRAPPER}} .back-blog-grid .back-pagination-area .nav-links',	
			]
		);

        $this->add_responsive_control(
            'pagination_align',
            [
                'label' => esc_html__( 'Alignment', 'back' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'back' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'back' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'back' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justify', 'back' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .back-pagination-area' => 'text-align: {{VALUE}}'
                ],
            ]
        ); 
        
        $this->add_responsive_control(
            'pagination_margin',
            [
                'label' => esc_html__( 'Margin', 'back' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .back-pagination-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
		$this->end_controls_section();

		// End Blog Pagination Style

	}

	/**
	 * Render Blog Grid widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display(); 
        $grayscale = $settings['blog_image_show_grayscale'];
        $no_grayscale = !empty($grayscale) ? 'grayscale' : 'no-grayscale'?>
			<div class="back-blog-grid blog-grid <?php echo esc_attr( $no_grayscale);?> back__scroll__<?php echo esc_html($settings['blog_scroll_show_hide']);?>">
				<div class="row">
				 	<?php                        

				        $cat = $settings['category'];
                        $select = $settings['select_posts'];
                        if ( 'yes' === $settings['blog_pagination_show_hide'] ){ 
							global  $paged;
                            if (is_front_page()) {
                                $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                            } else {
                                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                            }
							if(empty($cat)){
					        	$back_query = new wp_Query(array(
				        			'post_type'      => 'post',
                                    'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
									'posts_per_page' => $settings['per_page'],
                                    'meta_key'          => $settings['pre_posts_most_view'],
									'paged'          => $paged,
									'post__in' => $select,	
                                    'offset' => $settings['blog_item_offset'],
                                    'meta_query' => array(
                                        array(
                                            'key'     => 'editor_post',        
                                            'compare' => 'NOT EXISTS'
                                        ),
                                    ),				
								));	  
					        }   
					        else{
					        	$back_query = new wp_Query(array(
					        			'post_type'      => 'post',
                                        'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
										'posts_per_page' => $settings['per_page'],
                                        'meta_key'          => $settings['pre_posts_most_view'],
										'paged'          => $paged,
										'post__in' => $select,
                                        'offset' => $settings['blog_item_offset'],
                                        'meta_query' => array(
                                            array(
                                                'key'     => 'editor_post',        
                                                'compare' => 'NOT EXISTS'
                                            ),
                                        ),
										'tax_query'      => array(
									        array(
												'taxonomy' => 'category',
												'field'    => 'slug', 
												'terms'    => $cat 
									        ),
									    )
								));	  
					        }
					    }

					    else{

						    if(empty($cat)){
					        	$back_query = new wp_Query(array(
					        		'post_type'      => 'post',
                                    'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
									'posts_per_page' => $settings['per_page'],	
                                    'meta_key'          => $settings['pre_posts_most_view'],
                                    'post__in' => $select,
                                    'offset' => $settings['blog_item_offset'],
                                    'meta_query' => array(
                                        array(
                                            'key'     => 'editor_post',        
                                            'compare' => 'NOT EXISTS'
                                        ),
                                    ),			
								));	  
					        }   
					        else{
					        	$back_query = new wp_Query(array(
					        			'post_type'      => 'post',
                                        'orderby'           => array( $settings['pre_posts_order_by'] => $settings['pre_posts_sort'] ),
										'posts_per_page' => $settings['per_page'],
                                        'meta_key'          => $settings['pre_posts_most_view'],
                                        'post__in' => $select,
                                        'offset' => $settings['blog_item_offset'],
                                        'meta_query' => array(
                                            array(
                                                'key'     => 'editor_post',        
                                                'compare' => 'NOT EXISTS'
                                            ),
                                        ),
										'tax_query'      => array(
									        array(
												'taxonomy' => 'category',
												'field'    => 'slug', 
												'terms'    => $cat 
									        ),
									    )
								));	  
					        }
					    }
				        
						while($back_query->have_posts()): $back_query->the_post(); 

							$full_date      = get_the_date('F j, Y');
							$blog_date      = get_the_date('M j, Y');	
							$post_admin     = get_the_author();

							
							if(!empty($settings['blog_word_show'])){
								$limit = $settings['blog_word_show'];
							}
							else{
								$limit = 20;
							}

	                        
	                        if(!empty($settings['blog_title_word_show'])){
	                            $limits = $settings['blog_title_word_show'];
	                        }
	                        else{
	                            $limits = 200;
	                        }

						?>
						
						<div class="col-lg-<?php echo esc_html($settings['blog_columns']);?> col-md-<?php echo esc_html($settings['blog_columns_md']);?>">
							<div class="back-blog-item <?php echo esc_html($settings['blog_content_postion_style']);?> back-blog-meta-<?php echo esc_html($settings['blog_meta_style']);?> <?php echo esc_html($settings['blog_category_style']);?>">
								<div class="blog-inner-wrap back-thum-<?php echo esc_html($settings['blog_thumbnail']);?> back-meta-<?php echo esc_html($settings['blog_meta_alignment']);?> <?php echo esc_html($settings['content_alignment']);?>">
									<div class="back-image-wrap">
                                        <?php if ( 'yes' === $settings['blog_image_show_hide'] ){ ?>
    										<a class="back-pointer-events" href="<?php the_permalink();?>">
    											<?php  the_post_thumbnail($settings['thumbnail_size']);?>
    										</a>
                                        <?php } ?>

                                        <?php include plugin_dir_path(__FILE__)."/post-format.php"; ?>  

                                        <?php if ( 'yes' === $settings['blog_meta_show_hide'] ){ ?>
                                        <?php if ( 'yes' === $settings['date_meta'] ){ ?>
										<?php if(($settings['blog_meta_style'] == 'style2') ){ ?>
											<div class="back-blog-meta">
												<?php if(!empty($blog_date)){ ?>
													<span class="back-date"><?php echo esc_html($blog_date);?></span>
												<?php } ?>
											</div>
										<?php } } } ?>											
										
                                        <?php if ( 'yes' === $settings['blog_cat_show_hide'] ){ ?>
                                            <?php if(($settings['blog_cate_style'] == 'style1') ){ ?>
                                                <div class="back-cat-list">
                                                    <?php include plugin_dir_path(__FILE__)."/categorys.php"; ?>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
									</div>	

									<div class="back-blog-content">
                                    <!-- If Reverse Meta Vertical -->

                                    <?php if ( 'yes' === $settings['reverse_meta_vertical'] ){ ?>

                                        <?php if ( 'yes' === $settings['blog_cat_show_hide'] ){ ?>
                                            <?php if(($settings['blog_cate_style'] == 'style2') ){ ?>
                                                <div class="back-cat-list">
                                                    <?php include plugin_dir_path(__FILE__)."/categorys.php"; ?>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>

                                        <?php if ( 'yes' === $settings['blog_title_show_hide'] ){ ?>
                                            <h3 class="back-post-title"><a class="back-pointer-events" href="<?php the_permalink();?>"><?php echo wp_trim_words( get_the_title(), $limits, '' ); ?></a></h3>                                        
                                        <?php } ?>

                                        <?php if ( 'yes' === $settings['blog_meta_show_hide'] ){ ?>
                                            <?php if(($settings['blog_meta_style'] == 'style1') ){ ?>
                                                <?php if ( 'yes' === $settings['reverse_meta'] ){ ?>
                                                    <div class="back-blog-meta back-reverse-meta">                                                      
                                                        <?php if ( 'yes' === $settings['author_meta'] ){ ?>
                                                            <?php if(!empty($post_admin)){ ?>
                                                                <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                                                                <span class="back-admin">
                                                                    <?php if ( 'yes' === $settings['blog_avatar_show_hide'] ){ ?>
                                                                    
                                                                        <em class="back-avatar-image"><?php echo get_avatar(get_the_author_meta( 'ID' ), 30);?></em>
                                                                    
                                                                    <?php } else {?>
                                                                        <i class="ri-user-3-line"></i> 
                                                                    <?php } ?>
                                                                <?php echo esc_html($post_admin);?></span>
                                                            </a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                        <?php if ( 'yes' === $settings['date_meta'] ){ ?>
                                                            <?php if(!empty($full_date)){ ?>
                                                                <span class="back-date">
                                                                    <i class="ri-calendar-line"></i> 
                                                                    <?php echo esc_html($full_date);?></span>
                                                            <?php } ?>
                                                        <?php } ?>
                                                        <?php if ( 'yes' === $settings['blog_comments_show_hide'] ){ ?>
                                                            <span class="back-date back-comments">
                                                                <i class="ri-chat-4-line"></i> <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                                <?php 
                                                                    $com = get_comments_number(); 
                                                                    if ( $com == 1 ) {
                                                                        esc_html_e('Comment', 'neoton');
                                                                    } else {
                                                                        esc_html_e('Comments', 'neoton');
                                                                    }
                                                                ?>
                                                            </span>
                                                        <?php } ?>
                                                    </div>
                                                <?php } else { ?>
                                                    <div class="back-blog-meta">
                                                        <?php if ( 'yes' === $settings['date_meta'] ){ ?>
                                                            <?php if(!empty($full_date)){ ?>
                                                                <span class="back-date">
                                                                    <i class="ri-calendar-line"></i>  
                                                                    <?php echo esc_html($full_date);?></span>
                                                            <?php } ?>
                                                        <?php } ?>

                                                        <?php if ( 'yes' === $settings['blog_comments_show_hide'] ){ ?>
                                                            <span class="back-date back-comments">
                                                                <i class="ri-chat-4-line"></i> <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                                <?php 
                                                                    $com = get_comments_number(); 
                                                                    if ( $com == 1 ) {
                                                                        esc_html_e('Comment', 'neoton');
                                                                    } else {
                                                                        esc_html_e('Comments', 'neoton');
                                                                    }
                                                                ?>
                                                            </span>
                                                        <?php } ?>

                                                        <?php if ( 'yes' === $settings['author_meta'] ){ ?>
                                                            <?php if(!empty($post_admin)){ ?>
                                                                <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                                                                    <span class="back-admin">
                                                                        <?php if ( 'yes' === $settings['blog_avatar_show_hide'] ){ ?>
                                                                        
                                                                            <em class="back-avatar-image"><?php echo get_avatar(get_the_author_meta( 'ID' ), 30);?></em>
                                                                        
                                                                        <?php } else { ?>
                                                                            <i class="ri-user-3-line"></i>
                                                                        <?php } ?>
                                                                    <?php echo esc_html($post_admin);?></span>
                                                                </a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </div>
                                                <?php } ?>
                                        <?php } } ?> 

                                    

                                    <?php } else { ?>

                                        <?php if ( 'yes' === $settings['blog_meta_show_hide'] ){ ?>
                                            <?php if(($settings['blog_meta_style'] == 'style1') ){ ?>
                                                <?php if ( 'yes' === $settings['reverse_meta'] ){ ?>
                                                    <div class="back-blog-meta back-reverse-meta">                                                      
                                                        <?php if ( 'yes' === $settings['author_meta'] ){ ?>
                                                            <?php if(!empty($post_admin)){ ?>
                                                                <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                                                                    <span class="back-admin">
                                                                        <?php if ( 'yes' === $settings['blog_avatar_show_hide'] ){ ?>
                                                                        
                                                                            <em class="back-avatar-image"><?php echo get_avatar(get_the_author_meta( 'ID' ), 30);?></em>
                                                                        
                                                                        <?php } else { ?>
                                                                            <i class="ri-user-3-line"></i> 
                                                                        <?php } ?>
                                                                    <?php echo esc_html($post_admin);?></span>
                                                                </a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                        <?php if ( 'yes' === $settings['date_meta'] ){ ?>
                                                            <?php if(!empty($full_date)){ ?>
                                                                <span class="back-date">
                                                                    <i class="ri-calendar-line"></i> 
                                                                    <?php echo esc_html($full_date);?></span>
                                                            <?php } ?>
                                                        <?php } ?>

                                                        <?php if ( 'yes' === $settings['blog_comments_show_hide'] ){ ?>
                                                            <span class="back-date back-comments">
                                                                <i class="ri-chat-4-line"></i> <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                                <?php 
                                                                    $com = get_comments_number(); 
                                                                    if ( $com == 1 ) {
                                                                        esc_html_e('Comment', 'neoton');
                                                                    } else {
                                                                        esc_html_e('Comments', 'neoton');
                                                                    }
                                                                ?>
                                                            </span>
                                                        <?php } ?>
                                                    </div>
                                                <?php } else { ?>
                                                    <div class="back-blog-meta">
                                                        <?php if ( 'yes' === $settings['date_meta'] ){ ?>
                                                            <?php if(!empty($full_date)){ ?>
                                                                <span class="back-date">
                                                                    <i class="ri-calendar-line"></i>  
                                                                    <?php echo esc_html($full_date);?></span>
                                                            <?php } ?>
                                                        <?php } ?>

                                                        <?php if ( 'yes' === $settings['blog_comments_show_hide'] ){ ?>
                                                            <span class="back-date back-comments">
                                                                <i class="ri-chat-4-line"></i> <?php echo get_comments_number( '0', '1', '%' ); ?>
                                                                <?php 
                                                                    $com = get_comments_number(); 
                                                                    if ( $com == 1 ) {
                                                                        esc_html_e('Comment', 'neoton');
                                                                    } else {
                                                                        esc_html_e('Comments', 'neoton');
                                                                    }
                                                                ?>
                                                            </span>
                                                        <?php } ?>

                                                        <?php if ( 'yes' === $settings['author_meta'] ){ ?>
                                                            <?php if(!empty($post_admin)){ ?>
                                                                <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                                                                    <span class="back-admin">
                                                                        <?php if ( 'yes' === $settings['blog_avatar_show_hide'] ){ ?>
                                                                        
                                                                            <em class="back-avatar-image"><?php echo get_avatar(get_the_author_meta( 'ID' ), 30);?></em>
                                                                        
                                                                        <?php } else { ?>
                                                                            <i class="ri-user-3-line"></i>
                                                                        <?php } ?>
                                                                    <?php echo esc_html($post_admin);?></span>
                                                                </a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </div>
                                                <?php } ?>
                                        <?php } } ?>
                                                                                
                                        <?php if ( 'yes' === $settings['blog_title_show_hide'] ){ ?>
                                            <h3 class="back-post-title"><a class="back-pointer-events" href="<?php the_permalink();?>"><?php echo wp_trim_words( get_the_title(), $limits, '' ); ?></a></h3>                                        
                                        <?php } ?>

                                    <?php } ?>

                                    <!-- End if Reverse Meta Vertical -->

                                       

                                        <?php if ( 'yes' === $settings['blog_content_show_hide'] ){ ?>
    								  		<p class="back-content"><?php echo wp_trim_words( get_the_content(), $limit, '...' ); ?></p>
    									<?php } ?>

    									
                                        <?php if ( 'yes' === $settings['blog_readmore_show_hide'] ){ ?>

                                            <?php if(!empty($settings['blog_btn_text'])){ ?>
                                                <div class="blog-btn-part">
                                                    <?php  
                                                        $icon_position = $settings['blog_btn_icon_position'] == 'before' ? 'icon-before' : 'icon-after';
                                                    ?>
                                                        <a class="blog-btn <?php echo esc_attr($icon_position) ?>" href="<?php the_permalink(); ?>">
                                                            <span class="btn-txt"><?php echo esc_html($settings['blog_btn_text']);?></span>
                                                            <?php if(!empty($settings['blog_btn_text'])) : ?>
                                                                <i class="ri-arrow-right-line"></i> 
                                                            <?php endif; ?>
                                                        </a>

                                                </div>
                                            <?php } else { ?>
                                                <div class="blog-btn-part">
                                                    <?php  
                                                        $icon_position = $settings['blog_btn_icon_position'] == 'before' ? 'icon-before' : 'icon-after';
                                                    ?>
                                                        <a class="blog-btn <?php echo esc_attr($icon_position) ?>" href="<?php the_permalink(); ?>">
                                                            <span class="btn-txt"><?php echo esc_html($settings['blog_btn_text']);?></span>
                                                            <?php if(!empty($settings['blog_btn_text'])) : ?>
                                                                <i class="ri-arrow-right-line"></i> 
                                                            <?php endif; ?>
                                                        </a>

                                                </div>
                                          <?php  } }  ?>

									</div>
						  		</div>
					  		</div>
						</div>
						<?php
						endwhile;

						wp_reset_query();  ?>

                    <?php //} ?>
				</div>

				<?php 
					$paginate = paginate_links( array(
					    'total' => $back_query->max_num_pages
					));

					if(!empty($paginate ) && ( 'yes' === $settings['blog_pagination_show_hide'])){ ?>
						<div class="back-pagination-area"><div class="nav-links"><?php echo wp_kses_post($paginate); ?></div></div>
				<?php } ?>

			</div>
		<?php
	}
    public function getCategories(){
        $cat_list = [];
            if ( post_type_exists( 'post' ) ) { 
            $terms = get_terms( array(
                'taxonomy'    => 'category',
                'hide_empty'  => true            
            ) );
            
            foreach($terms as $post) {
                $cat_list[$post->slug]  = [$post->name];
            }
        }  
        return $cat_list;
    }
}