<?php
/**
 * Products Widget Template
 *
 * @package pls
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! is_a( $product, 'WC_Product' ) ) {
	return;
}
?>

<div class="product-widget-inner">
	<div class="product-widget-image">
		<div class="pls-product-labels">
			<?php pls_wc_product_widget_sale_label(); ?>
		</div>
		<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
			<?php echo pls_get_post_thumbnail( 'woocommerce_gallery_thumbnail' ); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</a>
	</div>
	<div class="product-widget-content">
		<a class="product-title" href="<?php echo esc_url( $product->get_permalink() ); ?>">
			<?php echo wp_kses_post( $product->get_name() ); ?>
		</a>
		<div class="product-widget-price-cart-btn">
			<div class="product-widget-price-rating">
				<?php if ( pls_get_loop_prop( 'show_rating' ) ) : ?>
					<?php woocommerce_template_loop_rating(); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				<?php endif; ?>
				<span class="price">
					<?php echo wp_kses_post( $product->get_price_html() ); // PHPCS:Ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
				</span>
			</div>
			<?php if ( pls_get_loop_prop( 'show_cart_button' ) ) : ?>
				<div class="product-widget-cart-btn">
					<?php pls_wc_product_loop_cart_button(); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>