<?php
if (!class_exists('PLS_Woocommerce_Variation_Gallery')) {

	class PLS_Woocommerce_Variation_Gallery{
		public $prefix = PLS_PREFIX;
		function __construct() {			
			add_action( 'woocommerce_product_after_variable_attributes',[ $this, 'add_galery_html' ], 10, 3 );
			add_action( 'woocommerce_save_product_variation', [ $this, 'save_additional_variation_images' ],10, 2 );
			add_filter( 'woocommerce_available_variation', [ $this,'update_available_variations' ], 99, 3);
			add_action( 'wp_ajax_pls_get_variation_gallery',[ $this, 'pls_get_variation_gallery' ] );
			add_action( 'wp_ajax_nopriv_pls_get_variation_gallery',[ $this, 'pls_get_variation_gallery' ] );
		}
		public function pls_get_variation_gallery(){
			
			$product_id 	= $_POST['variation_id'];
			$product_id 	= $_POST['product_id'];
			$gallery_images = $_POST['gallery_images'];
			
			$gallery_images = array_map('absint', $gallery_images);
			
			$response	= [
				'thumnail_html'	=> $this->pls_wc_get_gallery_html($gallery_images, false),
				'gallery_html'	=> $this->pls_wc_get_gallery_html($gallery_images, true ) 
			];
			
			wp_send_json_success($response );
			die();
			
		}
		public function pls_wc_get_gallery_html( $gallery_image_ids, $main_image = true ){
			$gallery_output = '';
			
			foreach ( $gallery_image_ids as $gallery_image_id ) {
				$gallery_output .= $this->pls_wc_get_gallery_image_html( $gallery_image_id, $main_image );
			}
			return $gallery_output;
		}
		
		public function pls_wc_get_gallery_image_html( $attachment_id, $main_image = false ){
			$flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', false );
			$gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
			$thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
			$image_size        = apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size );
			$full_size         = apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
			$thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
			if( empty( $thumbnail_src ) ){
				return;			
			}
			$full_src          = wp_get_attachment_image_src( $attachment_id, $full_size );
			$alt_text          = trim( wp_strip_all_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) ) );
			if( $main_image ){
				$image  = wp_get_attachment_image(
					$attachment_id,
					$image_size,
					false,
					apply_filters(
						'woocommerce_gallery_image_html_attachment_image_params',
						array(
							'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
							'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
							'data-src'                => esc_url( $full_src[0] ),
							'data-large_image'        => esc_url( $full_src[0] ),
							'data-large_image_width'  => esc_attr( $full_src[1] ),
							'data-large_image_height' => esc_attr( $full_src[2] ),
							'class'                   => esc_attr( $main_image ? 'wp-post-image' : '' ),
						),
						$attachment_id,
						$image_size,
						$main_image
					)
				);
				return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" data-thumb-alt="' . esc_attr( $alt_text ) . '" class="woocommerce-product-gallery__image">' . $image . '</div>';
			}else{
				return '<div class="woocommerce-product-gallery__thumbnail">'.wp_get_attachment_image( $attachment_id, $image_size ).'</div>';
			}
		}
	
		public function add_galery_html( $loop, $variation_data, $variation ) {
			$meta_key = PLS_PREFIX.'variation_gallery_images';
			$variation_id   = absint( $variation->ID );
			$gallery_images = get_post_meta( $variation_id, $meta_key, true );
			
			?>
			<div class="pls-variation-gallery-wrapper">				
				<div class="pls-variation-gallery-content">
					<div class="pls-variation-gallery-header">
						<h2><?php esc_html_e( 'Variation Product Gallery', 'modave' ) ?></h2>
					</div>
					<div class="pls-variation-gallery-images-wrp">	
						<?php
						if ( is_array( $gallery_images ) && ! empty( $gallery_images ) ) {
							foreach( $gallery_images as $id ){
								
								$attachment_url = wp_get_attachment_thumb_url( $id );
								if(empty($attachment_url)){
									continue;
								}
							?>
								<div class="pls-image-wrp">
									<img class="pls-img" src="<?php echo esc_url( $attachment_url ); ?>" alt="" />
									<input type="hidden" class="pls-attachment-id" name="pls_variation_gallery_images[<?php echo esc_attr( $variation_id ); ?>][]" value="<?php echo esc_attr($id); ?>" />
									<span class="pls-remove-img" title="<?php echo esc_attr__('Remove Image', 'modave'); ?>">X</span>
								</div>
							<?php
							}
						}
						?>
					</div>
				</div>
				<a href="#" class="pls-gallery-image-upload-btn button" data-variation_id="<?php echo esc_attr($variation_id); ?>"><?php echo esc_html__( 'Add Gallery Images', 'modave' ); ?></a>
			</div>
			<?php
		}
		
		public function save_additional_variation_images( $variation_id , $loop ){
			$meta_key = PLS_PREFIX.'variation_gallery_images';	
			if ( isset( $_POST['pls_variation_gallery_images'] ) ) {
				if ( isset( $_POST['pls_variation_gallery_images'][ $variation_id ] ) && !empty( $_POST['pls_variation_gallery_images'][ $variation_id ] ) ) {
					$image_ids = (array) array_map( 'absint', $_POST['pls_variation_gallery_images'][ $variation_id ] );
					$image_ids = array_values( array_unique( $image_ids ) );
					update_post_meta( $variation_id, $meta_key, $image_ids );
				} else {
					delete_post_meta( $variation_id, $meta_key );
				}
			} else {
				delete_post_meta( $variation_id, $meta_key);
			}			
		}
		
		public function update_available_variations( $available_variation, $variationProductObject, $variation ){
			$meta_key = PLS_PREFIX.'variation_gallery_images';
			
			$available_variation['pls_variation_gallery_images'] 	= array();
			$available_variation['pls_has_variation_gallery_images'] 	= false;
			$available_variation['pls_default_gallery_images'] 		= array();
			
			$product_id                   = absint( $variation->get_parent_id() );
			$variation_id                 = absint( $variation->get_id() );
			$variation_image_id           = absint( $variation->get_image_id() );
		
			$is_variation_images 	= (bool)get_post_meta( $variation_id, $meta_key, true );
			if( $is_variation_images ){
				$available_variation['pls_has_variation_gallery_images'] = true;
				$variation_images 	= (array)get_post_meta( $variation_id, $meta_key, true );				
			}else{
				$variation_images 	= $variationProductObject->get_gallery_image_ids();
			}
			if ( $variation_image_id ) {
				array_unshift( $variation_images, $variation_image_id );
			}else {
				$parent_product          = wc_get_product( $product_id );
				$parent_product_image_id = $parent_product->get_image_id();

				if ( ! empty( $parent_product_image_id ) ) {
					array_unshift( $variation_images, $parent_product_image_id );
				}
			}
			
			if($available_variation['pls_has_variation_gallery_images']){
				foreach($variation_images as $i => $variation_image){
					$available_variation['pls_variation_gallery_images'][$i] = $variation_image;
				}
			}
			return $available_variation;
		}
	}
	function pls_woocommerce_varation_gallery_init(){
		$obj_pls_variation_gallery = new PLS_Woocommerce_Variation_Gallery();
	}
	add_action( 'init', 'pls_woocommerce_varation_gallery_init');
	
}