<?php
//Adds a box to the main column on the Page edit screens
function mc_theme_add_custom_box() 
{
	add_meta_box( 
        "page-custom-options",
        __("Options", 'medicenter'),
        "mc_theme_inner_custom_box",
        "page",
		"normal",
		"high"
    );
	add_meta_box( 
        "options",
        __("Options", 'medicenter'),
        "mc_theme_inner_custom_box_post",
        "post",
		"normal",
		"high"
    );	
}
add_action("add_meta_boxes", "mc_theme_add_custom_box");

// Prints the box content
function mc_theme_inner_custom_box($post)
{
	global $themename;
	//Use nonce for verification
	wp_nonce_field(plugin_basename( __FILE__ ), $themename . "_noncename");
}

// Prints the box content post
function mc_theme_inner_custom_box_post($post)
{
	global $themename;
	//Use nonce for verification
	wp_nonce_field(plugin_basename( __FILE__ ), $themename . "_noncename");

	//The actual fields for data entry
	$attachment_ids = get_post_meta($post->ID, $themename. "_attachment_ids", true);
	$images = get_post_meta($post->ID, $themename. "_images", true);
	$images_titles = get_post_meta($post->ID, $themename. "_images_titles", true);
	$videos = get_post_meta($post->ID, $themename. "_videos", true);
	$iframes = get_post_meta($post->ID, $themename. "_iframes", true);
	$external_urls = get_post_meta($post->ID, $themename. "_external_urls", true);
	$features_images_loop = get_post_meta($post->ID, $themename. "_features_images_loop", true);
	$show_images_in = get_post_meta($post->ID, $themename. "_show_images_in", true);
	$hover_icons = get_post_meta($post->ID, $themename. "_hover_icons", true);
	echo '
	<table>
		<tbody>
			<tr valign="top">
				<th colspan="2" scope="row" style="font-weight: bold;">
					' . __('Additional featured images', 'medicenter') . '
				</th>
			</tr>';
			$images_count = count(array_values(array_filter((array)$images)));
			if($images_count==0)
				$images_count = 3;
			for($i=0; $i<$images_count; $i++)
			{
			echo '
			<tr class="image_url_row">
				<td>
					<label>' . __('Image url', 'medicenter') . " " . ($i+1) . '</label>
				</td>
				<td>
					<input type="hidden" name="attachment_ids[]" id="medicenter_attachment_id_' . absint(($i+1)) . '" value="' . (!empty($attachment_ids[$i]) ? esc_attr($attachment_ids[$i]) : '') . '" />
					<input class="regular-text" type="text" id="medicenter_image_url_' . absint(($i+1)) . '" name="images[]" value="' . (!empty($images[$i]) ? esc_attr($images[$i]) : '') . '" />
					<input type="button" class="button" name="medicenter_upload_button" id="medicenter_image_url_button_' . absint(($i+1)) . '" value="' . esc_attr__('Browse', 'medicenter') . '" />
				</td>
			</tr>
			<tr class="image_title_row">
				<td>
					<label>' . __('Image description', 'medicenter') . " " . ($i+1) . '</label>
				</td>
				<td>
					<input class="regular-text" type="text" id="medicenter_image_title_' . absint(($i+1)) . '" name="images_titles[]" value="' . (!empty($images_titles[$i]) ? esc_attr($images_titles[$i]) : '') . '" />
				</td>
			</tr>
			<tr class="video_row">
				<td>
					<label>' . __('Video url', 'medicenter') . " " . ($i+1) . '</label>
				</td>
				<td>
					<input class="regular-text" type="text" id="medicenter_video_' . absint(($i+1)) . '" name="videos[]" value="' . (!empty($videos[$i]) ? esc_attr($videos[$i]) : '') . '" />
				</td>
			</tr>
			<tr class="iframe_row">
				<td>
					<label>' . __('Iframe url', 'medicenter') . " " . ($i+1) . '</label>
				</td>
				<td>
					<input class="regular-text" type="text" id="medicenter_iframe_' . absint(($i+1)) . '" name="iframes[]" value="' . (!empty($iframes[$i]) ? esc_attr($iframes[$i]) : '') . '" />
				</td>
			</tr>
			<tr class="external_url_row">
				<td>
					<label>' . __('External url', 'medicenter') . " " . ($i+1) . '</label>
				</td>
				<td>
					<input class="regular-text" type="text" id="medicenter_external_url_' . absint(($i+1)) . '" name="external_urls[]" value="' . (!empty($external_urls[$i]) ? esc_attr($external_urls[$i]) : '') . '" />
				</td>
			</tr>';
			}
			echo '
			<tr>
				<td></td>
				<td>
					<input type="button" class="button" name="medicenter_add_new_button" id="medicenter_add_new_button_image" value="' . esc_attr__('Add image', 'medicenter') . '" />
				</td>
			</tr>
			<tr>
				<td>
					<label for="features_images_loop">' . __('Features images lightbox loop', 'medicenter') . ':</label>
				</td>
				<td>
					<select id="features_images_loop" name="features_images_loop">
						<option value="yes"' . ($features_images_loop=="yes" ? ' selected="selected"' : '') . '>' . __('yes', 'medicenter') . '</option>
						<option value="no"' . ($features_images_loop=="no" ? ' selected="selected"' : '') . '>' . __('no', 'medicenter') . '</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>
					' . __('Show featured images lightbox', 'medicenter') . '
				</td>
				<td>
					<select id="show_images_in" name="show_images_in">
						<option value="post"' . ($show_images_in=="post" ? ' selected="selected"' : '') . '>' . __('in single post', 'medicenter') . '</option>
						<option value="blog"' . ($show_images_in=="blog" ? ' selected="selected"' : '') . '>' . __('on post list', 'medicenter') . '</option>
						<option value="both"' . ($show_images_in=="both" ? ' selected="selected"' : '') . '>' . __('both', 'medicenter') . '</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>
					' . __('Show hover icons on the images', 'medicenter') . '
				</td>
				<td>
					<select id="hover_icons" name="hover_icons">
						<option value="yes"' . ($hover_icons=="yes" ? ' selected="selected"' : '') . '>' . __('yes', 'medicenter') . '</option>
						<option value="no"' . ($hover_icons=="no" ? ' selected="selected"' : '') . '>' . __('no', 'medicenter') . '</option>
					</select>
				</td>
			</tr>
		</tbody>
	</table>
	';
}

//When the post is saved, saves our custom data
function mc_theme_save_postdata($post_id) 
{
	global $themename;
	// verify if this is an auto save routine. 
	// If it is our form has not been submitted, so we dont want to do anything
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) 
		return;
	//verify this came from the our screen and with proper authorization,
	//because save_post can be triggered at other times
	if (!isset($_POST[$themename . '_noncename']) || !wp_verify_nonce($_POST[$themename . '_noncename'], plugin_basename( __FILE__ )))
		return;

	// Check permissions
	if(!current_user_can('edit_post', $post_id))
		return;
	//OK, we're authenticated: we need to find and save the data	
	if(isset($_POST["attachment_ids"]))
		update_post_meta($post_id, $themename . "_attachment_ids", array_filter((array)$_POST["attachment_ids"]));
	if(isset($_POST["images"]))
	{
		$images = (array)$_POST["images"];
		while(end($images)==="")
			array_pop($images);
		update_post_meta($post_id, $themename . "_images", $images);
	}
	if(isset($_POST["images_titles"]))
		update_post_meta($post_id, $themename . "_images_titles", array_filter((array)$_POST["images_titles"]));
	if(isset($_POST["videos"]))
		update_post_meta($post_id, $themename . "_videos", array_filter((array)$_POST["videos"]));
	if(isset($_POST["iframes"]))
		update_post_meta($post_id, $themename . "_iframes", array_filter((array)$_POST["iframes"]));
	if(isset($_POST["external_urls"]))
		update_post_meta($post_id, $themename . "_external_urls", array_filter((array)$_POST["external_urls"]));
	if(isset($_POST["features_images_loop"]))
		update_post_meta($post_id, $themename . "_features_images_loop", $_POST["features_images_loop"]);
	if(isset($_POST["show_images_in"]))
		update_post_meta($post_id, $themename . "_show_images_in", $_POST["show_images_in"]);
	if(isset($_POST["hover_icons"]))
		update_post_meta($post_id, $themename . "_hover_icons", $_POST["hover_icons"]);
	if(isset($_POST["page_sidebar_header"]))
		update_post_meta($post_id, "page_sidebar_header", $_POST["page_sidebar_header"]);
	if(isset($_POST["page_sidebar_top"]))
		update_post_meta($post_id, "page_sidebar_top", $_POST["page_sidebar_top"]);
	if(isset($_POST["page_sidebar_right"]))
		update_post_meta($post_id, "page_sidebar_right", $_POST["page_sidebar_right"]);
	if(isset($_POST["page_sidebar_footer_top"]))
		update_post_meta($post_id, "page_sidebar_footer_top", $_POST["page_sidebar_footer_top"]);
	if(isset($_POST["page_sidebar_footer_bottom"]))
		update_post_meta($post_id, "page_sidebar_footer_bottom", $_POST["page_sidebar_footer_bottom"]);
	update_post_meta($post_id, $themename . "_page_sidebars", array_values(array_filter(array(
		(!empty($_POST["page_sidebar_header"]) ? $_POST["page_sidebar_header"] : NULL),
		(!empty($_POST["page_sidebar_top"]) ? $_POST["page_sidebar_top"] : NULL),
		(!empty($_POST["page_sidebar_right"]) ? $_POST["page_sidebar_right"] : NULL),
		(!empty($_POST["page_sidebar_footer_top"]) ? $_POST["page_sidebar_footer_top"] : NULL),
		(!empty($_POST["page_sidebar_footer_bottom"]) ? $_POST["page_sidebar_footer_bottom"] : NULL)
	))));
	if(isset($_POST["main_slider"]))
		update_post_meta($post_id, "main_slider", $_POST["main_slider"]);
	if(did_action('elementor/loaded') && class_exists("Elementor\Core\Settings\Manager"))
	{
		$page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers('page');

		// Retrieve the settings model for the current page
		$page_settings_model = $page_settings_manager->get_model($post_id);

		// Retrieve data from a custom control
		$page_settings_model->set_settings('main_slider', (isset($_POST["main_slider"]) ? $_POST["main_slider"] : ''));
		$page_settings_model->set_settings('page_sidebar_header', (isset($_POST["page_sidebar_header"]) ? $_POST["page_sidebar_header"] : ''));
		$page_settings_model->set_settings('page_sidebar_top', (isset($_POST["page_sidebar_top"]) ? $_POST["page_sidebar_top"] : ''));
		$page_settings_model->set_settings('page_sidebar_footer_top', (isset($_POST["page_sidebar_footer_top"]) ? $_POST["page_sidebar_footer_top"] : ''));
		$page_settings_model->set_settings('page_sidebar_footer_bottom', (isset($_POST["page_sidebar_footer_bottom"]) ? $_POST["page_sidebar_footer_bottom"] : ''));
		for($i=1; $i<=5; $i++)
		{
			$page_settings_model->set_settings('image_url' . $i, ["id" => (isset($_POST["attachment_ids"][$i-1]) ? $_POST["attachment_ids"][$i-1] : ''), "url" => (isset($images[$i-1]) ? $images[$i-1] : '')]);
			$page_settings_model->set_settings('image_title' . $i, (isset($_POST["images_titles"][$i-1]) ? $_POST["images_titles"][$i-1] : ''));
			$page_settings_model->set_settings('video' . $i, (isset($_POST["videos"][$i-1]) ? $_POST["videos"][$i-1] : ''));
			$page_settings_model->set_settings('iframe' . $i, (isset($_POST["iframes"][$i-1]) ? $_POST["iframes"][$i-1] : ''));
			$page_settings_model->set_settings('external_url' . $i, (isset($_POST["external_urls"][$i-1]) ? $_POST["external_urls"][$i-1] : ''));
		}
		$page_settings_model->set_settings('features_images_loop', (isset($_POST["features_images_loop"]) ? $_POST["features_images_loop"] : ''));
		$page_settings_model->set_settings('show_images_in', (isset($_POST["show_images_in"]) ? $_POST["show_images_in"] : ''));
		$page_settings_model->set_settings('hover_icons', (isset($_POST["hover_icons"]) ? $_POST["hover_icons"] : ''));
		$page_settings_manager->save_settings($page_settings_model->get_settings(), $post_id);
	}
}
add_action("save_post", "mc_theme_save_postdata");
?>